<?php

require_once("html_parts.inc");
require_once("connexion_base_individuelle.inc");

$connexion = connexion();

if ($connexion) {
	$accueil_connexion = 'Connecté à la base <strong style="color:blue">' . pg_dbname($connexion) .
          '</strong> située sur le serveur <strong style="color:blue">' .  pg_host($connexion) . "</strong>.<br/>\n";
} else {
	print pg_last_error($connexion);
	exit;
}

pg_close($connexion);


html_header ('Accueil', 'css/objet.css'); ?>
<h1>Licence</h1>
<div class="notes">
<p>ATTENTION : le code de cette application est sous copyright et il
appartient à son auteur, Francesco Beretta, ainsi qu'au CNRS. Toute
copie, reproduction, diffusion, utilisation en ligne, vente, location,
etc. sous quelque forme que ce soit de l'ensemble ou d'une partie du
code est interdite.</p>
<p>Ce code est destiné à une <strong>utilisation strictement personnelle</strong>
sur un serveur local protégé par un parefeu. De plus, l'auteur du code
décline toute reponsabilité concernant les dommages qui pourraient
survenir de son utilisation, même à titre strictement personnel.</p>
<p>La <strong>simple utilisation</strong> de cette application <strong>implique
l'acceptation de ces principes</strong>.</p>
</div>


<div>
<h1>Objets</h1>
<p><a href="objet/objet_liste.php">Recherche / Liste des quinze derniers objets
insérés</a></p>
<p><a href="objet/objet_formulaire_insert.php">Créer un nouvel objet</a></p>
<p><a href="objet/objet_type_sous_type_liste.php">Types / sous-types
d'objets</a></p>
<br />
</div>
<div>
<h1>Unités de connaissance</h1>
</div>
<p><a href="unite_connaissance/unite_connaissance_liste.php">Unités de
connaissances</a></p>
<p><a href="type_unite_connaissance/types_uc_liste.php">Types d'unités
de connaissances</a></p>
<br />
</div>
<div>
<h1>Paramètres de la connexion</h1>
<p><?php echo $accueil_connexion;?></p>
<p><?php if ($maj_bhp == 'activée') {
	        $connexion_bhp = connexion_bhp(); 
	        if($connexion_bhp)
	        	echo 'Connexion à la <strong>BHP online</strong> activée. '; 
	        else echo 'Connexion avec la BHP impossible!';
         }
         else echo 'Connexion avec la BHP désactivée.'?></p>
<p><?php 
if(!empty($zotero_original)) {
	echo 'Connexion à la <strong>base locale Zotero</strong> activée.';
	$zotero_copie = '../zotero_copie.sqlite';
	echo '<form action="accueil.php" method="post">
				<input type="hidden" name="effectuer" value="maj_zotero_copie"/>
				<input type="submit" value="Mettre à jour Zotero"/></p>
				</form>';
	if (isset($_REQUEST['effectuer']) and $_REQUEST['effectuer'] == 'maj_zotero_copie') {
		/* ATTENTION : avec ce if on teste immédiatement le résultat de la copie,
		 * la fonction copy(), qui effectue la copie, renvoyant immédiatement TRUE
		 * si la copie est effectuée correctement */
		if(!copy($zotero_original,$zotero_copie)) echo 'Problème avec la copie du fichier !';
	}
}

?></p>
<p><br />
</p>
</div>
<?php if($maj_types == 'activée') echo '<div>
<h1>Mise-à-jour des types d\'information</h1>
<p><strong>ATTENTION : une connexion internet active est indispensable !</strong> 
<br/>Vérifiez si vous pouvez afficher la <a href="http://symogih.org/" target="_blank">page d\'accueil du projet SyMoGIH</a>.</p> 

<form action="mise_a_jour_types_uc_types_roles.php" method="post">
				<input type="submit" value="Mettre à jour types d\'UC / types de rôles"/></p>
				</form>
				<p><strong>Note pour les administrateurs</strong>: la mise à jour de la BHP s\'effectue automatiquement si la connexion à la BHP est activée.
				<br/> Sinon, exécuter préalablement "SELECT tables_types.maj_tables_types_uc();" sur le 243</p></div>' ;



?>
</body>
</html>
