<?php

require_once("../connexion_base_individuelle.inc");
require_once("../html_parts.inc");
require_once("../preparation_insert_update.inc");
require_once("../fonctions.inc");

	

//ouvre la connection avec la fonction externe et récupère la variable
$connexion = connexion();




if (isset($_REQUEST['cleObjet'])) $cle_objet = $_REQUEST['cleObjet']; else $cle_objet = '';


/* *  Cette requête permet d'afficher la fiche de l'acteur
 * ou de l'objet correspondant dans la base individuelle locale
 * */
if (isset($_REQUEST['cleObjetBHP_TEI'])) $cle_objet_bhp_TEI = $_REQUEST['cleObjetBHP_TEI']; else $cle_objet_bhp_TEI = '';
if (strlen($cle_objet_bhp_TEI) > 4) {
	$requete = "SELECT pk_objet
				FROM tables_objet.objet
				WHERE cle_objet_bhp = '".$cle_objet_bhp_TEI."' LIMIT 1";

	// effectuer la requête
	$resultat = pg_query($connexion, $requete) or die('Echec de la requête : ' . pg_last_error());

	// récupérer le résultat dans une variable
	if ($resultat) {
		$resultats = pg_fetch_assoc($resultat);
		$cle_objet = $resultats['pk_objet'];
	}



	// Libérer le résultat
	pg_free_result($resultat);

}


/* ce traitment s'applique lorsqu'un INSERT est appelé depuis le formulaire :
 ce script fait alors fonction de formulaire de saisie  */

if (isset($_REQUEST['effectuer']) and $_REQUEST['effectuer'] == 'insert') {

	// Prépare la variable par défaut du sexe = masculin
	if ($form_typeObjet == 7) $valeur_sexe = ', 86' ; else $valeur_sexe = ', NULL' ;



	if (isset($form_nom) and strlen($form_nom)< 1 and empty($form_cleObjetBHP)) {
		html_header ('Attention', '../css/objet.css');
		echo '<p>Attention : un nouvel objet requiert un nom, vous l\'avez omis : prière d\'insérer un nom</p>
		<p><form action="objet_formulaire_insert.php"  method="post" >
		<input type="submit" value="OK" /></form></p></body></html>';
		exit;
	}

	elseif (isset($form_nom) and strlen($form_nom)< 1 and !empty($form_cleObjetBHP)) {

		//ouvre la connection avec la fonction externe et récupère la variable
		$connexion_bhp = connexion_bhp();

		// Récupérer le nom standard sur le 243 avec la fonction de la BHP
		$requete = "SELECT bhp.get_standard_name('".$cle_objet_bhp."') ";

		// effectuer la requête
		$resultat = pg_query($connexion_bhp, $requete) or die('Echec de la requête : ' . pg_last_error());

		if ($resultat) {
			$liste_resultats = pg_fetch_assoc($resultat);
			$nom_standard_bhp = $liste_resultats['get_standard_name'];
		}
		else {
			html_header ('Attention', '../css/objet.css');
			echo '<p>Attention : manque le nom standard de l\'objet. <br/> L\'objet existe-t-il bien dans la BHP ? </p>
			<p><form action="objet_formulaire_insert.php"  method="post" >
			<input type="submit" value="OK" /></form></p></body></html>';
			exit;
		}
		// Libérer le résultat
		pg_free_result($resultat);


		if(empty($nom_standard_bhp)) {
				
			html_header ('Attention', '../css/objet.css');
			echo '<p>Attention : manque le nom standard de l\'objet. <br/> L\'objet existe-t-il bien dans la BHP ? </p>
			<p><form action="objet_formulaire_insert.php"  method="post" >
			<input type="submit" value="OK" /></form></p></body></html>';
			exit;	}

			else {
					
					
					
				$requete = "INSERT INTO tables_objet.objet
			( fk_type_objet".$champs_annee_debut.$champs_mois_debut.$champs_jour_debut.$champs_certitude_dd.
				$champs_annee_fin.$champs_mois_fin.$champs_jour_fin.$champs_certitude_df.
				$champs_descriptif.$champs_notes.$champs_url_objet.$champs_cle_objet_bhp.", sexe)
			VALUES (".$form_typeObjet.$partie_anneeDebut.$partie_moisDebut.$partie_jourDebut.$partie_certitudeDateDebut.
				$partie_anneeFin.$partie_moisFin.$partie_jourFin.
				$partie_certitudeDateFin.$partie_descriptif.$partie_notes.$partie_url_objet.
				$partie_cle_objet_bhp.$valeur_sexe.")";

				$resultat = pg_query($connexion, $requete) or die('Query failed: ' . pg_last_error());

				if (!$resultat) {
					echo "An error occured.\n";
					exit;
				}

				$cmdtuples = pg_affected_rows($resultat);

				// Libérer le résultat
				pg_free_result($resultat);

				$requete = 'SELECT MAX(pk_objet) AS pk_objet
			FROM tables_objet.objet';

				$resultat = pg_query($connexion, $requete) or die('Query failed: ' . pg_last_error());

				if (!$resultat) {
		  	echo "An error occured.\n";
		  	exit;
				}

				while ($row = pg_fetch_object($resultat)) {
					//  echo '<br/>pk du nouvel objet = '. $row->pk_objet;
		  	$cle_objet = $row->pk_objet;
				}

				// Libérer le résultat
				pg_free_result($resultat);


				$requete = "INSERT INTO tables_objet.nom_objet (fk_objet, nom,  si_nom_standard, type_nom)
				VALUES (".$cle_objet.", E'".addslashes($nom_standard_bhp)."', TRUE, 'bhp')";

				$resultat = pg_query($connexion, $requete) or die('Query failed: ' . pg_last_error());

				if (!$resultat) {
					echo "An error occured.\n";
					exit;
				}

				$cmdtuples = pg_affected_rows($resultat);

				// Libérer le résultat
				pg_free_result($resultat);
					

			}
	}

	elseif (isset($form_nom) and strlen($form_nom) > 0 ) {

		$requete = "INSERT INTO tables_objet.objet
		( fk_type_objet".$champs_annee_debut.$champs_mois_debut.$champs_jour_debut.$champs_certitude_dd.
		$champs_annee_fin.$champs_mois_fin.$champs_jour_fin.$champs_certitude_df.
		$champs_descriptif.$champs_notes.$champs_url_objet.$champs_cle_objet_bhp.", sexe)
		VALUES (".$form_typeObjet.$partie_anneeDebut.$partie_moisDebut.$partie_jourDebut.$partie_certitudeDateDebut.
		$partie_anneeFin.$partie_moisFin.$partie_jourFin.
		$partie_certitudeDateFin.$partie_descriptif.$partie_notes.$partie_url_objet.$partie_cle_objet_bhp.$valeur_sexe.")";

		$resultat = pg_query($connexion, $requete) or die('Query failed: ' . pg_last_error());

		if (!$resultat) {
			echo "An error occured.\n";
			exit;
		}

		$cmdtuples = pg_affected_rows($resultat);

		// Libérer le résultat
		pg_free_result($resultat);

		$requete = 'SELECT MAX(pk_objet) AS pk_objet
	FROM tables_objet.objet';

		$resultat = pg_query($connexion, $requete) or die('Query failed: ' . pg_last_error());

		if (!$resultat) {
			echo "An error occured.\n";
			exit;
		}

		while ($row = pg_fetch_object($resultat)) {
			//  echo '<br/>pk du nouvel objet = '. $row->pk_objet;
			$cle_objet = $row->pk_objet;
		}

		// Libérer le résultat
		pg_free_result($resultat);

		if($form_nom =='zot') {
			$type_nom = '\'zotero\'';
			$requete = "UPDATE tables_objet.objet SET cle_jointure_zotero = 'ObPe".$cle_objet."'
					WHERE pk_objet = ".$cle_objet;

			$resultat = pg_query($connexion, $requete) or die('Query failed: ' . pg_last_error());

			if (!$resultat) {
				echo "An error occured.\n";
				exit;
			}

			// Libérer le résultat
			pg_free_result($resultat);
		}
		else {
			$type_nom = 'NULL';
		}

		$requete = "INSERT INTO tables_objet.nom_objet (fk_objet, nom,  si_nom_standard, type_nom)
		VALUES (".$cle_objet.", E'".addslashes($form_nom)."', TRUE, ".$type_nom.")";

		$resultat = pg_query($connexion, $requete) or die('Query failed: ' . pg_last_error());

		if (!$resultat) {
			echo "An error occured.\n";
			exit;
		}

		$cmdtuples = pg_affected_rows($resultat);

		// Libérer le résultat
		pg_free_result($resultat);

	}
}

/* UPDATE
 * Ce traitement s'applique lorsqu'on veut mettre à jour la fiche de l'objet */

elseif (isset($_REQUEST['effectuer']) and $_REQUEST['effectuer'] == 'update') {

	// Récupérer le type d'objet actuel
	$requete = 'SELECT fk_type_objet
					FROM tables_objet.objet
					WHERE pk_objet = '.$cle_objet;

	// effectuer la requête
	$resultat = pg_query($connexion, $requete) or die('Echec de la requête : ' . pg_last_error());

	if ($resultat) {
		$liste_resultats = pg_fetch_assoc($resultat);
		$cle_objet_actuel = $liste_resultats['fk_type_objet'];
	}
	else {
		$liste_noms_standard = 'Erreur : vérifier le script !';
	}
	// Libérer le résultat
	pg_free_result($resultat);



	//Comparer le type d'objet actuel et celui qui vient du formulaire : si ce n'est pas le même, le sous-type d'objet est vidé
	if (isset($form_typeObjet) and isset($cle_objet_actuel) and $form_typeObjet!==$cle_objet_actuel)
	$update_fk_sous_type_objet_new_type = ", fk_sous_type_objet = NULL";
	else $update_fk_sous_type_objet_new_type = $update_fk_sous_type_objet;

	$requete = 'UPDATE tables_objet.objet SET '.
	$update_fk_type_objet.$update_fk_sous_type_objet_new_type.
	$update_anneeDebut.$update_moisDebut.$update_jourDebut.$update_certitudeDateDebut.$update_notesDD.
	$update_anneeFin.$update_moisFin.$update_jourFin.$update_certitudeDateFin.$update_notesDF.
	$update_descriptif.$update_notes.$update_url_objet.$update_cle_objet_bhp.$update_cle_jointure_zotero.
	$update_sexe.$update_longitude.$update_latitude.' WHERE pk_objet ='.$cle_objet;



	// effectuer la requête
	$resultat = pg_query($connexion, $requete) or die('Echec de la requête : ' . pg_last_error());

	// Libérer le résultat
	pg_free_result($resultat);	}



	/* UPDATE OBJET BHP */

	elseif (isset($_REQUEST['effectuer']) and $_REQUEST['effectuer'] == 'maj_objet_bhp') {

		//ouvre la connection avec la fonction externe et récupère la variable
		$connexion_bhp = connexion_bhp();
		
		// Récupérer le nom standard sur le 243 avec la fonction de la BHP
		$requete = "SELECT bhp.get_standard_name('".$cle_objet_bhp."') ";

		// effectuer la requête
		$resultat = pg_query($connexion_bhp, $requete) or die('Echec de la requête : ' . pg_last_error());

		if ($resultat) {
			$liste_resultats = pg_fetch_assoc($resultat);
			$nom_standard_bhp = $liste_resultats['get_standard_name'];
		}
		else {
			$liste_noms_standard = 'Erreur : vérifier le script !';
		}
		// Libérer le résultat
		pg_free_result($resultat);


		if(!empty($nom_standard_bhp)) {
				
				
			// Récupérer le type d'objet actuel
			$requete = "SELECT *
						FROM tables_objet.nom_objet
						WHERE fk_objet = ".$cle_objet.
						"AND   type_nom = 'bhp';";
			// effectuer la requête
			$resultat = pg_query($connexion, $requete) or die('Echec de la requête : ' . pg_last_error());
				
				
			if ($resultat) {
				$liste_resultats = pg_fetch_assoc($resultat);
				$id_nom = $liste_resultats['pk_nom_objet'];
				if (!empty($id_nom)) {
					$requete = "UPDATE tables_objet.nom_objet SET nom = E'".addslashes($nom_standard_bhp)."'
								WHERE fk_objet = ".$cle_objet.
								"AND   type_nom = 'bhp';";
					// effectuer la requête
					$resultat = pg_query($connexion, $requete) or die('Echec de la requête : ' . pg_last_error());
					// Libérer le résultat
					pg_free_result($resultat);
				}
				else {	$requete = "INSERT INTO tables_objet.nom_objet (
								  fk_objet,
								  nom,
								  type_nom,
								  si_nom_standard,
								  notes,
								  creation
									)
								VALUES
								(".$cle_objet.",
								  E'".addslashes($nom_standard_bhp)."',
								  'bhp',
								  FALSE,
								  '".$cle_objet_bhp."',
								  NOW()
								);";
				$resultat = pg_query($connexion, $requete) or die('Echec de la requête : ' . pg_last_error());
				// Libérer le résultat
				pg_free_result($resultat);
				}
			}
			else { echo 'Erreur !';}

			// Libérer le résultat
			//pg_free_result($resultat);

		}
		// test, pas de contrôle pour l'instant, seulement message tout en haut de la page
		else echo 'Manque le nom standard';
	}


	/* Mise à jour de la base SQLITE et du nom ZOTERO*/

	elseif (isset($_REQUEST['effectuer']) and $_REQUEST['effectuer'] == 'copier_zotero_sqlite') {

		if(!empty($zotero_original)) {
			$zotero_copie = '../../zotero_copie.sqlite';
			if(!empty($_REQUEST['cleJointureZotero'])) {
				$cle_jointure_zotero = $_REQUEST['cleJointureZotero'] ;
			} else $cle_jointure_zotero = '';


			/* ATTENTION : avec ce if on teste immédiatement le résultat de la copie,
			 * la fonction copy(), qui effectue la copie, renvoyant immédiatement TRUE
			 * si la copie est effectuée correctement */
			if(!copy($zotero_original,$zotero_copie)) echo 'Problème avec la copie du fichier !';

				

			try {
				$dbh = new PDO('sqlite:../../zotero_copie.sqlite');
				$dbh->setAttribute(PDO::ATTR_ERRMODE, PDO::ERRMODE_EXCEPTION);
			} catch (PDOException $e) {
				echo 'Echec lors de la connexion : ' . $e->getMessage();
			}

				
			try {
				// La fonction "requete_pour_ligne($ligne)", utilisée pour récupérer les données de la base sqlite Zotero
				// est définie dans le document fonctions.inc


				$cle_jointure_zotero = $_REQUEST['cleJointureZotero'];
				$requete_zotero = requete_pour_ligne($cle_jointure_zotero);
				$resultat_zotero = $dbh->query($requete_zotero);
					
				//print_r($resultat);
					
					
					
				$dbh = null;
			}
			catch (PDOException $e) {
				print "Error!: " . $e->getMessage() . "<br/>";
				die();
			}

			//	Analyse le type de variable et le contenu de l'objet (si c'est un objet)
			//	echo 'Variable type : '.gettype($resultat_zotero).'<br/>Object properties : '.get_object_vars($resultat_zotero);
			$tableau_resultat = array();
			foreach( $resultat_zotero as $row) {
					
				// ancienne syntaxe, ne récupère qu'une ligné par clé-valeur
				// $tableau_resultat[$row['t4.fieldName']] = $row['t5.value'];
					
				/*Corrigé qui crée un tableau à deux dimensions (cf. plus bas des explications plus détaillées).
					* La première syntaxe utilise la clé de la requête SQL – la deuxième syntaxe, actuellement utilisée, est plus sûre
					* car elle marche aussi s'il y a des doublons dans les clés
					* $tableau_resultat[$row['t4.fieldName']] [$row['id']] = $row['t5.value'];
					*/
				$tableau_resultat[$row['t4.fieldName']] [] = $row['t5.value'];
			}
				
				
				
			$groupsAuthor = array();
			$groupsEditor = array();
			$groupsTitle = array();
			$listeAuteurs = '';
			$listeEditeurs = '';
			$titre = '';

			// Production des nouveaux tableaux, le premier foreach traite le premier niveau de l'array,
			// le second le deuxième niveau
			foreach($tableau_resultat as $cle => $element) {
				foreach($element as $cle2 => $element2) {
					if($cle =='author') $groupsAuthor[] = $element2;
					if($cle =='editor') $groupsEditor[] = $element2;
					if($cle =='title') $groupsTitle[] = $element2;
						
				}
			}

			//voir le contenu du tableau
			//print_r(array_values($groupsAuthor));
			//sortir le tableau d'après les valeurs
			asort($groupsAuthor); //arsort – reverse sort
			asort($groupsEditor); //arsort – reverse sort
			$listeAuteurs = implode(' / ', $groupsAuthor);
			$listeEditeurs = implode(' / ', $groupsEditor);
			$titre = implode(' / ', $groupsTitle);
				
				
				
			// syntaxe précedente
			// if(array_key_exists('author', $tableau_resultat)) $author_zotero = $tableau_resultat['author']." – "; else $author_zotero = '';
			// if(array_key_exists('editor', $tableau_resultat)) $editor_zotero = " – ".$tableau_resultat['editor']." (éd.) "; else $editor_zotero = '';
				
			if(strlen($listeAuteurs) > 0)  $author_zotero = $listeAuteurs." – "; else $author_zotero = '';
			if(strlen($listeEditeurs) > 0)  $editor_zotero = ", ".$listeEditeurs." (éd.) "; else $editor_zotero = '';
				
				
			$nom_zotero = $author_zotero.$titre.$editor_zotero;
				
			if(!empty($nom_zotero)) {
				$requete = "UPDATE tables_objet.nom_objet SET nom = E'".addslashes($nom_zotero)."'
		    	  			WHERE fk_objet = ".$cle_objet." 
		    	  			AND type_nom = 'zotero'";

				// effectuer la requête
				$resultat = pg_query($connexion, $requete) or die('Echec de la requête : ' . pg_last_error());
				// Libérer le résultat
				pg_free_result($resultat);
			}
				
			//	echo $nom_zotero ;

		}
		else {
			echo "An error occured.\n";
			exit;
		}
	}


	/* Noms standard de l'objet  */

	// cette requête liste le ou les Noms standard de l'objet
	$requete = "SELECT fk_objet,
	array_to_string(ARRAY (SELECT unnest(array_agg(nom)) ORDER BY 1),', ') AS noms_standard_objet
	FROM tables_objet.nom_objet
	WHERE fk_objet = ".$cle_objet.
	"AND   si_nom_standard
	GROUP BY fk_objet";


	// effectuer la requête
	$resultat = pg_query($connexion, $requete) or die('Echec de la requête : ' . pg_last_error());

	// récupérer le résultat dans une variable
	if ($resultat) {
		$liste_resultats = pg_fetch_assoc($resultat);
		$liste_noms_standard = $liste_resultats['noms_standard_objet'];
	}
	else {
		$liste_noms_standard = 'Erreur : manque le nom !';
	}

	// Libérer le résultat
	pg_free_result($resultat);



	/* Tous les noms de l'objet  */

	// Préparer la requête qui cherche tous les noms
	$requete = "SELECT * FROM tables_objet.nom_objet
	WHERE fk_objet = ".$cle_objet." 
	ORDER BY date_debut" ;

	// effectuer la requête
	$resultat = pg_query($connexion, $requete) or die('Echec de la requête : ' . pg_last_error());

	// initialiser le tableau des noms
	$tableau_noms = array() ;

	// Récupérer le résultat et le mettre dans un tableau
	while ($objet_resultat = pg_fetch_object ($resultat)) {

		if ($objet_resultat->si_nom_standard =='t') {$si_nom_standard = 'oui';}
		else {$si_nom_standard = 'non';}

		// On sort le tableau résultant de la requête
		$tableau_noms[] = '<tr><td>'.$objet_resultat->nom.'</td><td>'.$si_nom_standard.'</td><td>'.$objet_resultat->date_debut.'</td><td>'.$objet_resultat->date_fin.'</td><td>'.$objet_resultat->descriptif.
	'</td><td>'.$objet_resultat->code_langue.'</td><td>'.$objet_resultat->type_nom.'</td><td><a href="nom_objet_insert_update.php?cle_nom_objet='.$objet_resultat->pk_nom_objet.'&cleObjet='.$cle_objet.'">'.$objet_resultat->pk_nom_objet.'</a></td></tr>';
	}

	// Libérer le résultat
	pg_free_result($resultat);




	/* Type de l'objet */

	$requete = 'SELECT fk_type_objet
					FROM tables_objet.objet
					WHERE pk_objet = '.$cle_objet;

	// effectuer la requête
	$resultat = pg_query($connexion, $requete) or die('Echec de la requête : ' . pg_last_error());

	if ($resultat) {
		$liste_resultats = pg_fetch_assoc($resultat);
		$cle_type_objet_actuel = $liste_resultats['fk_type_objet'];
	}
	else {
		$liste_noms_standard = 'Erreur : vérifier le script !';
	}
	// Libérer le résultat
	pg_free_result($resultat);




	/* Sexe */

	if ($cle_type_objet_actuel == 7)  {
			
		// préparer la requête qui liste les types de cet objet
		$requete = "SELECT t1.pk_parametre,
			       t1.nom,
			       CASE
			         WHEN t2.pk_objet IS NULL THEN NULL
			         ELSE 'selected'
			       END AS selected
					FROM tables_types.parametre t1 
			  	LEFT JOIN tables_objet.objet t2 ON t2.sexe = t1.pk_parametre AND t2.pk_objet = ".$cle_objet."	
				WHERE t1.type_parametre = 'sexe'
				ORDER BY t1.nom;";


		// effectuer la requête
		$resultat = pg_query($connexion, $requete) or die('Echec de la requête : ' . pg_last_error());
			
		if ($resultat) {
			//préparer le résultat pour l'utilisation dans le formulaire
			$liste_sexe = array();
			while ($types = pg_fetch_object($resultat))
			{
				$liste_sexe[] = '<option '.$types->selected.' value="'.$types->pk_parametre.'">'.$types->nom.'</option>';
			}
		}
		else {
			$liste_noms_standard = 'Erreur : vérifier le script !';
		}

	}
	// Libérer le résultat
	pg_free_result($resultat);



	/* Types de l'objet  */

	// préparer la requête qui liste les types de cet objet
	$requete = "SELECT t1.pk_parametre,
       t1.nom,
       CASE
         WHEN t2.pk_objet IS NULL THEN NULL
         ELSE 'selected'
       END AS selected
		FROM tables_types.parametre t1 
  	LEFT JOIN tables_objet.objet t2 ON t2.fk_type_objet = t1.pk_parametre AND t2.pk_objet = ".$cle_objet."	
	WHERE t1.type_parametre = 'type_objet'
	ORDER BY t1.nom;";

	// effectuer la requête
	$resultat = pg_query($connexion, $requete) or die('Echec de la requête : ' . pg_last_error());

	//préparer le résultat pour l'utilisation dans le formulaire
	$liste_types = array();
	while ($types = pg_fetch_object($resultat))
	{
		$liste_types[] = '<option '.$types->selected.' value="'.$types->pk_parametre.'">'.$types->nom.'</option>';
	}


	// Libérer le résultat
	pg_free_result($resultat);




	/* Sous-types de l'objet  */

	// ATTENTION : le sous-type sera créé après le type
	// préparer la requête qui liste les sous-types de cet objet
	$requete = "SELECT t1.fk_sous_type,
       t2.nom,
       CASE
         WHEN t1.si_standard = 't' THEN 'selected'
         ELSE ''
       END AS sans_sous_type,
       CASE
         WHEN t4.pk_parametre = t1.fk_sous_type THEN 'selected'
         ELSE '  '
       END AS avec_sous_type
FROM tables_types.associer_types_sous_types_objets t1 
  JOIN tables_types.parametre t2 ON t2.pk_parametre = t1.fk_sous_type 
  JOIN tables_objet.objet t3 ON t3.fk_type_objet = t1.fk_type AND t3.pk_objet = ".$cle_objet." /*test sur la présence de la clé fk_sous_type */ 
  LEFT JOIN tables_types.parametre t4 ON t4.pk_parametre = t3.fk_sous_type_objet
ORDER BY t2.nom;";

	// effectuer la requête
	$resultat = pg_query($connexion, $requete) or die('Echec de la requête : ' . pg_last_error());

	//préparer le résultat pour l'utilisation dans le formulaire
	$liste_sous_types = array();
	while ($types = pg_fetch_object($resultat))
	{   if (strlen($types->avec_sous_type)>0) {
		$selected = $types->avec_sous_type; } else {$selected = $types->sans_sous_type; }
		$liste_sous_types[] = '<option '.$selected.
	' value="'.$types->fk_sous_type.'">'.$types->nom.'</option>';
	}


	// Libérer le résultat
	pg_free_result($resultat);




	/* Certitude année début */

	// préparer la requête qui liste les paramètres année début
	$requete = "SELECT t1.pk_parametre,
       t1.nom AS nom,
       CASE
         WHEN t2.pk_objet IS NULL THEN NULL
         ELSE 'selected'
       END AS selected
FROM tables_types.parametre t1 
  LEFT JOIN tables_objet.objet t2 ON t2.certitude_dd = t1.pk_parametre AND t2.pk_objet = ".$cle_objet."
WHERE t1.type_parametre = 'certitude_date_annee'
ORDER BY t1.nom;";

	// effectuer la requête
	$resultat = pg_query($connexion, $requete) or die('Echec de la requête : ' . pg_last_error());

	//préparer le résultat pour l'utilisation dans le formulaire
	$liste_certitude_dd = array();
	while ($lignes = pg_fetch_object($resultat))
	{
		$liste_certitude_dd[] = '<option '.$lignes->selected.' value="'.$lignes->pk_parametre.'">'.$lignes->nom.'</option>';
	}


	// Libérer le résultat
	pg_free_result($resultat);



	/* Certitude année fin */

	// préparer la requête qui liste les paramètres année fin
	$requete = "SELECT t1.pk_parametre,
       t1.nom AS nom,
       CASE
         WHEN t2.pk_objet IS NULL THEN NULL
         ELSE 'selected'
       END AS selected
FROM tables_types.parametre t1 
  LEFT JOIN tables_objet.objet t2 ON t2.certitude_df = t1.pk_parametre AND t2.pk_objet = ".$cle_objet."
WHERE t1.type_parametre = 'certitude_date_annee'
ORDER BY t1.nom;";

	// effectuer la requête
	$resultat = pg_query($connexion, $requete) or die('Echec de la requête : ' . pg_last_error());

	//préparer le résultat pour l'utilisation dans le formulaire
	$liste_certitude_df = array();
	while ($lignes = pg_fetch_object($resultat))
	{
		$liste_certitude_df[] = '<option '.$lignes->selected.' value="'.$lignes->pk_parametre.'">'.$lignes->nom.'</option>';
	}


	// Libérer le résultat
	pg_free_result($resultat);



	/* Propriétés de l'objet */

	// préparer la requête qui cherche les propriétés de l'objet
	$requete = 'SELECT *
FROM tables_objet.objet
WHERE pk_objet = '.$cle_objet;

	// effectuer la requête
	$resultat = pg_query($connexion, $requete) or die('Echec de la requête : ' . pg_last_error());

	// récupérer le résultat dans une variable
	if ($resultat) {
		$champs_de_l_objet = pg_fetch_assoc($resultat);
		$annee_debut = $champs_de_l_objet['annee_debut'];
		$mois_debut = $champs_de_l_objet['mois_debut'];
		$jour_debut = $champs_de_l_objet['jour_debut'];
		$notes_dd = $champs_de_l_objet['notes_dd'];
		$annee_fin = $champs_de_l_objet['annee_fin'];
		$mois_fin = $champs_de_l_objet['mois_fin'];
		$jour_fin = $champs_de_l_objet['jour_fin'];
		$certitude_df = $champs_de_l_objet['certitude_df'];
		$notes_df = $champs_de_l_objet['notes_df'];
		$descriptif = $champs_de_l_objet['descriptif'];
		$notes = $champs_de_l_objet['notes'];
		$url_objet = $champs_de_l_objet['url_objet'];
		$cle_objet_bhp = $champs_de_l_objet['cle_objet_bhp'];
		$cle_jointure_zotero = $champs_de_l_objet['cle_jointure_zotero'];
		$sous_type_objet = $champs_de_l_objet['fk_sous_type_objet'];
		$longitude = $champs_de_l_objet['longitude'] ;
		$latitude = $champs_de_l_objet['latitude'] ;

	}
	else {
		$liste_noms_standard = 'Erreur : manque le nom !';
	}


	if ($sous_type_objet > 0) {$sous_type_non_renseigne = '';
	$option_si_vide = '';}
	else {$sous_type_non_renseigne = ' non renseigné ! Choisir';
	$option_si_vide = '<option selected value=""></option>';}



	// Fermer la connexion
	pg_close($connexion);




	/* Vérifie s'il y a une valeur de jointure avec Zotero
	 * et créé le tableau contenant les valeurs Zotero */

	if(!empty($cle_jointure_zotero)) {

		//$cle_jointure_zotero = $_REQUEST['cleJointureZotero'];

		try {
			$dbh = new PDO('sqlite:../../zotero_copie.sqlite');
			$dbh->setAttribute(PDO::ATTR_ERRMODE, PDO::ERRMODE_EXCEPTION);
		} catch (PDOException $e) {
			echo 'Echec lors de la connexion : ' . $e->getMessage();
		}

			
		try {
			// function requete_pour_ligne($ligne) déclarée ci-dessus

			$requete_zotero = requete_pour_ligne($cle_jointure_zotero);
			$resultat_zotero = $dbh->query($requete_zotero);
				
			//print_r($resultat);
				
			$dbh = null;
		}
		catch (PDOException $e) {
			print "Error!: " . $e->getMessage() . "<br/>";
			die();
		}

		//	Analyse le type de variable et le contenu de l'objet (si c'est un objet)
		//	echo 'Variable type : '.gettype($resultat_zotero).'<br/>Object properties : '.get_object_vars($resultat_zotero);
		$tableau_resultat = array();
		foreach( $resultat_zotero as $row) {

			/* Syntaxe d'origine
			 * $tableau_resultat[$row['t4.fieldName']] = $row['t5.value'];
			 * Mais avec syntaxe on perd des lignes s'il y a deux auteurs, etc.
			 * On pourrait résoudre le problème avec la fonction group_concat de sqlite, mais ma version de pdo_sqlite
			 * ne gère pas cette fonction.
			 * J'ai donc créé un tableau à deux dimensions.
			 */
			/*La première syntaxe utilise la clé de la requête SQL – la deuxième syntaxe, actuellement utilisée, est plus sûre
			 * car elle marche aussi s'il y a des doublons dans les clés
			 * $tableau_resultat[$row['t4.fieldName']] [$row['id']] = $row['t5.value'];
			 */
			$tableau_resultat[$row['t4.fieldName']] [] = $row['t5.value'];
		}
			
	}


	?>




<!-- Commence ici la partie HTML -->

	<?php html_header ('Identification de l\'objet', '../css/objet.css'); ?>


<div class="en_tete_page">
<h1><?php echo $liste_noms_standard.' – <span class="font_smaller">'.$cle_objet.' (ObPe'.$cle_objet.') [Identification] </span>'  ?></h1>
</div>

<div class="renvois">
<p><a
	href="objet_associations.php?cleObjet=<?php echo $cle_objet; ?>&typeAssociation=19">Associations
de l'objet</a> – <a href="objet_formulaire_insert.php" target="_blank">Créer un nouvel
objet</a> – <!-- Ajoute les boutons nécessaires pour bouger entre les fiches 
et pour naviguer dans la base de données --> <?php html_autres_possibilites() ; 
echo ' – ';
html_precedent_suivant('objet', $cle_objet);
?></p>
</div>

<div class="liste_noms">
<h4>Liste des noms</h4>
<table>
	<tr>
		<th>Nom objet</th>
		<th>Standard ?</th>
		<th>Année début</th>
		<th>Année fin</th>
		<th>Descriptif</th>
		<th>Langue</th>
		<th>Type</th>
		<th>Clé</th>
	</tr>
	<?php foreach ($tableau_noms as $ligne_nom) {
		echo $ligne_nom;
	}?>
</table>
<form action="nom_objet_insert_update.php" method="get" target="_blank"><input
	type="hidden" name="si_insert" value="t" /> <input type="hidden"
	name="cleObjet" value="<?php echo $cle_objet; ?>" />
<p><input type="submit" value="Nouveau nom" style="float: right" /></p>
</form>
</div>


<div class="proprietes_objet">
<h4>Propriétés de l'objet</h4>

<form action="objet_insert_update.php" method="post">

<p><input type="submit" value="Mettre à jour" /> – Type d'objet : <select name="typeObjet">
<?php foreach ($liste_types as $type) {
	echo $type;
}?>
</select> – Sous-type d'objet<?php echo $sous_type_non_renseigne; ?> : <select
	name="sousTypeObjet">
	<?php echo $option_si_vide;
	foreach ($liste_sous_types as $sub_type) {
		echo $sub_type;
	}?>
</select> <?php 
switch($cle_type_objet_actuel) {
	case 7 :
		echo ' – Sexe: <select name="sexe">';
		foreach ($liste_sexe as $sexe) {
			echo $sexe;
		}
		echo '</select>';
		break ;
	case 14 :
		echo ' – Longitude: <input type="text" size="7" name="longitude" value="'.$longitude.'" />
			   / Latitude: <input type="text" size="7" name="latitude" value="'.$latitude.'" />';
		break ;

	case 15 :
		echo ' – Longitude: <input type="text" size="7" name="longitude" value="'.$longitude.'" />
			   / Latitude: <input type="text" size="7" name="latitude" value="'.$latitude.'" />';
		break ;


	default:
		echo '';
} ?></p>
<table><tr style="column-width:10%"><th></th><th style="column-width:15%">Année</th>
<th style="column-width:10%">Mois</th><th  style="column-width:10%">Jour</th>
<th  style="column-width:15%">Certitude</th><th style="column-width:40%">Notes</th></tr>
<tr><td>Début:</td><td><input type="text" class="partie_date"
	size="3" name="anneeDebut" value="<?php echo $annee_debut; ?>" /> </td>
	<td><input type="text" class="partie_date" size="2" name="moisDebut"
	value="<?php echo $mois_debut; ?>" /></td><td><input type="text"
	class="partie_date" size="2" name="jourDebut"
	value="<?php echo $jour_debut; ?>" /></td><td><select
	name="certitudeDateDebut">
	<?php foreach ($liste_certitude_dd as $valeur_certitude_dd) {
		echo $valeur_certitude_dd;
	}?>
</select></td><td><input type="text" size="70" name="notesDD"
	value="<?php echo $notes_dd; ?>" /></td></tr>
	
<tr><td>Fin:</td><td><input type="text" class="partie_date"
	size="3" name="anneeFin" value="<?php echo $annee_fin; ?>" /></td><td>
<input type="text" class="partie_date" size="2" name="moisFin"
	value="<?php echo $mois_fin; ?>" /> </td><td><input type="text"
	class="partie_date" size="2" name="jourFin"
	value="<?php echo $jour_fin; ?>" /></td><td><select
	name="certitudeDateFin">	<?php foreach ($liste_certitude_df as $valeur_certitude_df) {
		echo $valeur_certitude_df;
	}?>
</select></td><td><input type="text" size="70" name="notesDF"
	value="<?php echo $notes_df; ?>" /></td></tr>
</table>
<!-- appelle la partie du formulaire concernant descriptif et notes, 
tout en indiquant dans le paramètre le nomtre de lignes à afficher  -->
	<?php html_descriptif_notes(3, $descriptif, $notes) ; ?>

<p>Url de l'objet (<a href="<?php echo $url_objet; ?>" target="_blank">activer</a>)
: <input type="text" size="70" name="urlObjet"
	value="<?php echo $url_objet; ?>" /></p>

<input type="hidden" name="effectuer" value="update" /> <input
	type="hidden" name="cleObjet" value="<?php echo $cle_objet; ?>" />
<p><?php if ($maj_bhp == 'activée') echo '<p>Clé objet BHP : 
<input name="cleObjetBHP" value="'.$cle_objet_bhp.'" />' ?> <?php if(!empty($zotero_original)) echo '  Clé jointure Zotero (champs Zotero : "extra") : 
	<input type="text" size="8" name="cleJointureZotero" value="'.$cle_jointure_zotero.'"/>' ; ?>
</p>
<p></p>
</form>

</div>

<div><?php 

if ($maj_bhp == 'activée' or (!empty($zotero_original) and !empty($cle_jointure_zotero))) {
	echo '<h4 class="ligne_horizontale_dessous">Actions supplémentaires</h4>
	<p>';
	/* Vérifie si le lien avec la BHP est activé
	 * et déclanche une mise à jour depuis la BHP du nom et de la date standard.
	 */
	if ($maj_bhp == 'activée')
	echo '<form action="objet_insert_update.php" method="post">
		<input type="hidden" name="effectuer" value="maj_objet_bhp" />
		<input type="hidden" name="cleObjetBHP" value="'.$cle_objet_bhp.'" />
		<input type="hidden" name="cleObjet" value="'.$cle_objet.'"/>
		<input type="submit" value="Mettre à jour objet BHP"/></p>
		</form>';

	if(!empty($zotero_original) and !empty($cle_jointure_zotero))
	echo '<form action="objet_insert_update.php" method="post">
		<input type="hidden" name="cleJointureZotero" value="'.$cle_jointure_zotero.'"/>
		<input type="hidden" name="effectuer" value="copier_zotero_sqlite" />
		<input type="hidden" name="cleObjet" value="'.$cle_objet.'"/>
		<input type="submit" value="Mettre à jour la copie de la base Zotero" style="float: left" />
		</form>';

	echo '</p>';
}



if (!isset($tableau_resultat)) $tableau_resultat = array();
if(!empty($zotero_original) and !empty($cle_jointure_zotero)) {

	// cette fonction permet de voir le contenu du tableau
	// print_r(array_values($tableau_resultat));

	$groupsAuthor = array();

	//partie de test
	foreach($tableau_resultat as $cle => $element) {
		foreach($element as $cle2 => $element2) {

			//if($cle =='author') echo $cle.' – '.$element2.'<br/>';

			if($cle =='author') $groupsAuthor[] = $element2;

			//   foreach($groups as $value => $items)
			//   echo 'Group ' . $value . ' has ' . count($items) . ' ' . (count($items) == 1 ? 'item' : 'items') . "<br/>";
		}
	}

	//voir le contenu du tableau
	// print_r(array_values($groupsAuthor));
	// sortir le tableau d'après les valeurs
	asort($groupsAuthor); //arsort – reverse sort
	$listeAuteurs = implode(' / ', $groupsAuthor);
	// $nombreAuteurs =  count ( $groupsAuthor);




	echo '<table><caption style="font-weight:bold">Données Zotero local</caption>';

	/* Cette syntaxe, fort importante, permet d'extraire des valeurs d'un talbeau à deux dimensions
	 *  Relever qu'on peut utiliser à la sortie toutes les variables, celles de premier et celles de deuxième niveau.
	 */
	foreach($tableau_resultat as $cle => $element) {
		foreach($element as $cle2 => $element2) {
			echo "<td>".$cle."</td><td>". $element2 ."</td></tr>";
		}
	}

	echo '</table>';

}


?></div>



</body>
</html>
