<?php

require_once("../connexion_base_individuelle.inc");
require_once("../html_parts.inc");
require_once("../preparation_insert_update.inc");


// récupère l'identifiant de l'unité de connaissance
if (isset($form_cleUC)) $cle_uc = $form_cleUC; else $form_cleUC = '';
if (!empty($form_cleObjetAssocie)) $cle_objet = $form_cleObjetAssocie; else $cle_objet = 'NULL';
if (isset($form_effectuer)) $form_effectuer = $form_effectuer; else $form_effectuer = '';






// Formulaire INSERT : ce traitment s'applique lorsqu'un insert est appelé depuis la fiche de l'unité de connaissance :
// ce script fait alors fonction de formulaire de saisie

if (isset($form_effectuer) and $form_effectuer =='association_objet_uc_form_insert') {

	$titre_div_fomulaire = '<h2>Insérer une nouvelle association à un objet pour l\'UnCo'.$cle_uc.'</h2>';
	$valeur_effectuer = 'insert';
	$value_submit= 'Nouvelle association';

	//déclarer et renseigner les variables en fonction des besoins


	$complement_html ='';
	$nom_objet_associe_avec_texte = '' ;
	$cle_sourcer = '';
	$cle_objet = '';
	$champs_association = '';
	$nom_objet_associe = '';
	$nom_objet_concerne = '';
	$reference_precise = '';
	$fk_type_association_objet = '';
	$type_association = '';
	$descriptif = '';
	$notes = '';


	/* Types de l'association  */

	// préparer la requête qui liste les types de l'association
	$requete = "SELECT pk_parametre,
	      			nom
	 			FROM tables_types.parametre
	 			WHERE  type_parametre = 'type_association_uc_objet' 
	 			\n ORDER BY nom;";

	// Ouvre la connection avec la fonction externe et récupère la variable
	$connexion = connexion();

	// effectuer la requête
	$resultat = pg_query($requete) or die('Echec de la requête : ' . pg_last_error());

	//préparer le résultat pour l'utilisation dans le formulaire
	$liste_types = array();
	while ($types = pg_fetch_object($resultat))
	{
		$liste_types[] = '<option value="'.$types->pk_parametre.'">'.$types->nom.'</option>';
	}

	// Libérer le résultat
	pg_free_result($resultat);


}

// ce traitement s'applique dans les autres cas
else {

	// récupère l'identifiant de la ligne source
	if (isset($form_cleAssociation)) $cle_association = $form_cleAssociation; else $cle_association = '';
	$complement_html ='';

	// Gestion du bouton effectuer	: insert ou update.
	if  (!empty($form_effectuer))  {

		// UPDATE : Partie qui effectue l'UPDATE des paramères de l'association
		if ($form_effectuer == 'update') {

			if (!empty($form_cleObjetAssocie) and !is_numeric($form_cleObjetAssocie)) {
				html_header ('Attention', '../css/unite_connaissance.css');
				exit( '<p>Attention : l\'objet qui source doit être au format numérique.</p>
				<p><form action="source_insert_update.php"  method="get" >
				<input type="hidden" name="cleAssociation" value="'.$cle_association.'" />
				<input type="hidden" name ="cleUC" value="'.$cle_uc.'"></input>
				<input type="submit" value="OK" /></form></p></body></html>')	;
			}

			if(empty($cle_objet)) $update_cle_objet_source = ", fk_objet=NULL ";
			else $update_cle_objet_source = ", fk_objet=".$cle_objet;

			$requete = "UPDATE tables_uc.associer_unite_connaissance_objet ".
			// Cette première ligne est en soi inutile
			// mais elle a été ajoutée pour traiter les cas où rien ne serait mis à jour
			"SET pk_associer_unite_connaissance_objet = ".$cle_association.
			$update_cle_objet_source.
			$update_reference_precise.
			$update_fk_type_association_objet.
			$update_descriptif.$update_notes."
			\n WHERE pk_associer_unite_connaissance_objet = ".$cle_association;

			// Ouvre la connection avec la fonction externe et récupère la variable
			$connexion = connexion();

			// Effectuer la requête qui liste les types de cet objet
			$resultat = pg_query($requete) or die('Echec de la requête : ' . pg_last_error());

			// Libérer le résultat
			pg_free_result($resultat);

		}


		// INSERT : Partie qui effectue l'INSERT de l'association
		elseif ($form_effectuer == 'insert') {

			if (!empty($form_cleObjetAssocie) and !is_numeric($form_cleObjetAssocie)) {
				html_header ('Attention', '../css/unite_connaissance.css');
				exit( '<p>Attention : l\'objet qui source doit être au format numérique.</p>
					<p><form action="source_insert_update.php"  method="get" >
					<input type="hidden" name="effectuer" value="source_form_insert"/>
					<input type="hidden" name ="cleUC" value="'.$cle_uc.'"></input>
					<input type="submit" value="OK" /></form></p></body></html>')	;
			}
			else {
				$complement_html = '';
			}


			$requete = "INSERT INTO tables_uc.associer_unite_connaissance_objet  (fk_unite_connaissance,
				fk_objet, fk_type_association_objet ".
			$champs_reference_precise.
			$champs_descriptif.$champs_notes.")
						VALUES (".$cle_uc.",".$cle_objet.
			$partie_fk_type_association_objet.
			$partie_reference_precise.
			$partie_descriptif.
			$partie_notes.")";

			// echo $requete;

			//ouvre la connection avec la fonction externe et récupère la variable
			$connexion = connexion();

			// effectuer la requête qui liste les types de cet objet
			$resultat = pg_query($requete) or die('Echec de la requête : ' . pg_last_error());

			// Libérer le résultat
			pg_free_result($resultat);


			// cherche la clé de la nouvelle association
			$requete = 'SELECT MAX(pk_associer_unite_connaissance_objet) AS pk_associer_unite_connaissance_objet
							FROM tables_uc.associer_unite_connaissance_objet';
			$resultat = pg_query($requete) or die('Query failed: ' . pg_last_error());
			if (!$resultat) {
				echo "Erreur.\n";
				exit;
			}
			while ($row = pg_fetch_object($resultat)) {
				$cle_association = $row->pk_associer_unite_connaissance_objet;
			}

			// Libérer le résultat
			pg_free_result($resultat);
		}

	}
	$value_submit = 'Mettre à jour';


	//ouvre la connection avec la fonction externe et récupère la variable
	$connexion = connexion();


	/* Types de l'association  */

	// préparer la requête qui liste les types de l'association
	$requete = "SELECT t1.pk_parametre,
       			t1.nom,
       			CASE
         			WHEN t3.pk_associer_unite_connaissance_objet IS NULL THEN NULL
         			ELSE 'selected'
       			END AS selected
			FROM tables_types.parametre t1
  			LEFT JOIN tables_uc.associer_unite_connaissance_objet t3 ON t3.fk_type_association_objet = t1.pk_parametre 
  				AND t3.pk_associer_unite_connaissance_objet = ".$cle_association." 
			WHERE t1.type_parametre = 'type_association_uc_objet'";


	// effectuer la requête
	$resultat = pg_query($requete) or die('Echec de la requête : ' . pg_last_error());

	//préparer le résultat pour l'utilisation dans le formulaire
	$liste_types = array();
	while ($types = pg_fetch_object($resultat))
	{
		$liste_types[] = '<option '.$types->selected.' value="'.$types->pk_parametre.'">'.$types->nom.'</option>';
	}

	// Libérer le résultat
	pg_free_result($resultat);


	//ouvre la connection avec la fonction externe et récupère la variable
	$connexion = connexion();



	// requête qui cherche les propriétés de cette association
	$requete = "SELECT *
				FROM tables_uc.v_associations_uc_objets
				WHERE pk_associer_unite_connaissance_objet = ".$cle_association;

	// effectuer la requête
	$resultat = pg_query($requete) or die('Echec de la requête : ' . pg_last_error());

	// récupérer le résultat dans une variable
	if ($resultat) {
		$champs_association = pg_fetch_assoc($resultat);
		$cle_objet = $champs_association['fk_objet'];
		$nom_objet = $champs_association['nom_objet'];
		$sous_type_objet = $champs_association['sous_type_objet'];
		$reference_precise = $champs_association['reference_precise'];
		$descriptif = $champs_association['descriptif'];
		$notes = $champs_association['notes'];
		$libelle_uc = $champs_association['libelle_uc'];
	}
	else {
		$liste_noms_standard = 'Erreur !';
	}

	if(!empty($sous_type_objet)) $sous_type_objet_concat = ' (Sous-type : '.$sous_type_objet.')'; else $sous_type_objet_concat = '';

	// autres variables
	$nom_objet_associe_avec_texte = ' Objet source : "'.$nom_objet_source.'" '.$sous_type_objet_concat ;
	$valeur_effectuer = 'update';
	$titre_div_fomulaire = '<h2>UnCo'.$cle_uc.' – '.$libelle_uc.' (clé association : '.$cle_association.')</h2>';


	// Libérer le résultat
	pg_free_result($resultat);

	// Fermer la connexion
	pg_close($connexion);




}




?>

<?php html_header ('Association', '../css/unite_connaissance.css'); ?>


<div><?php echo $titre_div_fomulaire; ?> <?php echo $complement_html; ?>

<form action="associer_uc_objet_insert_update.php" method="post">

<p>Type d'association : <select name="typeAssociation">
<?php foreach ($liste_types as $type) {
	echo $type;
}?>
</select></p>

<p>Cle objet associé : <input type="text" size="5"
	name="cleObjetAssocie" value="<?php echo $cle_objet;?>" /> <strong><?php echo $nom_objet; ?></strong>
</p>

<p>Référence précise : <input type="text" size="100"
	name="referencePrecise" value="<?php echo $reference_precise ; ?>" /></p>

<?php html_descriptif_notes(1, $descriptif, $notes) ; ?> <input
	type="hidden" name="effectuer" value="<?php echo $valeur_effectuer; ?>" />
<input type="hidden" name="cleAssociation"
	value="<?php echo $cle_association; ?>" /> <input type="hidden"
	name="cleUC" value="<?php echo $cle_uc; ?>" />
<p><input type="submit" value="<?php echo $value_submit; ?>" /></p>
</form>

<form action="unite_connaissance_update.php" method="get"><input
	type="hidden" name="cleUC" value="<?php echo $cle_uc; ?>" /> <input
	type="hidden" name="ongletActif" value="objets_associes" />
<p></p>
<input type="submit" value="Fermer" />
</p>
</form>

<?php html_autres_possibilites();?></div>
</body>
</html>
