<?php

require_once("../connexion_base_individuelle.inc");
require_once("../html_parts.inc");
require_once("../preparation_insert_update.inc");


// récupère l'identifiant de l'unité de connaissance
if (isset($form_cleUC)) $cle_uc = $form_cleUC; else $form_cleUC = '';
if (!empty($form_cleObjetSource)) $cle_objet_source = $form_cleObjetSource; else $cle_objet_source = NULL;
if (isset($form_effectuer)) $form_effectuer = $form_effectuer; else $form_effectuer = '';


// ce traitment s'applique lorsqu'un insert est appelé depuis la fiche de l'unité de connaissance :
// ce script fait alors fonction de formulaire de saisie

if (isset($form_effectuer) and $form_effectuer =='source_form_insert') {

	$titre_div_fomulaire = '<h2>Insérer une nouvelle source pour l\'UnCo'.$cle_uc.'</h2>';
	$valeur_effectuer = 'insert';
	$value_submit= 'Créer nouvelle source';

	//déclarer et renseigner les variables en fonction des besoins


	$complement_html ='';
	$nom_objet_associe_avec_texte = '' ;
	$cle_sourcer = '';
	$cle_objet_source = '';
	$champs_association = '';
	$nom_objet_associe = '';
	$nom_objet_concerne = '';
	$reference_precise = '';
	$fk_type_association_objet = '';
	$type_association = '';
	$descriptif = '';
	$notes = '';



}

// ce traitement s'applique dans les autres cas
else {

	// récupère l'identifiant de la ligne source
	if (isset($form_cleSourcer)) $cle_sourcer = $form_cleSourcer; else $cle_sourcer = '';
	$complement_html ='';

	// Gestion du bouton effectuer	: insert ou update.
	if  (!empty($form_effectuer))  {

		// UPDATE : Partie qui effectue l'UPDATE des paramères de l'association
		if ($form_effectuer == 'update') {

			if (!empty($form_cleObjetSource) and !is_numeric($form_cleObjetSource)) {
				html_header ('Attention', '../css/unite_connaissance.css');
				exit( '<p>Attention : l\'objet qui source doit être au format numérique.</p>
				<p><form action="source_insert_update.php"  method="get" >
				<input type="hidden" name="cleSourcer" value="'.$cle_sourcer.'" />
				<input type="hidden" name ="cleUC" value="'.$cle_uc.'"></input>
				<input type="submit" value="OK" /></form></p></body></html>')	;
			}

			if(empty($cle_objet_source)) $update_cle_objet_source = ", fk_objet=NULL ";
			else $update_cle_objet_source = ", fk_objet=".$cle_objet_source;

			$requete = "UPDATE tables_uc.sourcer SET pk_sourcer = ".$cle_sourcer.
			$update_cle_objet_source.
			$update_reference_precise.
			$update_descriptif.$update_notes."
			\n WHERE pk_sourcer = ".$cle_sourcer;

			//ouvre la connection avec la fonction externe et récupère la variable
			$connexion = connexion();

			// effectuer la requête qui liste les types de cet objet
			$resultat = pg_query($requete) or die('Echec de la requête : ' . pg_last_error());

			// Libérer le résultat
			pg_free_result($resultat);

		}


		// INSERT : Partie qui effectue l'INSERT de l'association
		elseif ($form_effectuer == 'insert') {

			if (!empty($form_cleObjetSource) and !is_numeric($form_cleObjetSource)) {
				html_header ('Attention', '../css/unite_connaissance.css');
				exit( '<p>Attention : l\'objet qui source doit être au format numérique.</p>
					<p><form action="source_insert_update.php"  method="get" >
					<input type="hidden" name="effectuer" value="source_form_insert"/>
					<input type="hidden" name ="cleUC" value="'.$cle_uc.'"></input>
					<input type="submit" value="OK" /></form></p></body></html>')	;
			}
			else {
				$complement_html = '';
			}


			$requete = "INSERT INTO tables_uc.sourcer  (fk_unite_connaissance, fk_objet".
			$champs_reference_precise.
			$champs_descriptif.$champs_notes.")
							VALUES (".$cle_uc.",".$cle_objet_source.
			$partie_reference_precise.
			$partie_descriptif.$partie_notes.")";

			//echo $requete;

			//ouvre la connection avec la fonction externe et récupère la variable
			$connexion = connexion();

			// effectuer la requête qui liste les types de cet objet
			$resultat = pg_query($requete) or die('Echec de la requête : ' . pg_last_error());

			// Libérer le résultat
			pg_free_result($resultat);


			// cherche la clé de la nouvelle association
			$requete = 'SELECT MAX(pk_sourcer) AS pk_sourcer
							FROM tables_uc.sourcer';
			$resultat = pg_query($requete) or die('Query failed: ' . pg_last_error());
			if (!$resultat) {
				echo "Erreur.\n";
				exit;
			}
			while ($row = pg_fetch_object($resultat)) {
				$cle_sourcer = $row->pk_sourcer;
			}

			// Libérer le résultat
			pg_free_result($resultat);
		}

	}
	$value_submit = 'Mettre à jour';

	//ouvre la connection avec la fonction externe et récupère la variable
	$connexion = connexion();



	// requête qui cherche les propriétés de cette source
	$requete = "SELECT *
						FROM tables_uc.v_sources_avec_libelles
						WHERE pk_sourcer = ".$cle_sourcer;

	// effectuer la requête
	$resultat = pg_query($requete) or die('Echec de la requête : ' . pg_last_error());

	// récupérer le résultat dans une variable
	if ($resultat) {
		$champs_association = pg_fetch_assoc($resultat);
		$cle_objet_source = $champs_association['fk_objet'];
		$nom_objet_source = $champs_association['source'];
		$sous_type_objet = $champs_association['sous_type_objet'];
		$reference_precise = $champs_association['reference_precise'];
		$descriptif = $champs_association['descriptif'];
		$notes = $champs_association['notes'];
		$libelle_uc = $champs_association['libelle_uc'];
	}
	else {
		$liste_noms_standard = 'Erreur !';
	}

	if(!empty($sous_type_objet)) $sous_type_objet_concat = ' (Sous-type : '.$sous_type_objet.')'; else $sous_type_objet_concat = '';

	// autres variables
	$nom_objet_associe_avec_texte = ' Objet source : "'.$nom_objet_source.'" '.$sous_type_objet_concat ;
	$valeur_effectuer = 'update';
	$titre_div_fomulaire = '<h2>UnCo'.$cle_uc.' – '.$libelle_uc.' (clé sourcer : '.$cle_sourcer.')</h2>';


	// Libérer le résultat
	pg_free_result($resultat);

	// Fermer la connexion
	pg_close($connexion);

}




?>

<?php html_header ('Sourcer', '../css/unite_connaissance.css'); ?>


<div><?php echo $titre_div_fomulaire; ?> <?php echo $complement_html; ?>

<form action="source_insert_update.php" method="post">

<p>Cle objet source : <input type="text" size="5" name="cleObjetSource"
	value="<?php echo $cle_objet_source;?>" /> <?php echo $nom_objet_associe_avec_texte; ?>
</p>

<p>Référence précise : <input type="text" size="100"
	name="referencePrecise" value="<?php echo $reference_precise ; ?>" /></p>

<?php html_descriptif_notes(2, $descriptif, $notes ) ; ?> <input
	type="hidden" name="effectuer" value="<?php echo $valeur_effectuer; ?>" />
<input type="hidden" name="cleSourcer"
	value="<?php echo $cle_sourcer; ?>" /> <input type="hidden"
	name="cleUC" value="<?php echo $cle_uc; ?>" />
<p><input type="submit" value="<?php echo $value_submit; ?>" /></p>
</form>

<form action="unite_connaissance_update.php" method="get"><input
	type="hidden" name="cleUC" value="<?php echo $cle_uc; ?>" /> <input
	type="hidden" name="ongletActif" value="sources" />
<p></p>
<input type="submit" value="Fermer" />
</p>
</form>

<?php html_autres_possibilites();?></div>
</body>
</html>
