<?php

ini_set('display_errors', 'On');
error_reporting(E_ALL);

// ATTENTION : l'insertion de nouvelles unités de connaissance se fait via les rôles

require_once("../connexion_base_individuelle.inc");
require_once("../html_parts.inc");
require_once("../preparation_insert_update.inc");

// récupère l'identifiant de l'objet
	if (isset($form_cleUC) and is_numeric($form_cleUC)) {
		//echo 'Clé UC : '.$form_cleUC;
		$cle_uc = $form_cleUC;
	}
	else { $cle_uc = NULL;
	echo 'Attention :manque la clé de l\'unité de connaissance' ;
	}


// Mise à jour du type d'unité de connaissance

	if (isset($form_effectuer) and $form_effectuer == 'update_uc_type_uc') {
	
		$requete = 'UPDATE tables_uc.unite_connaissance
						SET fk_type_unite_connaissance ='.$form_TypeUC.
						'WHERE pk_unite_connaissance ='.$cle_uc;
	
		$connexion = connexion();
		$resultat = pg_query($requete) or die('Echec de la requête : ' . pg_last_error());
		pg_free_result($resultat);
	
	}

// Mise à jour du descriptif et des notes

	elseif (isset($form_effectuer) and $form_effectuer == 'update_uc_descriptif_notes') {
	
		$requete = "UPDATE tables_uc.unite_connaissance
						SET pk_unite_connaissance =".$cle_uc.$update_descriptif.$update_notes.
						"WHERE pk_unite_connaissance =".$cle_uc;
	
		$connexion = connexion();
		$resultat = pg_query($requete) or die('Echec de la requête : ' . pg_last_error());
		pg_free_result($resultat);
	
	}





// récupère le nom de l'onglet actif ou afficher par défaut l'onglet 'roles'
	if (!empty($form_ongletActif)) {
		$onglet_actif = $form_ongletActif;
	}
	else { $onglet_actif = 'roles';
	}
	
	
	$connexion = connexion();
	
	
	/* Crée le libellé de l'unité de connaissance, avec le type et la date standard */
	
	$libelle_uc = '';
	
	// cette requête cherche le descriptif, la date standard et le type de l'UC
	$requete = "SELECT t1.pk_unite_connaissance,
				   	   t1.libelle_uc,
				       t2.date_standard,
				       t3.nom as nom_type_uc,
				       t4.fk_type_unite_connaissance,
				       t4.descriptif,
				       t4.notes,
				       t4.date_creation
				FROM tables_uc.v_libelle_uc t1 
				  JOIN tables_uc.unite_connaissance t4 on t4.pk_unite_connaissance = t1.pk_unite_connaissance
				  LEFT JOIN tables_uc.v_date_standard_uc t2 ON t2.fk_unite_connaissance = t1.pk_unite_connaissance 
				  LEFT JOIN tables_types.type_unite_connaissance t3 ON t3.pk_type_unite_connaissance = t1.fk_type_unite_connaissance
				WHERE t1.pk_unite_connaissance = ".$cle_uc.";";
	
	
	// effectuer la requête
	$resultat = pg_query($requete) or die('Echec de la requête : ' . pg_last_error());
	
	
	// récupérer le résultat dans une variable
	if ($resultat) {
		$champs_uc = pg_fetch_assoc($resultat);
		$fk_type_unite_connaissance = $champs_uc['fk_type_unite_connaissance'];
		$libelle_uc = $champs_uc['libelle_uc'];
		$date_standard = $champs_uc['date_standard'];
		$nom_type_uc = $champs_uc['nom_type_uc'];
		$descriptif = $champs_uc['descriptif'];
		$notes = $champs_uc['notes'];
		$date_creation = $champs_uc['date_creation'];
	
	}
	else {
		$libelle_uc = 'Erreur dans la recherche !';
	}
	
	
	// Libérer le résultat
	pg_free_result($resultat);




/* Chercher le sujet de l'unité de connaissance */

// cette requête liste cherche le/les sujets de l'UC
$requete = "SELECT fk_unite_connaissance,
				sujet_uc
	       	FROM tables_uc.v_sujet_uc
			WHERE fk_unite_connaissance = ".$cle_uc;


// effectuer la requête
$resultat = pg_query($requete) or die('Echec de la requête : ' . pg_last_error());


// récupérer le résultat dans une variable
if ($resultat) {
	$sujet_uc_resultat = pg_fetch_assoc($resultat);
	$sujet_uc = $sujet_uc_resultat['sujet_uc'];

}
else {
	$libelle_uc = 'Erreur dans la recherche !';
}


// Libérer le résultat
pg_free_result($resultat);



/* Tableau des DATES */

$requete = "SELECT t1.*, t2.nom AS type_date
		FROM tables_uc.date_unite_connaissance t1
		JOIN tables_types.parametre t2 ON t2.pk_parametre = t1.fk_type_date
		WHERE t1.fk_unite_connaissance = ".$cle_uc.
		"ORDER BY t1.date_recomposee";

$connexion = connexion();
$resultat = pg_query($requete) or die('Echec de la requête : ' . pg_last_error());

// initialiser le tableau des dates
$tableau_dates = array() ;

// Récupérer le résultat et le mettre dans un tableau
while ($objet_resultat = pg_fetch_object ($resultat)) {
	// On sort le tableau résultant de la requête
	$tableau_dates[] = '<tr><td>'.$objet_resultat->date_recomposee.'</td>
	<td>'.$objet_resultat->annee.'</td><td>'.$objet_resultat->mois.'</td><td>'.$objet_resultat->jour.'</td>
	<td>'.$objet_resultat->marge_date.'</td><td>'.$objet_resultat->type_date.'</td><td>'.$objet_resultat->libelle_selon_source.'</td>
	<td><a href="uc_date_insert_update.php?cleDate='.$objet_resultat->pk_date_unite_connaissance.'&cleUC='.$cle_uc.'">'.$objet_resultat->pk_date_unite_connaissance.'</a></td></tr>';
}

// Libérer le résultat
pg_free_result($resultat);




	


/* URL des onglets */
	$actif_roles = '><a href="unite_connaissance_update.php?cleUC='.$cle_uc.'&ongletActif=roles"';
	$actif_textes = '><a href="unite_connaissance_update.php?cleUC='.$cle_uc.'&ongletActif=textes"';
	$actif_texte_tei = '><a href="unite_connaissance_update.php?cleUC='.$cle_uc.'&ongletActif=texte_tei"';
	$actif_sources = '><a href="unite_connaissance_update.php?cleUC='.$cle_uc.'&ongletActif=sources"';
	$actif_uc_associees = '><a href="unite_connaissance_update.php?cleUC='.$cle_uc.'&ongletActif=uc_associees"';
	$actif_objets_associes = '><a href="unite_connaissance_update.php?cleUC='.$cle_uc.'&ongletActif=objets_associes"';




// initialiser variables pour tous les onglets
$titre_liste = '';
$tableau_roles = array() ;


switch ($onglet_actif) {

	case 'roles' :
		$actif_roles = ' class="active"><a';
		$titre_liste = 'Liste des rôles';
		// Préparer la requête qui cherche tous les rôles de cet UC
		$requete = 'SELECT *
					FROM vues_sql.v_role_avec_uc_avec_qualificatifs
					WHERE pk_unite_connaissance = '.$cle_uc;

		// effectuer la requête
		$resultat = pg_query($requete) or die('Echec de la requête : ' . pg_last_error());

		$nombre_roles = pg_num_rows($resultat);


		// Récupérer le résultat et le mettre dans un tableau

		while ($objet_resultat = pg_fetch_object ($resultat)) {

				
			
			if(strlen($objet_resultat->libelle_qualificatif_objet)>0 && strlen($objet_resultat->uc_libelle_qualificatif_objet)<1) {$libelle_objet_ou_uc_qualificatif = '<a href="../objet/objet_insert_update.php?cleObjet='.$objet_resultat->fk_qualificatif_objet.'" target="_blank">'.$objet_resultat->libelle_qualificatif_objet.'</a>' ;}
			elseif (strlen($objet_resultat->libelle_qualificatif_objet)<1 && strlen($objet_resultat->uc_libelle_qualificatif_objet)>0) $libelle_objet_ou_uc_qualificatif = '<a href="../unite_connaissance/unite_connaissance_update.php?cleUC='.$objet_resultat->fk_uc_qualificatif_objet.'" target="_blank">'.$objet_resultat->uc_libelle_qualificatif_objet.'</a>';
			else $libelle_objet_ou_uc_qualificatif = '';
			
			// On sort le tableau résultant de la requête
			$tableau_roles[] = '<tr>
			<td>'.$objet_resultat->type_role.'</td>
			<td>'.$objet_resultat->libelle_qualificatif_role.'</td>
			<td>'.$objet_resultat->descriptif_role.'</td>
			<td>'.$objet_resultat->objet_uc_associee.'</td>
			<td><a href="../objet/objet_associations.php?cleObjet='.$objet_resultat->fk_objet_associe.'&typeAssociation=uc" target="_blank">'.$objet_resultat->fk_objet_associe.'</a></td>
			<td><a href="unite_connaissance_update.php?cleUC='.$objet_resultat->fk_unite_connaissance_associee.'" target="_blank">'.$objet_resultat->fk_unite_connaissance_associee.'</a></td>
			<td>'.$libelle_objet_ou_uc_qualificatif.'</td>
			<td>'.$objet_resultat->libelle_selon_source.'</td>
			<td>'.$objet_resultat->valeur_numerique.'</td>
			<td>'.$objet_resultat->unite_mesure.'</td>
			<td><a href="role_insert_update.php?cleRole='.$objet_resultat->pk_role.'&typeUC='.$fk_type_unite_connaissance.'&cleUC='.$cle_uc.'">'.$objet_resultat->pk_role.'</a></td></tr>';
		}


		// Libérer le résultat
		pg_free_result($resultat);


		// préparer la requête qui liste les types d'unités de connaissance
		$requete = "SELECT pk_type_unite_connaissance,
		       	nom,
		       	CASE
         			WHEN pk_unite_connaissance IS NULL THEN NULL
         			ELSE 'selected'
       			END AS selected,
       			categorie_uc
		FROM tables_types.type_unite_connaissance
		LEFT JOIN tables_uc.unite_connaissance ON fk_type_unite_connaissance = pk_type_unite_connaissance
			AND pk_unite_connaissance = ".$cle_uc.
		"WHERE si_utilise IS TRUE
		ORDER BY nom;";

		$connexion = connexion();
		$resultat = pg_query($requete) or die('Echec de la requête : ' . pg_last_error());

		//préparer le résultat pour l'utilisation dans le formulaire
		$liste_types_uc = array();
		while ($types = pg_fetch_object($resultat))
		{
			$liste_types_uc[] = '<option '.$types->selected.' value="'.$types->pk_type_unite_connaissance.'">'.
			$types->nom.' ['.$types->categorie_uc.']</option>';
		}

		// Libérer le résultat
		pg_free_result($resultat);
		

		//fin de l'option rôles
		break;

		
	case 'textes' :
		$actif_textes = ' class="active"><a';
		$titre_liste = 'Liste des propriétés texte';


		$requete = "SELECT t1.*, t2.nom AS type_texte
		FROM tables_uc.propriete_texte t1
		JOIN tables_types.parametre t2 ON t2.pk_parametre = t1.fk_type_propriete
		WHERE t1.fk_unite_connaissance = ".$cle_uc.
		"ORDER BY t2.nom DESC";
		$connexion = connexion();
		$resultat = pg_query($requete) or die('Echec de la requête : ' . pg_last_error());

		// initialiser le tableau destiné à stocker le résultat
		$tableau_textes = array() ;

		// Récupérer le résultat et le mettre dans un tableau
		while ($objet_resultat = pg_fetch_object ($resultat)) {
			// On sort le tableau résultant de la requête
			$tableau_textes[] = '<tr><td>'.$objet_resultat->texte.'</td>
			<td>'.$objet_resultat->type_texte.'</td><td>'.$objet_resultat->code_langue.'</td><td>'.$objet_resultat->descriptif.'</td>
			<td>'.$objet_resultat->notes.'</td>
			<td><a href="uc_propriete_texte_insert_update.php?cleProprieteTexte='.$objet_resultat->pk_propriete_texte.'&cleUC='.$cle_uc.'">'.$objet_resultat->pk_propriete_texte.'</a></td></tr>';
		}

		// Libérer le résultat
		pg_free_result($resultat);


		//fin de l'option textes
		break;

		
		case 'texte_tei' :
		$actif_texte_tei = ' class="active"><a';
		$titre_liste = '';

				
		/* Récupère le texte XML */
		
		$requete = 'SELECT texte_xml_tei_body
			FROM tables_uc.unite_connaissance
			WHERE pk_unite_connaissance = '.$cle_uc;
		
		// récupère le texte xml (le champs peut-être NULL)
		$resultat = pg_query($requete) or die('Echec de la requête : ' . pg_last_error());
		$array_resultat = pg_fetch_assoc($resultat);
		$texte_xml =  $array_resultat['texte_xml_tei_body'];
		
		// Chargement du source XML
		$xml = new DOMDocument;
		
		// traite les cas où le champs texte TEI est NULL et crée l'objet XML à transformer
		if (strlen($texte_xml)>1) {
			$xml = new DOMDocument;
			$xml-> loadXML($texte_xml);
		} else {
			$xml-> loadXML('<text><body><p/></body></text>');
		}
		
		// Vérifier le contenu de l'objet à transformer: 
		//print_r($xml);
		
		
		$xsl = new DOMDocument;
		$xsl->load('text_xml_to_html.xsl');
		
		// Configuration du transformateur
		$proc = new XSLTProcessor;
		$proc->importStyleSheet($xsl); // attachement des règles xsl
		
		$texte_transforme = $proc->transformToDoc($xml);
	
		
		
		// Libérer le résultat
		pg_free_result($resultat);

		//fin de l'option texte_tei
		break;

		
	case 'sources' :
		$actif_sources = ' class="active"><a';
		$titre_liste = 'Liste des sources';

		$requete = 'SELECT *
					FROM tables_uc.v_sources_avec_libelles
					WHERE fk_unite_connaissance = '.$cle_uc;

		// effectuer la requête
		$resultat = pg_query($requete) or die('Echec de la requête : ' . pg_last_error());

		$nombre_sources = pg_num_rows($resultat);


		// Récupérer le résultat et le mettre dans un tableau
		$tableau_sources = array();
		while ($objet_resultat = pg_fetch_object ($resultat)) {

			// On sort le tableau résultant de la requête
			$tableau_sources[] = '<tr><td>'.$objet_resultat->source.'</td>
			<td>'.$objet_resultat->sous_type_objet.'</td>
			<td><a href="../objet/objet_insert_update.php?cleObjet='.$objet_resultat->fk_objet.'" target="_blank">'.$objet_resultat->fk_objet.'</a></td>
			<td>'.$objet_resultat->reference_precise.'</td>
			<td>'.$objet_resultat->notes.'</td>
			<td><a href="source_insert_update.php?cleSourcer='.$objet_resultat->pk_sourcer.'&cleUC='.$cle_uc.'">'.$objet_resultat->pk_sourcer.'</a></td></tr>';
		}


		// Libérer le résultat
		pg_free_result($resultat);
		break;

	case 'uc_associees' :
		$actif_uc_associees = ' class="active"><a';
		$titre_liste = 'Liste des informations associées';
		// Préparer la requête qui cherche tous les rôles de cet UC
		$requete = 'SELECT *
					FROM tables_uc.v_role_avec_uc
					WHERE fk_unite_connaissance_associee = '.$cle_uc;

		// effectuer la requête
		$resultat = pg_query($requete) or die('Echec de la requête : ' . pg_last_error());

		$nombre_roles = pg_num_rows($resultat);


		// Récupérer le résultat et le mettre dans un tableau
		$tableau_roles = array();

		while ($objet_resultat = pg_fetch_object ($resultat)) {

			// On sort le tableau résultant de la requête
			$tableau_roles[] = '<tr><td>'.$objet_resultat->type_role.'</td>
			<td>'.$objet_resultat->descriptif_role.'</td>
			<td>'.$objet_resultat->sujet_uc.' – '.$objet_resultat->libelle_uc.'</td>
			<td>'.$objet_resultat->type_uc.'</a></td>
			<td><a href="unite_connaissance_update.php?cleUC='.$objet_resultat->pk_unite_connaissance.'" target="_blank">'.$objet_resultat->pk_unite_connaissance.'</a></td>
			<td>'.$objet_resultat->libelle_selon_source.'</td>
			<td>'.$objet_resultat->valeur_numerique.'</td><td>'.$objet_resultat->unite_mesure.'</td>
			<td><a href="role_insert_update.php?cleRole='.$objet_resultat->pk_role.'&typeUC='.$fk_type_unite_connaissance.'&cleUC='.$cle_uc.'">'.$objet_resultat->pk_role.'</a></td></tr>';
		}


		// Libérer le résultat
		pg_free_result($resultat);
		break;

	case 'objets_associes' :
		$actif_objets_associes = ' class="active"><a';
		$titre_liste = 'Liste des objets associés';
		// Préparer la requête qui cherche tous les objets associés de cet UC
		$requete = 'SELECT *
					FROM tables_uc.v_associations_uc_objets
					WHERE fk_unite_connaissance = '.$cle_uc;

		// effectuer la requête
		$resultat = pg_query($requete) or die('Echec de la requête : ' . pg_last_error());

		$nombre_roles = pg_num_rows($resultat);


		// Récupérer le résultat et le mettre dans un tableau
		$tableau_objets_associes = array();

		while ($objet_resultat = pg_fetch_object ($resultat)) {

			if (strpos($objet_resultat->reference_precise, 'http') !== FALSE)
				$reference_precise = '<a href="'.$objet_resultat->reference_precise.'">'.$objet_resultat->reference_precise.'</a>' ;
			else $reference_precise = $objet_resultat->reference_precise;
			
			// On sort le tableau résultant de la requête
			$tableau_objets_associes[] = '<tr>
			<td>'.$objet_resultat->type_association.'</td>
			<td>'.$objet_resultat->nom_objet.'</td>
			<td><a href="../objet/objet_insert_update.php?cleObjet='.$objet_resultat->fk_objet.'" target="_blank">'.$objet_resultat->fk_objet.'</a></td>
			<td>'.$objet_resultat->sous_type_objet.'</a></td>
			<td>'.$reference_precise.'</td>
			<td>'.$objet_resultat->descriptif.'</td>
			<td>'.$objet_resultat->notes.'</td>
			<td><a href="associer_uc_objet_insert_update.php?cleAssociation='.$objet_resultat->pk_associer_unite_connaissance_objet.'&cleUC='.$cle_uc.'">'
			.$objet_resultat->pk_associer_unite_connaissance_objet.'</a></td>
			
			</tr>';
		}


		// Libérer le résultat
		pg_free_result($resultat);


}







// Fermer la connexion
pg_close($connexion);

?>




<!-- Commence ici la partie HTML -->

<?php html_header ('Unité de connaissance', '../css/unite_connaissance.css'); ?>


<div class="en_tete_page">
<h1><?php if(!empty($sujet_uc)) echo $sujet_uc.' : ';
echo $libelle_uc.' ('.$date_standard.') – <span class="font_smaller">'.$cle_uc.' (UnCo'.$cle_uc.')</span>' ?></h1>
</div>

<div class="renvois">
<p><a href="../type_unite_connaissance/types_uc_liste.php"
	target="_blank">Liste des types d'unités de connaissance</a> – <a
	href="../unite_connaissance/unite_connaissance_liste.php"
	target="_blank">Unités de connaissance</a> – <?php html_precedent_suivant('unite_connaissance', $cle_uc)?>
</p>
</div>


<div class="liste_dates">
<h4>Liste des dates</h4>
<table>
	<th>Date recomposée</th>
	<th>Année</th>
	<th>Mois</th>
	<th>Jour</th>
	<th>Marge date</th>
	<th>Type date</th>
	<th>Libelle source</th>
	<th>Clé</th>

	<?php  lignes_tableau($tableau_dates)?>
</table>
<form action="uc_date_insert_update.php" method="get"><input
	type="hidden" name="effectuer" value="form_insert" /> <input
	type="hidden" name="cleUC" value="<?php echo $cle_uc; ?>" />
<p><input type="submit" value="Nouvelle date" style="float: right" /></p>
</form>
</div>

<br />

<!-- Crée les onglets -->
<div id="menu">
<ul id="onglets">
	<li <?php echo $actif_roles;?>>Roles </a></li>
	<li <?php echo $actif_textes;?>>Textes </a></li>
	<li <?php echo $actif_texte_tei;?>>Texte TEI</a></li>
	<li <?php echo $actif_sources;?>>Sources </a></li>
	<li <?php echo $actif_uc_associees;?>>UC associées </a></li>
	<li <?php echo $actif_objets_associes;?>>Objets associés </a></li>

</ul>
</div>


<!-- Mise à jour du type d'unité de connaissance dans l'onglet 'Rôles' -->
	<?php if ($onglet_actif == 'roles') {
		echo '<form action="unite_connaissance_update.php" method="post">
	<p><br/>Type d\'unité de connaissance : <select name="TypeUC">';
		foreach ($liste_types_uc as $type) {
			echo $type;
		}
		echo '</select></p>
		<input type="hidden" name="effectuer" value="update_uc_type_uc"/>
		<input type="hidden" name="cleUC" value="'.$cle_uc.'"/>
		<p><input type="submit" value="Mettre à jour" /><br/></p>
		</form>';
	}
	?>


<!-- appelle la partie du formulaire concernant descriptif et notes -->
	<?php if ($onglet_actif == 'textes') {
		echo '<form action="unite_connaissance_update.php" method="post">';
		echo '<table class="formulaire"><tr><th>Libellé : </th><th>Notes :</th><th></th></tr>
  <tr>
    <td><textarea id="descriptif" rows="2" cols=65" name="descriptif" >'.$descriptif.'</textarea></td>
    <td><textarea rows="2" cols="35" name="notes" >'.$notes.'</textarea></td>
    <td><input type="hidden" name="effectuer" value="update_uc_descriptif_notes"/>
	<input type="hidden" name="ongletActif" value="textes"/>
	<input type="hidden" name="cleUC" value="'.$cle_uc.'" /> 
	<p><input type="submit" value="Mettre à jour" /></p>	</form></td>
</tr>
</table>';

	} ?>




<div>
<h4><?php echo $titre_liste; ?></h4>

	<?php



	if ($onglet_actif == 'roles') {
		$action = 'role_insert_update.php';
		$form_insert = 'role_form_insert';
		$bouton_insert = 'Nouveau rôle';
		echo '<div class="scrollingAreaObjetsAssocies">
				<table class="listeObjetsAssocies scrollable">
				<thead>
				<th>Type rôle</th>
				<th>Qualificatif rôle</th>
				<th>Descr. rôle</th>
				<th>Nom objet</th>
				<th>Objet</th>
				<th>UC</th>
				<th>Qualificatif objet</th>
				<th>Libellé selon la source</th>
				<th>Valeur</th>
				<th>Unité de mesure</th>
				<th>Rôle</th>
				</thead><tbody>';
		lignes_tableau($tableau_roles);

	} elseif ($onglet_actif == 'textes') {

		$action = 'uc_propriete_texte_insert_update.php';
		$form_insert = 'form_insert';
		$bouton_insert = 'Nouvelle propriété texte';


		echo '<div class="scrollingAreaObjetsAssociesLarger">
				<table class="listeObjetsAssociesLarger scrollable">
				<thead >
				<th>Texte</th>
				<th>Type</th>
				<th>Langue</th>
				<th>Descriptif</th>
				<th>Notes</th>
				<th>Clé</th>
				</thead><tbody>';
		lignes_tableau($tableau_textes);

		
	} elseif ($onglet_actif == 'texte_tei') {
		$action = 'uc_texte_tei_update.php';
		$form_insert = '';
		$bouton_insert = 'Ajouter / Modifier le texte';
		
		
	} elseif ($onglet_actif == 'sources') {
		$action = 'source_insert_update.php';
		$form_insert = 'source_form_insert';
		$bouton_insert = 'Nouvelle source';
		echo '<div class="scrollingAreaObjetsAssocies">
				<table class="listeObjetsAssocies scrollable">
				<thead>
				<th>Source (objet)</th>
				<th>Sous-type d\'objet</th>
				<th>Clé objet</th>
				<th>Référence précise</th>
				<th>Notes</th>
				<th>Clé source</th>
				</thead><tbody>';
		lignes_tableau($tableau_sources);

	} elseif ($onglet_actif == 'uc_associees') {
		$action = 'role_insert_update.php';
		$form_insert = 'role_form_insert';
		//$bouton_insert = 'Nouveau rôle';
		echo '<div class="scrollingAreaObjetsAssocies">
				<table class="listeObjetsAssocies scrollable">
				<thead>
				<th>Type rôle</th>
				<th>Descriptif du rôle</th>
				<th>Libellé UC associée</th>
				<th>Type UC</th>
				<th>UC</th>
				<th>Libellé selon la source</th>
				<th>Valeur</th>
				<th>Unité de mesure</th>
				<th>Rôle</th>
				</thead><tbody>';
		lignes_tableau($tableau_roles);

	} elseif ($onglet_actif == 'objets_associes') {
		$action = 'associer_uc_objet_insert_update.php';
		$form_insert = 'association_objet_uc_form_insert';
		$bouton_insert = 'Nouvelle association à un objet';
		echo '<div class="scrollingAreaObjetsAssocies">
				<table class="listeObjetsAssocies scrollable">
				<thead>
				<th>Type association</th>
				<th>Objet</th>
				<th>Clé objet</th>
				<th>Sous-type d\'objet</th>
				<th>Réf. précise</th>
				<th>Descriptif</th>
				<th>Notes</th>
				<th>Clé</th>
				</thead><tbody>';
		lignes_tableau($tableau_objets_associes);
	}

	echo '</tbody>
</table>';

	/* Si la variable qui renseigne le titre de l'action a un contenu, il sort le bouton qui
	 *  permet de déclancher l'action, sinon il ne sort pas le bouton
	 */
	if (isset($bouton_insert))

	{
		// ATTENTION : partie non encore traitée à adapter 
		echo '<form action="'.$action.'" method="get">
	<input type="hidden" name="effectuer" value="'.$form_insert.'" />
	<input type="hidden" name="cleUC" value="'.$cle_uc.'" /> 
	<input type="hidden" name="typeUC" value="'.$fk_type_unite_connaissance.'"/>
	<p><input type="submit" value="'.$bouton_insert.'" style="float: right" /></p>
	</form>' ;
		if ($onglet_actif == 'texte_tei') echo '<br/>';
	}
	
	echo '</div>' ;

	if ($onglet_actif == 'texte_tei') echo $texte_transforme -> saveHTML();
	

	?></div>
<br />




</body>
</html>
