<?php
/* * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * *
 *                                   ATTENTION!
 * If you see this message in your browser (Internet Explorer, Mozilla Firefox, Google Chrome, etc.)
 * this means that PHP is not properly installed on your web server. Please refer to the PHP manual
 * for more details: http://php.net/manual/install.php 
 *
 * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * *
 */


    include_once dirname(__FILE__) . '/' . 'components/utils/check_utils.php';
    CheckPHPVersion();
    CheckTemplatesCacheFolderIsExistsAndWritable();


    include_once dirname(__FILE__) . '/' . 'phpgen_settings.php';
    include_once dirname(__FILE__) . '/' . 'database_engine/pgsql_engine.php';
    include_once dirname(__FILE__) . '/' . 'components/page.php';


    function GetConnectionOptions()
    {
        $result = GetGlobalConnectionOptions();
        $result['client_encoding'] = 'utf8';
        GetApplication()->GetUserAuthorizationStrategy()->ApplyIdentityToConnectionOptions($result);
        return $result;
    }

    
    // OnGlobalBeforePageExecute event handler
    
    
    // OnBeforePageExecute event handler
    
    
    
    class vues_vm_association_objets_invPage extends Page
    {
        protected function DoBeforeCreate()
        {
            $this->dataset = new TableDataset(
                new PgConnectionFactory(),
                GetConnectionOptions(),
                '"vues"."vm_association_objets_inv"');
            $field = new IntegerField('fk_type_association_param');
            $this->dataset->AddField($field, false);
            $field = new IntegerField('fk_objet_source');
            $this->dataset->AddField($field, false);
            $field = new StringField('nom_objet_source');
            $this->dataset->AddField($field, false);
            $field = new StringField('date_objet_source');
            $this->dataset->AddField($field, false);
            $field = new StringField('reference_precise_objet_source');
            $this->dataset->AddField($field, false);
            $field = new StringField('libelle_original_objet_source');
            $this->dataset->AddField($field, false);
            $field = new IntegerField('valeur_objet_source');
            $this->dataset->AddField($field, false);
            $field = new IntegerField('fk_qualificatif_objet_source');
            $this->dataset->AddField($field, false);
            $field = new IntegerField('fk_role_objet_source');
            $this->dataset->AddField($field, false);
            $field = new IntegerField('fk_unite_de_mesure');
            $this->dataset->AddField($field, false);
            $field = new IntegerField('fk_objet_cible');
            $this->dataset->AddField($field, false);
            $field = new StringField('nom_objet_cible');
            $this->dataset->AddField($field, false);
            $field = new StringField('date_objet_cible');
            $this->dataset->AddField($field, false);
            $field = new StringField('descriptif');
            $this->dataset->AddField($field, false);
            $field = new StringField('notes');
            $this->dataset->AddField($field, false);
            $field = new IntegerField('pk_association_objets');
            $this->dataset->AddField($field, true);
            $field = new DateTimeField('date_creation');
            $this->dataset->AddField($field, false);
            $field = new DateTimeField('date_modification');
            $this->dataset->AddField($field, false);
            $this->dataset->AddLookupField('fk_objet_cible', 'vues.vm_objet_vue_de_base', new IntegerField('pk_objet'), new StringField('nom', 'fk_objet_cible_nom', 'fk_objet_cible_nom_vues_vm_objet_vue_de_base'), 'fk_objet_cible_nom_vues_vm_objet_vue_de_base');
            $this->dataset->AddLookupField('fk_type_association_param', 'vues.vn_types_associations_inverses_entre_objets', new IntegerField('pk_parametre_systeme'), new StringField('valeur_inverse', 'fk_type_association_param_valeur_inverse', 'fk_type_association_param_valeur_inverse_vues_vn_types_associations_inverses_entre_objets'), 'fk_type_association_param_valeur_inverse_vues_vn_types_associations_inverses_entre_objets');
            $this->dataset->AddLookupField('fk_objet_source', 'vues.vm_objet_vue_de_base', new IntegerField('pk_objet'), new StringField('nom', 'fk_objet_source_nom', 'fk_objet_source_nom_vues_vm_objet_vue_de_base'), 'fk_objet_source_nom_vues_vm_objet_vue_de_base');
        }
    
        protected function DoPrepare() {
    
        }
    
        protected function CreatePageNavigator()
        {
            $result = new CompositePageNavigator($this);
            
            $partitionNavigator = new PageNavigator('pnav', $this, $this->dataset);
            $partitionNavigator->SetRowsPerPage(20);
            $result->AddPageNavigator($partitionNavigator);
            
            return $result;
        }
    
        public function GetPageList()
        {
            $currentPageCaption = $this->GetShortCaption();
            $result = new PageList($this);
            $result->AddGroup($this->RenderText('Objets'));
            $result->AddGroup($this->RenderText('Paramtres'));
            if (GetCurrentUserGrantForDataSource('vues.vm_objet_vue_de_base')->HasViewGrant())
                $result->AddPage(new PageLink($this->RenderText('Vue de base des objets'), 'vues.vm_objet_vue_de_base.php', $this->RenderText('Vue de base des objets'), $currentPageCaption == $this->RenderText('Vue de base des objets'), false, $this->RenderText('Objets')));
            if (GetCurrentUserGrantForDataSource('parametres.parametre_systeme')->HasViewGrant())
                $result->AddPage(new PageLink($this->RenderText('Paramtres'), 'parametres.parametre_systeme.php', $this->RenderText('Paramtres'), $currentPageCaption == $this->RenderText('Paramtres'), false, $this->RenderText('Paramtres')));
            if (GetCurrentUserGrantForDataSource('objets.date_objet')->HasViewGrant())
                $result->AddPage(new PageLink($this->RenderText('Dates des objets'), 'objets.date_objet.php', $this->RenderText('Dates des objets'), $currentPageCaption == $this->RenderText('Dates des objets'), false, $this->RenderText('Objets')));
            if (GetCurrentUserGrantForDataSource('objets.nom_objet')->HasViewGrant())
                $result->AddPage(new PageLink($this->RenderText('Noms des objets'), 'objets.nom_objet.php', $this->RenderText('Noms des objets'), $currentPageCaption == $this->RenderText('Noms des objets'), false, $this->RenderText('Objets')));
            if (GetCurrentUserGrantForDataSource('vues.vm_association_objets')->HasViewGrant())
                $result->AddPage(new PageLink($this->RenderText('Associations des objets source'), 'vues.vm_association_objets.php', $this->RenderText('Associations des objets source'), $currentPageCaption == $this->RenderText('Associations des objets source'), false, $this->RenderText('Objets')));
            if (GetCurrentUserGrantForDataSource('vues.vm_association_objets_inv')->HasViewGrant())
                $result->AddPage(new PageLink($this->RenderText('Associations des objets cible'), 'vues.vm_association_objets_inv.php', $this->RenderText('Associations des objets cible'), $currentPageCaption == $this->RenderText('Associations des objets cible'), false, $this->RenderText('Objets')));
            
            if ( HasAdminPage() && GetApplication()->HasAdminGrantForCurrentUser() ) {
              $result->AddGroup('Admin area');
              $result->AddPage(new PageLink($this->GetLocalizerCaptions()->GetMessageString('AdminPage'), 'phpgen_admin.php', $this->GetLocalizerCaptions()->GetMessageString('AdminPage'), false, false, 'Admin area'));
            }
            return $result;
        }
    
        protected function CreateRssGenerator()
        {
            return null;
        }
    
        protected function CreateGridSearchControl(Grid $grid)
        {
            $grid->UseFilter = true;
            $grid->SearchControl = new SimpleSearch('vues_vm_association_objets_invssearch', $this->dataset,
                array('fk_objet_cible_nom', 'date_objet_cible', 'fk_type_association_param_valeur_inverse', 'fk_objet_source_nom', 'date_objet_source', 'reference_precise_objet_source', 'libelle_original_objet_source', 'valeur_objet_source', 'fk_qualificatif_objet_source', 'fk_role_objet_source', 'fk_unite_de_mesure', 'descriptif', 'notes', 'pk_association_objets', 'date_creation', 'date_modification'),
                array($this->RenderText('Fk Objet Cible'), $this->RenderText('Date Objet Cible'), $this->RenderText('Fk Type Association Param'), $this->RenderText('Fk Objet Source'), $this->RenderText('Date Objet Source'), $this->RenderText('Reference Precise Objet Source'), $this->RenderText('Libelle Original Objet Source'), $this->RenderText('Valeur Objet Source'), $this->RenderText('Fk Qualificatif Objet Source'), $this->RenderText('Fk Role Objet Source'), $this->RenderText('Fk Unite De Mesure'), $this->RenderText('Descriptif'), $this->RenderText('Notes'), $this->RenderText('Pk Association Objets'), $this->RenderText('Date Creation'), $this->RenderText('Date Modification')),
                array(
                    '=' => $this->GetLocalizerCaptions()->GetMessageString('equals'),
                    '<>' => $this->GetLocalizerCaptions()->GetMessageString('doesNotEquals'),
                    '<' => $this->GetLocalizerCaptions()->GetMessageString('isLessThan'),
                    '<=' => $this->GetLocalizerCaptions()->GetMessageString('isLessThanOrEqualsTo'),
                    '>' => $this->GetLocalizerCaptions()->GetMessageString('isGreaterThan'),
                    '>=' => $this->GetLocalizerCaptions()->GetMessageString('isGreaterThanOrEqualsTo'),
                    'ILIKE' => $this->GetLocalizerCaptions()->GetMessageString('Like'),
                    'STARTS' => $this->GetLocalizerCaptions()->GetMessageString('StartsWith'),
                    'ENDS' => $this->GetLocalizerCaptions()->GetMessageString('EndsWith'),
                    'CONTAINS' => $this->GetLocalizerCaptions()->GetMessageString('Contains')
                    ), $this->GetLocalizerCaptions(), $this, 'CONTAINS'
                );
        }
    
        protected function CreateGridAdvancedSearchControl(Grid $grid)
        {
            $this->AdvancedSearchControl = new AdvancedSearchControl('vues_vm_association_objets_invasearch', $this->dataset, $this->GetLocalizerCaptions(), $this->GetColumnVariableContainer(), $this->CreateLinkBuilder());
            $this->AdvancedSearchControl->setTimerInterval(1000);
            $lookupDataset = new TableDataset(
                new PgConnectionFactory(),
                GetConnectionOptions(),
                '"vues"."vm_objet_vue_de_base"');
            $field = new IntegerField('pk_objet');
            $lookupDataset->AddField($field, true);
            $field = new IntegerField('fk_type_objet_param');
            $lookupDataset->AddField($field, false);
            $field = new StringField('nom');
            $lookupDataset->AddField($field, false);
            $field = new IntegerField('fk_type_nom_param');
            $lookupDataset->AddField($field, false);
            $field = new StringField('definition');
            $lookupDataset->AddField($field, false);
            $field = new StringField('date_iso');
            $lookupDataset->AddField($field, false);
            $field = new IntegerField('fk_type_date_param');
            $lookupDataset->AddField($field, false);
            $field = new StringField('certitude');
            $lookupDataset->AddField($field, false);
            $field = new IntegerField('latitude');
            $lookupDataset->AddField($field, false);
            $field = new IntegerField('longitude');
            $lookupDataset->AddField($field, false);
            $field = new StringField('genre');
            $lookupDataset->AddField($field, false);
            $field = new StringField('notes');
            $lookupDataset->AddField($field, false);
            $field = new StringField('texte');
            $lookupDataset->AddField($field, false);
            $field = new StringField('texte_xml');
            $lookupDataset->AddField($field, false);
            $field = new BooleanField('si_texte_xml');
            $lookupDataset->AddField($field, false);
            $field = new DateTimeField('date_creation');
            $lookupDataset->AddField($field, false);
            $field = new DateTimeField('date_modification');
            $lookupDataset->AddField($field, false);
            $field = new IntegerField('pk_nom_objet');
            $lookupDataset->AddField($field, false);
            $field = new IntegerField('pk_date_objet');
            $lookupDataset->AddField($field, false);
            $lookupDataset->SetOrderBy('nom', GetOrderTypeAsSQL(otAscending));
            $this->AdvancedSearchControl->AddSearchColumn($this->AdvancedSearchControl->CreateLookupSearchInput('fk_objet_cible', $this->RenderText('Fk Objet Cible'), $lookupDataset, 'pk_objet', 'nom', false, 8));
            $this->AdvancedSearchControl->AddSearchColumn($this->AdvancedSearchControl->CreateStringSearchInput('date_objet_cible', $this->RenderText('Date Objet Cible')));
            
            $lookupDataset = new TableDataset(
                new PgConnectionFactory(),
                GetConnectionOptions(),
                '"vues"."vn_types_associations_inverses_entre_objets"');
            $field = new IntegerField('pk_parametre_systeme');
            $lookupDataset->AddField($field, false);
            $field = new StringField('valeur_inverse');
            $lookupDataset->AddField($field, false);
            $lookupDataset->SetOrderBy('valeur_inverse', GetOrderTypeAsSQL(otAscending));
            $this->AdvancedSearchControl->AddSearchColumn($this->AdvancedSearchControl->CreateLookupSearchInput('fk_type_association_param', $this->RenderText('Fk Type Association Param'), $lookupDataset, 'pk_parametre_systeme', 'valeur_inverse', false, 8));
            
            $lookupDataset = new TableDataset(
                new PgConnectionFactory(),
                GetConnectionOptions(),
                '"vues"."vm_objet_vue_de_base"');
            $field = new IntegerField('pk_objet');
            $lookupDataset->AddField($field, true);
            $field = new IntegerField('fk_type_objet_param');
            $lookupDataset->AddField($field, false);
            $field = new StringField('nom');
            $lookupDataset->AddField($field, false);
            $field = new IntegerField('fk_type_nom_param');
            $lookupDataset->AddField($field, false);
            $field = new StringField('definition');
            $lookupDataset->AddField($field, false);
            $field = new StringField('date_iso');
            $lookupDataset->AddField($field, false);
            $field = new IntegerField('fk_type_date_param');
            $lookupDataset->AddField($field, false);
            $field = new StringField('certitude');
            $lookupDataset->AddField($field, false);
            $field = new IntegerField('latitude');
            $lookupDataset->AddField($field, false);
            $field = new IntegerField('longitude');
            $lookupDataset->AddField($field, false);
            $field = new StringField('genre');
            $lookupDataset->AddField($field, false);
            $field = new StringField('notes');
            $lookupDataset->AddField($field, false);
            $field = new StringField('texte');
            $lookupDataset->AddField($field, false);
            $field = new StringField('texte_xml');
            $lookupDataset->AddField($field, false);
            $field = new BooleanField('si_texte_xml');
            $lookupDataset->AddField($field, false);
            $field = new DateTimeField('date_creation');
            $lookupDataset->AddField($field, false);
            $field = new DateTimeField('date_modification');
            $lookupDataset->AddField($field, false);
            $field = new IntegerField('pk_nom_objet');
            $lookupDataset->AddField($field, false);
            $field = new IntegerField('pk_date_objet');
            $lookupDataset->AddField($field, false);
            $lookupDataset->SetOrderBy('nom', GetOrderTypeAsSQL(otAscending));
            $this->AdvancedSearchControl->AddSearchColumn($this->AdvancedSearchControl->CreateLookupSearchInput('fk_objet_source', $this->RenderText('Fk Objet Source'), $lookupDataset, 'pk_objet', 'nom', false, 8));
            $this->AdvancedSearchControl->AddSearchColumn($this->AdvancedSearchControl->CreateStringSearchInput('date_objet_source', $this->RenderText('Date Objet Source')));
            $this->AdvancedSearchControl->AddSearchColumn($this->AdvancedSearchControl->CreateStringSearchInput('reference_precise_objet_source', $this->RenderText('Reference Precise Objet Source')));
            $this->AdvancedSearchControl->AddSearchColumn($this->AdvancedSearchControl->CreateStringSearchInput('libelle_original_objet_source', $this->RenderText('Libelle Original Objet Source')));
            $this->AdvancedSearchControl->AddSearchColumn($this->AdvancedSearchControl->CreateStringSearchInput('valeur_objet_source', $this->RenderText('Valeur Objet Source')));
            $this->AdvancedSearchControl->AddSearchColumn($this->AdvancedSearchControl->CreateStringSearchInput('fk_qualificatif_objet_source', $this->RenderText('Fk Qualificatif Objet Source')));
            $this->AdvancedSearchControl->AddSearchColumn($this->AdvancedSearchControl->CreateStringSearchInput('fk_role_objet_source', $this->RenderText('Fk Role Objet Source')));
            $this->AdvancedSearchControl->AddSearchColumn($this->AdvancedSearchControl->CreateStringSearchInput('fk_unite_de_mesure', $this->RenderText('Fk Unite De Mesure')));
            $this->AdvancedSearchControl->AddSearchColumn($this->AdvancedSearchControl->CreateStringSearchInput('descriptif', $this->RenderText('Descriptif')));
            $this->AdvancedSearchControl->AddSearchColumn($this->AdvancedSearchControl->CreateStringSearchInput('notes', $this->RenderText('Notes')));
            $this->AdvancedSearchControl->AddSearchColumn($this->AdvancedSearchControl->CreateStringSearchInput('pk_association_objets', $this->RenderText('Pk Association Objets')));
            $this->AdvancedSearchControl->AddSearchColumn($this->AdvancedSearchControl->CreateDateTimeSearchInput('date_creation', $this->RenderText('Date Creation'), 'Y-m-d H:i:s'));
            $this->AdvancedSearchControl->AddSearchColumn($this->AdvancedSearchControl->CreateDateTimeSearchInput('date_modification', $this->RenderText('Date Modification'), 'Y-m-d H:i:s'));
        }
    
        protected function AddOperationsColumns(Grid $grid)
        {
            $actionsBandName = 'actions';
            $grid->AddBandToBegin($actionsBandName, $this->GetLocalizerCaptions()->GetMessageString('Actions'), true);
            if ($this->GetSecurityInfo()->HasEditGrant())
            {
                $column = new ModalDialogEditRowColumn(
                    $this->GetLocalizerCaptions()->GetMessageString('Edit'), $this->dataset,
                    $this->GetLocalizerCaptions()->GetMessageString('Edit'),
                    $this->GetModalGridEditingHandler());
                $grid->AddViewColumn($column, $actionsBandName);
                $column->SetImagePath('images/edit_action.png');
                $column->OnShow->AddListener('ShowEditButtonHandler', $this);
            }
            if ($this->GetSecurityInfo()->HasDeleteGrant())
            {
                $column = new RowOperationByLinkColumn($this->GetLocalizerCaptions()->GetMessageString('Delete'), OPERATION_DELETE, $this->dataset);
                $grid->AddViewColumn($column, $actionsBandName);
                $column->SetImagePath('images/delete_action.png');
                $column->OnShow->AddListener('ShowDeleteButtonHandler', $this);
                $column->SetAdditionalAttribute('data-modal-delete', 'true');
                $column->SetAdditionalAttribute('data-delete-handler-name', $this->GetModalGridDeleteHandler());
            }
        }
    
        protected function AddFieldColumns(Grid $grid)
        {
            //
            // View column for nom field
            //
            $column = new TextViewColumn('fk_objet_cible_nom', 'Fk Objet Cible', $this->dataset);
            $column->SetOrderable(true);
            $column = new ExtendedHyperLinkColumnDecorator($column, $this->dataset, 'vues.vm_objet_vue_de_base.php?hname=objets_date_objetDetailEdit0vues_vm_objet_vue_de_base_handler&fk0=%fk_objet_cible%' , '_blank');
            $column->SetDescription($this->RenderText(''));
            $column->SetFixedWidth(null);
            $grid->AddViewColumn($column);
            
            //
            // View column for date_objet_cible field
            //
            $column = new TextViewColumn('date_objet_cible', 'Date Objet Cible', $this->dataset);
            $column->SetOrderable(true);
            $column->SetDescription($this->RenderText(''));
            $column->SetFixedWidth(null);
            $grid->AddViewColumn($column);
            
            //
            // View column for valeur_inverse field
            //
            $column = new TextViewColumn('fk_type_association_param_valeur_inverse', 'Fk Type Association Param', $this->dataset);
            $column->SetOrderable(true);
            $column->SetDescription($this->RenderText(''));
            $column->SetFixedWidth(null);
            $grid->AddViewColumn($column);
            
            //
            // View column for nom field
            //
            $column = new TextViewColumn('fk_objet_source_nom', 'Fk Objet Source', $this->dataset);
            $column->SetOrderable(true);
            $column = new ExtendedHyperLinkColumnDecorator($column, $this->dataset, 'vues.vm_objet_vue_de_base.php?hname=objets_date_objetDetailEdit0vues_vm_objet_vue_de_base_handler&fk0=%fk_objet_source%' , '_blank');
            $column->SetDescription($this->RenderText(''));
            $column->SetFixedWidth(null);
            $grid->AddViewColumn($column);
            
            //
            // View column for date_objet_source field
            //
            $column = new TextViewColumn('date_objet_source', 'Date Objet Source', $this->dataset);
            $column->SetOrderable(true);
            $column->SetDescription($this->RenderText(''));
            $column->SetFixedWidth(null);
            $grid->AddViewColumn($column);
            
            //
            // View column for reference_precise_objet_source field
            //
            $column = new TextViewColumn('reference_precise_objet_source', 'Reference Precise Objet Source', $this->dataset);
            $column->SetOrderable(true);
            $column->SetMaxLength(75);
            $column->SetFullTextWindowHandlerName('vues_vm_association_objets_invGrid_reference_precise_objet_source_handler_list');
            $column->SetDescription($this->RenderText(''));
            $column->SetFixedWidth(null);
            $grid->AddViewColumn($column);
            
            //
            // View column for libelle_original_objet_source field
            //
            $column = new TextViewColumn('libelle_original_objet_source', 'Libelle Original Objet Source', $this->dataset);
            $column->SetOrderable(true);
            $column->SetMaxLength(75);
            $column->SetFullTextWindowHandlerName('vues_vm_association_objets_invGrid_libelle_original_objet_source_handler_list');
            $column->SetDescription($this->RenderText(''));
            $column->SetFixedWidth(null);
            $grid->AddViewColumn($column);
            
            //
            // View column for valeur_objet_source field
            //
            $column = new TextViewColumn('valeur_objet_source', 'Valeur Objet Source', $this->dataset);
            $column->SetOrderable(true);
            $column = new NumberFormatValueViewColumnDecorator($column, 4, ',', '.');
            $column->SetDescription($this->RenderText(''));
            $column->SetFixedWidth(null);
            $grid->AddViewColumn($column);
            
            //
            // View column for fk_qualificatif_objet_source field
            //
            $column = new TextViewColumn('fk_qualificatif_objet_source', 'Fk Qualificatif Objet Source', $this->dataset);
            $column->SetOrderable(true);
            $column->SetDescription($this->RenderText(''));
            $column->SetFixedWidth(null);
            $grid->AddViewColumn($column);
            
            //
            // View column for fk_role_objet_source field
            //
            $column = new TextViewColumn('fk_role_objet_source', 'Fk Role Objet Source', $this->dataset);
            $column->SetOrderable(true);
            $column->SetDescription($this->RenderText(''));
            $column->SetFixedWidth(null);
            $grid->AddViewColumn($column);
            
            //
            // View column for fk_unite_de_mesure field
            //
            $column = new TextViewColumn('fk_unite_de_mesure', 'Fk Unite De Mesure', $this->dataset);
            $column->SetOrderable(true);
            $column->SetDescription($this->RenderText(''));
            $column->SetFixedWidth(null);
            $grid->AddViewColumn($column);
            
            //
            // View column for descriptif field
            //
            $column = new TextViewColumn('descriptif', 'Descriptif', $this->dataset);
            $column->SetOrderable(true);
            $column->SetMaxLength(75);
            $column->SetFullTextWindowHandlerName('vues_vm_association_objets_invGrid_descriptif_handler_list');
            $column->SetDescription($this->RenderText(''));
            $column->SetFixedWidth(null);
            $grid->AddViewColumn($column);
            
            //
            // View column for notes field
            //
            $column = new TextViewColumn('notes', 'Notes', $this->dataset);
            $column->SetOrderable(true);
            $column->SetMaxLength(75);
            $column->SetFullTextWindowHandlerName('vues_vm_association_objets_invGrid_notes_handler_list');
            $column->SetDescription($this->RenderText(''));
            $column->SetFixedWidth(null);
            $grid->AddViewColumn($column);
            
            //
            // View column for pk_association_objets field
            //
            $column = new TextViewColumn('pk_association_objets', 'Pk Association Objets', $this->dataset);
            $column->SetOrderable(true);
            $column->SetDescription($this->RenderText(''));
            $column->SetFixedWidth(null);
            $grid->AddViewColumn($column);
            
            //
            // View column for date_creation field
            //
            $column = new DateTimeViewColumn('date_creation', 'Date Creation', $this->dataset);
            $column->SetDateTimeFormat('Y-m-d H:i:s');
            $column->SetOrderable(true);
            $column->SetDescription($this->RenderText(''));
            $column->SetFixedWidth(null);
            $grid->AddViewColumn($column);
            
            //
            // View column for date_modification field
            //
            $column = new DateTimeViewColumn('date_modification', 'Date Modification', $this->dataset);
            $column->SetDateTimeFormat('Y-m-d H:i:s');
            $column->SetOrderable(true);
            $column->SetDescription($this->RenderText(''));
            $column->SetFixedWidth(null);
            $grid->AddViewColumn($column);
        }
    
        protected function AddSingleRecordViewColumns(Grid $grid)
        {
            //
            // View column for nom field
            //
            $column = new TextViewColumn('fk_objet_cible_nom', 'Fk Objet Cible', $this->dataset);
            $column->SetOrderable(true);
            $column = new ExtendedHyperLinkColumnDecorator($column, $this->dataset, 'vues.vm_objet_vue_de_base.php?hname=objets_date_objetDetailEdit0vues_vm_objet_vue_de_base_handler&fk0=%fk_objet_cible%' , '_blank');
            $grid->AddSingleRecordViewColumn($column);
            
            //
            // View column for date_objet_cible field
            //
            $column = new TextViewColumn('date_objet_cible', 'Date Objet Cible', $this->dataset);
            $column->SetOrderable(true);
            $grid->AddSingleRecordViewColumn($column);
            
            //
            // View column for valeur_inverse field
            //
            $column = new TextViewColumn('fk_type_association_param_valeur_inverse', 'Fk Type Association Param', $this->dataset);
            $column->SetOrderable(true);
            $grid->AddSingleRecordViewColumn($column);
            
            //
            // View column for nom field
            //
            $column = new TextViewColumn('fk_objet_source_nom', 'Fk Objet Source', $this->dataset);
            $column->SetOrderable(true);
            $column = new ExtendedHyperLinkColumnDecorator($column, $this->dataset, 'vues.vm_objet_vue_de_base.php?hname=objets_date_objetDetailEdit0vues_vm_objet_vue_de_base_handler&fk0=%fk_objet_source%' , '_blank');
            $grid->AddSingleRecordViewColumn($column);
            
            //
            // View column for date_objet_source field
            //
            $column = new TextViewColumn('date_objet_source', 'Date Objet Source', $this->dataset);
            $column->SetOrderable(true);
            $grid->AddSingleRecordViewColumn($column);
            
            //
            // View column for reference_precise_objet_source field
            //
            $column = new TextViewColumn('reference_precise_objet_source', 'Reference Precise Objet Source', $this->dataset);
            $column->SetOrderable(true);
            $column->SetMaxLength(75);
            $column->SetFullTextWindowHandlerName('vues_vm_association_objets_invGrid_reference_precise_objet_source_handler_view');
            $grid->AddSingleRecordViewColumn($column);
            
            //
            // View column for libelle_original_objet_source field
            //
            $column = new TextViewColumn('libelle_original_objet_source', 'Libelle Original Objet Source', $this->dataset);
            $column->SetOrderable(true);
            $column->SetMaxLength(75);
            $column->SetFullTextWindowHandlerName('vues_vm_association_objets_invGrid_libelle_original_objet_source_handler_view');
            $grid->AddSingleRecordViewColumn($column);
            
            //
            // View column for valeur_objet_source field
            //
            $column = new TextViewColumn('valeur_objet_source', 'Valeur Objet Source', $this->dataset);
            $column->SetOrderable(true);
            $column = new NumberFormatValueViewColumnDecorator($column, 4, ',', '.');
            $grid->AddSingleRecordViewColumn($column);
            
            //
            // View column for fk_qualificatif_objet_source field
            //
            $column = new TextViewColumn('fk_qualificatif_objet_source', 'Fk Qualificatif Objet Source', $this->dataset);
            $column->SetOrderable(true);
            $grid->AddSingleRecordViewColumn($column);
            
            //
            // View column for fk_role_objet_source field
            //
            $column = new TextViewColumn('fk_role_objet_source', 'Fk Role Objet Source', $this->dataset);
            $column->SetOrderable(true);
            $grid->AddSingleRecordViewColumn($column);
            
            //
            // View column for fk_unite_de_mesure field
            //
            $column = new TextViewColumn('fk_unite_de_mesure', 'Fk Unite De Mesure', $this->dataset);
            $column->SetOrderable(true);
            $grid->AddSingleRecordViewColumn($column);
            
            //
            // View column for descriptif field
            //
            $column = new TextViewColumn('descriptif', 'Descriptif', $this->dataset);
            $column->SetOrderable(true);
            $column->SetMaxLength(75);
            $column->SetFullTextWindowHandlerName('vues_vm_association_objets_invGrid_descriptif_handler_view');
            $grid->AddSingleRecordViewColumn($column);
            
            //
            // View column for notes field
            //
            $column = new TextViewColumn('notes', 'Notes', $this->dataset);
            $column->SetOrderable(true);
            $column->SetMaxLength(75);
            $column->SetFullTextWindowHandlerName('vues_vm_association_objets_invGrid_notes_handler_view');
            $grid->AddSingleRecordViewColumn($column);
            
            //
            // View column for pk_association_objets field
            //
            $column = new TextViewColumn('pk_association_objets', 'Pk Association Objets', $this->dataset);
            $column->SetOrderable(true);
            $grid->AddSingleRecordViewColumn($column);
            
            //
            // View column for date_creation field
            //
            $column = new DateTimeViewColumn('date_creation', 'Date Creation', $this->dataset);
            $column->SetDateTimeFormat('Y-m-d H:i:s');
            $column->SetOrderable(true);
            $grid->AddSingleRecordViewColumn($column);
            
            //
            // View column for date_modification field
            //
            $column = new DateTimeViewColumn('date_modification', 'Date Modification', $this->dataset);
            $column->SetDateTimeFormat('Y-m-d H:i:s');
            $column->SetOrderable(true);
            $grid->AddSingleRecordViewColumn($column);
        }
    
        protected function AddEditColumns(Grid $grid)
        {
            //
            // Edit column for fk_objet_cible field
            //
            $editor = new ComboBox('fk_objet_cible_edit', $this->GetLocalizerCaptions()->GetMessageString('PleaseSelect'));
            $lookupDataset = new TableDataset(
                new PgConnectionFactory(),
                GetConnectionOptions(),
                '"vues"."vm_objet_vue_de_base"');
            $field = new IntegerField('pk_objet');
            $lookupDataset->AddField($field, true);
            $field = new IntegerField('fk_type_objet_param');
            $lookupDataset->AddField($field, false);
            $field = new StringField('nom');
            $lookupDataset->AddField($field, false);
            $field = new IntegerField('fk_type_nom_param');
            $lookupDataset->AddField($field, false);
            $field = new StringField('definition');
            $lookupDataset->AddField($field, false);
            $field = new StringField('date_iso');
            $lookupDataset->AddField($field, false);
            $field = new IntegerField('fk_type_date_param');
            $lookupDataset->AddField($field, false);
            $field = new StringField('certitude');
            $lookupDataset->AddField($field, false);
            $field = new IntegerField('latitude');
            $lookupDataset->AddField($field, false);
            $field = new IntegerField('longitude');
            $lookupDataset->AddField($field, false);
            $field = new StringField('genre');
            $lookupDataset->AddField($field, false);
            $field = new StringField('notes');
            $lookupDataset->AddField($field, false);
            $field = new StringField('texte');
            $lookupDataset->AddField($field, false);
            $field = new StringField('texte_xml');
            $lookupDataset->AddField($field, false);
            $field = new BooleanField('si_texte_xml');
            $lookupDataset->AddField($field, false);
            $field = new DateTimeField('date_creation');
            $lookupDataset->AddField($field, false);
            $field = new DateTimeField('date_modification');
            $lookupDataset->AddField($field, false);
            $field = new IntegerField('pk_nom_objet');
            $lookupDataset->AddField($field, false);
            $field = new IntegerField('pk_date_objet');
            $lookupDataset->AddField($field, false);
            $lookupDataset->SetOrderBy('nom', GetOrderTypeAsSQL(otAscending));
            $editColumn = new LookUpEditColumn(
                'Fk Objet Cible', 
                'fk_objet_cible', 
                $editor, 
                $this->dataset, 'pk_objet', 'nom', $lookupDataset);
            $editColumn->SetAllowSetToNull(true);
            $this->ApplyCommonColumnEditProperties($editColumn);
            $grid->AddEditColumn($editColumn);
            
            //
            // Edit column for date_objet_cible field
            //
            $editor = new TextEdit('date_objet_cible_edit');
            $editColumn = new CustomEditColumn('Date Objet Cible', 'date_objet_cible', $editor, $this->dataset);
            $editColumn->SetAllowSetToNull(true);
            $this->ApplyCommonColumnEditProperties($editColumn);
            $grid->AddEditColumn($editColumn);
            
            //
            // Edit column for fk_type_association_param field
            //
            $editor = new ComboBox('fk_type_association_param_edit', $this->GetLocalizerCaptions()->GetMessageString('PleaseSelect'));
            $lookupDataset = new TableDataset(
                new PgConnectionFactory(),
                GetConnectionOptions(),
                '"vues"."vn_types_associations_inverses_entre_objets"');
            $field = new IntegerField('pk_parametre_systeme');
            $lookupDataset->AddField($field, false);
            $field = new StringField('valeur_inverse');
            $lookupDataset->AddField($field, false);
            $lookupDataset->SetOrderBy('valeur_inverse', GetOrderTypeAsSQL(otAscending));
            $editColumn = new LookUpEditColumn(
                'Fk Type Association Param', 
                'fk_type_association_param', 
                $editor, 
                $this->dataset, 'pk_parametre_systeme', 'valeur_inverse', $lookupDataset);
            $editColumn->SetAllowSetToNull(true);
            $this->ApplyCommonColumnEditProperties($editColumn);
            $grid->AddEditColumn($editColumn);
            
            //
            // Edit column for fk_objet_source field
            //
            $editor = new ComboBox('fk_objet_source_edit', $this->GetLocalizerCaptions()->GetMessageString('PleaseSelect'));
            $lookupDataset = new TableDataset(
                new PgConnectionFactory(),
                GetConnectionOptions(),
                '"vues"."vm_objet_vue_de_base"');
            $field = new IntegerField('pk_objet');
            $lookupDataset->AddField($field, true);
            $field = new IntegerField('fk_type_objet_param');
            $lookupDataset->AddField($field, false);
            $field = new StringField('nom');
            $lookupDataset->AddField($field, false);
            $field = new IntegerField('fk_type_nom_param');
            $lookupDataset->AddField($field, false);
            $field = new StringField('definition');
            $lookupDataset->AddField($field, false);
            $field = new StringField('date_iso');
            $lookupDataset->AddField($field, false);
            $field = new IntegerField('fk_type_date_param');
            $lookupDataset->AddField($field, false);
            $field = new StringField('certitude');
            $lookupDataset->AddField($field, false);
            $field = new IntegerField('latitude');
            $lookupDataset->AddField($field, false);
            $field = new IntegerField('longitude');
            $lookupDataset->AddField($field, false);
            $field = new StringField('genre');
            $lookupDataset->AddField($field, false);
            $field = new StringField('notes');
            $lookupDataset->AddField($field, false);
            $field = new StringField('texte');
            $lookupDataset->AddField($field, false);
            $field = new StringField('texte_xml');
            $lookupDataset->AddField($field, false);
            $field = new BooleanField('si_texte_xml');
            $lookupDataset->AddField($field, false);
            $field = new DateTimeField('date_creation');
            $lookupDataset->AddField($field, false);
            $field = new DateTimeField('date_modification');
            $lookupDataset->AddField($field, false);
            $field = new IntegerField('pk_nom_objet');
            $lookupDataset->AddField($field, false);
            $field = new IntegerField('pk_date_objet');
            $lookupDataset->AddField($field, false);
            $lookupDataset->SetOrderBy('nom', GetOrderTypeAsSQL(otAscending));
            $editColumn = new LookUpEditColumn(
                'Fk Objet Source', 
                'fk_objet_source', 
                $editor, 
                $this->dataset, 'pk_objet', 'nom', $lookupDataset);
            $editColumn->SetAllowSetToNull(true);
            $this->ApplyCommonColumnEditProperties($editColumn);
            $grid->AddEditColumn($editColumn);
            
            //
            // Edit column for date_objet_source field
            //
            $editor = new TextEdit('date_objet_source_edit');
            $editColumn = new CustomEditColumn('Date Objet Source', 'date_objet_source', $editor, $this->dataset);
            $editColumn->SetAllowSetToNull(true);
            $this->ApplyCommonColumnEditProperties($editColumn);
            $grid->AddEditColumn($editColumn);
            
            //
            // Edit column for reference_precise_objet_source field
            //
            $editor = new TextAreaEdit('reference_precise_objet_source_edit', 50, 8);
            $editColumn = new CustomEditColumn('Reference Precise Objet Source', 'reference_precise_objet_source', $editor, $this->dataset);
            $editColumn->SetAllowSetToNull(true);
            $this->ApplyCommonColumnEditProperties($editColumn);
            $grid->AddEditColumn($editColumn);
            
            //
            // Edit column for libelle_original_objet_source field
            //
            $editor = new TextAreaEdit('libelle_original_objet_source_edit', 50, 8);
            $editColumn = new CustomEditColumn('Libelle Original Objet Source', 'libelle_original_objet_source', $editor, $this->dataset);
            $editColumn->SetAllowSetToNull(true);
            $this->ApplyCommonColumnEditProperties($editColumn);
            $grid->AddEditColumn($editColumn);
            
            //
            // Edit column for valeur_objet_source field
            //
            $editor = new TextEdit('valeur_objet_source_edit');
            $editColumn = new CustomEditColumn('Valeur Objet Source', 'valeur_objet_source', $editor, $this->dataset);
            $editColumn->SetAllowSetToNull(true);
            $this->ApplyCommonColumnEditProperties($editColumn);
            $grid->AddEditColumn($editColumn);
            
            //
            // Edit column for fk_qualificatif_objet_source field
            //
            $editor = new TextEdit('fk_qualificatif_objet_source_edit');
            $editColumn = new CustomEditColumn('Fk Qualificatif Objet Source', 'fk_qualificatif_objet_source', $editor, $this->dataset);
            $editColumn->SetAllowSetToNull(true);
            $this->ApplyCommonColumnEditProperties($editColumn);
            $grid->AddEditColumn($editColumn);
            
            //
            // Edit column for fk_role_objet_source field
            //
            $editor = new TextEdit('fk_role_objet_source_edit');
            $editColumn = new CustomEditColumn('Fk Role Objet Source', 'fk_role_objet_source', $editor, $this->dataset);
            $editColumn->SetAllowSetToNull(true);
            $this->ApplyCommonColumnEditProperties($editColumn);
            $grid->AddEditColumn($editColumn);
            
            //
            // Edit column for fk_unite_de_mesure field
            //
            $editor = new TextEdit('fk_unite_de_mesure_edit');
            $editColumn = new CustomEditColumn('Fk Unite De Mesure', 'fk_unite_de_mesure', $editor, $this->dataset);
            $editColumn->SetAllowSetToNull(true);
            $this->ApplyCommonColumnEditProperties($editColumn);
            $grid->AddEditColumn($editColumn);
            
            //
            // Edit column for descriptif field
            //
            $editor = new TextAreaEdit('descriptif_edit', 50, 8);
            $editColumn = new CustomEditColumn('Descriptif', 'descriptif', $editor, $this->dataset);
            $editColumn->SetAllowSetToNull(true);
            $this->ApplyCommonColumnEditProperties($editColumn);
            $grid->AddEditColumn($editColumn);
            
            //
            // Edit column for notes field
            //
            $editor = new TextAreaEdit('notes_edit', 50, 8);
            $editColumn = new CustomEditColumn('Notes', 'notes', $editor, $this->dataset);
            $editColumn->SetAllowSetToNull(true);
            $this->ApplyCommonColumnEditProperties($editColumn);
            $grid->AddEditColumn($editColumn);
            
            //
            // Edit column for pk_association_objets field
            //
            $editor = new TextEdit('pk_association_objets_edit');
            $editColumn = new CustomEditColumn('Pk Association Objets', 'pk_association_objets', $editor, $this->dataset);
            $editColumn->SetAllowSetToNull(true);
            $this->ApplyCommonColumnEditProperties($editColumn);
            $grid->AddEditColumn($editColumn);
            
            //
            // Edit column for date_creation field
            //
            $editor = new DateTimeEdit('date_creation_edit', true, 'Y-m-d H:i:s', GetFirstDayOfWeek());
            $editColumn = new CustomEditColumn('Date Creation', 'date_creation', $editor, $this->dataset);
            $editColumn->SetAllowSetToNull(true);
            $this->ApplyCommonColumnEditProperties($editColumn);
            $grid->AddEditColumn($editColumn);
            
            //
            // Edit column for date_modification field
            //
            $editor = new DateTimeEdit('date_modification_edit', true, 'Y-m-d H:i:s', GetFirstDayOfWeek());
            $editColumn = new CustomEditColumn('Date Modification', 'date_modification', $editor, $this->dataset);
            $editColumn->SetAllowSetToNull(true);
            $this->ApplyCommonColumnEditProperties($editColumn);
            $grid->AddEditColumn($editColumn);
        }
    
        protected function AddInsertColumns(Grid $grid)
        {
            //
            // Edit column for fk_objet_cible field
            //
            $editor = new ComboBox('fk_objet_cible_edit', $this->GetLocalizerCaptions()->GetMessageString('PleaseSelect'));
            $lookupDataset = new TableDataset(
                new PgConnectionFactory(),
                GetConnectionOptions(),
                '"vues"."vm_objet_vue_de_base"');
            $field = new IntegerField('pk_objet');
            $lookupDataset->AddField($field, true);
            $field = new IntegerField('fk_type_objet_param');
            $lookupDataset->AddField($field, false);
            $field = new StringField('nom');
            $lookupDataset->AddField($field, false);
            $field = new IntegerField('fk_type_nom_param');
            $lookupDataset->AddField($field, false);
            $field = new StringField('definition');
            $lookupDataset->AddField($field, false);
            $field = new StringField('date_iso');
            $lookupDataset->AddField($field, false);
            $field = new IntegerField('fk_type_date_param');
            $lookupDataset->AddField($field, false);
            $field = new StringField('certitude');
            $lookupDataset->AddField($field, false);
            $field = new IntegerField('latitude');
            $lookupDataset->AddField($field, false);
            $field = new IntegerField('longitude');
            $lookupDataset->AddField($field, false);
            $field = new StringField('genre');
            $lookupDataset->AddField($field, false);
            $field = new StringField('notes');
            $lookupDataset->AddField($field, false);
            $field = new StringField('texte');
            $lookupDataset->AddField($field, false);
            $field = new StringField('texte_xml');
            $lookupDataset->AddField($field, false);
            $field = new BooleanField('si_texte_xml');
            $lookupDataset->AddField($field, false);
            $field = new DateTimeField('date_creation');
            $lookupDataset->AddField($field, false);
            $field = new DateTimeField('date_modification');
            $lookupDataset->AddField($field, false);
            $field = new IntegerField('pk_nom_objet');
            $lookupDataset->AddField($field, false);
            $field = new IntegerField('pk_date_objet');
            $lookupDataset->AddField($field, false);
            $lookupDataset->SetOrderBy('nom', GetOrderTypeAsSQL(otAscending));
            $editColumn = new LookUpEditColumn(
                'Fk Objet Cible', 
                'fk_objet_cible', 
                $editor, 
                $this->dataset, 'pk_objet', 'nom', $lookupDataset);
            $editColumn->SetAllowSetToNull(true);
            $this->ApplyCommonColumnEditProperties($editColumn);
            $grid->AddInsertColumn($editColumn);
            
            //
            // Edit column for date_objet_cible field
            //
            $editor = new TextEdit('date_objet_cible_edit');
            $editColumn = new CustomEditColumn('Date Objet Cible', 'date_objet_cible', $editor, $this->dataset);
            $editColumn->SetAllowSetToNull(true);
            $this->ApplyCommonColumnEditProperties($editColumn);
            $grid->AddInsertColumn($editColumn);
            
            //
            // Edit column for fk_type_association_param field
            //
            $editor = new ComboBox('fk_type_association_param_edit', $this->GetLocalizerCaptions()->GetMessageString('PleaseSelect'));
            $lookupDataset = new TableDataset(
                new PgConnectionFactory(),
                GetConnectionOptions(),
                '"vues"."vn_types_associations_inverses_entre_objets"');
            $field = new IntegerField('pk_parametre_systeme');
            $lookupDataset->AddField($field, false);
            $field = new StringField('valeur_inverse');
            $lookupDataset->AddField($field, false);
            $lookupDataset->SetOrderBy('valeur_inverse', GetOrderTypeAsSQL(otAscending));
            $editColumn = new LookUpEditColumn(
                'Fk Type Association Param', 
                'fk_type_association_param', 
                $editor, 
                $this->dataset, 'pk_parametre_systeme', 'valeur_inverse', $lookupDataset);
            $editColumn->SetAllowSetToNull(true);
            $this->ApplyCommonColumnEditProperties($editColumn);
            $grid->AddInsertColumn($editColumn);
            
            //
            // Edit column for fk_objet_source field
            //
            $editor = new ComboBox('fk_objet_source_edit', $this->GetLocalizerCaptions()->GetMessageString('PleaseSelect'));
            $lookupDataset = new TableDataset(
                new PgConnectionFactory(),
                GetConnectionOptions(),
                '"vues"."vm_objet_vue_de_base"');
            $field = new IntegerField('pk_objet');
            $lookupDataset->AddField($field, true);
            $field = new IntegerField('fk_type_objet_param');
            $lookupDataset->AddField($field, false);
            $field = new StringField('nom');
            $lookupDataset->AddField($field, false);
            $field = new IntegerField('fk_type_nom_param');
            $lookupDataset->AddField($field, false);
            $field = new StringField('definition');
            $lookupDataset->AddField($field, false);
            $field = new StringField('date_iso');
            $lookupDataset->AddField($field, false);
            $field = new IntegerField('fk_type_date_param');
            $lookupDataset->AddField($field, false);
            $field = new StringField('certitude');
            $lookupDataset->AddField($field, false);
            $field = new IntegerField('latitude');
            $lookupDataset->AddField($field, false);
            $field = new IntegerField('longitude');
            $lookupDataset->AddField($field, false);
            $field = new StringField('genre');
            $lookupDataset->AddField($field, false);
            $field = new StringField('notes');
            $lookupDataset->AddField($field, false);
            $field = new StringField('texte');
            $lookupDataset->AddField($field, false);
            $field = new StringField('texte_xml');
            $lookupDataset->AddField($field, false);
            $field = new BooleanField('si_texte_xml');
            $lookupDataset->AddField($field, false);
            $field = new DateTimeField('date_creation');
            $lookupDataset->AddField($field, false);
            $field = new DateTimeField('date_modification');
            $lookupDataset->AddField($field, false);
            $field = new IntegerField('pk_nom_objet');
            $lookupDataset->AddField($field, false);
            $field = new IntegerField('pk_date_objet');
            $lookupDataset->AddField($field, false);
            $lookupDataset->SetOrderBy('nom', GetOrderTypeAsSQL(otAscending));
            $editColumn = new LookUpEditColumn(
                'Fk Objet Source', 
                'fk_objet_source', 
                $editor, 
                $this->dataset, 'pk_objet', 'nom', $lookupDataset);
            $editColumn->SetAllowSetToNull(true);
            $this->ApplyCommonColumnEditProperties($editColumn);
            $grid->AddInsertColumn($editColumn);
            
            //
            // Edit column for date_objet_source field
            //
            $editor = new TextEdit('date_objet_source_edit');
            $editColumn = new CustomEditColumn('Date Objet Source', 'date_objet_source', $editor, $this->dataset);
            $editColumn->SetAllowSetToNull(true);
            $this->ApplyCommonColumnEditProperties($editColumn);
            $grid->AddInsertColumn($editColumn);
            
            //
            // Edit column for reference_precise_objet_source field
            //
            $editor = new TextAreaEdit('reference_precise_objet_source_edit', 50, 8);
            $editColumn = new CustomEditColumn('Reference Precise Objet Source', 'reference_precise_objet_source', $editor, $this->dataset);
            $editColumn->SetAllowSetToNull(true);
            $this->ApplyCommonColumnEditProperties($editColumn);
            $grid->AddInsertColumn($editColumn);
            
            //
            // Edit column for libelle_original_objet_source field
            //
            $editor = new TextAreaEdit('libelle_original_objet_source_edit', 50, 8);
            $editColumn = new CustomEditColumn('Libelle Original Objet Source', 'libelle_original_objet_source', $editor, $this->dataset);
            $editColumn->SetAllowSetToNull(true);
            $this->ApplyCommonColumnEditProperties($editColumn);
            $grid->AddInsertColumn($editColumn);
            
            //
            // Edit column for valeur_objet_source field
            //
            $editor = new TextEdit('valeur_objet_source_edit');
            $editColumn = new CustomEditColumn('Valeur Objet Source', 'valeur_objet_source', $editor, $this->dataset);
            $editColumn->SetAllowSetToNull(true);
            $this->ApplyCommonColumnEditProperties($editColumn);
            $grid->AddInsertColumn($editColumn);
            
            //
            // Edit column for fk_qualificatif_objet_source field
            //
            $editor = new TextEdit('fk_qualificatif_objet_source_edit');
            $editColumn = new CustomEditColumn('Fk Qualificatif Objet Source', 'fk_qualificatif_objet_source', $editor, $this->dataset);
            $editColumn->SetAllowSetToNull(true);
            $this->ApplyCommonColumnEditProperties($editColumn);
            $grid->AddInsertColumn($editColumn);
            
            //
            // Edit column for fk_role_objet_source field
            //
            $editor = new TextEdit('fk_role_objet_source_edit');
            $editColumn = new CustomEditColumn('Fk Role Objet Source', 'fk_role_objet_source', $editor, $this->dataset);
            $editColumn->SetAllowSetToNull(true);
            $this->ApplyCommonColumnEditProperties($editColumn);
            $grid->AddInsertColumn($editColumn);
            
            //
            // Edit column for fk_unite_de_mesure field
            //
            $editor = new TextEdit('fk_unite_de_mesure_edit');
            $editColumn = new CustomEditColumn('Fk Unite De Mesure', 'fk_unite_de_mesure', $editor, $this->dataset);
            $editColumn->SetAllowSetToNull(true);
            $this->ApplyCommonColumnEditProperties($editColumn);
            $grid->AddInsertColumn($editColumn);
            
            //
            // Edit column for descriptif field
            //
            $editor = new TextAreaEdit('descriptif_edit', 50, 8);
            $editColumn = new CustomEditColumn('Descriptif', 'descriptif', $editor, $this->dataset);
            $editColumn->SetAllowSetToNull(true);
            $this->ApplyCommonColumnEditProperties($editColumn);
            $grid->AddInsertColumn($editColumn);
            
            //
            // Edit column for notes field
            //
            $editor = new TextAreaEdit('notes_edit', 50, 8);
            $editColumn = new CustomEditColumn('Notes', 'notes', $editor, $this->dataset);
            $editColumn->SetAllowSetToNull(true);
            $this->ApplyCommonColumnEditProperties($editColumn);
            $grid->AddInsertColumn($editColumn);
            
            //
            // Edit column for pk_association_objets field
            //
            $editor = new TextEdit('pk_association_objets_edit');
            $editColumn = new CustomEditColumn('Pk Association Objets', 'pk_association_objets', $editor, $this->dataset);
            $editColumn->SetAllowSetToNull(true);
            $this->ApplyCommonColumnEditProperties($editColumn);
            $grid->AddInsertColumn($editColumn);
            
            //
            // Edit column for date_creation field
            //
            $editor = new DateTimeEdit('date_creation_edit', true, 'Y-m-d H:i:s', GetFirstDayOfWeek());
            $editColumn = new CustomEditColumn('Date Creation', 'date_creation', $editor, $this->dataset);
            $editColumn->SetAllowSetToNull(true);
            $this->ApplyCommonColumnEditProperties($editColumn);
            $grid->AddInsertColumn($editColumn);
            
            //
            // Edit column for date_modification field
            //
            $editor = new DateTimeEdit('date_modification_edit', true, 'Y-m-d H:i:s', GetFirstDayOfWeek());
            $editColumn = new CustomEditColumn('Date Modification', 'date_modification', $editor, $this->dataset);
            $editColumn->SetAllowSetToNull(true);
            $this->ApplyCommonColumnEditProperties($editColumn);
            $grid->AddInsertColumn($editColumn);
            if ($this->GetSecurityInfo()->HasAddGrant())
            {
                $grid->SetShowAddButton(true);
                $grid->SetShowInlineAddButton(false);
            }
            else
            {
                $grid->SetShowInlineAddButton(false);
                $grid->SetShowAddButton(false);
            }
        }
    
        protected function AddPrintColumns(Grid $grid)
        {
            //
            // View column for nom field
            //
            $column = new TextViewColumn('fk_objet_cible_nom', 'Fk Objet Cible', $this->dataset);
            $column->SetOrderable(true);
            $column = new ExtendedHyperLinkColumnDecorator($column, $this->dataset, 'vues.vm_objet_vue_de_base.php?hname=objets_date_objetDetailEdit0vues_vm_objet_vue_de_base_handler&fk0=%fk_objet_cible%' , '_blank');
            $grid->AddPrintColumn($column);
            
            //
            // View column for date_objet_cible field
            //
            $column = new TextViewColumn('date_objet_cible', 'Date Objet Cible', $this->dataset);
            $column->SetOrderable(true);
            $grid->AddPrintColumn($column);
            
            //
            // View column for valeur_inverse field
            //
            $column = new TextViewColumn('fk_type_association_param_valeur_inverse', 'Fk Type Association Param', $this->dataset);
            $column->SetOrderable(true);
            $grid->AddPrintColumn($column);
            
            //
            // View column for nom field
            //
            $column = new TextViewColumn('fk_objet_source_nom', 'Fk Objet Source', $this->dataset);
            $column->SetOrderable(true);
            $column = new ExtendedHyperLinkColumnDecorator($column, $this->dataset, 'vues.vm_objet_vue_de_base.php?hname=objets_date_objetDetailEdit0vues_vm_objet_vue_de_base_handler&fk0=%fk_objet_source%' , '_blank');
            $grid->AddPrintColumn($column);
            
            //
            // View column for date_objet_source field
            //
            $column = new TextViewColumn('date_objet_source', 'Date Objet Source', $this->dataset);
            $column->SetOrderable(true);
            $grid->AddPrintColumn($column);
            
            //
            // View column for reference_precise_objet_source field
            //
            $column = new TextViewColumn('reference_precise_objet_source', 'Reference Precise Objet Source', $this->dataset);
            $column->SetOrderable(true);
            $grid->AddPrintColumn($column);
            
            //
            // View column for libelle_original_objet_source field
            //
            $column = new TextViewColumn('libelle_original_objet_source', 'Libelle Original Objet Source', $this->dataset);
            $column->SetOrderable(true);
            $grid->AddPrintColumn($column);
            
            //
            // View column for valeur_objet_source field
            //
            $column = new TextViewColumn('valeur_objet_source', 'Valeur Objet Source', $this->dataset);
            $column->SetOrderable(true);
            $column = new NumberFormatValueViewColumnDecorator($column, 4, ',', '.');
            $grid->AddPrintColumn($column);
            
            //
            // View column for fk_qualificatif_objet_source field
            //
            $column = new TextViewColumn('fk_qualificatif_objet_source', 'Fk Qualificatif Objet Source', $this->dataset);
            $column->SetOrderable(true);
            $grid->AddPrintColumn($column);
            
            //
            // View column for fk_role_objet_source field
            //
            $column = new TextViewColumn('fk_role_objet_source', 'Fk Role Objet Source', $this->dataset);
            $column->SetOrderable(true);
            $grid->AddPrintColumn($column);
            
            //
            // View column for fk_unite_de_mesure field
            //
            $column = new TextViewColumn('fk_unite_de_mesure', 'Fk Unite De Mesure', $this->dataset);
            $column->SetOrderable(true);
            $grid->AddPrintColumn($column);
            
            //
            // View column for descriptif field
            //
            $column = new TextViewColumn('descriptif', 'Descriptif', $this->dataset);
            $column->SetOrderable(true);
            $grid->AddPrintColumn($column);
            
            //
            // View column for notes field
            //
            $column = new TextViewColumn('notes', 'Notes', $this->dataset);
            $column->SetOrderable(true);
            $grid->AddPrintColumn($column);
            
            //
            // View column for pk_association_objets field
            //
            $column = new TextViewColumn('pk_association_objets', 'Pk Association Objets', $this->dataset);
            $column->SetOrderable(true);
            $grid->AddPrintColumn($column);
            
            //
            // View column for date_creation field
            //
            $column = new DateTimeViewColumn('date_creation', 'Date Creation', $this->dataset);
            $column->SetDateTimeFormat('Y-m-d H:i:s');
            $column->SetOrderable(true);
            $grid->AddPrintColumn($column);
            
            //
            // View column for date_modification field
            //
            $column = new DateTimeViewColumn('date_modification', 'Date Modification', $this->dataset);
            $column->SetDateTimeFormat('Y-m-d H:i:s');
            $column->SetOrderable(true);
            $grid->AddPrintColumn($column);
        }
    
        protected function AddExportColumns(Grid $grid)
        {
            //
            // View column for nom field
            //
            $column = new TextViewColumn('fk_objet_cible_nom', 'Fk Objet Cible', $this->dataset);
            $column->SetOrderable(true);
            $column = new ExtendedHyperLinkColumnDecorator($column, $this->dataset, 'vues.vm_objet_vue_de_base.php?hname=objets_date_objetDetailEdit0vues_vm_objet_vue_de_base_handler&fk0=%fk_objet_cible%' , '_blank');
            $grid->AddExportColumn($column);
            
            //
            // View column for date_objet_cible field
            //
            $column = new TextViewColumn('date_objet_cible', 'Date Objet Cible', $this->dataset);
            $column->SetOrderable(true);
            $grid->AddExportColumn($column);
            
            //
            // View column for valeur_inverse field
            //
            $column = new TextViewColumn('fk_type_association_param_valeur_inverse', 'Fk Type Association Param', $this->dataset);
            $column->SetOrderable(true);
            $grid->AddExportColumn($column);
            
            //
            // View column for nom field
            //
            $column = new TextViewColumn('fk_objet_source_nom', 'Fk Objet Source', $this->dataset);
            $column->SetOrderable(true);
            $column = new ExtendedHyperLinkColumnDecorator($column, $this->dataset, 'vues.vm_objet_vue_de_base.php?hname=objets_date_objetDetailEdit0vues_vm_objet_vue_de_base_handler&fk0=%fk_objet_source%' , '_blank');
            $grid->AddExportColumn($column);
            
            //
            // View column for date_objet_source field
            //
            $column = new TextViewColumn('date_objet_source', 'Date Objet Source', $this->dataset);
            $column->SetOrderable(true);
            $grid->AddExportColumn($column);
            
            //
            // View column for reference_precise_objet_source field
            //
            $column = new TextViewColumn('reference_precise_objet_source', 'Reference Precise Objet Source', $this->dataset);
            $column->SetOrderable(true);
            $grid->AddExportColumn($column);
            
            //
            // View column for libelle_original_objet_source field
            //
            $column = new TextViewColumn('libelle_original_objet_source', 'Libelle Original Objet Source', $this->dataset);
            $column->SetOrderable(true);
            $grid->AddExportColumn($column);
            
            //
            // View column for valeur_objet_source field
            //
            $column = new TextViewColumn('valeur_objet_source', 'Valeur Objet Source', $this->dataset);
            $column->SetOrderable(true);
            $column = new NumberFormatValueViewColumnDecorator($column, 4, ',', '.');
            $grid->AddExportColumn($column);
            
            //
            // View column for fk_qualificatif_objet_source field
            //
            $column = new TextViewColumn('fk_qualificatif_objet_source', 'Fk Qualificatif Objet Source', $this->dataset);
            $column->SetOrderable(true);
            $grid->AddExportColumn($column);
            
            //
            // View column for fk_role_objet_source field
            //
            $column = new TextViewColumn('fk_role_objet_source', 'Fk Role Objet Source', $this->dataset);
            $column->SetOrderable(true);
            $grid->AddExportColumn($column);
            
            //
            // View column for fk_unite_de_mesure field
            //
            $column = new TextViewColumn('fk_unite_de_mesure', 'Fk Unite De Mesure', $this->dataset);
            $column->SetOrderable(true);
            $grid->AddExportColumn($column);
            
            //
            // View column for descriptif field
            //
            $column = new TextViewColumn('descriptif', 'Descriptif', $this->dataset);
            $column->SetOrderable(true);
            $grid->AddExportColumn($column);
            
            //
            // View column for notes field
            //
            $column = new TextViewColumn('notes', 'Notes', $this->dataset);
            $column->SetOrderable(true);
            $grid->AddExportColumn($column);
            
            //
            // View column for pk_association_objets field
            //
            $column = new TextViewColumn('pk_association_objets', 'Pk Association Objets', $this->dataset);
            $column->SetOrderable(true);
            $grid->AddExportColumn($column);
            
            //
            // View column for date_creation field
            //
            $column = new DateTimeViewColumn('date_creation', 'Date Creation', $this->dataset);
            $column->SetDateTimeFormat('Y-m-d H:i:s');
            $column->SetOrderable(true);
            $grid->AddExportColumn($column);
            
            //
            // View column for date_modification field
            //
            $column = new DateTimeViewColumn('date_modification', 'Date Modification', $this->dataset);
            $column->SetDateTimeFormat('Y-m-d H:i:s');
            $column->SetOrderable(true);
            $grid->AddExportColumn($column);
        }
    
        public function GetPageDirection()
        {
            return null;
        }
    
        protected function ApplyCommonColumnEditProperties(CustomEditColumn $column)
        {
            $column->SetDisplaySetToNullCheckBox(false);
            $column->SetDisplaySetToDefaultCheckBox(false);
    		$column->SetVariableContainer($this->GetColumnVariableContainer());
        }
    
        function GetCustomClientScript()
        {
            return ;
        }
        
        function GetOnPageLoadedClientScript()
        {
            return ;
        }
        public function GetModalGridEditingHandler() { return 'vues_vm_association_objets_inv_inline_edit'; }
        protected function GetEnableModalGridEditing() { return true; }
        public function ShowEditButtonHandler(&$show)
        {
            if ($this->GetRecordPermission() != null)
                $show = $this->GetRecordPermission()->HasEditGrant($this->GetDataset());
        }
        public function ShowDeleteButtonHandler(&$show)
        {
            if ($this->GetRecordPermission() != null)
                $show = $this->GetRecordPermission()->HasDeleteGrant($this->GetDataset());
        }
        
        public function GetModalGridDeleteHandler() { return 'vues_vm_association_objets_inv_modal_delete'; }
        protected function GetEnableModalGridDelete() { return true; }
    
        protected function CreateGrid()
        {
            $result = new Grid($this, $this->dataset, 'vues_vm_association_objets_invGrid');
            if ($this->GetSecurityInfo()->HasDeleteGrant())
               $result->SetAllowDeleteSelected(false);
            else
               $result->SetAllowDeleteSelected(false);   
            
            ApplyCommonPageSettings($this, $result);
            
            $result->SetUseImagesForActions(true);
            $result->SetUseFixedHeader(false);
            $result->SetShowLineNumbers(false);
            
            $result->SetHighlightRowAtHover(false);
            $result->SetWidth('');
            $this->CreateGridSearchControl($result);
            $this->CreateGridAdvancedSearchControl($result);
            $this->AddOperationsColumns($result);
            $this->AddFieldColumns($result);
            $this->AddSingleRecordViewColumns($result);
            $this->AddEditColumns($result);
            $this->AddInsertColumns($result);
            $this->AddPrintColumns($result);
            $this->AddExportColumns($result);
    
            $this->SetShowPageList(true);
            $this->SetHidePageListByDefault(false);
            $this->SetExportToExcelAvailable(true);
            $this->SetExportToWordAvailable(true);
            $this->SetExportToXmlAvailable(true);
            $this->SetExportToCsvAvailable(true);
            $this->SetExportToPdfAvailable(true);
            $this->SetPrinterFriendlyAvailable(true);
            $this->SetSimpleSearchAvailable(true);
            $this->SetAdvancedSearchAvailable(true);
            $this->SetFilterRowAvailable(true);
            $this->SetVisualEffectsEnabled(true);
            $this->SetShowTopPageNavigator(true);
            $this->SetShowBottomPageNavigator(true);
    
            //
            // Http Handlers
            //
            //
            // View column for reference_precise_objet_source field
            //
            $column = new TextViewColumn('reference_precise_objet_source', 'Reference Precise Objet Source', $this->dataset);
            $column->SetOrderable(true);
            $handler = new ShowTextBlobHandler($this->dataset, $this, 'vues_vm_association_objets_invGrid_reference_precise_objet_source_handler_list', $column);
            GetApplication()->RegisterHTTPHandler($handler);
            //
            // View column for libelle_original_objet_source field
            //
            $column = new TextViewColumn('libelle_original_objet_source', 'Libelle Original Objet Source', $this->dataset);
            $column->SetOrderable(true);
            $handler = new ShowTextBlobHandler($this->dataset, $this, 'vues_vm_association_objets_invGrid_libelle_original_objet_source_handler_list', $column);
            GetApplication()->RegisterHTTPHandler($handler);
            //
            // View column for descriptif field
            //
            $column = new TextViewColumn('descriptif', 'Descriptif', $this->dataset);
            $column->SetOrderable(true);
            $handler = new ShowTextBlobHandler($this->dataset, $this, 'vues_vm_association_objets_invGrid_descriptif_handler_list', $column);
            GetApplication()->RegisterHTTPHandler($handler);
            //
            // View column for notes field
            //
            $column = new TextViewColumn('notes', 'Notes', $this->dataset);
            $column->SetOrderable(true);
            $handler = new ShowTextBlobHandler($this->dataset, $this, 'vues_vm_association_objets_invGrid_notes_handler_list', $column);
            GetApplication()->RegisterHTTPHandler($handler);//
            // View column for reference_precise_objet_source field
            //
            $column = new TextViewColumn('reference_precise_objet_source', 'Reference Precise Objet Source', $this->dataset);
            $column->SetOrderable(true);
            $handler = new ShowTextBlobHandler($this->dataset, $this, 'vues_vm_association_objets_invGrid_reference_precise_objet_source_handler_view', $column);
            GetApplication()->RegisterHTTPHandler($handler);
            //
            // View column for libelle_original_objet_source field
            //
            $column = new TextViewColumn('libelle_original_objet_source', 'Libelle Original Objet Source', $this->dataset);
            $column->SetOrderable(true);
            $handler = new ShowTextBlobHandler($this->dataset, $this, 'vues_vm_association_objets_invGrid_libelle_original_objet_source_handler_view', $column);
            GetApplication()->RegisterHTTPHandler($handler);
            //
            // View column for descriptif field
            //
            $column = new TextViewColumn('descriptif', 'Descriptif', $this->dataset);
            $column->SetOrderable(true);
            $handler = new ShowTextBlobHandler($this->dataset, $this, 'vues_vm_association_objets_invGrid_descriptif_handler_view', $column);
            GetApplication()->RegisterHTTPHandler($handler);
            //
            // View column for notes field
            //
            $column = new TextViewColumn('notes', 'Notes', $this->dataset);
            $column->SetOrderable(true);
            $handler = new ShowTextBlobHandler($this->dataset, $this, 'vues_vm_association_objets_invGrid_notes_handler_view', $column);
            GetApplication()->RegisterHTTPHandler($handler);
            return $result;
        }
        
        public function OpenAdvancedSearchByDefault()
        {
            return false;
        }
    
        protected function DoGetGridHeader()
        {
            return '';
        }
    }



    try
    {
        $Page = new vues_vm_association_objets_invPage("vues.vm_association_objets_inv.php", "vues_vm_association_objets_inv", GetCurrentUserGrantForDataSource("vues.vm_association_objets_inv"), 'UTF-8');
        $Page->SetShortCaption('Associations des objets cible');
        $Page->SetHeader(GetPagesHeader());
        $Page->SetFooter(GetPagesFooter());
        $Page->SetCaption('Associations des objets cible');
        $Page->SetRecordPermission(GetCurrentUserRecordPermissionsForDataSource("vues.vm_association_objets_inv"));
        GetApplication()->SetEnableLessRunTimeCompile(GetEnableLessFilesRunTimeCompilation());
        GetApplication()->SetCanUserChangeOwnPassword(
            !function_exists('CanUserChangeOwnPassword') || CanUserChangeOwnPassword());
        GetApplication()->SetMainPage($Page);
        GetApplication()->Run();
    }
    catch(Exception $e)
    {
        ShowErrorPage($e->getMessage());
    }
	
