--
-- PostgreSQL database dump
--

-- Dumped from database version 9.4.4
-- Dumped by pg_dump version 9.4.4
-- Started on 2015-10-05 13:57:58 CEST

SET statement_timeout = 0;
SET lock_timeout = 0;
SET client_encoding = 'UTF8';
SET standard_conforming_strings = on;
SET check_function_bodies = false;
SET client_min_messages = warning;

--
-- TOC entry 8 (class 2615 OID 22725)
-- Name: vues; Type: SCHEMA; Schema: -; Owner: -
--

CREATE SCHEMA vues;


SET search_path = vues, pg_catalog;

--
-- TOC entry 215 (class 1255 OID 39256)
-- Name: date_standard_objet(integer); Type: FUNCTION; Schema: vues; Owner: -
--

CREATE FUNCTION date_standard_objet(id integer, OUT certitude character, OUT date_iso character varying, OUT descriptif text, OUT fk_objet integer, OUT fk_type_date_param integer, OUT libelle_original_date text, OUT notes text, OUT pk_date_objet integer, OUT valeur character varying) RETURNS SETOF record
    LANGUAGE sql
    AS $_$ WITH tw1
AS
(SELECT fk_objet,
       MIN(date_iso) date_iso
FROM objets.date_objet
WHERE fk_objet = $1
GROUP BY fk_objet)
SELECT t1.certitude::char,
       t1.date_iso,
       t1.descriptif,
       t1.fk_objet,
       t1.fk_type_date_param,
       t1.libelle_original_date,
       t1.notes,
       t1.pk_date_objet,
       t2.valeur
FROM objets.date_objet t1
  JOIN tw1
    ON tw1.fk_objet = t1.fk_objet
   AND tw1.date_iso = t1.date_iso
  LEFT JOIN parametres.parametre_systeme t2 ON t2.pk_parametre_systeme = t1.fk_type_date_param $_$;


--
-- TOC entry 219 (class 1255 OID 39359)
-- Name: insert_vm_association_objets(); Type: FUNCTION; Schema: vues; Owner: -
--

CREATE FUNCTION insert_vm_association_objets() RETURNS trigger
    LANGUAGE plpgsql
    AS $$ 

DECLARE 
type_association integer;


BEGIN 


IF NEW.fk_type_association_param IS NOT NULL THEN 
			type_association := NEW.fk_type_association_param ;
ELSE type_association := 21;
END IF;



INSERT INTO objets.association_objets
(
	fk_type_association_param,
	fk_objet_source,
	reference_precise_objet_source,
	libelle_original_objet_source,
	valeur_objet_source,
	fk_qualificatif_objet_source,
	fk_role_objet_source,
	fk_unite_de_mesure,
	fk_objet_cible,
	descriptif,
	notes
)
VALUES
(
	type_association,
	NEW.fk_objet_source,
	NEW.reference_precise_objet_source,
	NEW.libelle_original_objet_source,
	NEW.valeur_objet_source,
	NEW.fk_qualificatif_objet_source,
	NEW.fk_role_objet_source,
	NEW.fk_unite_de_mesure,
	NEW.fk_objet_cible,
	NEW.descriptif,
	NEW.notes

) ;

RETURN NEW;
END;

$$;


--
-- TOC entry 217 (class 1255 OID 39318)
-- Name: insert_vm_objet_vue_de_base(); Type: FUNCTION; Schema: vues; Owner: -
--

CREATE FUNCTION insert_vm_objet_vue_de_base() RETURNS trigger
    LANGUAGE plpgsql
    AS $$ 

DECLARE 
id integer;
type_objet integer;
type_nom integer;
type_date integer;


BEGIN 


IF NEW.fk_type_objet_param IS NOT NULL THEN 
			type_objet := NEW.fk_type_objet_param ;
ELSE type_objet := 1;
END IF;


IF NEW.fk_type_nom_param IS NOT NULL THEN 
			type_nom := NEW.fk_type_nom_param ;
ELSE type_nom := 15;
END IF;


IF NEW.fk_type_date_param IS NOT NULL THEN 
			type_date := NEW.fk_type_date_param ;
ELSE type_date := 26;
END IF;



INSERT INTO objets.objet
(
  definition,
  fk_type_objet_param,
  latitude,
  longitude,
  genre,
  notes,
  texte
)
VALUES
(
  NEW.definition,
  type_objet,
  NEW.latitude,
  NEW.longitude,
  NEW.genre,
  NEW.notes,
  NEW.texte
) RETURNING pk_objet INTO id;

INSERT INTO objets.nom_objet
(
  nom,
  fk_objet,
  fk_type_nom_param,
  est_standard
)
VALUES
(
  new.nom,
  id,
  type_nom,
  TRUE
);





IF length(NEW.date_iso) > 3 THEN

	INSERT INTO objets.date_objet
	(
	  date_iso,
	  fk_objet,
	  fk_type_date_param,
	  certitude
	)
	VALUES
	(
	  NEW.date_iso,
	  id,
	  type_date,
	  NEW.certitude
	);
END IF;



RETURN NEW;
END;

$$;


--
-- TOC entry 216 (class 1255 OID 39108)
-- Name: transformation_xml(integer); Type: FUNCTION; Schema: vues; Owner: -
--

CREATE FUNCTION transformation_xml(integer) RETURNS character varying
    LANGUAGE sql
    AS $_$ 
WITH tw0 AS 
(
  -- transforme les entités XML
  SELECT REPLACE(REPLACE(REPLACE(texte,'&','&amp;'),'<','&lt;'),'>','&gt;') txt
  FROM objets.objet
  WHERE pk_objet = $1
),
tw1 AS
(
  -- transforme les accolades en chevrons
  SELECT REPLACE(REPLACE(REPLACE(txt,'{/','</'),'{','<'),'}','>') txt
  FROM tw0
),
tw2 AS
(
  -- traite le cas de balises à deux caractères qui contiennent le type après l'id de l'objet: ajoute l'attribut "type"
  SELECT REGEXP_REPLACE(txt,'(<\w{2})([\d\|]+)([a-z]{2})(_?)([\d|\|]*)(>)','\1\2\4\5 type="\3"\6','g') AS txt
  FROM tw1
),
tw3 AS
(
  -- traite le cas de balises à deux caractères suivies d'un 0: élimine l'attribut "ref" tout en gardant l'attribut @type
  SELECT REGEXP_REPLACE(txt,'(<\w{2})(0)(_?)([\d|\|]*)([\s"=\w]*)(>)','\1\3\4\5\6','g') AS txt
  FROM tw2
),
tw4 AS
(
  -- traite le cas de balises à deux caractères suivies ou non d'un id possédant un '_': ajoute l'attribut @ana
  SELECT REGEXP_REPLACE(txt,'(<\w{2})([\d|\|]*)(_)([\d\|]*)([\s"=\w]*)(>)','\1\2\5 ana="\4"\6','g') AS txt
  FROM tw3
),
tw5 AS
(
  -- traite le cas de balises à deux caractères suivies d'un id : ajoute l'attribut @ref
  SELECT REGEXP_REPLACE(txt,'(<\w{2})([\d\|]+)([\s"=\w|]*)(>)','\1 ref="\2" \3\4','g') AS txt
  FROM tw4
),
tw6 AS
(
  -- traite le cas de balises seg et eud possédant un '_': ajoute l'attribut @ana
  SELECT REGEXP_REPLACE(txt,'(<)(seg|eud)(_)([\d|\|]*)(>)','\1\2 ana="\4"\5','g') AS txt
  FROM tw5
),
tw7 AS
(
  -- traite le cas des dates avec un paramètre d'incertitude en ajoutant l'attribut @cert
  SELECT REGEXP_REPLACE(txt,'(<)(dat)([0-9]+)(r|p)(_?)([a-z]{2})(>)','\1\2\3\5\6 cert="\4"\7','g') AS txt
  FROM tw6
),
tw8 AS
(
  -- traite le cas des dates avec un type en ajoutant l'attribut @type
  SELECT REGEXP_REPLACE(txt,'(<)(dat)([0-9]+)(_)([a-z]{2})','\1\2\3 type="\5"','g') AS txt
  FROM tw7
),
tw9 AS
(
  -- traite le cas des dates en ajoutant l'attribut @when
  SELECT REGEXP_REPLACE(txt,'(<)(dat)([0-9]+)','\1\2 when="\3"','g') AS txt
  FROM tw8
)
 UPDATE objets.objet
   SET texte_xml = (concat('<root>',REGEXP_REPLACE(txt, '\|', ' ' , 'g'),'</root>'))::xml
FROM tw9
WHERE pk_objet = $1;

SELECT 'Effectué'::varchar AS resultat;


$_$;


--
-- TOC entry 220 (class 1255 OID 39361)
-- Name: update_vm_association_objets(); Type: FUNCTION; Schema: vues; Owner: -
--

CREATE FUNCTION update_vm_association_objets() RETURNS trigger
    LANGUAGE plpgsql
    AS $$


DECLARE 
type_association integer;



BEGIN

	IF NEW.fk_type_association_param IS NOT NULL THEN 
				type_association := NEW.fk_type_association_param ;
	ELSE type_association := 21;
	END IF;
	

	UPDATE objets.association_objets SET	fk_type_association_param = type_association,
						fk_objet_source = NEW.fk_objet_source,
						reference_precise_objet_source = NEW.reference_precise_objet_source,
						libelle_original_objet_source = NEW.libelle_original_objet_source,
						valeur_objet_source = NEW.valeur_objet_source,
						fk_qualificatif_objet_source = NEW.fk_qualificatif_objet_source,
						fk_role_objet_source = NEW.fk_role_objet_source,
						fk_unite_de_mesure = NEW.fk_unite_de_mesure,
						fk_objet_cible = NEW.fk_objet_cible,
						descriptif = NEW.descriptif,
						notes = NEW.notes			
				
				WHERE pk_association_objets = OLD.pk_association_objets;

     

            RETURN NEW;


END;

$$;


--
-- TOC entry 218 (class 1255 OID 39320)
-- Name: update_vm_objet_vue_de_base(); Type: FUNCTION; Schema: vues; Owner: -
--

CREATE FUNCTION update_vm_objet_vue_de_base() RETURNS trigger
    LANGUAGE plpgsql
    AS $$


DECLARE 
type_nom integer;
type_date integer;



BEGIN

	IF NEW.fk_type_nom_param IS NOT NULL THEN 
				type_nom := NEW.fk_type_nom_param ;
	ELSE type_nom := 15;
	END IF;

	IF NEW.fk_type_date_param IS NOT NULL THEN 
			type_date := NEW.fk_type_date_param ;
	ELSE type_date := 26;
	END IF;
	

	UPDATE objets.objet 	SET	fk_type_objet_param = NEW.fk_type_objet_param,
					definition = NEW.definition,
					latitude = NEW.latitude,
					longitude = NEW.longitude,
					genre = NEW.genre,
					notes = NEW.notes,
					texte = NEW.texte			
				
				WHERE pk_objet = OLD.pk_objet;

			

	IF OLD.pk_nom_objet IS NOT NULL THEN
			
            UPDATE objets.nom_objet	SET	nom = NEW.nom, 
						fk_type_nom_param = NEW.fk_type_nom_param
					
					WHERE pk_nom_objet = OLD.pk_nom_objet;
	ELSE 


		INSERT INTO objets.nom_objet
		(
		  nom,
		  fk_objet,
		  fk_type_nom_param,
		  est_standard
		)
		VALUES
		(
		  NEW.nom,
		  OLD.pk_objet,
		  type_nom,
		  TRUE
		);

	END IF;




	IF OLD.pk_date_objet IS NOT NULL THEN
			
		UPDATE objets.date_objet SET	date_iso = NEW.date_iso,
						fk_type_date_param= NEW.fk_type_date_param,
						certitude = NEW.certitude
					
						WHERE pk_date_objet = OLD.pk_date_objet;
	ELSE 


		IF length(NEW.date_iso) > 3 THEN

			INSERT INTO objets.date_objet
			(
			  date_iso,
			  fk_objet,
			  fk_type_date_param,
			  certitude
			)
			VALUES
			(
			  NEW.date_iso,
			  OLD.pk_objet,
			  type_date,
			  NEW.certitude
			);
		END IF;
		
	END IF;

	
           

     

            RETURN NEW;


END;

$$;


--
-- TOC entry 197 (class 1259 OID 39354)
-- Name: vm_association_objets; Type: VIEW; Schema: vues; Owner: -
--

CREATE VIEW vm_association_objets AS
 SELECT ao.fk_type_association_param,
    ao.fk_objet_source,
    os.nom AS nom_objet_source,
        CASE
            WHEN (( SELECT (date_standard_objet(ao.fk_objet_source)).date_iso AS date_iso
             LIMIT 1) IS NULL) THEN ''::character varying
            ELSE ( SELECT (date_standard_objet(ao.fk_objet_source)).date_iso AS date_iso
             LIMIT 1)
        END AS date_objet_source,
    ao.reference_precise_objet_source,
    ao.libelle_original_objet_source,
    ao.valeur_objet_source,
    ao.fk_qualificatif_objet_source,
    ao.fk_role_objet_source,
    ao.fk_unite_de_mesure,
    ao.fk_objet_cible,
    oc.nom AS nom_objet_cible,
        CASE
            WHEN (( SELECT (date_standard_objet(ao.fk_objet_cible)).date_iso AS date_iso
             LIMIT 1) IS NULL) THEN ''::character varying
            ELSE ( SELECT (date_standard_objet(ao.fk_objet_cible)).date_iso AS date_iso
             LIMIT 1)
        END AS date_objet_cible,
    ao.descriptif,
    ao.notes,
    ao.pk_association_objets,
    ao.date_creation,
    ao.date_modification
   FROM ((objets.association_objets ao
     LEFT JOIN objets.nom_objet os ON (((os.fk_objet = ao.fk_objet_source) AND (os.est_standard IS TRUE))))
     LEFT JOIN objets.nom_objet oc ON (((oc.fk_objet = ao.fk_objet_cible) AND (oc.est_standard IS TRUE))));


--
-- TOC entry 198 (class 1259 OID 39363)
-- Name: vm_association_objets_inv; Type: VIEW; Schema: vues; Owner: -
--

CREATE VIEW vm_association_objets_inv AS
 SELECT ao.fk_type_association_param,
    ao.fk_objet_source,
    os.nom AS nom_objet_source,
        CASE
            WHEN (( SELECT (date_standard_objet(ao.fk_objet_source)).date_iso AS date_iso
             LIMIT 1) IS NULL) THEN ''::character varying
            ELSE ( SELECT (date_standard_objet(ao.fk_objet_source)).date_iso AS date_iso
             LIMIT 1)
        END AS date_objet_source,
    ao.reference_precise_objet_source,
    ao.libelle_original_objet_source,
    ao.valeur_objet_source,
    ao.fk_qualificatif_objet_source,
    ao.fk_role_objet_source,
    ao.fk_unite_de_mesure,
    ao.fk_objet_cible,
    oc.nom AS nom_objet_cible,
        CASE
            WHEN (( SELECT (date_standard_objet(ao.fk_objet_cible)).date_iso AS date_iso
             LIMIT 1) IS NULL) THEN ''::character varying
            ELSE ( SELECT (date_standard_objet(ao.fk_objet_cible)).date_iso AS date_iso
             LIMIT 1)
        END AS date_objet_cible,
    ao.descriptif,
    ao.notes,
    ao.pk_association_objets,
    ao.date_creation,
    ao.date_modification
   FROM ((objets.association_objets ao
     LEFT JOIN objets.nom_objet os ON (((os.fk_objet = ao.fk_objet_source) AND (os.est_standard IS TRUE))))
     LEFT JOIN objets.nom_objet oc ON (((oc.fk_objet = ao.fk_objet_cible) AND (oc.est_standard IS TRUE))));


--
-- TOC entry 193 (class 1259 OID 39288)
-- Name: vm_objet_vue_de_base; Type: VIEW; Schema: vues; Owner: -
--

CREATE VIEW vm_objet_vue_de_base AS
 SELECT ob.pk_objet,
    ob.fk_type_objet_param,
    no.nom,
    no.fk_type_nom_param,
    ob.definition,
    dob.date_iso,
    dob.fk_type_date_param,
    dob.certitude,
    ob.latitude,
    ob.longitude,
    ob.genre,
    ob.notes,
    ob.texte,
    ob.texte_xml,
        CASE
            WHEN (length((ob.texte_xml)::text) > 0) THEN true
            ELSE false
        END AS si_texte_xml,
    ob.date_creation,
    ob.date_modification,
    no.pk_nom_objet,
    dob.pk_date_objet
   FROM ((objets.objet ob
     LEFT JOIN objets.nom_objet no ON (((no.fk_objet = ob.pk_objet) AND (no.est_standard IS TRUE))))
     LEFT JOIN objets.date_objet dob ON ((dob.pk_date_objet = ( SELECT (date_standard_objet(ob.pk_objet)).pk_date_objet AS pk_date_objet
         LIMIT 1))))
  ORDER BY ob.pk_objet DESC;


--
-- TOC entry 187 (class 1259 OID 30940)
-- Name: vn_liste_ud_avec_en_tete; Type: VIEW; Schema: vues; Owner: -
--

CREATE VIEW vn_liste_ud_avec_en_tete AS
 WITH tw1 AS (
         SELECT replace(regexp_split_to_table(objet.texte, '{/ud0}'::text), '{ud0}'::text, ''::text) AS ud
           FROM objets.objet
        ), tw2 AS (
         SELECT row_number() OVER (ORDER BY 1::integer) AS id_ud,
            replace(regexp_split_to_table(tw1.ud, '{/eud}'::text), '{eud}'::text, ''::text) AS ud_split
           FROM tw1
        ), tw3 AS (
         SELECT tw2.id_ud,
            max(
                CASE
                    WHEN (tw2.ud_split !~ '{seg'::text) THEN tw2.ud_split
                    ELSE ''::text
                END) AS titre,
            max(
                CASE
                    WHEN (tw2.ud_split ~ '{seg'::text) THEN tw2.ud_split
                    ELSE ''::text
                END) AS corps
           FROM tw2
          GROUP BY tw2.id_ud
        )
 SELECT tw3.id_ud,
    tw3.titre,
    replace(replace((regexp_matches(tw3.corps, '{seg}.*{/seg}'::text, 'g'::text))[1], '{seg}'::text, ''::text), '{/seg}'::text, ''::text) AS ud_split,
    tw3.corps
   FROM tw3
  ORDER BY tw3.titre;


--
-- TOC entry 188 (class 1259 OID 30945)
-- Name: vn_nom_annee_naissance_notices_bnf; Type: VIEW; Schema: vues; Owner: -
--

CREATE VIEW vn_nom_annee_naissance_notices_bnf AS
 WITH tw1 AS (
         SELECT regexp_replace(replace(regexp_split_to_table(objet.texte, '{/ud\}'::text), '{ud0}'::text, ''::text), '\n'::text, ''::text, 'g'::text) AS ud
           FROM objets.objet
        )
 SELECT
        CASE
            WHEN ("position"(tw1.ud, '('::text) > 0) THEN "substring"(tw1.ud, 1, ("position"(tw1.ud, '('::text) - 2))
            ELSE "substring"(tw1.ud, 1, "position"(tw1.ud, '('::text))
        END AS nom,
    (replace((regexp_matches(tw1.ud, '\{dat\d{4}'::text))[1], '{dat'::text, ''::text))::integer AS annee_naissance,
    regexp_replace((regexp_matches(tw1.ud, '\{en0li\}.{1,}\{/en\}'::text))[1], '(\{en0li\})(.{1,})(\{/en\})'::text, '\2'::text) AS lieu_naissance,
    tw1.ud
   FROM tw1
  ORDER BY (replace((regexp_matches(tw1.ud, '\{dat\d{4}'::text))[1], '{dat'::text, ''::text))::integer;


--
-- TOC entry 195 (class 1259 OID 39310)
-- Name: vn_type_valeurs; Type: VIEW; Schema: vues; Owner: -
--

CREATE VIEW vn_type_valeurs AS
 SELECT DISTINCT parametre_systeme.type_valeur
   FROM parametres.parametre_systeme
  ORDER BY parametre_systeme.type_valeur DESC;


--
-- TOC entry 192 (class 1259 OID 39279)
-- Name: vn_types_associations_entre_objets; Type: VIEW; Schema: vues; Owner: -
--

CREATE VIEW vn_types_associations_entre_objets AS
 SELECT parametre_systeme.pk_parametre_systeme,
    parametre_systeme.valeur
   FROM parametres.parametre_systeme
  WHERE ((parametre_systeme.type_valeur)::text = 'type_association_objets'::text);


--
-- TOC entry 199 (class 1259 OID 39370)
-- Name: vn_types_associations_inverses_entre_objets; Type: VIEW; Schema: vues; Owner: -
--

CREATE VIEW vn_types_associations_inverses_entre_objets AS
 SELECT parametre_systeme.pk_parametre_systeme,
    parametre_systeme.valeur_inverse
   FROM parametres.parametre_systeme
  WHERE ((parametre_systeme.type_valeur)::text = 'type_association_objets'::text);


--
-- TOC entry 191 (class 1259 OID 39275)
-- Name: vn_types_date; Type: VIEW; Schema: vues; Owner: -
--

CREATE VIEW vn_types_date AS
 SELECT parametre_systeme.pk_parametre_systeme,
    parametre_systeme.valeur
   FROM parametres.parametre_systeme
  WHERE ((parametre_systeme.type_valeur)::text = 'type_date'::text);


--
-- TOC entry 190 (class 1259 OID 39271)
-- Name: vn_types_nom_objet; Type: VIEW; Schema: vues; Owner: -
--

CREATE VIEW vn_types_nom_objet AS
 SELECT parametre_systeme.pk_parametre_systeme,
    parametre_systeme.valeur
   FROM parametres.parametre_systeme
  WHERE ((parametre_systeme.type_valeur)::text = 'type_nom'::text);


--
-- TOC entry 189 (class 1259 OID 39267)
-- Name: vn_types_objet; Type: VIEW; Schema: vues; Owner: -
--

CREATE VIEW vn_types_objet AS
 SELECT parametre_systeme.pk_parametre_systeme,
    parametre_systeme.valeur
   FROM parametres.parametre_systeme
  WHERE ((parametre_systeme.type_valeur)::text = 'type_objet'::text);


--
-- TOC entry 194 (class 1259 OID 39306)
-- Name: vn_valeurs_genre; Type: VIEW; Schema: vues; Owner: -
--

CREATE VIEW vn_valeurs_genre AS
 SELECT parametre_systeme.pk_parametre_systeme,
    parametre_systeme.valeur
   FROM parametres.parametre_systeme
  WHERE ((parametre_systeme.type_valeur)::text = 'type_genre'::text)
  ORDER BY parametre_systeme.pk_parametre_systeme;


--
-- TOC entry 196 (class 1259 OID 39314)
-- Name: vn_valeurs_type_certitude_date; Type: VIEW; Schema: vues; Owner: -
--

CREATE VIEW vn_valeurs_type_certitude_date AS
 SELECT parametre_systeme.pk_parametre_systeme,
    parametre_systeme.valeur
   FROM parametres.parametre_systeme
  WHERE ((parametre_systeme.type_valeur)::text = 'type_certitude_date'::text)
  ORDER BY parametre_systeme.pk_parametre_systeme;


--
-- TOC entry 2242 (class 2620 OID 39360)
-- Name: on_insert_vues_insert_vm_association_objets; Type: TRIGGER; Schema: vues; Owner: -
--

CREATE TRIGGER on_insert_vues_insert_vm_association_objets INSTEAD OF INSERT ON vm_association_objets FOR EACH ROW EXECUTE PROCEDURE insert_vm_association_objets();


--
-- TOC entry 2244 (class 2620 OID 39368)
-- Name: on_insert_vues_insert_vm_association_objets_inv; Type: TRIGGER; Schema: vues; Owner: -
--

CREATE TRIGGER on_insert_vues_insert_vm_association_objets_inv INSTEAD OF INSERT ON vm_association_objets_inv FOR EACH ROW EXECUTE PROCEDURE insert_vm_association_objets();


--
-- TOC entry 2240 (class 2620 OID 39319)
-- Name: on_insert_vues_insert_vm_objet_vue_de_base; Type: TRIGGER; Schema: vues; Owner: -
--

CREATE TRIGGER on_insert_vues_insert_vm_objet_vue_de_base INSTEAD OF INSERT ON vm_objet_vue_de_base FOR EACH ROW EXECUTE PROCEDURE insert_vm_objet_vue_de_base();


--
-- TOC entry 2243 (class 2620 OID 39362)
-- Name: on_update_vues_update_vm_association_objets; Type: TRIGGER; Schema: vues; Owner: -
--

CREATE TRIGGER on_update_vues_update_vm_association_objets INSTEAD OF UPDATE ON vm_association_objets FOR EACH ROW EXECUTE PROCEDURE update_vm_association_objets();


--
-- TOC entry 2245 (class 2620 OID 39369)
-- Name: on_update_vues_update_vm_association_objets_inv; Type: TRIGGER; Schema: vues; Owner: -
--

CREATE TRIGGER on_update_vues_update_vm_association_objets_inv INSTEAD OF UPDATE ON vm_association_objets_inv FOR EACH ROW EXECUTE PROCEDURE update_vm_association_objets();


--
-- TOC entry 2241 (class 2620 OID 39322)
-- Name: on_update_vues_update_vm_objet_vue_de_base; Type: TRIGGER; Schema: vues; Owner: -
--

CREATE TRIGGER on_update_vues_update_vm_objet_vue_de_base INSTEAD OF UPDATE ON vm_objet_vue_de_base FOR EACH ROW EXECUTE PROCEDURE update_vm_objet_vue_de_base();


-- Completed on 2015-10-05 13:57:58 CEST

--
-- PostgreSQL database dump complete
--

