source(connexion_postgresql.R)

# compte le nombre d'individus par année
occurrences_car_soc <- dbGetQuery(con, "WITH tw1 AS
(
  SELECT UNNEST(xpath ('/root/ud',t1.texte_xml)) ud,
  UNNEST(xpath ('/root/ud/dat[1]/@when',t1.texte_xml)) annee
  FROM objets.objet t1
  WHERE t1.pk_objet = 36
),
  tw2 AS
  (
  SELECT ROW_NUMBER() OVER (ORDER BY 1)::INTEGER AS id_ud,
  (UNNEST(xpath ('//en/@ref',tw1.ud))::text) en,
  annee
  FROM tw1
  )
  SELECT DISTINCT id_ud,
  (en::text)::integer cle_objet,
  (annee::text)::integer annee,
  t1.nom
  FROM tw2
  JOIN vues.vm_objet_vue_de_base t1
  ON t1.pk_objet = tw2.en::integer
  AND t1.fk_type_objet_param = 4
  ORDER BY annee,
  id_ud
  ")

astrologues <- subset(occurrences_car_soc, occurrences_car_soc$nom=='Astrologue')
astrononomes <- subset(occurrences_car_soc, occurrences_car_soc$nom=='Astronome')
medecins <- subset(occurrences_car_soc, occurrences_car_soc$nom=='Médecin')
ingenieurs <- subset(occurrences_car_soc, occurrences_car_soc$nom=='Ingénieur')


hist(astrologues$annee)
boxplot(astrononomes$annee, astrologues$annee, medecins$annee, ingenieurs$annee)


occurrences_car_soc$soch <- factor(occurrences_car_soc$nom)
occurrences_car_soc$annee_fct <- factor(occurrences_car_soc$annee)

# col=rainbow(100)

plot(occurrences_car_soc$soch, occurrences_car_soc$annee, varwidth=TRUE)




pop_des_1400 <- subset(occurrences_car_soc, occurrences_car_soc$annee > 1400)
pop_des_1400$soch <- factor(pop_des_1400$nom)

pas_annees <- seq(1400, 1800, by = 20)
hist(pop_des_1400$annee, breaks=pas_annees, col="#99CCFF",
     main="Générations de mathématiciens et astronomes")

par(las=2)
par(mar=c(8,5,1,1))
# R choisit le boxplot tout seul, car variable catégorielle ?
plot(pop_des_1400$soch, pop_des_1400$annee, varwidth=TRUE)






#########




                                  
                                  
plot(annee_effectif, main="Effectif des naissances par année")
  
# liste les années de naissance (toutes)
liste_annee <- dbGetQuery(con, 
"SELECT (SUBSTR(UNNEST(xpath ('//ud/dat[1]/text()',texte_xml))::text,1,4))::INTEGER annee
  FROM objets.objet
  WHERE pk_objet = 5")

# lister les noms des colonnes
names(liste_annee)

# vous pouvez changer le pas (1 an, 2 ans, 5 ans, etc.) et rééxécuter la requête
pas_annees <- seq(1100, 1800, by = 10)
hist(liste_annee$annee, breaks=pas_annees, col="#99CCFF",
     main="Générations de mathématiciens et astronomes")


