source(connexion_postgresql.R)

# compte le nombre d'individus par année
annee_effectif <- dbGetQuery(con, "WITH tw1 AS
(
  SELECT (SUBSTR(UNNEST(xpath ('//ud/dat[1]/text()',texte_xml))::text,1,4))::INTEGER annee
  FROM objets.objet
  WHERE pk_objet = 5
)
                             SELECT annee,
                             COUNT(*) effectif
                             FROM tw1
                             GROUP BY annee
                             ORDER BY annee")

plot(annee_effectif, main="Effectif des naissances par année")
  
# liste les années de naissance (toutes)
liste_annee <- dbGetQuery(con, 
"SELECT (SUBSTR(UNNEST(xpath ('//ud/dat[1]/text()',texte_xml))::text,1,4))::INTEGER annee
  FROM objets.objet
  WHERE pk_objet = 5")

# lister les noms des colonnes
names(liste_annee)

# vous pouvez changer le pas (1 an, 2 ans, 5 ans, etc.) et rééxécuter la requête
pas_annees <- seq(1100, 1800, by = 25)
hist(liste_annee$annee, breaks=pas_annees, col="#99CCFF",
     main="Générations de mathématiciens et astronomes", xlab="Génération")


