
library(timeline)


source(connexion_postgresql.R)


###  Timeline

# Cette requête liste les conseillers avec début et fin de signature et effectif des signatures pour chacun
# Attention: dans le résultat est omis une première charte de 1430 car elle est séparéé
# de 10 ans de la suivante

donnees_timeline <- dbGetQuery(con,"WITH tw1 AS
(
  SELECT UNNEST(xpath ('/root/ud',t1.texte_xml)) ud,
  UNNEST(xpath ('/root/ud/dat[1]/@when',t1.texte_xml)) annee
  FROM objets.objet t1
  WHERE t1.pk_objet = 36
),
  tw2_0 AS
  (
  SELECT ROW_NUMBER() OVER (ORDER BY 1)::INTEGER AS id_ud,
  (UNNEST(xpath ('//en[not(@type=\"li\")]/@ref',tw1.ud))::text)::INTEGER en,
  annee
  FROM tw1
  ORDER BY en
  ),
  tw2 AS
  (
  SELECT *
  FROM tw2_0,
  vues.vm_objet_vue_de_base t1
  WHERE t1.pk_objet = tw2_0.en
  AND   t1.fk_type_objet_param = 4
  ),
  tw3 AS
  (
  SELECT t1.id_ud,
  t1.en,
  t2.en,
  ((t1.annee)::text)::integer,
  t3.nom objet_1,
  t4.nom objet_2
  FROM tw2 t1,
  tw2 t2,
  vues.vm_objet_vue_de_base t3,
  vues.vm_objet_vue_de_base t4
  WHERE t2.id_ud = t1.id_ud
  AND   t2.en > t1.en
  AND   t3.pk_objet = t1.en
  AND   t4.pk_objet = t2.en
  ORDER BY
  --t1.id_ud,
  t1.en,
  t2.en
  )
  SELECT objet_1||'_'||objet_2,
  COUNT(*) AS effectif,
  MIN(annee) AS min_annee,
  MAX(annee) AS max_annee
  FROM tw3
  GROUP BY objet_1,
  objet_2")


# timeline des conseillers (ouvrir avec le bouton zoom pour la lire)
timeline(donnees_timeline, group.col=names(donnees_timeline)[1], label.col=names(donnees_timeline)[2],
         start.col=names(donnees_timeline)[3], end.col=names(donnees_timeline)[4])




###  Réseaux
# Il ne s'agit pas de faire une vraie analyse de réseaux mais de visualizer 
# les effectifs et cooccurrences des signataires

# cette requête liste, pour chaque charte, les paires de co-signataires, puis compte combien de fois la même paire se retrouve.
# en d'autres termes on étudie les liens établis entre acteurs par le fait d'avoir signé la même charte

source(connexion_postgresql.R)

library(statnet)

asso_avec_eff <- dbGetQuery(con,"WITH tw1 AS
(
  SELECT UNNEST(xpath ('/root/ud',t1.texte_xml)) ud,
  UNNEST(xpath ('/root/ud/dat[1]/@when',t1.texte_xml)) annee
  FROM objets.objet t1
  WHERE t1.pk_objet = 36
),
  tw2_0 AS
  (
  SELECT ROW_NUMBER() OVER (ORDER BY 1)::INTEGER AS id_ud,
  (UNNEST(xpath ('//en[not(@type=\"li\")]/@ref',tw1.ud))::text)::INTEGER en,
  annee
  FROM tw1
  ORDER BY en
  ),
  tw2 AS
  (
  SELECT *
  FROM tw2_0,
  vues.vm_objet_vue_de_base t1
  WHERE t1.pk_objet = tw2_0.en
  AND   t1.fk_type_objet_param = 4
  ),
  tw3 AS
  (
  SELECT t1.id_ud,
  t1.en,
  t2.en,
  ((t1.annee)::text)::integer,
  t3.nom objet_1,
  t4.nom objet_2
  FROM tw2 t1,
  tw2 t2,
  vues.vm_objet_vue_de_base t3,
  vues.vm_objet_vue_de_base t4
  WHERE t2.id_ud = t1.id_ud
  AND   t2.en > t1.en
  AND   t3.pk_objet = t1.en
  AND   t4.pk_objet = t2.en
  ORDER BY
  --t1.id_ud,
  t1.en,
  t2.en
  )
  SELECT objet_1,
  objet_2,
  COUNT(*) AS effectif,
  MIN(annee) AS min_annee,
  MAX(annee) AS max_annee
  FROM tw3
  GROUP BY objet_1,
  objet_2")


class(asso_avec_eff)
names(asso_avec_eff)



## explications: http://www.inside-r.org/packages/cran/network/docs/loading.attributes

# création du réseau
asceNet<-network(asso_avec_eff[,1:2],matrix.type='edgelist')
class(asceNet)

# as.matrix(asceNet)

# ajout des propriétés des lignes
asceNet<-network(asso_avec_eff,matrix.type='edgelist',ignore.eval=FALSE)
list.edge.attributes(asceNet)
as.matrix(asso_avec_eff, attrname = "effectif")

degre <- degree(asceNet, gmode="graph", cmode = "degree")

indegree <- degree(asceNet, gmode="graph", cmode = "outdegree")

indegree
degre

asceNet
## aide sur la fonction plot.network.default
## reexécuter à plusieurs reprises jusqu'à l'affichage optimal
gplot(asceNet, label = network.vertex.names(asceNet),
      vertex.cex = degree(asceNet, gmode="graph", cmode = "indegree")/4, 
      mode="fruchtermanreingold", layout.par=list(repulse.rad=20000), 
      main = "Centralité de degré et nombre de liens entre professions", gmode="graph", 
      edge.col= get.edge.value(asceNet,"effectif"),
      edge.lwd=log1p(get.edge.value(asceNet,"effectif"))*2,
      vertex.col = "#FFC299",
      label.col = "#000099", 
      label.pos = 5, 
      label.cex = 0.8,
      boxed.labels = TRUE,
      label.pad=0.03)

## Comparer le réseau affiché avec la timeline et le graphique des rapports
# entre durée de la charge et nombre de signatures pour chercher des particularités
# en lien avec ce que vous savez par ailleurs sur ces acteurs