source(connexion_postgresql.R)

# compte le nombre d'individus par année
occurrences_car_soc <- dbGetQuery(con, "WITH tw1 AS
(
  SELECT UNNEST(xpath ('/root/ud',t1.texte_xml)) ud,
  UNNEST(xpath ('/root/ud/dat[1]/@when',t1.texte_xml)) annee
  FROM objets.objet t1
  WHERE t1.pk_objet = 36
),
  tw2 AS
  (
  SELECT ROW_NUMBER() OVER (ORDER BY 1)::INTEGER AS id_ud,
  (UNNEST(xpath ('//en/@ref',tw1.ud))::text) en,
  annee
  FROM tw1
  )
  SELECT DISTINCT id_ud,
  (en::text)::integer cle_objet,
  (annee::text)::integer annee,
  t1.nom
  FROM tw2
  JOIN vues.vm_objet_vue_de_base t1
  ON t1.pk_objet = tw2.en::integer
  AND t1.fk_type_objet_param = 4
  ORDER BY annee,
  id_ud
  ")


occurrences_car_soc$soch <- factor(occurrences_car_soc$nom)
occurrences_car_soc$annee_fct <- factor(occurrences_car_soc$annee)

# col=rainbow(100)

plot(occurrences_car_soc$soch, occurrences_car_soc$annee, varwidth=TRUE)




pop_des_1400 <- subset(occurrences_car_soc, occurrences_car_soc$annee > 1400)
pop_des_1400$soch <- factor(pop_des_1400$nom)



pop_des_1400
levels(pop_des_1400$soch)

dotchart(sort(table(pop_des_1400$soch)), main="Distribution de l'effectif par profession")



astrologues <- subset(pop_des_1400, pop_des_1400$soch=='Astrologue')
astrononomes <- subset(pop_des_1400, pop_des_1400$soch=='Astronome')
medecins <- subset(pop_des_1400, pop_des_1400$soch=='Médecin')
ingenieurs <- subset(pop_des_1400, pop_des_1400$soch=='Ingénieur')

pas_annees <- seq(1400, 1800, by = 20)
hist(astrononomes$annee, breaks = pas_annees)
hist(ingenieurs$annee, breaks = pas_annees, add=TRUE, col='blue')
hist(astrologues$annee, breaks = pas_annees, add=TRUE, col='red')

plot(table(astrononomes$annee), type='l')
hist(ingenieurs$annee, breaks = pas_annees, add=TRUE, col='blue')
hist(astrologues$annee, breaks = pas_annees, add=TRUE, col='red')


pas_annees <- seq(1400, 1800, by = 20)
hist(pop_des_1400$annee, breaks=pas_annees, col="#99CCFF",
     main="Générations de mathématiciens et astronomes")

par(las=2)
par(mar=c(8,5,1,1))
# R choisit le boxplot tout seul, car variable catégorielle ?
plot(pop_des_1400$soch, pop_des_1400$annee, varwidth=TRUE)



