--
-- PostgreSQL database dump
--

-- Dumped from database version 9.3.1
-- Dumped by pg_dump version 9.3.1
-- Started on 2014-02-25 11:18:40 CET

SET statement_timeout = 0;
SET lock_timeout = 0;
SET client_encoding = 'UTF8';
SET standard_conforming_strings = on;
SET check_function_bodies = false;
SET client_min_messages = warning;

--
-- TOC entry 9 (class 2615 OID 37892)
-- Name: tables_uc; Type: SCHEMA; Schema: -; Owner: -
--

CREATE SCHEMA tables_uc;


SET search_path = tables_uc, pg_catalog;

--
-- TOC entry 246 (class 1255 OID 37893)
-- Name: create_info_date_concatenated_date(); Type: FUNCTION; Schema: tables_uc; Owner: -
--

CREATE FUNCTION create_info_date_concatenated_date() RETURNS trigger
    LANGUAGE plpgsql
    AS $$

DECLARE variable_date text;

BEGIN

IF NEW.annee IS NOT NULL AND NEW.mois IS NULL THEN
	IF NEW.annee < 0 THEN
		variable_date := substring(to_char(NEW.annee, '0000')from 1 for 5);
	ELSE
		variable_date := substring(to_char(NEW.annee, '0000')from 2 for 5);
	END IF;
END IF;

IF NEW.annee IS NOT NULL AND NEW.mois IS NOT NULL AND NEW.jour IS NULL THEN
	IF NEW.annee < 0 THEN
		variable_date := substring(to_char(NEW.annee, '0000')from 1 for 5)||'-'||substring(to_char(NEW.mois, '00') from 2 for 3);	
	ELSE
		variable_date := substring(to_char(NEW.annee, '0000')from 2 for 5)||'-'||substring(to_char(NEW.mois, '00') from 2 for 3);
	END IF;
END IF;

IF NEW.annee IS NOT NULL AND NEW.mois IS NOT NULL AND NEW.jour IS NOT NULL THEN
	IF NEW.annee < 0 THEN
		variable_date := substring(to_char(NEW.annee, '0000')from 1 for 5)||'-'||substring(to_char(NEW.mois, '00') from 2 for 3)||'-'||substring(to_char(NEW.jour, '00') from 2 for 3);
	ELSE
		variable_date := substring(to_char(NEW.annee, '0000')from 2 for 5)||'-'||substring(to_char(NEW.mois, '00') from 2 for 3)||'-'||substring(to_char(NEW.jour, '00') from 2 for 3);
	END IF;
END IF;


IF NEW.annee IS NULL
THEN variable_date := NULL;
END IF;


IF  NEW.certitude_date = 1
THEN variable_date := variable_date;
ELSEIF NEW.certitude_date = 2
THEN variable_date := variable_date || ' r';

ELSEIF NEW.certitude_date = 3
THEN variable_date := variable_date || ' p';
END IF;




NEW.date_recomposee =  variable_date;

RETURN NEW;

END;
$$;


SET default_tablespace = '';

SET default_with_oids = false;

--
-- TOC entry 198 (class 1259 OID 37894)
-- Name: associer_unite_connaissance_objet; Type: TABLE; Schema: tables_uc; Owner: -; Tablespace: 
--

CREATE TABLE associer_unite_connaissance_objet (
    pk_associer_unite_connaissance_objet integer NOT NULL,
    fk_unite_connaissance integer,
    fk_objet integer,
    fk_type_association_objet integer,
    notes text,
    descriptif text,
    reference_precise text
);


--
-- TOC entry 2440 (class 0 OID 0)
-- Dependencies: 198
-- Name: TABLE associer_unite_connaissance_objet; Type: COMMENT; Schema: tables_uc; Owner: -
--

COMMENT ON TABLE associer_unite_connaissance_objet IS 'Cette table fait la jointure entre les unités de connaissance et les objets qui permettent de classer, documenter, etc. les unités de connaissance';


--
-- TOC entry 199 (class 1259 OID 37900)
-- Name: associer_unite_connaissance_o_pk_associer_unite_connaissanc_seq; Type: SEQUENCE; Schema: tables_uc; Owner: -
--

CREATE SEQUENCE associer_unite_connaissance_o_pk_associer_unite_connaissanc_seq
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


--
-- TOC entry 2441 (class 0 OID 0)
-- Dependencies: 199
-- Name: associer_unite_connaissance_o_pk_associer_unite_connaissanc_seq; Type: SEQUENCE OWNED BY; Schema: tables_uc; Owner: -
--

ALTER SEQUENCE associer_unite_connaissance_o_pk_associer_unite_connaissanc_seq OWNED BY associer_unite_connaissance_objet.pk_associer_unite_connaissance_objet;


--
-- TOC entry 200 (class 1259 OID 37902)
-- Name: date_unite_connaissance; Type: TABLE; Schema: tables_uc; Owner: -; Tablespace: 
--

CREATE TABLE date_unite_connaissance (
    pk_date_unite_connaissance integer NOT NULL,
    fk_type_date integer,
    libelle_selon_source text,
    annee integer,
    mois integer,
    jour integer,
    date_recomposee character varying(20),
    certitude_date smallint,
    qualificatif_date smallint,
    marge_date integer,
    heures integer,
    minutes integer,
    secondes integer,
    descriptif text,
    notes text,
    fk_unite_connaissance integer
);


--
-- TOC entry 201 (class 1259 OID 37908)
-- Name: date_unite_connaissance_pk_date_unite_connaissance_seq; Type: SEQUENCE; Schema: tables_uc; Owner: -
--

CREATE SEQUENCE date_unite_connaissance_pk_date_unite_connaissance_seq
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


--
-- TOC entry 2442 (class 0 OID 0)
-- Dependencies: 201
-- Name: date_unite_connaissance_pk_date_unite_connaissance_seq; Type: SEQUENCE OWNED BY; Schema: tables_uc; Owner: -
--

ALTER SEQUENCE date_unite_connaissance_pk_date_unite_connaissance_seq OWNED BY date_unite_connaissance.pk_date_unite_connaissance;


--
-- TOC entry 202 (class 1259 OID 37910)
-- Name: propriete_objet_associe; Type: TABLE; Schema: tables_uc; Owner: -; Tablespace: 
--

CREATE TABLE propriete_objet_associe (
    pk_propriete_objet_associe integer NOT NULL,
    fk_role integer,
    fk_type_propriete integer,
    fk_valeur_propriete integer,
    fk_unite_mesure integer,
    valeur_propriete_texte text,
    valeur_propriete_nombre numeric,
    notes text,
    date_creation timestamp without time zone
);


--
-- TOC entry 203 (class 1259 OID 37916)
-- Name: propriete_objet_associe_pk_propriete_objet_associe_seq; Type: SEQUENCE; Schema: tables_uc; Owner: -
--

CREATE SEQUENCE propriete_objet_associe_pk_propriete_objet_associe_seq
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


--
-- TOC entry 2443 (class 0 OID 0)
-- Dependencies: 203
-- Name: propriete_objet_associe_pk_propriete_objet_associe_seq; Type: SEQUENCE OWNED BY; Schema: tables_uc; Owner: -
--

ALTER SEQUENCE propriete_objet_associe_pk_propriete_objet_associe_seq OWNED BY propriete_objet_associe.pk_propriete_objet_associe;


--
-- TOC entry 204 (class 1259 OID 37918)
-- Name: propriete_texte; Type: TABLE; Schema: tables_uc; Owner: -; Tablespace: 
--

CREATE TABLE propriete_texte (
    pk_propriete_texte integer NOT NULL,
    texte text,
    descriptif text,
    notes text,
    code_langue character(3),
    fk_unite_connaissance integer,
    fk_type_propriete integer
);


--
-- TOC entry 205 (class 1259 OID 37924)
-- Name: propriete_texte_pk_propriete_texte_seq; Type: SEQUENCE; Schema: tables_uc; Owner: -
--

CREATE SEQUENCE propriete_texte_pk_propriete_texte_seq
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


--
-- TOC entry 2444 (class 0 OID 0)
-- Dependencies: 205
-- Name: propriete_texte_pk_propriete_texte_seq; Type: SEQUENCE OWNED BY; Schema: tables_uc; Owner: -
--

ALTER SEQUENCE propriete_texte_pk_propriete_texte_seq OWNED BY propriete_texte.pk_propriete_texte;


--
-- TOC entry 206 (class 1259 OID 37926)
-- Name: role; Type: TABLE; Schema: tables_uc; Owner: -; Tablespace: 
--

CREATE TABLE role (
    pk_role integer NOT NULL,
    libelle_selon_source text,
    valeur_numerique numeric,
    si_sujet_uc boolean,
    descriptif text,
    notes text,
    date_creation timestamp without time zone,
    fk_unite_connaissance integer,
    fk_objet_associe integer,
    fk_unite_connaissance_associee integer,
    fk_unite_mesure integer,
    fk_role_associe integer,
    notes_role_associe text,
    fk_type_role integer,
    fk_qualificatif_objet integer,
    fk_uc_qualificatif_objet integer,
    fk_qualificatif_role integer
);


--
-- TOC entry 207 (class 1259 OID 37932)
-- Name: role_pk_role_seq; Type: SEQUENCE; Schema: tables_uc; Owner: -
--

CREATE SEQUENCE role_pk_role_seq
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


--
-- TOC entry 2445 (class 0 OID 0)
-- Dependencies: 207
-- Name: role_pk_role_seq; Type: SEQUENCE OWNED BY; Schema: tables_uc; Owner: -
--

ALTER SEQUENCE role_pk_role_seq OWNED BY role.pk_role;


--
-- TOC entry 208 (class 1259 OID 37934)
-- Name: sourcer; Type: TABLE; Schema: tables_uc; Owner: -; Tablespace: 
--

CREATE TABLE sourcer (
    pk_sourcer integer NOT NULL,
    reference_precise text,
    descriptif text,
    notes text,
    fk_unite_connaissance integer,
    fk_objet integer
);


--
-- TOC entry 209 (class 1259 OID 37940)
-- Name: sourcer_pk_sourcer_seq; Type: SEQUENCE; Schema: tables_uc; Owner: -
--

CREATE SEQUENCE sourcer_pk_sourcer_seq
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


--
-- TOC entry 2446 (class 0 OID 0)
-- Dependencies: 209
-- Name: sourcer_pk_sourcer_seq; Type: SEQUENCE OWNED BY; Schema: tables_uc; Owner: -
--

ALTER SEQUENCE sourcer_pk_sourcer_seq OWNED BY sourcer.pk_sourcer;


--
-- TOC entry 210 (class 1259 OID 37942)
-- Name: unite_connaissance; Type: TABLE; Schema: tables_uc; Owner: -; Tablespace: 
--

CREATE TABLE unite_connaissance (
    pk_unite_connaissance integer NOT NULL,
    descriptif text,
    notes text,
    date_creation timestamp without time zone,
    fk_type_unite_connaissance integer
);


--
-- TOC entry 211 (class 1259 OID 37948)
-- Name: unite_connaissance_pk_unite_connaissance_seq; Type: SEQUENCE; Schema: tables_uc; Owner: -
--

CREATE SEQUENCE unite_connaissance_pk_unite_connaissance_seq
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


--
-- TOC entry 2447 (class 0 OID 0)
-- Dependencies: 211
-- Name: unite_connaissance_pk_unite_connaissance_seq; Type: SEQUENCE OWNED BY; Schema: tables_uc; Owner: -
--

ALTER SEQUENCE unite_connaissance_pk_unite_connaissance_seq OWNED BY unite_connaissance.pk_unite_connaissance;


--
-- TOC entry 212 (class 1259 OID 37950)
-- Name: v_libelle_uc; Type: VIEW; Schema: tables_uc; Owner: -
--

CREATE VIEW v_libelle_uc AS
 SELECT t1.pk_unite_connaissance, 
        CASE
            WHEN ((t1.descriptif IS NULL) OR (t1.descriptif = ''::text)) THEN t2.nom
            ELSE t1.descriptif
        END AS libelle_uc, 
    t1.fk_type_unite_connaissance
   FROM (unite_connaissance t1
   JOIN tables_types.type_unite_connaissance t2 ON ((t2.pk_type_unite_connaissance = t1.fk_type_unite_connaissance)));


--
-- TOC entry 213 (class 1259 OID 37954)
-- Name: v_associations_uc_objets; Type: VIEW; Schema: tables_uc; Owner: -
--

CREATE VIEW v_associations_uc_objets AS
 SELECT t1.pk_associer_unite_connaissance_objet, 
    t1.fk_unite_connaissance, 
    t1.fk_objet, 
    t1.fk_type_association_objet AS fk_type_association, 
    t1.reference_precise, 
    t1.descriptif, 
    t1.notes, 
        CASE
            WHEN (t1.fk_type_association_objet = 84) THEN 'UC classée par '::text
            WHEN (t1.fk_type_association_objet = 85) THEN 'UC documentée par '::text
            ELSE NULL::text
        END AS type_association, 
    t2.nom AS nom_objet, 
    t4.nom AS sous_type_objet, 
    t5.libelle_uc
   FROM ((((associer_unite_connaissance_objet t1
   LEFT JOIN tables_objet.v_noms_standards_objets_dans_ordre_chronologique t2 ON ((t2.fk_objet = t1.fk_objet)))
   LEFT JOIN tables_objet.objet t3 ON ((t3.pk_objet = t1.fk_objet)))
   LEFT JOIN tables_types.parametre t4 ON ((t4.pk_parametre = t3.fk_sous_type_objet)))
   LEFT JOIN v_libelle_uc t5 ON ((t5.pk_unite_connaissance = t1.fk_unite_connaissance)));


--
-- TOC entry 214 (class 1259 OID 37959)
-- Name: v_autres_objets_uc; Type: VIEW; Schema: tables_uc; Owner: -
--

CREATE VIEW v_autres_objets_uc AS
 SELECT t1.fk_unite_connaissance, 
    array_to_string(ARRAY( SELECT unnest(array_agg(
                CASE
                    WHEN (t3.nom IS NOT NULL) THEN t3.nom
                    ELSE t2.libelle_uc
                END)) AS unnest
          ORDER BY unnest(array_agg(
                CASE
                    WHEN (t3.nom IS NOT NULL) THEN t3.nom
                    ELSE t2.libelle_uc
                END))), ', '::text) AS autres_objets_uc
   FROM ((role t1
   LEFT JOIN v_libelle_uc t2 ON ((t2.pk_unite_connaissance = t1.fk_unite_connaissance_associee)))
   LEFT JOIN tables_objet.v_noms_standards_objets_dans_ordre_chronologique t3 ON ((t3.fk_objet = t1.fk_objet_associe)))
  WHERE (t1.si_sujet_uc IS NOT TRUE)
  GROUP BY t1.fk_unite_connaissance;


--
-- TOC entry 215 (class 1259 OID 37964)
-- Name: v_date_standard_uc; Type: VIEW; Schema: tables_uc; Owner: -
--

CREATE VIEW v_date_standard_uc AS
 SELECT date_unite_connaissance.fk_unite_connaissance, 
    (ARRAY( SELECT unnest(array_agg(date_unite_connaissance.date_recomposee)) AS unnest
          ORDER BY unnest(array_agg(date_unite_connaissance.fk_type_date))))[1] AS date_standard
   FROM date_unite_connaissance
  GROUP BY date_unite_connaissance.fk_unite_connaissance;


--
-- TOC entry 216 (class 1259 OID 37968)
-- Name: v_sujet_uc; Type: VIEW; Schema: tables_uc; Owner: -
--

CREATE VIEW v_sujet_uc AS
 SELECT t1.fk_unite_connaissance, 
    array_to_string(ARRAY( SELECT unnest(array_agg(
                CASE
                    WHEN (t3.nom IS NOT NULL) THEN t3.nom
                    ELSE t2.libelle_uc
                END)) AS unnest
          ORDER BY unnest(array_agg(
                CASE
                    WHEN (t3.nom IS NOT NULL) THEN t3.nom
                    ELSE t2.libelle_uc
                END))), ', '::text) AS sujet_uc
   FROM ((role t1
   LEFT JOIN v_libelle_uc t2 ON ((t2.pk_unite_connaissance = t1.fk_unite_connaissance_associee)))
   LEFT JOIN tables_objet.v_noms_standards_objets_dans_ordre_chronologique t3 ON ((t3.fk_objet = t1.fk_objet_associe)))
  WHERE (t1.si_sujet_uc IS TRUE)
  GROUP BY t1.fk_unite_connaissance;


--
-- TOC entry 217 (class 1259 OID 37973)
-- Name: v_role_avec_uc; Type: VIEW; Schema: tables_uc; Owner: -
--

CREATE VIEW v_role_avec_uc AS
 SELECT t1.pk_role, 
    t1.fk_objet_associe, 
    t1.fk_unite_connaissance_associee, 
        CASE
            WHEN ((t6.nom IS NOT NULL) OR (t6.nom <> ''::text)) THEN t6.nom
            ELSE t8.libelle_uc
        END AS objet_uc_associee, 
    t1.fk_type_role, 
    t1.descriptif AS descriptif_role, 
    t7.nom AS type_role, 
    t1.libelle_selon_source, 
    t1.si_sujet_uc, 
    t1.valeur_numerique, 
    t4.nom AS unite_mesure, 
    t9.sujet_uc, 
    t10.autres_objets_uc, 
    t2.libelle_uc, 
    t11.descriptif, 
    t3.date_standard, 
    t2.fk_type_unite_connaissance AS cle_type_uc, 
    t5.nom AS type_uc, 
    t2.pk_unite_connaissance
   FROM ((((((((((role t1
   JOIN unite_connaissance t11 ON ((t11.pk_unite_connaissance = t1.fk_unite_connaissance)))
   LEFT JOIN v_libelle_uc t2 ON ((t2.pk_unite_connaissance = t1.fk_unite_connaissance)))
   LEFT JOIN tables_types.type_unite_connaissance t5 ON ((t5.pk_type_unite_connaissance = t2.fk_type_unite_connaissance)))
   LEFT JOIN tables_types.type_role t7 ON ((t7.pk_type_role = t1.fk_type_role)))
   LEFT JOIN v_date_standard_uc t3 ON ((t3.fk_unite_connaissance = t1.fk_unite_connaissance)))
   LEFT JOIN tables_objet.v_noms_standards_objets_dans_ordre_chronologique t6 ON ((t6.fk_objet = t1.fk_objet_associe)))
   LEFT JOIN v_libelle_uc t8 ON ((t8.pk_unite_connaissance = t1.fk_unite_connaissance_associee)))
   LEFT JOIN tables_objet.v_noms_standards_objets_dans_ordre_chronologique t4 ON ((t4.fk_objet = t1.fk_unite_mesure)))
   LEFT JOIN v_sujet_uc t9 ON ((t9.fk_unite_connaissance = t1.fk_unite_connaissance)))
   LEFT JOIN v_autres_objets_uc t10 ON ((t10.fk_unite_connaissance = t1.fk_unite_connaissance)));


--
-- TOC entry 218 (class 1259 OID 37978)
-- Name: v_sources_avec_libelles; Type: VIEW; Schema: tables_uc; Owner: -
--

CREATE VIEW v_sources_avec_libelles AS
 SELECT t1.fk_unite_connaissance, 
    t3.libelle_uc, 
    t1.fk_objet, 
    t2.nom AS source, 
    t5.nom AS sous_type_objet, 
    t1.reference_precise, 
    t1.descriptif, 
    t1.notes, 
    t1.pk_sourcer
   FROM ((((sourcer t1
   LEFT JOIN tables_objet.v_noms_standards_objets_dans_ordre_chronologique t2 ON ((t2.fk_objet = t1.fk_objet)))
   LEFT JOIN tables_objet.objet t4 ON ((t4.pk_objet = t1.fk_objet)))
   LEFT JOIN tables_types.parametre t5 ON ((t5.pk_parametre = t4.fk_sous_type_objet)))
   LEFT JOIN v_libelle_uc t3 ON ((t3.pk_unite_connaissance = t1.fk_unite_connaissance)));


--
-- TOC entry 2274 (class 2604 OID 37983)
-- Name: pk_associer_unite_connaissance_objet; Type: DEFAULT; Schema: tables_uc; Owner: -
--

ALTER TABLE ONLY associer_unite_connaissance_objet ALTER COLUMN pk_associer_unite_connaissance_objet SET DEFAULT nextval('associer_unite_connaissance_o_pk_associer_unite_connaissanc_seq'::regclass);


--
-- TOC entry 2275 (class 2604 OID 37984)
-- Name: pk_date_unite_connaissance; Type: DEFAULT; Schema: tables_uc; Owner: -
--

ALTER TABLE ONLY date_unite_connaissance ALTER COLUMN pk_date_unite_connaissance SET DEFAULT nextval('date_unite_connaissance_pk_date_unite_connaissance_seq'::regclass);


--
-- TOC entry 2276 (class 2604 OID 37985)
-- Name: pk_propriete_objet_associe; Type: DEFAULT; Schema: tables_uc; Owner: -
--

ALTER TABLE ONLY propriete_objet_associe ALTER COLUMN pk_propriete_objet_associe SET DEFAULT nextval('propriete_objet_associe_pk_propriete_objet_associe_seq'::regclass);


--
-- TOC entry 2277 (class 2604 OID 37986)
-- Name: pk_propriete_texte; Type: DEFAULT; Schema: tables_uc; Owner: -
--

ALTER TABLE ONLY propriete_texte ALTER COLUMN pk_propriete_texte SET DEFAULT nextval('propriete_texte_pk_propriete_texte_seq'::regclass);


--
-- TOC entry 2278 (class 2604 OID 37987)
-- Name: pk_role; Type: DEFAULT; Schema: tables_uc; Owner: -
--

ALTER TABLE ONLY role ALTER COLUMN pk_role SET DEFAULT nextval('role_pk_role_seq'::regclass);


--
-- TOC entry 2279 (class 2604 OID 37988)
-- Name: pk_sourcer; Type: DEFAULT; Schema: tables_uc; Owner: -
--

ALTER TABLE ONLY sourcer ALTER COLUMN pk_sourcer SET DEFAULT nextval('sourcer_pk_sourcer_seq'::regclass);


--
-- TOC entry 2280 (class 2604 OID 37989)
-- Name: pk_unite_connaissance; Type: DEFAULT; Schema: tables_uc; Owner: -
--

ALTER TABLE ONLY unite_connaissance ALTER COLUMN pk_unite_connaissance SET DEFAULT nextval('unite_connaissance_pk_unite_connaissance_seq'::regclass);


--
-- TOC entry 2282 (class 2606 OID 37991)
-- Name: associer_unite_connaissance_objet_pkey; Type: CONSTRAINT; Schema: tables_uc; Owner: -; Tablespace: 
--

ALTER TABLE ONLY associer_unite_connaissance_objet
    ADD CONSTRAINT associer_unite_connaissance_objet_pkey PRIMARY KEY (pk_associer_unite_connaissance_objet);


--
-- TOC entry 2284 (class 2606 OID 37993)
-- Name: date_unite_connaissance_pkey; Type: CONSTRAINT; Schema: tables_uc; Owner: -; Tablespace: 
--

ALTER TABLE ONLY date_unite_connaissance
    ADD CONSTRAINT date_unite_connaissance_pkey PRIMARY KEY (pk_date_unite_connaissance);


--
-- TOC entry 2287 (class 2606 OID 37995)
-- Name: propriete_objet_associe_pkey; Type: CONSTRAINT; Schema: tables_uc; Owner: -; Tablespace: 
--

ALTER TABLE ONLY propriete_objet_associe
    ADD CONSTRAINT propriete_objet_associe_pkey PRIMARY KEY (pk_propriete_objet_associe);


--
-- TOC entry 2289 (class 2606 OID 37997)
-- Name: propriete_texte_pkey; Type: CONSTRAINT; Schema: tables_uc; Owner: -; Tablespace: 
--

ALTER TABLE ONLY propriete_texte
    ADD CONSTRAINT propriete_texte_pkey PRIMARY KEY (pk_propriete_texte);


--
-- TOC entry 2292 (class 2606 OID 37999)
-- Name: role_pkey; Type: CONSTRAINT; Schema: tables_uc; Owner: -; Tablespace: 
--

ALTER TABLE ONLY role
    ADD CONSTRAINT role_pkey PRIMARY KEY (pk_role);


--
-- TOC entry 2295 (class 2606 OID 38001)
-- Name: sourcer_pkey; Type: CONSTRAINT; Schema: tables_uc; Owner: -; Tablespace: 
--

ALTER TABLE ONLY sourcer
    ADD CONSTRAINT sourcer_pkey PRIMARY KEY (pk_sourcer);


--
-- TOC entry 2297 (class 2606 OID 38003)
-- Name: unite_connaissance_pkey; Type: CONSTRAINT; Schema: tables_uc; Owner: -; Tablespace: 
--

ALTER TABLE ONLY unite_connaissance
    ADD CONSTRAINT unite_connaissance_pkey PRIMARY KEY (pk_unite_connaissance);


--
-- TOC entry 2290 (class 1259 OID 38004)
-- Name: fki_cle_role; Type: INDEX; Schema: tables_uc; Owner: -; Tablespace: 
--

CREATE INDEX fki_cle_role ON role USING btree (fk_unite_connaissance);


--
-- TOC entry 2285 (class 1259 OID 38005)
-- Name: fki_fkc_date; Type: INDEX; Schema: tables_uc; Owner: -; Tablespace: 
--

CREATE INDEX fki_fkc_date ON date_unite_connaissance USING btree (fk_unite_connaissance);


--
-- TOC entry 2293 (class 1259 OID 38006)
-- Name: fki_fkc_sourcer; Type: INDEX; Schema: tables_uc; Owner: -; Tablespace: 
--

CREATE INDEX fki_fkc_sourcer ON sourcer USING btree (fk_unite_connaissance);


--
-- TOC entry 2302 (class 2620 OID 38007)
-- Name: set_concatenated_date; Type: TRIGGER; Schema: tables_uc; Owner: -
--

CREATE TRIGGER set_concatenated_date BEFORE INSERT OR UPDATE ON date_unite_connaissance FOR EACH ROW EXECUTE PROCEDURE create_info_date_concatenated_date();


--
-- TOC entry 2298 (class 2606 OID 38008)
-- Name: fkc_date; Type: FK CONSTRAINT; Schema: tables_uc; Owner: -
--

ALTER TABLE ONLY date_unite_connaissance
    ADD CONSTRAINT fkc_date FOREIGN KEY (fk_unite_connaissance) REFERENCES unite_connaissance(pk_unite_connaissance) ON DELETE CASCADE;


--
-- TOC entry 2299 (class 2606 OID 38013)
-- Name: fkc_propriete_texte; Type: FK CONSTRAINT; Schema: tables_uc; Owner: -
--

ALTER TABLE ONLY propriete_texte
    ADD CONSTRAINT fkc_propriete_texte FOREIGN KEY (fk_unite_connaissance) REFERENCES unite_connaissance(pk_unite_connaissance) ON DELETE CASCADE;


--
-- TOC entry 2300 (class 2606 OID 38018)
-- Name: fkc_role; Type: FK CONSTRAINT; Schema: tables_uc; Owner: -
--

ALTER TABLE ONLY role
    ADD CONSTRAINT fkc_role FOREIGN KEY (fk_unite_connaissance) REFERENCES unite_connaissance(pk_unite_connaissance) ON DELETE CASCADE;


--
-- TOC entry 2301 (class 2606 OID 38023)
-- Name: fkc_sourcer; Type: FK CONSTRAINT; Schema: tables_uc; Owner: -
--

ALTER TABLE ONLY sourcer
    ADD CONSTRAINT fkc_sourcer FOREIGN KEY (fk_unite_connaissance) REFERENCES unite_connaissance(pk_unite_connaissance) ON DELETE CASCADE;


-- Completed on 2014-02-25 11:18:40 CET

--
-- PostgreSQL database dump complete
--

