--
-- PostgreSQL database dump
--

-- Dumped from database version 9.3.1
-- Dumped by pg_dump version 9.3.1
-- Started on 2014-02-25 11:19:10 CET

SET statement_timeout = 0;
SET lock_timeout = 0;
SET client_encoding = 'UTF8';
SET standard_conforming_strings = on;
SET check_function_bodies = false;
SET client_min_messages = warning;

--
-- TOC entry 10 (class 2615 OID 38029)
-- Name: vues_sql; Type: SCHEMA; Schema: -; Owner: -
--

CREATE SCHEMA vues_sql;


SET search_path = vues_sql, pg_catalog;

--
-- TOC entry 247 (class 1255 OID 38030)
-- Name: objet_ascendants_descendants(integer); Type: FUNCTION; Schema: vues_sql; Owner: -
--

CREATE FUNCTION objet_ascendants_descendants(integer) RETURNS TABLE(fk_objet_concerne integer, objet_concerne text, type_objet_concerne text, type_association text, fk_objet_associe integer, objet_associe text, type_objet_associe text, profondeur integer, _path integer[])
    LANGUAGE sql
    AS $_$
/* ATTENTION : cette fonction est utilisée dans le code PHP pour l'affichage des hiérarchies d'objets.
	Ne pas supprimer!
*/


/* En utilisant deux requêtes récursives combinées, cette fonction chercher tous les parents et ancêtres, 
ainsi que tous les enfants et descendants d'un objet, au sens de l'association entre un objet concerné et ses associés, ou l'inverse */
(
(
WITH RECURSIVE liste_associations (fk_objet_concerne, objet_concerne, type_objet_concerne, type_association, fk_objet_associe, objet_associe, type_objet_associe, profondeur, _path, _cycle) AS
(
  SELECT fk_objet_concerne,
         t4.nom,
         t6.type_objet,
         t3.nom,
         fk_objet_associe,
         t5.nom,
         t7.type_objet,
         1,
         ARRAY [fk_objet_concerne],
         FALSE
  FROM tables_objet.associer_objet t1,
       tables_types.parametre t3,
       tables_objet.v_noms_standards_objets_dans_ordre_chronologique t4,
       tables_objet.v_noms_standards_objets_dans_ordre_chronologique t5,
       tables_objet.v_objet_avec_type t6,
       tables_objet.v_objet_avec_type t7
  WHERE t1.fk_objet_concerne = $1
  AND   t1.fk_type_association_objet = t3.pk_parametre
  AND   t1.fk_objet_concerne = t4.fk_objet
  AND   t1.fk_objet_associe = t5.fk_objet
  AND   t1.fk_objet_concerne = t6.pk_objet
  AND   t1.fk_objet_associe = t7.pk_objet
  UNION
  SELECT t1.fk_objet_concerne,
         t4.nom,
         t6.type_objet,
         t3.nom,
         t1.fk_objet_associe,
         t5.nom,
         t7.type_objet,
         t2.profondeur + 1,
         _path|| t1.fk_objet_concerne,
         t1.fk_objet_concerne = ANY (_path)
  FROM tables_objet.associer_objet t1,
       liste_associations t2,
       tables_types.parametre t3,
       tables_objet.v_noms_standards_objets_dans_ordre_chronologique t4,
       tables_objet.v_noms_standards_objets_dans_ordre_chronologique t5,
       tables_objet.v_objet_avec_type t6,
       tables_objet.v_objet_avec_type t7
  WHERE t2.fk_objet_associe = t1.fk_objet_concerne
  AND   _cycle IS FALSE
  AND   t1.fk_type_association_objet = t3.pk_parametre
  AND   t1.fk_objet_concerne = t4.fk_objet
  AND   t1.fk_objet_associe = t5.fk_objet
  AND   t1.fk_objet_concerne = t6.pk_objet
  AND   t1.fk_objet_associe = t7.pk_objet
)
SELECT DISTINCT fk_objet_concerne,
       objet_concerne,
       type_objet_concerne,
       type_association,
       fk_objet_associe,
       objet_associe,
       type_objet_associe,
       profondeur,
       _path
FROM liste_associations
WHERE _cycle IS NOT TRUE
)

UNION

(
WITH RECURSIVE liste_associations (fk_objet_concerne, objet_concerne, type_objet_concerne, type_association, fk_objet_associe, objet_associe, type_objet_associe, profondeur, _path, _cycle) AS
(
  SELECT fk_objet_concerne,
         t4.nom,
         t6.type_objet,
         t3.nom,
         fk_objet_associe,
         t5.nom,
         t7.type_objet,
         -1,
         ARRAY [fk_objet_concerne],
         FALSE
  FROM tables_objet.associer_objet t1,
       tables_types.parametre t3,
       tables_objet.v_noms_standards_objets_dans_ordre_chronologique t4,
       tables_objet.v_noms_standards_objets_dans_ordre_chronologique t5,
       tables_objet.v_objet_avec_type t6,
       tables_objet.v_objet_avec_type t7
  WHERE t1.fk_objet_associe = $1
  AND   t1.fk_type_association_objet = t3.pk_parametre
  AND   t1.fk_objet_concerne = t4.fk_objet
  AND   t1.fk_objet_associe = t5.fk_objet
  AND   t1.fk_objet_concerne = t6.pk_objet
  AND   t1.fk_objet_associe = t7.pk_objet
  UNION
  SELECT t1.fk_objet_concerne,
         t4.nom,
         t6.type_objet,
         t3.nom,
         t1.fk_objet_associe,
         t5.nom,
         t7.type_objet,
         t2.profondeur - 1,
         _path|| t1.fk_objet_concerne,
         t1.fk_objet_concerne = ANY (_path)
  FROM tables_objet.associer_objet t1,
       liste_associations t2,
       tables_types.parametre t3,
       tables_objet.v_noms_standards_objets_dans_ordre_chronologique t4,
       tables_objet.v_noms_standards_objets_dans_ordre_chronologique t5,
       tables_objet.v_objet_avec_type t6,
       tables_objet.v_objet_avec_type t7
  WHERE t1.fk_objet_associe = t2.fk_objet_concerne
  AND   _cycle IS FALSE
  AND   t1.fk_type_association_objet = t3.pk_parametre
  AND   t1.fk_objet_concerne = t4.fk_objet
  AND   t1.fk_objet_associe = t5.fk_objet
  AND   t1.fk_objet_concerne = t6.pk_objet
  AND   t1.fk_objet_associe = t7.pk_objet
)
SELECT DISTINCT fk_objet_concerne,
       objet_concerne,
       type_objet_concerne,
       type_association,
       fk_objet_associe,
       objet_associe,
       type_objet_associe,
       profondeur,
       _path
FROM liste_associations
WHERE _cycle IS NOT TRUE
)

ORDER BY profondeur
)

$_$;


--
-- TOC entry 224 (class 1259 OID 38055)
-- Name: v_objet_date_debut_recomposee; Type: VIEW; Schema: vues_sql; Owner: -
--

CREATE VIEW v_objet_date_debut_recomposee AS
 WITH ta1 AS (
         SELECT objet.pk_objet, 
                CASE
                    WHEN ((objet.annee_debut IS NOT NULL) AND (objet.mois_debut IS NULL)) THEN to_char(objet.annee_debut, '0000'::text)
                    WHEN (((objet.annee_debut IS NOT NULL) AND (objet.mois_debut IS NOT NULL)) AND (objet.jour_debut IS NULL)) THEN ((to_char(objet.annee_debut, '0000'::text) || '-'::text) || "substring"(to_char(objet.mois_debut, '00'::text), 2, 5))
                    WHEN (((objet.annee_debut IS NOT NULL) AND (objet.mois_debut IS NOT NULL)) AND (objet.jour_debut IS NOT NULL)) THEN ((((to_char(objet.annee_debut, '0000'::text) || '-'::text) || "substring"(to_char(objet.mois_debut, '00'::text), 2, 5)) || '-'::text) || "substring"(to_char(objet.jour_debut, '00'::text), 2, 5))
                    ELSE NULL::text
                END AS date_debut_recomposee, 
            objet.certitude_dd
           FROM tables_objet.objet
        )
 SELECT ta1.pk_objet, 
        CASE
            WHEN (ta1.certitude_dd = 2) THEN (ta1.date_debut_recomposee || ' r'::text)
            WHEN (ta1.certitude_dd = 3) THEN (ta1.date_debut_recomposee || ' p'::text)
            ELSE ta1.date_debut_recomposee
        END AS date_debut_recomposee
   FROM ta1;


--
-- TOC entry 219 (class 1259 OID 38031)
-- Name: v_association_objets_uc_avec_roles; Type: VIEW; Schema: vues_sql; Owner: -
--

CREATE VIEW v_association_objets_uc_avec_roles AS
         SELECT ('UnCo'::text || t1.fk_unite_connaissance) AS uc, 
            ('UnCo'::text || t1.fk_unite_connaissance_associee) AS objet_associe, 
            t2.fk_type_unite_connaissance AS type_uc, 
            t3.date_standard AS date_uc
           FROM ((tables_uc.role t1
      JOIN tables_uc.unite_connaissance t2 ON ((t2.pk_unite_connaissance = t1.fk_unite_connaissance)))
   JOIN tables_uc.v_date_standard_uc t3 ON ((t3.fk_unite_connaissance = t1.fk_unite_connaissance)))
  WHERE (t1.fk_unite_connaissance_associee > 0)
UNION 
         SELECT ('UnCo'::text || t1.fk_unite_connaissance) AS uc, 
            ('ObPe'::text || t1.fk_objet_associe) AS objet_associe, 
            t2.fk_type_unite_connaissance AS type_uc, 
            t3.date_standard AS date_uc
           FROM ((tables_uc.role t1
      JOIN tables_uc.unite_connaissance t2 ON ((t2.pk_unite_connaissance = t1.fk_unite_connaissance)))
   JOIN tables_uc.v_date_standard_uc t3 ON ((t3.fk_unite_connaissance = t1.fk_unite_connaissance)))
  WHERE (t1.fk_objet_associe > 0);


--
-- TOC entry 220 (class 1259 OID 38036)
-- Name: v_autres_objets_uc; Type: VIEW; Schema: vues_sql; Owner: -
--

CREATE VIEW v_autres_objets_uc AS
 SELECT t1.fk_unite_connaissance, 
    array_to_string(ARRAY( SELECT unnest(array_agg(
                CASE
                    WHEN (t3.nom IS NOT NULL) THEN concat_ws(': '::text, t3.nom, 
                    CASE
                        WHEN (t4.nom IS NOT NULL) THEN t4.nom
                        ELSE concat_ws(' – '::text, t5.sujet_uc, t6.libelle_uc)
                    END)
                    ELSE t2.libelle_uc
                END)) AS unnest
          ORDER BY unnest(array_agg(
                CASE
                    WHEN (t3.nom IS NOT NULL) THEN t3.nom
                    ELSE t2.libelle_uc
                END))), ', '::text) AS autres_objets_uc
   FROM (((((tables_uc.role t1
   LEFT JOIN tables_uc.v_libelle_uc t2 ON ((t2.pk_unite_connaissance = t1.fk_unite_connaissance_associee)))
   LEFT JOIN tables_objet.v_noms_standards_objets_dans_ordre_chronologique t3 ON ((t3.fk_objet = t1.fk_objet_associe)))
   LEFT JOIN tables_objet.v_noms_standards_objets_dans_ordre_chronologique t4 ON ((t4.fk_objet = t1.fk_qualificatif_objet)))
   LEFT JOIN tables_uc.v_sujet_uc t5 ON ((t5.fk_unite_connaissance = t1.fk_uc_qualificatif_objet)))
   LEFT JOIN tables_uc.v_libelle_uc t6 ON ((t6.pk_unite_connaissance = t1.fk_uc_qualificatif_objet)))
  WHERE (t1.si_sujet_uc IS NOT TRUE)
  GROUP BY t1.fk_unite_connaissance;


--
-- TOC entry 221 (class 1259 OID 38041)
-- Name: v_compter_types_soustypes; Type: VIEW; Schema: vues_sql; Owner: -
--

CREATE VIEW v_compter_types_soustypes AS
 SELECT count(*) AS count, 
    v_objet_nom_type_sous_type.type_objet, 
    v_objet_nom_type_sous_type.sous_type_objet
   FROM tables_objet.v_objet_nom_type_sous_type
  WHERE (v_objet_nom_type_sous_type.type_objet IS NOT NULL)
  GROUP BY v_objet_nom_type_sous_type.type_objet, v_objet_nom_type_sous_type.sous_type_objet
  ORDER BY v_objet_nom_type_sous_type.type_objet, v_objet_nom_type_sous_type.sous_type_objet;


--
-- TOC entry 222 (class 1259 OID 38045)
-- Name: v_nom_objets_associes_avec_uc; Type: VIEW; Schema: vues_sql; Owner: -
--

CREATE VIEW v_nom_objets_associes_avec_uc AS
 WITH ta1 AS (
                 SELECT v_association_objets_uc_avec_roles.uc AS obpe_unco
                   FROM v_association_objets_uc_avec_roles
        UNION 
                 SELECT v_association_objets_uc_avec_roles.objet_associe AS obpe_unco
                   FROM v_association_objets_uc_avec_roles
        ), ta2 AS (
         SELECT t1.obpe_unco, 
            t2.nom
           FROM (ta1 t1
      JOIN tables_objet.v_noms_standards_objets_dans_ordre_chronologique t2 ON ((('ObPe'::text || t2.fk_objet) = t1.obpe_unco)))
        ), ta3 AS (
         SELECT t1.obpe_unco, 
            t2.libelle_uc
           FROM (ta1 t1
      JOIN tables_uc.v_libelle_uc t2 ON ((('UnCo'::text || t2.pk_unite_connaissance) = t1.obpe_unco)))
        )
         SELECT ta2.obpe_unco, 
            ta2.nom
           FROM ta2
UNION 
         SELECT ta3.obpe_unco, 
            ta3.libelle_uc AS nom
           FROM ta3;


--
-- TOC entry 223 (class 1259 OID 38050)
-- Name: v_objet_ascendants_descendants; Type: VIEW; Schema: vues_sql; Owner: -
--

CREATE VIEW v_objet_ascendants_descendants AS
        ( WITH RECURSIVE liste_associations(fk_objet_concerne, objet_concerne, type_association, fk_objet_associe, objet_associe, profondeur, _path, _cycle) AS (
                         SELECT t1.fk_objet_concerne, 
                            t4.nom, 
                            t3.nom, 
                            t1.fk_objet_associe, 
                            t5.nom, 
                            0, 
                            ARRAY[t1.fk_objet_concerne] AS "array", 
                            false AS bool
                           FROM (((tables_objet.associer_objet t1
                      JOIN tables_types.parametre t3 ON ((t1.fk_type_association_objet = t3.pk_parametre)))
                 JOIN tables_objet.v_noms_standards_objets_dans_ordre_chronologique t4 ON ((t1.fk_objet_concerne = t4.fk_objet)))
            JOIN tables_objet.v_noms_standards_objets_dans_ordre_chronologique t5 ON ((t1.fk_objet_associe = t5.fk_objet)))
           WHERE (t1.fk_objet_concerne = 610)
                UNION 
                         SELECT t1.fk_objet_concerne, 
                            t4.nom, 
                            t3.nom, 
                            t1.fk_objet_associe, 
                            t5.nom, 
                            (t2.profondeur + 1), 
                            (t2._path || t1.fk_objet_concerne), 
                            (t1.fk_objet_concerne = ANY (t2._path))
                           FROM ((((tables_objet.associer_objet t1
                      JOIN liste_associations t2 ON (((t2.fk_objet_associe = t1.fk_objet_concerne) AND (t2._cycle IS FALSE))))
                 JOIN tables_types.parametre t3 ON ((t1.fk_type_association_objet = t3.pk_parametre)))
            JOIN tables_objet.v_noms_standards_objets_dans_ordre_chronologique t4 ON ((t1.fk_objet_concerne = t4.fk_objet)))
       JOIN tables_objet.v_noms_standards_objets_dans_ordre_chronologique t5 ON ((t1.fk_objet_associe = t5.fk_objet)))
                )
         SELECT DISTINCT liste_associations.fk_objet_concerne, 
            liste_associations.objet_concerne, 
            liste_associations.type_association, 
            liste_associations.fk_objet_associe, 
            liste_associations.objet_associe, 
            liste_associations.profondeur, 
            liste_associations._path, 
            liste_associations._cycle
           FROM liste_associations
          WHERE (liste_associations._cycle IS NOT TRUE))
UNION 
        ( WITH RECURSIVE liste_associations(fk_objet_concerne, objet_concerne, type_association, fk_objet_associe, objet_associe, profondeur, _path, _cycle) AS (
                         SELECT t1.fk_objet_concerne, 
                            t4.nom, 
                            t3.nom, 
                            t1.fk_objet_associe, 
                            t5.nom, 
                            (-1), 
                            ARRAY[t1.fk_objet_concerne] AS "array", 
                            false AS bool
                           FROM (((tables_objet.associer_objet t1
                      JOIN tables_types.parametre t3 ON ((t1.fk_type_association_objet = t3.pk_parametre)))
                 JOIN tables_objet.v_noms_standards_objets_dans_ordre_chronologique t4 ON ((t1.fk_objet_concerne = t4.fk_objet)))
            JOIN tables_objet.v_noms_standards_objets_dans_ordre_chronologique t5 ON ((t1.fk_objet_associe = t5.fk_objet)))
           WHERE (t1.fk_objet_associe = 610)
                UNION 
                         SELECT t1.fk_objet_concerne, 
                            t4.nom, 
                            t3.nom, 
                            t1.fk_objet_associe, 
                            t5.nom, 
                            (t2.profondeur - 1), 
                            (t2._path || t1.fk_objet_concerne), 
                            (t1.fk_objet_concerne = ANY (t2._path))
                           FROM ((((tables_objet.associer_objet t1
                      JOIN liste_associations t2 ON (((t1.fk_objet_associe = t2.fk_objet_concerne) AND (t2._cycle IS FALSE))))
                 JOIN tables_types.parametre t3 ON ((t1.fk_type_association_objet = t3.pk_parametre)))
            JOIN tables_objet.v_noms_standards_objets_dans_ordre_chronologique t4 ON ((t1.fk_objet_concerne = t4.fk_objet)))
       JOIN tables_objet.v_noms_standards_objets_dans_ordre_chronologique t5 ON ((t1.fk_objet_associe = t5.fk_objet)))
                )
         SELECT DISTINCT liste_associations.fk_objet_concerne, 
            liste_associations.objet_concerne, 
            liste_associations.type_association, 
            liste_associations.fk_objet_associe, 
            liste_associations.objet_associe, 
            liste_associations.profondeur, 
            liste_associations._path, 
            liste_associations._cycle
           FROM liste_associations
          WHERE (liste_associations._cycle IS NOT TRUE))
  ORDER BY 6;


--
-- TOC entry 225 (class 1259 OID 38060)
-- Name: v_objet_date_fin_recomposee; Type: VIEW; Schema: vues_sql; Owner: -
--

CREATE VIEW v_objet_date_fin_recomposee AS
 WITH ta1 AS (
         SELECT objet.pk_objet, 
                CASE
                    WHEN ((objet.annee_fin IS NOT NULL) AND (objet.mois_fin IS NULL)) THEN to_char(objet.annee_fin, '0000'::text)
                    WHEN (((objet.annee_fin IS NOT NULL) AND (objet.mois_fin IS NOT NULL)) AND (objet.jour_fin IS NULL)) THEN ((to_char(objet.annee_fin, '0000'::text) || '-'::text) || "substring"(to_char(objet.mois_fin, '00'::text), 2, 5))
                    WHEN (((objet.annee_fin IS NOT NULL) AND (objet.mois_fin IS NOT NULL)) AND (objet.jour_fin IS NOT NULL)) THEN ((((to_char(objet.annee_fin, '0000'::text) || '-'::text) || "substring"(to_char(objet.mois_fin, '00'::text), 2, 5)) || '-'::text) || "substring"(to_char(objet.jour_fin, '00'::text), 2, 5))
                    ELSE NULL::text
                END AS date_fin_recomposee, 
            objet.certitude_df
           FROM tables_objet.objet
        )
 SELECT ta1.pk_objet, 
        CASE
            WHEN (ta1.certitude_df = 2) THEN (ta1.date_fin_recomposee || ' r'::text)
            WHEN (ta1.certitude_df = 3) THEN (ta1.date_fin_recomposee || ' p'::text)
            ELSE ta1.date_fin_recomposee
        END AS date_fin_recomposee
   FROM ta1;


--
-- TOC entry 226 (class 1259 OID 38065)
-- Name: v_proprietes_avec_noms; Type: VIEW; Schema: vues_sql; Owner: -
--

CREATE VIEW v_proprietes_avec_noms AS
 SELECT t1.pk_propriete_objet_associe, 
    t1.fk_role, 
    t1.fk_type_propriete, 
    t2.nom AS type_propriete, 
    t1.fk_valeur_propriete, 
    t3.nom AS valeur_propriete, 
    t1.fk_unite_mesure, 
    t4.nom AS unite_mesure, 
    t1.valeur_propriete_nombre, 
    t1.valeur_propriete_texte, 
    t1.notes, 
    t5.fk_type_role
   FROM ((((tables_uc.propriete_objet_associe t1
   LEFT JOIN tables_objet.v_noms_standards_objets_dans_ordre_chronologique t2 ON ((t2.fk_objet = t1.fk_type_propriete)))
   LEFT JOIN tables_objet.v_noms_standards_objets_dans_ordre_chronologique t3 ON ((t3.fk_objet = t1.fk_valeur_propriete)))
   LEFT JOIN tables_objet.v_noms_standards_objets_dans_ordre_chronologique t4 ON ((t4.fk_objet = t1.fk_unite_mesure)))
   LEFT JOIN tables_uc.role t5 ON ((t5.pk_role = t1.fk_role)));


--
-- TOC entry 227 (class 1259 OID 38070)
-- Name: v_role_avec_uc_avec_qualificatifs; Type: VIEW; Schema: vues_sql; Owner: -
--

CREATE VIEW v_role_avec_uc_avec_qualificatifs AS
 SELECT t1.pk_role, 
    t1.fk_objet_associe, 
    t1.fk_unite_connaissance_associee, 
        CASE
            WHEN ((t6.nom IS NOT NULL) OR (t6.nom <> ''::text)) THEN t6.nom
            ELSE concat_ws(' – '::text, t9.sujet_uc, t8.libelle_uc)
        END AS objet_uc_associee, 
    t1.fk_type_role, 
    t1.descriptif AS descriptif_role, 
    t7.nom AS type_role, 
    t1.libelle_selon_source, 
    t1.si_sujet_uc, 
    t1.valeur_numerique, 
    t4.nom AS unite_mesure, 
    t9.sujet_uc, 
    t10.autres_objets_uc, 
    t2.libelle_uc, 
    t11.descriptif, 
    t3.date_standard, 
    t2.fk_type_unite_connaissance AS cle_type_uc, 
    t5.nom AS type_uc, 
    t2.pk_unite_connaissance, 
    t1.fk_qualificatif_objet, 
    t12.nom AS libelle_qualificatif_objet, 
    t1.fk_uc_qualificatif_objet, 
    t13.libelle_uc AS uc_libelle_qualificatif_objet, 
    t1.fk_qualificatif_role, 
    t14.nom AS libelle_qualificatif_role
   FROM (((((((((((((tables_uc.role t1
   JOIN tables_uc.unite_connaissance t11 ON ((t11.pk_unite_connaissance = t1.fk_unite_connaissance)))
   LEFT JOIN tables_uc.v_libelle_uc t2 ON ((t2.pk_unite_connaissance = t1.fk_unite_connaissance)))
   LEFT JOIN tables_types.type_unite_connaissance t5 ON ((t5.pk_type_unite_connaissance = t2.fk_type_unite_connaissance)))
   LEFT JOIN tables_types.type_role t7 ON ((t7.pk_type_role = t1.fk_type_role)))
   LEFT JOIN tables_uc.v_date_standard_uc t3 ON ((t3.fk_unite_connaissance = t1.fk_unite_connaissance)))
   LEFT JOIN tables_objet.v_noms_standards_objets_dans_ordre_chronologique t6 ON ((t6.fk_objet = t1.fk_objet_associe)))
   LEFT JOIN tables_uc.v_libelle_uc t8 ON ((t8.pk_unite_connaissance = t1.fk_unite_connaissance_associee)))
   LEFT JOIN tables_objet.v_noms_standards_objets_dans_ordre_chronologique t4 ON ((t4.fk_objet = t1.fk_unite_mesure)))
   LEFT JOIN tables_uc.v_sujet_uc t9 ON ((t9.fk_unite_connaissance = t1.fk_unite_connaissance_associee)))
   LEFT JOIN tables_uc.v_autres_objets_uc t10 ON ((t10.fk_unite_connaissance = t1.fk_unite_connaissance)))
   LEFT JOIN tables_objet.v_noms_standards_objets_dans_ordre_chronologique t12 ON ((t12.fk_objet = t1.fk_qualificatif_objet)))
   LEFT JOIN tables_uc.v_libelle_uc t13 ON ((t13.pk_unite_connaissance = t1.fk_uc_qualificatif_objet)))
   LEFT JOIN tables_objet.v_noms_standards_objets_dans_ordre_chronologique t14 ON ((t14.fk_objet = t1.fk_qualificatif_role)));


--
-- TOC entry 228 (class 1259 OID 38075)
-- Name: v_types_uc_avec_effectifs; Type: VIEW; Schema: vues_sql; Owner: -
--

CREATE VIEW v_types_uc_avec_effectifs AS
 SELECT count(*) AS count, 
    t2.nom, 
    t1.fk_type_unite_connaissance
   FROM (tables_uc.unite_connaissance t1
   JOIN tables_types.type_unite_connaissance t2 ON ((t2.pk_type_unite_connaissance = t1.fk_type_unite_connaissance)))
  GROUP BY t1.fk_type_unite_connaissance, t2.nom
  ORDER BY count(*) DESC;


-- Completed on 2014-02-25 11:19:10 CET

--
-- PostgreSQL database dump complete
--

