<?php
/* * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * *
 *                                   ATTENTION!
 * If you see this message in your browser (Internet Explorer, Mozilla Firefox, Google Chrome, etc.)
 * this means that PHP is not properly installed on your web server. Please refer to the PHP manual
 * for more details: http://php.net/manual/install.php 
 *
 * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * *
 */


    include_once dirname(__FILE__) . '/' . 'components/utils/check_utils.php';
    CheckPHPVersion();
    CheckTemplatesCacheFolderIsExistsAndWritable();


    include_once dirname(__FILE__) . '/' . 'phpgen_settings.php';
    include_once dirname(__FILE__) . '/' . 'database_engine/pgsql_engine.php';
    include_once dirname(__FILE__) . '/' . 'components/page.php';


    function GetConnectionOptions()
    {
        $result = GetGlobalConnectionOptions();
        $result['client_encoding'] = 'utf8';
        GetApplication()->GetUserAuthorizationStrategy()->ApplyIdentityToConnectionOptions($result);
        return $result;
    }

    
    // OnGlobalBeforePageExecute event handler
    
    
    // OnBeforePageExecute event handler
    
    
    
    class parametres_parametre_systemePage extends Page
    {
        protected function DoBeforeCreate()
        {
            $this->dataset = new TableDataset(
                new PgConnectionFactory(),
                GetConnectionOptions(),
                '"parametres"."parametre_systeme"');
            $field = new IntegerField('pk_parametre_systeme', null, null, true);
            $field->SetIsNotNull(true);
            $this->dataset->AddField($field, true);
            $field = new StringField('valeur');
            $this->dataset->AddField($field, false);
            $field = new StringField('definition');
            $this->dataset->AddField($field, false);
            $field = new StringField('notes');
            $this->dataset->AddField($field, false);
            $field = new StringField('type_valeur');
            $this->dataset->AddField($field, false);
            $field = new StringField('champ_concerne');
            $this->dataset->AddField($field, false);
            $field = new DateTimeField('date_creation');
            $this->dataset->AddField($field, false);
            $field = new DateTimeField('date_modification');
            $this->dataset->AddField($field, false);
            $field = new StringField('classe_concernee');
            $this->dataset->AddField($field, false);
            $field = new StringField('valeur_inverse');
            $this->dataset->AddField($field, false);
            $this->dataset->AddLookupField('type_valeur', 'vues.vn_type_valeurs', new StringField('type_valeur'), new StringField('type_valeur', 'type_valeur_type_valeur', 'type_valeur_type_valeur_vues_vn_type_valeurs'), 'type_valeur_type_valeur_vues_vn_type_valeurs');
        }
    
        protected function DoPrepare() {
    
        }
    
        protected function CreatePageNavigator()
        {
            $result = new CompositePageNavigator($this);
            
            $partitionNavigator = new PageNavigator('pnav', $this, $this->dataset);
            $partitionNavigator->SetRowsPerPage(20);
            $result->AddPageNavigator($partitionNavigator);
            
            return $result;
        }
    
        public function GetPageList()
        {
            $currentPageCaption = $this->GetShortCaption();
            $result = new PageList($this);
            $result->AddGroup($this->RenderText('Objets'));
            $result->AddGroup($this->RenderText('Paramtres'));
            if (GetCurrentUserGrantForDataSource('vues.vm_objet_vue_de_base')->HasViewGrant())
                $result->AddPage(new PageLink($this->RenderText('Vue de base des objets'), 'vues.vm_objet_vue_de_base.php', $this->RenderText('Vue de base des objets'), $currentPageCaption == $this->RenderText('Vue de base des objets'), false, $this->RenderText('Objets')));
            if (GetCurrentUserGrantForDataSource('parametres.parametre_systeme')->HasViewGrant())
                $result->AddPage(new PageLink($this->RenderText('Paramtres'), 'parametres.parametre_systeme.php', $this->RenderText('Paramtres'), $currentPageCaption == $this->RenderText('Paramtres'), false, $this->RenderText('Paramtres')));
            if (GetCurrentUserGrantForDataSource('objets.date_objet')->HasViewGrant())
                $result->AddPage(new PageLink($this->RenderText('Dates des objets'), 'objets.date_objet.php', $this->RenderText('Dates des objets'), $currentPageCaption == $this->RenderText('Dates des objets'), false, $this->RenderText('Objets')));
            if (GetCurrentUserGrantForDataSource('objets.nom_objet')->HasViewGrant())
                $result->AddPage(new PageLink($this->RenderText('Noms des objets'), 'objets.nom_objet.php', $this->RenderText('Noms des objets'), $currentPageCaption == $this->RenderText('Noms des objets'), false, $this->RenderText('Objets')));
            if (GetCurrentUserGrantForDataSource('vues.vm_association_objets')->HasViewGrant())
                $result->AddPage(new PageLink($this->RenderText('Associations des objets source'), 'vues.vm_association_objets.php', $this->RenderText('Associations des objets source'), $currentPageCaption == $this->RenderText('Associations des objets source'), false, $this->RenderText('Objets')));
            if (GetCurrentUserGrantForDataSource('vues.vm_association_objets_inv')->HasViewGrant())
                $result->AddPage(new PageLink($this->RenderText('Associations des objets cible'), 'vues.vm_association_objets_inv.php', $this->RenderText('Associations des objets cible'), $currentPageCaption == $this->RenderText('Associations des objets cible'), false, $this->RenderText('Objets')));
            
            if ( HasAdminPage() && GetApplication()->HasAdminGrantForCurrentUser() ) {
              $result->AddGroup('Admin area');
              $result->AddPage(new PageLink($this->GetLocalizerCaptions()->GetMessageString('AdminPage'), 'phpgen_admin.php', $this->GetLocalizerCaptions()->GetMessageString('AdminPage'), false, false, 'Admin area'));
            }
            return $result;
        }
    
        protected function CreateRssGenerator()
        {
            return null;
        }
    
        protected function CreateGridSearchControl(Grid $grid)
        {
            $grid->UseFilter = true;
            $grid->SearchControl = new SimpleSearch('parametres_parametre_systemessearch', $this->dataset,
                array('pk_parametre_systeme', 'valeur', 'definition', 'type_valeur_type_valeur', 'valeur_inverse', 'champ_concerne', 'notes', 'date_creation', 'date_modification', 'classe_concernee'),
                array($this->RenderText('Pk Parametre Systeme'), $this->RenderText('Valeur'), $this->RenderText('Definition'), $this->RenderText('Type Valeur'), $this->RenderText('Valeur Inverse'), $this->RenderText('Champ Concerne'), $this->RenderText('Notes'), $this->RenderText('Date Creation'), $this->RenderText('Date Modification'), $this->RenderText('Classe Concernee')),
                array(
                    '=' => $this->GetLocalizerCaptions()->GetMessageString('equals'),
                    '<>' => $this->GetLocalizerCaptions()->GetMessageString('doesNotEquals'),
                    '<' => $this->GetLocalizerCaptions()->GetMessageString('isLessThan'),
                    '<=' => $this->GetLocalizerCaptions()->GetMessageString('isLessThanOrEqualsTo'),
                    '>' => $this->GetLocalizerCaptions()->GetMessageString('isGreaterThan'),
                    '>=' => $this->GetLocalizerCaptions()->GetMessageString('isGreaterThanOrEqualsTo'),
                    'ILIKE' => $this->GetLocalizerCaptions()->GetMessageString('Like'),
                    'STARTS' => $this->GetLocalizerCaptions()->GetMessageString('StartsWith'),
                    'ENDS' => $this->GetLocalizerCaptions()->GetMessageString('EndsWith'),
                    'CONTAINS' => $this->GetLocalizerCaptions()->GetMessageString('Contains')
                    ), $this->GetLocalizerCaptions(), $this, 'CONTAINS'
                );
        }
    
        protected function CreateGridAdvancedSearchControl(Grid $grid)
        {
            $this->AdvancedSearchControl = new AdvancedSearchControl('parametres_parametre_systemeasearch', $this->dataset, $this->GetLocalizerCaptions(), $this->GetColumnVariableContainer(), $this->CreateLinkBuilder());
            $this->AdvancedSearchControl->setTimerInterval(1000);
            $this->AdvancedSearchControl->AddSearchColumn($this->AdvancedSearchControl->CreateStringSearchInput('pk_parametre_systeme', $this->RenderText('Pk Parametre Systeme')));
            $this->AdvancedSearchControl->AddSearchColumn($this->AdvancedSearchControl->CreateStringSearchInput('valeur', $this->RenderText('Valeur')));
            $this->AdvancedSearchControl->AddSearchColumn($this->AdvancedSearchControl->CreateStringSearchInput('definition', $this->RenderText('Definition')));
            
            $lookupDataset = new TableDataset(
                new PgConnectionFactory(),
                GetConnectionOptions(),
                '"vues"."vn_type_valeurs"');
            $field = new StringField('type_valeur');
            $lookupDataset->AddField($field, false);
            $lookupDataset->SetOrderBy('type_valeur', GetOrderTypeAsSQL(otAscending));
            $this->AdvancedSearchControl->AddSearchColumn($this->AdvancedSearchControl->CreateLookupSearchInput('type_valeur', $this->RenderText('Type Valeur'), $lookupDataset, 'type_valeur', 'type_valeur', false, 8));
            $this->AdvancedSearchControl->AddSearchColumn($this->AdvancedSearchControl->CreateStringSearchInput('valeur_inverse', $this->RenderText('Valeur Inverse')));
            $this->AdvancedSearchControl->AddSearchColumn($this->AdvancedSearchControl->CreateStringSearchInput('champ_concerne', $this->RenderText('Champ Concerne')));
            $this->AdvancedSearchControl->AddSearchColumn($this->AdvancedSearchControl->CreateStringSearchInput('notes', $this->RenderText('Notes')));
            $this->AdvancedSearchControl->AddSearchColumn($this->AdvancedSearchControl->CreateDateTimeSearchInput('date_creation', $this->RenderText('Date Creation'), 'Y-m-d H:i:s'));
            $this->AdvancedSearchControl->AddSearchColumn($this->AdvancedSearchControl->CreateDateTimeSearchInput('date_modification', $this->RenderText('Date Modification'), 'Y-m-d H:i:s'));
            $this->AdvancedSearchControl->AddSearchColumn($this->AdvancedSearchControl->CreateStringSearchInput('classe_concernee', $this->RenderText('Classe Concernee')));
        }
    
        protected function AddOperationsColumns(Grid $grid)
        {
            $actionsBandName = 'actions';
            $grid->AddBandToBegin($actionsBandName, $this->GetLocalizerCaptions()->GetMessageString('Actions'), true);
            if ($this->GetSecurityInfo()->HasViewGrant())
            {
                $column = new ModalDialogViewRowColumn(
                    $this->GetLocalizerCaptions()->GetMessageString('View'), $this->dataset,
                    $this->GetLocalizerCaptions()->GetMessageString('View'),
                    $this->GetModalGridViewHandler());
                $grid->AddViewColumn($column, $actionsBandName);
                $column->SetImagePath('images/view_action.png');
            }
        }
    
        protected function AddFieldColumns(Grid $grid)
        {
            //
            // View column for pk_parametre_systeme field
            //
            $column = new TextViewColumn('pk_parametre_systeme', 'Pk Parametre Systeme', $this->dataset);
            $column->SetOrderable(true);
            $column->SetDescription($this->RenderText(''));
            $column->SetFixedWidth(null);
            $grid->AddViewColumn($column);
            
            //
            // View column for valeur field
            //
            $column = new TextViewColumn('valeur', 'Valeur', $this->dataset);
            $column->SetOrderable(true);
            $column->SetMaxLength(75);
            $column->SetFullTextWindowHandlerName('parametres_parametre_systemeGrid_valeur_handler_list');
            $column->SetDescription($this->RenderText(''));
            $column->SetFixedWidth(null);
            $grid->AddViewColumn($column);
            
            //
            // View column for definition field
            //
            $column = new TextViewColumn('definition', 'Definition', $this->dataset);
            $column->SetOrderable(true);
            $column->SetMaxLength(75);
            $column->SetFullTextWindowHandlerName('parametres_parametre_systemeGrid_definition_handler_list');
            $column->SetDescription($this->RenderText(''));
            $column->SetFixedWidth(null);
            $grid->AddViewColumn($column);
            
            //
            // View column for type_valeur field
            //
            $column = new TextViewColumn('type_valeur_type_valeur', 'Type Valeur', $this->dataset);
            $column->SetOrderable(true);
            $column->SetMaxLength(75);
            $column->SetFullTextWindowHandlerName('parametres_parametre_systemeGrid_type_valeur_handler_list');
            $column->SetDescription($this->RenderText(''));
            $column->SetFixedWidth(null);
            $grid->AddViewColumn($column);
            
            //
            // View column for valeur_inverse field
            //
            $column = new TextViewColumn('valeur_inverse', 'Valeur Inverse', $this->dataset);
            $column->SetOrderable(true);
            $column->SetMaxLength(75);
            $column->SetFullTextWindowHandlerName('parametres_parametre_systemeGrid_valeur_inverse_handler_list');
            $column->SetDescription($this->RenderText(''));
            $column->SetFixedWidth(null);
            $grid->AddViewColumn($column);
            
            //
            // View column for champ_concerne field
            //
            $column = new TextViewColumn('champ_concerne', 'Champ Concerne', $this->dataset);
            $column->SetOrderable(true);
            $column->SetMaxLength(75);
            $column->SetFullTextWindowHandlerName('parametres_parametre_systemeGrid_champ_concerne_handler_list');
            $column->SetDescription($this->RenderText(''));
            $column->SetFixedWidth(null);
            $grid->AddViewColumn($column);
            
            //
            // View column for notes field
            //
            $column = new TextViewColumn('notes', 'Notes', $this->dataset);
            $column->SetOrderable(true);
            $column->SetMaxLength(75);
            $column->SetFullTextWindowHandlerName('parametres_parametre_systemeGrid_notes_handler_list');
            $column->SetDescription($this->RenderText(''));
            $column->SetFixedWidth(null);
            $grid->AddViewColumn($column);
            
            //
            // View column for date_creation field
            //
            $column = new DateTimeViewColumn('date_creation', 'Date Creation', $this->dataset);
            $column->SetDateTimeFormat('Y-m-d H:i:s');
            $column->SetOrderable(true);
            $column->SetDescription($this->RenderText(''));
            $column->SetFixedWidth(null);
            $grid->AddViewColumn($column);
            
            //
            // View column for date_modification field
            //
            $column = new DateTimeViewColumn('date_modification', 'Date Modification', $this->dataset);
            $column->SetDateTimeFormat('Y-m-d H:i:s');
            $column->SetOrderable(true);
            $column->SetDescription($this->RenderText(''));
            $column->SetFixedWidth(null);
            $grid->AddViewColumn($column);
            
            //
            // View column for classe_concernee field
            //
            $column = new TextViewColumn('classe_concernee', 'Classe Concernee', $this->dataset);
            $column->SetOrderable(true);
            $column->SetMaxLength(75);
            $column->SetFullTextWindowHandlerName('parametres_parametre_systemeGrid_classe_concernee_handler_list');
            $column->SetDescription($this->RenderText(''));
            $column->SetFixedWidth(null);
            $grid->AddViewColumn($column);
        }
    
        protected function AddSingleRecordViewColumns(Grid $grid)
        {
            //
            // View column for pk_parametre_systeme field
            //
            $column = new TextViewColumn('pk_parametre_systeme', 'Pk Parametre Systeme', $this->dataset);
            $column->SetOrderable(true);
            $grid->AddSingleRecordViewColumn($column);
            
            //
            // View column for valeur field
            //
            $column = new TextViewColumn('valeur', 'Valeur', $this->dataset);
            $column->SetOrderable(true);
            $column->SetMaxLength(75);
            $column->SetFullTextWindowHandlerName('parametres_parametre_systemeGrid_valeur_handler_view');
            $grid->AddSingleRecordViewColumn($column);
            
            //
            // View column for definition field
            //
            $column = new TextViewColumn('definition', 'Definition', $this->dataset);
            $column->SetOrderable(true);
            $grid->AddSingleRecordViewColumn($column);
            
            //
            // View column for type_valeur field
            //
            $column = new TextViewColumn('type_valeur_type_valeur', 'Type Valeur', $this->dataset);
            $column->SetOrderable(true);
            $column->SetMaxLength(75);
            $column->SetFullTextWindowHandlerName('parametres_parametre_systemeGrid_type_valeur_handler_view');
            $grid->AddSingleRecordViewColumn($column);
            
            //
            // View column for valeur_inverse field
            //
            $column = new TextViewColumn('valeur_inverse', 'Valeur Inverse', $this->dataset);
            $column->SetOrderable(true);
            $column->SetMaxLength(75);
            $column->SetFullTextWindowHandlerName('parametres_parametre_systemeGrid_valeur_inverse_handler_view');
            $grid->AddSingleRecordViewColumn($column);
            
            //
            // View column for champ_concerne field
            //
            $column = new TextViewColumn('champ_concerne', 'Champ Concerne', $this->dataset);
            $column->SetOrderable(true);
            $column->SetMaxLength(75);
            $column->SetFullTextWindowHandlerName('parametres_parametre_systemeGrid_champ_concerne_handler_view');
            $grid->AddSingleRecordViewColumn($column);
            
            //
            // View column for notes field
            //
            $column = new TextViewColumn('notes', 'Notes', $this->dataset);
            $column->SetOrderable(true);
            $column->SetMaxLength(75);
            $column->SetFullTextWindowHandlerName('parametres_parametre_systemeGrid_notes_handler_view');
            $grid->AddSingleRecordViewColumn($column);
            
            //
            // View column for date_creation field
            //
            $column = new DateTimeViewColumn('date_creation', 'Date Creation', $this->dataset);
            $column->SetDateTimeFormat('Y-m-d H:i:s');
            $column->SetOrderable(true);
            $grid->AddSingleRecordViewColumn($column);
            
            //
            // View column for date_modification field
            //
            $column = new DateTimeViewColumn('date_modification', 'Date Modification', $this->dataset);
            $column->SetDateTimeFormat('Y-m-d H:i:s');
            $column->SetOrderable(true);
            $grid->AddSingleRecordViewColumn($column);
            
            //
            // View column for classe_concernee field
            //
            $column = new TextViewColumn('classe_concernee', 'Classe Concernee', $this->dataset);
            $column->SetOrderable(true);
            $column->SetMaxLength(75);
            $column->SetFullTextWindowHandlerName('parametres_parametre_systemeGrid_classe_concernee_handler_view');
            $grid->AddSingleRecordViewColumn($column);
        }
    
        protected function AddEditColumns(Grid $grid)
        {
            //
            // Edit column for valeur field
            //
            $editor = new TextAreaEdit('valeur_edit', 50, 8);
            $editColumn = new CustomEditColumn('Valeur', 'valeur', $editor, $this->dataset);
            $editColumn->SetAllowSetToNull(true);
            $this->ApplyCommonColumnEditProperties($editColumn);
            $grid->AddEditColumn($editColumn);
            
            //
            // Edit column for definition field
            //
            $editor = new TextAreaEdit('definition_edit', 50, 8);
            $editColumn = new CustomEditColumn('Definition', 'definition', $editor, $this->dataset);
            $editColumn->SetAllowSetToNull(true);
            $this->ApplyCommonColumnEditProperties($editColumn);
            $grid->AddEditColumn($editColumn);
            
            //
            // Edit column for type_valeur field
            //
            $editor = new ComboBox('type_valeur_edit', $this->GetLocalizerCaptions()->GetMessageString('PleaseSelect'));
            $lookupDataset = new TableDataset(
                new PgConnectionFactory(),
                GetConnectionOptions(),
                '"vues"."vn_type_valeurs"');
            $field = new StringField('type_valeur');
            $lookupDataset->AddField($field, false);
            $lookupDataset->SetOrderBy('type_valeur', GetOrderTypeAsSQL(otAscending));
            $editColumn = new LookUpEditColumn(
                'Type Valeur', 
                'type_valeur', 
                $editor, 
                $this->dataset, 'type_valeur', 'type_valeur', $lookupDataset);
            $editColumn->SetAllowSetToNull(true);
            $this->ApplyCommonColumnEditProperties($editColumn);
            $grid->AddEditColumn($editColumn);
            
            //
            // Edit column for valeur_inverse field
            //
            $editor = new TextAreaEdit('valeur_inverse_edit', 50, 8);
            $editColumn = new CustomEditColumn('Valeur Inverse', 'valeur_inverse', $editor, $this->dataset);
            $editColumn->SetAllowSetToNull(true);
            $this->ApplyCommonColumnEditProperties($editColumn);
            $grid->AddEditColumn($editColumn);
            
            //
            // Edit column for champ_concerne field
            //
            $editor = new TextAreaEdit('champ_concerne_edit', 50, 8);
            $editColumn = new CustomEditColumn('Champ Concerne', 'champ_concerne', $editor, $this->dataset);
            $editColumn->SetAllowSetToNull(true);
            $this->ApplyCommonColumnEditProperties($editColumn);
            $grid->AddEditColumn($editColumn);
            
            //
            // Edit column for notes field
            //
            $editor = new TextAreaEdit('notes_edit', 50, 8);
            $editColumn = new CustomEditColumn('Notes', 'notes', $editor, $this->dataset);
            $editColumn->SetAllowSetToNull(true);
            $this->ApplyCommonColumnEditProperties($editColumn);
            $grid->AddEditColumn($editColumn);
            
            //
            // Edit column for date_creation field
            //
            $editor = new DateTimeEdit('date_creation_edit', true, 'Y-m-d H:i:s', GetFirstDayOfWeek());
            $editColumn = new CustomEditColumn('Date Creation', 'date_creation', $editor, $this->dataset);
            $editColumn->SetAllowSetToNull(true);
            $this->ApplyCommonColumnEditProperties($editColumn);
            $grid->AddEditColumn($editColumn);
            
            //
            // Edit column for date_modification field
            //
            $editor = new DateTimeEdit('date_modification_edit', true, 'Y-m-d H:i:s', GetFirstDayOfWeek());
            $editColumn = new CustomEditColumn('Date Modification', 'date_modification', $editor, $this->dataset);
            $editColumn->SetAllowSetToNull(true);
            $this->ApplyCommonColumnEditProperties($editColumn);
            $grid->AddEditColumn($editColumn);
            
            //
            // Edit column for classe_concernee field
            //
            $editor = new TextAreaEdit('classe_concernee_edit', 50, 8);
            $editColumn = new CustomEditColumn('Classe Concernee', 'classe_concernee', $editor, $this->dataset);
            $editColumn->SetAllowSetToNull(true);
            $this->ApplyCommonColumnEditProperties($editColumn);
            $grid->AddEditColumn($editColumn);
        }
    
        protected function AddInsertColumns(Grid $grid)
        {
            //
            // Edit column for valeur field
            //
            $editor = new TextAreaEdit('valeur_edit', 50, 8);
            $editColumn = new CustomEditColumn('Valeur', 'valeur', $editor, $this->dataset);
            $editColumn->SetAllowSetToNull(true);
            $this->ApplyCommonColumnEditProperties($editColumn);
            $grid->AddInsertColumn($editColumn);
            
            //
            // Edit column for definition field
            //
            $editor = new TextAreaEdit('definition_edit', 50, 8);
            $editColumn = new CustomEditColumn('Definition', 'definition', $editor, $this->dataset);
            $editColumn->SetAllowSetToNull(true);
            $this->ApplyCommonColumnEditProperties($editColumn);
            $grid->AddInsertColumn($editColumn);
            
            //
            // Edit column for type_valeur field
            //
            $editor = new ComboBox('type_valeur_edit', $this->GetLocalizerCaptions()->GetMessageString('PleaseSelect'));
            $lookupDataset = new TableDataset(
                new PgConnectionFactory(),
                GetConnectionOptions(),
                '"vues"."vn_type_valeurs"');
            $field = new StringField('type_valeur');
            $lookupDataset->AddField($field, false);
            $lookupDataset->SetOrderBy('type_valeur', GetOrderTypeAsSQL(otAscending));
            $editColumn = new LookUpEditColumn(
                'Type Valeur', 
                'type_valeur', 
                $editor, 
                $this->dataset, 'type_valeur', 'type_valeur', $lookupDataset);
            $editColumn->SetAllowSetToNull(true);
            $this->ApplyCommonColumnEditProperties($editColumn);
            $grid->AddInsertColumn($editColumn);
            
            //
            // Edit column for valeur_inverse field
            //
            $editor = new TextAreaEdit('valeur_inverse_edit', 50, 8);
            $editColumn = new CustomEditColumn('Valeur Inverse', 'valeur_inverse', $editor, $this->dataset);
            $editColumn->SetAllowSetToNull(true);
            $this->ApplyCommonColumnEditProperties($editColumn);
            $grid->AddInsertColumn($editColumn);
            
            //
            // Edit column for champ_concerne field
            //
            $editor = new TextAreaEdit('champ_concerne_edit', 50, 8);
            $editColumn = new CustomEditColumn('Champ Concerne', 'champ_concerne', $editor, $this->dataset);
            $editColumn->SetAllowSetToNull(true);
            $this->ApplyCommonColumnEditProperties($editColumn);
            $grid->AddInsertColumn($editColumn);
            
            //
            // Edit column for notes field
            //
            $editor = new TextAreaEdit('notes_edit', 50, 8);
            $editColumn = new CustomEditColumn('Notes', 'notes', $editor, $this->dataset);
            $editColumn->SetAllowSetToNull(true);
            $this->ApplyCommonColumnEditProperties($editColumn);
            $grid->AddInsertColumn($editColumn);
            
            //
            // Edit column for date_creation field
            //
            $editor = new DateTimeEdit('date_creation_edit', true, 'Y-m-d H:i:s', GetFirstDayOfWeek());
            $editColumn = new CustomEditColumn('Date Creation', 'date_creation', $editor, $this->dataset);
            $editColumn->SetAllowSetToNull(true);
            $this->ApplyCommonColumnEditProperties($editColumn);
            $grid->AddInsertColumn($editColumn);
            
            //
            // Edit column for date_modification field
            //
            $editor = new DateTimeEdit('date_modification_edit', true, 'Y-m-d H:i:s', GetFirstDayOfWeek());
            $editColumn = new CustomEditColumn('Date Modification', 'date_modification', $editor, $this->dataset);
            $editColumn->SetAllowSetToNull(true);
            $this->ApplyCommonColumnEditProperties($editColumn);
            $grid->AddInsertColumn($editColumn);
            
            //
            // Edit column for classe_concernee field
            //
            $editor = new TextAreaEdit('classe_concernee_edit', 50, 8);
            $editColumn = new CustomEditColumn('Classe Concernee', 'classe_concernee', $editor, $this->dataset);
            $editColumn->SetAllowSetToNull(true);
            $this->ApplyCommonColumnEditProperties($editColumn);
            $grid->AddInsertColumn($editColumn);
            if ($this->GetSecurityInfo()->HasAddGrant())
            {
                $grid->SetShowAddButton(false);
                $grid->SetShowInlineAddButton(false);
            }
            else
            {
                $grid->SetShowInlineAddButton(false);
                $grid->SetShowAddButton(false);
            }
        }
    
        protected function AddPrintColumns(Grid $grid)
        {
            //
            // View column for pk_parametre_systeme field
            //
            $column = new TextViewColumn('pk_parametre_systeme', 'Pk Parametre Systeme', $this->dataset);
            $column->SetOrderable(true);
            $grid->AddPrintColumn($column);
            
            //
            // View column for valeur field
            //
            $column = new TextViewColumn('valeur', 'Valeur', $this->dataset);
            $column->SetOrderable(true);
            $grid->AddPrintColumn($column);
            
            //
            // View column for definition field
            //
            $column = new TextViewColumn('definition', 'Definition', $this->dataset);
            $column->SetOrderable(true);
            $grid->AddPrintColumn($column);
            
            //
            // View column for type_valeur field
            //
            $column = new TextViewColumn('type_valeur', 'Type Valeur', $this->dataset);
            $column->SetOrderable(true);
            $grid->AddPrintColumn($column);
            
            //
            // View column for valeur_inverse field
            //
            $column = new TextViewColumn('valeur_inverse', 'Valeur Inverse', $this->dataset);
            $column->SetOrderable(true);
            $grid->AddPrintColumn($column);
            
            //
            // View column for champ_concerne field
            //
            $column = new TextViewColumn('champ_concerne', 'Champ Concerne', $this->dataset);
            $column->SetOrderable(true);
            $grid->AddPrintColumn($column);
            
            //
            // View column for notes field
            //
            $column = new TextViewColumn('notes', 'Notes', $this->dataset);
            $column->SetOrderable(true);
            $grid->AddPrintColumn($column);
            
            //
            // View column for date_creation field
            //
            $column = new DateTimeViewColumn('date_creation', 'Date Creation', $this->dataset);
            $column->SetDateTimeFormat('Y-m-d H:i:s');
            $column->SetOrderable(true);
            $grid->AddPrintColumn($column);
            
            //
            // View column for date_modification field
            //
            $column = new DateTimeViewColumn('date_modification', 'Date Modification', $this->dataset);
            $column->SetDateTimeFormat('Y-m-d H:i:s');
            $column->SetOrderable(true);
            $grid->AddPrintColumn($column);
            
            //
            // View column for classe_concernee field
            //
            $column = new TextViewColumn('classe_concernee', 'Classe Concernee', $this->dataset);
            $column->SetOrderable(true);
            $grid->AddPrintColumn($column);
        }
    
        protected function AddExportColumns(Grid $grid)
        {
            //
            // View column for pk_parametre_systeme field
            //
            $column = new TextViewColumn('pk_parametre_systeme', 'Pk Parametre Systeme', $this->dataset);
            $column->SetOrderable(true);
            $grid->AddExportColumn($column);
            
            //
            // View column for valeur field
            //
            $column = new TextViewColumn('valeur', 'Valeur', $this->dataset);
            $column->SetOrderable(true);
            $grid->AddExportColumn($column);
            
            //
            // View column for definition field
            //
            $column = new TextViewColumn('definition', 'Definition', $this->dataset);
            $column->SetOrderable(true);
            $grid->AddExportColumn($column);
            
            //
            // View column for type_valeur field
            //
            $column = new TextViewColumn('type_valeur', 'Type Valeur', $this->dataset);
            $column->SetOrderable(true);
            $grid->AddExportColumn($column);
            
            //
            // View column for valeur_inverse field
            //
            $column = new TextViewColumn('valeur_inverse', 'Valeur Inverse', $this->dataset);
            $column->SetOrderable(true);
            $grid->AddExportColumn($column);
            
            //
            // View column for champ_concerne field
            //
            $column = new TextViewColumn('champ_concerne', 'Champ Concerne', $this->dataset);
            $column->SetOrderable(true);
            $grid->AddExportColumn($column);
            
            //
            // View column for notes field
            //
            $column = new TextViewColumn('notes', 'Notes', $this->dataset);
            $column->SetOrderable(true);
            $grid->AddExportColumn($column);
            
            //
            // View column for date_creation field
            //
            $column = new DateTimeViewColumn('date_creation', 'Date Creation', $this->dataset);
            $column->SetDateTimeFormat('Y-m-d H:i:s');
            $column->SetOrderable(true);
            $grid->AddExportColumn($column);
            
            //
            // View column for date_modification field
            //
            $column = new DateTimeViewColumn('date_modification', 'Date Modification', $this->dataset);
            $column->SetDateTimeFormat('Y-m-d H:i:s');
            $column->SetOrderable(true);
            $grid->AddExportColumn($column);
            
            //
            // View column for classe_concernee field
            //
            $column = new TextViewColumn('classe_concernee', 'Classe Concernee', $this->dataset);
            $column->SetOrderable(true);
            $grid->AddExportColumn($column);
        }
    
        public function GetPageDirection()
        {
            return null;
        }
    
        protected function ApplyCommonColumnEditProperties(CustomEditColumn $column)
        {
            $column->SetDisplaySetToNullCheckBox(false);
            $column->SetDisplaySetToDefaultCheckBox(false);
    		$column->SetVariableContainer($this->GetColumnVariableContainer());
        }
    
        function GetCustomClientScript()
        {
            return ;
        }
        
        function GetOnPageLoadedClientScript()
        {
            return ;
        }
        public function GetModalGridViewHandler() { return 'parametres_parametre_systeme_inline_record_view'; }
        protected function GetEnableModalSingleRecordView() { return true; }
    
        protected function CreateGrid()
        {
            $result = new Grid($this, $this->dataset, 'parametres_parametre_systemeGrid');
            if ($this->GetSecurityInfo()->HasDeleteGrant())
               $result->SetAllowDeleteSelected(false);
            else
               $result->SetAllowDeleteSelected(false);   
            
            ApplyCommonPageSettings($this, $result);
            
            $result->SetUseImagesForActions(true);
            $result->SetUseFixedHeader(false);
            $result->SetShowLineNumbers(false);
            
            $result->SetHighlightRowAtHover(false);
            $result->SetWidth('');
            $this->CreateGridSearchControl($result);
            $this->CreateGridAdvancedSearchControl($result);
            $this->AddOperationsColumns($result);
            $this->AddFieldColumns($result);
            $this->AddSingleRecordViewColumns($result);
            $this->AddEditColumns($result);
            $this->AddInsertColumns($result);
            $this->AddPrintColumns($result);
            $this->AddExportColumns($result);
    
            $this->SetShowPageList(true);
            $this->SetHidePageListByDefault(false);
            $this->SetExportToExcelAvailable(true);
            $this->SetExportToWordAvailable(true);
            $this->SetExportToXmlAvailable(true);
            $this->SetExportToCsvAvailable(true);
            $this->SetExportToPdfAvailable(true);
            $this->SetPrinterFriendlyAvailable(true);
            $this->SetSimpleSearchAvailable(true);
            $this->SetAdvancedSearchAvailable(false);
            $this->SetFilterRowAvailable(true);
            $this->SetVisualEffectsEnabled(true);
            $this->SetShowTopPageNavigator(true);
            $this->SetShowBottomPageNavigator(true);
    
            //
            // Http Handlers
            //
            //
            // View column for valeur field
            //
            $column = new TextViewColumn('valeur', 'Valeur', $this->dataset);
            $column->SetOrderable(true);
            $handler = new ShowTextBlobHandler($this->dataset, $this, 'parametres_parametre_systemeGrid_valeur_handler_list', $column);
            GetApplication()->RegisterHTTPHandler($handler);
            //
            // View column for definition field
            //
            $column = new TextViewColumn('definition', 'Definition', $this->dataset);
            $column->SetOrderable(true);
            $handler = new ShowTextBlobHandler($this->dataset, $this, 'parametres_parametre_systemeGrid_definition_handler_list', $column);
            GetApplication()->RegisterHTTPHandler($handler);
            //
            // View column for type_valeur field
            //
            $column = new TextViewColumn('type_valeur_type_valeur', 'Type Valeur', $this->dataset);
            $column->SetOrderable(true);
            $handler = new ShowTextBlobHandler($this->dataset, $this, 'parametres_parametre_systemeGrid_type_valeur_handler_list', $column);
            GetApplication()->RegisterHTTPHandler($handler);
            //
            // View column for valeur_inverse field
            //
            $column = new TextViewColumn('valeur_inverse', 'Valeur Inverse', $this->dataset);
            $column->SetOrderable(true);
            $handler = new ShowTextBlobHandler($this->dataset, $this, 'parametres_parametre_systemeGrid_valeur_inverse_handler_list', $column);
            GetApplication()->RegisterHTTPHandler($handler);
            //
            // View column for champ_concerne field
            //
            $column = new TextViewColumn('champ_concerne', 'Champ Concerne', $this->dataset);
            $column->SetOrderable(true);
            $handler = new ShowTextBlobHandler($this->dataset, $this, 'parametres_parametre_systemeGrid_champ_concerne_handler_list', $column);
            GetApplication()->RegisterHTTPHandler($handler);
            //
            // View column for notes field
            //
            $column = new TextViewColumn('notes', 'Notes', $this->dataset);
            $column->SetOrderable(true);
            $handler = new ShowTextBlobHandler($this->dataset, $this, 'parametres_parametre_systemeGrid_notes_handler_list', $column);
            GetApplication()->RegisterHTTPHandler($handler);
            //
            // View column for classe_concernee field
            //
            $column = new TextViewColumn('classe_concernee', 'Classe Concernee', $this->dataset);
            $column->SetOrderable(true);
            $handler = new ShowTextBlobHandler($this->dataset, $this, 'parametres_parametre_systemeGrid_classe_concernee_handler_list', $column);
            GetApplication()->RegisterHTTPHandler($handler);//
            // View column for valeur field
            //
            $column = new TextViewColumn('valeur', 'Valeur', $this->dataset);
            $column->SetOrderable(true);
            $handler = new ShowTextBlobHandler($this->dataset, $this, 'parametres_parametre_systemeGrid_valeur_handler_view', $column);
            GetApplication()->RegisterHTTPHandler($handler);
            //
            // View column for type_valeur field
            //
            $column = new TextViewColumn('type_valeur_type_valeur', 'Type Valeur', $this->dataset);
            $column->SetOrderable(true);
            $handler = new ShowTextBlobHandler($this->dataset, $this, 'parametres_parametre_systemeGrid_type_valeur_handler_view', $column);
            GetApplication()->RegisterHTTPHandler($handler);
            //
            // View column for valeur_inverse field
            //
            $column = new TextViewColumn('valeur_inverse', 'Valeur Inverse', $this->dataset);
            $column->SetOrderable(true);
            $handler = new ShowTextBlobHandler($this->dataset, $this, 'parametres_parametre_systemeGrid_valeur_inverse_handler_view', $column);
            GetApplication()->RegisterHTTPHandler($handler);
            //
            // View column for champ_concerne field
            //
            $column = new TextViewColumn('champ_concerne', 'Champ Concerne', $this->dataset);
            $column->SetOrderable(true);
            $handler = new ShowTextBlobHandler($this->dataset, $this, 'parametres_parametre_systemeGrid_champ_concerne_handler_view', $column);
            GetApplication()->RegisterHTTPHandler($handler);
            //
            // View column for notes field
            //
            $column = new TextViewColumn('notes', 'Notes', $this->dataset);
            $column->SetOrderable(true);
            $handler = new ShowTextBlobHandler($this->dataset, $this, 'parametres_parametre_systemeGrid_notes_handler_view', $column);
            GetApplication()->RegisterHTTPHandler($handler);
            //
            // View column for classe_concernee field
            //
            $column = new TextViewColumn('classe_concernee', 'Classe Concernee', $this->dataset);
            $column->SetOrderable(true);
            $handler = new ShowTextBlobHandler($this->dataset, $this, 'parametres_parametre_systemeGrid_classe_concernee_handler_view', $column);
            GetApplication()->RegisterHTTPHandler($handler);
            return $result;
        }
        
        public function OpenAdvancedSearchByDefault()
        {
            return false;
        }
    
        protected function DoGetGridHeader()
        {
            return '';
        }
    }



    try
    {
        $Page = new parametres_parametre_systemePage("parametres.parametre_systeme.php", "parametres_parametre_systeme", GetCurrentUserGrantForDataSource("parametres.parametre_systeme"), 'UTF-8');
        $Page->SetShortCaption('Paramtres');
        $Page->SetHeader(GetPagesHeader());
        $Page->SetFooter(GetPagesFooter());
        $Page->SetCaption('Paramtres');
        $Page->SetRecordPermission(GetCurrentUserRecordPermissionsForDataSource("parametres.parametre_systeme"));
        GetApplication()->SetEnableLessRunTimeCompile(GetEnableLessFilesRunTimeCompilation());
        GetApplication()->SetCanUserChangeOwnPassword(
            !function_exists('CanUserChangeOwnPassword') || CanUserChangeOwnPassword());
        GetApplication()->SetMainPage($Page);
        GetApplication()->Run();
    }
    catch(Exception $e)
    {
        ShowErrorPage($e->getMessage());
    }
	
