--
-- PostgreSQL database dump
--

-- Dumped from database version 9.4.4
-- Dumped by pg_dump version 9.4.4
-- Started on 2015-12-01 08:47:02 CET

SET statement_timeout = 0;
SET lock_timeout = 0;
SET client_encoding = 'UTF8';
SET standard_conforming_strings = on;
SET check_function_bodies = false;
SET client_min_messages = warning;

--
-- TOC entry 6 (class 2615 OID 22723)
-- Name: objets; Type: SCHEMA; Schema: -; Owner: -
--

CREATE SCHEMA objets;


SET search_path = objets, pg_catalog;

--
-- TOC entry 206 (class 1255 OID 22726)
-- Name: update_created_column(); Type: FUNCTION; Schema: objets; Owner: -
--

CREATE FUNCTION update_created_column() RETURNS trigger
    LANGUAGE plpgsql
    AS $$

BEGIN

	   NEW.date_creation = now(); 

	   RETURN NEW;

	END;

$$;


--
-- TOC entry 219 (class 1255 OID 22727)
-- Name: update_updated_column(); Type: FUNCTION; Schema: objets; Owner: -
--

CREATE FUNCTION update_updated_column() RETURNS trigger
    LANGUAGE plpgsql
    AS $$

BEGIN

	   NEW.date_modification = now(); 

	   RETURN NEW;

	END;

$$;


SET default_tablespace = '';

SET default_with_oids = false;

--
-- TOC entry 177 (class 1259 OID 22729)
-- Name: association_objets; Type: TABLE; Schema: objets; Owner: -; Tablespace: 
--

CREATE TABLE association_objets (
    pk_association_objets integer NOT NULL,
    fk_objet_source integer,
    fk_objet_cible integer,
    fk_type_association_param integer,
    reference_precise_objet_source text,
    url_objet_source text,
    descriptif text,
    notes text,
    date_creation timestamp with time zone,
    date_modification timestamp with time zone,
    fk_qualificatif_objet_source integer,
    fk_role_objet_source integer,
    libelle_original_objet_source text,
    valeur_objet_source double precision,
    fk_unite_de_mesure integer
);


--
-- TOC entry 178 (class 1259 OID 22735)
-- Name: associer_objets_pk_associer_objets_seq; Type: SEQUENCE; Schema: objets; Owner: -
--

CREATE SEQUENCE associer_objets_pk_associer_objets_seq
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


--
-- TOC entry 2406 (class 0 OID 0)
-- Dependencies: 178
-- Name: associer_objets_pk_associer_objets_seq; Type: SEQUENCE OWNED BY; Schema: objets; Owner: -
--

ALTER SEQUENCE associer_objets_pk_associer_objets_seq OWNED BY association_objets.pk_association_objets;


--
-- TOC entry 188 (class 1259 OID 22815)
-- Name: date_objet; Type: TABLE; Schema: objets; Owner: -; Tablespace: 
--

CREATE TABLE date_objet (
    pk_date_objet integer NOT NULL,
    date_iso character varying(59),
    fk_type_date_param integer,
    libelle_original_date text,
    notes text,
    descriptif text,
    fk_objet integer,
    date_creation timestamp with time zone,
    date_modification timestamp with time zone,
    certitude character(1)
);


--
-- TOC entry 187 (class 1259 OID 22813)
-- Name: date_objet_pk_date_objet_seq; Type: SEQUENCE; Schema: objets; Owner: -
--

CREATE SEQUENCE date_objet_pk_date_objet_seq
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


--
-- TOC entry 2407 (class 0 OID 0)
-- Dependencies: 187
-- Name: date_objet_pk_date_objet_seq; Type: SEQUENCE OWNED BY; Schema: objets; Owner: -
--

ALTER SEQUENCE date_objet_pk_date_objet_seq OWNED BY date_objet.pk_date_objet;


--
-- TOC entry 179 (class 1259 OID 22737)
-- Name: nom_objet; Type: TABLE; Schema: objets; Owner: -; Tablespace: 
--

CREATE TABLE nom_objet (
    pk_nom_objet integer NOT NULL,
    nom text DEFAULT 'Nom'::text,
    langue character varying(255),
    notes text,
    fk_objet integer,
    est_standard boolean DEFAULT true,
    date_creation timestamp with time zone,
    date_modification timestamp with time zone,
    fk_type_nom_param integer,
    date_debut character varying(10),
    date_fin character varying(10)
);


--
-- TOC entry 180 (class 1259 OID 22744)
-- Name: nom_objet_cle_nom_objet_seq; Type: SEQUENCE; Schema: objets; Owner: -
--

CREATE SEQUENCE nom_objet_cle_nom_objet_seq
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


--
-- TOC entry 2408 (class 0 OID 0)
-- Dependencies: 180
-- Name: nom_objet_cle_nom_objet_seq; Type: SEQUENCE OWNED BY; Schema: objets; Owner: -
--

ALTER SEQUENCE nom_objet_cle_nom_objet_seq OWNED BY nom_objet.pk_nom_objet;


--
-- TOC entry 181 (class 1259 OID 22746)
-- Name: objet; Type: TABLE; Schema: objets; Owner: -; Tablespace: 
--

CREATE TABLE objet (
    pk_objet integer NOT NULL,
    definition text,
    notes text,
    date_creation timestamp with time zone,
    date_modification timestamp with time zone,
    cle_importation integer,
    cle_importation_txt text,
    longitude double precision,
    latitude double precision,
    texte_xml xml,
    fk_type_objet_param integer NOT NULL,
    genre character(1),
    texte text,
    langue_texte character varying(255)
);


--
-- TOC entry 2409 (class 0 OID 0)
-- Dependencies: 181
-- Name: COLUMN objet.longitude; Type: COMMENT; Schema: objets; Owner: -
--

COMMENT ON COLUMN objet.longitude IS 'ALTER TABLE objets.objet

   ALTER COLUMN longitude TYPE double precision;

';


--
-- TOC entry 2410 (class 0 OID 0)
-- Dependencies: 181
-- Name: COLUMN objet.latitude; Type: COMMENT; Schema: objets; Owner: -
--

COMMENT ON COLUMN objet.latitude IS 'ALTER TABLE objets.objet

   ALTER COLUMN latitude TYPE double precision;

';


--
-- TOC entry 182 (class 1259 OID 22752)
-- Name: objet_cle_objet_seq; Type: SEQUENCE; Schema: objets; Owner: -
--

CREATE SEQUENCE objet_cle_objet_seq
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


--
-- TOC entry 2411 (class 0 OID 0)
-- Dependencies: 182
-- Name: objet_cle_objet_seq; Type: SEQUENCE OWNED BY; Schema: objets; Owner: -
--

ALTER SEQUENCE objet_cle_objet_seq OWNED BY objet.pk_objet;


--
-- TOC entry 2244 (class 2604 OID 22778)
-- Name: pk_association_objets; Type: DEFAULT; Schema: objets; Owner: -
--

ALTER TABLE ONLY association_objets ALTER COLUMN pk_association_objets SET DEFAULT nextval('associer_objets_pk_associer_objets_seq'::regclass);


--
-- TOC entry 2249 (class 2604 OID 22818)
-- Name: pk_date_objet; Type: DEFAULT; Schema: objets; Owner: -
--

ALTER TABLE ONLY date_objet ALTER COLUMN pk_date_objet SET DEFAULT nextval('date_objet_pk_date_objet_seq'::regclass);


--
-- TOC entry 2246 (class 2604 OID 22779)
-- Name: pk_nom_objet; Type: DEFAULT; Schema: objets; Owner: -
--

ALTER TABLE ONLY nom_objet ALTER COLUMN pk_nom_objet SET DEFAULT nextval('nom_objet_cle_nom_objet_seq'::regclass);


--
-- TOC entry 2248 (class 2604 OID 22780)
-- Name: pk_objet; Type: DEFAULT; Schema: objets; Owner: -
--

ALTER TABLE ONLY objet ALTER COLUMN pk_objet SET DEFAULT nextval('objet_cle_objet_seq'::regclass);


--
-- TOC entry 2394 (class 0 OID 22729)
-- Dependencies: 177
-- Data for Name: association_objets; Type: TABLE DATA; Schema: objets; Owner: -
--

INSERT INTO association_objets (pk_association_objets, fk_objet_source, fk_objet_cible, fk_type_association_param, reference_precise_objet_source, url_objet_source, descriptif, notes, date_creation, date_modification, fk_qualificatif_objet_source, fk_role_objet_source, libelle_original_objet_source, valeur_objet_source, fk_unite_de_mesure) VALUES (1, 3, 2, 17, NULL, NULL, NULL, NULL, '2015-10-04 12:11:31.143556+02', NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO association_objets (pk_association_objets, fk_objet_source, fk_objet_cible, fk_type_association_param, reference_precise_objet_source, url_objet_source, descriptif, notes, date_creation, date_modification, fk_qualificatif_objet_source, fk_role_objet_source, libelle_original_objet_source, valeur_objet_source, fk_unite_de_mesure) VALUES (3, 16, 15, 21, NULL, NULL, NULL, NULL, '2015-10-05 07:35:37.300968+02', NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO association_objets (pk_association_objets, fk_objet_source, fk_objet_cible, fk_type_association_param, reference_precise_objet_source, url_objet_source, descriptif, notes, date_creation, date_modification, fk_qualificatif_objet_source, fk_role_objet_source, libelle_original_objet_source, valeur_objet_source, fk_unite_de_mesure) VALUES (4, 13, 3, 35, NULL, NULL, NULL, NULL, '2015-10-05 08:04:00.486892+02', NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO association_objets (pk_association_objets, fk_objet_source, fk_objet_cible, fk_type_association_param, reference_precise_objet_source, url_objet_source, descriptif, notes, date_creation, date_modification, fk_qualificatif_objet_source, fk_role_objet_source, libelle_original_objet_source, valeur_objet_source, fk_unite_de_mesure) VALUES (5, 2, 13, 34, NULL, NULL, NULL, NULL, '2015-10-05 08:53:49.238243+02', '2015-10-05 08:59:57.794138+02', NULL, 23, NULL, NULL, NULL);
INSERT INTO association_objets (pk_association_objets, fk_objet_source, fk_objet_cible, fk_type_association_param, reference_precise_objet_source, url_objet_source, descriptif, notes, date_creation, date_modification, fk_qualificatif_objet_source, fk_role_objet_source, libelle_original_objet_source, valeur_objet_source, fk_unite_de_mesure) VALUES (6, 21, 13, 34, NULL, NULL, NULL, NULL, '2015-10-05 08:57:49.49488+02', '2015-10-05 09:14:00.426949+02', NULL, 22, NULL, NULL, NULL);
INSERT INTO association_objets (pk_association_objets, fk_objet_source, fk_objet_cible, fk_type_association_param, reference_precise_objet_source, url_objet_source, descriptif, notes, date_creation, date_modification, fk_qualificatif_objet_source, fk_role_objet_source, libelle_original_objet_source, valeur_objet_source, fk_unite_de_mesure) VALUES (2, 5, 2, 17, NULL, NULL, NULL, NULL, '2015-10-04 14:44:10.664694+02', '2015-10-12 07:50:52.426352+02', NULL, NULL, NULL, NULL, NULL);
INSERT INTO association_objets (pk_association_objets, fk_objet_source, fk_objet_cible, fk_type_association_param, reference_precise_objet_source, url_objet_source, descriptif, notes, date_creation, date_modification, fk_qualificatif_objet_source, fk_role_objet_source, libelle_original_objet_source, valeur_objet_source, fk_unite_de_mesure) VALUES (7, 32, 2, 17, 'p.35-45', NULL, NULL, NULL, '2015-10-13 15:38:54.27321+02', NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO association_objets (pk_association_objets, fk_objet_source, fk_objet_cible, fk_type_association_param, reference_precise_objet_source, url_objet_source, descriptif, notes, date_creation, date_modification, fk_qualificatif_objet_source, fk_role_objet_source, libelle_original_objet_source, valeur_objet_source, fk_unite_de_mesure) VALUES (9, 35, 34, 18, NULL, NULL, NULL, NULL, '2015-10-13 17:52:05.874491+02', NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO association_objets (pk_association_objets, fk_objet_source, fk_objet_cible, fk_type_association_param, reference_precise_objet_source, url_objet_source, descriptif, notes, date_creation, date_modification, fk_qualificatif_objet_source, fk_role_objet_source, libelle_original_objet_source, valeur_objet_source, fk_unite_de_mesure) VALUES (8, 33, 32, 18, NULL, NULL, 'aélsdkfjasdlék fjasélkdfja', NULL, '2015-10-13 15:44:28.866347+02', '2015-10-13 21:12:14.79035+02', NULL, NULL, NULL, NULL, NULL);
INSERT INTO association_objets (pk_association_objets, fk_objet_source, fk_objet_cible, fk_type_association_param, reference_precise_objet_source, url_objet_source, descriptif, notes, date_creation, date_modification, fk_qualificatif_objet_source, fk_role_objet_source, libelle_original_objet_source, valeur_objet_source, fk_unite_de_mesure) VALUES (11, 1101, 2, 17, NULL, NULL, NULL, NULL, '2015-11-09 14:32:02.822392+01', NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO association_objets (pk_association_objets, fk_objet_source, fk_objet_cible, fk_type_association_param, reference_precise_objet_source, url_objet_source, descriptif, notes, date_creation, date_modification, fk_qualificatif_objet_source, fk_role_objet_source, libelle_original_objet_source, valeur_objet_source, fk_unite_de_mesure) VALUES (12, 22, 11, 39, NULL, NULL, 'Associe le lieu qui localise la naissance', NULL, '2015-11-09 21:06:59.518424+01', '2015-11-09 21:07:49.296544+01', NULL, NULL, NULL, NULL, NULL);
INSERT INTO association_objets (pk_association_objets, fk_objet_source, fk_objet_cible, fk_type_association_param, reference_precise_objet_source, url_objet_source, descriptif, notes, date_creation, date_modification, fk_qualificatif_objet_source, fk_role_objet_source, libelle_original_objet_source, valeur_objet_source, fk_unite_de_mesure) VALUES (10, 23, 11, 39, NULL, NULL, 'Associe la personne qui naît', NULL, '2015-11-03 11:18:36.870722+01', '2015-11-09 21:08:30.341712+01', NULL, NULL, NULL, NULL, NULL);
INSERT INTO association_objets (pk_association_objets, fk_objet_source, fk_objet_cible, fk_type_association_param, reference_precise_objet_source, url_objet_source, descriptif, notes, date_creation, date_modification, fk_qualificatif_objet_source, fk_role_objet_source, libelle_original_objet_source, valeur_objet_source, fk_unite_de_mesure) VALUES (13, 1624, 1621, 39, NULL, NULL, 'Associe l''enseignant.', NULL, '2015-11-09 22:59:04.670766+01', NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO association_objets (pk_association_objets, fk_objet_source, fk_objet_cible, fk_type_association_param, reference_precise_objet_source, url_objet_source, descriptif, notes, date_creation, date_modification, fk_qualificatif_objet_source, fk_role_objet_source, libelle_original_objet_source, valeur_objet_source, fk_unite_de_mesure) VALUES (15, 1622, 1621, 39, NULL, NULL, 'La matière enseignée (un objet abstrait). On peut en associer plusieurs si on enseigne en même temps plusieurs matières. En revanche, il faut créer plusieurs informations si les enseignements des différentes matières se succèdent ou si le contexte institutionnel est différent ', NULL, '2015-11-09 23:06:24.947314+01', NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO association_objets (pk_association_objets, fk_objet_source, fk_objet_cible, fk_type_association_param, reference_precise_objet_source, url_objet_source, descriptif, notes, date_creation, date_modification, fk_qualificatif_objet_source, fk_role_objet_source, libelle_original_objet_source, valeur_objet_source, fk_unite_de_mesure) VALUES (14, 1623, 1621, 39, NULL, NULL, 'Qualification de l''enseignement : professeur, chargé de cours, etc. Ce rôle a été gardé pour être l''équivalent du TyIn7 : Exercice d''une fonction. ', NULL, '2015-11-09 23:05:15.693556+01', '2015-11-09 23:07:20.743396+01', NULL, NULL, NULL, NULL, NULL);
INSERT INTO association_objets (pk_association_objets, fk_objet_source, fk_objet_cible, fk_type_association_param, reference_precise_objet_source, url_objet_source, descriptif, notes, date_creation, date_modification, fk_qualificatif_objet_source, fk_role_objet_source, libelle_original_objet_source, valeur_objet_source, fk_unite_de_mesure) VALUES (16, 10, 1621, 39, NULL, NULL, 'Institution auprès de laquelle s''exerce l''enseignement.', NULL, '2015-11-09 23:09:54.125574+01', NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO association_objets (pk_association_objets, fk_objet_source, fk_objet_cible, fk_type_association_param, reference_precise_objet_source, url_objet_source, descriptif, notes, date_creation, date_modification, fk_qualificatif_objet_source, fk_role_objet_source, libelle_original_objet_source, valeur_objet_source, fk_unite_de_mesure) VALUES (17, 1627, 1626, 39, NULL, NULL, 'Associe un objet abstrait qui indique de quel type de caractéristique il s''agit (expertise, intérêt, etc.) ', NULL, '2015-11-10 08:48:56.833631+01', NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO association_objets (pk_association_objets, fk_objet_source, fk_objet_cible, fk_type_association_param, reference_precise_objet_source, url_objet_source, descriptif, notes, date_creation, date_modification, fk_qualificatif_objet_source, fk_role_objet_source, libelle_original_objet_source, valeur_objet_source, fk_unite_de_mesure) VALUES (18, 10, 1626, 39, NULL, NULL, 'Associe l''objet qui est caractérisé, auquel on associe les caractéristiques', NULL, '2015-11-10 08:49:58.516422+01', NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO association_objets (pk_association_objets, fk_objet_source, fk_objet_cible, fk_type_association_param, reference_precise_objet_source, url_objet_source, descriptif, notes, date_creation, date_modification, fk_qualificatif_objet_source, fk_role_objet_source, libelle_original_objet_source, valeur_objet_source, fk_unite_de_mesure) VALUES (19, 1628, 1626, 39, NULL, NULL, 'Associe une caractéristique de l''objet. Ajouter un rôle par caractéristique', NULL, '2015-11-10 09:01:21.010316+01', NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO association_objets (pk_association_objets, fk_objet_source, fk_objet_cible, fk_type_association_param, reference_precise_objet_source, url_objet_source, descriptif, notes, date_creation, date_modification, fk_qualificatif_objet_source, fk_role_objet_source, libelle_original_objet_source, valeur_objet_source, fk_unite_de_mesure) VALUES (20, 959, 7, 17, NULL, NULL, NULL, NULL, '2015-11-11 11:39:40.26718+01', NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO association_objets (pk_association_objets, fk_objet_source, fk_objet_cible, fk_type_association_param, reference_precise_objet_source, url_objet_source, descriptif, notes, date_creation, date_modification, fk_qualificatif_objet_source, fk_role_objet_source, libelle_original_objet_source, valeur_objet_source, fk_unite_de_mesure) VALUES (21, 1618, 37, 19, NULL, NULL, NULL, NULL, '2015-11-11 23:13:37.694065+01', NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO association_objets (pk_association_objets, fk_objet_source, fk_objet_cible, fk_type_association_param, reference_precise_objet_source, url_objet_source, descriptif, notes, date_creation, date_modification, fk_qualificatif_objet_source, fk_role_objet_source, libelle_original_objet_source, valeur_objet_source, fk_unite_de_mesure) VALUES (22, 1617, 37, 19, NULL, NULL, NULL, NULL, '2015-11-11 23:13:37.694065+01', NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO association_objets (pk_association_objets, fk_objet_source, fk_objet_cible, fk_type_association_param, reference_precise_objet_source, url_objet_source, descriptif, notes, date_creation, date_modification, fk_qualificatif_objet_source, fk_role_objet_source, libelle_original_objet_source, valeur_objet_source, fk_unite_de_mesure) VALUES (23, 1616, 37, 19, NULL, NULL, NULL, NULL, '2015-11-11 23:13:37.694065+01', NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO association_objets (pk_association_objets, fk_objet_source, fk_objet_cible, fk_type_association_param, reference_precise_objet_source, url_objet_source, descriptif, notes, date_creation, date_modification, fk_qualificatif_objet_source, fk_role_objet_source, libelle_original_objet_source, valeur_objet_source, fk_unite_de_mesure) VALUES (24, 1615, 37, 19, NULL, NULL, NULL, NULL, '2015-11-11 23:13:37.694065+01', NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO association_objets (pk_association_objets, fk_objet_source, fk_objet_cible, fk_type_association_param, reference_precise_objet_source, url_objet_source, descriptif, notes, date_creation, date_modification, fk_qualificatif_objet_source, fk_role_objet_source, libelle_original_objet_source, valeur_objet_source, fk_unite_de_mesure) VALUES (25, 1614, 37, 19, NULL, NULL, NULL, NULL, '2015-11-11 23:13:37.694065+01', NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO association_objets (pk_association_objets, fk_objet_source, fk_objet_cible, fk_type_association_param, reference_precise_objet_source, url_objet_source, descriptif, notes, date_creation, date_modification, fk_qualificatif_objet_source, fk_role_objet_source, libelle_original_objet_source, valeur_objet_source, fk_unite_de_mesure) VALUES (26, 1613, 37, 19, NULL, NULL, NULL, NULL, '2015-11-11 23:13:37.694065+01', NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO association_objets (pk_association_objets, fk_objet_source, fk_objet_cible, fk_type_association_param, reference_precise_objet_source, url_objet_source, descriptif, notes, date_creation, date_modification, fk_qualificatif_objet_source, fk_role_objet_source, libelle_original_objet_source, valeur_objet_source, fk_unite_de_mesure) VALUES (27, 1612, 37, 19, NULL, NULL, NULL, NULL, '2015-11-11 23:13:37.694065+01', NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO association_objets (pk_association_objets, fk_objet_source, fk_objet_cible, fk_type_association_param, reference_precise_objet_source, url_objet_source, descriptif, notes, date_creation, date_modification, fk_qualificatif_objet_source, fk_role_objet_source, libelle_original_objet_source, valeur_objet_source, fk_unite_de_mesure) VALUES (28, 1611, 37, 19, NULL, NULL, NULL, NULL, '2015-11-11 23:13:37.694065+01', NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO association_objets (pk_association_objets, fk_objet_source, fk_objet_cible, fk_type_association_param, reference_precise_objet_source, url_objet_source, descriptif, notes, date_creation, date_modification, fk_qualificatif_objet_source, fk_role_objet_source, libelle_original_objet_source, valeur_objet_source, fk_unite_de_mesure) VALUES (29, 1610, 37, 19, NULL, NULL, NULL, NULL, '2015-11-11 23:13:37.694065+01', NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO association_objets (pk_association_objets, fk_objet_source, fk_objet_cible, fk_type_association_param, reference_precise_objet_source, url_objet_source, descriptif, notes, date_creation, date_modification, fk_qualificatif_objet_source, fk_role_objet_source, libelle_original_objet_source, valeur_objet_source, fk_unite_de_mesure) VALUES (30, 1609, 37, 19, NULL, NULL, NULL, NULL, '2015-11-11 23:13:37.694065+01', NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO association_objets (pk_association_objets, fk_objet_source, fk_objet_cible, fk_type_association_param, reference_precise_objet_source, url_objet_source, descriptif, notes, date_creation, date_modification, fk_qualificatif_objet_source, fk_role_objet_source, libelle_original_objet_source, valeur_objet_source, fk_unite_de_mesure) VALUES (31, 1608, 37, 19, NULL, NULL, NULL, NULL, '2015-11-11 23:13:37.694065+01', NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO association_objets (pk_association_objets, fk_objet_source, fk_objet_cible, fk_type_association_param, reference_precise_objet_source, url_objet_source, descriptif, notes, date_creation, date_modification, fk_qualificatif_objet_source, fk_role_objet_source, libelle_original_objet_source, valeur_objet_source, fk_unite_de_mesure) VALUES (32, 1607, 37, 19, NULL, NULL, NULL, NULL, '2015-11-11 23:13:37.694065+01', NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO association_objets (pk_association_objets, fk_objet_source, fk_objet_cible, fk_type_association_param, reference_precise_objet_source, url_objet_source, descriptif, notes, date_creation, date_modification, fk_qualificatif_objet_source, fk_role_objet_source, libelle_original_objet_source, valeur_objet_source, fk_unite_de_mesure) VALUES (33, 1606, 37, 19, NULL, NULL, NULL, NULL, '2015-11-11 23:13:37.694065+01', NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO association_objets (pk_association_objets, fk_objet_source, fk_objet_cible, fk_type_association_param, reference_precise_objet_source, url_objet_source, descriptif, notes, date_creation, date_modification, fk_qualificatif_objet_source, fk_role_objet_source, libelle_original_objet_source, valeur_objet_source, fk_unite_de_mesure) VALUES (34, 1605, 37, 19, NULL, NULL, NULL, NULL, '2015-11-11 23:13:37.694065+01', NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO association_objets (pk_association_objets, fk_objet_source, fk_objet_cible, fk_type_association_param, reference_precise_objet_source, url_objet_source, descriptif, notes, date_creation, date_modification, fk_qualificatif_objet_source, fk_role_objet_source, libelle_original_objet_source, valeur_objet_source, fk_unite_de_mesure) VALUES (35, 1604, 37, 19, NULL, NULL, NULL, NULL, '2015-11-11 23:13:37.694065+01', NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO association_objets (pk_association_objets, fk_objet_source, fk_objet_cible, fk_type_association_param, reference_precise_objet_source, url_objet_source, descriptif, notes, date_creation, date_modification, fk_qualificatif_objet_source, fk_role_objet_source, libelle_original_objet_source, valeur_objet_source, fk_unite_de_mesure) VALUES (36, 1603, 37, 19, NULL, NULL, NULL, NULL, '2015-11-11 23:13:37.694065+01', NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO association_objets (pk_association_objets, fk_objet_source, fk_objet_cible, fk_type_association_param, reference_precise_objet_source, url_objet_source, descriptif, notes, date_creation, date_modification, fk_qualificatif_objet_source, fk_role_objet_source, libelle_original_objet_source, valeur_objet_source, fk_unite_de_mesure) VALUES (37, 1602, 37, 19, NULL, NULL, NULL, NULL, '2015-11-11 23:13:37.694065+01', NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO association_objets (pk_association_objets, fk_objet_source, fk_objet_cible, fk_type_association_param, reference_precise_objet_source, url_objet_source, descriptif, notes, date_creation, date_modification, fk_qualificatif_objet_source, fk_role_objet_source, libelle_original_objet_source, valeur_objet_source, fk_unite_de_mesure) VALUES (38, 1601, 37, 19, NULL, NULL, NULL, NULL, '2015-11-11 23:13:37.694065+01', NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO association_objets (pk_association_objets, fk_objet_source, fk_objet_cible, fk_type_association_param, reference_precise_objet_source, url_objet_source, descriptif, notes, date_creation, date_modification, fk_qualificatif_objet_source, fk_role_objet_source, libelle_original_objet_source, valeur_objet_source, fk_unite_de_mesure) VALUES (39, 1600, 37, 19, NULL, NULL, NULL, NULL, '2015-11-11 23:13:37.694065+01', NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO association_objets (pk_association_objets, fk_objet_source, fk_objet_cible, fk_type_association_param, reference_precise_objet_source, url_objet_source, descriptif, notes, date_creation, date_modification, fk_qualificatif_objet_source, fk_role_objet_source, libelle_original_objet_source, valeur_objet_source, fk_unite_de_mesure) VALUES (40, 1599, 37, 19, NULL, NULL, NULL, NULL, '2015-11-11 23:13:37.694065+01', NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO association_objets (pk_association_objets, fk_objet_source, fk_objet_cible, fk_type_association_param, reference_precise_objet_source, url_objet_source, descriptif, notes, date_creation, date_modification, fk_qualificatif_objet_source, fk_role_objet_source, libelle_original_objet_source, valeur_objet_source, fk_unite_de_mesure) VALUES (41, 1598, 37, 19, NULL, NULL, NULL, NULL, '2015-11-11 23:13:37.694065+01', NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO association_objets (pk_association_objets, fk_objet_source, fk_objet_cible, fk_type_association_param, reference_precise_objet_source, url_objet_source, descriptif, notes, date_creation, date_modification, fk_qualificatif_objet_source, fk_role_objet_source, libelle_original_objet_source, valeur_objet_source, fk_unite_de_mesure) VALUES (42, 1597, 37, 19, NULL, NULL, NULL, NULL, '2015-11-11 23:13:37.694065+01', NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO association_objets (pk_association_objets, fk_objet_source, fk_objet_cible, fk_type_association_param, reference_precise_objet_source, url_objet_source, descriptif, notes, date_creation, date_modification, fk_qualificatif_objet_source, fk_role_objet_source, libelle_original_objet_source, valeur_objet_source, fk_unite_de_mesure) VALUES (43, 1596, 37, 19, NULL, NULL, NULL, NULL, '2015-11-11 23:13:37.694065+01', NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO association_objets (pk_association_objets, fk_objet_source, fk_objet_cible, fk_type_association_param, reference_precise_objet_source, url_objet_source, descriptif, notes, date_creation, date_modification, fk_qualificatif_objet_source, fk_role_objet_source, libelle_original_objet_source, valeur_objet_source, fk_unite_de_mesure) VALUES (44, 1595, 37, 19, NULL, NULL, NULL, NULL, '2015-11-11 23:13:37.694065+01', NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO association_objets (pk_association_objets, fk_objet_source, fk_objet_cible, fk_type_association_param, reference_precise_objet_source, url_objet_source, descriptif, notes, date_creation, date_modification, fk_qualificatif_objet_source, fk_role_objet_source, libelle_original_objet_source, valeur_objet_source, fk_unite_de_mesure) VALUES (45, 1594, 37, 19, NULL, NULL, NULL, NULL, '2015-11-11 23:13:37.694065+01', NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO association_objets (pk_association_objets, fk_objet_source, fk_objet_cible, fk_type_association_param, reference_precise_objet_source, url_objet_source, descriptif, notes, date_creation, date_modification, fk_qualificatif_objet_source, fk_role_objet_source, libelle_original_objet_source, valeur_objet_source, fk_unite_de_mesure) VALUES (46, 1593, 37, 19, NULL, NULL, NULL, NULL, '2015-11-11 23:13:37.694065+01', NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO association_objets (pk_association_objets, fk_objet_source, fk_objet_cible, fk_type_association_param, reference_precise_objet_source, url_objet_source, descriptif, notes, date_creation, date_modification, fk_qualificatif_objet_source, fk_role_objet_source, libelle_original_objet_source, valeur_objet_source, fk_unite_de_mesure) VALUES (47, 1592, 37, 19, NULL, NULL, NULL, NULL, '2015-11-11 23:13:37.694065+01', NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO association_objets (pk_association_objets, fk_objet_source, fk_objet_cible, fk_type_association_param, reference_precise_objet_source, url_objet_source, descriptif, notes, date_creation, date_modification, fk_qualificatif_objet_source, fk_role_objet_source, libelle_original_objet_source, valeur_objet_source, fk_unite_de_mesure) VALUES (48, 1591, 37, 19, NULL, NULL, NULL, NULL, '2015-11-11 23:13:37.694065+01', NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO association_objets (pk_association_objets, fk_objet_source, fk_objet_cible, fk_type_association_param, reference_precise_objet_source, url_objet_source, descriptif, notes, date_creation, date_modification, fk_qualificatif_objet_source, fk_role_objet_source, libelle_original_objet_source, valeur_objet_source, fk_unite_de_mesure) VALUES (49, 1590, 37, 19, NULL, NULL, NULL, NULL, '2015-11-11 23:13:37.694065+01', NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO association_objets (pk_association_objets, fk_objet_source, fk_objet_cible, fk_type_association_param, reference_precise_objet_source, url_objet_source, descriptif, notes, date_creation, date_modification, fk_qualificatif_objet_source, fk_role_objet_source, libelle_original_objet_source, valeur_objet_source, fk_unite_de_mesure) VALUES (50, 1589, 37, 19, NULL, NULL, NULL, NULL, '2015-11-11 23:13:37.694065+01', NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO association_objets (pk_association_objets, fk_objet_source, fk_objet_cible, fk_type_association_param, reference_precise_objet_source, url_objet_source, descriptif, notes, date_creation, date_modification, fk_qualificatif_objet_source, fk_role_objet_source, libelle_original_objet_source, valeur_objet_source, fk_unite_de_mesure) VALUES (51, 1588, 37, 19, NULL, NULL, NULL, NULL, '2015-11-11 23:13:37.694065+01', NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO association_objets (pk_association_objets, fk_objet_source, fk_objet_cible, fk_type_association_param, reference_precise_objet_source, url_objet_source, descriptif, notes, date_creation, date_modification, fk_qualificatif_objet_source, fk_role_objet_source, libelle_original_objet_source, valeur_objet_source, fk_unite_de_mesure) VALUES (52, 1587, 37, 19, NULL, NULL, NULL, NULL, '2015-11-11 23:13:37.694065+01', NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO association_objets (pk_association_objets, fk_objet_source, fk_objet_cible, fk_type_association_param, reference_precise_objet_source, url_objet_source, descriptif, notes, date_creation, date_modification, fk_qualificatif_objet_source, fk_role_objet_source, libelle_original_objet_source, valeur_objet_source, fk_unite_de_mesure) VALUES (53, 1586, 37, 19, NULL, NULL, NULL, NULL, '2015-11-11 23:13:37.694065+01', NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO association_objets (pk_association_objets, fk_objet_source, fk_objet_cible, fk_type_association_param, reference_precise_objet_source, url_objet_source, descriptif, notes, date_creation, date_modification, fk_qualificatif_objet_source, fk_role_objet_source, libelle_original_objet_source, valeur_objet_source, fk_unite_de_mesure) VALUES (54, 1585, 37, 19, NULL, NULL, NULL, NULL, '2015-11-11 23:13:37.694065+01', NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO association_objets (pk_association_objets, fk_objet_source, fk_objet_cible, fk_type_association_param, reference_precise_objet_source, url_objet_source, descriptif, notes, date_creation, date_modification, fk_qualificatif_objet_source, fk_role_objet_source, libelle_original_objet_source, valeur_objet_source, fk_unite_de_mesure) VALUES (55, 1584, 37, 19, NULL, NULL, NULL, NULL, '2015-11-11 23:13:37.694065+01', NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO association_objets (pk_association_objets, fk_objet_source, fk_objet_cible, fk_type_association_param, reference_precise_objet_source, url_objet_source, descriptif, notes, date_creation, date_modification, fk_qualificatif_objet_source, fk_role_objet_source, libelle_original_objet_source, valeur_objet_source, fk_unite_de_mesure) VALUES (56, 1583, 37, 19, NULL, NULL, NULL, NULL, '2015-11-11 23:13:37.694065+01', NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO association_objets (pk_association_objets, fk_objet_source, fk_objet_cible, fk_type_association_param, reference_precise_objet_source, url_objet_source, descriptif, notes, date_creation, date_modification, fk_qualificatif_objet_source, fk_role_objet_source, libelle_original_objet_source, valeur_objet_source, fk_unite_de_mesure) VALUES (57, 1582, 37, 19, NULL, NULL, NULL, NULL, '2015-11-11 23:13:37.694065+01', NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO association_objets (pk_association_objets, fk_objet_source, fk_objet_cible, fk_type_association_param, reference_precise_objet_source, url_objet_source, descriptif, notes, date_creation, date_modification, fk_qualificatif_objet_source, fk_role_objet_source, libelle_original_objet_source, valeur_objet_source, fk_unite_de_mesure) VALUES (58, 1581, 37, 19, NULL, NULL, NULL, NULL, '2015-11-11 23:13:37.694065+01', NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO association_objets (pk_association_objets, fk_objet_source, fk_objet_cible, fk_type_association_param, reference_precise_objet_source, url_objet_source, descriptif, notes, date_creation, date_modification, fk_qualificatif_objet_source, fk_role_objet_source, libelle_original_objet_source, valeur_objet_source, fk_unite_de_mesure) VALUES (59, 1580, 37, 19, NULL, NULL, NULL, NULL, '2015-11-11 23:13:37.694065+01', NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO association_objets (pk_association_objets, fk_objet_source, fk_objet_cible, fk_type_association_param, reference_precise_objet_source, url_objet_source, descriptif, notes, date_creation, date_modification, fk_qualificatif_objet_source, fk_role_objet_source, libelle_original_objet_source, valeur_objet_source, fk_unite_de_mesure) VALUES (60, 1579, 37, 19, NULL, NULL, NULL, NULL, '2015-11-11 23:13:37.694065+01', NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO association_objets (pk_association_objets, fk_objet_source, fk_objet_cible, fk_type_association_param, reference_precise_objet_source, url_objet_source, descriptif, notes, date_creation, date_modification, fk_qualificatif_objet_source, fk_role_objet_source, libelle_original_objet_source, valeur_objet_source, fk_unite_de_mesure) VALUES (61, 1578, 37, 19, NULL, NULL, NULL, NULL, '2015-11-11 23:13:37.694065+01', NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO association_objets (pk_association_objets, fk_objet_source, fk_objet_cible, fk_type_association_param, reference_precise_objet_source, url_objet_source, descriptif, notes, date_creation, date_modification, fk_qualificatif_objet_source, fk_role_objet_source, libelle_original_objet_source, valeur_objet_source, fk_unite_de_mesure) VALUES (62, 1577, 37, 19, NULL, NULL, NULL, NULL, '2015-11-11 23:13:37.694065+01', NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO association_objets (pk_association_objets, fk_objet_source, fk_objet_cible, fk_type_association_param, reference_precise_objet_source, url_objet_source, descriptif, notes, date_creation, date_modification, fk_qualificatif_objet_source, fk_role_objet_source, libelle_original_objet_source, valeur_objet_source, fk_unite_de_mesure) VALUES (63, 1576, 37, 19, NULL, NULL, NULL, NULL, '2015-11-11 23:13:37.694065+01', NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO association_objets (pk_association_objets, fk_objet_source, fk_objet_cible, fk_type_association_param, reference_precise_objet_source, url_objet_source, descriptif, notes, date_creation, date_modification, fk_qualificatif_objet_source, fk_role_objet_source, libelle_original_objet_source, valeur_objet_source, fk_unite_de_mesure) VALUES (64, 1575, 37, 19, NULL, NULL, NULL, NULL, '2015-11-11 23:13:37.694065+01', NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO association_objets (pk_association_objets, fk_objet_source, fk_objet_cible, fk_type_association_param, reference_precise_objet_source, url_objet_source, descriptif, notes, date_creation, date_modification, fk_qualificatif_objet_source, fk_role_objet_source, libelle_original_objet_source, valeur_objet_source, fk_unite_de_mesure) VALUES (65, 1574, 37, 19, NULL, NULL, NULL, NULL, '2015-11-11 23:13:37.694065+01', NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO association_objets (pk_association_objets, fk_objet_source, fk_objet_cible, fk_type_association_param, reference_precise_objet_source, url_objet_source, descriptif, notes, date_creation, date_modification, fk_qualificatif_objet_source, fk_role_objet_source, libelle_original_objet_source, valeur_objet_source, fk_unite_de_mesure) VALUES (66, 1573, 37, 19, NULL, NULL, NULL, NULL, '2015-11-11 23:13:37.694065+01', NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO association_objets (pk_association_objets, fk_objet_source, fk_objet_cible, fk_type_association_param, reference_precise_objet_source, url_objet_source, descriptif, notes, date_creation, date_modification, fk_qualificatif_objet_source, fk_role_objet_source, libelle_original_objet_source, valeur_objet_source, fk_unite_de_mesure) VALUES (67, 1572, 37, 19, NULL, NULL, NULL, NULL, '2015-11-11 23:13:37.694065+01', NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO association_objets (pk_association_objets, fk_objet_source, fk_objet_cible, fk_type_association_param, reference_precise_objet_source, url_objet_source, descriptif, notes, date_creation, date_modification, fk_qualificatif_objet_source, fk_role_objet_source, libelle_original_objet_source, valeur_objet_source, fk_unite_de_mesure) VALUES (68, 1571, 37, 19, NULL, NULL, NULL, NULL, '2015-11-11 23:13:37.694065+01', NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO association_objets (pk_association_objets, fk_objet_source, fk_objet_cible, fk_type_association_param, reference_precise_objet_source, url_objet_source, descriptif, notes, date_creation, date_modification, fk_qualificatif_objet_source, fk_role_objet_source, libelle_original_objet_source, valeur_objet_source, fk_unite_de_mesure) VALUES (69, 1570, 37, 19, NULL, NULL, NULL, NULL, '2015-11-11 23:13:37.694065+01', NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO association_objets (pk_association_objets, fk_objet_source, fk_objet_cible, fk_type_association_param, reference_precise_objet_source, url_objet_source, descriptif, notes, date_creation, date_modification, fk_qualificatif_objet_source, fk_role_objet_source, libelle_original_objet_source, valeur_objet_source, fk_unite_de_mesure) VALUES (70, 1569, 37, 19, NULL, NULL, NULL, NULL, '2015-11-11 23:13:37.694065+01', NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO association_objets (pk_association_objets, fk_objet_source, fk_objet_cible, fk_type_association_param, reference_precise_objet_source, url_objet_source, descriptif, notes, date_creation, date_modification, fk_qualificatif_objet_source, fk_role_objet_source, libelle_original_objet_source, valeur_objet_source, fk_unite_de_mesure) VALUES (71, 1568, 37, 19, NULL, NULL, NULL, NULL, '2015-11-11 23:13:37.694065+01', NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO association_objets (pk_association_objets, fk_objet_source, fk_objet_cible, fk_type_association_param, reference_precise_objet_source, url_objet_source, descriptif, notes, date_creation, date_modification, fk_qualificatif_objet_source, fk_role_objet_source, libelle_original_objet_source, valeur_objet_source, fk_unite_de_mesure) VALUES (72, 1567, 37, 19, NULL, NULL, NULL, NULL, '2015-11-11 23:13:37.694065+01', NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO association_objets (pk_association_objets, fk_objet_source, fk_objet_cible, fk_type_association_param, reference_precise_objet_source, url_objet_source, descriptif, notes, date_creation, date_modification, fk_qualificatif_objet_source, fk_role_objet_source, libelle_original_objet_source, valeur_objet_source, fk_unite_de_mesure) VALUES (73, 1566, 37, 19, NULL, NULL, NULL, NULL, '2015-11-11 23:13:37.694065+01', NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO association_objets (pk_association_objets, fk_objet_source, fk_objet_cible, fk_type_association_param, reference_precise_objet_source, url_objet_source, descriptif, notes, date_creation, date_modification, fk_qualificatif_objet_source, fk_role_objet_source, libelle_original_objet_source, valeur_objet_source, fk_unite_de_mesure) VALUES (74, 1565, 37, 19, NULL, NULL, NULL, NULL, '2015-11-11 23:13:37.694065+01', NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO association_objets (pk_association_objets, fk_objet_source, fk_objet_cible, fk_type_association_param, reference_precise_objet_source, url_objet_source, descriptif, notes, date_creation, date_modification, fk_qualificatif_objet_source, fk_role_objet_source, libelle_original_objet_source, valeur_objet_source, fk_unite_de_mesure) VALUES (75, 1564, 37, 19, NULL, NULL, NULL, NULL, '2015-11-11 23:13:37.694065+01', NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO association_objets (pk_association_objets, fk_objet_source, fk_objet_cible, fk_type_association_param, reference_precise_objet_source, url_objet_source, descriptif, notes, date_creation, date_modification, fk_qualificatif_objet_source, fk_role_objet_source, libelle_original_objet_source, valeur_objet_source, fk_unite_de_mesure) VALUES (76, 1563, 37, 19, NULL, NULL, NULL, NULL, '2015-11-11 23:13:37.694065+01', NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO association_objets (pk_association_objets, fk_objet_source, fk_objet_cible, fk_type_association_param, reference_precise_objet_source, url_objet_source, descriptif, notes, date_creation, date_modification, fk_qualificatif_objet_source, fk_role_objet_source, libelle_original_objet_source, valeur_objet_source, fk_unite_de_mesure) VALUES (77, 1562, 37, 19, NULL, NULL, NULL, NULL, '2015-11-11 23:13:37.694065+01', NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO association_objets (pk_association_objets, fk_objet_source, fk_objet_cible, fk_type_association_param, reference_precise_objet_source, url_objet_source, descriptif, notes, date_creation, date_modification, fk_qualificatif_objet_source, fk_role_objet_source, libelle_original_objet_source, valeur_objet_source, fk_unite_de_mesure) VALUES (78, 1561, 37, 19, NULL, NULL, NULL, NULL, '2015-11-11 23:13:37.694065+01', NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO association_objets (pk_association_objets, fk_objet_source, fk_objet_cible, fk_type_association_param, reference_precise_objet_source, url_objet_source, descriptif, notes, date_creation, date_modification, fk_qualificatif_objet_source, fk_role_objet_source, libelle_original_objet_source, valeur_objet_source, fk_unite_de_mesure) VALUES (79, 1560, 37, 19, NULL, NULL, NULL, NULL, '2015-11-11 23:13:37.694065+01', NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO association_objets (pk_association_objets, fk_objet_source, fk_objet_cible, fk_type_association_param, reference_precise_objet_source, url_objet_source, descriptif, notes, date_creation, date_modification, fk_qualificatif_objet_source, fk_role_objet_source, libelle_original_objet_source, valeur_objet_source, fk_unite_de_mesure) VALUES (80, 1559, 37, 19, NULL, NULL, NULL, NULL, '2015-11-11 23:13:37.694065+01', NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO association_objets (pk_association_objets, fk_objet_source, fk_objet_cible, fk_type_association_param, reference_precise_objet_source, url_objet_source, descriptif, notes, date_creation, date_modification, fk_qualificatif_objet_source, fk_role_objet_source, libelle_original_objet_source, valeur_objet_source, fk_unite_de_mesure) VALUES (81, 1558, 37, 19, NULL, NULL, NULL, NULL, '2015-11-11 23:13:37.694065+01', NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO association_objets (pk_association_objets, fk_objet_source, fk_objet_cible, fk_type_association_param, reference_precise_objet_source, url_objet_source, descriptif, notes, date_creation, date_modification, fk_qualificatif_objet_source, fk_role_objet_source, libelle_original_objet_source, valeur_objet_source, fk_unite_de_mesure) VALUES (82, 1557, 37, 19, NULL, NULL, NULL, NULL, '2015-11-11 23:13:37.694065+01', NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO association_objets (pk_association_objets, fk_objet_source, fk_objet_cible, fk_type_association_param, reference_precise_objet_source, url_objet_source, descriptif, notes, date_creation, date_modification, fk_qualificatif_objet_source, fk_role_objet_source, libelle_original_objet_source, valeur_objet_source, fk_unite_de_mesure) VALUES (83, 1556, 37, 19, NULL, NULL, NULL, NULL, '2015-11-11 23:13:37.694065+01', NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO association_objets (pk_association_objets, fk_objet_source, fk_objet_cible, fk_type_association_param, reference_precise_objet_source, url_objet_source, descriptif, notes, date_creation, date_modification, fk_qualificatif_objet_source, fk_role_objet_source, libelle_original_objet_source, valeur_objet_source, fk_unite_de_mesure) VALUES (84, 1555, 37, 19, NULL, NULL, NULL, NULL, '2015-11-11 23:13:37.694065+01', NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO association_objets (pk_association_objets, fk_objet_source, fk_objet_cible, fk_type_association_param, reference_precise_objet_source, url_objet_source, descriptif, notes, date_creation, date_modification, fk_qualificatif_objet_source, fk_role_objet_source, libelle_original_objet_source, valeur_objet_source, fk_unite_de_mesure) VALUES (85, 1554, 37, 19, NULL, NULL, NULL, NULL, '2015-11-11 23:13:37.694065+01', NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO association_objets (pk_association_objets, fk_objet_source, fk_objet_cible, fk_type_association_param, reference_precise_objet_source, url_objet_source, descriptif, notes, date_creation, date_modification, fk_qualificatif_objet_source, fk_role_objet_source, libelle_original_objet_source, valeur_objet_source, fk_unite_de_mesure) VALUES (86, 1553, 37, 19, NULL, NULL, NULL, NULL, '2015-11-11 23:13:37.694065+01', NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO association_objets (pk_association_objets, fk_objet_source, fk_objet_cible, fk_type_association_param, reference_precise_objet_source, url_objet_source, descriptif, notes, date_creation, date_modification, fk_qualificatif_objet_source, fk_role_objet_source, libelle_original_objet_source, valeur_objet_source, fk_unite_de_mesure) VALUES (87, 1552, 37, 19, NULL, NULL, NULL, NULL, '2015-11-11 23:13:37.694065+01', NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO association_objets (pk_association_objets, fk_objet_source, fk_objet_cible, fk_type_association_param, reference_precise_objet_source, url_objet_source, descriptif, notes, date_creation, date_modification, fk_qualificatif_objet_source, fk_role_objet_source, libelle_original_objet_source, valeur_objet_source, fk_unite_de_mesure) VALUES (88, 1551, 37, 19, NULL, NULL, NULL, NULL, '2015-11-11 23:13:37.694065+01', NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO association_objets (pk_association_objets, fk_objet_source, fk_objet_cible, fk_type_association_param, reference_precise_objet_source, url_objet_source, descriptif, notes, date_creation, date_modification, fk_qualificatif_objet_source, fk_role_objet_source, libelle_original_objet_source, valeur_objet_source, fk_unite_de_mesure) VALUES (89, 1550, 37, 19, NULL, NULL, NULL, NULL, '2015-11-11 23:13:37.694065+01', NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO association_objets (pk_association_objets, fk_objet_source, fk_objet_cible, fk_type_association_param, reference_precise_objet_source, url_objet_source, descriptif, notes, date_creation, date_modification, fk_qualificatif_objet_source, fk_role_objet_source, libelle_original_objet_source, valeur_objet_source, fk_unite_de_mesure) VALUES (90, 1549, 37, 19, NULL, NULL, NULL, NULL, '2015-11-11 23:13:37.694065+01', NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO association_objets (pk_association_objets, fk_objet_source, fk_objet_cible, fk_type_association_param, reference_precise_objet_source, url_objet_source, descriptif, notes, date_creation, date_modification, fk_qualificatif_objet_source, fk_role_objet_source, libelle_original_objet_source, valeur_objet_source, fk_unite_de_mesure) VALUES (91, 1548, 37, 19, NULL, NULL, NULL, NULL, '2015-11-11 23:13:37.694065+01', NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO association_objets (pk_association_objets, fk_objet_source, fk_objet_cible, fk_type_association_param, reference_precise_objet_source, url_objet_source, descriptif, notes, date_creation, date_modification, fk_qualificatif_objet_source, fk_role_objet_source, libelle_original_objet_source, valeur_objet_source, fk_unite_de_mesure) VALUES (92, 1547, 37, 19, NULL, NULL, NULL, NULL, '2015-11-11 23:13:37.694065+01', NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO association_objets (pk_association_objets, fk_objet_source, fk_objet_cible, fk_type_association_param, reference_precise_objet_source, url_objet_source, descriptif, notes, date_creation, date_modification, fk_qualificatif_objet_source, fk_role_objet_source, libelle_original_objet_source, valeur_objet_source, fk_unite_de_mesure) VALUES (93, 1546, 37, 19, NULL, NULL, NULL, NULL, '2015-11-11 23:13:37.694065+01', NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO association_objets (pk_association_objets, fk_objet_source, fk_objet_cible, fk_type_association_param, reference_precise_objet_source, url_objet_source, descriptif, notes, date_creation, date_modification, fk_qualificatif_objet_source, fk_role_objet_source, libelle_original_objet_source, valeur_objet_source, fk_unite_de_mesure) VALUES (94, 1545, 37, 19, NULL, NULL, NULL, NULL, '2015-11-11 23:13:37.694065+01', NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO association_objets (pk_association_objets, fk_objet_source, fk_objet_cible, fk_type_association_param, reference_precise_objet_source, url_objet_source, descriptif, notes, date_creation, date_modification, fk_qualificatif_objet_source, fk_role_objet_source, libelle_original_objet_source, valeur_objet_source, fk_unite_de_mesure) VALUES (95, 1544, 37, 19, NULL, NULL, NULL, NULL, '2015-11-11 23:13:37.694065+01', NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO association_objets (pk_association_objets, fk_objet_source, fk_objet_cible, fk_type_association_param, reference_precise_objet_source, url_objet_source, descriptif, notes, date_creation, date_modification, fk_qualificatif_objet_source, fk_role_objet_source, libelle_original_objet_source, valeur_objet_source, fk_unite_de_mesure) VALUES (96, 1543, 37, 19, NULL, NULL, NULL, NULL, '2015-11-11 23:13:37.694065+01', NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO association_objets (pk_association_objets, fk_objet_source, fk_objet_cible, fk_type_association_param, reference_precise_objet_source, url_objet_source, descriptif, notes, date_creation, date_modification, fk_qualificatif_objet_source, fk_role_objet_source, libelle_original_objet_source, valeur_objet_source, fk_unite_de_mesure) VALUES (97, 1542, 37, 19, NULL, NULL, NULL, NULL, '2015-11-11 23:13:37.694065+01', NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO association_objets (pk_association_objets, fk_objet_source, fk_objet_cible, fk_type_association_param, reference_precise_objet_source, url_objet_source, descriptif, notes, date_creation, date_modification, fk_qualificatif_objet_source, fk_role_objet_source, libelle_original_objet_source, valeur_objet_source, fk_unite_de_mesure) VALUES (98, 1541, 37, 19, NULL, NULL, NULL, NULL, '2015-11-11 23:13:37.694065+01', NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO association_objets (pk_association_objets, fk_objet_source, fk_objet_cible, fk_type_association_param, reference_precise_objet_source, url_objet_source, descriptif, notes, date_creation, date_modification, fk_qualificatif_objet_source, fk_role_objet_source, libelle_original_objet_source, valeur_objet_source, fk_unite_de_mesure) VALUES (99, 1540, 37, 19, NULL, NULL, NULL, NULL, '2015-11-11 23:13:37.694065+01', NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO association_objets (pk_association_objets, fk_objet_source, fk_objet_cible, fk_type_association_param, reference_precise_objet_source, url_objet_source, descriptif, notes, date_creation, date_modification, fk_qualificatif_objet_source, fk_role_objet_source, libelle_original_objet_source, valeur_objet_source, fk_unite_de_mesure) VALUES (100, 1539, 37, 19, NULL, NULL, NULL, NULL, '2015-11-11 23:13:37.694065+01', NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO association_objets (pk_association_objets, fk_objet_source, fk_objet_cible, fk_type_association_param, reference_precise_objet_source, url_objet_source, descriptif, notes, date_creation, date_modification, fk_qualificatif_objet_source, fk_role_objet_source, libelle_original_objet_source, valeur_objet_source, fk_unite_de_mesure) VALUES (101, 1538, 37, 19, NULL, NULL, NULL, NULL, '2015-11-11 23:13:37.694065+01', NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO association_objets (pk_association_objets, fk_objet_source, fk_objet_cible, fk_type_association_param, reference_precise_objet_source, url_objet_source, descriptif, notes, date_creation, date_modification, fk_qualificatif_objet_source, fk_role_objet_source, libelle_original_objet_source, valeur_objet_source, fk_unite_de_mesure) VALUES (102, 1537, 37, 19, NULL, NULL, NULL, NULL, '2015-11-11 23:13:37.694065+01', NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO association_objets (pk_association_objets, fk_objet_source, fk_objet_cible, fk_type_association_param, reference_precise_objet_source, url_objet_source, descriptif, notes, date_creation, date_modification, fk_qualificatif_objet_source, fk_role_objet_source, libelle_original_objet_source, valeur_objet_source, fk_unite_de_mesure) VALUES (103, 1536, 37, 19, NULL, NULL, NULL, NULL, '2015-11-11 23:13:37.694065+01', NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO association_objets (pk_association_objets, fk_objet_source, fk_objet_cible, fk_type_association_param, reference_precise_objet_source, url_objet_source, descriptif, notes, date_creation, date_modification, fk_qualificatif_objet_source, fk_role_objet_source, libelle_original_objet_source, valeur_objet_source, fk_unite_de_mesure) VALUES (104, 1535, 37, 19, NULL, NULL, NULL, NULL, '2015-11-11 23:13:37.694065+01', NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO association_objets (pk_association_objets, fk_objet_source, fk_objet_cible, fk_type_association_param, reference_precise_objet_source, url_objet_source, descriptif, notes, date_creation, date_modification, fk_qualificatif_objet_source, fk_role_objet_source, libelle_original_objet_source, valeur_objet_source, fk_unite_de_mesure) VALUES (105, 1534, 37, 19, NULL, NULL, NULL, NULL, '2015-11-11 23:13:37.694065+01', NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO association_objets (pk_association_objets, fk_objet_source, fk_objet_cible, fk_type_association_param, reference_precise_objet_source, url_objet_source, descriptif, notes, date_creation, date_modification, fk_qualificatif_objet_source, fk_role_objet_source, libelle_original_objet_source, valeur_objet_source, fk_unite_de_mesure) VALUES (106, 1533, 37, 19, NULL, NULL, NULL, NULL, '2015-11-11 23:13:37.694065+01', NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO association_objets (pk_association_objets, fk_objet_source, fk_objet_cible, fk_type_association_param, reference_precise_objet_source, url_objet_source, descriptif, notes, date_creation, date_modification, fk_qualificatif_objet_source, fk_role_objet_source, libelle_original_objet_source, valeur_objet_source, fk_unite_de_mesure) VALUES (107, 1532, 37, 19, NULL, NULL, NULL, NULL, '2015-11-11 23:13:37.694065+01', NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO association_objets (pk_association_objets, fk_objet_source, fk_objet_cible, fk_type_association_param, reference_precise_objet_source, url_objet_source, descriptif, notes, date_creation, date_modification, fk_qualificatif_objet_source, fk_role_objet_source, libelle_original_objet_source, valeur_objet_source, fk_unite_de_mesure) VALUES (108, 1531, 37, 19, NULL, NULL, NULL, NULL, '2015-11-11 23:13:37.694065+01', NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO association_objets (pk_association_objets, fk_objet_source, fk_objet_cible, fk_type_association_param, reference_precise_objet_source, url_objet_source, descriptif, notes, date_creation, date_modification, fk_qualificatif_objet_source, fk_role_objet_source, libelle_original_objet_source, valeur_objet_source, fk_unite_de_mesure) VALUES (109, 1530, 37, 19, NULL, NULL, NULL, NULL, '2015-11-11 23:13:37.694065+01', NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO association_objets (pk_association_objets, fk_objet_source, fk_objet_cible, fk_type_association_param, reference_precise_objet_source, url_objet_source, descriptif, notes, date_creation, date_modification, fk_qualificatif_objet_source, fk_role_objet_source, libelle_original_objet_source, valeur_objet_source, fk_unite_de_mesure) VALUES (110, 1529, 37, 19, NULL, NULL, NULL, NULL, '2015-11-11 23:13:37.694065+01', NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO association_objets (pk_association_objets, fk_objet_source, fk_objet_cible, fk_type_association_param, reference_precise_objet_source, url_objet_source, descriptif, notes, date_creation, date_modification, fk_qualificatif_objet_source, fk_role_objet_source, libelle_original_objet_source, valeur_objet_source, fk_unite_de_mesure) VALUES (111, 1528, 37, 19, NULL, NULL, NULL, NULL, '2015-11-11 23:13:37.694065+01', NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO association_objets (pk_association_objets, fk_objet_source, fk_objet_cible, fk_type_association_param, reference_precise_objet_source, url_objet_source, descriptif, notes, date_creation, date_modification, fk_qualificatif_objet_source, fk_role_objet_source, libelle_original_objet_source, valeur_objet_source, fk_unite_de_mesure) VALUES (112, 1527, 37, 19, NULL, NULL, NULL, NULL, '2015-11-11 23:13:37.694065+01', NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO association_objets (pk_association_objets, fk_objet_source, fk_objet_cible, fk_type_association_param, reference_precise_objet_source, url_objet_source, descriptif, notes, date_creation, date_modification, fk_qualificatif_objet_source, fk_role_objet_source, libelle_original_objet_source, valeur_objet_source, fk_unite_de_mesure) VALUES (113, 1526, 37, 19, NULL, NULL, NULL, NULL, '2015-11-11 23:13:37.694065+01', NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO association_objets (pk_association_objets, fk_objet_source, fk_objet_cible, fk_type_association_param, reference_precise_objet_source, url_objet_source, descriptif, notes, date_creation, date_modification, fk_qualificatif_objet_source, fk_role_objet_source, libelle_original_objet_source, valeur_objet_source, fk_unite_de_mesure) VALUES (114, 1525, 37, 19, NULL, NULL, NULL, NULL, '2015-11-11 23:13:37.694065+01', NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO association_objets (pk_association_objets, fk_objet_source, fk_objet_cible, fk_type_association_param, reference_precise_objet_source, url_objet_source, descriptif, notes, date_creation, date_modification, fk_qualificatif_objet_source, fk_role_objet_source, libelle_original_objet_source, valeur_objet_source, fk_unite_de_mesure) VALUES (115, 1524, 37, 19, NULL, NULL, NULL, NULL, '2015-11-11 23:13:37.694065+01', NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO association_objets (pk_association_objets, fk_objet_source, fk_objet_cible, fk_type_association_param, reference_precise_objet_source, url_objet_source, descriptif, notes, date_creation, date_modification, fk_qualificatif_objet_source, fk_role_objet_source, libelle_original_objet_source, valeur_objet_source, fk_unite_de_mesure) VALUES (116, 1523, 37, 19, NULL, NULL, NULL, NULL, '2015-11-11 23:13:37.694065+01', NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO association_objets (pk_association_objets, fk_objet_source, fk_objet_cible, fk_type_association_param, reference_precise_objet_source, url_objet_source, descriptif, notes, date_creation, date_modification, fk_qualificatif_objet_source, fk_role_objet_source, libelle_original_objet_source, valeur_objet_source, fk_unite_de_mesure) VALUES (117, 1522, 37, 19, NULL, NULL, NULL, NULL, '2015-11-11 23:13:37.694065+01', NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO association_objets (pk_association_objets, fk_objet_source, fk_objet_cible, fk_type_association_param, reference_precise_objet_source, url_objet_source, descriptif, notes, date_creation, date_modification, fk_qualificatif_objet_source, fk_role_objet_source, libelle_original_objet_source, valeur_objet_source, fk_unite_de_mesure) VALUES (118, 1521, 37, 19, NULL, NULL, NULL, NULL, '2015-11-11 23:13:37.694065+01', NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO association_objets (pk_association_objets, fk_objet_source, fk_objet_cible, fk_type_association_param, reference_precise_objet_source, url_objet_source, descriptif, notes, date_creation, date_modification, fk_qualificatif_objet_source, fk_role_objet_source, libelle_original_objet_source, valeur_objet_source, fk_unite_de_mesure) VALUES (119, 1520, 37, 19, NULL, NULL, NULL, NULL, '2015-11-11 23:13:37.694065+01', NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO association_objets (pk_association_objets, fk_objet_source, fk_objet_cible, fk_type_association_param, reference_precise_objet_source, url_objet_source, descriptif, notes, date_creation, date_modification, fk_qualificatif_objet_source, fk_role_objet_source, libelle_original_objet_source, valeur_objet_source, fk_unite_de_mesure) VALUES (120, 1519, 37, 19, NULL, NULL, NULL, NULL, '2015-11-11 23:13:37.694065+01', NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO association_objets (pk_association_objets, fk_objet_source, fk_objet_cible, fk_type_association_param, reference_precise_objet_source, url_objet_source, descriptif, notes, date_creation, date_modification, fk_qualificatif_objet_source, fk_role_objet_source, libelle_original_objet_source, valeur_objet_source, fk_unite_de_mesure) VALUES (121, 1518, 37, 19, NULL, NULL, NULL, NULL, '2015-11-11 23:13:37.694065+01', NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO association_objets (pk_association_objets, fk_objet_source, fk_objet_cible, fk_type_association_param, reference_precise_objet_source, url_objet_source, descriptif, notes, date_creation, date_modification, fk_qualificatif_objet_source, fk_role_objet_source, libelle_original_objet_source, valeur_objet_source, fk_unite_de_mesure) VALUES (122, 1517, 37, 19, NULL, NULL, NULL, NULL, '2015-11-11 23:13:37.694065+01', NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO association_objets (pk_association_objets, fk_objet_source, fk_objet_cible, fk_type_association_param, reference_precise_objet_source, url_objet_source, descriptif, notes, date_creation, date_modification, fk_qualificatif_objet_source, fk_role_objet_source, libelle_original_objet_source, valeur_objet_source, fk_unite_de_mesure) VALUES (123, 1516, 37, 19, NULL, NULL, NULL, NULL, '2015-11-11 23:13:37.694065+01', NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO association_objets (pk_association_objets, fk_objet_source, fk_objet_cible, fk_type_association_param, reference_precise_objet_source, url_objet_source, descriptif, notes, date_creation, date_modification, fk_qualificatif_objet_source, fk_role_objet_source, libelle_original_objet_source, valeur_objet_source, fk_unite_de_mesure) VALUES (124, 1515, 37, 19, NULL, NULL, NULL, NULL, '2015-11-11 23:13:37.694065+01', NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO association_objets (pk_association_objets, fk_objet_source, fk_objet_cible, fk_type_association_param, reference_precise_objet_source, url_objet_source, descriptif, notes, date_creation, date_modification, fk_qualificatif_objet_source, fk_role_objet_source, libelle_original_objet_source, valeur_objet_source, fk_unite_de_mesure) VALUES (125, 1514, 37, 19, NULL, NULL, NULL, NULL, '2015-11-11 23:13:37.694065+01', NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO association_objets (pk_association_objets, fk_objet_source, fk_objet_cible, fk_type_association_param, reference_precise_objet_source, url_objet_source, descriptif, notes, date_creation, date_modification, fk_qualificatif_objet_source, fk_role_objet_source, libelle_original_objet_source, valeur_objet_source, fk_unite_de_mesure) VALUES (126, 1513, 37, 19, NULL, NULL, NULL, NULL, '2015-11-11 23:13:37.694065+01', NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO association_objets (pk_association_objets, fk_objet_source, fk_objet_cible, fk_type_association_param, reference_precise_objet_source, url_objet_source, descriptif, notes, date_creation, date_modification, fk_qualificatif_objet_source, fk_role_objet_source, libelle_original_objet_source, valeur_objet_source, fk_unite_de_mesure) VALUES (127, 1512, 37, 19, NULL, NULL, NULL, NULL, '2015-11-11 23:13:37.694065+01', NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO association_objets (pk_association_objets, fk_objet_source, fk_objet_cible, fk_type_association_param, reference_precise_objet_source, url_objet_source, descriptif, notes, date_creation, date_modification, fk_qualificatif_objet_source, fk_role_objet_source, libelle_original_objet_source, valeur_objet_source, fk_unite_de_mesure) VALUES (128, 1511, 37, 19, NULL, NULL, NULL, NULL, '2015-11-11 23:13:37.694065+01', NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO association_objets (pk_association_objets, fk_objet_source, fk_objet_cible, fk_type_association_param, reference_precise_objet_source, url_objet_source, descriptif, notes, date_creation, date_modification, fk_qualificatif_objet_source, fk_role_objet_source, libelle_original_objet_source, valeur_objet_source, fk_unite_de_mesure) VALUES (129, 1510, 37, 19, NULL, NULL, NULL, NULL, '2015-11-11 23:13:37.694065+01', NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO association_objets (pk_association_objets, fk_objet_source, fk_objet_cible, fk_type_association_param, reference_precise_objet_source, url_objet_source, descriptif, notes, date_creation, date_modification, fk_qualificatif_objet_source, fk_role_objet_source, libelle_original_objet_source, valeur_objet_source, fk_unite_de_mesure) VALUES (130, 1509, 37, 19, NULL, NULL, NULL, NULL, '2015-11-11 23:13:37.694065+01', NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO association_objets (pk_association_objets, fk_objet_source, fk_objet_cible, fk_type_association_param, reference_precise_objet_source, url_objet_source, descriptif, notes, date_creation, date_modification, fk_qualificatif_objet_source, fk_role_objet_source, libelle_original_objet_source, valeur_objet_source, fk_unite_de_mesure) VALUES (131, 1508, 37, 19, NULL, NULL, NULL, NULL, '2015-11-11 23:13:37.694065+01', NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO association_objets (pk_association_objets, fk_objet_source, fk_objet_cible, fk_type_association_param, reference_precise_objet_source, url_objet_source, descriptif, notes, date_creation, date_modification, fk_qualificatif_objet_source, fk_role_objet_source, libelle_original_objet_source, valeur_objet_source, fk_unite_de_mesure) VALUES (132, 1507, 37, 19, NULL, NULL, NULL, NULL, '2015-11-11 23:13:37.694065+01', NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO association_objets (pk_association_objets, fk_objet_source, fk_objet_cible, fk_type_association_param, reference_precise_objet_source, url_objet_source, descriptif, notes, date_creation, date_modification, fk_qualificatif_objet_source, fk_role_objet_source, libelle_original_objet_source, valeur_objet_source, fk_unite_de_mesure) VALUES (133, 1506, 37, 19, NULL, NULL, NULL, NULL, '2015-11-11 23:13:37.694065+01', NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO association_objets (pk_association_objets, fk_objet_source, fk_objet_cible, fk_type_association_param, reference_precise_objet_source, url_objet_source, descriptif, notes, date_creation, date_modification, fk_qualificatif_objet_source, fk_role_objet_source, libelle_original_objet_source, valeur_objet_source, fk_unite_de_mesure) VALUES (134, 1505, 37, 19, NULL, NULL, NULL, NULL, '2015-11-11 23:13:37.694065+01', NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO association_objets (pk_association_objets, fk_objet_source, fk_objet_cible, fk_type_association_param, reference_precise_objet_source, url_objet_source, descriptif, notes, date_creation, date_modification, fk_qualificatif_objet_source, fk_role_objet_source, libelle_original_objet_source, valeur_objet_source, fk_unite_de_mesure) VALUES (135, 1504, 37, 19, NULL, NULL, NULL, NULL, '2015-11-11 23:13:37.694065+01', NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO association_objets (pk_association_objets, fk_objet_source, fk_objet_cible, fk_type_association_param, reference_precise_objet_source, url_objet_source, descriptif, notes, date_creation, date_modification, fk_qualificatif_objet_source, fk_role_objet_source, libelle_original_objet_source, valeur_objet_source, fk_unite_de_mesure) VALUES (136, 1503, 37, 19, NULL, NULL, NULL, NULL, '2015-11-11 23:13:37.694065+01', NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO association_objets (pk_association_objets, fk_objet_source, fk_objet_cible, fk_type_association_param, reference_precise_objet_source, url_objet_source, descriptif, notes, date_creation, date_modification, fk_qualificatif_objet_source, fk_role_objet_source, libelle_original_objet_source, valeur_objet_source, fk_unite_de_mesure) VALUES (137, 1502, 37, 19, NULL, NULL, NULL, NULL, '2015-11-11 23:13:37.694065+01', NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO association_objets (pk_association_objets, fk_objet_source, fk_objet_cible, fk_type_association_param, reference_precise_objet_source, url_objet_source, descriptif, notes, date_creation, date_modification, fk_qualificatif_objet_source, fk_role_objet_source, libelle_original_objet_source, valeur_objet_source, fk_unite_de_mesure) VALUES (138, 1501, 37, 19, NULL, NULL, NULL, NULL, '2015-11-11 23:13:37.694065+01', NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO association_objets (pk_association_objets, fk_objet_source, fk_objet_cible, fk_type_association_param, reference_precise_objet_source, url_objet_source, descriptif, notes, date_creation, date_modification, fk_qualificatif_objet_source, fk_role_objet_source, libelle_original_objet_source, valeur_objet_source, fk_unite_de_mesure) VALUES (139, 1500, 37, 19, NULL, NULL, NULL, NULL, '2015-11-11 23:13:37.694065+01', NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO association_objets (pk_association_objets, fk_objet_source, fk_objet_cible, fk_type_association_param, reference_precise_objet_source, url_objet_source, descriptif, notes, date_creation, date_modification, fk_qualificatif_objet_source, fk_role_objet_source, libelle_original_objet_source, valeur_objet_source, fk_unite_de_mesure) VALUES (140, 1499, 37, 19, NULL, NULL, NULL, NULL, '2015-11-11 23:13:37.694065+01', NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO association_objets (pk_association_objets, fk_objet_source, fk_objet_cible, fk_type_association_param, reference_precise_objet_source, url_objet_source, descriptif, notes, date_creation, date_modification, fk_qualificatif_objet_source, fk_role_objet_source, libelle_original_objet_source, valeur_objet_source, fk_unite_de_mesure) VALUES (141, 1498, 37, 19, NULL, NULL, NULL, NULL, '2015-11-11 23:13:37.694065+01', NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO association_objets (pk_association_objets, fk_objet_source, fk_objet_cible, fk_type_association_param, reference_precise_objet_source, url_objet_source, descriptif, notes, date_creation, date_modification, fk_qualificatif_objet_source, fk_role_objet_source, libelle_original_objet_source, valeur_objet_source, fk_unite_de_mesure) VALUES (142, 1497, 37, 19, NULL, NULL, NULL, NULL, '2015-11-11 23:13:37.694065+01', NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO association_objets (pk_association_objets, fk_objet_source, fk_objet_cible, fk_type_association_param, reference_precise_objet_source, url_objet_source, descriptif, notes, date_creation, date_modification, fk_qualificatif_objet_source, fk_role_objet_source, libelle_original_objet_source, valeur_objet_source, fk_unite_de_mesure) VALUES (143, 1496, 37, 19, NULL, NULL, NULL, NULL, '2015-11-11 23:13:37.694065+01', NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO association_objets (pk_association_objets, fk_objet_source, fk_objet_cible, fk_type_association_param, reference_precise_objet_source, url_objet_source, descriptif, notes, date_creation, date_modification, fk_qualificatif_objet_source, fk_role_objet_source, libelle_original_objet_source, valeur_objet_source, fk_unite_de_mesure) VALUES (144, 1495, 37, 19, NULL, NULL, NULL, NULL, '2015-11-11 23:13:37.694065+01', NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO association_objets (pk_association_objets, fk_objet_source, fk_objet_cible, fk_type_association_param, reference_precise_objet_source, url_objet_source, descriptif, notes, date_creation, date_modification, fk_qualificatif_objet_source, fk_role_objet_source, libelle_original_objet_source, valeur_objet_source, fk_unite_de_mesure) VALUES (145, 1494, 37, 19, NULL, NULL, NULL, NULL, '2015-11-11 23:13:37.694065+01', NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO association_objets (pk_association_objets, fk_objet_source, fk_objet_cible, fk_type_association_param, reference_precise_objet_source, url_objet_source, descriptif, notes, date_creation, date_modification, fk_qualificatif_objet_source, fk_role_objet_source, libelle_original_objet_source, valeur_objet_source, fk_unite_de_mesure) VALUES (146, 1493, 37, 19, NULL, NULL, NULL, NULL, '2015-11-11 23:13:37.694065+01', NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO association_objets (pk_association_objets, fk_objet_source, fk_objet_cible, fk_type_association_param, reference_precise_objet_source, url_objet_source, descriptif, notes, date_creation, date_modification, fk_qualificatif_objet_source, fk_role_objet_source, libelle_original_objet_source, valeur_objet_source, fk_unite_de_mesure) VALUES (147, 1492, 37, 19, NULL, NULL, NULL, NULL, '2015-11-11 23:13:37.694065+01', NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO association_objets (pk_association_objets, fk_objet_source, fk_objet_cible, fk_type_association_param, reference_precise_objet_source, url_objet_source, descriptif, notes, date_creation, date_modification, fk_qualificatif_objet_source, fk_role_objet_source, libelle_original_objet_source, valeur_objet_source, fk_unite_de_mesure) VALUES (148, 1491, 37, 19, NULL, NULL, NULL, NULL, '2015-11-11 23:13:37.694065+01', NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO association_objets (pk_association_objets, fk_objet_source, fk_objet_cible, fk_type_association_param, reference_precise_objet_source, url_objet_source, descriptif, notes, date_creation, date_modification, fk_qualificatif_objet_source, fk_role_objet_source, libelle_original_objet_source, valeur_objet_source, fk_unite_de_mesure) VALUES (149, 1490, 37, 19, NULL, NULL, NULL, NULL, '2015-11-11 23:13:37.694065+01', NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO association_objets (pk_association_objets, fk_objet_source, fk_objet_cible, fk_type_association_param, reference_precise_objet_source, url_objet_source, descriptif, notes, date_creation, date_modification, fk_qualificatif_objet_source, fk_role_objet_source, libelle_original_objet_source, valeur_objet_source, fk_unite_de_mesure) VALUES (150, 1489, 37, 19, NULL, NULL, NULL, NULL, '2015-11-11 23:13:37.694065+01', NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO association_objets (pk_association_objets, fk_objet_source, fk_objet_cible, fk_type_association_param, reference_precise_objet_source, url_objet_source, descriptif, notes, date_creation, date_modification, fk_qualificatif_objet_source, fk_role_objet_source, libelle_original_objet_source, valeur_objet_source, fk_unite_de_mesure) VALUES (151, 1488, 37, 19, NULL, NULL, NULL, NULL, '2015-11-11 23:13:37.694065+01', NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO association_objets (pk_association_objets, fk_objet_source, fk_objet_cible, fk_type_association_param, reference_precise_objet_source, url_objet_source, descriptif, notes, date_creation, date_modification, fk_qualificatif_objet_source, fk_role_objet_source, libelle_original_objet_source, valeur_objet_source, fk_unite_de_mesure) VALUES (152, 1487, 37, 19, NULL, NULL, NULL, NULL, '2015-11-11 23:13:37.694065+01', NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO association_objets (pk_association_objets, fk_objet_source, fk_objet_cible, fk_type_association_param, reference_precise_objet_source, url_objet_source, descriptif, notes, date_creation, date_modification, fk_qualificatif_objet_source, fk_role_objet_source, libelle_original_objet_source, valeur_objet_source, fk_unite_de_mesure) VALUES (153, 1486, 37, 19, NULL, NULL, NULL, NULL, '2015-11-11 23:13:37.694065+01', NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO association_objets (pk_association_objets, fk_objet_source, fk_objet_cible, fk_type_association_param, reference_precise_objet_source, url_objet_source, descriptif, notes, date_creation, date_modification, fk_qualificatif_objet_source, fk_role_objet_source, libelle_original_objet_source, valeur_objet_source, fk_unite_de_mesure) VALUES (154, 1485, 37, 19, NULL, NULL, NULL, NULL, '2015-11-11 23:13:37.694065+01', NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO association_objets (pk_association_objets, fk_objet_source, fk_objet_cible, fk_type_association_param, reference_precise_objet_source, url_objet_source, descriptif, notes, date_creation, date_modification, fk_qualificatif_objet_source, fk_role_objet_source, libelle_original_objet_source, valeur_objet_source, fk_unite_de_mesure) VALUES (155, 1484, 37, 19, NULL, NULL, NULL, NULL, '2015-11-11 23:13:37.694065+01', NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO association_objets (pk_association_objets, fk_objet_source, fk_objet_cible, fk_type_association_param, reference_precise_objet_source, url_objet_source, descriptif, notes, date_creation, date_modification, fk_qualificatif_objet_source, fk_role_objet_source, libelle_original_objet_source, valeur_objet_source, fk_unite_de_mesure) VALUES (156, 1483, 37, 19, NULL, NULL, NULL, NULL, '2015-11-11 23:13:37.694065+01', NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO association_objets (pk_association_objets, fk_objet_source, fk_objet_cible, fk_type_association_param, reference_precise_objet_source, url_objet_source, descriptif, notes, date_creation, date_modification, fk_qualificatif_objet_source, fk_role_objet_source, libelle_original_objet_source, valeur_objet_source, fk_unite_de_mesure) VALUES (157, 1482, 37, 19, NULL, NULL, NULL, NULL, '2015-11-11 23:13:37.694065+01', NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO association_objets (pk_association_objets, fk_objet_source, fk_objet_cible, fk_type_association_param, reference_precise_objet_source, url_objet_source, descriptif, notes, date_creation, date_modification, fk_qualificatif_objet_source, fk_role_objet_source, libelle_original_objet_source, valeur_objet_source, fk_unite_de_mesure) VALUES (158, 1481, 37, 19, NULL, NULL, NULL, NULL, '2015-11-11 23:13:37.694065+01', NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO association_objets (pk_association_objets, fk_objet_source, fk_objet_cible, fk_type_association_param, reference_precise_objet_source, url_objet_source, descriptif, notes, date_creation, date_modification, fk_qualificatif_objet_source, fk_role_objet_source, libelle_original_objet_source, valeur_objet_source, fk_unite_de_mesure) VALUES (159, 1480, 37, 19, NULL, NULL, NULL, NULL, '2015-11-11 23:13:37.694065+01', NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO association_objets (pk_association_objets, fk_objet_source, fk_objet_cible, fk_type_association_param, reference_precise_objet_source, url_objet_source, descriptif, notes, date_creation, date_modification, fk_qualificatif_objet_source, fk_role_objet_source, libelle_original_objet_source, valeur_objet_source, fk_unite_de_mesure) VALUES (160, 1479, 37, 19, NULL, NULL, NULL, NULL, '2015-11-11 23:13:37.694065+01', NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO association_objets (pk_association_objets, fk_objet_source, fk_objet_cible, fk_type_association_param, reference_precise_objet_source, url_objet_source, descriptif, notes, date_creation, date_modification, fk_qualificatif_objet_source, fk_role_objet_source, libelle_original_objet_source, valeur_objet_source, fk_unite_de_mesure) VALUES (161, 1478, 37, 19, NULL, NULL, NULL, NULL, '2015-11-11 23:13:37.694065+01', NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO association_objets (pk_association_objets, fk_objet_source, fk_objet_cible, fk_type_association_param, reference_precise_objet_source, url_objet_source, descriptif, notes, date_creation, date_modification, fk_qualificatif_objet_source, fk_role_objet_source, libelle_original_objet_source, valeur_objet_source, fk_unite_de_mesure) VALUES (162, 1477, 37, 19, NULL, NULL, NULL, NULL, '2015-11-11 23:13:37.694065+01', NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO association_objets (pk_association_objets, fk_objet_source, fk_objet_cible, fk_type_association_param, reference_precise_objet_source, url_objet_source, descriptif, notes, date_creation, date_modification, fk_qualificatif_objet_source, fk_role_objet_source, libelle_original_objet_source, valeur_objet_source, fk_unite_de_mesure) VALUES (163, 1476, 37, 19, NULL, NULL, NULL, NULL, '2015-11-11 23:13:37.694065+01', NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO association_objets (pk_association_objets, fk_objet_source, fk_objet_cible, fk_type_association_param, reference_precise_objet_source, url_objet_source, descriptif, notes, date_creation, date_modification, fk_qualificatif_objet_source, fk_role_objet_source, libelle_original_objet_source, valeur_objet_source, fk_unite_de_mesure) VALUES (164, 1475, 37, 19, NULL, NULL, NULL, NULL, '2015-11-11 23:13:37.694065+01', NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO association_objets (pk_association_objets, fk_objet_source, fk_objet_cible, fk_type_association_param, reference_precise_objet_source, url_objet_source, descriptif, notes, date_creation, date_modification, fk_qualificatif_objet_source, fk_role_objet_source, libelle_original_objet_source, valeur_objet_source, fk_unite_de_mesure) VALUES (165, 1474, 37, 19, NULL, NULL, NULL, NULL, '2015-11-11 23:13:37.694065+01', NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO association_objets (pk_association_objets, fk_objet_source, fk_objet_cible, fk_type_association_param, reference_precise_objet_source, url_objet_source, descriptif, notes, date_creation, date_modification, fk_qualificatif_objet_source, fk_role_objet_source, libelle_original_objet_source, valeur_objet_source, fk_unite_de_mesure) VALUES (166, 1473, 37, 19, NULL, NULL, NULL, NULL, '2015-11-11 23:13:37.694065+01', NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO association_objets (pk_association_objets, fk_objet_source, fk_objet_cible, fk_type_association_param, reference_precise_objet_source, url_objet_source, descriptif, notes, date_creation, date_modification, fk_qualificatif_objet_source, fk_role_objet_source, libelle_original_objet_source, valeur_objet_source, fk_unite_de_mesure) VALUES (167, 1472, 37, 19, NULL, NULL, NULL, NULL, '2015-11-11 23:13:37.694065+01', NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO association_objets (pk_association_objets, fk_objet_source, fk_objet_cible, fk_type_association_param, reference_precise_objet_source, url_objet_source, descriptif, notes, date_creation, date_modification, fk_qualificatif_objet_source, fk_role_objet_source, libelle_original_objet_source, valeur_objet_source, fk_unite_de_mesure) VALUES (168, 1471, 37, 19, NULL, NULL, NULL, NULL, '2015-11-11 23:13:37.694065+01', NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO association_objets (pk_association_objets, fk_objet_source, fk_objet_cible, fk_type_association_param, reference_precise_objet_source, url_objet_source, descriptif, notes, date_creation, date_modification, fk_qualificatif_objet_source, fk_role_objet_source, libelle_original_objet_source, valeur_objet_source, fk_unite_de_mesure) VALUES (169, 1470, 37, 19, NULL, NULL, NULL, NULL, '2015-11-11 23:13:37.694065+01', NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO association_objets (pk_association_objets, fk_objet_source, fk_objet_cible, fk_type_association_param, reference_precise_objet_source, url_objet_source, descriptif, notes, date_creation, date_modification, fk_qualificatif_objet_source, fk_role_objet_source, libelle_original_objet_source, valeur_objet_source, fk_unite_de_mesure) VALUES (170, 1469, 37, 19, NULL, NULL, NULL, NULL, '2015-11-11 23:13:37.694065+01', NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO association_objets (pk_association_objets, fk_objet_source, fk_objet_cible, fk_type_association_param, reference_precise_objet_source, url_objet_source, descriptif, notes, date_creation, date_modification, fk_qualificatif_objet_source, fk_role_objet_source, libelle_original_objet_source, valeur_objet_source, fk_unite_de_mesure) VALUES (171, 1468, 37, 19, NULL, NULL, NULL, NULL, '2015-11-11 23:13:37.694065+01', NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO association_objets (pk_association_objets, fk_objet_source, fk_objet_cible, fk_type_association_param, reference_precise_objet_source, url_objet_source, descriptif, notes, date_creation, date_modification, fk_qualificatif_objet_source, fk_role_objet_source, libelle_original_objet_source, valeur_objet_source, fk_unite_de_mesure) VALUES (172, 1467, 37, 19, NULL, NULL, NULL, NULL, '2015-11-11 23:13:37.694065+01', NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO association_objets (pk_association_objets, fk_objet_source, fk_objet_cible, fk_type_association_param, reference_precise_objet_source, url_objet_source, descriptif, notes, date_creation, date_modification, fk_qualificatif_objet_source, fk_role_objet_source, libelle_original_objet_source, valeur_objet_source, fk_unite_de_mesure) VALUES (173, 1466, 37, 19, NULL, NULL, NULL, NULL, '2015-11-11 23:13:37.694065+01', NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO association_objets (pk_association_objets, fk_objet_source, fk_objet_cible, fk_type_association_param, reference_precise_objet_source, url_objet_source, descriptif, notes, date_creation, date_modification, fk_qualificatif_objet_source, fk_role_objet_source, libelle_original_objet_source, valeur_objet_source, fk_unite_de_mesure) VALUES (174, 1465, 37, 19, NULL, NULL, NULL, NULL, '2015-11-11 23:13:37.694065+01', NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO association_objets (pk_association_objets, fk_objet_source, fk_objet_cible, fk_type_association_param, reference_precise_objet_source, url_objet_source, descriptif, notes, date_creation, date_modification, fk_qualificatif_objet_source, fk_role_objet_source, libelle_original_objet_source, valeur_objet_source, fk_unite_de_mesure) VALUES (175, 1464, 37, 19, NULL, NULL, NULL, NULL, '2015-11-11 23:13:37.694065+01', NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO association_objets (pk_association_objets, fk_objet_source, fk_objet_cible, fk_type_association_param, reference_precise_objet_source, url_objet_source, descriptif, notes, date_creation, date_modification, fk_qualificatif_objet_source, fk_role_objet_source, libelle_original_objet_source, valeur_objet_source, fk_unite_de_mesure) VALUES (176, 1463, 37, 19, NULL, NULL, NULL, NULL, '2015-11-11 23:13:37.694065+01', NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO association_objets (pk_association_objets, fk_objet_source, fk_objet_cible, fk_type_association_param, reference_precise_objet_source, url_objet_source, descriptif, notes, date_creation, date_modification, fk_qualificatif_objet_source, fk_role_objet_source, libelle_original_objet_source, valeur_objet_source, fk_unite_de_mesure) VALUES (177, 1462, 37, 19, NULL, NULL, NULL, NULL, '2015-11-11 23:13:37.694065+01', NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO association_objets (pk_association_objets, fk_objet_source, fk_objet_cible, fk_type_association_param, reference_precise_objet_source, url_objet_source, descriptif, notes, date_creation, date_modification, fk_qualificatif_objet_source, fk_role_objet_source, libelle_original_objet_source, valeur_objet_source, fk_unite_de_mesure) VALUES (178, 1461, 37, 19, NULL, NULL, NULL, NULL, '2015-11-11 23:13:37.694065+01', NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO association_objets (pk_association_objets, fk_objet_source, fk_objet_cible, fk_type_association_param, reference_precise_objet_source, url_objet_source, descriptif, notes, date_creation, date_modification, fk_qualificatif_objet_source, fk_role_objet_source, libelle_original_objet_source, valeur_objet_source, fk_unite_de_mesure) VALUES (179, 1460, 37, 19, NULL, NULL, NULL, NULL, '2015-11-11 23:13:37.694065+01', NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO association_objets (pk_association_objets, fk_objet_source, fk_objet_cible, fk_type_association_param, reference_precise_objet_source, url_objet_source, descriptif, notes, date_creation, date_modification, fk_qualificatif_objet_source, fk_role_objet_source, libelle_original_objet_source, valeur_objet_source, fk_unite_de_mesure) VALUES (180, 1459, 37, 19, NULL, NULL, NULL, NULL, '2015-11-11 23:13:37.694065+01', NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO association_objets (pk_association_objets, fk_objet_source, fk_objet_cible, fk_type_association_param, reference_precise_objet_source, url_objet_source, descriptif, notes, date_creation, date_modification, fk_qualificatif_objet_source, fk_role_objet_source, libelle_original_objet_source, valeur_objet_source, fk_unite_de_mesure) VALUES (181, 1458, 37, 19, NULL, NULL, NULL, NULL, '2015-11-11 23:13:37.694065+01', NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO association_objets (pk_association_objets, fk_objet_source, fk_objet_cible, fk_type_association_param, reference_precise_objet_source, url_objet_source, descriptif, notes, date_creation, date_modification, fk_qualificatif_objet_source, fk_role_objet_source, libelle_original_objet_source, valeur_objet_source, fk_unite_de_mesure) VALUES (182, 1457, 37, 19, NULL, NULL, NULL, NULL, '2015-11-11 23:13:37.694065+01', NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO association_objets (pk_association_objets, fk_objet_source, fk_objet_cible, fk_type_association_param, reference_precise_objet_source, url_objet_source, descriptif, notes, date_creation, date_modification, fk_qualificatif_objet_source, fk_role_objet_source, libelle_original_objet_source, valeur_objet_source, fk_unite_de_mesure) VALUES (183, 1456, 37, 19, NULL, NULL, NULL, NULL, '2015-11-11 23:13:37.694065+01', NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO association_objets (pk_association_objets, fk_objet_source, fk_objet_cible, fk_type_association_param, reference_precise_objet_source, url_objet_source, descriptif, notes, date_creation, date_modification, fk_qualificatif_objet_source, fk_role_objet_source, libelle_original_objet_source, valeur_objet_source, fk_unite_de_mesure) VALUES (184, 1455, 37, 19, NULL, NULL, NULL, NULL, '2015-11-11 23:13:37.694065+01', NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO association_objets (pk_association_objets, fk_objet_source, fk_objet_cible, fk_type_association_param, reference_precise_objet_source, url_objet_source, descriptif, notes, date_creation, date_modification, fk_qualificatif_objet_source, fk_role_objet_source, libelle_original_objet_source, valeur_objet_source, fk_unite_de_mesure) VALUES (185, 1454, 37, 19, NULL, NULL, NULL, NULL, '2015-11-11 23:13:37.694065+01', NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO association_objets (pk_association_objets, fk_objet_source, fk_objet_cible, fk_type_association_param, reference_precise_objet_source, url_objet_source, descriptif, notes, date_creation, date_modification, fk_qualificatif_objet_source, fk_role_objet_source, libelle_original_objet_source, valeur_objet_source, fk_unite_de_mesure) VALUES (186, 1453, 37, 19, NULL, NULL, NULL, NULL, '2015-11-11 23:13:37.694065+01', NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO association_objets (pk_association_objets, fk_objet_source, fk_objet_cible, fk_type_association_param, reference_precise_objet_source, url_objet_source, descriptif, notes, date_creation, date_modification, fk_qualificatif_objet_source, fk_role_objet_source, libelle_original_objet_source, valeur_objet_source, fk_unite_de_mesure) VALUES (187, 1452, 37, 19, NULL, NULL, NULL, NULL, '2015-11-11 23:13:37.694065+01', NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO association_objets (pk_association_objets, fk_objet_source, fk_objet_cible, fk_type_association_param, reference_precise_objet_source, url_objet_source, descriptif, notes, date_creation, date_modification, fk_qualificatif_objet_source, fk_role_objet_source, libelle_original_objet_source, valeur_objet_source, fk_unite_de_mesure) VALUES (188, 1451, 37, 19, NULL, NULL, NULL, NULL, '2015-11-11 23:13:37.694065+01', NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO association_objets (pk_association_objets, fk_objet_source, fk_objet_cible, fk_type_association_param, reference_precise_objet_source, url_objet_source, descriptif, notes, date_creation, date_modification, fk_qualificatif_objet_source, fk_role_objet_source, libelle_original_objet_source, valeur_objet_source, fk_unite_de_mesure) VALUES (189, 1450, 37, 19, NULL, NULL, NULL, NULL, '2015-11-11 23:13:37.694065+01', NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO association_objets (pk_association_objets, fk_objet_source, fk_objet_cible, fk_type_association_param, reference_precise_objet_source, url_objet_source, descriptif, notes, date_creation, date_modification, fk_qualificatif_objet_source, fk_role_objet_source, libelle_original_objet_source, valeur_objet_source, fk_unite_de_mesure) VALUES (190, 1449, 37, 19, NULL, NULL, NULL, NULL, '2015-11-11 23:13:37.694065+01', NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO association_objets (pk_association_objets, fk_objet_source, fk_objet_cible, fk_type_association_param, reference_precise_objet_source, url_objet_source, descriptif, notes, date_creation, date_modification, fk_qualificatif_objet_source, fk_role_objet_source, libelle_original_objet_source, valeur_objet_source, fk_unite_de_mesure) VALUES (191, 1448, 37, 19, NULL, NULL, NULL, NULL, '2015-11-11 23:13:37.694065+01', NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO association_objets (pk_association_objets, fk_objet_source, fk_objet_cible, fk_type_association_param, reference_precise_objet_source, url_objet_source, descriptif, notes, date_creation, date_modification, fk_qualificatif_objet_source, fk_role_objet_source, libelle_original_objet_source, valeur_objet_source, fk_unite_de_mesure) VALUES (192, 1447, 37, 19, NULL, NULL, NULL, NULL, '2015-11-11 23:13:37.694065+01', NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO association_objets (pk_association_objets, fk_objet_source, fk_objet_cible, fk_type_association_param, reference_precise_objet_source, url_objet_source, descriptif, notes, date_creation, date_modification, fk_qualificatif_objet_source, fk_role_objet_source, libelle_original_objet_source, valeur_objet_source, fk_unite_de_mesure) VALUES (193, 1446, 37, 19, NULL, NULL, NULL, NULL, '2015-11-11 23:13:37.694065+01', NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO association_objets (pk_association_objets, fk_objet_source, fk_objet_cible, fk_type_association_param, reference_precise_objet_source, url_objet_source, descriptif, notes, date_creation, date_modification, fk_qualificatif_objet_source, fk_role_objet_source, libelle_original_objet_source, valeur_objet_source, fk_unite_de_mesure) VALUES (194, 1445, 37, 19, NULL, NULL, NULL, NULL, '2015-11-11 23:13:37.694065+01', NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO association_objets (pk_association_objets, fk_objet_source, fk_objet_cible, fk_type_association_param, reference_precise_objet_source, url_objet_source, descriptif, notes, date_creation, date_modification, fk_qualificatif_objet_source, fk_role_objet_source, libelle_original_objet_source, valeur_objet_source, fk_unite_de_mesure) VALUES (195, 1444, 37, 19, NULL, NULL, NULL, NULL, '2015-11-11 23:13:37.694065+01', NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO association_objets (pk_association_objets, fk_objet_source, fk_objet_cible, fk_type_association_param, reference_precise_objet_source, url_objet_source, descriptif, notes, date_creation, date_modification, fk_qualificatif_objet_source, fk_role_objet_source, libelle_original_objet_source, valeur_objet_source, fk_unite_de_mesure) VALUES (196, 1443, 37, 19, NULL, NULL, NULL, NULL, '2015-11-11 23:13:37.694065+01', NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO association_objets (pk_association_objets, fk_objet_source, fk_objet_cible, fk_type_association_param, reference_precise_objet_source, url_objet_source, descriptif, notes, date_creation, date_modification, fk_qualificatif_objet_source, fk_role_objet_source, libelle_original_objet_source, valeur_objet_source, fk_unite_de_mesure) VALUES (197, 1442, 37, 19, NULL, NULL, NULL, NULL, '2015-11-11 23:13:37.694065+01', NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO association_objets (pk_association_objets, fk_objet_source, fk_objet_cible, fk_type_association_param, reference_precise_objet_source, url_objet_source, descriptif, notes, date_creation, date_modification, fk_qualificatif_objet_source, fk_role_objet_source, libelle_original_objet_source, valeur_objet_source, fk_unite_de_mesure) VALUES (198, 1441, 37, 19, NULL, NULL, NULL, NULL, '2015-11-11 23:13:37.694065+01', NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO association_objets (pk_association_objets, fk_objet_source, fk_objet_cible, fk_type_association_param, reference_precise_objet_source, url_objet_source, descriptif, notes, date_creation, date_modification, fk_qualificatif_objet_source, fk_role_objet_source, libelle_original_objet_source, valeur_objet_source, fk_unite_de_mesure) VALUES (199, 1440, 37, 19, NULL, NULL, NULL, NULL, '2015-11-11 23:13:37.694065+01', NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO association_objets (pk_association_objets, fk_objet_source, fk_objet_cible, fk_type_association_param, reference_precise_objet_source, url_objet_source, descriptif, notes, date_creation, date_modification, fk_qualificatif_objet_source, fk_role_objet_source, libelle_original_objet_source, valeur_objet_source, fk_unite_de_mesure) VALUES (200, 1439, 37, 19, NULL, NULL, NULL, NULL, '2015-11-11 23:13:37.694065+01', NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO association_objets (pk_association_objets, fk_objet_source, fk_objet_cible, fk_type_association_param, reference_precise_objet_source, url_objet_source, descriptif, notes, date_creation, date_modification, fk_qualificatif_objet_source, fk_role_objet_source, libelle_original_objet_source, valeur_objet_source, fk_unite_de_mesure) VALUES (201, 1438, 37, 19, NULL, NULL, NULL, NULL, '2015-11-11 23:13:37.694065+01', NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO association_objets (pk_association_objets, fk_objet_source, fk_objet_cible, fk_type_association_param, reference_precise_objet_source, url_objet_source, descriptif, notes, date_creation, date_modification, fk_qualificatif_objet_source, fk_role_objet_source, libelle_original_objet_source, valeur_objet_source, fk_unite_de_mesure) VALUES (202, 1437, 37, 19, NULL, NULL, NULL, NULL, '2015-11-11 23:13:37.694065+01', NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO association_objets (pk_association_objets, fk_objet_source, fk_objet_cible, fk_type_association_param, reference_precise_objet_source, url_objet_source, descriptif, notes, date_creation, date_modification, fk_qualificatif_objet_source, fk_role_objet_source, libelle_original_objet_source, valeur_objet_source, fk_unite_de_mesure) VALUES (203, 1436, 37, 19, NULL, NULL, NULL, NULL, '2015-11-11 23:13:37.694065+01', NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO association_objets (pk_association_objets, fk_objet_source, fk_objet_cible, fk_type_association_param, reference_precise_objet_source, url_objet_source, descriptif, notes, date_creation, date_modification, fk_qualificatif_objet_source, fk_role_objet_source, libelle_original_objet_source, valeur_objet_source, fk_unite_de_mesure) VALUES (204, 1435, 37, 19, NULL, NULL, NULL, NULL, '2015-11-11 23:13:37.694065+01', NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO association_objets (pk_association_objets, fk_objet_source, fk_objet_cible, fk_type_association_param, reference_precise_objet_source, url_objet_source, descriptif, notes, date_creation, date_modification, fk_qualificatif_objet_source, fk_role_objet_source, libelle_original_objet_source, valeur_objet_source, fk_unite_de_mesure) VALUES (205, 1434, 37, 19, NULL, NULL, NULL, NULL, '2015-11-11 23:13:37.694065+01', NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO association_objets (pk_association_objets, fk_objet_source, fk_objet_cible, fk_type_association_param, reference_precise_objet_source, url_objet_source, descriptif, notes, date_creation, date_modification, fk_qualificatif_objet_source, fk_role_objet_source, libelle_original_objet_source, valeur_objet_source, fk_unite_de_mesure) VALUES (206, 1433, 37, 19, NULL, NULL, NULL, NULL, '2015-11-11 23:13:37.694065+01', NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO association_objets (pk_association_objets, fk_objet_source, fk_objet_cible, fk_type_association_param, reference_precise_objet_source, url_objet_source, descriptif, notes, date_creation, date_modification, fk_qualificatif_objet_source, fk_role_objet_source, libelle_original_objet_source, valeur_objet_source, fk_unite_de_mesure) VALUES (207, 1432, 37, 19, NULL, NULL, NULL, NULL, '2015-11-11 23:13:37.694065+01', NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO association_objets (pk_association_objets, fk_objet_source, fk_objet_cible, fk_type_association_param, reference_precise_objet_source, url_objet_source, descriptif, notes, date_creation, date_modification, fk_qualificatif_objet_source, fk_role_objet_source, libelle_original_objet_source, valeur_objet_source, fk_unite_de_mesure) VALUES (208, 1431, 37, 19, NULL, NULL, NULL, NULL, '2015-11-11 23:13:37.694065+01', NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO association_objets (pk_association_objets, fk_objet_source, fk_objet_cible, fk_type_association_param, reference_precise_objet_source, url_objet_source, descriptif, notes, date_creation, date_modification, fk_qualificatif_objet_source, fk_role_objet_source, libelle_original_objet_source, valeur_objet_source, fk_unite_de_mesure) VALUES (209, 1430, 37, 19, NULL, NULL, NULL, NULL, '2015-11-11 23:13:37.694065+01', NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO association_objets (pk_association_objets, fk_objet_source, fk_objet_cible, fk_type_association_param, reference_precise_objet_source, url_objet_source, descriptif, notes, date_creation, date_modification, fk_qualificatif_objet_source, fk_role_objet_source, libelle_original_objet_source, valeur_objet_source, fk_unite_de_mesure) VALUES (210, 1429, 37, 19, NULL, NULL, NULL, NULL, '2015-11-11 23:13:37.694065+01', NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO association_objets (pk_association_objets, fk_objet_source, fk_objet_cible, fk_type_association_param, reference_precise_objet_source, url_objet_source, descriptif, notes, date_creation, date_modification, fk_qualificatif_objet_source, fk_role_objet_source, libelle_original_objet_source, valeur_objet_source, fk_unite_de_mesure) VALUES (211, 1428, 37, 19, NULL, NULL, NULL, NULL, '2015-11-11 23:13:37.694065+01', NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO association_objets (pk_association_objets, fk_objet_source, fk_objet_cible, fk_type_association_param, reference_precise_objet_source, url_objet_source, descriptif, notes, date_creation, date_modification, fk_qualificatif_objet_source, fk_role_objet_source, libelle_original_objet_source, valeur_objet_source, fk_unite_de_mesure) VALUES (212, 1427, 37, 19, NULL, NULL, NULL, NULL, '2015-11-11 23:13:37.694065+01', NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO association_objets (pk_association_objets, fk_objet_source, fk_objet_cible, fk_type_association_param, reference_precise_objet_source, url_objet_source, descriptif, notes, date_creation, date_modification, fk_qualificatif_objet_source, fk_role_objet_source, libelle_original_objet_source, valeur_objet_source, fk_unite_de_mesure) VALUES (213, 1426, 37, 19, NULL, NULL, NULL, NULL, '2015-11-11 23:13:37.694065+01', NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO association_objets (pk_association_objets, fk_objet_source, fk_objet_cible, fk_type_association_param, reference_precise_objet_source, url_objet_source, descriptif, notes, date_creation, date_modification, fk_qualificatif_objet_source, fk_role_objet_source, libelle_original_objet_source, valeur_objet_source, fk_unite_de_mesure) VALUES (214, 1425, 37, 19, NULL, NULL, NULL, NULL, '2015-11-11 23:13:37.694065+01', NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO association_objets (pk_association_objets, fk_objet_source, fk_objet_cible, fk_type_association_param, reference_precise_objet_source, url_objet_source, descriptif, notes, date_creation, date_modification, fk_qualificatif_objet_source, fk_role_objet_source, libelle_original_objet_source, valeur_objet_source, fk_unite_de_mesure) VALUES (215, 1424, 37, 19, NULL, NULL, NULL, NULL, '2015-11-11 23:13:37.694065+01', NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO association_objets (pk_association_objets, fk_objet_source, fk_objet_cible, fk_type_association_param, reference_precise_objet_source, url_objet_source, descriptif, notes, date_creation, date_modification, fk_qualificatif_objet_source, fk_role_objet_source, libelle_original_objet_source, valeur_objet_source, fk_unite_de_mesure) VALUES (216, 1423, 37, 19, NULL, NULL, NULL, NULL, '2015-11-11 23:13:37.694065+01', NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO association_objets (pk_association_objets, fk_objet_source, fk_objet_cible, fk_type_association_param, reference_precise_objet_source, url_objet_source, descriptif, notes, date_creation, date_modification, fk_qualificatif_objet_source, fk_role_objet_source, libelle_original_objet_source, valeur_objet_source, fk_unite_de_mesure) VALUES (217, 1422, 37, 19, NULL, NULL, NULL, NULL, '2015-11-11 23:13:37.694065+01', NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO association_objets (pk_association_objets, fk_objet_source, fk_objet_cible, fk_type_association_param, reference_precise_objet_source, url_objet_source, descriptif, notes, date_creation, date_modification, fk_qualificatif_objet_source, fk_role_objet_source, libelle_original_objet_source, valeur_objet_source, fk_unite_de_mesure) VALUES (218, 1421, 37, 19, NULL, NULL, NULL, NULL, '2015-11-11 23:13:37.694065+01', NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO association_objets (pk_association_objets, fk_objet_source, fk_objet_cible, fk_type_association_param, reference_precise_objet_source, url_objet_source, descriptif, notes, date_creation, date_modification, fk_qualificatif_objet_source, fk_role_objet_source, libelle_original_objet_source, valeur_objet_source, fk_unite_de_mesure) VALUES (219, 1420, 37, 19, NULL, NULL, NULL, NULL, '2015-11-11 23:13:37.694065+01', NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO association_objets (pk_association_objets, fk_objet_source, fk_objet_cible, fk_type_association_param, reference_precise_objet_source, url_objet_source, descriptif, notes, date_creation, date_modification, fk_qualificatif_objet_source, fk_role_objet_source, libelle_original_objet_source, valeur_objet_source, fk_unite_de_mesure) VALUES (220, 1419, 37, 19, NULL, NULL, NULL, NULL, '2015-11-11 23:13:37.694065+01', NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO association_objets (pk_association_objets, fk_objet_source, fk_objet_cible, fk_type_association_param, reference_precise_objet_source, url_objet_source, descriptif, notes, date_creation, date_modification, fk_qualificatif_objet_source, fk_role_objet_source, libelle_original_objet_source, valeur_objet_source, fk_unite_de_mesure) VALUES (221, 1418, 37, 19, NULL, NULL, NULL, NULL, '2015-11-11 23:13:37.694065+01', NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO association_objets (pk_association_objets, fk_objet_source, fk_objet_cible, fk_type_association_param, reference_precise_objet_source, url_objet_source, descriptif, notes, date_creation, date_modification, fk_qualificatif_objet_source, fk_role_objet_source, libelle_original_objet_source, valeur_objet_source, fk_unite_de_mesure) VALUES (222, 1417, 37, 19, NULL, NULL, NULL, NULL, '2015-11-11 23:13:37.694065+01', NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO association_objets (pk_association_objets, fk_objet_source, fk_objet_cible, fk_type_association_param, reference_precise_objet_source, url_objet_source, descriptif, notes, date_creation, date_modification, fk_qualificatif_objet_source, fk_role_objet_source, libelle_original_objet_source, valeur_objet_source, fk_unite_de_mesure) VALUES (223, 1416, 37, 19, NULL, NULL, NULL, NULL, '2015-11-11 23:13:37.694065+01', NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO association_objets (pk_association_objets, fk_objet_source, fk_objet_cible, fk_type_association_param, reference_precise_objet_source, url_objet_source, descriptif, notes, date_creation, date_modification, fk_qualificatif_objet_source, fk_role_objet_source, libelle_original_objet_source, valeur_objet_source, fk_unite_de_mesure) VALUES (224, 1415, 37, 19, NULL, NULL, NULL, NULL, '2015-11-11 23:13:37.694065+01', NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO association_objets (pk_association_objets, fk_objet_source, fk_objet_cible, fk_type_association_param, reference_precise_objet_source, url_objet_source, descriptif, notes, date_creation, date_modification, fk_qualificatif_objet_source, fk_role_objet_source, libelle_original_objet_source, valeur_objet_source, fk_unite_de_mesure) VALUES (225, 1414, 37, 19, NULL, NULL, NULL, NULL, '2015-11-11 23:13:37.694065+01', NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO association_objets (pk_association_objets, fk_objet_source, fk_objet_cible, fk_type_association_param, reference_precise_objet_source, url_objet_source, descriptif, notes, date_creation, date_modification, fk_qualificatif_objet_source, fk_role_objet_source, libelle_original_objet_source, valeur_objet_source, fk_unite_de_mesure) VALUES (226, 1413, 37, 19, NULL, NULL, NULL, NULL, '2015-11-11 23:13:37.694065+01', NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO association_objets (pk_association_objets, fk_objet_source, fk_objet_cible, fk_type_association_param, reference_precise_objet_source, url_objet_source, descriptif, notes, date_creation, date_modification, fk_qualificatif_objet_source, fk_role_objet_source, libelle_original_objet_source, valeur_objet_source, fk_unite_de_mesure) VALUES (227, 1412, 37, 19, NULL, NULL, NULL, NULL, '2015-11-11 23:13:37.694065+01', NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO association_objets (pk_association_objets, fk_objet_source, fk_objet_cible, fk_type_association_param, reference_precise_objet_source, url_objet_source, descriptif, notes, date_creation, date_modification, fk_qualificatif_objet_source, fk_role_objet_source, libelle_original_objet_source, valeur_objet_source, fk_unite_de_mesure) VALUES (228, 1411, 37, 19, NULL, NULL, NULL, NULL, '2015-11-11 23:13:37.694065+01', NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO association_objets (pk_association_objets, fk_objet_source, fk_objet_cible, fk_type_association_param, reference_precise_objet_source, url_objet_source, descriptif, notes, date_creation, date_modification, fk_qualificatif_objet_source, fk_role_objet_source, libelle_original_objet_source, valeur_objet_source, fk_unite_de_mesure) VALUES (229, 1410, 37, 19, NULL, NULL, NULL, NULL, '2015-11-11 23:13:37.694065+01', NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO association_objets (pk_association_objets, fk_objet_source, fk_objet_cible, fk_type_association_param, reference_precise_objet_source, url_objet_source, descriptif, notes, date_creation, date_modification, fk_qualificatif_objet_source, fk_role_objet_source, libelle_original_objet_source, valeur_objet_source, fk_unite_de_mesure) VALUES (230, 1409, 37, 19, NULL, NULL, NULL, NULL, '2015-11-11 23:13:37.694065+01', NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO association_objets (pk_association_objets, fk_objet_source, fk_objet_cible, fk_type_association_param, reference_precise_objet_source, url_objet_source, descriptif, notes, date_creation, date_modification, fk_qualificatif_objet_source, fk_role_objet_source, libelle_original_objet_source, valeur_objet_source, fk_unite_de_mesure) VALUES (231, 1408, 37, 19, NULL, NULL, NULL, NULL, '2015-11-11 23:13:37.694065+01', NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO association_objets (pk_association_objets, fk_objet_source, fk_objet_cible, fk_type_association_param, reference_precise_objet_source, url_objet_source, descriptif, notes, date_creation, date_modification, fk_qualificatif_objet_source, fk_role_objet_source, libelle_original_objet_source, valeur_objet_source, fk_unite_de_mesure) VALUES (232, 1407, 37, 19, NULL, NULL, NULL, NULL, '2015-11-11 23:13:37.694065+01', NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO association_objets (pk_association_objets, fk_objet_source, fk_objet_cible, fk_type_association_param, reference_precise_objet_source, url_objet_source, descriptif, notes, date_creation, date_modification, fk_qualificatif_objet_source, fk_role_objet_source, libelle_original_objet_source, valeur_objet_source, fk_unite_de_mesure) VALUES (233, 1406, 37, 19, NULL, NULL, NULL, NULL, '2015-11-11 23:13:37.694065+01', NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO association_objets (pk_association_objets, fk_objet_source, fk_objet_cible, fk_type_association_param, reference_precise_objet_source, url_objet_source, descriptif, notes, date_creation, date_modification, fk_qualificatif_objet_source, fk_role_objet_source, libelle_original_objet_source, valeur_objet_source, fk_unite_de_mesure) VALUES (234, 1405, 37, 19, NULL, NULL, NULL, NULL, '2015-11-11 23:13:37.694065+01', NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO association_objets (pk_association_objets, fk_objet_source, fk_objet_cible, fk_type_association_param, reference_precise_objet_source, url_objet_source, descriptif, notes, date_creation, date_modification, fk_qualificatif_objet_source, fk_role_objet_source, libelle_original_objet_source, valeur_objet_source, fk_unite_de_mesure) VALUES (235, 1404, 37, 19, NULL, NULL, NULL, NULL, '2015-11-11 23:13:37.694065+01', NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO association_objets (pk_association_objets, fk_objet_source, fk_objet_cible, fk_type_association_param, reference_precise_objet_source, url_objet_source, descriptif, notes, date_creation, date_modification, fk_qualificatif_objet_source, fk_role_objet_source, libelle_original_objet_source, valeur_objet_source, fk_unite_de_mesure) VALUES (236, 1403, 37, 19, NULL, NULL, NULL, NULL, '2015-11-11 23:13:37.694065+01', NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO association_objets (pk_association_objets, fk_objet_source, fk_objet_cible, fk_type_association_param, reference_precise_objet_source, url_objet_source, descriptif, notes, date_creation, date_modification, fk_qualificatif_objet_source, fk_role_objet_source, libelle_original_objet_source, valeur_objet_source, fk_unite_de_mesure) VALUES (237, 1402, 37, 19, NULL, NULL, NULL, NULL, '2015-11-11 23:13:37.694065+01', NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO association_objets (pk_association_objets, fk_objet_source, fk_objet_cible, fk_type_association_param, reference_precise_objet_source, url_objet_source, descriptif, notes, date_creation, date_modification, fk_qualificatif_objet_source, fk_role_objet_source, libelle_original_objet_source, valeur_objet_source, fk_unite_de_mesure) VALUES (238, 1401, 37, 19, NULL, NULL, NULL, NULL, '2015-11-11 23:13:37.694065+01', NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO association_objets (pk_association_objets, fk_objet_source, fk_objet_cible, fk_type_association_param, reference_precise_objet_source, url_objet_source, descriptif, notes, date_creation, date_modification, fk_qualificatif_objet_source, fk_role_objet_source, libelle_original_objet_source, valeur_objet_source, fk_unite_de_mesure) VALUES (239, 1400, 37, 19, NULL, NULL, NULL, NULL, '2015-11-11 23:13:37.694065+01', NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO association_objets (pk_association_objets, fk_objet_source, fk_objet_cible, fk_type_association_param, reference_precise_objet_source, url_objet_source, descriptif, notes, date_creation, date_modification, fk_qualificatif_objet_source, fk_role_objet_source, libelle_original_objet_source, valeur_objet_source, fk_unite_de_mesure) VALUES (240, 1399, 37, 19, NULL, NULL, NULL, NULL, '2015-11-11 23:13:37.694065+01', NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO association_objets (pk_association_objets, fk_objet_source, fk_objet_cible, fk_type_association_param, reference_precise_objet_source, url_objet_source, descriptif, notes, date_creation, date_modification, fk_qualificatif_objet_source, fk_role_objet_source, libelle_original_objet_source, valeur_objet_source, fk_unite_de_mesure) VALUES (241, 1398, 37, 19, NULL, NULL, NULL, NULL, '2015-11-11 23:13:37.694065+01', NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO association_objets (pk_association_objets, fk_objet_source, fk_objet_cible, fk_type_association_param, reference_precise_objet_source, url_objet_source, descriptif, notes, date_creation, date_modification, fk_qualificatif_objet_source, fk_role_objet_source, libelle_original_objet_source, valeur_objet_source, fk_unite_de_mesure) VALUES (242, 1397, 37, 19, NULL, NULL, NULL, NULL, '2015-11-11 23:13:37.694065+01', NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO association_objets (pk_association_objets, fk_objet_source, fk_objet_cible, fk_type_association_param, reference_precise_objet_source, url_objet_source, descriptif, notes, date_creation, date_modification, fk_qualificatif_objet_source, fk_role_objet_source, libelle_original_objet_source, valeur_objet_source, fk_unite_de_mesure) VALUES (243, 1396, 37, 19, NULL, NULL, NULL, NULL, '2015-11-11 23:13:37.694065+01', NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO association_objets (pk_association_objets, fk_objet_source, fk_objet_cible, fk_type_association_param, reference_precise_objet_source, url_objet_source, descriptif, notes, date_creation, date_modification, fk_qualificatif_objet_source, fk_role_objet_source, libelle_original_objet_source, valeur_objet_source, fk_unite_de_mesure) VALUES (244, 1395, 37, 19, NULL, NULL, NULL, NULL, '2015-11-11 23:13:37.694065+01', NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO association_objets (pk_association_objets, fk_objet_source, fk_objet_cible, fk_type_association_param, reference_precise_objet_source, url_objet_source, descriptif, notes, date_creation, date_modification, fk_qualificatif_objet_source, fk_role_objet_source, libelle_original_objet_source, valeur_objet_source, fk_unite_de_mesure) VALUES (245, 1394, 37, 19, NULL, NULL, NULL, NULL, '2015-11-11 23:13:37.694065+01', NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO association_objets (pk_association_objets, fk_objet_source, fk_objet_cible, fk_type_association_param, reference_precise_objet_source, url_objet_source, descriptif, notes, date_creation, date_modification, fk_qualificatif_objet_source, fk_role_objet_source, libelle_original_objet_source, valeur_objet_source, fk_unite_de_mesure) VALUES (246, 1393, 37, 19, NULL, NULL, NULL, NULL, '2015-11-11 23:13:37.694065+01', NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO association_objets (pk_association_objets, fk_objet_source, fk_objet_cible, fk_type_association_param, reference_precise_objet_source, url_objet_source, descriptif, notes, date_creation, date_modification, fk_qualificatif_objet_source, fk_role_objet_source, libelle_original_objet_source, valeur_objet_source, fk_unite_de_mesure) VALUES (247, 1392, 37, 19, NULL, NULL, NULL, NULL, '2015-11-11 23:13:37.694065+01', NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO association_objets (pk_association_objets, fk_objet_source, fk_objet_cible, fk_type_association_param, reference_precise_objet_source, url_objet_source, descriptif, notes, date_creation, date_modification, fk_qualificatif_objet_source, fk_role_objet_source, libelle_original_objet_source, valeur_objet_source, fk_unite_de_mesure) VALUES (248, 1391, 37, 19, NULL, NULL, NULL, NULL, '2015-11-11 23:13:37.694065+01', NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO association_objets (pk_association_objets, fk_objet_source, fk_objet_cible, fk_type_association_param, reference_precise_objet_source, url_objet_source, descriptif, notes, date_creation, date_modification, fk_qualificatif_objet_source, fk_role_objet_source, libelle_original_objet_source, valeur_objet_source, fk_unite_de_mesure) VALUES (249, 1390, 37, 19, NULL, NULL, NULL, NULL, '2015-11-11 23:13:37.694065+01', NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO association_objets (pk_association_objets, fk_objet_source, fk_objet_cible, fk_type_association_param, reference_precise_objet_source, url_objet_source, descriptif, notes, date_creation, date_modification, fk_qualificatif_objet_source, fk_role_objet_source, libelle_original_objet_source, valeur_objet_source, fk_unite_de_mesure) VALUES (250, 1389, 37, 19, NULL, NULL, NULL, NULL, '2015-11-11 23:13:37.694065+01', NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO association_objets (pk_association_objets, fk_objet_source, fk_objet_cible, fk_type_association_param, reference_precise_objet_source, url_objet_source, descriptif, notes, date_creation, date_modification, fk_qualificatif_objet_source, fk_role_objet_source, libelle_original_objet_source, valeur_objet_source, fk_unite_de_mesure) VALUES (251, 1388, 37, 19, NULL, NULL, NULL, NULL, '2015-11-11 23:13:37.694065+01', NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO association_objets (pk_association_objets, fk_objet_source, fk_objet_cible, fk_type_association_param, reference_precise_objet_source, url_objet_source, descriptif, notes, date_creation, date_modification, fk_qualificatif_objet_source, fk_role_objet_source, libelle_original_objet_source, valeur_objet_source, fk_unite_de_mesure) VALUES (252, 1387, 37, 19, NULL, NULL, NULL, NULL, '2015-11-11 23:13:37.694065+01', NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO association_objets (pk_association_objets, fk_objet_source, fk_objet_cible, fk_type_association_param, reference_precise_objet_source, url_objet_source, descriptif, notes, date_creation, date_modification, fk_qualificatif_objet_source, fk_role_objet_source, libelle_original_objet_source, valeur_objet_source, fk_unite_de_mesure) VALUES (253, 1386, 37, 19, NULL, NULL, NULL, NULL, '2015-11-11 23:13:37.694065+01', NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO association_objets (pk_association_objets, fk_objet_source, fk_objet_cible, fk_type_association_param, reference_precise_objet_source, url_objet_source, descriptif, notes, date_creation, date_modification, fk_qualificatif_objet_source, fk_role_objet_source, libelle_original_objet_source, valeur_objet_source, fk_unite_de_mesure) VALUES (254, 1385, 37, 19, NULL, NULL, NULL, NULL, '2015-11-11 23:13:37.694065+01', NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO association_objets (pk_association_objets, fk_objet_source, fk_objet_cible, fk_type_association_param, reference_precise_objet_source, url_objet_source, descriptif, notes, date_creation, date_modification, fk_qualificatif_objet_source, fk_role_objet_source, libelle_original_objet_source, valeur_objet_source, fk_unite_de_mesure) VALUES (255, 1384, 37, 19, NULL, NULL, NULL, NULL, '2015-11-11 23:13:37.694065+01', NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO association_objets (pk_association_objets, fk_objet_source, fk_objet_cible, fk_type_association_param, reference_precise_objet_source, url_objet_source, descriptif, notes, date_creation, date_modification, fk_qualificatif_objet_source, fk_role_objet_source, libelle_original_objet_source, valeur_objet_source, fk_unite_de_mesure) VALUES (256, 1383, 37, 19, NULL, NULL, NULL, NULL, '2015-11-11 23:13:37.694065+01', NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO association_objets (pk_association_objets, fk_objet_source, fk_objet_cible, fk_type_association_param, reference_precise_objet_source, url_objet_source, descriptif, notes, date_creation, date_modification, fk_qualificatif_objet_source, fk_role_objet_source, libelle_original_objet_source, valeur_objet_source, fk_unite_de_mesure) VALUES (257, 1382, 37, 19, NULL, NULL, NULL, NULL, '2015-11-11 23:13:37.694065+01', NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO association_objets (pk_association_objets, fk_objet_source, fk_objet_cible, fk_type_association_param, reference_precise_objet_source, url_objet_source, descriptif, notes, date_creation, date_modification, fk_qualificatif_objet_source, fk_role_objet_source, libelle_original_objet_source, valeur_objet_source, fk_unite_de_mesure) VALUES (258, 1381, 37, 19, NULL, NULL, NULL, NULL, '2015-11-11 23:13:37.694065+01', NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO association_objets (pk_association_objets, fk_objet_source, fk_objet_cible, fk_type_association_param, reference_precise_objet_source, url_objet_source, descriptif, notes, date_creation, date_modification, fk_qualificatif_objet_source, fk_role_objet_source, libelle_original_objet_source, valeur_objet_source, fk_unite_de_mesure) VALUES (259, 1380, 37, 19, NULL, NULL, NULL, NULL, '2015-11-11 23:13:37.694065+01', NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO association_objets (pk_association_objets, fk_objet_source, fk_objet_cible, fk_type_association_param, reference_precise_objet_source, url_objet_source, descriptif, notes, date_creation, date_modification, fk_qualificatif_objet_source, fk_role_objet_source, libelle_original_objet_source, valeur_objet_source, fk_unite_de_mesure) VALUES (260, 1379, 37, 19, NULL, NULL, NULL, NULL, '2015-11-11 23:13:37.694065+01', NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO association_objets (pk_association_objets, fk_objet_source, fk_objet_cible, fk_type_association_param, reference_precise_objet_source, url_objet_source, descriptif, notes, date_creation, date_modification, fk_qualificatif_objet_source, fk_role_objet_source, libelle_original_objet_source, valeur_objet_source, fk_unite_de_mesure) VALUES (261, 1378, 37, 19, NULL, NULL, NULL, NULL, '2015-11-11 23:13:37.694065+01', NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO association_objets (pk_association_objets, fk_objet_source, fk_objet_cible, fk_type_association_param, reference_precise_objet_source, url_objet_source, descriptif, notes, date_creation, date_modification, fk_qualificatif_objet_source, fk_role_objet_source, libelle_original_objet_source, valeur_objet_source, fk_unite_de_mesure) VALUES (262, 1377, 37, 19, NULL, NULL, NULL, NULL, '2015-11-11 23:13:37.694065+01', NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO association_objets (pk_association_objets, fk_objet_source, fk_objet_cible, fk_type_association_param, reference_precise_objet_source, url_objet_source, descriptif, notes, date_creation, date_modification, fk_qualificatif_objet_source, fk_role_objet_source, libelle_original_objet_source, valeur_objet_source, fk_unite_de_mesure) VALUES (263, 1376, 37, 19, NULL, NULL, NULL, NULL, '2015-11-11 23:13:37.694065+01', NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO association_objets (pk_association_objets, fk_objet_source, fk_objet_cible, fk_type_association_param, reference_precise_objet_source, url_objet_source, descriptif, notes, date_creation, date_modification, fk_qualificatif_objet_source, fk_role_objet_source, libelle_original_objet_source, valeur_objet_source, fk_unite_de_mesure) VALUES (264, 1375, 37, 19, NULL, NULL, NULL, NULL, '2015-11-11 23:13:37.694065+01', NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO association_objets (pk_association_objets, fk_objet_source, fk_objet_cible, fk_type_association_param, reference_precise_objet_source, url_objet_source, descriptif, notes, date_creation, date_modification, fk_qualificatif_objet_source, fk_role_objet_source, libelle_original_objet_source, valeur_objet_source, fk_unite_de_mesure) VALUES (265, 1374, 37, 19, NULL, NULL, NULL, NULL, '2015-11-11 23:13:37.694065+01', NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO association_objets (pk_association_objets, fk_objet_source, fk_objet_cible, fk_type_association_param, reference_precise_objet_source, url_objet_source, descriptif, notes, date_creation, date_modification, fk_qualificatif_objet_source, fk_role_objet_source, libelle_original_objet_source, valeur_objet_source, fk_unite_de_mesure) VALUES (266, 1373, 37, 19, NULL, NULL, NULL, NULL, '2015-11-11 23:13:37.694065+01', NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO association_objets (pk_association_objets, fk_objet_source, fk_objet_cible, fk_type_association_param, reference_precise_objet_source, url_objet_source, descriptif, notes, date_creation, date_modification, fk_qualificatif_objet_source, fk_role_objet_source, libelle_original_objet_source, valeur_objet_source, fk_unite_de_mesure) VALUES (267, 1372, 37, 19, NULL, NULL, NULL, NULL, '2015-11-11 23:13:37.694065+01', NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO association_objets (pk_association_objets, fk_objet_source, fk_objet_cible, fk_type_association_param, reference_precise_objet_source, url_objet_source, descriptif, notes, date_creation, date_modification, fk_qualificatif_objet_source, fk_role_objet_source, libelle_original_objet_source, valeur_objet_source, fk_unite_de_mesure) VALUES (268, 1371, 37, 19, NULL, NULL, NULL, NULL, '2015-11-11 23:13:37.694065+01', NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO association_objets (pk_association_objets, fk_objet_source, fk_objet_cible, fk_type_association_param, reference_precise_objet_source, url_objet_source, descriptif, notes, date_creation, date_modification, fk_qualificatif_objet_source, fk_role_objet_source, libelle_original_objet_source, valeur_objet_source, fk_unite_de_mesure) VALUES (269, 1370, 37, 19, NULL, NULL, NULL, NULL, '2015-11-11 23:13:37.694065+01', NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO association_objets (pk_association_objets, fk_objet_source, fk_objet_cible, fk_type_association_param, reference_precise_objet_source, url_objet_source, descriptif, notes, date_creation, date_modification, fk_qualificatif_objet_source, fk_role_objet_source, libelle_original_objet_source, valeur_objet_source, fk_unite_de_mesure) VALUES (270, 1369, 37, 19, NULL, NULL, NULL, NULL, '2015-11-11 23:13:37.694065+01', NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO association_objets (pk_association_objets, fk_objet_source, fk_objet_cible, fk_type_association_param, reference_precise_objet_source, url_objet_source, descriptif, notes, date_creation, date_modification, fk_qualificatif_objet_source, fk_role_objet_source, libelle_original_objet_source, valeur_objet_source, fk_unite_de_mesure) VALUES (271, 1368, 37, 19, NULL, NULL, NULL, NULL, '2015-11-11 23:13:37.694065+01', NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO association_objets (pk_association_objets, fk_objet_source, fk_objet_cible, fk_type_association_param, reference_precise_objet_source, url_objet_source, descriptif, notes, date_creation, date_modification, fk_qualificatif_objet_source, fk_role_objet_source, libelle_original_objet_source, valeur_objet_source, fk_unite_de_mesure) VALUES (272, 1367, 37, 19, NULL, NULL, NULL, NULL, '2015-11-11 23:13:37.694065+01', NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO association_objets (pk_association_objets, fk_objet_source, fk_objet_cible, fk_type_association_param, reference_precise_objet_source, url_objet_source, descriptif, notes, date_creation, date_modification, fk_qualificatif_objet_source, fk_role_objet_source, libelle_original_objet_source, valeur_objet_source, fk_unite_de_mesure) VALUES (273, 1366, 37, 19, NULL, NULL, NULL, NULL, '2015-11-11 23:13:37.694065+01', NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO association_objets (pk_association_objets, fk_objet_source, fk_objet_cible, fk_type_association_param, reference_precise_objet_source, url_objet_source, descriptif, notes, date_creation, date_modification, fk_qualificatif_objet_source, fk_role_objet_source, libelle_original_objet_source, valeur_objet_source, fk_unite_de_mesure) VALUES (274, 1365, 37, 19, NULL, NULL, NULL, NULL, '2015-11-11 23:13:37.694065+01', NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO association_objets (pk_association_objets, fk_objet_source, fk_objet_cible, fk_type_association_param, reference_precise_objet_source, url_objet_source, descriptif, notes, date_creation, date_modification, fk_qualificatif_objet_source, fk_role_objet_source, libelle_original_objet_source, valeur_objet_source, fk_unite_de_mesure) VALUES (275, 1364, 37, 19, NULL, NULL, NULL, NULL, '2015-11-11 23:13:37.694065+01', NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO association_objets (pk_association_objets, fk_objet_source, fk_objet_cible, fk_type_association_param, reference_precise_objet_source, url_objet_source, descriptif, notes, date_creation, date_modification, fk_qualificatif_objet_source, fk_role_objet_source, libelle_original_objet_source, valeur_objet_source, fk_unite_de_mesure) VALUES (276, 1363, 37, 19, NULL, NULL, NULL, NULL, '2015-11-11 23:13:37.694065+01', NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO association_objets (pk_association_objets, fk_objet_source, fk_objet_cible, fk_type_association_param, reference_precise_objet_source, url_objet_source, descriptif, notes, date_creation, date_modification, fk_qualificatif_objet_source, fk_role_objet_source, libelle_original_objet_source, valeur_objet_source, fk_unite_de_mesure) VALUES (277, 1362, 37, 19, NULL, NULL, NULL, NULL, '2015-11-11 23:13:37.694065+01', NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO association_objets (pk_association_objets, fk_objet_source, fk_objet_cible, fk_type_association_param, reference_precise_objet_source, url_objet_source, descriptif, notes, date_creation, date_modification, fk_qualificatif_objet_source, fk_role_objet_source, libelle_original_objet_source, valeur_objet_source, fk_unite_de_mesure) VALUES (278, 1361, 37, 19, NULL, NULL, NULL, NULL, '2015-11-11 23:13:37.694065+01', NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO association_objets (pk_association_objets, fk_objet_source, fk_objet_cible, fk_type_association_param, reference_precise_objet_source, url_objet_source, descriptif, notes, date_creation, date_modification, fk_qualificatif_objet_source, fk_role_objet_source, libelle_original_objet_source, valeur_objet_source, fk_unite_de_mesure) VALUES (279, 1360, 37, 19, NULL, NULL, NULL, NULL, '2015-11-11 23:13:37.694065+01', NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO association_objets (pk_association_objets, fk_objet_source, fk_objet_cible, fk_type_association_param, reference_precise_objet_source, url_objet_source, descriptif, notes, date_creation, date_modification, fk_qualificatif_objet_source, fk_role_objet_source, libelle_original_objet_source, valeur_objet_source, fk_unite_de_mesure) VALUES (280, 1359, 37, 19, NULL, NULL, NULL, NULL, '2015-11-11 23:13:37.694065+01', NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO association_objets (pk_association_objets, fk_objet_source, fk_objet_cible, fk_type_association_param, reference_precise_objet_source, url_objet_source, descriptif, notes, date_creation, date_modification, fk_qualificatif_objet_source, fk_role_objet_source, libelle_original_objet_source, valeur_objet_source, fk_unite_de_mesure) VALUES (281, 1358, 37, 19, NULL, NULL, NULL, NULL, '2015-11-11 23:13:37.694065+01', NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO association_objets (pk_association_objets, fk_objet_source, fk_objet_cible, fk_type_association_param, reference_precise_objet_source, url_objet_source, descriptif, notes, date_creation, date_modification, fk_qualificatif_objet_source, fk_role_objet_source, libelle_original_objet_source, valeur_objet_source, fk_unite_de_mesure) VALUES (282, 1357, 37, 19, NULL, NULL, NULL, NULL, '2015-11-11 23:13:37.694065+01', NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO association_objets (pk_association_objets, fk_objet_source, fk_objet_cible, fk_type_association_param, reference_precise_objet_source, url_objet_source, descriptif, notes, date_creation, date_modification, fk_qualificatif_objet_source, fk_role_objet_source, libelle_original_objet_source, valeur_objet_source, fk_unite_de_mesure) VALUES (283, 1356, 37, 19, NULL, NULL, NULL, NULL, '2015-11-11 23:13:37.694065+01', NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO association_objets (pk_association_objets, fk_objet_source, fk_objet_cible, fk_type_association_param, reference_precise_objet_source, url_objet_source, descriptif, notes, date_creation, date_modification, fk_qualificatif_objet_source, fk_role_objet_source, libelle_original_objet_source, valeur_objet_source, fk_unite_de_mesure) VALUES (284, 1355, 37, 19, NULL, NULL, NULL, NULL, '2015-11-11 23:13:37.694065+01', NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO association_objets (pk_association_objets, fk_objet_source, fk_objet_cible, fk_type_association_param, reference_precise_objet_source, url_objet_source, descriptif, notes, date_creation, date_modification, fk_qualificatif_objet_source, fk_role_objet_source, libelle_original_objet_source, valeur_objet_source, fk_unite_de_mesure) VALUES (285, 1354, 37, 19, NULL, NULL, NULL, NULL, '2015-11-11 23:13:37.694065+01', NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO association_objets (pk_association_objets, fk_objet_source, fk_objet_cible, fk_type_association_param, reference_precise_objet_source, url_objet_source, descriptif, notes, date_creation, date_modification, fk_qualificatif_objet_source, fk_role_objet_source, libelle_original_objet_source, valeur_objet_source, fk_unite_de_mesure) VALUES (286, 1353, 37, 19, NULL, NULL, NULL, NULL, '2015-11-11 23:13:37.694065+01', NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO association_objets (pk_association_objets, fk_objet_source, fk_objet_cible, fk_type_association_param, reference_precise_objet_source, url_objet_source, descriptif, notes, date_creation, date_modification, fk_qualificatif_objet_source, fk_role_objet_source, libelle_original_objet_source, valeur_objet_source, fk_unite_de_mesure) VALUES (287, 1352, 37, 19, NULL, NULL, NULL, NULL, '2015-11-11 23:13:37.694065+01', NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO association_objets (pk_association_objets, fk_objet_source, fk_objet_cible, fk_type_association_param, reference_precise_objet_source, url_objet_source, descriptif, notes, date_creation, date_modification, fk_qualificatif_objet_source, fk_role_objet_source, libelle_original_objet_source, valeur_objet_source, fk_unite_de_mesure) VALUES (288, 1351, 37, 19, NULL, NULL, NULL, NULL, '2015-11-11 23:13:37.694065+01', NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO association_objets (pk_association_objets, fk_objet_source, fk_objet_cible, fk_type_association_param, reference_precise_objet_source, url_objet_source, descriptif, notes, date_creation, date_modification, fk_qualificatif_objet_source, fk_role_objet_source, libelle_original_objet_source, valeur_objet_source, fk_unite_de_mesure) VALUES (289, 1350, 37, 19, NULL, NULL, NULL, NULL, '2015-11-11 23:13:37.694065+01', NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO association_objets (pk_association_objets, fk_objet_source, fk_objet_cible, fk_type_association_param, reference_precise_objet_source, url_objet_source, descriptif, notes, date_creation, date_modification, fk_qualificatif_objet_source, fk_role_objet_source, libelle_original_objet_source, valeur_objet_source, fk_unite_de_mesure) VALUES (290, 1349, 37, 19, NULL, NULL, NULL, NULL, '2015-11-11 23:13:37.694065+01', NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO association_objets (pk_association_objets, fk_objet_source, fk_objet_cible, fk_type_association_param, reference_precise_objet_source, url_objet_source, descriptif, notes, date_creation, date_modification, fk_qualificatif_objet_source, fk_role_objet_source, libelle_original_objet_source, valeur_objet_source, fk_unite_de_mesure) VALUES (291, 1348, 37, 19, NULL, NULL, NULL, NULL, '2015-11-11 23:13:37.694065+01', NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO association_objets (pk_association_objets, fk_objet_source, fk_objet_cible, fk_type_association_param, reference_precise_objet_source, url_objet_source, descriptif, notes, date_creation, date_modification, fk_qualificatif_objet_source, fk_role_objet_source, libelle_original_objet_source, valeur_objet_source, fk_unite_de_mesure) VALUES (292, 1347, 37, 19, NULL, NULL, NULL, NULL, '2015-11-11 23:13:37.694065+01', NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO association_objets (pk_association_objets, fk_objet_source, fk_objet_cible, fk_type_association_param, reference_precise_objet_source, url_objet_source, descriptif, notes, date_creation, date_modification, fk_qualificatif_objet_source, fk_role_objet_source, libelle_original_objet_source, valeur_objet_source, fk_unite_de_mesure) VALUES (293, 1346, 37, 19, NULL, NULL, NULL, NULL, '2015-11-11 23:13:37.694065+01', NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO association_objets (pk_association_objets, fk_objet_source, fk_objet_cible, fk_type_association_param, reference_precise_objet_source, url_objet_source, descriptif, notes, date_creation, date_modification, fk_qualificatif_objet_source, fk_role_objet_source, libelle_original_objet_source, valeur_objet_source, fk_unite_de_mesure) VALUES (294, 1345, 37, 19, NULL, NULL, NULL, NULL, '2015-11-11 23:13:37.694065+01', NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO association_objets (pk_association_objets, fk_objet_source, fk_objet_cible, fk_type_association_param, reference_precise_objet_source, url_objet_source, descriptif, notes, date_creation, date_modification, fk_qualificatif_objet_source, fk_role_objet_source, libelle_original_objet_source, valeur_objet_source, fk_unite_de_mesure) VALUES (295, 1344, 37, 19, NULL, NULL, NULL, NULL, '2015-11-11 23:13:37.694065+01', NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO association_objets (pk_association_objets, fk_objet_source, fk_objet_cible, fk_type_association_param, reference_precise_objet_source, url_objet_source, descriptif, notes, date_creation, date_modification, fk_qualificatif_objet_source, fk_role_objet_source, libelle_original_objet_source, valeur_objet_source, fk_unite_de_mesure) VALUES (296, 1343, 37, 19, NULL, NULL, NULL, NULL, '2015-11-11 23:13:37.694065+01', NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO association_objets (pk_association_objets, fk_objet_source, fk_objet_cible, fk_type_association_param, reference_precise_objet_source, url_objet_source, descriptif, notes, date_creation, date_modification, fk_qualificatif_objet_source, fk_role_objet_source, libelle_original_objet_source, valeur_objet_source, fk_unite_de_mesure) VALUES (297, 1342, 37, 19, NULL, NULL, NULL, NULL, '2015-11-11 23:13:37.694065+01', NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO association_objets (pk_association_objets, fk_objet_source, fk_objet_cible, fk_type_association_param, reference_precise_objet_source, url_objet_source, descriptif, notes, date_creation, date_modification, fk_qualificatif_objet_source, fk_role_objet_source, libelle_original_objet_source, valeur_objet_source, fk_unite_de_mesure) VALUES (298, 1341, 37, 19, NULL, NULL, NULL, NULL, '2015-11-11 23:13:37.694065+01', NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO association_objets (pk_association_objets, fk_objet_source, fk_objet_cible, fk_type_association_param, reference_precise_objet_source, url_objet_source, descriptif, notes, date_creation, date_modification, fk_qualificatif_objet_source, fk_role_objet_source, libelle_original_objet_source, valeur_objet_source, fk_unite_de_mesure) VALUES (299, 1340, 37, 19, NULL, NULL, NULL, NULL, '2015-11-11 23:13:37.694065+01', NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO association_objets (pk_association_objets, fk_objet_source, fk_objet_cible, fk_type_association_param, reference_precise_objet_source, url_objet_source, descriptif, notes, date_creation, date_modification, fk_qualificatif_objet_source, fk_role_objet_source, libelle_original_objet_source, valeur_objet_source, fk_unite_de_mesure) VALUES (300, 1339, 37, 19, NULL, NULL, NULL, NULL, '2015-11-11 23:13:37.694065+01', NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO association_objets (pk_association_objets, fk_objet_source, fk_objet_cible, fk_type_association_param, reference_precise_objet_source, url_objet_source, descriptif, notes, date_creation, date_modification, fk_qualificatif_objet_source, fk_role_objet_source, libelle_original_objet_source, valeur_objet_source, fk_unite_de_mesure) VALUES (301, 1338, 37, 19, NULL, NULL, NULL, NULL, '2015-11-11 23:13:37.694065+01', NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO association_objets (pk_association_objets, fk_objet_source, fk_objet_cible, fk_type_association_param, reference_precise_objet_source, url_objet_source, descriptif, notes, date_creation, date_modification, fk_qualificatif_objet_source, fk_role_objet_source, libelle_original_objet_source, valeur_objet_source, fk_unite_de_mesure) VALUES (302, 1337, 37, 19, NULL, NULL, NULL, NULL, '2015-11-11 23:13:37.694065+01', NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO association_objets (pk_association_objets, fk_objet_source, fk_objet_cible, fk_type_association_param, reference_precise_objet_source, url_objet_source, descriptif, notes, date_creation, date_modification, fk_qualificatif_objet_source, fk_role_objet_source, libelle_original_objet_source, valeur_objet_source, fk_unite_de_mesure) VALUES (303, 1336, 37, 19, NULL, NULL, NULL, NULL, '2015-11-11 23:13:37.694065+01', NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO association_objets (pk_association_objets, fk_objet_source, fk_objet_cible, fk_type_association_param, reference_precise_objet_source, url_objet_source, descriptif, notes, date_creation, date_modification, fk_qualificatif_objet_source, fk_role_objet_source, libelle_original_objet_source, valeur_objet_source, fk_unite_de_mesure) VALUES (304, 1335, 37, 19, NULL, NULL, NULL, NULL, '2015-11-11 23:13:37.694065+01', NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO association_objets (pk_association_objets, fk_objet_source, fk_objet_cible, fk_type_association_param, reference_precise_objet_source, url_objet_source, descriptif, notes, date_creation, date_modification, fk_qualificatif_objet_source, fk_role_objet_source, libelle_original_objet_source, valeur_objet_source, fk_unite_de_mesure) VALUES (305, 1334, 37, 19, NULL, NULL, NULL, NULL, '2015-11-11 23:13:37.694065+01', NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO association_objets (pk_association_objets, fk_objet_source, fk_objet_cible, fk_type_association_param, reference_precise_objet_source, url_objet_source, descriptif, notes, date_creation, date_modification, fk_qualificatif_objet_source, fk_role_objet_source, libelle_original_objet_source, valeur_objet_source, fk_unite_de_mesure) VALUES (306, 1333, 37, 19, NULL, NULL, NULL, NULL, '2015-11-11 23:13:37.694065+01', NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO association_objets (pk_association_objets, fk_objet_source, fk_objet_cible, fk_type_association_param, reference_precise_objet_source, url_objet_source, descriptif, notes, date_creation, date_modification, fk_qualificatif_objet_source, fk_role_objet_source, libelle_original_objet_source, valeur_objet_source, fk_unite_de_mesure) VALUES (307, 1332, 37, 19, NULL, NULL, NULL, NULL, '2015-11-11 23:13:37.694065+01', NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO association_objets (pk_association_objets, fk_objet_source, fk_objet_cible, fk_type_association_param, reference_precise_objet_source, url_objet_source, descriptif, notes, date_creation, date_modification, fk_qualificatif_objet_source, fk_role_objet_source, libelle_original_objet_source, valeur_objet_source, fk_unite_de_mesure) VALUES (308, 1331, 37, 19, NULL, NULL, NULL, NULL, '2015-11-11 23:13:37.694065+01', NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO association_objets (pk_association_objets, fk_objet_source, fk_objet_cible, fk_type_association_param, reference_precise_objet_source, url_objet_source, descriptif, notes, date_creation, date_modification, fk_qualificatif_objet_source, fk_role_objet_source, libelle_original_objet_source, valeur_objet_source, fk_unite_de_mesure) VALUES (309, 1330, 37, 19, NULL, NULL, NULL, NULL, '2015-11-11 23:13:37.694065+01', NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO association_objets (pk_association_objets, fk_objet_source, fk_objet_cible, fk_type_association_param, reference_precise_objet_source, url_objet_source, descriptif, notes, date_creation, date_modification, fk_qualificatif_objet_source, fk_role_objet_source, libelle_original_objet_source, valeur_objet_source, fk_unite_de_mesure) VALUES (310, 1329, 37, 19, NULL, NULL, NULL, NULL, '2015-11-11 23:13:37.694065+01', NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO association_objets (pk_association_objets, fk_objet_source, fk_objet_cible, fk_type_association_param, reference_precise_objet_source, url_objet_source, descriptif, notes, date_creation, date_modification, fk_qualificatif_objet_source, fk_role_objet_source, libelle_original_objet_source, valeur_objet_source, fk_unite_de_mesure) VALUES (311, 1328, 37, 19, NULL, NULL, NULL, NULL, '2015-11-11 23:13:37.694065+01', NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO association_objets (pk_association_objets, fk_objet_source, fk_objet_cible, fk_type_association_param, reference_precise_objet_source, url_objet_source, descriptif, notes, date_creation, date_modification, fk_qualificatif_objet_source, fk_role_objet_source, libelle_original_objet_source, valeur_objet_source, fk_unite_de_mesure) VALUES (312, 1327, 37, 19, NULL, NULL, NULL, NULL, '2015-11-11 23:13:37.694065+01', NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO association_objets (pk_association_objets, fk_objet_source, fk_objet_cible, fk_type_association_param, reference_precise_objet_source, url_objet_source, descriptif, notes, date_creation, date_modification, fk_qualificatif_objet_source, fk_role_objet_source, libelle_original_objet_source, valeur_objet_source, fk_unite_de_mesure) VALUES (313, 1326, 37, 19, NULL, NULL, NULL, NULL, '2015-11-11 23:13:37.694065+01', NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO association_objets (pk_association_objets, fk_objet_source, fk_objet_cible, fk_type_association_param, reference_precise_objet_source, url_objet_source, descriptif, notes, date_creation, date_modification, fk_qualificatif_objet_source, fk_role_objet_source, libelle_original_objet_source, valeur_objet_source, fk_unite_de_mesure) VALUES (314, 1325, 37, 19, NULL, NULL, NULL, NULL, '2015-11-11 23:13:37.694065+01', NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO association_objets (pk_association_objets, fk_objet_source, fk_objet_cible, fk_type_association_param, reference_precise_objet_source, url_objet_source, descriptif, notes, date_creation, date_modification, fk_qualificatif_objet_source, fk_role_objet_source, libelle_original_objet_source, valeur_objet_source, fk_unite_de_mesure) VALUES (315, 1324, 37, 19, NULL, NULL, NULL, NULL, '2015-11-11 23:13:37.694065+01', NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO association_objets (pk_association_objets, fk_objet_source, fk_objet_cible, fk_type_association_param, reference_precise_objet_source, url_objet_source, descriptif, notes, date_creation, date_modification, fk_qualificatif_objet_source, fk_role_objet_source, libelle_original_objet_source, valeur_objet_source, fk_unite_de_mesure) VALUES (316, 1323, 37, 19, NULL, NULL, NULL, NULL, '2015-11-11 23:13:37.694065+01', NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO association_objets (pk_association_objets, fk_objet_source, fk_objet_cible, fk_type_association_param, reference_precise_objet_source, url_objet_source, descriptif, notes, date_creation, date_modification, fk_qualificatif_objet_source, fk_role_objet_source, libelle_original_objet_source, valeur_objet_source, fk_unite_de_mesure) VALUES (317, 1322, 37, 19, NULL, NULL, NULL, NULL, '2015-11-11 23:13:37.694065+01', NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO association_objets (pk_association_objets, fk_objet_source, fk_objet_cible, fk_type_association_param, reference_precise_objet_source, url_objet_source, descriptif, notes, date_creation, date_modification, fk_qualificatif_objet_source, fk_role_objet_source, libelle_original_objet_source, valeur_objet_source, fk_unite_de_mesure) VALUES (318, 1321, 37, 19, NULL, NULL, NULL, NULL, '2015-11-11 23:13:37.694065+01', NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO association_objets (pk_association_objets, fk_objet_source, fk_objet_cible, fk_type_association_param, reference_precise_objet_source, url_objet_source, descriptif, notes, date_creation, date_modification, fk_qualificatif_objet_source, fk_role_objet_source, libelle_original_objet_source, valeur_objet_source, fk_unite_de_mesure) VALUES (319, 1320, 37, 19, NULL, NULL, NULL, NULL, '2015-11-11 23:13:37.694065+01', NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO association_objets (pk_association_objets, fk_objet_source, fk_objet_cible, fk_type_association_param, reference_precise_objet_source, url_objet_source, descriptif, notes, date_creation, date_modification, fk_qualificatif_objet_source, fk_role_objet_source, libelle_original_objet_source, valeur_objet_source, fk_unite_de_mesure) VALUES (320, 1319, 37, 19, NULL, NULL, NULL, NULL, '2015-11-11 23:13:37.694065+01', NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO association_objets (pk_association_objets, fk_objet_source, fk_objet_cible, fk_type_association_param, reference_precise_objet_source, url_objet_source, descriptif, notes, date_creation, date_modification, fk_qualificatif_objet_source, fk_role_objet_source, libelle_original_objet_source, valeur_objet_source, fk_unite_de_mesure) VALUES (321, 1318, 37, 19, NULL, NULL, NULL, NULL, '2015-11-11 23:13:37.694065+01', NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO association_objets (pk_association_objets, fk_objet_source, fk_objet_cible, fk_type_association_param, reference_precise_objet_source, url_objet_source, descriptif, notes, date_creation, date_modification, fk_qualificatif_objet_source, fk_role_objet_source, libelle_original_objet_source, valeur_objet_source, fk_unite_de_mesure) VALUES (322, 1317, 37, 19, NULL, NULL, NULL, NULL, '2015-11-11 23:13:37.694065+01', NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO association_objets (pk_association_objets, fk_objet_source, fk_objet_cible, fk_type_association_param, reference_precise_objet_source, url_objet_source, descriptif, notes, date_creation, date_modification, fk_qualificatif_objet_source, fk_role_objet_source, libelle_original_objet_source, valeur_objet_source, fk_unite_de_mesure) VALUES (323, 1316, 37, 19, NULL, NULL, NULL, NULL, '2015-11-11 23:13:37.694065+01', NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO association_objets (pk_association_objets, fk_objet_source, fk_objet_cible, fk_type_association_param, reference_precise_objet_source, url_objet_source, descriptif, notes, date_creation, date_modification, fk_qualificatif_objet_source, fk_role_objet_source, libelle_original_objet_source, valeur_objet_source, fk_unite_de_mesure) VALUES (324, 1315, 37, 19, NULL, NULL, NULL, NULL, '2015-11-11 23:13:37.694065+01', NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO association_objets (pk_association_objets, fk_objet_source, fk_objet_cible, fk_type_association_param, reference_precise_objet_source, url_objet_source, descriptif, notes, date_creation, date_modification, fk_qualificatif_objet_source, fk_role_objet_source, libelle_original_objet_source, valeur_objet_source, fk_unite_de_mesure) VALUES (325, 1314, 37, 19, NULL, NULL, NULL, NULL, '2015-11-11 23:13:37.694065+01', NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO association_objets (pk_association_objets, fk_objet_source, fk_objet_cible, fk_type_association_param, reference_precise_objet_source, url_objet_source, descriptif, notes, date_creation, date_modification, fk_qualificatif_objet_source, fk_role_objet_source, libelle_original_objet_source, valeur_objet_source, fk_unite_de_mesure) VALUES (326, 1313, 37, 19, NULL, NULL, NULL, NULL, '2015-11-11 23:13:37.694065+01', NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO association_objets (pk_association_objets, fk_objet_source, fk_objet_cible, fk_type_association_param, reference_precise_objet_source, url_objet_source, descriptif, notes, date_creation, date_modification, fk_qualificatif_objet_source, fk_role_objet_source, libelle_original_objet_source, valeur_objet_source, fk_unite_de_mesure) VALUES (327, 1312, 37, 19, NULL, NULL, NULL, NULL, '2015-11-11 23:13:37.694065+01', NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO association_objets (pk_association_objets, fk_objet_source, fk_objet_cible, fk_type_association_param, reference_precise_objet_source, url_objet_source, descriptif, notes, date_creation, date_modification, fk_qualificatif_objet_source, fk_role_objet_source, libelle_original_objet_source, valeur_objet_source, fk_unite_de_mesure) VALUES (328, 1311, 37, 19, NULL, NULL, NULL, NULL, '2015-11-11 23:13:37.694065+01', NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO association_objets (pk_association_objets, fk_objet_source, fk_objet_cible, fk_type_association_param, reference_precise_objet_source, url_objet_source, descriptif, notes, date_creation, date_modification, fk_qualificatif_objet_source, fk_role_objet_source, libelle_original_objet_source, valeur_objet_source, fk_unite_de_mesure) VALUES (329, 1310, 37, 19, NULL, NULL, NULL, NULL, '2015-11-11 23:13:37.694065+01', NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO association_objets (pk_association_objets, fk_objet_source, fk_objet_cible, fk_type_association_param, reference_precise_objet_source, url_objet_source, descriptif, notes, date_creation, date_modification, fk_qualificatif_objet_source, fk_role_objet_source, libelle_original_objet_source, valeur_objet_source, fk_unite_de_mesure) VALUES (330, 1309, 37, 19, NULL, NULL, NULL, NULL, '2015-11-11 23:13:37.694065+01', NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO association_objets (pk_association_objets, fk_objet_source, fk_objet_cible, fk_type_association_param, reference_precise_objet_source, url_objet_source, descriptif, notes, date_creation, date_modification, fk_qualificatif_objet_source, fk_role_objet_source, libelle_original_objet_source, valeur_objet_source, fk_unite_de_mesure) VALUES (331, 1308, 37, 19, NULL, NULL, NULL, NULL, '2015-11-11 23:13:37.694065+01', NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO association_objets (pk_association_objets, fk_objet_source, fk_objet_cible, fk_type_association_param, reference_precise_objet_source, url_objet_source, descriptif, notes, date_creation, date_modification, fk_qualificatif_objet_source, fk_role_objet_source, libelle_original_objet_source, valeur_objet_source, fk_unite_de_mesure) VALUES (332, 1307, 37, 19, NULL, NULL, NULL, NULL, '2015-11-11 23:13:37.694065+01', NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO association_objets (pk_association_objets, fk_objet_source, fk_objet_cible, fk_type_association_param, reference_precise_objet_source, url_objet_source, descriptif, notes, date_creation, date_modification, fk_qualificatif_objet_source, fk_role_objet_source, libelle_original_objet_source, valeur_objet_source, fk_unite_de_mesure) VALUES (333, 1306, 37, 19, NULL, NULL, NULL, NULL, '2015-11-11 23:13:37.694065+01', NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO association_objets (pk_association_objets, fk_objet_source, fk_objet_cible, fk_type_association_param, reference_precise_objet_source, url_objet_source, descriptif, notes, date_creation, date_modification, fk_qualificatif_objet_source, fk_role_objet_source, libelle_original_objet_source, valeur_objet_source, fk_unite_de_mesure) VALUES (334, 1305, 37, 19, NULL, NULL, NULL, NULL, '2015-11-11 23:13:37.694065+01', NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO association_objets (pk_association_objets, fk_objet_source, fk_objet_cible, fk_type_association_param, reference_precise_objet_source, url_objet_source, descriptif, notes, date_creation, date_modification, fk_qualificatif_objet_source, fk_role_objet_source, libelle_original_objet_source, valeur_objet_source, fk_unite_de_mesure) VALUES (335, 1304, 37, 19, NULL, NULL, NULL, NULL, '2015-11-11 23:13:37.694065+01', NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO association_objets (pk_association_objets, fk_objet_source, fk_objet_cible, fk_type_association_param, reference_precise_objet_source, url_objet_source, descriptif, notes, date_creation, date_modification, fk_qualificatif_objet_source, fk_role_objet_source, libelle_original_objet_source, valeur_objet_source, fk_unite_de_mesure) VALUES (336, 1303, 37, 19, NULL, NULL, NULL, NULL, '2015-11-11 23:13:37.694065+01', NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO association_objets (pk_association_objets, fk_objet_source, fk_objet_cible, fk_type_association_param, reference_precise_objet_source, url_objet_source, descriptif, notes, date_creation, date_modification, fk_qualificatif_objet_source, fk_role_objet_source, libelle_original_objet_source, valeur_objet_source, fk_unite_de_mesure) VALUES (337, 1302, 37, 19, NULL, NULL, NULL, NULL, '2015-11-11 23:13:37.694065+01', NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO association_objets (pk_association_objets, fk_objet_source, fk_objet_cible, fk_type_association_param, reference_precise_objet_source, url_objet_source, descriptif, notes, date_creation, date_modification, fk_qualificatif_objet_source, fk_role_objet_source, libelle_original_objet_source, valeur_objet_source, fk_unite_de_mesure) VALUES (338, 1301, 37, 19, NULL, NULL, NULL, NULL, '2015-11-11 23:13:37.694065+01', NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO association_objets (pk_association_objets, fk_objet_source, fk_objet_cible, fk_type_association_param, reference_precise_objet_source, url_objet_source, descriptif, notes, date_creation, date_modification, fk_qualificatif_objet_source, fk_role_objet_source, libelle_original_objet_source, valeur_objet_source, fk_unite_de_mesure) VALUES (339, 1300, 37, 19, NULL, NULL, NULL, NULL, '2015-11-11 23:13:37.694065+01', NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO association_objets (pk_association_objets, fk_objet_source, fk_objet_cible, fk_type_association_param, reference_precise_objet_source, url_objet_source, descriptif, notes, date_creation, date_modification, fk_qualificatif_objet_source, fk_role_objet_source, libelle_original_objet_source, valeur_objet_source, fk_unite_de_mesure) VALUES (340, 1299, 37, 19, NULL, NULL, NULL, NULL, '2015-11-11 23:13:37.694065+01', NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO association_objets (pk_association_objets, fk_objet_source, fk_objet_cible, fk_type_association_param, reference_precise_objet_source, url_objet_source, descriptif, notes, date_creation, date_modification, fk_qualificatif_objet_source, fk_role_objet_source, libelle_original_objet_source, valeur_objet_source, fk_unite_de_mesure) VALUES (341, 1298, 37, 19, NULL, NULL, NULL, NULL, '2015-11-11 23:13:37.694065+01', NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO association_objets (pk_association_objets, fk_objet_source, fk_objet_cible, fk_type_association_param, reference_precise_objet_source, url_objet_source, descriptif, notes, date_creation, date_modification, fk_qualificatif_objet_source, fk_role_objet_source, libelle_original_objet_source, valeur_objet_source, fk_unite_de_mesure) VALUES (342, 1297, 37, 19, NULL, NULL, NULL, NULL, '2015-11-11 23:13:37.694065+01', NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO association_objets (pk_association_objets, fk_objet_source, fk_objet_cible, fk_type_association_param, reference_precise_objet_source, url_objet_source, descriptif, notes, date_creation, date_modification, fk_qualificatif_objet_source, fk_role_objet_source, libelle_original_objet_source, valeur_objet_source, fk_unite_de_mesure) VALUES (343, 1296, 37, 19, NULL, NULL, NULL, NULL, '2015-11-11 23:13:37.694065+01', NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO association_objets (pk_association_objets, fk_objet_source, fk_objet_cible, fk_type_association_param, reference_precise_objet_source, url_objet_source, descriptif, notes, date_creation, date_modification, fk_qualificatif_objet_source, fk_role_objet_source, libelle_original_objet_source, valeur_objet_source, fk_unite_de_mesure) VALUES (344, 1295, 37, 19, NULL, NULL, NULL, NULL, '2015-11-11 23:13:37.694065+01', NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO association_objets (pk_association_objets, fk_objet_source, fk_objet_cible, fk_type_association_param, reference_precise_objet_source, url_objet_source, descriptif, notes, date_creation, date_modification, fk_qualificatif_objet_source, fk_role_objet_source, libelle_original_objet_source, valeur_objet_source, fk_unite_de_mesure) VALUES (345, 1294, 37, 19, NULL, NULL, NULL, NULL, '2015-11-11 23:13:37.694065+01', NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO association_objets (pk_association_objets, fk_objet_source, fk_objet_cible, fk_type_association_param, reference_precise_objet_source, url_objet_source, descriptif, notes, date_creation, date_modification, fk_qualificatif_objet_source, fk_role_objet_source, libelle_original_objet_source, valeur_objet_source, fk_unite_de_mesure) VALUES (346, 1293, 37, 19, NULL, NULL, NULL, NULL, '2015-11-11 23:13:37.694065+01', NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO association_objets (pk_association_objets, fk_objet_source, fk_objet_cible, fk_type_association_param, reference_precise_objet_source, url_objet_source, descriptif, notes, date_creation, date_modification, fk_qualificatif_objet_source, fk_role_objet_source, libelle_original_objet_source, valeur_objet_source, fk_unite_de_mesure) VALUES (347, 1292, 37, 19, NULL, NULL, NULL, NULL, '2015-11-11 23:13:37.694065+01', NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO association_objets (pk_association_objets, fk_objet_source, fk_objet_cible, fk_type_association_param, reference_precise_objet_source, url_objet_source, descriptif, notes, date_creation, date_modification, fk_qualificatif_objet_source, fk_role_objet_source, libelle_original_objet_source, valeur_objet_source, fk_unite_de_mesure) VALUES (348, 1291, 37, 19, NULL, NULL, NULL, NULL, '2015-11-11 23:13:37.694065+01', NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO association_objets (pk_association_objets, fk_objet_source, fk_objet_cible, fk_type_association_param, reference_precise_objet_source, url_objet_source, descriptif, notes, date_creation, date_modification, fk_qualificatif_objet_source, fk_role_objet_source, libelle_original_objet_source, valeur_objet_source, fk_unite_de_mesure) VALUES (349, 1290, 37, 19, NULL, NULL, NULL, NULL, '2015-11-11 23:13:37.694065+01', NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO association_objets (pk_association_objets, fk_objet_source, fk_objet_cible, fk_type_association_param, reference_precise_objet_source, url_objet_source, descriptif, notes, date_creation, date_modification, fk_qualificatif_objet_source, fk_role_objet_source, libelle_original_objet_source, valeur_objet_source, fk_unite_de_mesure) VALUES (350, 1289, 37, 19, NULL, NULL, NULL, NULL, '2015-11-11 23:13:37.694065+01', NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO association_objets (pk_association_objets, fk_objet_source, fk_objet_cible, fk_type_association_param, reference_precise_objet_source, url_objet_source, descriptif, notes, date_creation, date_modification, fk_qualificatif_objet_source, fk_role_objet_source, libelle_original_objet_source, valeur_objet_source, fk_unite_de_mesure) VALUES (351, 1288, 37, 19, NULL, NULL, NULL, NULL, '2015-11-11 23:13:37.694065+01', NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO association_objets (pk_association_objets, fk_objet_source, fk_objet_cible, fk_type_association_param, reference_precise_objet_source, url_objet_source, descriptif, notes, date_creation, date_modification, fk_qualificatif_objet_source, fk_role_objet_source, libelle_original_objet_source, valeur_objet_source, fk_unite_de_mesure) VALUES (352, 1287, 37, 19, NULL, NULL, NULL, NULL, '2015-11-11 23:13:37.694065+01', NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO association_objets (pk_association_objets, fk_objet_source, fk_objet_cible, fk_type_association_param, reference_precise_objet_source, url_objet_source, descriptif, notes, date_creation, date_modification, fk_qualificatif_objet_source, fk_role_objet_source, libelle_original_objet_source, valeur_objet_source, fk_unite_de_mesure) VALUES (353, 1286, 37, 19, NULL, NULL, NULL, NULL, '2015-11-11 23:13:37.694065+01', NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO association_objets (pk_association_objets, fk_objet_source, fk_objet_cible, fk_type_association_param, reference_precise_objet_source, url_objet_source, descriptif, notes, date_creation, date_modification, fk_qualificatif_objet_source, fk_role_objet_source, libelle_original_objet_source, valeur_objet_source, fk_unite_de_mesure) VALUES (354, 1285, 37, 19, NULL, NULL, NULL, NULL, '2015-11-11 23:13:37.694065+01', NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO association_objets (pk_association_objets, fk_objet_source, fk_objet_cible, fk_type_association_param, reference_precise_objet_source, url_objet_source, descriptif, notes, date_creation, date_modification, fk_qualificatif_objet_source, fk_role_objet_source, libelle_original_objet_source, valeur_objet_source, fk_unite_de_mesure) VALUES (355, 1284, 37, 19, NULL, NULL, NULL, NULL, '2015-11-11 23:13:37.694065+01', NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO association_objets (pk_association_objets, fk_objet_source, fk_objet_cible, fk_type_association_param, reference_precise_objet_source, url_objet_source, descriptif, notes, date_creation, date_modification, fk_qualificatif_objet_source, fk_role_objet_source, libelle_original_objet_source, valeur_objet_source, fk_unite_de_mesure) VALUES (356, 1283, 37, 19, NULL, NULL, NULL, NULL, '2015-11-11 23:13:37.694065+01', NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO association_objets (pk_association_objets, fk_objet_source, fk_objet_cible, fk_type_association_param, reference_precise_objet_source, url_objet_source, descriptif, notes, date_creation, date_modification, fk_qualificatif_objet_source, fk_role_objet_source, libelle_original_objet_source, valeur_objet_source, fk_unite_de_mesure) VALUES (357, 1282, 37, 19, NULL, NULL, NULL, NULL, '2015-11-11 23:13:37.694065+01', NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO association_objets (pk_association_objets, fk_objet_source, fk_objet_cible, fk_type_association_param, reference_precise_objet_source, url_objet_source, descriptif, notes, date_creation, date_modification, fk_qualificatif_objet_source, fk_role_objet_source, libelle_original_objet_source, valeur_objet_source, fk_unite_de_mesure) VALUES (358, 1281, 37, 19, NULL, NULL, NULL, NULL, '2015-11-11 23:13:37.694065+01', NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO association_objets (pk_association_objets, fk_objet_source, fk_objet_cible, fk_type_association_param, reference_precise_objet_source, url_objet_source, descriptif, notes, date_creation, date_modification, fk_qualificatif_objet_source, fk_role_objet_source, libelle_original_objet_source, valeur_objet_source, fk_unite_de_mesure) VALUES (359, 1280, 37, 19, NULL, NULL, NULL, NULL, '2015-11-11 23:13:37.694065+01', NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO association_objets (pk_association_objets, fk_objet_source, fk_objet_cible, fk_type_association_param, reference_precise_objet_source, url_objet_source, descriptif, notes, date_creation, date_modification, fk_qualificatif_objet_source, fk_role_objet_source, libelle_original_objet_source, valeur_objet_source, fk_unite_de_mesure) VALUES (360, 1279, 37, 19, NULL, NULL, NULL, NULL, '2015-11-11 23:13:37.694065+01', NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO association_objets (pk_association_objets, fk_objet_source, fk_objet_cible, fk_type_association_param, reference_precise_objet_source, url_objet_source, descriptif, notes, date_creation, date_modification, fk_qualificatif_objet_source, fk_role_objet_source, libelle_original_objet_source, valeur_objet_source, fk_unite_de_mesure) VALUES (361, 1278, 37, 19, NULL, NULL, NULL, NULL, '2015-11-11 23:13:37.694065+01', NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO association_objets (pk_association_objets, fk_objet_source, fk_objet_cible, fk_type_association_param, reference_precise_objet_source, url_objet_source, descriptif, notes, date_creation, date_modification, fk_qualificatif_objet_source, fk_role_objet_source, libelle_original_objet_source, valeur_objet_source, fk_unite_de_mesure) VALUES (362, 1277, 37, 19, NULL, NULL, NULL, NULL, '2015-11-11 23:13:37.694065+01', NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO association_objets (pk_association_objets, fk_objet_source, fk_objet_cible, fk_type_association_param, reference_precise_objet_source, url_objet_source, descriptif, notes, date_creation, date_modification, fk_qualificatif_objet_source, fk_role_objet_source, libelle_original_objet_source, valeur_objet_source, fk_unite_de_mesure) VALUES (363, 1276, 37, 19, NULL, NULL, NULL, NULL, '2015-11-11 23:13:37.694065+01', NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO association_objets (pk_association_objets, fk_objet_source, fk_objet_cible, fk_type_association_param, reference_precise_objet_source, url_objet_source, descriptif, notes, date_creation, date_modification, fk_qualificatif_objet_source, fk_role_objet_source, libelle_original_objet_source, valeur_objet_source, fk_unite_de_mesure) VALUES (364, 1275, 37, 19, NULL, NULL, NULL, NULL, '2015-11-11 23:13:37.694065+01', NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO association_objets (pk_association_objets, fk_objet_source, fk_objet_cible, fk_type_association_param, reference_precise_objet_source, url_objet_source, descriptif, notes, date_creation, date_modification, fk_qualificatif_objet_source, fk_role_objet_source, libelle_original_objet_source, valeur_objet_source, fk_unite_de_mesure) VALUES (365, 1274, 37, 19, NULL, NULL, NULL, NULL, '2015-11-11 23:13:37.694065+01', NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO association_objets (pk_association_objets, fk_objet_source, fk_objet_cible, fk_type_association_param, reference_precise_objet_source, url_objet_source, descriptif, notes, date_creation, date_modification, fk_qualificatif_objet_source, fk_role_objet_source, libelle_original_objet_source, valeur_objet_source, fk_unite_de_mesure) VALUES (366, 1273, 37, 19, NULL, NULL, NULL, NULL, '2015-11-11 23:13:37.694065+01', NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO association_objets (pk_association_objets, fk_objet_source, fk_objet_cible, fk_type_association_param, reference_precise_objet_source, url_objet_source, descriptif, notes, date_creation, date_modification, fk_qualificatif_objet_source, fk_role_objet_source, libelle_original_objet_source, valeur_objet_source, fk_unite_de_mesure) VALUES (367, 1272, 37, 19, NULL, NULL, NULL, NULL, '2015-11-11 23:13:37.694065+01', NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO association_objets (pk_association_objets, fk_objet_source, fk_objet_cible, fk_type_association_param, reference_precise_objet_source, url_objet_source, descriptif, notes, date_creation, date_modification, fk_qualificatif_objet_source, fk_role_objet_source, libelle_original_objet_source, valeur_objet_source, fk_unite_de_mesure) VALUES (368, 1271, 37, 19, NULL, NULL, NULL, NULL, '2015-11-11 23:13:37.694065+01', NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO association_objets (pk_association_objets, fk_objet_source, fk_objet_cible, fk_type_association_param, reference_precise_objet_source, url_objet_source, descriptif, notes, date_creation, date_modification, fk_qualificatif_objet_source, fk_role_objet_source, libelle_original_objet_source, valeur_objet_source, fk_unite_de_mesure) VALUES (369, 1270, 37, 19, NULL, NULL, NULL, NULL, '2015-11-11 23:13:37.694065+01', NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO association_objets (pk_association_objets, fk_objet_source, fk_objet_cible, fk_type_association_param, reference_precise_objet_source, url_objet_source, descriptif, notes, date_creation, date_modification, fk_qualificatif_objet_source, fk_role_objet_source, libelle_original_objet_source, valeur_objet_source, fk_unite_de_mesure) VALUES (370, 1269, 37, 19, NULL, NULL, NULL, NULL, '2015-11-11 23:13:37.694065+01', NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO association_objets (pk_association_objets, fk_objet_source, fk_objet_cible, fk_type_association_param, reference_precise_objet_source, url_objet_source, descriptif, notes, date_creation, date_modification, fk_qualificatif_objet_source, fk_role_objet_source, libelle_original_objet_source, valeur_objet_source, fk_unite_de_mesure) VALUES (371, 1268, 37, 19, NULL, NULL, NULL, NULL, '2015-11-11 23:13:37.694065+01', NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO association_objets (pk_association_objets, fk_objet_source, fk_objet_cible, fk_type_association_param, reference_precise_objet_source, url_objet_source, descriptif, notes, date_creation, date_modification, fk_qualificatif_objet_source, fk_role_objet_source, libelle_original_objet_source, valeur_objet_source, fk_unite_de_mesure) VALUES (372, 1267, 37, 19, NULL, NULL, NULL, NULL, '2015-11-11 23:13:37.694065+01', NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO association_objets (pk_association_objets, fk_objet_source, fk_objet_cible, fk_type_association_param, reference_precise_objet_source, url_objet_source, descriptif, notes, date_creation, date_modification, fk_qualificatif_objet_source, fk_role_objet_source, libelle_original_objet_source, valeur_objet_source, fk_unite_de_mesure) VALUES (373, 1266, 37, 19, NULL, NULL, NULL, NULL, '2015-11-11 23:13:37.694065+01', NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO association_objets (pk_association_objets, fk_objet_source, fk_objet_cible, fk_type_association_param, reference_precise_objet_source, url_objet_source, descriptif, notes, date_creation, date_modification, fk_qualificatif_objet_source, fk_role_objet_source, libelle_original_objet_source, valeur_objet_source, fk_unite_de_mesure) VALUES (374, 1265, 37, 19, NULL, NULL, NULL, NULL, '2015-11-11 23:13:37.694065+01', NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO association_objets (pk_association_objets, fk_objet_source, fk_objet_cible, fk_type_association_param, reference_precise_objet_source, url_objet_source, descriptif, notes, date_creation, date_modification, fk_qualificatif_objet_source, fk_role_objet_source, libelle_original_objet_source, valeur_objet_source, fk_unite_de_mesure) VALUES (375, 1264, 37, 19, NULL, NULL, NULL, NULL, '2015-11-11 23:13:37.694065+01', NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO association_objets (pk_association_objets, fk_objet_source, fk_objet_cible, fk_type_association_param, reference_precise_objet_source, url_objet_source, descriptif, notes, date_creation, date_modification, fk_qualificatif_objet_source, fk_role_objet_source, libelle_original_objet_source, valeur_objet_source, fk_unite_de_mesure) VALUES (376, 1263, 37, 19, NULL, NULL, NULL, NULL, '2015-11-11 23:13:37.694065+01', NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO association_objets (pk_association_objets, fk_objet_source, fk_objet_cible, fk_type_association_param, reference_precise_objet_source, url_objet_source, descriptif, notes, date_creation, date_modification, fk_qualificatif_objet_source, fk_role_objet_source, libelle_original_objet_source, valeur_objet_source, fk_unite_de_mesure) VALUES (377, 1262, 37, 19, NULL, NULL, NULL, NULL, '2015-11-11 23:13:37.694065+01', NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO association_objets (pk_association_objets, fk_objet_source, fk_objet_cible, fk_type_association_param, reference_precise_objet_source, url_objet_source, descriptif, notes, date_creation, date_modification, fk_qualificatif_objet_source, fk_role_objet_source, libelle_original_objet_source, valeur_objet_source, fk_unite_de_mesure) VALUES (378, 1261, 37, 19, NULL, NULL, NULL, NULL, '2015-11-11 23:13:37.694065+01', NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO association_objets (pk_association_objets, fk_objet_source, fk_objet_cible, fk_type_association_param, reference_precise_objet_source, url_objet_source, descriptif, notes, date_creation, date_modification, fk_qualificatif_objet_source, fk_role_objet_source, libelle_original_objet_source, valeur_objet_source, fk_unite_de_mesure) VALUES (379, 1260, 37, 19, NULL, NULL, NULL, NULL, '2015-11-11 23:13:37.694065+01', NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO association_objets (pk_association_objets, fk_objet_source, fk_objet_cible, fk_type_association_param, reference_precise_objet_source, url_objet_source, descriptif, notes, date_creation, date_modification, fk_qualificatif_objet_source, fk_role_objet_source, libelle_original_objet_source, valeur_objet_source, fk_unite_de_mesure) VALUES (380, 1259, 37, 19, NULL, NULL, NULL, NULL, '2015-11-11 23:13:37.694065+01', NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO association_objets (pk_association_objets, fk_objet_source, fk_objet_cible, fk_type_association_param, reference_precise_objet_source, url_objet_source, descriptif, notes, date_creation, date_modification, fk_qualificatif_objet_source, fk_role_objet_source, libelle_original_objet_source, valeur_objet_source, fk_unite_de_mesure) VALUES (381, 1258, 37, 19, NULL, NULL, NULL, NULL, '2015-11-11 23:13:37.694065+01', NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO association_objets (pk_association_objets, fk_objet_source, fk_objet_cible, fk_type_association_param, reference_precise_objet_source, url_objet_source, descriptif, notes, date_creation, date_modification, fk_qualificatif_objet_source, fk_role_objet_source, libelle_original_objet_source, valeur_objet_source, fk_unite_de_mesure) VALUES (382, 1257, 37, 19, NULL, NULL, NULL, NULL, '2015-11-11 23:13:37.694065+01', NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO association_objets (pk_association_objets, fk_objet_source, fk_objet_cible, fk_type_association_param, reference_precise_objet_source, url_objet_source, descriptif, notes, date_creation, date_modification, fk_qualificatif_objet_source, fk_role_objet_source, libelle_original_objet_source, valeur_objet_source, fk_unite_de_mesure) VALUES (383, 1256, 37, 19, NULL, NULL, NULL, NULL, '2015-11-11 23:13:37.694065+01', NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO association_objets (pk_association_objets, fk_objet_source, fk_objet_cible, fk_type_association_param, reference_precise_objet_source, url_objet_source, descriptif, notes, date_creation, date_modification, fk_qualificatif_objet_source, fk_role_objet_source, libelle_original_objet_source, valeur_objet_source, fk_unite_de_mesure) VALUES (384, 1255, 37, 19, NULL, NULL, NULL, NULL, '2015-11-11 23:13:37.694065+01', NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO association_objets (pk_association_objets, fk_objet_source, fk_objet_cible, fk_type_association_param, reference_precise_objet_source, url_objet_source, descriptif, notes, date_creation, date_modification, fk_qualificatif_objet_source, fk_role_objet_source, libelle_original_objet_source, valeur_objet_source, fk_unite_de_mesure) VALUES (385, 1254, 37, 19, NULL, NULL, NULL, NULL, '2015-11-11 23:13:37.694065+01', NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO association_objets (pk_association_objets, fk_objet_source, fk_objet_cible, fk_type_association_param, reference_precise_objet_source, url_objet_source, descriptif, notes, date_creation, date_modification, fk_qualificatif_objet_source, fk_role_objet_source, libelle_original_objet_source, valeur_objet_source, fk_unite_de_mesure) VALUES (386, 1253, 37, 19, NULL, NULL, NULL, NULL, '2015-11-11 23:13:37.694065+01', NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO association_objets (pk_association_objets, fk_objet_source, fk_objet_cible, fk_type_association_param, reference_precise_objet_source, url_objet_source, descriptif, notes, date_creation, date_modification, fk_qualificatif_objet_source, fk_role_objet_source, libelle_original_objet_source, valeur_objet_source, fk_unite_de_mesure) VALUES (387, 1252, 37, 19, NULL, NULL, NULL, NULL, '2015-11-11 23:13:37.694065+01', NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO association_objets (pk_association_objets, fk_objet_source, fk_objet_cible, fk_type_association_param, reference_precise_objet_source, url_objet_source, descriptif, notes, date_creation, date_modification, fk_qualificatif_objet_source, fk_role_objet_source, libelle_original_objet_source, valeur_objet_source, fk_unite_de_mesure) VALUES (388, 1251, 37, 19, NULL, NULL, NULL, NULL, '2015-11-11 23:13:37.694065+01', NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO association_objets (pk_association_objets, fk_objet_source, fk_objet_cible, fk_type_association_param, reference_precise_objet_source, url_objet_source, descriptif, notes, date_creation, date_modification, fk_qualificatif_objet_source, fk_role_objet_source, libelle_original_objet_source, valeur_objet_source, fk_unite_de_mesure) VALUES (389, 1250, 37, 19, NULL, NULL, NULL, NULL, '2015-11-11 23:13:37.694065+01', NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO association_objets (pk_association_objets, fk_objet_source, fk_objet_cible, fk_type_association_param, reference_precise_objet_source, url_objet_source, descriptif, notes, date_creation, date_modification, fk_qualificatif_objet_source, fk_role_objet_source, libelle_original_objet_source, valeur_objet_source, fk_unite_de_mesure) VALUES (390, 1249, 37, 19, NULL, NULL, NULL, NULL, '2015-11-11 23:13:37.694065+01', NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO association_objets (pk_association_objets, fk_objet_source, fk_objet_cible, fk_type_association_param, reference_precise_objet_source, url_objet_source, descriptif, notes, date_creation, date_modification, fk_qualificatif_objet_source, fk_role_objet_source, libelle_original_objet_source, valeur_objet_source, fk_unite_de_mesure) VALUES (391, 1248, 37, 19, NULL, NULL, NULL, NULL, '2015-11-11 23:13:37.694065+01', NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO association_objets (pk_association_objets, fk_objet_source, fk_objet_cible, fk_type_association_param, reference_precise_objet_source, url_objet_source, descriptif, notes, date_creation, date_modification, fk_qualificatif_objet_source, fk_role_objet_source, libelle_original_objet_source, valeur_objet_source, fk_unite_de_mesure) VALUES (392, 1247, 37, 19, NULL, NULL, NULL, NULL, '2015-11-11 23:13:37.694065+01', NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO association_objets (pk_association_objets, fk_objet_source, fk_objet_cible, fk_type_association_param, reference_precise_objet_source, url_objet_source, descriptif, notes, date_creation, date_modification, fk_qualificatif_objet_source, fk_role_objet_source, libelle_original_objet_source, valeur_objet_source, fk_unite_de_mesure) VALUES (393, 1246, 37, 19, NULL, NULL, NULL, NULL, '2015-11-11 23:13:37.694065+01', NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO association_objets (pk_association_objets, fk_objet_source, fk_objet_cible, fk_type_association_param, reference_precise_objet_source, url_objet_source, descriptif, notes, date_creation, date_modification, fk_qualificatif_objet_source, fk_role_objet_source, libelle_original_objet_source, valeur_objet_source, fk_unite_de_mesure) VALUES (394, 1245, 37, 19, NULL, NULL, NULL, NULL, '2015-11-11 23:13:37.694065+01', NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO association_objets (pk_association_objets, fk_objet_source, fk_objet_cible, fk_type_association_param, reference_precise_objet_source, url_objet_source, descriptif, notes, date_creation, date_modification, fk_qualificatif_objet_source, fk_role_objet_source, libelle_original_objet_source, valeur_objet_source, fk_unite_de_mesure) VALUES (395, 1244, 37, 19, NULL, NULL, NULL, NULL, '2015-11-11 23:13:37.694065+01', NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO association_objets (pk_association_objets, fk_objet_source, fk_objet_cible, fk_type_association_param, reference_precise_objet_source, url_objet_source, descriptif, notes, date_creation, date_modification, fk_qualificatif_objet_source, fk_role_objet_source, libelle_original_objet_source, valeur_objet_source, fk_unite_de_mesure) VALUES (396, 1243, 37, 19, NULL, NULL, NULL, NULL, '2015-11-11 23:13:37.694065+01', NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO association_objets (pk_association_objets, fk_objet_source, fk_objet_cible, fk_type_association_param, reference_precise_objet_source, url_objet_source, descriptif, notes, date_creation, date_modification, fk_qualificatif_objet_source, fk_role_objet_source, libelle_original_objet_source, valeur_objet_source, fk_unite_de_mesure) VALUES (397, 1242, 37, 19, NULL, NULL, NULL, NULL, '2015-11-11 23:13:37.694065+01', NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO association_objets (pk_association_objets, fk_objet_source, fk_objet_cible, fk_type_association_param, reference_precise_objet_source, url_objet_source, descriptif, notes, date_creation, date_modification, fk_qualificatif_objet_source, fk_role_objet_source, libelle_original_objet_source, valeur_objet_source, fk_unite_de_mesure) VALUES (398, 1241, 37, 19, NULL, NULL, NULL, NULL, '2015-11-11 23:13:37.694065+01', NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO association_objets (pk_association_objets, fk_objet_source, fk_objet_cible, fk_type_association_param, reference_precise_objet_source, url_objet_source, descriptif, notes, date_creation, date_modification, fk_qualificatif_objet_source, fk_role_objet_source, libelle_original_objet_source, valeur_objet_source, fk_unite_de_mesure) VALUES (399, 1240, 37, 19, NULL, NULL, NULL, NULL, '2015-11-11 23:13:37.694065+01', NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO association_objets (pk_association_objets, fk_objet_source, fk_objet_cible, fk_type_association_param, reference_precise_objet_source, url_objet_source, descriptif, notes, date_creation, date_modification, fk_qualificatif_objet_source, fk_role_objet_source, libelle_original_objet_source, valeur_objet_source, fk_unite_de_mesure) VALUES (400, 1239, 37, 19, NULL, NULL, NULL, NULL, '2015-11-11 23:13:37.694065+01', NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO association_objets (pk_association_objets, fk_objet_source, fk_objet_cible, fk_type_association_param, reference_precise_objet_source, url_objet_source, descriptif, notes, date_creation, date_modification, fk_qualificatif_objet_source, fk_role_objet_source, libelle_original_objet_source, valeur_objet_source, fk_unite_de_mesure) VALUES (401, 1238, 37, 19, NULL, NULL, NULL, NULL, '2015-11-11 23:13:37.694065+01', NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO association_objets (pk_association_objets, fk_objet_source, fk_objet_cible, fk_type_association_param, reference_precise_objet_source, url_objet_source, descriptif, notes, date_creation, date_modification, fk_qualificatif_objet_source, fk_role_objet_source, libelle_original_objet_source, valeur_objet_source, fk_unite_de_mesure) VALUES (402, 1237, 37, 19, NULL, NULL, NULL, NULL, '2015-11-11 23:13:37.694065+01', NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO association_objets (pk_association_objets, fk_objet_source, fk_objet_cible, fk_type_association_param, reference_precise_objet_source, url_objet_source, descriptif, notes, date_creation, date_modification, fk_qualificatif_objet_source, fk_role_objet_source, libelle_original_objet_source, valeur_objet_source, fk_unite_de_mesure) VALUES (403, 1236, 37, 19, NULL, NULL, NULL, NULL, '2015-11-11 23:13:37.694065+01', NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO association_objets (pk_association_objets, fk_objet_source, fk_objet_cible, fk_type_association_param, reference_precise_objet_source, url_objet_source, descriptif, notes, date_creation, date_modification, fk_qualificatif_objet_source, fk_role_objet_source, libelle_original_objet_source, valeur_objet_source, fk_unite_de_mesure) VALUES (404, 1235, 37, 19, NULL, NULL, NULL, NULL, '2015-11-11 23:13:37.694065+01', NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO association_objets (pk_association_objets, fk_objet_source, fk_objet_cible, fk_type_association_param, reference_precise_objet_source, url_objet_source, descriptif, notes, date_creation, date_modification, fk_qualificatif_objet_source, fk_role_objet_source, libelle_original_objet_source, valeur_objet_source, fk_unite_de_mesure) VALUES (405, 1234, 37, 19, NULL, NULL, NULL, NULL, '2015-11-11 23:13:37.694065+01', NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO association_objets (pk_association_objets, fk_objet_source, fk_objet_cible, fk_type_association_param, reference_precise_objet_source, url_objet_source, descriptif, notes, date_creation, date_modification, fk_qualificatif_objet_source, fk_role_objet_source, libelle_original_objet_source, valeur_objet_source, fk_unite_de_mesure) VALUES (406, 1233, 37, 19, NULL, NULL, NULL, NULL, '2015-11-11 23:13:37.694065+01', NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO association_objets (pk_association_objets, fk_objet_source, fk_objet_cible, fk_type_association_param, reference_precise_objet_source, url_objet_source, descriptif, notes, date_creation, date_modification, fk_qualificatif_objet_source, fk_role_objet_source, libelle_original_objet_source, valeur_objet_source, fk_unite_de_mesure) VALUES (407, 1232, 37, 19, NULL, NULL, NULL, NULL, '2015-11-11 23:13:37.694065+01', NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO association_objets (pk_association_objets, fk_objet_source, fk_objet_cible, fk_type_association_param, reference_precise_objet_source, url_objet_source, descriptif, notes, date_creation, date_modification, fk_qualificatif_objet_source, fk_role_objet_source, libelle_original_objet_source, valeur_objet_source, fk_unite_de_mesure) VALUES (408, 1231, 37, 19, NULL, NULL, NULL, NULL, '2015-11-11 23:13:37.694065+01', NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO association_objets (pk_association_objets, fk_objet_source, fk_objet_cible, fk_type_association_param, reference_precise_objet_source, url_objet_source, descriptif, notes, date_creation, date_modification, fk_qualificatif_objet_source, fk_role_objet_source, libelle_original_objet_source, valeur_objet_source, fk_unite_de_mesure) VALUES (409, 1230, 37, 19, NULL, NULL, NULL, NULL, '2015-11-11 23:13:37.694065+01', NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO association_objets (pk_association_objets, fk_objet_source, fk_objet_cible, fk_type_association_param, reference_precise_objet_source, url_objet_source, descriptif, notes, date_creation, date_modification, fk_qualificatif_objet_source, fk_role_objet_source, libelle_original_objet_source, valeur_objet_source, fk_unite_de_mesure) VALUES (410, 1229, 37, 19, NULL, NULL, NULL, NULL, '2015-11-11 23:13:37.694065+01', NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO association_objets (pk_association_objets, fk_objet_source, fk_objet_cible, fk_type_association_param, reference_precise_objet_source, url_objet_source, descriptif, notes, date_creation, date_modification, fk_qualificatif_objet_source, fk_role_objet_source, libelle_original_objet_source, valeur_objet_source, fk_unite_de_mesure) VALUES (411, 1228, 37, 19, NULL, NULL, NULL, NULL, '2015-11-11 23:13:37.694065+01', NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO association_objets (pk_association_objets, fk_objet_source, fk_objet_cible, fk_type_association_param, reference_precise_objet_source, url_objet_source, descriptif, notes, date_creation, date_modification, fk_qualificatif_objet_source, fk_role_objet_source, libelle_original_objet_source, valeur_objet_source, fk_unite_de_mesure) VALUES (412, 1227, 37, 19, NULL, NULL, NULL, NULL, '2015-11-11 23:13:37.694065+01', NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO association_objets (pk_association_objets, fk_objet_source, fk_objet_cible, fk_type_association_param, reference_precise_objet_source, url_objet_source, descriptif, notes, date_creation, date_modification, fk_qualificatif_objet_source, fk_role_objet_source, libelle_original_objet_source, valeur_objet_source, fk_unite_de_mesure) VALUES (413, 1226, 37, 19, NULL, NULL, NULL, NULL, '2015-11-11 23:13:37.694065+01', NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO association_objets (pk_association_objets, fk_objet_source, fk_objet_cible, fk_type_association_param, reference_precise_objet_source, url_objet_source, descriptif, notes, date_creation, date_modification, fk_qualificatif_objet_source, fk_role_objet_source, libelle_original_objet_source, valeur_objet_source, fk_unite_de_mesure) VALUES (414, 1225, 37, 19, NULL, NULL, NULL, NULL, '2015-11-11 23:13:37.694065+01', NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO association_objets (pk_association_objets, fk_objet_source, fk_objet_cible, fk_type_association_param, reference_precise_objet_source, url_objet_source, descriptif, notes, date_creation, date_modification, fk_qualificatif_objet_source, fk_role_objet_source, libelle_original_objet_source, valeur_objet_source, fk_unite_de_mesure) VALUES (415, 1224, 37, 19, NULL, NULL, NULL, NULL, '2015-11-11 23:13:37.694065+01', NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO association_objets (pk_association_objets, fk_objet_source, fk_objet_cible, fk_type_association_param, reference_precise_objet_source, url_objet_source, descriptif, notes, date_creation, date_modification, fk_qualificatif_objet_source, fk_role_objet_source, libelle_original_objet_source, valeur_objet_source, fk_unite_de_mesure) VALUES (416, 1223, 37, 19, NULL, NULL, NULL, NULL, '2015-11-11 23:13:37.694065+01', NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO association_objets (pk_association_objets, fk_objet_source, fk_objet_cible, fk_type_association_param, reference_precise_objet_source, url_objet_source, descriptif, notes, date_creation, date_modification, fk_qualificatif_objet_source, fk_role_objet_source, libelle_original_objet_source, valeur_objet_source, fk_unite_de_mesure) VALUES (417, 1222, 37, 19, NULL, NULL, NULL, NULL, '2015-11-11 23:13:37.694065+01', NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO association_objets (pk_association_objets, fk_objet_source, fk_objet_cible, fk_type_association_param, reference_precise_objet_source, url_objet_source, descriptif, notes, date_creation, date_modification, fk_qualificatif_objet_source, fk_role_objet_source, libelle_original_objet_source, valeur_objet_source, fk_unite_de_mesure) VALUES (418, 1221, 37, 19, NULL, NULL, NULL, NULL, '2015-11-11 23:13:37.694065+01', NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO association_objets (pk_association_objets, fk_objet_source, fk_objet_cible, fk_type_association_param, reference_precise_objet_source, url_objet_source, descriptif, notes, date_creation, date_modification, fk_qualificatif_objet_source, fk_role_objet_source, libelle_original_objet_source, valeur_objet_source, fk_unite_de_mesure) VALUES (419, 1220, 37, 19, NULL, NULL, NULL, NULL, '2015-11-11 23:13:37.694065+01', NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO association_objets (pk_association_objets, fk_objet_source, fk_objet_cible, fk_type_association_param, reference_precise_objet_source, url_objet_source, descriptif, notes, date_creation, date_modification, fk_qualificatif_objet_source, fk_role_objet_source, libelle_original_objet_source, valeur_objet_source, fk_unite_de_mesure) VALUES (420, 1219, 37, 19, NULL, NULL, NULL, NULL, '2015-11-11 23:13:37.694065+01', NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO association_objets (pk_association_objets, fk_objet_source, fk_objet_cible, fk_type_association_param, reference_precise_objet_source, url_objet_source, descriptif, notes, date_creation, date_modification, fk_qualificatif_objet_source, fk_role_objet_source, libelle_original_objet_source, valeur_objet_source, fk_unite_de_mesure) VALUES (421, 1218, 37, 19, NULL, NULL, NULL, NULL, '2015-11-11 23:13:37.694065+01', NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO association_objets (pk_association_objets, fk_objet_source, fk_objet_cible, fk_type_association_param, reference_precise_objet_source, url_objet_source, descriptif, notes, date_creation, date_modification, fk_qualificatif_objet_source, fk_role_objet_source, libelle_original_objet_source, valeur_objet_source, fk_unite_de_mesure) VALUES (422, 1217, 37, 19, NULL, NULL, NULL, NULL, '2015-11-11 23:13:37.694065+01', NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO association_objets (pk_association_objets, fk_objet_source, fk_objet_cible, fk_type_association_param, reference_precise_objet_source, url_objet_source, descriptif, notes, date_creation, date_modification, fk_qualificatif_objet_source, fk_role_objet_source, libelle_original_objet_source, valeur_objet_source, fk_unite_de_mesure) VALUES (423, 1216, 37, 19, NULL, NULL, NULL, NULL, '2015-11-11 23:13:37.694065+01', NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO association_objets (pk_association_objets, fk_objet_source, fk_objet_cible, fk_type_association_param, reference_precise_objet_source, url_objet_source, descriptif, notes, date_creation, date_modification, fk_qualificatif_objet_source, fk_role_objet_source, libelle_original_objet_source, valeur_objet_source, fk_unite_de_mesure) VALUES (424, 1215, 37, 19, NULL, NULL, NULL, NULL, '2015-11-11 23:13:37.694065+01', NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO association_objets (pk_association_objets, fk_objet_source, fk_objet_cible, fk_type_association_param, reference_precise_objet_source, url_objet_source, descriptif, notes, date_creation, date_modification, fk_qualificatif_objet_source, fk_role_objet_source, libelle_original_objet_source, valeur_objet_source, fk_unite_de_mesure) VALUES (425, 1214, 37, 19, NULL, NULL, NULL, NULL, '2015-11-11 23:13:37.694065+01', NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO association_objets (pk_association_objets, fk_objet_source, fk_objet_cible, fk_type_association_param, reference_precise_objet_source, url_objet_source, descriptif, notes, date_creation, date_modification, fk_qualificatif_objet_source, fk_role_objet_source, libelle_original_objet_source, valeur_objet_source, fk_unite_de_mesure) VALUES (426, 1213, 37, 19, NULL, NULL, NULL, NULL, '2015-11-11 23:13:37.694065+01', NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO association_objets (pk_association_objets, fk_objet_source, fk_objet_cible, fk_type_association_param, reference_precise_objet_source, url_objet_source, descriptif, notes, date_creation, date_modification, fk_qualificatif_objet_source, fk_role_objet_source, libelle_original_objet_source, valeur_objet_source, fk_unite_de_mesure) VALUES (427, 1212, 37, 19, NULL, NULL, NULL, NULL, '2015-11-11 23:13:37.694065+01', NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO association_objets (pk_association_objets, fk_objet_source, fk_objet_cible, fk_type_association_param, reference_precise_objet_source, url_objet_source, descriptif, notes, date_creation, date_modification, fk_qualificatif_objet_source, fk_role_objet_source, libelle_original_objet_source, valeur_objet_source, fk_unite_de_mesure) VALUES (428, 1211, 37, 19, NULL, NULL, NULL, NULL, '2015-11-11 23:13:37.694065+01', NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO association_objets (pk_association_objets, fk_objet_source, fk_objet_cible, fk_type_association_param, reference_precise_objet_source, url_objet_source, descriptif, notes, date_creation, date_modification, fk_qualificatif_objet_source, fk_role_objet_source, libelle_original_objet_source, valeur_objet_source, fk_unite_de_mesure) VALUES (429, 1210, 37, 19, NULL, NULL, NULL, NULL, '2015-11-11 23:13:37.694065+01', NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO association_objets (pk_association_objets, fk_objet_source, fk_objet_cible, fk_type_association_param, reference_precise_objet_source, url_objet_source, descriptif, notes, date_creation, date_modification, fk_qualificatif_objet_source, fk_role_objet_source, libelle_original_objet_source, valeur_objet_source, fk_unite_de_mesure) VALUES (430, 1209, 37, 19, NULL, NULL, NULL, NULL, '2015-11-11 23:13:37.694065+01', NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO association_objets (pk_association_objets, fk_objet_source, fk_objet_cible, fk_type_association_param, reference_precise_objet_source, url_objet_source, descriptif, notes, date_creation, date_modification, fk_qualificatif_objet_source, fk_role_objet_source, libelle_original_objet_source, valeur_objet_source, fk_unite_de_mesure) VALUES (431, 1208, 37, 19, NULL, NULL, NULL, NULL, '2015-11-11 23:13:37.694065+01', NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO association_objets (pk_association_objets, fk_objet_source, fk_objet_cible, fk_type_association_param, reference_precise_objet_source, url_objet_source, descriptif, notes, date_creation, date_modification, fk_qualificatif_objet_source, fk_role_objet_source, libelle_original_objet_source, valeur_objet_source, fk_unite_de_mesure) VALUES (432, 1207, 37, 19, NULL, NULL, NULL, NULL, '2015-11-11 23:13:37.694065+01', NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO association_objets (pk_association_objets, fk_objet_source, fk_objet_cible, fk_type_association_param, reference_precise_objet_source, url_objet_source, descriptif, notes, date_creation, date_modification, fk_qualificatif_objet_source, fk_role_objet_source, libelle_original_objet_source, valeur_objet_source, fk_unite_de_mesure) VALUES (433, 1206, 37, 19, NULL, NULL, NULL, NULL, '2015-11-11 23:13:37.694065+01', NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO association_objets (pk_association_objets, fk_objet_source, fk_objet_cible, fk_type_association_param, reference_precise_objet_source, url_objet_source, descriptif, notes, date_creation, date_modification, fk_qualificatif_objet_source, fk_role_objet_source, libelle_original_objet_source, valeur_objet_source, fk_unite_de_mesure) VALUES (434, 1205, 37, 19, NULL, NULL, NULL, NULL, '2015-11-11 23:13:37.694065+01', NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO association_objets (pk_association_objets, fk_objet_source, fk_objet_cible, fk_type_association_param, reference_precise_objet_source, url_objet_source, descriptif, notes, date_creation, date_modification, fk_qualificatif_objet_source, fk_role_objet_source, libelle_original_objet_source, valeur_objet_source, fk_unite_de_mesure) VALUES (435, 1204, 37, 19, NULL, NULL, NULL, NULL, '2015-11-11 23:13:37.694065+01', NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO association_objets (pk_association_objets, fk_objet_source, fk_objet_cible, fk_type_association_param, reference_precise_objet_source, url_objet_source, descriptif, notes, date_creation, date_modification, fk_qualificatif_objet_source, fk_role_objet_source, libelle_original_objet_source, valeur_objet_source, fk_unite_de_mesure) VALUES (436, 1203, 37, 19, NULL, NULL, NULL, NULL, '2015-11-11 23:13:37.694065+01', NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO association_objets (pk_association_objets, fk_objet_source, fk_objet_cible, fk_type_association_param, reference_precise_objet_source, url_objet_source, descriptif, notes, date_creation, date_modification, fk_qualificatif_objet_source, fk_role_objet_source, libelle_original_objet_source, valeur_objet_source, fk_unite_de_mesure) VALUES (437, 1202, 37, 19, NULL, NULL, NULL, NULL, '2015-11-11 23:13:37.694065+01', NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO association_objets (pk_association_objets, fk_objet_source, fk_objet_cible, fk_type_association_param, reference_precise_objet_source, url_objet_source, descriptif, notes, date_creation, date_modification, fk_qualificatif_objet_source, fk_role_objet_source, libelle_original_objet_source, valeur_objet_source, fk_unite_de_mesure) VALUES (438, 1201, 37, 19, NULL, NULL, NULL, NULL, '2015-11-11 23:13:37.694065+01', NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO association_objets (pk_association_objets, fk_objet_source, fk_objet_cible, fk_type_association_param, reference_precise_objet_source, url_objet_source, descriptif, notes, date_creation, date_modification, fk_qualificatif_objet_source, fk_role_objet_source, libelle_original_objet_source, valeur_objet_source, fk_unite_de_mesure) VALUES (439, 1200, 37, 19, NULL, NULL, NULL, NULL, '2015-11-11 23:13:37.694065+01', NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO association_objets (pk_association_objets, fk_objet_source, fk_objet_cible, fk_type_association_param, reference_precise_objet_source, url_objet_source, descriptif, notes, date_creation, date_modification, fk_qualificatif_objet_source, fk_role_objet_source, libelle_original_objet_source, valeur_objet_source, fk_unite_de_mesure) VALUES (440, 1199, 37, 19, NULL, NULL, NULL, NULL, '2015-11-11 23:13:37.694065+01', NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO association_objets (pk_association_objets, fk_objet_source, fk_objet_cible, fk_type_association_param, reference_precise_objet_source, url_objet_source, descriptif, notes, date_creation, date_modification, fk_qualificatif_objet_source, fk_role_objet_source, libelle_original_objet_source, valeur_objet_source, fk_unite_de_mesure) VALUES (441, 1198, 37, 19, NULL, NULL, NULL, NULL, '2015-11-11 23:13:37.694065+01', NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO association_objets (pk_association_objets, fk_objet_source, fk_objet_cible, fk_type_association_param, reference_precise_objet_source, url_objet_source, descriptif, notes, date_creation, date_modification, fk_qualificatif_objet_source, fk_role_objet_source, libelle_original_objet_source, valeur_objet_source, fk_unite_de_mesure) VALUES (442, 1197, 37, 19, NULL, NULL, NULL, NULL, '2015-11-11 23:13:37.694065+01', NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO association_objets (pk_association_objets, fk_objet_source, fk_objet_cible, fk_type_association_param, reference_precise_objet_source, url_objet_source, descriptif, notes, date_creation, date_modification, fk_qualificatif_objet_source, fk_role_objet_source, libelle_original_objet_source, valeur_objet_source, fk_unite_de_mesure) VALUES (443, 1196, 37, 19, NULL, NULL, NULL, NULL, '2015-11-11 23:13:37.694065+01', NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO association_objets (pk_association_objets, fk_objet_source, fk_objet_cible, fk_type_association_param, reference_precise_objet_source, url_objet_source, descriptif, notes, date_creation, date_modification, fk_qualificatif_objet_source, fk_role_objet_source, libelle_original_objet_source, valeur_objet_source, fk_unite_de_mesure) VALUES (444, 1195, 37, 19, NULL, NULL, NULL, NULL, '2015-11-11 23:13:37.694065+01', NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO association_objets (pk_association_objets, fk_objet_source, fk_objet_cible, fk_type_association_param, reference_precise_objet_source, url_objet_source, descriptif, notes, date_creation, date_modification, fk_qualificatif_objet_source, fk_role_objet_source, libelle_original_objet_source, valeur_objet_source, fk_unite_de_mesure) VALUES (445, 1194, 37, 19, NULL, NULL, NULL, NULL, '2015-11-11 23:13:37.694065+01', NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO association_objets (pk_association_objets, fk_objet_source, fk_objet_cible, fk_type_association_param, reference_precise_objet_source, url_objet_source, descriptif, notes, date_creation, date_modification, fk_qualificatif_objet_source, fk_role_objet_source, libelle_original_objet_source, valeur_objet_source, fk_unite_de_mesure) VALUES (446, 1193, 37, 19, NULL, NULL, NULL, NULL, '2015-11-11 23:13:37.694065+01', NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO association_objets (pk_association_objets, fk_objet_source, fk_objet_cible, fk_type_association_param, reference_precise_objet_source, url_objet_source, descriptif, notes, date_creation, date_modification, fk_qualificatif_objet_source, fk_role_objet_source, libelle_original_objet_source, valeur_objet_source, fk_unite_de_mesure) VALUES (447, 1192, 37, 19, NULL, NULL, NULL, NULL, '2015-11-11 23:13:37.694065+01', NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO association_objets (pk_association_objets, fk_objet_source, fk_objet_cible, fk_type_association_param, reference_precise_objet_source, url_objet_source, descriptif, notes, date_creation, date_modification, fk_qualificatif_objet_source, fk_role_objet_source, libelle_original_objet_source, valeur_objet_source, fk_unite_de_mesure) VALUES (448, 1191, 37, 19, NULL, NULL, NULL, NULL, '2015-11-11 23:13:37.694065+01', NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO association_objets (pk_association_objets, fk_objet_source, fk_objet_cible, fk_type_association_param, reference_precise_objet_source, url_objet_source, descriptif, notes, date_creation, date_modification, fk_qualificatif_objet_source, fk_role_objet_source, libelle_original_objet_source, valeur_objet_source, fk_unite_de_mesure) VALUES (449, 1190, 37, 19, NULL, NULL, NULL, NULL, '2015-11-11 23:13:37.694065+01', NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO association_objets (pk_association_objets, fk_objet_source, fk_objet_cible, fk_type_association_param, reference_precise_objet_source, url_objet_source, descriptif, notes, date_creation, date_modification, fk_qualificatif_objet_source, fk_role_objet_source, libelle_original_objet_source, valeur_objet_source, fk_unite_de_mesure) VALUES (450, 1189, 37, 19, NULL, NULL, NULL, NULL, '2015-11-11 23:13:37.694065+01', NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO association_objets (pk_association_objets, fk_objet_source, fk_objet_cible, fk_type_association_param, reference_precise_objet_source, url_objet_source, descriptif, notes, date_creation, date_modification, fk_qualificatif_objet_source, fk_role_objet_source, libelle_original_objet_source, valeur_objet_source, fk_unite_de_mesure) VALUES (451, 1188, 37, 19, NULL, NULL, NULL, NULL, '2015-11-11 23:13:37.694065+01', NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO association_objets (pk_association_objets, fk_objet_source, fk_objet_cible, fk_type_association_param, reference_precise_objet_source, url_objet_source, descriptif, notes, date_creation, date_modification, fk_qualificatif_objet_source, fk_role_objet_source, libelle_original_objet_source, valeur_objet_source, fk_unite_de_mesure) VALUES (452, 1187, 37, 19, NULL, NULL, NULL, NULL, '2015-11-11 23:13:37.694065+01', NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO association_objets (pk_association_objets, fk_objet_source, fk_objet_cible, fk_type_association_param, reference_precise_objet_source, url_objet_source, descriptif, notes, date_creation, date_modification, fk_qualificatif_objet_source, fk_role_objet_source, libelle_original_objet_source, valeur_objet_source, fk_unite_de_mesure) VALUES (453, 1186, 37, 19, NULL, NULL, NULL, NULL, '2015-11-11 23:13:37.694065+01', NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO association_objets (pk_association_objets, fk_objet_source, fk_objet_cible, fk_type_association_param, reference_precise_objet_source, url_objet_source, descriptif, notes, date_creation, date_modification, fk_qualificatif_objet_source, fk_role_objet_source, libelle_original_objet_source, valeur_objet_source, fk_unite_de_mesure) VALUES (454, 1185, 37, 19, NULL, NULL, NULL, NULL, '2015-11-11 23:13:37.694065+01', NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO association_objets (pk_association_objets, fk_objet_source, fk_objet_cible, fk_type_association_param, reference_precise_objet_source, url_objet_source, descriptif, notes, date_creation, date_modification, fk_qualificatif_objet_source, fk_role_objet_source, libelle_original_objet_source, valeur_objet_source, fk_unite_de_mesure) VALUES (455, 1184, 37, 19, NULL, NULL, NULL, NULL, '2015-11-11 23:13:37.694065+01', NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO association_objets (pk_association_objets, fk_objet_source, fk_objet_cible, fk_type_association_param, reference_precise_objet_source, url_objet_source, descriptif, notes, date_creation, date_modification, fk_qualificatif_objet_source, fk_role_objet_source, libelle_original_objet_source, valeur_objet_source, fk_unite_de_mesure) VALUES (456, 1183, 37, 19, NULL, NULL, NULL, NULL, '2015-11-11 23:13:37.694065+01', NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO association_objets (pk_association_objets, fk_objet_source, fk_objet_cible, fk_type_association_param, reference_precise_objet_source, url_objet_source, descriptif, notes, date_creation, date_modification, fk_qualificatif_objet_source, fk_role_objet_source, libelle_original_objet_source, valeur_objet_source, fk_unite_de_mesure) VALUES (457, 1182, 37, 19, NULL, NULL, NULL, NULL, '2015-11-11 23:13:37.694065+01', NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO association_objets (pk_association_objets, fk_objet_source, fk_objet_cible, fk_type_association_param, reference_precise_objet_source, url_objet_source, descriptif, notes, date_creation, date_modification, fk_qualificatif_objet_source, fk_role_objet_source, libelle_original_objet_source, valeur_objet_source, fk_unite_de_mesure) VALUES (458, 1181, 37, 19, NULL, NULL, NULL, NULL, '2015-11-11 23:13:37.694065+01', NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO association_objets (pk_association_objets, fk_objet_source, fk_objet_cible, fk_type_association_param, reference_precise_objet_source, url_objet_source, descriptif, notes, date_creation, date_modification, fk_qualificatif_objet_source, fk_role_objet_source, libelle_original_objet_source, valeur_objet_source, fk_unite_de_mesure) VALUES (459, 1180, 37, 19, NULL, NULL, NULL, NULL, '2015-11-11 23:13:37.694065+01', NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO association_objets (pk_association_objets, fk_objet_source, fk_objet_cible, fk_type_association_param, reference_precise_objet_source, url_objet_source, descriptif, notes, date_creation, date_modification, fk_qualificatif_objet_source, fk_role_objet_source, libelle_original_objet_source, valeur_objet_source, fk_unite_de_mesure) VALUES (460, 1179, 37, 19, NULL, NULL, NULL, NULL, '2015-11-11 23:13:37.694065+01', NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO association_objets (pk_association_objets, fk_objet_source, fk_objet_cible, fk_type_association_param, reference_precise_objet_source, url_objet_source, descriptif, notes, date_creation, date_modification, fk_qualificatif_objet_source, fk_role_objet_source, libelle_original_objet_source, valeur_objet_source, fk_unite_de_mesure) VALUES (461, 1178, 37, 19, NULL, NULL, NULL, NULL, '2015-11-11 23:13:37.694065+01', NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO association_objets (pk_association_objets, fk_objet_source, fk_objet_cible, fk_type_association_param, reference_precise_objet_source, url_objet_source, descriptif, notes, date_creation, date_modification, fk_qualificatif_objet_source, fk_role_objet_source, libelle_original_objet_source, valeur_objet_source, fk_unite_de_mesure) VALUES (462, 1177, 37, 19, NULL, NULL, NULL, NULL, '2015-11-11 23:13:37.694065+01', NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO association_objets (pk_association_objets, fk_objet_source, fk_objet_cible, fk_type_association_param, reference_precise_objet_source, url_objet_source, descriptif, notes, date_creation, date_modification, fk_qualificatif_objet_source, fk_role_objet_source, libelle_original_objet_source, valeur_objet_source, fk_unite_de_mesure) VALUES (463, 1176, 37, 19, NULL, NULL, NULL, NULL, '2015-11-11 23:13:37.694065+01', NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO association_objets (pk_association_objets, fk_objet_source, fk_objet_cible, fk_type_association_param, reference_precise_objet_source, url_objet_source, descriptif, notes, date_creation, date_modification, fk_qualificatif_objet_source, fk_role_objet_source, libelle_original_objet_source, valeur_objet_source, fk_unite_de_mesure) VALUES (464, 1175, 37, 19, NULL, NULL, NULL, NULL, '2015-11-11 23:13:37.694065+01', NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO association_objets (pk_association_objets, fk_objet_source, fk_objet_cible, fk_type_association_param, reference_precise_objet_source, url_objet_source, descriptif, notes, date_creation, date_modification, fk_qualificatif_objet_source, fk_role_objet_source, libelle_original_objet_source, valeur_objet_source, fk_unite_de_mesure) VALUES (465, 1174, 37, 19, NULL, NULL, NULL, NULL, '2015-11-11 23:13:37.694065+01', NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO association_objets (pk_association_objets, fk_objet_source, fk_objet_cible, fk_type_association_param, reference_precise_objet_source, url_objet_source, descriptif, notes, date_creation, date_modification, fk_qualificatif_objet_source, fk_role_objet_source, libelle_original_objet_source, valeur_objet_source, fk_unite_de_mesure) VALUES (466, 1173, 37, 19, NULL, NULL, NULL, NULL, '2015-11-11 23:13:37.694065+01', NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO association_objets (pk_association_objets, fk_objet_source, fk_objet_cible, fk_type_association_param, reference_precise_objet_source, url_objet_source, descriptif, notes, date_creation, date_modification, fk_qualificatif_objet_source, fk_role_objet_source, libelle_original_objet_source, valeur_objet_source, fk_unite_de_mesure) VALUES (467, 1172, 37, 19, NULL, NULL, NULL, NULL, '2015-11-11 23:13:37.694065+01', NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO association_objets (pk_association_objets, fk_objet_source, fk_objet_cible, fk_type_association_param, reference_precise_objet_source, url_objet_source, descriptif, notes, date_creation, date_modification, fk_qualificatif_objet_source, fk_role_objet_source, libelle_original_objet_source, valeur_objet_source, fk_unite_de_mesure) VALUES (468, 1171, 37, 19, NULL, NULL, NULL, NULL, '2015-11-11 23:13:37.694065+01', NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO association_objets (pk_association_objets, fk_objet_source, fk_objet_cible, fk_type_association_param, reference_precise_objet_source, url_objet_source, descriptif, notes, date_creation, date_modification, fk_qualificatif_objet_source, fk_role_objet_source, libelle_original_objet_source, valeur_objet_source, fk_unite_de_mesure) VALUES (469, 1170, 37, 19, NULL, NULL, NULL, NULL, '2015-11-11 23:13:37.694065+01', NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO association_objets (pk_association_objets, fk_objet_source, fk_objet_cible, fk_type_association_param, reference_precise_objet_source, url_objet_source, descriptif, notes, date_creation, date_modification, fk_qualificatif_objet_source, fk_role_objet_source, libelle_original_objet_source, valeur_objet_source, fk_unite_de_mesure) VALUES (470, 1169, 37, 19, NULL, NULL, NULL, NULL, '2015-11-11 23:13:37.694065+01', NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO association_objets (pk_association_objets, fk_objet_source, fk_objet_cible, fk_type_association_param, reference_precise_objet_source, url_objet_source, descriptif, notes, date_creation, date_modification, fk_qualificatif_objet_source, fk_role_objet_source, libelle_original_objet_source, valeur_objet_source, fk_unite_de_mesure) VALUES (471, 1168, 37, 19, NULL, NULL, NULL, NULL, '2015-11-11 23:13:37.694065+01', NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO association_objets (pk_association_objets, fk_objet_source, fk_objet_cible, fk_type_association_param, reference_precise_objet_source, url_objet_source, descriptif, notes, date_creation, date_modification, fk_qualificatif_objet_source, fk_role_objet_source, libelle_original_objet_source, valeur_objet_source, fk_unite_de_mesure) VALUES (472, 1167, 37, 19, NULL, NULL, NULL, NULL, '2015-11-11 23:13:37.694065+01', NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO association_objets (pk_association_objets, fk_objet_source, fk_objet_cible, fk_type_association_param, reference_precise_objet_source, url_objet_source, descriptif, notes, date_creation, date_modification, fk_qualificatif_objet_source, fk_role_objet_source, libelle_original_objet_source, valeur_objet_source, fk_unite_de_mesure) VALUES (473, 1166, 37, 19, NULL, NULL, NULL, NULL, '2015-11-11 23:13:37.694065+01', NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO association_objets (pk_association_objets, fk_objet_source, fk_objet_cible, fk_type_association_param, reference_precise_objet_source, url_objet_source, descriptif, notes, date_creation, date_modification, fk_qualificatif_objet_source, fk_role_objet_source, libelle_original_objet_source, valeur_objet_source, fk_unite_de_mesure) VALUES (474, 1165, 37, 19, NULL, NULL, NULL, NULL, '2015-11-11 23:13:37.694065+01', NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO association_objets (pk_association_objets, fk_objet_source, fk_objet_cible, fk_type_association_param, reference_precise_objet_source, url_objet_source, descriptif, notes, date_creation, date_modification, fk_qualificatif_objet_source, fk_role_objet_source, libelle_original_objet_source, valeur_objet_source, fk_unite_de_mesure) VALUES (475, 1164, 37, 19, NULL, NULL, NULL, NULL, '2015-11-11 23:13:37.694065+01', NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO association_objets (pk_association_objets, fk_objet_source, fk_objet_cible, fk_type_association_param, reference_precise_objet_source, url_objet_source, descriptif, notes, date_creation, date_modification, fk_qualificatif_objet_source, fk_role_objet_source, libelle_original_objet_source, valeur_objet_source, fk_unite_de_mesure) VALUES (476, 1163, 37, 19, NULL, NULL, NULL, NULL, '2015-11-11 23:13:37.694065+01', NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO association_objets (pk_association_objets, fk_objet_source, fk_objet_cible, fk_type_association_param, reference_precise_objet_source, url_objet_source, descriptif, notes, date_creation, date_modification, fk_qualificatif_objet_source, fk_role_objet_source, libelle_original_objet_source, valeur_objet_source, fk_unite_de_mesure) VALUES (477, 1162, 37, 19, NULL, NULL, NULL, NULL, '2015-11-11 23:13:37.694065+01', NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO association_objets (pk_association_objets, fk_objet_source, fk_objet_cible, fk_type_association_param, reference_precise_objet_source, url_objet_source, descriptif, notes, date_creation, date_modification, fk_qualificatif_objet_source, fk_role_objet_source, libelle_original_objet_source, valeur_objet_source, fk_unite_de_mesure) VALUES (478, 1161, 37, 19, NULL, NULL, NULL, NULL, '2015-11-11 23:13:37.694065+01', NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO association_objets (pk_association_objets, fk_objet_source, fk_objet_cible, fk_type_association_param, reference_precise_objet_source, url_objet_source, descriptif, notes, date_creation, date_modification, fk_qualificatif_objet_source, fk_role_objet_source, libelle_original_objet_source, valeur_objet_source, fk_unite_de_mesure) VALUES (479, 1160, 37, 19, NULL, NULL, NULL, NULL, '2015-11-11 23:13:37.694065+01', NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO association_objets (pk_association_objets, fk_objet_source, fk_objet_cible, fk_type_association_param, reference_precise_objet_source, url_objet_source, descriptif, notes, date_creation, date_modification, fk_qualificatif_objet_source, fk_role_objet_source, libelle_original_objet_source, valeur_objet_source, fk_unite_de_mesure) VALUES (480, 1159, 37, 19, NULL, NULL, NULL, NULL, '2015-11-11 23:13:37.694065+01', NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO association_objets (pk_association_objets, fk_objet_source, fk_objet_cible, fk_type_association_param, reference_precise_objet_source, url_objet_source, descriptif, notes, date_creation, date_modification, fk_qualificatif_objet_source, fk_role_objet_source, libelle_original_objet_source, valeur_objet_source, fk_unite_de_mesure) VALUES (481, 1158, 37, 19, NULL, NULL, NULL, NULL, '2015-11-11 23:13:37.694065+01', NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO association_objets (pk_association_objets, fk_objet_source, fk_objet_cible, fk_type_association_param, reference_precise_objet_source, url_objet_source, descriptif, notes, date_creation, date_modification, fk_qualificatif_objet_source, fk_role_objet_source, libelle_original_objet_source, valeur_objet_source, fk_unite_de_mesure) VALUES (482, 1157, 37, 19, NULL, NULL, NULL, NULL, '2015-11-11 23:13:37.694065+01', NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO association_objets (pk_association_objets, fk_objet_source, fk_objet_cible, fk_type_association_param, reference_precise_objet_source, url_objet_source, descriptif, notes, date_creation, date_modification, fk_qualificatif_objet_source, fk_role_objet_source, libelle_original_objet_source, valeur_objet_source, fk_unite_de_mesure) VALUES (483, 1156, 37, 19, NULL, NULL, NULL, NULL, '2015-11-11 23:13:37.694065+01', NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO association_objets (pk_association_objets, fk_objet_source, fk_objet_cible, fk_type_association_param, reference_precise_objet_source, url_objet_source, descriptif, notes, date_creation, date_modification, fk_qualificatif_objet_source, fk_role_objet_source, libelle_original_objet_source, valeur_objet_source, fk_unite_de_mesure) VALUES (484, 1155, 37, 19, NULL, NULL, NULL, NULL, '2015-11-11 23:13:37.694065+01', NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO association_objets (pk_association_objets, fk_objet_source, fk_objet_cible, fk_type_association_param, reference_precise_objet_source, url_objet_source, descriptif, notes, date_creation, date_modification, fk_qualificatif_objet_source, fk_role_objet_source, libelle_original_objet_source, valeur_objet_source, fk_unite_de_mesure) VALUES (485, 1154, 37, 19, NULL, NULL, NULL, NULL, '2015-11-11 23:13:37.694065+01', NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO association_objets (pk_association_objets, fk_objet_source, fk_objet_cible, fk_type_association_param, reference_precise_objet_source, url_objet_source, descriptif, notes, date_creation, date_modification, fk_qualificatif_objet_source, fk_role_objet_source, libelle_original_objet_source, valeur_objet_source, fk_unite_de_mesure) VALUES (486, 1153, 37, 19, NULL, NULL, NULL, NULL, '2015-11-11 23:13:37.694065+01', NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO association_objets (pk_association_objets, fk_objet_source, fk_objet_cible, fk_type_association_param, reference_precise_objet_source, url_objet_source, descriptif, notes, date_creation, date_modification, fk_qualificatif_objet_source, fk_role_objet_source, libelle_original_objet_source, valeur_objet_source, fk_unite_de_mesure) VALUES (487, 1152, 37, 19, NULL, NULL, NULL, NULL, '2015-11-11 23:13:37.694065+01', NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO association_objets (pk_association_objets, fk_objet_source, fk_objet_cible, fk_type_association_param, reference_precise_objet_source, url_objet_source, descriptif, notes, date_creation, date_modification, fk_qualificatif_objet_source, fk_role_objet_source, libelle_original_objet_source, valeur_objet_source, fk_unite_de_mesure) VALUES (488, 1151, 37, 19, NULL, NULL, NULL, NULL, '2015-11-11 23:13:37.694065+01', NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO association_objets (pk_association_objets, fk_objet_source, fk_objet_cible, fk_type_association_param, reference_precise_objet_source, url_objet_source, descriptif, notes, date_creation, date_modification, fk_qualificatif_objet_source, fk_role_objet_source, libelle_original_objet_source, valeur_objet_source, fk_unite_de_mesure) VALUES (489, 1150, 37, 19, NULL, NULL, NULL, NULL, '2015-11-11 23:13:37.694065+01', NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO association_objets (pk_association_objets, fk_objet_source, fk_objet_cible, fk_type_association_param, reference_precise_objet_source, url_objet_source, descriptif, notes, date_creation, date_modification, fk_qualificatif_objet_source, fk_role_objet_source, libelle_original_objet_source, valeur_objet_source, fk_unite_de_mesure) VALUES (490, 1149, 37, 19, NULL, NULL, NULL, NULL, '2015-11-11 23:13:37.694065+01', NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO association_objets (pk_association_objets, fk_objet_source, fk_objet_cible, fk_type_association_param, reference_precise_objet_source, url_objet_source, descriptif, notes, date_creation, date_modification, fk_qualificatif_objet_source, fk_role_objet_source, libelle_original_objet_source, valeur_objet_source, fk_unite_de_mesure) VALUES (491, 1148, 37, 19, NULL, NULL, NULL, NULL, '2015-11-11 23:13:37.694065+01', NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO association_objets (pk_association_objets, fk_objet_source, fk_objet_cible, fk_type_association_param, reference_precise_objet_source, url_objet_source, descriptif, notes, date_creation, date_modification, fk_qualificatif_objet_source, fk_role_objet_source, libelle_original_objet_source, valeur_objet_source, fk_unite_de_mesure) VALUES (492, 1147, 37, 19, NULL, NULL, NULL, NULL, '2015-11-11 23:13:37.694065+01', NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO association_objets (pk_association_objets, fk_objet_source, fk_objet_cible, fk_type_association_param, reference_precise_objet_source, url_objet_source, descriptif, notes, date_creation, date_modification, fk_qualificatif_objet_source, fk_role_objet_source, libelle_original_objet_source, valeur_objet_source, fk_unite_de_mesure) VALUES (493, 1146, 37, 19, NULL, NULL, NULL, NULL, '2015-11-11 23:13:37.694065+01', NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO association_objets (pk_association_objets, fk_objet_source, fk_objet_cible, fk_type_association_param, reference_precise_objet_source, url_objet_source, descriptif, notes, date_creation, date_modification, fk_qualificatif_objet_source, fk_role_objet_source, libelle_original_objet_source, valeur_objet_source, fk_unite_de_mesure) VALUES (494, 1145, 37, 19, NULL, NULL, NULL, NULL, '2015-11-11 23:13:37.694065+01', NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO association_objets (pk_association_objets, fk_objet_source, fk_objet_cible, fk_type_association_param, reference_precise_objet_source, url_objet_source, descriptif, notes, date_creation, date_modification, fk_qualificatif_objet_source, fk_role_objet_source, libelle_original_objet_source, valeur_objet_source, fk_unite_de_mesure) VALUES (495, 1144, 37, 19, NULL, NULL, NULL, NULL, '2015-11-11 23:13:37.694065+01', NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO association_objets (pk_association_objets, fk_objet_source, fk_objet_cible, fk_type_association_param, reference_precise_objet_source, url_objet_source, descriptif, notes, date_creation, date_modification, fk_qualificatif_objet_source, fk_role_objet_source, libelle_original_objet_source, valeur_objet_source, fk_unite_de_mesure) VALUES (496, 1143, 37, 19, NULL, NULL, NULL, NULL, '2015-11-11 23:13:37.694065+01', NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO association_objets (pk_association_objets, fk_objet_source, fk_objet_cible, fk_type_association_param, reference_precise_objet_source, url_objet_source, descriptif, notes, date_creation, date_modification, fk_qualificatif_objet_source, fk_role_objet_source, libelle_original_objet_source, valeur_objet_source, fk_unite_de_mesure) VALUES (497, 1142, 37, 19, NULL, NULL, NULL, NULL, '2015-11-11 23:13:37.694065+01', NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO association_objets (pk_association_objets, fk_objet_source, fk_objet_cible, fk_type_association_param, reference_precise_objet_source, url_objet_source, descriptif, notes, date_creation, date_modification, fk_qualificatif_objet_source, fk_role_objet_source, libelle_original_objet_source, valeur_objet_source, fk_unite_de_mesure) VALUES (498, 1141, 37, 19, NULL, NULL, NULL, NULL, '2015-11-11 23:13:37.694065+01', NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO association_objets (pk_association_objets, fk_objet_source, fk_objet_cible, fk_type_association_param, reference_precise_objet_source, url_objet_source, descriptif, notes, date_creation, date_modification, fk_qualificatif_objet_source, fk_role_objet_source, libelle_original_objet_source, valeur_objet_source, fk_unite_de_mesure) VALUES (499, 1140, 37, 19, NULL, NULL, NULL, NULL, '2015-11-11 23:13:37.694065+01', NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO association_objets (pk_association_objets, fk_objet_source, fk_objet_cible, fk_type_association_param, reference_precise_objet_source, url_objet_source, descriptif, notes, date_creation, date_modification, fk_qualificatif_objet_source, fk_role_objet_source, libelle_original_objet_source, valeur_objet_source, fk_unite_de_mesure) VALUES (500, 1139, 37, 19, NULL, NULL, NULL, NULL, '2015-11-11 23:13:37.694065+01', NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO association_objets (pk_association_objets, fk_objet_source, fk_objet_cible, fk_type_association_param, reference_precise_objet_source, url_objet_source, descriptif, notes, date_creation, date_modification, fk_qualificatif_objet_source, fk_role_objet_source, libelle_original_objet_source, valeur_objet_source, fk_unite_de_mesure) VALUES (501, 1138, 37, 19, NULL, NULL, NULL, NULL, '2015-11-11 23:13:37.694065+01', NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO association_objets (pk_association_objets, fk_objet_source, fk_objet_cible, fk_type_association_param, reference_precise_objet_source, url_objet_source, descriptif, notes, date_creation, date_modification, fk_qualificatif_objet_source, fk_role_objet_source, libelle_original_objet_source, valeur_objet_source, fk_unite_de_mesure) VALUES (502, 1137, 37, 19, NULL, NULL, NULL, NULL, '2015-11-11 23:13:37.694065+01', NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO association_objets (pk_association_objets, fk_objet_source, fk_objet_cible, fk_type_association_param, reference_precise_objet_source, url_objet_source, descriptif, notes, date_creation, date_modification, fk_qualificatif_objet_source, fk_role_objet_source, libelle_original_objet_source, valeur_objet_source, fk_unite_de_mesure) VALUES (503, 1136, 37, 19, NULL, NULL, NULL, NULL, '2015-11-11 23:13:37.694065+01', NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO association_objets (pk_association_objets, fk_objet_source, fk_objet_cible, fk_type_association_param, reference_precise_objet_source, url_objet_source, descriptif, notes, date_creation, date_modification, fk_qualificatif_objet_source, fk_role_objet_source, libelle_original_objet_source, valeur_objet_source, fk_unite_de_mesure) VALUES (504, 1135, 37, 19, NULL, NULL, NULL, NULL, '2015-11-11 23:13:37.694065+01', NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO association_objets (pk_association_objets, fk_objet_source, fk_objet_cible, fk_type_association_param, reference_precise_objet_source, url_objet_source, descriptif, notes, date_creation, date_modification, fk_qualificatif_objet_source, fk_role_objet_source, libelle_original_objet_source, valeur_objet_source, fk_unite_de_mesure) VALUES (505, 1134, 37, 19, NULL, NULL, NULL, NULL, '2015-11-11 23:13:37.694065+01', NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO association_objets (pk_association_objets, fk_objet_source, fk_objet_cible, fk_type_association_param, reference_precise_objet_source, url_objet_source, descriptif, notes, date_creation, date_modification, fk_qualificatif_objet_source, fk_role_objet_source, libelle_original_objet_source, valeur_objet_source, fk_unite_de_mesure) VALUES (506, 1133, 37, 19, NULL, NULL, NULL, NULL, '2015-11-11 23:13:37.694065+01', NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO association_objets (pk_association_objets, fk_objet_source, fk_objet_cible, fk_type_association_param, reference_precise_objet_source, url_objet_source, descriptif, notes, date_creation, date_modification, fk_qualificatif_objet_source, fk_role_objet_source, libelle_original_objet_source, valeur_objet_source, fk_unite_de_mesure) VALUES (507, 1132, 37, 19, NULL, NULL, NULL, NULL, '2015-11-11 23:13:37.694065+01', NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO association_objets (pk_association_objets, fk_objet_source, fk_objet_cible, fk_type_association_param, reference_precise_objet_source, url_objet_source, descriptif, notes, date_creation, date_modification, fk_qualificatif_objet_source, fk_role_objet_source, libelle_original_objet_source, valeur_objet_source, fk_unite_de_mesure) VALUES (508, 1131, 37, 19, NULL, NULL, NULL, NULL, '2015-11-11 23:13:37.694065+01', NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO association_objets (pk_association_objets, fk_objet_source, fk_objet_cible, fk_type_association_param, reference_precise_objet_source, url_objet_source, descriptif, notes, date_creation, date_modification, fk_qualificatif_objet_source, fk_role_objet_source, libelle_original_objet_source, valeur_objet_source, fk_unite_de_mesure) VALUES (509, 1130, 37, 19, NULL, NULL, NULL, NULL, '2015-11-11 23:13:37.694065+01', NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO association_objets (pk_association_objets, fk_objet_source, fk_objet_cible, fk_type_association_param, reference_precise_objet_source, url_objet_source, descriptif, notes, date_creation, date_modification, fk_qualificatif_objet_source, fk_role_objet_source, libelle_original_objet_source, valeur_objet_source, fk_unite_de_mesure) VALUES (510, 1129, 37, 19, NULL, NULL, NULL, NULL, '2015-11-11 23:13:37.694065+01', NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO association_objets (pk_association_objets, fk_objet_source, fk_objet_cible, fk_type_association_param, reference_precise_objet_source, url_objet_source, descriptif, notes, date_creation, date_modification, fk_qualificatif_objet_source, fk_role_objet_source, libelle_original_objet_source, valeur_objet_source, fk_unite_de_mesure) VALUES (511, 1128, 37, 19, NULL, NULL, NULL, NULL, '2015-11-11 23:13:37.694065+01', NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO association_objets (pk_association_objets, fk_objet_source, fk_objet_cible, fk_type_association_param, reference_precise_objet_source, url_objet_source, descriptif, notes, date_creation, date_modification, fk_qualificatif_objet_source, fk_role_objet_source, libelle_original_objet_source, valeur_objet_source, fk_unite_de_mesure) VALUES (512, 1127, 37, 19, NULL, NULL, NULL, NULL, '2015-11-11 23:13:37.694065+01', NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO association_objets (pk_association_objets, fk_objet_source, fk_objet_cible, fk_type_association_param, reference_precise_objet_source, url_objet_source, descriptif, notes, date_creation, date_modification, fk_qualificatif_objet_source, fk_role_objet_source, libelle_original_objet_source, valeur_objet_source, fk_unite_de_mesure) VALUES (513, 1126, 37, 19, NULL, NULL, NULL, NULL, '2015-11-11 23:13:37.694065+01', NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO association_objets (pk_association_objets, fk_objet_source, fk_objet_cible, fk_type_association_param, reference_precise_objet_source, url_objet_source, descriptif, notes, date_creation, date_modification, fk_qualificatif_objet_source, fk_role_objet_source, libelle_original_objet_source, valeur_objet_source, fk_unite_de_mesure) VALUES (514, 1125, 37, 19, NULL, NULL, NULL, NULL, '2015-11-11 23:13:37.694065+01', NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO association_objets (pk_association_objets, fk_objet_source, fk_objet_cible, fk_type_association_param, reference_precise_objet_source, url_objet_source, descriptif, notes, date_creation, date_modification, fk_qualificatif_objet_source, fk_role_objet_source, libelle_original_objet_source, valeur_objet_source, fk_unite_de_mesure) VALUES (515, 1124, 37, 19, NULL, NULL, NULL, NULL, '2015-11-11 23:13:37.694065+01', NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO association_objets (pk_association_objets, fk_objet_source, fk_objet_cible, fk_type_association_param, reference_precise_objet_source, url_objet_source, descriptif, notes, date_creation, date_modification, fk_qualificatif_objet_source, fk_role_objet_source, libelle_original_objet_source, valeur_objet_source, fk_unite_de_mesure) VALUES (516, 1123, 37, 19, NULL, NULL, NULL, NULL, '2015-11-11 23:13:37.694065+01', NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO association_objets (pk_association_objets, fk_objet_source, fk_objet_cible, fk_type_association_param, reference_precise_objet_source, url_objet_source, descriptif, notes, date_creation, date_modification, fk_qualificatif_objet_source, fk_role_objet_source, libelle_original_objet_source, valeur_objet_source, fk_unite_de_mesure) VALUES (517, 1122, 37, 19, NULL, NULL, NULL, NULL, '2015-11-11 23:13:37.694065+01', NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO association_objets (pk_association_objets, fk_objet_source, fk_objet_cible, fk_type_association_param, reference_precise_objet_source, url_objet_source, descriptif, notes, date_creation, date_modification, fk_qualificatif_objet_source, fk_role_objet_source, libelle_original_objet_source, valeur_objet_source, fk_unite_de_mesure) VALUES (518, 1121, 37, 19, NULL, NULL, NULL, NULL, '2015-11-11 23:13:37.694065+01', NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO association_objets (pk_association_objets, fk_objet_source, fk_objet_cible, fk_type_association_param, reference_precise_objet_source, url_objet_source, descriptif, notes, date_creation, date_modification, fk_qualificatif_objet_source, fk_role_objet_source, libelle_original_objet_source, valeur_objet_source, fk_unite_de_mesure) VALUES (519, 1120, 37, 19, NULL, NULL, NULL, NULL, '2015-11-11 23:13:37.694065+01', NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO association_objets (pk_association_objets, fk_objet_source, fk_objet_cible, fk_type_association_param, reference_precise_objet_source, url_objet_source, descriptif, notes, date_creation, date_modification, fk_qualificatif_objet_source, fk_role_objet_source, libelle_original_objet_source, valeur_objet_source, fk_unite_de_mesure) VALUES (520, 1119, 37, 19, NULL, NULL, NULL, NULL, '2015-11-11 23:13:37.694065+01', NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO association_objets (pk_association_objets, fk_objet_source, fk_objet_cible, fk_type_association_param, reference_precise_objet_source, url_objet_source, descriptif, notes, date_creation, date_modification, fk_qualificatif_objet_source, fk_role_objet_source, libelle_original_objet_source, valeur_objet_source, fk_unite_de_mesure) VALUES (521, 1118, 37, 19, NULL, NULL, NULL, NULL, '2015-11-11 23:13:37.694065+01', NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO association_objets (pk_association_objets, fk_objet_source, fk_objet_cible, fk_type_association_param, reference_precise_objet_source, url_objet_source, descriptif, notes, date_creation, date_modification, fk_qualificatif_objet_source, fk_role_objet_source, libelle_original_objet_source, valeur_objet_source, fk_unite_de_mesure) VALUES (522, 1117, 37, 19, NULL, NULL, NULL, NULL, '2015-11-11 23:13:37.694065+01', NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO association_objets (pk_association_objets, fk_objet_source, fk_objet_cible, fk_type_association_param, reference_precise_objet_source, url_objet_source, descriptif, notes, date_creation, date_modification, fk_qualificatif_objet_source, fk_role_objet_source, libelle_original_objet_source, valeur_objet_source, fk_unite_de_mesure) VALUES (523, 1116, 37, 19, NULL, NULL, NULL, NULL, '2015-11-11 23:13:37.694065+01', NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO association_objets (pk_association_objets, fk_objet_source, fk_objet_cible, fk_type_association_param, reference_precise_objet_source, url_objet_source, descriptif, notes, date_creation, date_modification, fk_qualificatif_objet_source, fk_role_objet_source, libelle_original_objet_source, valeur_objet_source, fk_unite_de_mesure) VALUES (524, 1115, 37, 19, NULL, NULL, NULL, NULL, '2015-11-11 23:13:37.694065+01', NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO association_objets (pk_association_objets, fk_objet_source, fk_objet_cible, fk_type_association_param, reference_precise_objet_source, url_objet_source, descriptif, notes, date_creation, date_modification, fk_qualificatif_objet_source, fk_role_objet_source, libelle_original_objet_source, valeur_objet_source, fk_unite_de_mesure) VALUES (525, 1114, 37, 19, NULL, NULL, NULL, NULL, '2015-11-11 23:13:37.694065+01', NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO association_objets (pk_association_objets, fk_objet_source, fk_objet_cible, fk_type_association_param, reference_precise_objet_source, url_objet_source, descriptif, notes, date_creation, date_modification, fk_qualificatif_objet_source, fk_role_objet_source, libelle_original_objet_source, valeur_objet_source, fk_unite_de_mesure) VALUES (526, 1113, 37, 19, NULL, NULL, NULL, NULL, '2015-11-11 23:13:37.694065+01', NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO association_objets (pk_association_objets, fk_objet_source, fk_objet_cible, fk_type_association_param, reference_precise_objet_source, url_objet_source, descriptif, notes, date_creation, date_modification, fk_qualificatif_objet_source, fk_role_objet_source, libelle_original_objet_source, valeur_objet_source, fk_unite_de_mesure) VALUES (527, 1112, 37, 19, NULL, NULL, NULL, NULL, '2015-11-11 23:13:37.694065+01', NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO association_objets (pk_association_objets, fk_objet_source, fk_objet_cible, fk_type_association_param, reference_precise_objet_source, url_objet_source, descriptif, notes, date_creation, date_modification, fk_qualificatif_objet_source, fk_role_objet_source, libelle_original_objet_source, valeur_objet_source, fk_unite_de_mesure) VALUES (528, 1111, 37, 19, NULL, NULL, NULL, NULL, '2015-11-11 23:13:37.694065+01', NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO association_objets (pk_association_objets, fk_objet_source, fk_objet_cible, fk_type_association_param, reference_precise_objet_source, url_objet_source, descriptif, notes, date_creation, date_modification, fk_qualificatif_objet_source, fk_role_objet_source, libelle_original_objet_source, valeur_objet_source, fk_unite_de_mesure) VALUES (529, 1110, 37, 19, NULL, NULL, NULL, NULL, '2015-11-11 23:13:37.694065+01', NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO association_objets (pk_association_objets, fk_objet_source, fk_objet_cible, fk_type_association_param, reference_precise_objet_source, url_objet_source, descriptif, notes, date_creation, date_modification, fk_qualificatif_objet_source, fk_role_objet_source, libelle_original_objet_source, valeur_objet_source, fk_unite_de_mesure) VALUES (530, 1109, 37, 19, NULL, NULL, NULL, NULL, '2015-11-11 23:13:37.694065+01', NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO association_objets (pk_association_objets, fk_objet_source, fk_objet_cible, fk_type_association_param, reference_precise_objet_source, url_objet_source, descriptif, notes, date_creation, date_modification, fk_qualificatif_objet_source, fk_role_objet_source, libelle_original_objet_source, valeur_objet_source, fk_unite_de_mesure) VALUES (531, 1108, 37, 19, NULL, NULL, NULL, NULL, '2015-11-11 23:13:37.694065+01', NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO association_objets (pk_association_objets, fk_objet_source, fk_objet_cible, fk_type_association_param, reference_precise_objet_source, url_objet_source, descriptif, notes, date_creation, date_modification, fk_qualificatif_objet_source, fk_role_objet_source, libelle_original_objet_source, valeur_objet_source, fk_unite_de_mesure) VALUES (532, 1107, 37, 19, NULL, NULL, NULL, NULL, '2015-11-11 23:13:37.694065+01', NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO association_objets (pk_association_objets, fk_objet_source, fk_objet_cible, fk_type_association_param, reference_precise_objet_source, url_objet_source, descriptif, notes, date_creation, date_modification, fk_qualificatif_objet_source, fk_role_objet_source, libelle_original_objet_source, valeur_objet_source, fk_unite_de_mesure) VALUES (533, 1106, 37, 19, NULL, NULL, NULL, NULL, '2015-11-11 23:13:37.694065+01', NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO association_objets (pk_association_objets, fk_objet_source, fk_objet_cible, fk_type_association_param, reference_precise_objet_source, url_objet_source, descriptif, notes, date_creation, date_modification, fk_qualificatif_objet_source, fk_role_objet_source, libelle_original_objet_source, valeur_objet_source, fk_unite_de_mesure) VALUES (534, 1105, 37, 19, NULL, NULL, NULL, NULL, '2015-11-11 23:13:37.694065+01', NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO association_objets (pk_association_objets, fk_objet_source, fk_objet_cible, fk_type_association_param, reference_precise_objet_source, url_objet_source, descriptif, notes, date_creation, date_modification, fk_qualificatif_objet_source, fk_role_objet_source, libelle_original_objet_source, valeur_objet_source, fk_unite_de_mesure) VALUES (535, 1104, 37, 19, NULL, NULL, NULL, NULL, '2015-11-11 23:13:37.694065+01', NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO association_objets (pk_association_objets, fk_objet_source, fk_objet_cible, fk_type_association_param, reference_precise_objet_source, url_objet_source, descriptif, notes, date_creation, date_modification, fk_qualificatif_objet_source, fk_role_objet_source, libelle_original_objet_source, valeur_objet_source, fk_unite_de_mesure) VALUES (536, 1103, 37, 19, NULL, NULL, NULL, NULL, '2015-11-11 23:13:37.694065+01', NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO association_objets (pk_association_objets, fk_objet_source, fk_objet_cible, fk_type_association_param, reference_precise_objet_source, url_objet_source, descriptif, notes, date_creation, date_modification, fk_qualificatif_objet_source, fk_role_objet_source, libelle_original_objet_source, valeur_objet_source, fk_unite_de_mesure) VALUES (537, 1102, 37, 19, NULL, NULL, NULL, NULL, '2015-11-11 23:13:37.694065+01', NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO association_objets (pk_association_objets, fk_objet_source, fk_objet_cible, fk_type_association_param, reference_precise_objet_source, url_objet_source, descriptif, notes, date_creation, date_modification, fk_qualificatif_objet_source, fk_role_objet_source, libelle_original_objet_source, valeur_objet_source, fk_unite_de_mesure) VALUES (538, 1101, 37, 19, NULL, NULL, NULL, NULL, '2015-11-11 23:13:37.694065+01', NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO association_objets (pk_association_objets, fk_objet_source, fk_objet_cible, fk_type_association_param, reference_precise_objet_source, url_objet_source, descriptif, notes, date_creation, date_modification, fk_qualificatif_objet_source, fk_role_objet_source, libelle_original_objet_source, valeur_objet_source, fk_unite_de_mesure) VALUES (539, 1100, 37, 19, NULL, NULL, NULL, NULL, '2015-11-11 23:13:37.694065+01', NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO association_objets (pk_association_objets, fk_objet_source, fk_objet_cible, fk_type_association_param, reference_precise_objet_source, url_objet_source, descriptif, notes, date_creation, date_modification, fk_qualificatif_objet_source, fk_role_objet_source, libelle_original_objet_source, valeur_objet_source, fk_unite_de_mesure) VALUES (540, 1099, 37, 19, NULL, NULL, NULL, NULL, '2015-11-11 23:13:37.694065+01', NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO association_objets (pk_association_objets, fk_objet_source, fk_objet_cible, fk_type_association_param, reference_precise_objet_source, url_objet_source, descriptif, notes, date_creation, date_modification, fk_qualificatif_objet_source, fk_role_objet_source, libelle_original_objet_source, valeur_objet_source, fk_unite_de_mesure) VALUES (541, 1098, 37, 19, NULL, NULL, NULL, NULL, '2015-11-11 23:13:37.694065+01', NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO association_objets (pk_association_objets, fk_objet_source, fk_objet_cible, fk_type_association_param, reference_precise_objet_source, url_objet_source, descriptif, notes, date_creation, date_modification, fk_qualificatif_objet_source, fk_role_objet_source, libelle_original_objet_source, valeur_objet_source, fk_unite_de_mesure) VALUES (542, 1097, 37, 19, NULL, NULL, NULL, NULL, '2015-11-11 23:13:37.694065+01', NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO association_objets (pk_association_objets, fk_objet_source, fk_objet_cible, fk_type_association_param, reference_precise_objet_source, url_objet_source, descriptif, notes, date_creation, date_modification, fk_qualificatif_objet_source, fk_role_objet_source, libelle_original_objet_source, valeur_objet_source, fk_unite_de_mesure) VALUES (543, 1096, 37, 19, NULL, NULL, NULL, NULL, '2015-11-11 23:13:37.694065+01', NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO association_objets (pk_association_objets, fk_objet_source, fk_objet_cible, fk_type_association_param, reference_precise_objet_source, url_objet_source, descriptif, notes, date_creation, date_modification, fk_qualificatif_objet_source, fk_role_objet_source, libelle_original_objet_source, valeur_objet_source, fk_unite_de_mesure) VALUES (544, 1095, 37, 19, NULL, NULL, NULL, NULL, '2015-11-11 23:13:37.694065+01', NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO association_objets (pk_association_objets, fk_objet_source, fk_objet_cible, fk_type_association_param, reference_precise_objet_source, url_objet_source, descriptif, notes, date_creation, date_modification, fk_qualificatif_objet_source, fk_role_objet_source, libelle_original_objet_source, valeur_objet_source, fk_unite_de_mesure) VALUES (545, 1094, 37, 19, NULL, NULL, NULL, NULL, '2015-11-11 23:13:37.694065+01', NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO association_objets (pk_association_objets, fk_objet_source, fk_objet_cible, fk_type_association_param, reference_precise_objet_source, url_objet_source, descriptif, notes, date_creation, date_modification, fk_qualificatif_objet_source, fk_role_objet_source, libelle_original_objet_source, valeur_objet_source, fk_unite_de_mesure) VALUES (546, 1093, 37, 19, NULL, NULL, NULL, NULL, '2015-11-11 23:13:37.694065+01', NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO association_objets (pk_association_objets, fk_objet_source, fk_objet_cible, fk_type_association_param, reference_precise_objet_source, url_objet_source, descriptif, notes, date_creation, date_modification, fk_qualificatif_objet_source, fk_role_objet_source, libelle_original_objet_source, valeur_objet_source, fk_unite_de_mesure) VALUES (547, 1092, 37, 19, NULL, NULL, NULL, NULL, '2015-11-11 23:13:37.694065+01', NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO association_objets (pk_association_objets, fk_objet_source, fk_objet_cible, fk_type_association_param, reference_precise_objet_source, url_objet_source, descriptif, notes, date_creation, date_modification, fk_qualificatif_objet_source, fk_role_objet_source, libelle_original_objet_source, valeur_objet_source, fk_unite_de_mesure) VALUES (548, 1091, 37, 19, NULL, NULL, NULL, NULL, '2015-11-11 23:13:37.694065+01', NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO association_objets (pk_association_objets, fk_objet_source, fk_objet_cible, fk_type_association_param, reference_precise_objet_source, url_objet_source, descriptif, notes, date_creation, date_modification, fk_qualificatif_objet_source, fk_role_objet_source, libelle_original_objet_source, valeur_objet_source, fk_unite_de_mesure) VALUES (549, 1090, 37, 19, NULL, NULL, NULL, NULL, '2015-11-11 23:13:37.694065+01', NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO association_objets (pk_association_objets, fk_objet_source, fk_objet_cible, fk_type_association_param, reference_precise_objet_source, url_objet_source, descriptif, notes, date_creation, date_modification, fk_qualificatif_objet_source, fk_role_objet_source, libelle_original_objet_source, valeur_objet_source, fk_unite_de_mesure) VALUES (550, 1089, 37, 19, NULL, NULL, NULL, NULL, '2015-11-11 23:13:37.694065+01', NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO association_objets (pk_association_objets, fk_objet_source, fk_objet_cible, fk_type_association_param, reference_precise_objet_source, url_objet_source, descriptif, notes, date_creation, date_modification, fk_qualificatif_objet_source, fk_role_objet_source, libelle_original_objet_source, valeur_objet_source, fk_unite_de_mesure) VALUES (551, 1088, 37, 19, NULL, NULL, NULL, NULL, '2015-11-11 23:13:37.694065+01', NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO association_objets (pk_association_objets, fk_objet_source, fk_objet_cible, fk_type_association_param, reference_precise_objet_source, url_objet_source, descriptif, notes, date_creation, date_modification, fk_qualificatif_objet_source, fk_role_objet_source, libelle_original_objet_source, valeur_objet_source, fk_unite_de_mesure) VALUES (552, 1087, 37, 19, NULL, NULL, NULL, NULL, '2015-11-11 23:13:37.694065+01', NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO association_objets (pk_association_objets, fk_objet_source, fk_objet_cible, fk_type_association_param, reference_precise_objet_source, url_objet_source, descriptif, notes, date_creation, date_modification, fk_qualificatif_objet_source, fk_role_objet_source, libelle_original_objet_source, valeur_objet_source, fk_unite_de_mesure) VALUES (553, 1086, 37, 19, NULL, NULL, NULL, NULL, '2015-11-11 23:13:37.694065+01', NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO association_objets (pk_association_objets, fk_objet_source, fk_objet_cible, fk_type_association_param, reference_precise_objet_source, url_objet_source, descriptif, notes, date_creation, date_modification, fk_qualificatif_objet_source, fk_role_objet_source, libelle_original_objet_source, valeur_objet_source, fk_unite_de_mesure) VALUES (554, 1085, 37, 19, NULL, NULL, NULL, NULL, '2015-11-11 23:13:37.694065+01', NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO association_objets (pk_association_objets, fk_objet_source, fk_objet_cible, fk_type_association_param, reference_precise_objet_source, url_objet_source, descriptif, notes, date_creation, date_modification, fk_qualificatif_objet_source, fk_role_objet_source, libelle_original_objet_source, valeur_objet_source, fk_unite_de_mesure) VALUES (555, 1084, 37, 19, NULL, NULL, NULL, NULL, '2015-11-11 23:13:37.694065+01', NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO association_objets (pk_association_objets, fk_objet_source, fk_objet_cible, fk_type_association_param, reference_precise_objet_source, url_objet_source, descriptif, notes, date_creation, date_modification, fk_qualificatif_objet_source, fk_role_objet_source, libelle_original_objet_source, valeur_objet_source, fk_unite_de_mesure) VALUES (556, 1083, 37, 19, NULL, NULL, NULL, NULL, '2015-11-11 23:13:37.694065+01', NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO association_objets (pk_association_objets, fk_objet_source, fk_objet_cible, fk_type_association_param, reference_precise_objet_source, url_objet_source, descriptif, notes, date_creation, date_modification, fk_qualificatif_objet_source, fk_role_objet_source, libelle_original_objet_source, valeur_objet_source, fk_unite_de_mesure) VALUES (557, 1082, 37, 19, NULL, NULL, NULL, NULL, '2015-11-11 23:13:37.694065+01', NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO association_objets (pk_association_objets, fk_objet_source, fk_objet_cible, fk_type_association_param, reference_precise_objet_source, url_objet_source, descriptif, notes, date_creation, date_modification, fk_qualificatif_objet_source, fk_role_objet_source, libelle_original_objet_source, valeur_objet_source, fk_unite_de_mesure) VALUES (558, 1081, 37, 19, NULL, NULL, NULL, NULL, '2015-11-11 23:13:37.694065+01', NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO association_objets (pk_association_objets, fk_objet_source, fk_objet_cible, fk_type_association_param, reference_precise_objet_source, url_objet_source, descriptif, notes, date_creation, date_modification, fk_qualificatif_objet_source, fk_role_objet_source, libelle_original_objet_source, valeur_objet_source, fk_unite_de_mesure) VALUES (559, 1080, 37, 19, NULL, NULL, NULL, NULL, '2015-11-11 23:13:37.694065+01', NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO association_objets (pk_association_objets, fk_objet_source, fk_objet_cible, fk_type_association_param, reference_precise_objet_source, url_objet_source, descriptif, notes, date_creation, date_modification, fk_qualificatif_objet_source, fk_role_objet_source, libelle_original_objet_source, valeur_objet_source, fk_unite_de_mesure) VALUES (560, 1079, 37, 19, NULL, NULL, NULL, NULL, '2015-11-11 23:13:37.694065+01', NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO association_objets (pk_association_objets, fk_objet_source, fk_objet_cible, fk_type_association_param, reference_precise_objet_source, url_objet_source, descriptif, notes, date_creation, date_modification, fk_qualificatif_objet_source, fk_role_objet_source, libelle_original_objet_source, valeur_objet_source, fk_unite_de_mesure) VALUES (561, 1078, 37, 19, NULL, NULL, NULL, NULL, '2015-11-11 23:13:37.694065+01', NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO association_objets (pk_association_objets, fk_objet_source, fk_objet_cible, fk_type_association_param, reference_precise_objet_source, url_objet_source, descriptif, notes, date_creation, date_modification, fk_qualificatif_objet_source, fk_role_objet_source, libelle_original_objet_source, valeur_objet_source, fk_unite_de_mesure) VALUES (562, 1077, 37, 19, NULL, NULL, NULL, NULL, '2015-11-11 23:13:37.694065+01', NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO association_objets (pk_association_objets, fk_objet_source, fk_objet_cible, fk_type_association_param, reference_precise_objet_source, url_objet_source, descriptif, notes, date_creation, date_modification, fk_qualificatif_objet_source, fk_role_objet_source, libelle_original_objet_source, valeur_objet_source, fk_unite_de_mesure) VALUES (563, 1076, 37, 19, NULL, NULL, NULL, NULL, '2015-11-11 23:13:37.694065+01', NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO association_objets (pk_association_objets, fk_objet_source, fk_objet_cible, fk_type_association_param, reference_precise_objet_source, url_objet_source, descriptif, notes, date_creation, date_modification, fk_qualificatif_objet_source, fk_role_objet_source, libelle_original_objet_source, valeur_objet_source, fk_unite_de_mesure) VALUES (564, 1075, 37, 19, NULL, NULL, NULL, NULL, '2015-11-11 23:13:37.694065+01', NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO association_objets (pk_association_objets, fk_objet_source, fk_objet_cible, fk_type_association_param, reference_precise_objet_source, url_objet_source, descriptif, notes, date_creation, date_modification, fk_qualificatif_objet_source, fk_role_objet_source, libelle_original_objet_source, valeur_objet_source, fk_unite_de_mesure) VALUES (565, 1074, 37, 19, NULL, NULL, NULL, NULL, '2015-11-11 23:13:37.694065+01', NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO association_objets (pk_association_objets, fk_objet_source, fk_objet_cible, fk_type_association_param, reference_precise_objet_source, url_objet_source, descriptif, notes, date_creation, date_modification, fk_qualificatif_objet_source, fk_role_objet_source, libelle_original_objet_source, valeur_objet_source, fk_unite_de_mesure) VALUES (566, 1073, 37, 19, NULL, NULL, NULL, NULL, '2015-11-11 23:13:37.694065+01', NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO association_objets (pk_association_objets, fk_objet_source, fk_objet_cible, fk_type_association_param, reference_precise_objet_source, url_objet_source, descriptif, notes, date_creation, date_modification, fk_qualificatif_objet_source, fk_role_objet_source, libelle_original_objet_source, valeur_objet_source, fk_unite_de_mesure) VALUES (567, 1072, 37, 19, NULL, NULL, NULL, NULL, '2015-11-11 23:13:37.694065+01', NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO association_objets (pk_association_objets, fk_objet_source, fk_objet_cible, fk_type_association_param, reference_precise_objet_source, url_objet_source, descriptif, notes, date_creation, date_modification, fk_qualificatif_objet_source, fk_role_objet_source, libelle_original_objet_source, valeur_objet_source, fk_unite_de_mesure) VALUES (568, 1071, 37, 19, NULL, NULL, NULL, NULL, '2015-11-11 23:13:37.694065+01', NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO association_objets (pk_association_objets, fk_objet_source, fk_objet_cible, fk_type_association_param, reference_precise_objet_source, url_objet_source, descriptif, notes, date_creation, date_modification, fk_qualificatif_objet_source, fk_role_objet_source, libelle_original_objet_source, valeur_objet_source, fk_unite_de_mesure) VALUES (569, 1070, 37, 19, NULL, NULL, NULL, NULL, '2015-11-11 23:13:37.694065+01', NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO association_objets (pk_association_objets, fk_objet_source, fk_objet_cible, fk_type_association_param, reference_precise_objet_source, url_objet_source, descriptif, notes, date_creation, date_modification, fk_qualificatif_objet_source, fk_role_objet_source, libelle_original_objet_source, valeur_objet_source, fk_unite_de_mesure) VALUES (570, 1069, 37, 19, NULL, NULL, NULL, NULL, '2015-11-11 23:13:37.694065+01', NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO association_objets (pk_association_objets, fk_objet_source, fk_objet_cible, fk_type_association_param, reference_precise_objet_source, url_objet_source, descriptif, notes, date_creation, date_modification, fk_qualificatif_objet_source, fk_role_objet_source, libelle_original_objet_source, valeur_objet_source, fk_unite_de_mesure) VALUES (571, 1068, 37, 19, NULL, NULL, NULL, NULL, '2015-11-11 23:13:37.694065+01', NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO association_objets (pk_association_objets, fk_objet_source, fk_objet_cible, fk_type_association_param, reference_precise_objet_source, url_objet_source, descriptif, notes, date_creation, date_modification, fk_qualificatif_objet_source, fk_role_objet_source, libelle_original_objet_source, valeur_objet_source, fk_unite_de_mesure) VALUES (572, 1067, 37, 19, NULL, NULL, NULL, NULL, '2015-11-11 23:13:37.694065+01', NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO association_objets (pk_association_objets, fk_objet_source, fk_objet_cible, fk_type_association_param, reference_precise_objet_source, url_objet_source, descriptif, notes, date_creation, date_modification, fk_qualificatif_objet_source, fk_role_objet_source, libelle_original_objet_source, valeur_objet_source, fk_unite_de_mesure) VALUES (573, 1066, 37, 19, NULL, NULL, NULL, NULL, '2015-11-11 23:13:37.694065+01', NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO association_objets (pk_association_objets, fk_objet_source, fk_objet_cible, fk_type_association_param, reference_precise_objet_source, url_objet_source, descriptif, notes, date_creation, date_modification, fk_qualificatif_objet_source, fk_role_objet_source, libelle_original_objet_source, valeur_objet_source, fk_unite_de_mesure) VALUES (574, 1065, 37, 19, NULL, NULL, NULL, NULL, '2015-11-11 23:13:37.694065+01', NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO association_objets (pk_association_objets, fk_objet_source, fk_objet_cible, fk_type_association_param, reference_precise_objet_source, url_objet_source, descriptif, notes, date_creation, date_modification, fk_qualificatif_objet_source, fk_role_objet_source, libelle_original_objet_source, valeur_objet_source, fk_unite_de_mesure) VALUES (575, 1064, 37, 19, NULL, NULL, NULL, NULL, '2015-11-11 23:13:37.694065+01', NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO association_objets (pk_association_objets, fk_objet_source, fk_objet_cible, fk_type_association_param, reference_precise_objet_source, url_objet_source, descriptif, notes, date_creation, date_modification, fk_qualificatif_objet_source, fk_role_objet_source, libelle_original_objet_source, valeur_objet_source, fk_unite_de_mesure) VALUES (576, 1063, 37, 19, NULL, NULL, NULL, NULL, '2015-11-11 23:13:37.694065+01', NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO association_objets (pk_association_objets, fk_objet_source, fk_objet_cible, fk_type_association_param, reference_precise_objet_source, url_objet_source, descriptif, notes, date_creation, date_modification, fk_qualificatif_objet_source, fk_role_objet_source, libelle_original_objet_source, valeur_objet_source, fk_unite_de_mesure) VALUES (577, 1062, 37, 19, NULL, NULL, NULL, NULL, '2015-11-11 23:13:37.694065+01', NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO association_objets (pk_association_objets, fk_objet_source, fk_objet_cible, fk_type_association_param, reference_precise_objet_source, url_objet_source, descriptif, notes, date_creation, date_modification, fk_qualificatif_objet_source, fk_role_objet_source, libelle_original_objet_source, valeur_objet_source, fk_unite_de_mesure) VALUES (578, 1061, 37, 19, NULL, NULL, NULL, NULL, '2015-11-11 23:13:37.694065+01', NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO association_objets (pk_association_objets, fk_objet_source, fk_objet_cible, fk_type_association_param, reference_precise_objet_source, url_objet_source, descriptif, notes, date_creation, date_modification, fk_qualificatif_objet_source, fk_role_objet_source, libelle_original_objet_source, valeur_objet_source, fk_unite_de_mesure) VALUES (579, 1060, 37, 19, NULL, NULL, NULL, NULL, '2015-11-11 23:13:37.694065+01', NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO association_objets (pk_association_objets, fk_objet_source, fk_objet_cible, fk_type_association_param, reference_precise_objet_source, url_objet_source, descriptif, notes, date_creation, date_modification, fk_qualificatif_objet_source, fk_role_objet_source, libelle_original_objet_source, valeur_objet_source, fk_unite_de_mesure) VALUES (580, 1059, 37, 19, NULL, NULL, NULL, NULL, '2015-11-11 23:13:37.694065+01', NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO association_objets (pk_association_objets, fk_objet_source, fk_objet_cible, fk_type_association_param, reference_precise_objet_source, url_objet_source, descriptif, notes, date_creation, date_modification, fk_qualificatif_objet_source, fk_role_objet_source, libelle_original_objet_source, valeur_objet_source, fk_unite_de_mesure) VALUES (581, 1058, 37, 19, NULL, NULL, NULL, NULL, '2015-11-11 23:13:37.694065+01', NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO association_objets (pk_association_objets, fk_objet_source, fk_objet_cible, fk_type_association_param, reference_precise_objet_source, url_objet_source, descriptif, notes, date_creation, date_modification, fk_qualificatif_objet_source, fk_role_objet_source, libelle_original_objet_source, valeur_objet_source, fk_unite_de_mesure) VALUES (582, 1057, 37, 19, NULL, NULL, NULL, NULL, '2015-11-11 23:13:37.694065+01', NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO association_objets (pk_association_objets, fk_objet_source, fk_objet_cible, fk_type_association_param, reference_precise_objet_source, url_objet_source, descriptif, notes, date_creation, date_modification, fk_qualificatif_objet_source, fk_role_objet_source, libelle_original_objet_source, valeur_objet_source, fk_unite_de_mesure) VALUES (583, 1056, 37, 19, NULL, NULL, NULL, NULL, '2015-11-11 23:13:37.694065+01', NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO association_objets (pk_association_objets, fk_objet_source, fk_objet_cible, fk_type_association_param, reference_precise_objet_source, url_objet_source, descriptif, notes, date_creation, date_modification, fk_qualificatif_objet_source, fk_role_objet_source, libelle_original_objet_source, valeur_objet_source, fk_unite_de_mesure) VALUES (584, 1055, 37, 19, NULL, NULL, NULL, NULL, '2015-11-11 23:13:37.694065+01', NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO association_objets (pk_association_objets, fk_objet_source, fk_objet_cible, fk_type_association_param, reference_precise_objet_source, url_objet_source, descriptif, notes, date_creation, date_modification, fk_qualificatif_objet_source, fk_role_objet_source, libelle_original_objet_source, valeur_objet_source, fk_unite_de_mesure) VALUES (585, 1054, 37, 19, NULL, NULL, NULL, NULL, '2015-11-11 23:13:37.694065+01', NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO association_objets (pk_association_objets, fk_objet_source, fk_objet_cible, fk_type_association_param, reference_precise_objet_source, url_objet_source, descriptif, notes, date_creation, date_modification, fk_qualificatif_objet_source, fk_role_objet_source, libelle_original_objet_source, valeur_objet_source, fk_unite_de_mesure) VALUES (586, 1053, 37, 19, NULL, NULL, NULL, NULL, '2015-11-11 23:13:37.694065+01', NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO association_objets (pk_association_objets, fk_objet_source, fk_objet_cible, fk_type_association_param, reference_precise_objet_source, url_objet_source, descriptif, notes, date_creation, date_modification, fk_qualificatif_objet_source, fk_role_objet_source, libelle_original_objet_source, valeur_objet_source, fk_unite_de_mesure) VALUES (587, 1052, 37, 19, NULL, NULL, NULL, NULL, '2015-11-11 23:13:37.694065+01', NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO association_objets (pk_association_objets, fk_objet_source, fk_objet_cible, fk_type_association_param, reference_precise_objet_source, url_objet_source, descriptif, notes, date_creation, date_modification, fk_qualificatif_objet_source, fk_role_objet_source, libelle_original_objet_source, valeur_objet_source, fk_unite_de_mesure) VALUES (588, 1051, 37, 19, NULL, NULL, NULL, NULL, '2015-11-11 23:13:37.694065+01', NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO association_objets (pk_association_objets, fk_objet_source, fk_objet_cible, fk_type_association_param, reference_precise_objet_source, url_objet_source, descriptif, notes, date_creation, date_modification, fk_qualificatif_objet_source, fk_role_objet_source, libelle_original_objet_source, valeur_objet_source, fk_unite_de_mesure) VALUES (589, 1050, 37, 19, NULL, NULL, NULL, NULL, '2015-11-11 23:13:37.694065+01', NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO association_objets (pk_association_objets, fk_objet_source, fk_objet_cible, fk_type_association_param, reference_precise_objet_source, url_objet_source, descriptif, notes, date_creation, date_modification, fk_qualificatif_objet_source, fk_role_objet_source, libelle_original_objet_source, valeur_objet_source, fk_unite_de_mesure) VALUES (590, 1049, 37, 19, NULL, NULL, NULL, NULL, '2015-11-11 23:13:37.694065+01', NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO association_objets (pk_association_objets, fk_objet_source, fk_objet_cible, fk_type_association_param, reference_precise_objet_source, url_objet_source, descriptif, notes, date_creation, date_modification, fk_qualificatif_objet_source, fk_role_objet_source, libelle_original_objet_source, valeur_objet_source, fk_unite_de_mesure) VALUES (591, 1048, 37, 19, NULL, NULL, NULL, NULL, '2015-11-11 23:13:37.694065+01', NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO association_objets (pk_association_objets, fk_objet_source, fk_objet_cible, fk_type_association_param, reference_precise_objet_source, url_objet_source, descriptif, notes, date_creation, date_modification, fk_qualificatif_objet_source, fk_role_objet_source, libelle_original_objet_source, valeur_objet_source, fk_unite_de_mesure) VALUES (592, 1047, 37, 19, NULL, NULL, NULL, NULL, '2015-11-11 23:13:37.694065+01', NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO association_objets (pk_association_objets, fk_objet_source, fk_objet_cible, fk_type_association_param, reference_precise_objet_source, url_objet_source, descriptif, notes, date_creation, date_modification, fk_qualificatif_objet_source, fk_role_objet_source, libelle_original_objet_source, valeur_objet_source, fk_unite_de_mesure) VALUES (593, 1046, 37, 19, NULL, NULL, NULL, NULL, '2015-11-11 23:13:37.694065+01', NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO association_objets (pk_association_objets, fk_objet_source, fk_objet_cible, fk_type_association_param, reference_precise_objet_source, url_objet_source, descriptif, notes, date_creation, date_modification, fk_qualificatif_objet_source, fk_role_objet_source, libelle_original_objet_source, valeur_objet_source, fk_unite_de_mesure) VALUES (594, 1045, 37, 19, NULL, NULL, NULL, NULL, '2015-11-11 23:13:37.694065+01', NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO association_objets (pk_association_objets, fk_objet_source, fk_objet_cible, fk_type_association_param, reference_precise_objet_source, url_objet_source, descriptif, notes, date_creation, date_modification, fk_qualificatif_objet_source, fk_role_objet_source, libelle_original_objet_source, valeur_objet_source, fk_unite_de_mesure) VALUES (595, 1044, 37, 19, NULL, NULL, NULL, NULL, '2015-11-11 23:13:37.694065+01', NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO association_objets (pk_association_objets, fk_objet_source, fk_objet_cible, fk_type_association_param, reference_precise_objet_source, url_objet_source, descriptif, notes, date_creation, date_modification, fk_qualificatif_objet_source, fk_role_objet_source, libelle_original_objet_source, valeur_objet_source, fk_unite_de_mesure) VALUES (596, 1043, 37, 19, NULL, NULL, NULL, NULL, '2015-11-11 23:13:37.694065+01', NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO association_objets (pk_association_objets, fk_objet_source, fk_objet_cible, fk_type_association_param, reference_precise_objet_source, url_objet_source, descriptif, notes, date_creation, date_modification, fk_qualificatif_objet_source, fk_role_objet_source, libelle_original_objet_source, valeur_objet_source, fk_unite_de_mesure) VALUES (597, 1042, 37, 19, NULL, NULL, NULL, NULL, '2015-11-11 23:13:37.694065+01', NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO association_objets (pk_association_objets, fk_objet_source, fk_objet_cible, fk_type_association_param, reference_precise_objet_source, url_objet_source, descriptif, notes, date_creation, date_modification, fk_qualificatif_objet_source, fk_role_objet_source, libelle_original_objet_source, valeur_objet_source, fk_unite_de_mesure) VALUES (598, 1041, 37, 19, NULL, NULL, NULL, NULL, '2015-11-11 23:13:37.694065+01', NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO association_objets (pk_association_objets, fk_objet_source, fk_objet_cible, fk_type_association_param, reference_precise_objet_source, url_objet_source, descriptif, notes, date_creation, date_modification, fk_qualificatif_objet_source, fk_role_objet_source, libelle_original_objet_source, valeur_objet_source, fk_unite_de_mesure) VALUES (599, 1040, 37, 19, NULL, NULL, NULL, NULL, '2015-11-11 23:13:37.694065+01', NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO association_objets (pk_association_objets, fk_objet_source, fk_objet_cible, fk_type_association_param, reference_precise_objet_source, url_objet_source, descriptif, notes, date_creation, date_modification, fk_qualificatif_objet_source, fk_role_objet_source, libelle_original_objet_source, valeur_objet_source, fk_unite_de_mesure) VALUES (600, 1039, 37, 19, NULL, NULL, NULL, NULL, '2015-11-11 23:13:37.694065+01', NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO association_objets (pk_association_objets, fk_objet_source, fk_objet_cible, fk_type_association_param, reference_precise_objet_source, url_objet_source, descriptif, notes, date_creation, date_modification, fk_qualificatif_objet_source, fk_role_objet_source, libelle_original_objet_source, valeur_objet_source, fk_unite_de_mesure) VALUES (601, 1038, 37, 19, NULL, NULL, NULL, NULL, '2015-11-11 23:13:37.694065+01', NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO association_objets (pk_association_objets, fk_objet_source, fk_objet_cible, fk_type_association_param, reference_precise_objet_source, url_objet_source, descriptif, notes, date_creation, date_modification, fk_qualificatif_objet_source, fk_role_objet_source, libelle_original_objet_source, valeur_objet_source, fk_unite_de_mesure) VALUES (602, 1037, 37, 19, NULL, NULL, NULL, NULL, '2015-11-11 23:13:37.694065+01', NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO association_objets (pk_association_objets, fk_objet_source, fk_objet_cible, fk_type_association_param, reference_precise_objet_source, url_objet_source, descriptif, notes, date_creation, date_modification, fk_qualificatif_objet_source, fk_role_objet_source, libelle_original_objet_source, valeur_objet_source, fk_unite_de_mesure) VALUES (603, 1036, 37, 19, NULL, NULL, NULL, NULL, '2015-11-11 23:13:37.694065+01', NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO association_objets (pk_association_objets, fk_objet_source, fk_objet_cible, fk_type_association_param, reference_precise_objet_source, url_objet_source, descriptif, notes, date_creation, date_modification, fk_qualificatif_objet_source, fk_role_objet_source, libelle_original_objet_source, valeur_objet_source, fk_unite_de_mesure) VALUES (604, 1035, 37, 19, NULL, NULL, NULL, NULL, '2015-11-11 23:13:37.694065+01', NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO association_objets (pk_association_objets, fk_objet_source, fk_objet_cible, fk_type_association_param, reference_precise_objet_source, url_objet_source, descriptif, notes, date_creation, date_modification, fk_qualificatif_objet_source, fk_role_objet_source, libelle_original_objet_source, valeur_objet_source, fk_unite_de_mesure) VALUES (605, 1034, 37, 19, NULL, NULL, NULL, NULL, '2015-11-11 23:13:37.694065+01', NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO association_objets (pk_association_objets, fk_objet_source, fk_objet_cible, fk_type_association_param, reference_precise_objet_source, url_objet_source, descriptif, notes, date_creation, date_modification, fk_qualificatif_objet_source, fk_role_objet_source, libelle_original_objet_source, valeur_objet_source, fk_unite_de_mesure) VALUES (606, 1033, 37, 19, NULL, NULL, NULL, NULL, '2015-11-11 23:13:37.694065+01', NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO association_objets (pk_association_objets, fk_objet_source, fk_objet_cible, fk_type_association_param, reference_precise_objet_source, url_objet_source, descriptif, notes, date_creation, date_modification, fk_qualificatif_objet_source, fk_role_objet_source, libelle_original_objet_source, valeur_objet_source, fk_unite_de_mesure) VALUES (607, 1032, 37, 19, NULL, NULL, NULL, NULL, '2015-11-11 23:13:37.694065+01', NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO association_objets (pk_association_objets, fk_objet_source, fk_objet_cible, fk_type_association_param, reference_precise_objet_source, url_objet_source, descriptif, notes, date_creation, date_modification, fk_qualificatif_objet_source, fk_role_objet_source, libelle_original_objet_source, valeur_objet_source, fk_unite_de_mesure) VALUES (608, 1031, 37, 19, NULL, NULL, NULL, NULL, '2015-11-11 23:13:37.694065+01', NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO association_objets (pk_association_objets, fk_objet_source, fk_objet_cible, fk_type_association_param, reference_precise_objet_source, url_objet_source, descriptif, notes, date_creation, date_modification, fk_qualificatif_objet_source, fk_role_objet_source, libelle_original_objet_source, valeur_objet_source, fk_unite_de_mesure) VALUES (609, 1030, 37, 19, NULL, NULL, NULL, NULL, '2015-11-11 23:13:37.694065+01', NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO association_objets (pk_association_objets, fk_objet_source, fk_objet_cible, fk_type_association_param, reference_precise_objet_source, url_objet_source, descriptif, notes, date_creation, date_modification, fk_qualificatif_objet_source, fk_role_objet_source, libelle_original_objet_source, valeur_objet_source, fk_unite_de_mesure) VALUES (610, 1029, 37, 19, NULL, NULL, NULL, NULL, '2015-11-11 23:13:37.694065+01', NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO association_objets (pk_association_objets, fk_objet_source, fk_objet_cible, fk_type_association_param, reference_precise_objet_source, url_objet_source, descriptif, notes, date_creation, date_modification, fk_qualificatif_objet_source, fk_role_objet_source, libelle_original_objet_source, valeur_objet_source, fk_unite_de_mesure) VALUES (611, 1028, 37, 19, NULL, NULL, NULL, NULL, '2015-11-11 23:13:37.694065+01', NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO association_objets (pk_association_objets, fk_objet_source, fk_objet_cible, fk_type_association_param, reference_precise_objet_source, url_objet_source, descriptif, notes, date_creation, date_modification, fk_qualificatif_objet_source, fk_role_objet_source, libelle_original_objet_source, valeur_objet_source, fk_unite_de_mesure) VALUES (612, 1027, 37, 19, NULL, NULL, NULL, NULL, '2015-11-11 23:13:37.694065+01', NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO association_objets (pk_association_objets, fk_objet_source, fk_objet_cible, fk_type_association_param, reference_precise_objet_source, url_objet_source, descriptif, notes, date_creation, date_modification, fk_qualificatif_objet_source, fk_role_objet_source, libelle_original_objet_source, valeur_objet_source, fk_unite_de_mesure) VALUES (613, 1026, 37, 19, NULL, NULL, NULL, NULL, '2015-11-11 23:13:37.694065+01', NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO association_objets (pk_association_objets, fk_objet_source, fk_objet_cible, fk_type_association_param, reference_precise_objet_source, url_objet_source, descriptif, notes, date_creation, date_modification, fk_qualificatif_objet_source, fk_role_objet_source, libelle_original_objet_source, valeur_objet_source, fk_unite_de_mesure) VALUES (614, 1025, 37, 19, NULL, NULL, NULL, NULL, '2015-11-11 23:13:37.694065+01', NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO association_objets (pk_association_objets, fk_objet_source, fk_objet_cible, fk_type_association_param, reference_precise_objet_source, url_objet_source, descriptif, notes, date_creation, date_modification, fk_qualificatif_objet_source, fk_role_objet_source, libelle_original_objet_source, valeur_objet_source, fk_unite_de_mesure) VALUES (615, 1024, 37, 19, NULL, NULL, NULL, NULL, '2015-11-11 23:13:37.694065+01', NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO association_objets (pk_association_objets, fk_objet_source, fk_objet_cible, fk_type_association_param, reference_precise_objet_source, url_objet_source, descriptif, notes, date_creation, date_modification, fk_qualificatif_objet_source, fk_role_objet_source, libelle_original_objet_source, valeur_objet_source, fk_unite_de_mesure) VALUES (616, 1023, 37, 19, NULL, NULL, NULL, NULL, '2015-11-11 23:13:37.694065+01', NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO association_objets (pk_association_objets, fk_objet_source, fk_objet_cible, fk_type_association_param, reference_precise_objet_source, url_objet_source, descriptif, notes, date_creation, date_modification, fk_qualificatif_objet_source, fk_role_objet_source, libelle_original_objet_source, valeur_objet_source, fk_unite_de_mesure) VALUES (617, 1022, 37, 19, NULL, NULL, NULL, NULL, '2015-11-11 23:13:37.694065+01', NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO association_objets (pk_association_objets, fk_objet_source, fk_objet_cible, fk_type_association_param, reference_precise_objet_source, url_objet_source, descriptif, notes, date_creation, date_modification, fk_qualificatif_objet_source, fk_role_objet_source, libelle_original_objet_source, valeur_objet_source, fk_unite_de_mesure) VALUES (618, 1021, 37, 19, NULL, NULL, NULL, NULL, '2015-11-11 23:13:37.694065+01', NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO association_objets (pk_association_objets, fk_objet_source, fk_objet_cible, fk_type_association_param, reference_precise_objet_source, url_objet_source, descriptif, notes, date_creation, date_modification, fk_qualificatif_objet_source, fk_role_objet_source, libelle_original_objet_source, valeur_objet_source, fk_unite_de_mesure) VALUES (619, 1020, 37, 19, NULL, NULL, NULL, NULL, '2015-11-11 23:13:37.694065+01', NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO association_objets (pk_association_objets, fk_objet_source, fk_objet_cible, fk_type_association_param, reference_precise_objet_source, url_objet_source, descriptif, notes, date_creation, date_modification, fk_qualificatif_objet_source, fk_role_objet_source, libelle_original_objet_source, valeur_objet_source, fk_unite_de_mesure) VALUES (620, 1019, 37, 19, NULL, NULL, NULL, NULL, '2015-11-11 23:13:37.694065+01', NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO association_objets (pk_association_objets, fk_objet_source, fk_objet_cible, fk_type_association_param, reference_precise_objet_source, url_objet_source, descriptif, notes, date_creation, date_modification, fk_qualificatif_objet_source, fk_role_objet_source, libelle_original_objet_source, valeur_objet_source, fk_unite_de_mesure) VALUES (621, 1018, 37, 19, NULL, NULL, NULL, NULL, '2015-11-11 23:13:37.694065+01', NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO association_objets (pk_association_objets, fk_objet_source, fk_objet_cible, fk_type_association_param, reference_precise_objet_source, url_objet_source, descriptif, notes, date_creation, date_modification, fk_qualificatif_objet_source, fk_role_objet_source, libelle_original_objet_source, valeur_objet_source, fk_unite_de_mesure) VALUES (622, 1017, 37, 19, NULL, NULL, NULL, NULL, '2015-11-11 23:13:37.694065+01', NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO association_objets (pk_association_objets, fk_objet_source, fk_objet_cible, fk_type_association_param, reference_precise_objet_source, url_objet_source, descriptif, notes, date_creation, date_modification, fk_qualificatif_objet_source, fk_role_objet_source, libelle_original_objet_source, valeur_objet_source, fk_unite_de_mesure) VALUES (623, 1016, 37, 19, NULL, NULL, NULL, NULL, '2015-11-11 23:13:37.694065+01', NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO association_objets (pk_association_objets, fk_objet_source, fk_objet_cible, fk_type_association_param, reference_precise_objet_source, url_objet_source, descriptif, notes, date_creation, date_modification, fk_qualificatif_objet_source, fk_role_objet_source, libelle_original_objet_source, valeur_objet_source, fk_unite_de_mesure) VALUES (624, 1015, 37, 19, NULL, NULL, NULL, NULL, '2015-11-11 23:13:37.694065+01', NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO association_objets (pk_association_objets, fk_objet_source, fk_objet_cible, fk_type_association_param, reference_precise_objet_source, url_objet_source, descriptif, notes, date_creation, date_modification, fk_qualificatif_objet_source, fk_role_objet_source, libelle_original_objet_source, valeur_objet_source, fk_unite_de_mesure) VALUES (625, 1014, 37, 19, NULL, NULL, NULL, NULL, '2015-11-11 23:13:37.694065+01', NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO association_objets (pk_association_objets, fk_objet_source, fk_objet_cible, fk_type_association_param, reference_precise_objet_source, url_objet_source, descriptif, notes, date_creation, date_modification, fk_qualificatif_objet_source, fk_role_objet_source, libelle_original_objet_source, valeur_objet_source, fk_unite_de_mesure) VALUES (626, 1013, 37, 19, NULL, NULL, NULL, NULL, '2015-11-11 23:13:37.694065+01', NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO association_objets (pk_association_objets, fk_objet_source, fk_objet_cible, fk_type_association_param, reference_precise_objet_source, url_objet_source, descriptif, notes, date_creation, date_modification, fk_qualificatif_objet_source, fk_role_objet_source, libelle_original_objet_source, valeur_objet_source, fk_unite_de_mesure) VALUES (627, 1012, 37, 19, NULL, NULL, NULL, NULL, '2015-11-11 23:13:37.694065+01', NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO association_objets (pk_association_objets, fk_objet_source, fk_objet_cible, fk_type_association_param, reference_precise_objet_source, url_objet_source, descriptif, notes, date_creation, date_modification, fk_qualificatif_objet_source, fk_role_objet_source, libelle_original_objet_source, valeur_objet_source, fk_unite_de_mesure) VALUES (628, 1011, 37, 19, NULL, NULL, NULL, NULL, '2015-11-11 23:13:37.694065+01', NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO association_objets (pk_association_objets, fk_objet_source, fk_objet_cible, fk_type_association_param, reference_precise_objet_source, url_objet_source, descriptif, notes, date_creation, date_modification, fk_qualificatif_objet_source, fk_role_objet_source, libelle_original_objet_source, valeur_objet_source, fk_unite_de_mesure) VALUES (629, 1010, 37, 19, NULL, NULL, NULL, NULL, '2015-11-11 23:13:37.694065+01', NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO association_objets (pk_association_objets, fk_objet_source, fk_objet_cible, fk_type_association_param, reference_precise_objet_source, url_objet_source, descriptif, notes, date_creation, date_modification, fk_qualificatif_objet_source, fk_role_objet_source, libelle_original_objet_source, valeur_objet_source, fk_unite_de_mesure) VALUES (630, 1009, 37, 19, NULL, NULL, NULL, NULL, '2015-11-11 23:13:37.694065+01', NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO association_objets (pk_association_objets, fk_objet_source, fk_objet_cible, fk_type_association_param, reference_precise_objet_source, url_objet_source, descriptif, notes, date_creation, date_modification, fk_qualificatif_objet_source, fk_role_objet_source, libelle_original_objet_source, valeur_objet_source, fk_unite_de_mesure) VALUES (631, 1008, 37, 19, NULL, NULL, NULL, NULL, '2015-11-11 23:13:37.694065+01', NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO association_objets (pk_association_objets, fk_objet_source, fk_objet_cible, fk_type_association_param, reference_precise_objet_source, url_objet_source, descriptif, notes, date_creation, date_modification, fk_qualificatif_objet_source, fk_role_objet_source, libelle_original_objet_source, valeur_objet_source, fk_unite_de_mesure) VALUES (632, 1007, 37, 19, NULL, NULL, NULL, NULL, '2015-11-11 23:13:37.694065+01', NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO association_objets (pk_association_objets, fk_objet_source, fk_objet_cible, fk_type_association_param, reference_precise_objet_source, url_objet_source, descriptif, notes, date_creation, date_modification, fk_qualificatif_objet_source, fk_role_objet_source, libelle_original_objet_source, valeur_objet_source, fk_unite_de_mesure) VALUES (633, 1006, 37, 19, NULL, NULL, NULL, NULL, '2015-11-11 23:13:37.694065+01', NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO association_objets (pk_association_objets, fk_objet_source, fk_objet_cible, fk_type_association_param, reference_precise_objet_source, url_objet_source, descriptif, notes, date_creation, date_modification, fk_qualificatif_objet_source, fk_role_objet_source, libelle_original_objet_source, valeur_objet_source, fk_unite_de_mesure) VALUES (634, 1005, 37, 19, NULL, NULL, NULL, NULL, '2015-11-11 23:13:37.694065+01', NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO association_objets (pk_association_objets, fk_objet_source, fk_objet_cible, fk_type_association_param, reference_precise_objet_source, url_objet_source, descriptif, notes, date_creation, date_modification, fk_qualificatif_objet_source, fk_role_objet_source, libelle_original_objet_source, valeur_objet_source, fk_unite_de_mesure) VALUES (635, 1004, 37, 19, NULL, NULL, NULL, NULL, '2015-11-11 23:13:37.694065+01', NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO association_objets (pk_association_objets, fk_objet_source, fk_objet_cible, fk_type_association_param, reference_precise_objet_source, url_objet_source, descriptif, notes, date_creation, date_modification, fk_qualificatif_objet_source, fk_role_objet_source, libelle_original_objet_source, valeur_objet_source, fk_unite_de_mesure) VALUES (636, 1003, 37, 19, NULL, NULL, NULL, NULL, '2015-11-11 23:13:37.694065+01', NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO association_objets (pk_association_objets, fk_objet_source, fk_objet_cible, fk_type_association_param, reference_precise_objet_source, url_objet_source, descriptif, notes, date_creation, date_modification, fk_qualificatif_objet_source, fk_role_objet_source, libelle_original_objet_source, valeur_objet_source, fk_unite_de_mesure) VALUES (637, 1002, 37, 19, NULL, NULL, NULL, NULL, '2015-11-11 23:13:37.694065+01', NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO association_objets (pk_association_objets, fk_objet_source, fk_objet_cible, fk_type_association_param, reference_precise_objet_source, url_objet_source, descriptif, notes, date_creation, date_modification, fk_qualificatif_objet_source, fk_role_objet_source, libelle_original_objet_source, valeur_objet_source, fk_unite_de_mesure) VALUES (638, 1001, 37, 19, NULL, NULL, NULL, NULL, '2015-11-11 23:13:37.694065+01', NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO association_objets (pk_association_objets, fk_objet_source, fk_objet_cible, fk_type_association_param, reference_precise_objet_source, url_objet_source, descriptif, notes, date_creation, date_modification, fk_qualificatif_objet_source, fk_role_objet_source, libelle_original_objet_source, valeur_objet_source, fk_unite_de_mesure) VALUES (639, 1000, 37, 19, NULL, NULL, NULL, NULL, '2015-11-11 23:13:37.694065+01', NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO association_objets (pk_association_objets, fk_objet_source, fk_objet_cible, fk_type_association_param, reference_precise_objet_source, url_objet_source, descriptif, notes, date_creation, date_modification, fk_qualificatif_objet_source, fk_role_objet_source, libelle_original_objet_source, valeur_objet_source, fk_unite_de_mesure) VALUES (640, 999, 37, 19, NULL, NULL, NULL, NULL, '2015-11-11 23:13:37.694065+01', NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO association_objets (pk_association_objets, fk_objet_source, fk_objet_cible, fk_type_association_param, reference_precise_objet_source, url_objet_source, descriptif, notes, date_creation, date_modification, fk_qualificatif_objet_source, fk_role_objet_source, libelle_original_objet_source, valeur_objet_source, fk_unite_de_mesure) VALUES (641, 998, 37, 19, NULL, NULL, NULL, NULL, '2015-11-11 23:13:37.694065+01', NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO association_objets (pk_association_objets, fk_objet_source, fk_objet_cible, fk_type_association_param, reference_precise_objet_source, url_objet_source, descriptif, notes, date_creation, date_modification, fk_qualificatif_objet_source, fk_role_objet_source, libelle_original_objet_source, valeur_objet_source, fk_unite_de_mesure) VALUES (642, 997, 37, 19, NULL, NULL, NULL, NULL, '2015-11-11 23:13:37.694065+01', NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO association_objets (pk_association_objets, fk_objet_source, fk_objet_cible, fk_type_association_param, reference_precise_objet_source, url_objet_source, descriptif, notes, date_creation, date_modification, fk_qualificatif_objet_source, fk_role_objet_source, libelle_original_objet_source, valeur_objet_source, fk_unite_de_mesure) VALUES (643, 996, 37, 19, NULL, NULL, NULL, NULL, '2015-11-11 23:13:37.694065+01', NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO association_objets (pk_association_objets, fk_objet_source, fk_objet_cible, fk_type_association_param, reference_precise_objet_source, url_objet_source, descriptif, notes, date_creation, date_modification, fk_qualificatif_objet_source, fk_role_objet_source, libelle_original_objet_source, valeur_objet_source, fk_unite_de_mesure) VALUES (644, 995, 37, 19, NULL, NULL, NULL, NULL, '2015-11-11 23:13:37.694065+01', NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO association_objets (pk_association_objets, fk_objet_source, fk_objet_cible, fk_type_association_param, reference_precise_objet_source, url_objet_source, descriptif, notes, date_creation, date_modification, fk_qualificatif_objet_source, fk_role_objet_source, libelle_original_objet_source, valeur_objet_source, fk_unite_de_mesure) VALUES (645, 994, 37, 19, NULL, NULL, NULL, NULL, '2015-11-11 23:13:37.694065+01', NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO association_objets (pk_association_objets, fk_objet_source, fk_objet_cible, fk_type_association_param, reference_precise_objet_source, url_objet_source, descriptif, notes, date_creation, date_modification, fk_qualificatif_objet_source, fk_role_objet_source, libelle_original_objet_source, valeur_objet_source, fk_unite_de_mesure) VALUES (646, 993, 37, 19, NULL, NULL, NULL, NULL, '2015-11-11 23:13:37.694065+01', NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO association_objets (pk_association_objets, fk_objet_source, fk_objet_cible, fk_type_association_param, reference_precise_objet_source, url_objet_source, descriptif, notes, date_creation, date_modification, fk_qualificatif_objet_source, fk_role_objet_source, libelle_original_objet_source, valeur_objet_source, fk_unite_de_mesure) VALUES (647, 992, 37, 19, NULL, NULL, NULL, NULL, '2015-11-11 23:13:37.694065+01', NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO association_objets (pk_association_objets, fk_objet_source, fk_objet_cible, fk_type_association_param, reference_precise_objet_source, url_objet_source, descriptif, notes, date_creation, date_modification, fk_qualificatif_objet_source, fk_role_objet_source, libelle_original_objet_source, valeur_objet_source, fk_unite_de_mesure) VALUES (648, 991, 37, 19, NULL, NULL, NULL, NULL, '2015-11-11 23:13:37.694065+01', NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO association_objets (pk_association_objets, fk_objet_source, fk_objet_cible, fk_type_association_param, reference_precise_objet_source, url_objet_source, descriptif, notes, date_creation, date_modification, fk_qualificatif_objet_source, fk_role_objet_source, libelle_original_objet_source, valeur_objet_source, fk_unite_de_mesure) VALUES (649, 990, 37, 19, NULL, NULL, NULL, NULL, '2015-11-11 23:13:37.694065+01', NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO association_objets (pk_association_objets, fk_objet_source, fk_objet_cible, fk_type_association_param, reference_precise_objet_source, url_objet_source, descriptif, notes, date_creation, date_modification, fk_qualificatif_objet_source, fk_role_objet_source, libelle_original_objet_source, valeur_objet_source, fk_unite_de_mesure) VALUES (650, 989, 37, 19, NULL, NULL, NULL, NULL, '2015-11-11 23:13:37.694065+01', NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO association_objets (pk_association_objets, fk_objet_source, fk_objet_cible, fk_type_association_param, reference_precise_objet_source, url_objet_source, descriptif, notes, date_creation, date_modification, fk_qualificatif_objet_source, fk_role_objet_source, libelle_original_objet_source, valeur_objet_source, fk_unite_de_mesure) VALUES (651, 988, 37, 19, NULL, NULL, NULL, NULL, '2015-11-11 23:13:37.694065+01', NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO association_objets (pk_association_objets, fk_objet_source, fk_objet_cible, fk_type_association_param, reference_precise_objet_source, url_objet_source, descriptif, notes, date_creation, date_modification, fk_qualificatif_objet_source, fk_role_objet_source, libelle_original_objet_source, valeur_objet_source, fk_unite_de_mesure) VALUES (652, 987, 37, 19, NULL, NULL, NULL, NULL, '2015-11-11 23:13:37.694065+01', NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO association_objets (pk_association_objets, fk_objet_source, fk_objet_cible, fk_type_association_param, reference_precise_objet_source, url_objet_source, descriptif, notes, date_creation, date_modification, fk_qualificatif_objet_source, fk_role_objet_source, libelle_original_objet_source, valeur_objet_source, fk_unite_de_mesure) VALUES (653, 986, 37, 19, NULL, NULL, NULL, NULL, '2015-11-11 23:13:37.694065+01', NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO association_objets (pk_association_objets, fk_objet_source, fk_objet_cible, fk_type_association_param, reference_precise_objet_source, url_objet_source, descriptif, notes, date_creation, date_modification, fk_qualificatif_objet_source, fk_role_objet_source, libelle_original_objet_source, valeur_objet_source, fk_unite_de_mesure) VALUES (654, 985, 37, 19, NULL, NULL, NULL, NULL, '2015-11-11 23:13:37.694065+01', NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO association_objets (pk_association_objets, fk_objet_source, fk_objet_cible, fk_type_association_param, reference_precise_objet_source, url_objet_source, descriptif, notes, date_creation, date_modification, fk_qualificatif_objet_source, fk_role_objet_source, libelle_original_objet_source, valeur_objet_source, fk_unite_de_mesure) VALUES (655, 984, 37, 19, NULL, NULL, NULL, NULL, '2015-11-11 23:13:37.694065+01', NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO association_objets (pk_association_objets, fk_objet_source, fk_objet_cible, fk_type_association_param, reference_precise_objet_source, url_objet_source, descriptif, notes, date_creation, date_modification, fk_qualificatif_objet_source, fk_role_objet_source, libelle_original_objet_source, valeur_objet_source, fk_unite_de_mesure) VALUES (656, 983, 37, 19, NULL, NULL, NULL, NULL, '2015-11-11 23:13:37.694065+01', NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO association_objets (pk_association_objets, fk_objet_source, fk_objet_cible, fk_type_association_param, reference_precise_objet_source, url_objet_source, descriptif, notes, date_creation, date_modification, fk_qualificatif_objet_source, fk_role_objet_source, libelle_original_objet_source, valeur_objet_source, fk_unite_de_mesure) VALUES (657, 982, 37, 19, NULL, NULL, NULL, NULL, '2015-11-11 23:13:37.694065+01', NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO association_objets (pk_association_objets, fk_objet_source, fk_objet_cible, fk_type_association_param, reference_precise_objet_source, url_objet_source, descriptif, notes, date_creation, date_modification, fk_qualificatif_objet_source, fk_role_objet_source, libelle_original_objet_source, valeur_objet_source, fk_unite_de_mesure) VALUES (658, 981, 37, 19, NULL, NULL, NULL, NULL, '2015-11-11 23:13:37.694065+01', NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO association_objets (pk_association_objets, fk_objet_source, fk_objet_cible, fk_type_association_param, reference_precise_objet_source, url_objet_source, descriptif, notes, date_creation, date_modification, fk_qualificatif_objet_source, fk_role_objet_source, libelle_original_objet_source, valeur_objet_source, fk_unite_de_mesure) VALUES (659, 980, 37, 19, NULL, NULL, NULL, NULL, '2015-11-11 23:13:37.694065+01', NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO association_objets (pk_association_objets, fk_objet_source, fk_objet_cible, fk_type_association_param, reference_precise_objet_source, url_objet_source, descriptif, notes, date_creation, date_modification, fk_qualificatif_objet_source, fk_role_objet_source, libelle_original_objet_source, valeur_objet_source, fk_unite_de_mesure) VALUES (660, 979, 37, 19, NULL, NULL, NULL, NULL, '2015-11-11 23:13:37.694065+01', NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO association_objets (pk_association_objets, fk_objet_source, fk_objet_cible, fk_type_association_param, reference_precise_objet_source, url_objet_source, descriptif, notes, date_creation, date_modification, fk_qualificatif_objet_source, fk_role_objet_source, libelle_original_objet_source, valeur_objet_source, fk_unite_de_mesure) VALUES (661, 978, 37, 19, NULL, NULL, NULL, NULL, '2015-11-11 23:13:37.694065+01', NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO association_objets (pk_association_objets, fk_objet_source, fk_objet_cible, fk_type_association_param, reference_precise_objet_source, url_objet_source, descriptif, notes, date_creation, date_modification, fk_qualificatif_objet_source, fk_role_objet_source, libelle_original_objet_source, valeur_objet_source, fk_unite_de_mesure) VALUES (662, 977, 37, 19, NULL, NULL, NULL, NULL, '2015-11-11 23:13:37.694065+01', NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO association_objets (pk_association_objets, fk_objet_source, fk_objet_cible, fk_type_association_param, reference_precise_objet_source, url_objet_source, descriptif, notes, date_creation, date_modification, fk_qualificatif_objet_source, fk_role_objet_source, libelle_original_objet_source, valeur_objet_source, fk_unite_de_mesure) VALUES (663, 976, 37, 19, NULL, NULL, NULL, NULL, '2015-11-11 23:13:37.694065+01', NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO association_objets (pk_association_objets, fk_objet_source, fk_objet_cible, fk_type_association_param, reference_precise_objet_source, url_objet_source, descriptif, notes, date_creation, date_modification, fk_qualificatif_objet_source, fk_role_objet_source, libelle_original_objet_source, valeur_objet_source, fk_unite_de_mesure) VALUES (664, 975, 37, 19, NULL, NULL, NULL, NULL, '2015-11-11 23:13:37.694065+01', NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO association_objets (pk_association_objets, fk_objet_source, fk_objet_cible, fk_type_association_param, reference_precise_objet_source, url_objet_source, descriptif, notes, date_creation, date_modification, fk_qualificatif_objet_source, fk_role_objet_source, libelle_original_objet_source, valeur_objet_source, fk_unite_de_mesure) VALUES (665, 974, 37, 19, NULL, NULL, NULL, NULL, '2015-11-11 23:13:37.694065+01', NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO association_objets (pk_association_objets, fk_objet_source, fk_objet_cible, fk_type_association_param, reference_precise_objet_source, url_objet_source, descriptif, notes, date_creation, date_modification, fk_qualificatif_objet_source, fk_role_objet_source, libelle_original_objet_source, valeur_objet_source, fk_unite_de_mesure) VALUES (666, 973, 37, 19, NULL, NULL, NULL, NULL, '2015-11-11 23:13:37.694065+01', NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO association_objets (pk_association_objets, fk_objet_source, fk_objet_cible, fk_type_association_param, reference_precise_objet_source, url_objet_source, descriptif, notes, date_creation, date_modification, fk_qualificatif_objet_source, fk_role_objet_source, libelle_original_objet_source, valeur_objet_source, fk_unite_de_mesure) VALUES (667, 972, 37, 19, NULL, NULL, NULL, NULL, '2015-11-11 23:13:37.694065+01', NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO association_objets (pk_association_objets, fk_objet_source, fk_objet_cible, fk_type_association_param, reference_precise_objet_source, url_objet_source, descriptif, notes, date_creation, date_modification, fk_qualificatif_objet_source, fk_role_objet_source, libelle_original_objet_source, valeur_objet_source, fk_unite_de_mesure) VALUES (668, 971, 37, 19, NULL, NULL, NULL, NULL, '2015-11-11 23:13:37.694065+01', NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO association_objets (pk_association_objets, fk_objet_source, fk_objet_cible, fk_type_association_param, reference_precise_objet_source, url_objet_source, descriptif, notes, date_creation, date_modification, fk_qualificatif_objet_source, fk_role_objet_source, libelle_original_objet_source, valeur_objet_source, fk_unite_de_mesure) VALUES (669, 970, 37, 19, NULL, NULL, NULL, NULL, '2015-11-11 23:13:37.694065+01', NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO association_objets (pk_association_objets, fk_objet_source, fk_objet_cible, fk_type_association_param, reference_precise_objet_source, url_objet_source, descriptif, notes, date_creation, date_modification, fk_qualificatif_objet_source, fk_role_objet_source, libelle_original_objet_source, valeur_objet_source, fk_unite_de_mesure) VALUES (670, 969, 37, 19, NULL, NULL, NULL, NULL, '2015-11-11 23:13:37.694065+01', NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO association_objets (pk_association_objets, fk_objet_source, fk_objet_cible, fk_type_association_param, reference_precise_objet_source, url_objet_source, descriptif, notes, date_creation, date_modification, fk_qualificatif_objet_source, fk_role_objet_source, libelle_original_objet_source, valeur_objet_source, fk_unite_de_mesure) VALUES (671, 968, 37, 19, NULL, NULL, NULL, NULL, '2015-11-11 23:13:37.694065+01', NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO association_objets (pk_association_objets, fk_objet_source, fk_objet_cible, fk_type_association_param, reference_precise_objet_source, url_objet_source, descriptif, notes, date_creation, date_modification, fk_qualificatif_objet_source, fk_role_objet_source, libelle_original_objet_source, valeur_objet_source, fk_unite_de_mesure) VALUES (672, 967, 37, 19, NULL, NULL, NULL, NULL, '2015-11-11 23:13:37.694065+01', NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO association_objets (pk_association_objets, fk_objet_source, fk_objet_cible, fk_type_association_param, reference_precise_objet_source, url_objet_source, descriptif, notes, date_creation, date_modification, fk_qualificatif_objet_source, fk_role_objet_source, libelle_original_objet_source, valeur_objet_source, fk_unite_de_mesure) VALUES (673, 966, 37, 19, NULL, NULL, NULL, NULL, '2015-11-11 23:13:37.694065+01', NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO association_objets (pk_association_objets, fk_objet_source, fk_objet_cible, fk_type_association_param, reference_precise_objet_source, url_objet_source, descriptif, notes, date_creation, date_modification, fk_qualificatif_objet_source, fk_role_objet_source, libelle_original_objet_source, valeur_objet_source, fk_unite_de_mesure) VALUES (674, 965, 37, 19, NULL, NULL, NULL, NULL, '2015-11-11 23:13:37.694065+01', NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO association_objets (pk_association_objets, fk_objet_source, fk_objet_cible, fk_type_association_param, reference_precise_objet_source, url_objet_source, descriptif, notes, date_creation, date_modification, fk_qualificatif_objet_source, fk_role_objet_source, libelle_original_objet_source, valeur_objet_source, fk_unite_de_mesure) VALUES (675, 964, 37, 19, NULL, NULL, NULL, NULL, '2015-11-11 23:13:37.694065+01', NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO association_objets (pk_association_objets, fk_objet_source, fk_objet_cible, fk_type_association_param, reference_precise_objet_source, url_objet_source, descriptif, notes, date_creation, date_modification, fk_qualificatif_objet_source, fk_role_objet_source, libelle_original_objet_source, valeur_objet_source, fk_unite_de_mesure) VALUES (676, 963, 37, 19, NULL, NULL, NULL, NULL, '2015-11-11 23:13:37.694065+01', NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO association_objets (pk_association_objets, fk_objet_source, fk_objet_cible, fk_type_association_param, reference_precise_objet_source, url_objet_source, descriptif, notes, date_creation, date_modification, fk_qualificatif_objet_source, fk_role_objet_source, libelle_original_objet_source, valeur_objet_source, fk_unite_de_mesure) VALUES (677, 962, 37, 19, NULL, NULL, NULL, NULL, '2015-11-11 23:13:37.694065+01', NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO association_objets (pk_association_objets, fk_objet_source, fk_objet_cible, fk_type_association_param, reference_precise_objet_source, url_objet_source, descriptif, notes, date_creation, date_modification, fk_qualificatif_objet_source, fk_role_objet_source, libelle_original_objet_source, valeur_objet_source, fk_unite_de_mesure) VALUES (678, 961, 37, 19, NULL, NULL, NULL, NULL, '2015-11-11 23:13:37.694065+01', NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO association_objets (pk_association_objets, fk_objet_source, fk_objet_cible, fk_type_association_param, reference_precise_objet_source, url_objet_source, descriptif, notes, date_creation, date_modification, fk_qualificatif_objet_source, fk_role_objet_source, libelle_original_objet_source, valeur_objet_source, fk_unite_de_mesure) VALUES (679, 960, 37, 19, NULL, NULL, NULL, NULL, '2015-11-11 23:13:37.694065+01', NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO association_objets (pk_association_objets, fk_objet_source, fk_objet_cible, fk_type_association_param, reference_precise_objet_source, url_objet_source, descriptif, notes, date_creation, date_modification, fk_qualificatif_objet_source, fk_role_objet_source, libelle_original_objet_source, valeur_objet_source, fk_unite_de_mesure) VALUES (680, 959, 37, 19, NULL, NULL, NULL, NULL, '2015-11-11 23:13:37.694065+01', NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO association_objets (pk_association_objets, fk_objet_source, fk_objet_cible, fk_type_association_param, reference_precise_objet_source, url_objet_source, descriptif, notes, date_creation, date_modification, fk_qualificatif_objet_source, fk_role_objet_source, libelle_original_objet_source, valeur_objet_source, fk_unite_de_mesure) VALUES (681, 958, 37, 19, NULL, NULL, NULL, NULL, '2015-11-11 23:13:37.694065+01', NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO association_objets (pk_association_objets, fk_objet_source, fk_objet_cible, fk_type_association_param, reference_precise_objet_source, url_objet_source, descriptif, notes, date_creation, date_modification, fk_qualificatif_objet_source, fk_role_objet_source, libelle_original_objet_source, valeur_objet_source, fk_unite_de_mesure) VALUES (682, 957, 37, 19, NULL, NULL, NULL, NULL, '2015-11-11 23:13:37.694065+01', NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO association_objets (pk_association_objets, fk_objet_source, fk_objet_cible, fk_type_association_param, reference_precise_objet_source, url_objet_source, descriptif, notes, date_creation, date_modification, fk_qualificatif_objet_source, fk_role_objet_source, libelle_original_objet_source, valeur_objet_source, fk_unite_de_mesure) VALUES (683, 956, 37, 19, NULL, NULL, NULL, NULL, '2015-11-11 23:13:37.694065+01', NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO association_objets (pk_association_objets, fk_objet_source, fk_objet_cible, fk_type_association_param, reference_precise_objet_source, url_objet_source, descriptif, notes, date_creation, date_modification, fk_qualificatif_objet_source, fk_role_objet_source, libelle_original_objet_source, valeur_objet_source, fk_unite_de_mesure) VALUES (684, 955, 37, 19, NULL, NULL, NULL, NULL, '2015-11-11 23:13:37.694065+01', NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO association_objets (pk_association_objets, fk_objet_source, fk_objet_cible, fk_type_association_param, reference_precise_objet_source, url_objet_source, descriptif, notes, date_creation, date_modification, fk_qualificatif_objet_source, fk_role_objet_source, libelle_original_objet_source, valeur_objet_source, fk_unite_de_mesure) VALUES (685, 954, 37, 19, NULL, NULL, NULL, NULL, '2015-11-11 23:13:37.694065+01', NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO association_objets (pk_association_objets, fk_objet_source, fk_objet_cible, fk_type_association_param, reference_precise_objet_source, url_objet_source, descriptif, notes, date_creation, date_modification, fk_qualificatif_objet_source, fk_role_objet_source, libelle_original_objet_source, valeur_objet_source, fk_unite_de_mesure) VALUES (686, 953, 37, 19, NULL, NULL, NULL, NULL, '2015-11-11 23:13:37.694065+01', NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO association_objets (pk_association_objets, fk_objet_source, fk_objet_cible, fk_type_association_param, reference_precise_objet_source, url_objet_source, descriptif, notes, date_creation, date_modification, fk_qualificatif_objet_source, fk_role_objet_source, libelle_original_objet_source, valeur_objet_source, fk_unite_de_mesure) VALUES (687, 952, 37, 19, NULL, NULL, NULL, NULL, '2015-11-11 23:13:37.694065+01', NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO association_objets (pk_association_objets, fk_objet_source, fk_objet_cible, fk_type_association_param, reference_precise_objet_source, url_objet_source, descriptif, notes, date_creation, date_modification, fk_qualificatif_objet_source, fk_role_objet_source, libelle_original_objet_source, valeur_objet_source, fk_unite_de_mesure) VALUES (688, 951, 37, 19, NULL, NULL, NULL, NULL, '2015-11-11 23:13:37.694065+01', NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO association_objets (pk_association_objets, fk_objet_source, fk_objet_cible, fk_type_association_param, reference_precise_objet_source, url_objet_source, descriptif, notes, date_creation, date_modification, fk_qualificatif_objet_source, fk_role_objet_source, libelle_original_objet_source, valeur_objet_source, fk_unite_de_mesure) VALUES (689, 950, 37, 19, NULL, NULL, NULL, NULL, '2015-11-11 23:13:37.694065+01', NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO association_objets (pk_association_objets, fk_objet_source, fk_objet_cible, fk_type_association_param, reference_precise_objet_source, url_objet_source, descriptif, notes, date_creation, date_modification, fk_qualificatif_objet_source, fk_role_objet_source, libelle_original_objet_source, valeur_objet_source, fk_unite_de_mesure) VALUES (690, 949, 37, 19, NULL, NULL, NULL, NULL, '2015-11-11 23:13:37.694065+01', NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO association_objets (pk_association_objets, fk_objet_source, fk_objet_cible, fk_type_association_param, reference_precise_objet_source, url_objet_source, descriptif, notes, date_creation, date_modification, fk_qualificatif_objet_source, fk_role_objet_source, libelle_original_objet_source, valeur_objet_source, fk_unite_de_mesure) VALUES (691, 948, 37, 19, NULL, NULL, NULL, NULL, '2015-11-11 23:13:37.694065+01', NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO association_objets (pk_association_objets, fk_objet_source, fk_objet_cible, fk_type_association_param, reference_precise_objet_source, url_objet_source, descriptif, notes, date_creation, date_modification, fk_qualificatif_objet_source, fk_role_objet_source, libelle_original_objet_source, valeur_objet_source, fk_unite_de_mesure) VALUES (692, 947, 37, 19, NULL, NULL, NULL, NULL, '2015-11-11 23:13:37.694065+01', NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO association_objets (pk_association_objets, fk_objet_source, fk_objet_cible, fk_type_association_param, reference_precise_objet_source, url_objet_source, descriptif, notes, date_creation, date_modification, fk_qualificatif_objet_source, fk_role_objet_source, libelle_original_objet_source, valeur_objet_source, fk_unite_de_mesure) VALUES (693, 946, 37, 19, NULL, NULL, NULL, NULL, '2015-11-11 23:13:37.694065+01', NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO association_objets (pk_association_objets, fk_objet_source, fk_objet_cible, fk_type_association_param, reference_precise_objet_source, url_objet_source, descriptif, notes, date_creation, date_modification, fk_qualificatif_objet_source, fk_role_objet_source, libelle_original_objet_source, valeur_objet_source, fk_unite_de_mesure) VALUES (694, 945, 37, 19, NULL, NULL, NULL, NULL, '2015-11-11 23:13:37.694065+01', NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO association_objets (pk_association_objets, fk_objet_source, fk_objet_cible, fk_type_association_param, reference_precise_objet_source, url_objet_source, descriptif, notes, date_creation, date_modification, fk_qualificatif_objet_source, fk_role_objet_source, libelle_original_objet_source, valeur_objet_source, fk_unite_de_mesure) VALUES (695, 944, 37, 19, NULL, NULL, NULL, NULL, '2015-11-11 23:13:37.694065+01', NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO association_objets (pk_association_objets, fk_objet_source, fk_objet_cible, fk_type_association_param, reference_precise_objet_source, url_objet_source, descriptif, notes, date_creation, date_modification, fk_qualificatif_objet_source, fk_role_objet_source, libelle_original_objet_source, valeur_objet_source, fk_unite_de_mesure) VALUES (696, 943, 37, 19, NULL, NULL, NULL, NULL, '2015-11-11 23:13:37.694065+01', NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO association_objets (pk_association_objets, fk_objet_source, fk_objet_cible, fk_type_association_param, reference_precise_objet_source, url_objet_source, descriptif, notes, date_creation, date_modification, fk_qualificatif_objet_source, fk_role_objet_source, libelle_original_objet_source, valeur_objet_source, fk_unite_de_mesure) VALUES (697, 942, 37, 19, NULL, NULL, NULL, NULL, '2015-11-11 23:13:37.694065+01', NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO association_objets (pk_association_objets, fk_objet_source, fk_objet_cible, fk_type_association_param, reference_precise_objet_source, url_objet_source, descriptif, notes, date_creation, date_modification, fk_qualificatif_objet_source, fk_role_objet_source, libelle_original_objet_source, valeur_objet_source, fk_unite_de_mesure) VALUES (698, 941, 37, 19, NULL, NULL, NULL, NULL, '2015-11-11 23:13:37.694065+01', NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO association_objets (pk_association_objets, fk_objet_source, fk_objet_cible, fk_type_association_param, reference_precise_objet_source, url_objet_source, descriptif, notes, date_creation, date_modification, fk_qualificatif_objet_source, fk_role_objet_source, libelle_original_objet_source, valeur_objet_source, fk_unite_de_mesure) VALUES (699, 940, 37, 19, NULL, NULL, NULL, NULL, '2015-11-11 23:13:37.694065+01', NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO association_objets (pk_association_objets, fk_objet_source, fk_objet_cible, fk_type_association_param, reference_precise_objet_source, url_objet_source, descriptif, notes, date_creation, date_modification, fk_qualificatif_objet_source, fk_role_objet_source, libelle_original_objet_source, valeur_objet_source, fk_unite_de_mesure) VALUES (700, 939, 37, 19, NULL, NULL, NULL, NULL, '2015-11-11 23:13:37.694065+01', NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO association_objets (pk_association_objets, fk_objet_source, fk_objet_cible, fk_type_association_param, reference_precise_objet_source, url_objet_source, descriptif, notes, date_creation, date_modification, fk_qualificatif_objet_source, fk_role_objet_source, libelle_original_objet_source, valeur_objet_source, fk_unite_de_mesure) VALUES (701, 938, 37, 19, NULL, NULL, NULL, NULL, '2015-11-11 23:13:37.694065+01', NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO association_objets (pk_association_objets, fk_objet_source, fk_objet_cible, fk_type_association_param, reference_precise_objet_source, url_objet_source, descriptif, notes, date_creation, date_modification, fk_qualificatif_objet_source, fk_role_objet_source, libelle_original_objet_source, valeur_objet_source, fk_unite_de_mesure) VALUES (702, 937, 37, 19, NULL, NULL, NULL, NULL, '2015-11-11 23:13:37.694065+01', NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO association_objets (pk_association_objets, fk_objet_source, fk_objet_cible, fk_type_association_param, reference_precise_objet_source, url_objet_source, descriptif, notes, date_creation, date_modification, fk_qualificatif_objet_source, fk_role_objet_source, libelle_original_objet_source, valeur_objet_source, fk_unite_de_mesure) VALUES (703, 936, 37, 19, NULL, NULL, NULL, NULL, '2015-11-11 23:13:37.694065+01', NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO association_objets (pk_association_objets, fk_objet_source, fk_objet_cible, fk_type_association_param, reference_precise_objet_source, url_objet_source, descriptif, notes, date_creation, date_modification, fk_qualificatif_objet_source, fk_role_objet_source, libelle_original_objet_source, valeur_objet_source, fk_unite_de_mesure) VALUES (704, 935, 37, 19, NULL, NULL, NULL, NULL, '2015-11-11 23:13:37.694065+01', NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO association_objets (pk_association_objets, fk_objet_source, fk_objet_cible, fk_type_association_param, reference_precise_objet_source, url_objet_source, descriptif, notes, date_creation, date_modification, fk_qualificatif_objet_source, fk_role_objet_source, libelle_original_objet_source, valeur_objet_source, fk_unite_de_mesure) VALUES (705, 934, 37, 19, NULL, NULL, NULL, NULL, '2015-11-11 23:13:37.694065+01', NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO association_objets (pk_association_objets, fk_objet_source, fk_objet_cible, fk_type_association_param, reference_precise_objet_source, url_objet_source, descriptif, notes, date_creation, date_modification, fk_qualificatif_objet_source, fk_role_objet_source, libelle_original_objet_source, valeur_objet_source, fk_unite_de_mesure) VALUES (706, 933, 37, 19, NULL, NULL, NULL, NULL, '2015-11-11 23:13:37.694065+01', NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO association_objets (pk_association_objets, fk_objet_source, fk_objet_cible, fk_type_association_param, reference_precise_objet_source, url_objet_source, descriptif, notes, date_creation, date_modification, fk_qualificatif_objet_source, fk_role_objet_source, libelle_original_objet_source, valeur_objet_source, fk_unite_de_mesure) VALUES (707, 932, 37, 19, NULL, NULL, NULL, NULL, '2015-11-11 23:13:37.694065+01', NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO association_objets (pk_association_objets, fk_objet_source, fk_objet_cible, fk_type_association_param, reference_precise_objet_source, url_objet_source, descriptif, notes, date_creation, date_modification, fk_qualificatif_objet_source, fk_role_objet_source, libelle_original_objet_source, valeur_objet_source, fk_unite_de_mesure) VALUES (708, 931, 37, 19, NULL, NULL, NULL, NULL, '2015-11-11 23:13:37.694065+01', NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO association_objets (pk_association_objets, fk_objet_source, fk_objet_cible, fk_type_association_param, reference_precise_objet_source, url_objet_source, descriptif, notes, date_creation, date_modification, fk_qualificatif_objet_source, fk_role_objet_source, libelle_original_objet_source, valeur_objet_source, fk_unite_de_mesure) VALUES (709, 930, 37, 19, NULL, NULL, NULL, NULL, '2015-11-11 23:13:37.694065+01', NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO association_objets (pk_association_objets, fk_objet_source, fk_objet_cible, fk_type_association_param, reference_precise_objet_source, url_objet_source, descriptif, notes, date_creation, date_modification, fk_qualificatif_objet_source, fk_role_objet_source, libelle_original_objet_source, valeur_objet_source, fk_unite_de_mesure) VALUES (710, 929, 37, 19, NULL, NULL, NULL, NULL, '2015-11-11 23:13:37.694065+01', NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO association_objets (pk_association_objets, fk_objet_source, fk_objet_cible, fk_type_association_param, reference_precise_objet_source, url_objet_source, descriptif, notes, date_creation, date_modification, fk_qualificatif_objet_source, fk_role_objet_source, libelle_original_objet_source, valeur_objet_source, fk_unite_de_mesure) VALUES (711, 928, 37, 19, NULL, NULL, NULL, NULL, '2015-11-11 23:13:37.694065+01', NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO association_objets (pk_association_objets, fk_objet_source, fk_objet_cible, fk_type_association_param, reference_precise_objet_source, url_objet_source, descriptif, notes, date_creation, date_modification, fk_qualificatif_objet_source, fk_role_objet_source, libelle_original_objet_source, valeur_objet_source, fk_unite_de_mesure) VALUES (712, 927, 37, 19, NULL, NULL, NULL, NULL, '2015-11-11 23:13:37.694065+01', NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO association_objets (pk_association_objets, fk_objet_source, fk_objet_cible, fk_type_association_param, reference_precise_objet_source, url_objet_source, descriptif, notes, date_creation, date_modification, fk_qualificatif_objet_source, fk_role_objet_source, libelle_original_objet_source, valeur_objet_source, fk_unite_de_mesure) VALUES (713, 926, 37, 19, NULL, NULL, NULL, NULL, '2015-11-11 23:13:37.694065+01', NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO association_objets (pk_association_objets, fk_objet_source, fk_objet_cible, fk_type_association_param, reference_precise_objet_source, url_objet_source, descriptif, notes, date_creation, date_modification, fk_qualificatif_objet_source, fk_role_objet_source, libelle_original_objet_source, valeur_objet_source, fk_unite_de_mesure) VALUES (714, 925, 37, 19, NULL, NULL, NULL, NULL, '2015-11-11 23:13:37.694065+01', NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO association_objets (pk_association_objets, fk_objet_source, fk_objet_cible, fk_type_association_param, reference_precise_objet_source, url_objet_source, descriptif, notes, date_creation, date_modification, fk_qualificatif_objet_source, fk_role_objet_source, libelle_original_objet_source, valeur_objet_source, fk_unite_de_mesure) VALUES (715, 924, 37, 19, NULL, NULL, NULL, NULL, '2015-11-11 23:13:37.694065+01', NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO association_objets (pk_association_objets, fk_objet_source, fk_objet_cible, fk_type_association_param, reference_precise_objet_source, url_objet_source, descriptif, notes, date_creation, date_modification, fk_qualificatif_objet_source, fk_role_objet_source, libelle_original_objet_source, valeur_objet_source, fk_unite_de_mesure) VALUES (716, 923, 37, 19, NULL, NULL, NULL, NULL, '2015-11-11 23:13:37.694065+01', NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO association_objets (pk_association_objets, fk_objet_source, fk_objet_cible, fk_type_association_param, reference_precise_objet_source, url_objet_source, descriptif, notes, date_creation, date_modification, fk_qualificatif_objet_source, fk_role_objet_source, libelle_original_objet_source, valeur_objet_source, fk_unite_de_mesure) VALUES (717, 922, 37, 19, NULL, NULL, NULL, NULL, '2015-11-11 23:13:37.694065+01', NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO association_objets (pk_association_objets, fk_objet_source, fk_objet_cible, fk_type_association_param, reference_precise_objet_source, url_objet_source, descriptif, notes, date_creation, date_modification, fk_qualificatif_objet_source, fk_role_objet_source, libelle_original_objet_source, valeur_objet_source, fk_unite_de_mesure) VALUES (718, 921, 37, 19, NULL, NULL, NULL, NULL, '2015-11-11 23:13:37.694065+01', NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO association_objets (pk_association_objets, fk_objet_source, fk_objet_cible, fk_type_association_param, reference_precise_objet_source, url_objet_source, descriptif, notes, date_creation, date_modification, fk_qualificatif_objet_source, fk_role_objet_source, libelle_original_objet_source, valeur_objet_source, fk_unite_de_mesure) VALUES (719, 920, 37, 19, NULL, NULL, NULL, NULL, '2015-11-11 23:13:37.694065+01', NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO association_objets (pk_association_objets, fk_objet_source, fk_objet_cible, fk_type_association_param, reference_precise_objet_source, url_objet_source, descriptif, notes, date_creation, date_modification, fk_qualificatif_objet_source, fk_role_objet_source, libelle_original_objet_source, valeur_objet_source, fk_unite_de_mesure) VALUES (720, 919, 37, 19, NULL, NULL, NULL, NULL, '2015-11-11 23:13:37.694065+01', NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO association_objets (pk_association_objets, fk_objet_source, fk_objet_cible, fk_type_association_param, reference_precise_objet_source, url_objet_source, descriptif, notes, date_creation, date_modification, fk_qualificatif_objet_source, fk_role_objet_source, libelle_original_objet_source, valeur_objet_source, fk_unite_de_mesure) VALUES (721, 918, 37, 19, NULL, NULL, NULL, NULL, '2015-11-11 23:13:37.694065+01', NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO association_objets (pk_association_objets, fk_objet_source, fk_objet_cible, fk_type_association_param, reference_precise_objet_source, url_objet_source, descriptif, notes, date_creation, date_modification, fk_qualificatif_objet_source, fk_role_objet_source, libelle_original_objet_source, valeur_objet_source, fk_unite_de_mesure) VALUES (722, 917, 37, 19, NULL, NULL, NULL, NULL, '2015-11-11 23:13:37.694065+01', NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO association_objets (pk_association_objets, fk_objet_source, fk_objet_cible, fk_type_association_param, reference_precise_objet_source, url_objet_source, descriptif, notes, date_creation, date_modification, fk_qualificatif_objet_source, fk_role_objet_source, libelle_original_objet_source, valeur_objet_source, fk_unite_de_mesure) VALUES (723, 916, 37, 19, NULL, NULL, NULL, NULL, '2015-11-11 23:13:37.694065+01', NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO association_objets (pk_association_objets, fk_objet_source, fk_objet_cible, fk_type_association_param, reference_precise_objet_source, url_objet_source, descriptif, notes, date_creation, date_modification, fk_qualificatif_objet_source, fk_role_objet_source, libelle_original_objet_source, valeur_objet_source, fk_unite_de_mesure) VALUES (724, 915, 37, 19, NULL, NULL, NULL, NULL, '2015-11-11 23:13:37.694065+01', NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO association_objets (pk_association_objets, fk_objet_source, fk_objet_cible, fk_type_association_param, reference_precise_objet_source, url_objet_source, descriptif, notes, date_creation, date_modification, fk_qualificatif_objet_source, fk_role_objet_source, libelle_original_objet_source, valeur_objet_source, fk_unite_de_mesure) VALUES (725, 914, 37, 19, NULL, NULL, NULL, NULL, '2015-11-11 23:13:37.694065+01', NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO association_objets (pk_association_objets, fk_objet_source, fk_objet_cible, fk_type_association_param, reference_precise_objet_source, url_objet_source, descriptif, notes, date_creation, date_modification, fk_qualificatif_objet_source, fk_role_objet_source, libelle_original_objet_source, valeur_objet_source, fk_unite_de_mesure) VALUES (726, 913, 37, 19, NULL, NULL, NULL, NULL, '2015-11-11 23:13:37.694065+01', NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO association_objets (pk_association_objets, fk_objet_source, fk_objet_cible, fk_type_association_param, reference_precise_objet_source, url_objet_source, descriptif, notes, date_creation, date_modification, fk_qualificatif_objet_source, fk_role_objet_source, libelle_original_objet_source, valeur_objet_source, fk_unite_de_mesure) VALUES (727, 912, 37, 19, NULL, NULL, NULL, NULL, '2015-11-11 23:13:37.694065+01', NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO association_objets (pk_association_objets, fk_objet_source, fk_objet_cible, fk_type_association_param, reference_precise_objet_source, url_objet_source, descriptif, notes, date_creation, date_modification, fk_qualificatif_objet_source, fk_role_objet_source, libelle_original_objet_source, valeur_objet_source, fk_unite_de_mesure) VALUES (728, 911, 37, 19, NULL, NULL, NULL, NULL, '2015-11-11 23:13:37.694065+01', NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO association_objets (pk_association_objets, fk_objet_source, fk_objet_cible, fk_type_association_param, reference_precise_objet_source, url_objet_source, descriptif, notes, date_creation, date_modification, fk_qualificatif_objet_source, fk_role_objet_source, libelle_original_objet_source, valeur_objet_source, fk_unite_de_mesure) VALUES (729, 910, 37, 19, NULL, NULL, NULL, NULL, '2015-11-11 23:13:37.694065+01', NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO association_objets (pk_association_objets, fk_objet_source, fk_objet_cible, fk_type_association_param, reference_precise_objet_source, url_objet_source, descriptif, notes, date_creation, date_modification, fk_qualificatif_objet_source, fk_role_objet_source, libelle_original_objet_source, valeur_objet_source, fk_unite_de_mesure) VALUES (730, 909, 37, 19, NULL, NULL, NULL, NULL, '2015-11-11 23:13:37.694065+01', NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO association_objets (pk_association_objets, fk_objet_source, fk_objet_cible, fk_type_association_param, reference_precise_objet_source, url_objet_source, descriptif, notes, date_creation, date_modification, fk_qualificatif_objet_source, fk_role_objet_source, libelle_original_objet_source, valeur_objet_source, fk_unite_de_mesure) VALUES (731, 908, 37, 19, NULL, NULL, NULL, NULL, '2015-11-11 23:13:37.694065+01', NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO association_objets (pk_association_objets, fk_objet_source, fk_objet_cible, fk_type_association_param, reference_precise_objet_source, url_objet_source, descriptif, notes, date_creation, date_modification, fk_qualificatif_objet_source, fk_role_objet_source, libelle_original_objet_source, valeur_objet_source, fk_unite_de_mesure) VALUES (732, 907, 37, 19, NULL, NULL, NULL, NULL, '2015-11-11 23:13:37.694065+01', NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO association_objets (pk_association_objets, fk_objet_source, fk_objet_cible, fk_type_association_param, reference_precise_objet_source, url_objet_source, descriptif, notes, date_creation, date_modification, fk_qualificatif_objet_source, fk_role_objet_source, libelle_original_objet_source, valeur_objet_source, fk_unite_de_mesure) VALUES (733, 906, 37, 19, NULL, NULL, NULL, NULL, '2015-11-11 23:13:37.694065+01', NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO association_objets (pk_association_objets, fk_objet_source, fk_objet_cible, fk_type_association_param, reference_precise_objet_source, url_objet_source, descriptif, notes, date_creation, date_modification, fk_qualificatif_objet_source, fk_role_objet_source, libelle_original_objet_source, valeur_objet_source, fk_unite_de_mesure) VALUES (734, 905, 37, 19, NULL, NULL, NULL, NULL, '2015-11-11 23:13:37.694065+01', NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO association_objets (pk_association_objets, fk_objet_source, fk_objet_cible, fk_type_association_param, reference_precise_objet_source, url_objet_source, descriptif, notes, date_creation, date_modification, fk_qualificatif_objet_source, fk_role_objet_source, libelle_original_objet_source, valeur_objet_source, fk_unite_de_mesure) VALUES (735, 904, 37, 19, NULL, NULL, NULL, NULL, '2015-11-11 23:13:37.694065+01', NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO association_objets (pk_association_objets, fk_objet_source, fk_objet_cible, fk_type_association_param, reference_precise_objet_source, url_objet_source, descriptif, notes, date_creation, date_modification, fk_qualificatif_objet_source, fk_role_objet_source, libelle_original_objet_source, valeur_objet_source, fk_unite_de_mesure) VALUES (736, 903, 37, 19, NULL, NULL, NULL, NULL, '2015-11-11 23:13:37.694065+01', NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO association_objets (pk_association_objets, fk_objet_source, fk_objet_cible, fk_type_association_param, reference_precise_objet_source, url_objet_source, descriptif, notes, date_creation, date_modification, fk_qualificatif_objet_source, fk_role_objet_source, libelle_original_objet_source, valeur_objet_source, fk_unite_de_mesure) VALUES (737, 902, 37, 19, NULL, NULL, NULL, NULL, '2015-11-11 23:13:37.694065+01', NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO association_objets (pk_association_objets, fk_objet_source, fk_objet_cible, fk_type_association_param, reference_precise_objet_source, url_objet_source, descriptif, notes, date_creation, date_modification, fk_qualificatif_objet_source, fk_role_objet_source, libelle_original_objet_source, valeur_objet_source, fk_unite_de_mesure) VALUES (738, 901, 37, 19, NULL, NULL, NULL, NULL, '2015-11-11 23:13:37.694065+01', NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO association_objets (pk_association_objets, fk_objet_source, fk_objet_cible, fk_type_association_param, reference_precise_objet_source, url_objet_source, descriptif, notes, date_creation, date_modification, fk_qualificatif_objet_source, fk_role_objet_source, libelle_original_objet_source, valeur_objet_source, fk_unite_de_mesure) VALUES (739, 900, 37, 19, NULL, NULL, NULL, NULL, '2015-11-11 23:13:37.694065+01', NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO association_objets (pk_association_objets, fk_objet_source, fk_objet_cible, fk_type_association_param, reference_precise_objet_source, url_objet_source, descriptif, notes, date_creation, date_modification, fk_qualificatif_objet_source, fk_role_objet_source, libelle_original_objet_source, valeur_objet_source, fk_unite_de_mesure) VALUES (740, 899, 37, 19, NULL, NULL, NULL, NULL, '2015-11-11 23:13:37.694065+01', NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO association_objets (pk_association_objets, fk_objet_source, fk_objet_cible, fk_type_association_param, reference_precise_objet_source, url_objet_source, descriptif, notes, date_creation, date_modification, fk_qualificatif_objet_source, fk_role_objet_source, libelle_original_objet_source, valeur_objet_source, fk_unite_de_mesure) VALUES (741, 898, 37, 19, NULL, NULL, NULL, NULL, '2015-11-11 23:13:37.694065+01', NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO association_objets (pk_association_objets, fk_objet_source, fk_objet_cible, fk_type_association_param, reference_precise_objet_source, url_objet_source, descriptif, notes, date_creation, date_modification, fk_qualificatif_objet_source, fk_role_objet_source, libelle_original_objet_source, valeur_objet_source, fk_unite_de_mesure) VALUES (742, 897, 37, 19, NULL, NULL, NULL, NULL, '2015-11-11 23:13:37.694065+01', NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO association_objets (pk_association_objets, fk_objet_source, fk_objet_cible, fk_type_association_param, reference_precise_objet_source, url_objet_source, descriptif, notes, date_creation, date_modification, fk_qualificatif_objet_source, fk_role_objet_source, libelle_original_objet_source, valeur_objet_source, fk_unite_de_mesure) VALUES (743, 896, 37, 19, NULL, NULL, NULL, NULL, '2015-11-11 23:13:37.694065+01', NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO association_objets (pk_association_objets, fk_objet_source, fk_objet_cible, fk_type_association_param, reference_precise_objet_source, url_objet_source, descriptif, notes, date_creation, date_modification, fk_qualificatif_objet_source, fk_role_objet_source, libelle_original_objet_source, valeur_objet_source, fk_unite_de_mesure) VALUES (744, 895, 37, 19, NULL, NULL, NULL, NULL, '2015-11-11 23:13:37.694065+01', NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO association_objets (pk_association_objets, fk_objet_source, fk_objet_cible, fk_type_association_param, reference_precise_objet_source, url_objet_source, descriptif, notes, date_creation, date_modification, fk_qualificatif_objet_source, fk_role_objet_source, libelle_original_objet_source, valeur_objet_source, fk_unite_de_mesure) VALUES (745, 894, 37, 19, NULL, NULL, NULL, NULL, '2015-11-11 23:13:37.694065+01', NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO association_objets (pk_association_objets, fk_objet_source, fk_objet_cible, fk_type_association_param, reference_precise_objet_source, url_objet_source, descriptif, notes, date_creation, date_modification, fk_qualificatif_objet_source, fk_role_objet_source, libelle_original_objet_source, valeur_objet_source, fk_unite_de_mesure) VALUES (746, 893, 37, 19, NULL, NULL, NULL, NULL, '2015-11-11 23:13:37.694065+01', NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO association_objets (pk_association_objets, fk_objet_source, fk_objet_cible, fk_type_association_param, reference_precise_objet_source, url_objet_source, descriptif, notes, date_creation, date_modification, fk_qualificatif_objet_source, fk_role_objet_source, libelle_original_objet_source, valeur_objet_source, fk_unite_de_mesure) VALUES (747, 892, 37, 19, NULL, NULL, NULL, NULL, '2015-11-11 23:13:37.694065+01', NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO association_objets (pk_association_objets, fk_objet_source, fk_objet_cible, fk_type_association_param, reference_precise_objet_source, url_objet_source, descriptif, notes, date_creation, date_modification, fk_qualificatif_objet_source, fk_role_objet_source, libelle_original_objet_source, valeur_objet_source, fk_unite_de_mesure) VALUES (748, 891, 37, 19, NULL, NULL, NULL, NULL, '2015-11-11 23:13:37.694065+01', NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO association_objets (pk_association_objets, fk_objet_source, fk_objet_cible, fk_type_association_param, reference_precise_objet_source, url_objet_source, descriptif, notes, date_creation, date_modification, fk_qualificatif_objet_source, fk_role_objet_source, libelle_original_objet_source, valeur_objet_source, fk_unite_de_mesure) VALUES (749, 890, 37, 19, NULL, NULL, NULL, NULL, '2015-11-11 23:13:37.694065+01', NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO association_objets (pk_association_objets, fk_objet_source, fk_objet_cible, fk_type_association_param, reference_precise_objet_source, url_objet_source, descriptif, notes, date_creation, date_modification, fk_qualificatif_objet_source, fk_role_objet_source, libelle_original_objet_source, valeur_objet_source, fk_unite_de_mesure) VALUES (750, 889, 37, 19, NULL, NULL, NULL, NULL, '2015-11-11 23:13:37.694065+01', NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO association_objets (pk_association_objets, fk_objet_source, fk_objet_cible, fk_type_association_param, reference_precise_objet_source, url_objet_source, descriptif, notes, date_creation, date_modification, fk_qualificatif_objet_source, fk_role_objet_source, libelle_original_objet_source, valeur_objet_source, fk_unite_de_mesure) VALUES (751, 888, 37, 19, NULL, NULL, NULL, NULL, '2015-11-11 23:13:37.694065+01', NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO association_objets (pk_association_objets, fk_objet_source, fk_objet_cible, fk_type_association_param, reference_precise_objet_source, url_objet_source, descriptif, notes, date_creation, date_modification, fk_qualificatif_objet_source, fk_role_objet_source, libelle_original_objet_source, valeur_objet_source, fk_unite_de_mesure) VALUES (752, 887, 37, 19, NULL, NULL, NULL, NULL, '2015-11-11 23:13:37.694065+01', NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO association_objets (pk_association_objets, fk_objet_source, fk_objet_cible, fk_type_association_param, reference_precise_objet_source, url_objet_source, descriptif, notes, date_creation, date_modification, fk_qualificatif_objet_source, fk_role_objet_source, libelle_original_objet_source, valeur_objet_source, fk_unite_de_mesure) VALUES (753, 886, 37, 19, NULL, NULL, NULL, NULL, '2015-11-11 23:13:37.694065+01', NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO association_objets (pk_association_objets, fk_objet_source, fk_objet_cible, fk_type_association_param, reference_precise_objet_source, url_objet_source, descriptif, notes, date_creation, date_modification, fk_qualificatif_objet_source, fk_role_objet_source, libelle_original_objet_source, valeur_objet_source, fk_unite_de_mesure) VALUES (754, 885, 37, 19, NULL, NULL, NULL, NULL, '2015-11-11 23:13:37.694065+01', NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO association_objets (pk_association_objets, fk_objet_source, fk_objet_cible, fk_type_association_param, reference_precise_objet_source, url_objet_source, descriptif, notes, date_creation, date_modification, fk_qualificatif_objet_source, fk_role_objet_source, libelle_original_objet_source, valeur_objet_source, fk_unite_de_mesure) VALUES (755, 884, 37, 19, NULL, NULL, NULL, NULL, '2015-11-11 23:13:37.694065+01', NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO association_objets (pk_association_objets, fk_objet_source, fk_objet_cible, fk_type_association_param, reference_precise_objet_source, url_objet_source, descriptif, notes, date_creation, date_modification, fk_qualificatif_objet_source, fk_role_objet_source, libelle_original_objet_source, valeur_objet_source, fk_unite_de_mesure) VALUES (756, 883, 37, 19, NULL, NULL, NULL, NULL, '2015-11-11 23:13:37.694065+01', NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO association_objets (pk_association_objets, fk_objet_source, fk_objet_cible, fk_type_association_param, reference_precise_objet_source, url_objet_source, descriptif, notes, date_creation, date_modification, fk_qualificatif_objet_source, fk_role_objet_source, libelle_original_objet_source, valeur_objet_source, fk_unite_de_mesure) VALUES (757, 882, 37, 19, NULL, NULL, NULL, NULL, '2015-11-11 23:13:37.694065+01', NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO association_objets (pk_association_objets, fk_objet_source, fk_objet_cible, fk_type_association_param, reference_precise_objet_source, url_objet_source, descriptif, notes, date_creation, date_modification, fk_qualificatif_objet_source, fk_role_objet_source, libelle_original_objet_source, valeur_objet_source, fk_unite_de_mesure) VALUES (758, 881, 37, 19, NULL, NULL, NULL, NULL, '2015-11-11 23:13:37.694065+01', NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO association_objets (pk_association_objets, fk_objet_source, fk_objet_cible, fk_type_association_param, reference_precise_objet_source, url_objet_source, descriptif, notes, date_creation, date_modification, fk_qualificatif_objet_source, fk_role_objet_source, libelle_original_objet_source, valeur_objet_source, fk_unite_de_mesure) VALUES (759, 880, 37, 19, NULL, NULL, NULL, NULL, '2015-11-11 23:13:37.694065+01', NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO association_objets (pk_association_objets, fk_objet_source, fk_objet_cible, fk_type_association_param, reference_precise_objet_source, url_objet_source, descriptif, notes, date_creation, date_modification, fk_qualificatif_objet_source, fk_role_objet_source, libelle_original_objet_source, valeur_objet_source, fk_unite_de_mesure) VALUES (760, 879, 37, 19, NULL, NULL, NULL, NULL, '2015-11-11 23:13:37.694065+01', NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO association_objets (pk_association_objets, fk_objet_source, fk_objet_cible, fk_type_association_param, reference_precise_objet_source, url_objet_source, descriptif, notes, date_creation, date_modification, fk_qualificatif_objet_source, fk_role_objet_source, libelle_original_objet_source, valeur_objet_source, fk_unite_de_mesure) VALUES (761, 878, 37, 19, NULL, NULL, NULL, NULL, '2015-11-11 23:13:37.694065+01', NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO association_objets (pk_association_objets, fk_objet_source, fk_objet_cible, fk_type_association_param, reference_precise_objet_source, url_objet_source, descriptif, notes, date_creation, date_modification, fk_qualificatif_objet_source, fk_role_objet_source, libelle_original_objet_source, valeur_objet_source, fk_unite_de_mesure) VALUES (762, 877, 37, 19, NULL, NULL, NULL, NULL, '2015-11-11 23:13:37.694065+01', NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO association_objets (pk_association_objets, fk_objet_source, fk_objet_cible, fk_type_association_param, reference_precise_objet_source, url_objet_source, descriptif, notes, date_creation, date_modification, fk_qualificatif_objet_source, fk_role_objet_source, libelle_original_objet_source, valeur_objet_source, fk_unite_de_mesure) VALUES (763, 876, 37, 19, NULL, NULL, NULL, NULL, '2015-11-11 23:13:37.694065+01', NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO association_objets (pk_association_objets, fk_objet_source, fk_objet_cible, fk_type_association_param, reference_precise_objet_source, url_objet_source, descriptif, notes, date_creation, date_modification, fk_qualificatif_objet_source, fk_role_objet_source, libelle_original_objet_source, valeur_objet_source, fk_unite_de_mesure) VALUES (764, 875, 37, 19, NULL, NULL, NULL, NULL, '2015-11-11 23:13:37.694065+01', NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO association_objets (pk_association_objets, fk_objet_source, fk_objet_cible, fk_type_association_param, reference_precise_objet_source, url_objet_source, descriptif, notes, date_creation, date_modification, fk_qualificatif_objet_source, fk_role_objet_source, libelle_original_objet_source, valeur_objet_source, fk_unite_de_mesure) VALUES (765, 874, 37, 19, NULL, NULL, NULL, NULL, '2015-11-11 23:13:37.694065+01', NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO association_objets (pk_association_objets, fk_objet_source, fk_objet_cible, fk_type_association_param, reference_precise_objet_source, url_objet_source, descriptif, notes, date_creation, date_modification, fk_qualificatif_objet_source, fk_role_objet_source, libelle_original_objet_source, valeur_objet_source, fk_unite_de_mesure) VALUES (766, 873, 37, 19, NULL, NULL, NULL, NULL, '2015-11-11 23:13:37.694065+01', NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO association_objets (pk_association_objets, fk_objet_source, fk_objet_cible, fk_type_association_param, reference_precise_objet_source, url_objet_source, descriptif, notes, date_creation, date_modification, fk_qualificatif_objet_source, fk_role_objet_source, libelle_original_objet_source, valeur_objet_source, fk_unite_de_mesure) VALUES (767, 872, 37, 19, NULL, NULL, NULL, NULL, '2015-11-11 23:13:37.694065+01', NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO association_objets (pk_association_objets, fk_objet_source, fk_objet_cible, fk_type_association_param, reference_precise_objet_source, url_objet_source, descriptif, notes, date_creation, date_modification, fk_qualificatif_objet_source, fk_role_objet_source, libelle_original_objet_source, valeur_objet_source, fk_unite_de_mesure) VALUES (768, 871, 37, 19, NULL, NULL, NULL, NULL, '2015-11-11 23:13:37.694065+01', NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO association_objets (pk_association_objets, fk_objet_source, fk_objet_cible, fk_type_association_param, reference_precise_objet_source, url_objet_source, descriptif, notes, date_creation, date_modification, fk_qualificatif_objet_source, fk_role_objet_source, libelle_original_objet_source, valeur_objet_source, fk_unite_de_mesure) VALUES (769, 870, 37, 19, NULL, NULL, NULL, NULL, '2015-11-11 23:13:37.694065+01', NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO association_objets (pk_association_objets, fk_objet_source, fk_objet_cible, fk_type_association_param, reference_precise_objet_source, url_objet_source, descriptif, notes, date_creation, date_modification, fk_qualificatif_objet_source, fk_role_objet_source, libelle_original_objet_source, valeur_objet_source, fk_unite_de_mesure) VALUES (770, 869, 37, 19, NULL, NULL, NULL, NULL, '2015-11-11 23:13:37.694065+01', NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO association_objets (pk_association_objets, fk_objet_source, fk_objet_cible, fk_type_association_param, reference_precise_objet_source, url_objet_source, descriptif, notes, date_creation, date_modification, fk_qualificatif_objet_source, fk_role_objet_source, libelle_original_objet_source, valeur_objet_source, fk_unite_de_mesure) VALUES (771, 868, 37, 19, NULL, NULL, NULL, NULL, '2015-11-11 23:13:37.694065+01', NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO association_objets (pk_association_objets, fk_objet_source, fk_objet_cible, fk_type_association_param, reference_precise_objet_source, url_objet_source, descriptif, notes, date_creation, date_modification, fk_qualificatif_objet_source, fk_role_objet_source, libelle_original_objet_source, valeur_objet_source, fk_unite_de_mesure) VALUES (772, 867, 37, 19, NULL, NULL, NULL, NULL, '2015-11-11 23:13:37.694065+01', NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO association_objets (pk_association_objets, fk_objet_source, fk_objet_cible, fk_type_association_param, reference_precise_objet_source, url_objet_source, descriptif, notes, date_creation, date_modification, fk_qualificatif_objet_source, fk_role_objet_source, libelle_original_objet_source, valeur_objet_source, fk_unite_de_mesure) VALUES (773, 866, 37, 19, NULL, NULL, NULL, NULL, '2015-11-11 23:13:37.694065+01', NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO association_objets (pk_association_objets, fk_objet_source, fk_objet_cible, fk_type_association_param, reference_precise_objet_source, url_objet_source, descriptif, notes, date_creation, date_modification, fk_qualificatif_objet_source, fk_role_objet_source, libelle_original_objet_source, valeur_objet_source, fk_unite_de_mesure) VALUES (774, 865, 37, 19, NULL, NULL, NULL, NULL, '2015-11-11 23:13:37.694065+01', NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO association_objets (pk_association_objets, fk_objet_source, fk_objet_cible, fk_type_association_param, reference_precise_objet_source, url_objet_source, descriptif, notes, date_creation, date_modification, fk_qualificatif_objet_source, fk_role_objet_source, libelle_original_objet_source, valeur_objet_source, fk_unite_de_mesure) VALUES (775, 864, 37, 19, NULL, NULL, NULL, NULL, '2015-11-11 23:13:37.694065+01', NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO association_objets (pk_association_objets, fk_objet_source, fk_objet_cible, fk_type_association_param, reference_precise_objet_source, url_objet_source, descriptif, notes, date_creation, date_modification, fk_qualificatif_objet_source, fk_role_objet_source, libelle_original_objet_source, valeur_objet_source, fk_unite_de_mesure) VALUES (776, 863, 37, 19, NULL, NULL, NULL, NULL, '2015-11-11 23:13:37.694065+01', NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO association_objets (pk_association_objets, fk_objet_source, fk_objet_cible, fk_type_association_param, reference_precise_objet_source, url_objet_source, descriptif, notes, date_creation, date_modification, fk_qualificatif_objet_source, fk_role_objet_source, libelle_original_objet_source, valeur_objet_source, fk_unite_de_mesure) VALUES (777, 862, 37, 19, NULL, NULL, NULL, NULL, '2015-11-11 23:13:37.694065+01', NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO association_objets (pk_association_objets, fk_objet_source, fk_objet_cible, fk_type_association_param, reference_precise_objet_source, url_objet_source, descriptif, notes, date_creation, date_modification, fk_qualificatif_objet_source, fk_role_objet_source, libelle_original_objet_source, valeur_objet_source, fk_unite_de_mesure) VALUES (778, 861, 37, 19, NULL, NULL, NULL, NULL, '2015-11-11 23:13:37.694065+01', NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO association_objets (pk_association_objets, fk_objet_source, fk_objet_cible, fk_type_association_param, reference_precise_objet_source, url_objet_source, descriptif, notes, date_creation, date_modification, fk_qualificatif_objet_source, fk_role_objet_source, libelle_original_objet_source, valeur_objet_source, fk_unite_de_mesure) VALUES (779, 860, 37, 19, NULL, NULL, NULL, NULL, '2015-11-11 23:13:37.694065+01', NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO association_objets (pk_association_objets, fk_objet_source, fk_objet_cible, fk_type_association_param, reference_precise_objet_source, url_objet_source, descriptif, notes, date_creation, date_modification, fk_qualificatif_objet_source, fk_role_objet_source, libelle_original_objet_source, valeur_objet_source, fk_unite_de_mesure) VALUES (780, 859, 37, 19, NULL, NULL, NULL, NULL, '2015-11-11 23:13:37.694065+01', NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO association_objets (pk_association_objets, fk_objet_source, fk_objet_cible, fk_type_association_param, reference_precise_objet_source, url_objet_source, descriptif, notes, date_creation, date_modification, fk_qualificatif_objet_source, fk_role_objet_source, libelle_original_objet_source, valeur_objet_source, fk_unite_de_mesure) VALUES (781, 858, 37, 19, NULL, NULL, NULL, NULL, '2015-11-11 23:13:37.694065+01', NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO association_objets (pk_association_objets, fk_objet_source, fk_objet_cible, fk_type_association_param, reference_precise_objet_source, url_objet_source, descriptif, notes, date_creation, date_modification, fk_qualificatif_objet_source, fk_role_objet_source, libelle_original_objet_source, valeur_objet_source, fk_unite_de_mesure) VALUES (782, 857, 37, 19, NULL, NULL, NULL, NULL, '2015-11-11 23:13:37.694065+01', NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO association_objets (pk_association_objets, fk_objet_source, fk_objet_cible, fk_type_association_param, reference_precise_objet_source, url_objet_source, descriptif, notes, date_creation, date_modification, fk_qualificatif_objet_source, fk_role_objet_source, libelle_original_objet_source, valeur_objet_source, fk_unite_de_mesure) VALUES (783, 856, 37, 19, NULL, NULL, NULL, NULL, '2015-11-11 23:13:37.694065+01', NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO association_objets (pk_association_objets, fk_objet_source, fk_objet_cible, fk_type_association_param, reference_precise_objet_source, url_objet_source, descriptif, notes, date_creation, date_modification, fk_qualificatif_objet_source, fk_role_objet_source, libelle_original_objet_source, valeur_objet_source, fk_unite_de_mesure) VALUES (784, 855, 37, 19, NULL, NULL, NULL, NULL, '2015-11-11 23:13:37.694065+01', NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO association_objets (pk_association_objets, fk_objet_source, fk_objet_cible, fk_type_association_param, reference_precise_objet_source, url_objet_source, descriptif, notes, date_creation, date_modification, fk_qualificatif_objet_source, fk_role_objet_source, libelle_original_objet_source, valeur_objet_source, fk_unite_de_mesure) VALUES (785, 854, 37, 19, NULL, NULL, NULL, NULL, '2015-11-11 23:13:37.694065+01', NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO association_objets (pk_association_objets, fk_objet_source, fk_objet_cible, fk_type_association_param, reference_precise_objet_source, url_objet_source, descriptif, notes, date_creation, date_modification, fk_qualificatif_objet_source, fk_role_objet_source, libelle_original_objet_source, valeur_objet_source, fk_unite_de_mesure) VALUES (786, 853, 37, 19, NULL, NULL, NULL, NULL, '2015-11-11 23:13:37.694065+01', NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO association_objets (pk_association_objets, fk_objet_source, fk_objet_cible, fk_type_association_param, reference_precise_objet_source, url_objet_source, descriptif, notes, date_creation, date_modification, fk_qualificatif_objet_source, fk_role_objet_source, libelle_original_objet_source, valeur_objet_source, fk_unite_de_mesure) VALUES (787, 852, 37, 19, NULL, NULL, NULL, NULL, '2015-11-11 23:13:37.694065+01', NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO association_objets (pk_association_objets, fk_objet_source, fk_objet_cible, fk_type_association_param, reference_precise_objet_source, url_objet_source, descriptif, notes, date_creation, date_modification, fk_qualificatif_objet_source, fk_role_objet_source, libelle_original_objet_source, valeur_objet_source, fk_unite_de_mesure) VALUES (788, 851, 37, 19, NULL, NULL, NULL, NULL, '2015-11-11 23:13:37.694065+01', NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO association_objets (pk_association_objets, fk_objet_source, fk_objet_cible, fk_type_association_param, reference_precise_objet_source, url_objet_source, descriptif, notes, date_creation, date_modification, fk_qualificatif_objet_source, fk_role_objet_source, libelle_original_objet_source, valeur_objet_source, fk_unite_de_mesure) VALUES (789, 850, 37, 19, NULL, NULL, NULL, NULL, '2015-11-11 23:13:37.694065+01', NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO association_objets (pk_association_objets, fk_objet_source, fk_objet_cible, fk_type_association_param, reference_precise_objet_source, url_objet_source, descriptif, notes, date_creation, date_modification, fk_qualificatif_objet_source, fk_role_objet_source, libelle_original_objet_source, valeur_objet_source, fk_unite_de_mesure) VALUES (790, 849, 37, 19, NULL, NULL, NULL, NULL, '2015-11-11 23:13:37.694065+01', NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO association_objets (pk_association_objets, fk_objet_source, fk_objet_cible, fk_type_association_param, reference_precise_objet_source, url_objet_source, descriptif, notes, date_creation, date_modification, fk_qualificatif_objet_source, fk_role_objet_source, libelle_original_objet_source, valeur_objet_source, fk_unite_de_mesure) VALUES (791, 848, 37, 19, NULL, NULL, NULL, NULL, '2015-11-11 23:13:37.694065+01', NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO association_objets (pk_association_objets, fk_objet_source, fk_objet_cible, fk_type_association_param, reference_precise_objet_source, url_objet_source, descriptif, notes, date_creation, date_modification, fk_qualificatif_objet_source, fk_role_objet_source, libelle_original_objet_source, valeur_objet_source, fk_unite_de_mesure) VALUES (792, 847, 37, 19, NULL, NULL, NULL, NULL, '2015-11-11 23:13:37.694065+01', NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO association_objets (pk_association_objets, fk_objet_source, fk_objet_cible, fk_type_association_param, reference_precise_objet_source, url_objet_source, descriptif, notes, date_creation, date_modification, fk_qualificatif_objet_source, fk_role_objet_source, libelle_original_objet_source, valeur_objet_source, fk_unite_de_mesure) VALUES (793, 846, 37, 19, NULL, NULL, NULL, NULL, '2015-11-11 23:13:37.694065+01', NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO association_objets (pk_association_objets, fk_objet_source, fk_objet_cible, fk_type_association_param, reference_precise_objet_source, url_objet_source, descriptif, notes, date_creation, date_modification, fk_qualificatif_objet_source, fk_role_objet_source, libelle_original_objet_source, valeur_objet_source, fk_unite_de_mesure) VALUES (794, 845, 37, 19, NULL, NULL, NULL, NULL, '2015-11-11 23:13:37.694065+01', NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO association_objets (pk_association_objets, fk_objet_source, fk_objet_cible, fk_type_association_param, reference_precise_objet_source, url_objet_source, descriptif, notes, date_creation, date_modification, fk_qualificatif_objet_source, fk_role_objet_source, libelle_original_objet_source, valeur_objet_source, fk_unite_de_mesure) VALUES (795, 844, 37, 19, NULL, NULL, NULL, NULL, '2015-11-11 23:13:37.694065+01', NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO association_objets (pk_association_objets, fk_objet_source, fk_objet_cible, fk_type_association_param, reference_precise_objet_source, url_objet_source, descriptif, notes, date_creation, date_modification, fk_qualificatif_objet_source, fk_role_objet_source, libelle_original_objet_source, valeur_objet_source, fk_unite_de_mesure) VALUES (796, 843, 37, 19, NULL, NULL, NULL, NULL, '2015-11-11 23:13:37.694065+01', NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO association_objets (pk_association_objets, fk_objet_source, fk_objet_cible, fk_type_association_param, reference_precise_objet_source, url_objet_source, descriptif, notes, date_creation, date_modification, fk_qualificatif_objet_source, fk_role_objet_source, libelle_original_objet_source, valeur_objet_source, fk_unite_de_mesure) VALUES (797, 842, 37, 19, NULL, NULL, NULL, NULL, '2015-11-11 23:13:37.694065+01', NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO association_objets (pk_association_objets, fk_objet_source, fk_objet_cible, fk_type_association_param, reference_precise_objet_source, url_objet_source, descriptif, notes, date_creation, date_modification, fk_qualificatif_objet_source, fk_role_objet_source, libelle_original_objet_source, valeur_objet_source, fk_unite_de_mesure) VALUES (798, 841, 37, 19, NULL, NULL, NULL, NULL, '2015-11-11 23:13:37.694065+01', NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO association_objets (pk_association_objets, fk_objet_source, fk_objet_cible, fk_type_association_param, reference_precise_objet_source, url_objet_source, descriptif, notes, date_creation, date_modification, fk_qualificatif_objet_source, fk_role_objet_source, libelle_original_objet_source, valeur_objet_source, fk_unite_de_mesure) VALUES (799, 840, 37, 19, NULL, NULL, NULL, NULL, '2015-11-11 23:13:37.694065+01', NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO association_objets (pk_association_objets, fk_objet_source, fk_objet_cible, fk_type_association_param, reference_precise_objet_source, url_objet_source, descriptif, notes, date_creation, date_modification, fk_qualificatif_objet_source, fk_role_objet_source, libelle_original_objet_source, valeur_objet_source, fk_unite_de_mesure) VALUES (800, 839, 37, 19, NULL, NULL, NULL, NULL, '2015-11-11 23:13:37.694065+01', NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO association_objets (pk_association_objets, fk_objet_source, fk_objet_cible, fk_type_association_param, reference_precise_objet_source, url_objet_source, descriptif, notes, date_creation, date_modification, fk_qualificatif_objet_source, fk_role_objet_source, libelle_original_objet_source, valeur_objet_source, fk_unite_de_mesure) VALUES (801, 838, 37, 19, NULL, NULL, NULL, NULL, '2015-11-11 23:13:37.694065+01', NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO association_objets (pk_association_objets, fk_objet_source, fk_objet_cible, fk_type_association_param, reference_precise_objet_source, url_objet_source, descriptif, notes, date_creation, date_modification, fk_qualificatif_objet_source, fk_role_objet_source, libelle_original_objet_source, valeur_objet_source, fk_unite_de_mesure) VALUES (802, 837, 37, 19, NULL, NULL, NULL, NULL, '2015-11-11 23:13:37.694065+01', NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO association_objets (pk_association_objets, fk_objet_source, fk_objet_cible, fk_type_association_param, reference_precise_objet_source, url_objet_source, descriptif, notes, date_creation, date_modification, fk_qualificatif_objet_source, fk_role_objet_source, libelle_original_objet_source, valeur_objet_source, fk_unite_de_mesure) VALUES (803, 836, 37, 19, NULL, NULL, NULL, NULL, '2015-11-11 23:13:37.694065+01', NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO association_objets (pk_association_objets, fk_objet_source, fk_objet_cible, fk_type_association_param, reference_precise_objet_source, url_objet_source, descriptif, notes, date_creation, date_modification, fk_qualificatif_objet_source, fk_role_objet_source, libelle_original_objet_source, valeur_objet_source, fk_unite_de_mesure) VALUES (804, 835, 37, 19, NULL, NULL, NULL, NULL, '2015-11-11 23:13:37.694065+01', NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO association_objets (pk_association_objets, fk_objet_source, fk_objet_cible, fk_type_association_param, reference_precise_objet_source, url_objet_source, descriptif, notes, date_creation, date_modification, fk_qualificatif_objet_source, fk_role_objet_source, libelle_original_objet_source, valeur_objet_source, fk_unite_de_mesure) VALUES (805, 834, 37, 19, NULL, NULL, NULL, NULL, '2015-11-11 23:13:37.694065+01', NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO association_objets (pk_association_objets, fk_objet_source, fk_objet_cible, fk_type_association_param, reference_precise_objet_source, url_objet_source, descriptif, notes, date_creation, date_modification, fk_qualificatif_objet_source, fk_role_objet_source, libelle_original_objet_source, valeur_objet_source, fk_unite_de_mesure) VALUES (806, 833, 37, 19, NULL, NULL, NULL, NULL, '2015-11-11 23:13:37.694065+01', NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO association_objets (pk_association_objets, fk_objet_source, fk_objet_cible, fk_type_association_param, reference_precise_objet_source, url_objet_source, descriptif, notes, date_creation, date_modification, fk_qualificatif_objet_source, fk_role_objet_source, libelle_original_objet_source, valeur_objet_source, fk_unite_de_mesure) VALUES (807, 832, 37, 19, NULL, NULL, NULL, NULL, '2015-11-11 23:13:37.694065+01', NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO association_objets (pk_association_objets, fk_objet_source, fk_objet_cible, fk_type_association_param, reference_precise_objet_source, url_objet_source, descriptif, notes, date_creation, date_modification, fk_qualificatif_objet_source, fk_role_objet_source, libelle_original_objet_source, valeur_objet_source, fk_unite_de_mesure) VALUES (808, 831, 37, 19, NULL, NULL, NULL, NULL, '2015-11-11 23:13:37.694065+01', NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO association_objets (pk_association_objets, fk_objet_source, fk_objet_cible, fk_type_association_param, reference_precise_objet_source, url_objet_source, descriptif, notes, date_creation, date_modification, fk_qualificatif_objet_source, fk_role_objet_source, libelle_original_objet_source, valeur_objet_source, fk_unite_de_mesure) VALUES (809, 830, 37, 19, NULL, NULL, NULL, NULL, '2015-11-11 23:13:37.694065+01', NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO association_objets (pk_association_objets, fk_objet_source, fk_objet_cible, fk_type_association_param, reference_precise_objet_source, url_objet_source, descriptif, notes, date_creation, date_modification, fk_qualificatif_objet_source, fk_role_objet_source, libelle_original_objet_source, valeur_objet_source, fk_unite_de_mesure) VALUES (810, 829, 37, 19, NULL, NULL, NULL, NULL, '2015-11-11 23:13:37.694065+01', NULL, NULL, NULL, NULL, NULL, NULL);


--
-- TOC entry 2412 (class 0 OID 0)
-- Dependencies: 178
-- Name: associer_objets_pk_associer_objets_seq; Type: SEQUENCE SET; Schema: objets; Owner: -
--

SELECT pg_catalog.setval('associer_objets_pk_associer_objets_seq', 810, true);


--
-- TOC entry 2401 (class 0 OID 22815)
-- Dependencies: 188
-- Data for Name: date_objet; Type: TABLE DATA; Schema: objets; Owner: -
--

INSERT INTO date_objet (pk_date_objet, date_iso, fk_type_date_param, libelle_original_date, notes, descriptif, fk_objet, date_creation, date_modification, certitude) VALUES (2, '1630', 27, NULL, NULL, NULL, 2, '2015-10-02 14:17:45.118701+02', NULL, ' ');
INSERT INTO date_objet (pk_date_objet, date_iso, fk_type_date_param, libelle_original_date, notes, descriptif, fk_objet, date_creation, date_modification, certitude) VALUES (4, '1642', 27, NULL, NULL, NULL, 7, '2015-10-02 22:28:35.936273+02', NULL, NULL);
INSERT INTO date_objet (pk_date_objet, date_iso, fk_type_date_param, libelle_original_date, notes, descriptif, fk_objet, date_creation, date_modification, certitude) VALUES (7, '20151027', 25, NULL, NULL, NULL, 3, '2015-10-04 12:16:24.653578+02', '2015-11-10 15:29:26.376954+01', NULL);
INSERT INTO date_objet (pk_date_objet, date_iso, fk_type_date_param, libelle_original_date, notes, descriptif, fk_objet, date_creation, date_modification, certitude) VALUES (8, '1637', 27, NULL, NULL, NULL, 17, '2015-10-04 21:15:16.650704+02', NULL, NULL);
INSERT INTO date_objet (pk_date_objet, date_iso, fk_type_date_param, libelle_original_date, notes, descriptif, fk_objet, date_creation, date_modification, certitude) VALUES (1, '1571', 25, NULL, NULL, NULL, 2, '2015-10-01 20:17:45+02', '2015-10-04 22:52:57.837407+02', NULL);
INSERT INTO date_objet (pk_date_objet, date_iso, fk_type_date_param, libelle_original_date, notes, descriptif, fk_objet, date_creation, date_modification, certitude) VALUES (3, '1564', 25, NULL, NULL, NULL, 7, '2015-10-02 22:28:04.59748+02', '2015-10-04 23:06:33.201954+02', NULL);
INSERT INTO date_objet (pk_date_objet, date_iso, fk_type_date_param, libelle_original_date, notes, descriptif, fk_objet, date_creation, date_modification, certitude) VALUES (9, '1571', 25, NULL, NULL, NULL, 13, '2015-10-05 08:44:24.207099+02', NULL, NULL);
INSERT INTO date_objet (pk_date_objet, date_iso, fk_type_date_param, libelle_original_date, notes, descriptif, fk_objet, date_creation, date_modification, certitude) VALUES (6, '1580', 25, NULL, NULL, NULL, 17, '2015-10-03 10:56:25.356309+02', '2015-10-05 13:51:05.754774+02', NULL);
INSERT INTO date_objet (pk_date_objet, date_iso, fk_type_date_param, libelle_original_date, notes, descriptif, fk_objet, date_creation, date_modification, certitude) VALUES (10, '1473', 25, NULL, NULL, NULL, 30, '2015-10-13 15:01:29.86825+02', NULL, NULL);
INSERT INTO date_objet (pk_date_objet, date_iso, fk_type_date_param, libelle_original_date, notes, descriptif, fk_objet, date_creation, date_modification, certitude) VALUES (11, '1543', 27, NULL, NULL, NULL, 30, '2015-10-13 15:03:57.613771+02', NULL, NULL);
INSERT INTO date_objet (pk_date_objet, date_iso, fk_type_date_param, libelle_original_date, notes, descriptif, fk_objet, date_creation, date_modification, certitude) VALUES (13, '1644', 27, NULL, NULL, NULL, 31, '2015-10-13 15:10:55.45077+02', NULL, NULL);
INSERT INTO date_objet (pk_date_objet, date_iso, fk_type_date_param, libelle_original_date, notes, descriptif, fk_objet, date_creation, date_modification, certitude) VALUES (14, '2011', 26, NULL, NULL, NULL, 32, '2015-10-13 15:37:11.24158+02', NULL, NULL);
INSERT INTO date_objet (pk_date_objet, date_iso, fk_type_date_param, libelle_original_date, notes, descriptif, fk_objet, date_creation, date_modification, certitude) VALUES (15, '2015-10-13', 25, NULL, NULL, NULL, 33, '2015-10-13 15:43:05.942249+02', NULL, NULL);
INSERT INTO date_objet (pk_date_objet, date_iso, fk_type_date_param, libelle_original_date, notes, descriptif, fk_objet, date_creation, date_modification, certitude) VALUES (16, '1860', 26, NULL, NULL, NULL, 35, '2015-10-13 17:46:12.942494+02', NULL, NULL);
INSERT INTO date_objet (pk_date_objet, date_iso, fk_type_date_param, libelle_original_date, notes, descriptif, fk_objet, date_creation, date_modification, certitude) VALUES (12, '1568', 25, NULL, NULL, NULL, 31, '2015-10-13 15:09:58.391533+02', '2015-11-06 17:36:06.103893+01', NULL);
INSERT INTO date_objet (pk_date_objet, date_iso, fk_type_date_param, libelle_original_date, notes, descriptif, fk_objet, date_creation, date_modification, certitude) VALUES (17, '1604', 25, NULL, NULL, NULL, 851, '2015-11-06 18:13:56.804955+01', NULL, ' ');
INSERT INTO date_objet (pk_date_objet, date_iso, fk_type_date_param, libelle_original_date, notes, descriptif, fk_objet, date_creation, date_modification, certitude) VALUES (18, '1105', 25, NULL, NULL, NULL, 1053, '2015-11-06 18:13:56.804955+01', NULL, ' ');
INSERT INTO date_objet (pk_date_objet, date_iso, fk_type_date_param, libelle_original_date, notes, descriptif, fk_objet, date_creation, date_modification, certitude) VALUES (19, '1623', 25, NULL, NULL, NULL, 833, '2015-11-06 18:13:56.804955+01', NULL, ' ');
INSERT INTO date_objet (pk_date_objet, date_iso, fk_type_date_param, libelle_original_date, notes, descriptif, fk_objet, date_creation, date_modification, certitude) VALUES (20, '1640', 25, NULL, NULL, NULL, 1371, '2015-11-06 18:13:56.804955+01', NULL, ' ');
INSERT INTO date_objet (pk_date_objet, date_iso, fk_type_date_param, libelle_original_date, notes, descriptif, fk_objet, date_creation, date_modification, certitude) VALUES (21, '1110', 25, NULL, NULL, NULL, 1560, '2015-11-06 18:13:56.804955+01', NULL, ' ');
INSERT INTO date_objet (pk_date_objet, date_iso, fk_type_date_param, libelle_original_date, notes, descriptif, fk_objet, date_creation, date_modification, certitude) VALUES (22, '1114', 25, NULL, NULL, NULL, 924, '2015-11-06 18:13:56.804955+01', NULL, ' ');
INSERT INTO date_objet (pk_date_objet, date_iso, fk_type_date_param, libelle_original_date, notes, descriptif, fk_objet, date_creation, date_modification, certitude) VALUES (23, '1151', 25, NULL, NULL, NULL, 852, '2015-11-06 18:13:56.804955+01', NULL, 'p');
INSERT INTO date_objet (pk_date_objet, date_iso, fk_type_date_param, libelle_original_date, notes, descriptif, fk_objet, date_creation, date_modification, certitude) VALUES (24, '1151', 25, NULL, NULL, NULL, 1144, '2015-11-06 18:13:56.804955+01', NULL, 'p');
INSERT INTO date_objet (pk_date_objet, date_iso, fk_type_date_param, libelle_original_date, notes, descriptif, fk_objet, date_creation, date_modification, certitude) VALUES (25, '1170', 25, NULL, NULL, NULL, 1214, '2015-11-06 18:13:56.804955+01', NULL, ' ');
INSERT INTO date_objet (pk_date_objet, date_iso, fk_type_date_param, libelle_original_date, notes, descriptif, fk_objet, date_creation, date_modification, certitude) VALUES (26, '1170', 25, NULL, NULL, NULL, 1361, '2015-11-06 18:13:56.804955+01', NULL, ' ');
INSERT INTO date_objet (pk_date_objet, date_iso, fk_type_date_param, libelle_original_date, notes, descriptif, fk_objet, date_creation, date_modification, certitude) VALUES (27, '1201', 25, NULL, NULL, NULL, 1197, '2015-11-06 18:13:56.804955+01', NULL, ' ');
INSERT INTO date_objet (pk_date_objet, date_iso, fk_type_date_param, libelle_original_date, notes, descriptif, fk_objet, date_creation, date_modification, certitude) VALUES (28, '1220', 25, NULL, NULL, NULL, 1122, '2015-11-06 18:13:56.804955+01', NULL, ' ');
INSERT INTO date_objet (pk_date_objet, date_iso, fk_type_date_param, libelle_original_date, notes, descriptif, fk_objet, date_creation, date_modification, certitude) VALUES (29, '1220', 25, NULL, NULL, NULL, 987, '2015-11-06 18:13:56.804955+01', NULL, ' ');
INSERT INTO date_objet (pk_date_objet, date_iso, fk_type_date_param, libelle_original_date, notes, descriptif, fk_objet, date_creation, date_modification, certitude) VALUES (30, '1236', 25, NULL, NULL, NULL, 846, '2015-11-06 18:13:56.804955+01', NULL, ' ');
INSERT INTO date_objet (pk_date_objet, date_iso, fk_type_date_param, libelle_original_date, notes, descriptif, fk_objet, date_creation, date_modification, certitude) VALUES (31, '1238', 25, NULL, NULL, NULL, 1369, '2015-11-06 18:13:56.804955+01', NULL, ' ');
INSERT INTO date_objet (pk_date_objet, date_iso, fk_type_date_param, libelle_original_date, notes, descriptif, fk_objet, date_creation, date_modification, certitude) VALUES (32, '1240', 25, NULL, NULL, NULL, 904, '2015-11-06 18:13:56.804955+01', NULL, ' ');
INSERT INTO date_objet (pk_date_objet, date_iso, fk_type_date_param, libelle_original_date, notes, descriptif, fk_objet, date_creation, date_modification, certitude) VALUES (33, '1246', 25, NULL, NULL, NULL, 1126, '2015-11-06 18:13:56.804955+01', NULL, ' ');
INSERT INTO date_objet (pk_date_objet, date_iso, fk_type_date_param, libelle_original_date, notes, descriptif, fk_objet, date_creation, date_modification, certitude) VALUES (34, '1251', 25, NULL, NULL, NULL, 1306, '2015-11-06 18:13:56.804955+01', NULL, 'p');
INSERT INTO date_objet (pk_date_objet, date_iso, fk_type_date_param, libelle_original_date, notes, descriptif, fk_objet, date_creation, date_modification, certitude) VALUES (35, '1251', 25, NULL, NULL, NULL, 1339, '2015-11-06 18:13:56.804955+01', NULL, 'p');
INSERT INTO date_objet (pk_date_objet, date_iso, fk_type_date_param, libelle_original_date, notes, descriptif, fk_objet, date_creation, date_modification, certitude) VALUES (36, '1251', 25, NULL, NULL, NULL, 1551, '2015-11-06 18:13:56.804955+01', NULL, 'p');
INSERT INTO date_objet (pk_date_objet, date_iso, fk_type_date_param, libelle_original_date, notes, descriptif, fk_objet, date_creation, date_modification, certitude) VALUES (37, '1251', 25, NULL, NULL, NULL, 1509, '2015-11-06 18:13:56.804955+01', NULL, 'p');
INSERT INTO date_objet (pk_date_objet, date_iso, fk_type_date_param, libelle_original_date, notes, descriptif, fk_objet, date_creation, date_modification, certitude) VALUES (38, '1251', 25, NULL, NULL, NULL, 912, '2015-11-06 18:13:56.804955+01', NULL, 'p');
INSERT INTO date_objet (pk_date_objet, date_iso, fk_type_date_param, libelle_original_date, notes, descriptif, fk_objet, date_creation, date_modification, certitude) VALUES (39, '1251', 25, NULL, NULL, NULL, 1131, '2015-11-06 18:13:56.804955+01', NULL, 'p');
INSERT INTO date_objet (pk_date_objet, date_iso, fk_type_date_param, libelle_original_date, notes, descriptif, fk_objet, date_creation, date_modification, certitude) VALUES (40, '1251', 25, NULL, NULL, NULL, 895, '2015-11-06 18:13:56.804955+01', NULL, 'p');
INSERT INTO date_objet (pk_date_objet, date_iso, fk_type_date_param, libelle_original_date, notes, descriptif, fk_objet, date_creation, date_modification, certitude) VALUES (41, '1251', 25, NULL, NULL, NULL, 1553, '2015-11-06 18:13:56.804955+01', NULL, 'p');
INSERT INTO date_objet (pk_date_objet, date_iso, fk_type_date_param, libelle_original_date, notes, descriptif, fk_objet, date_creation, date_modification, certitude) VALUES (42, '1251', 25, NULL, NULL, NULL, 1114, '2015-11-06 18:13:56.804955+01', NULL, 'p');
INSERT INTO date_objet (pk_date_objet, date_iso, fk_type_date_param, libelle_original_date, notes, descriptif, fk_objet, date_creation, date_modification, certitude) VALUES (43, '1251', 25, NULL, NULL, NULL, 877, '2015-11-06 18:13:56.804955+01', NULL, 'p');
INSERT INTO date_objet (pk_date_objet, date_iso, fk_type_date_param, libelle_original_date, notes, descriptif, fk_objet, date_creation, date_modification, certitude) VALUES (44, '1251', 25, NULL, NULL, NULL, 849, '2015-11-06 18:13:56.804955+01', NULL, 'p');
INSERT INTO date_objet (pk_date_objet, date_iso, fk_type_date_param, libelle_original_date, notes, descriptif, fk_objet, date_creation, date_modification, certitude) VALUES (45, '1251', 25, NULL, NULL, NULL, 1436, '2015-11-06 18:13:56.804955+01', NULL, 'p');
INSERT INTO date_objet (pk_date_objet, date_iso, fk_type_date_param, libelle_original_date, notes, descriptif, fk_objet, date_creation, date_modification, certitude) VALUES (46, '1260', 25, NULL, NULL, NULL, 923, '2015-11-06 18:13:56.804955+01', NULL, ' ');
INSERT INTO date_objet (pk_date_objet, date_iso, fk_type_date_param, libelle_original_date, notes, descriptif, fk_objet, date_creation, date_modification, certitude) VALUES (47, '1260', 25, NULL, NULL, NULL, 1239, '2015-11-06 18:13:56.804955+01', NULL, ' ');
INSERT INTO date_objet (pk_date_objet, date_iso, fk_type_date_param, libelle_original_date, notes, descriptif, fk_objet, date_creation, date_modification, certitude) VALUES (48, '1290', 25, NULL, NULL, NULL, 1205, '2015-11-06 18:13:56.804955+01', NULL, ' ');
INSERT INTO date_objet (pk_date_objet, date_iso, fk_type_date_param, libelle_original_date, notes, descriptif, fk_objet, date_creation, date_modification, certitude) VALUES (49, '1290', 25, NULL, NULL, NULL, 1118, '2015-11-06 18:13:56.804955+01', NULL, ' ');
INSERT INTO date_objet (pk_date_objet, date_iso, fk_type_date_param, libelle_original_date, notes, descriptif, fk_objet, date_creation, date_modification, certitude) VALUES (50, '1290', 25, NULL, NULL, NULL, 1086, '2015-11-06 18:13:56.804955+01', NULL, ' ');
INSERT INTO date_objet (pk_date_objet, date_iso, fk_type_date_param, libelle_original_date, notes, descriptif, fk_objet, date_creation, date_modification, certitude) VALUES (51, '1292', 25, NULL, NULL, NULL, 1324, '2015-11-06 18:13:56.804955+01', NULL, ' ');
INSERT INTO date_objet (pk_date_objet, date_iso, fk_type_date_param, libelle_original_date, notes, descriptif, fk_objet, date_creation, date_modification, certitude) VALUES (52, '1300', 25, NULL, NULL, NULL, 845, '2015-11-06 18:13:56.804955+01', NULL, ' ');
INSERT INTO date_objet (pk_date_objet, date_iso, fk_type_date_param, libelle_original_date, notes, descriptif, fk_objet, date_creation, date_modification, certitude) VALUES (53, '1318', 25, NULL, NULL, NULL, 1185, '2015-11-06 18:13:56.804955+01', NULL, ' ');
INSERT INTO date_objet (pk_date_objet, date_iso, fk_type_date_param, libelle_original_date, notes, descriptif, fk_objet, date_creation, date_modification, certitude) VALUES (54, '1325', 25, NULL, NULL, NULL, 1555, '2015-11-06 18:13:56.804955+01', NULL, ' ');
INSERT INTO date_objet (pk_date_objet, date_iso, fk_type_date_param, libelle_original_date, notes, descriptif, fk_objet, date_creation, date_modification, certitude) VALUES (55, '1347', 25, NULL, NULL, NULL, 1418, '2015-11-06 18:13:56.804955+01', NULL, ' ');
INSERT INTO date_objet (pk_date_objet, date_iso, fk_type_date_param, libelle_original_date, notes, descriptif, fk_objet, date_creation, date_modification, certitude) VALUES (56, '1351', 25, NULL, NULL, NULL, 1449, '2015-11-06 18:13:56.804955+01', NULL, 'p');
INSERT INTO date_objet (pk_date_objet, date_iso, fk_type_date_param, libelle_original_date, notes, descriptif, fk_objet, date_creation, date_modification, certitude) VALUES (57, '1351', 25, NULL, NULL, NULL, 883, '2015-11-06 18:13:56.804955+01', NULL, 'p');
INSERT INTO date_objet (pk_date_objet, date_iso, fk_type_date_param, libelle_original_date, notes, descriptif, fk_objet, date_creation, date_modification, certitude) VALUES (58, '1351', 25, NULL, NULL, NULL, 1047, '2015-11-06 18:13:56.804955+01', NULL, 'p');
INSERT INTO date_objet (pk_date_objet, date_iso, fk_type_date_param, libelle_original_date, notes, descriptif, fk_objet, date_creation, date_modification, certitude) VALUES (59, '1351', 25, NULL, NULL, NULL, 1530, '2015-11-06 18:13:56.804955+01', NULL, 'p');
INSERT INTO date_objet (pk_date_objet, date_iso, fk_type_date_param, libelle_original_date, notes, descriptif, fk_objet, date_creation, date_modification, certitude) VALUES (60, '1351', 25, NULL, NULL, NULL, 1127, '2015-11-06 18:13:56.804955+01', NULL, 'p');
INSERT INTO date_objet (pk_date_objet, date_iso, fk_type_date_param, libelle_original_date, notes, descriptif, fk_objet, date_creation, date_modification, certitude) VALUES (61, '1351', 25, NULL, NULL, NULL, 1484, '2015-11-06 18:13:56.804955+01', NULL, 'p');
INSERT INTO date_objet (pk_date_objet, date_iso, fk_type_date_param, libelle_original_date, notes, descriptif, fk_objet, date_creation, date_modification, certitude) VALUES (62, '1351', 25, NULL, NULL, NULL, 1320, '2015-11-06 18:13:56.804955+01', NULL, 'p');
INSERT INTO date_objet (pk_date_objet, date_iso, fk_type_date_param, libelle_original_date, notes, descriptif, fk_objet, date_creation, date_modification, certitude) VALUES (63, '1397', 25, NULL, NULL, NULL, 1425, '2015-11-06 18:13:56.804955+01', NULL, ' ');
INSERT INTO date_objet (pk_date_objet, date_iso, fk_type_date_param, libelle_original_date, notes, descriptif, fk_objet, date_creation, date_modification, certitude) VALUES (64, '1405', 25, NULL, NULL, NULL, 1249, '2015-11-06 18:13:56.804955+01', NULL, ' ');
INSERT INTO date_objet (pk_date_objet, date_iso, fk_type_date_param, libelle_original_date, notes, descriptif, fk_objet, date_creation, date_modification, certitude) VALUES (65, '1411', 25, NULL, NULL, NULL, 1111, '2015-11-06 18:13:56.804955+01', NULL, ' ');
INSERT INTO date_objet (pk_date_objet, date_iso, fk_type_date_param, libelle_original_date, notes, descriptif, fk_objet, date_creation, date_modification, certitude) VALUES (66, '1412', 25, NULL, NULL, NULL, 1188, '2015-11-06 18:13:56.804955+01', NULL, ' ');
INSERT INTO date_objet (pk_date_objet, date_iso, fk_type_date_param, libelle_original_date, notes, descriptif, fk_objet, date_creation, date_modification, certitude) VALUES (67, '1416', 25, NULL, NULL, NULL, 1535, '2015-11-06 18:13:56.804955+01', NULL, ' ');
INSERT INTO date_objet (pk_date_objet, date_iso, fk_type_date_param, libelle_original_date, notes, descriptif, fk_objet, date_creation, date_modification, certitude) VALUES (68, '1422', 25, NULL, NULL, NULL, 963, '2015-11-06 18:13:56.804955+01', NULL, ' ');
INSERT INTO date_objet (pk_date_objet, date_iso, fk_type_date_param, libelle_original_date, notes, descriptif, fk_objet, date_creation, date_modification, certitude) VALUES (69, '1423', 25, NULL, NULL, NULL, 1529, '2015-11-06 18:13:56.804955+01', NULL, ' ');
INSERT INTO date_objet (pk_date_objet, date_iso, fk_type_date_param, libelle_original_date, notes, descriptif, fk_objet, date_creation, date_modification, certitude) VALUES (70, '1423', 25, NULL, NULL, NULL, 1017, '2015-11-06 18:13:56.804955+01', NULL, ' ');
INSERT INTO date_objet (pk_date_objet, date_iso, fk_type_date_param, libelle_original_date, notes, descriptif, fk_objet, date_creation, date_modification, certitude) VALUES (71, '1426', 25, NULL, NULL, NULL, 1283, '2015-11-06 18:13:56.804955+01', NULL, ' ');
INSERT INTO date_objet (pk_date_objet, date_iso, fk_type_date_param, libelle_original_date, notes, descriptif, fk_objet, date_creation, date_modification, certitude) VALUES (72, '1436', 25, NULL, NULL, NULL, 1134, '2015-11-06 18:13:56.804955+01', NULL, ' ');
INSERT INTO date_objet (pk_date_objet, date_iso, fk_type_date_param, libelle_original_date, notes, descriptif, fk_objet, date_creation, date_modification, certitude) VALUES (73, '1443', 25, NULL, NULL, NULL, 1210, '2015-11-06 18:13:56.804955+01', NULL, ' ');
INSERT INTO date_objet (pk_date_objet, date_iso, fk_type_date_param, libelle_original_date, notes, descriptif, fk_objet, date_creation, date_modification, certitude) VALUES (74, '1445', 25, NULL, NULL, NULL, 1037, '2015-11-06 18:13:56.804955+01', NULL, ' ');
INSERT INTO date_objet (pk_date_objet, date_iso, fk_type_date_param, libelle_original_date, notes, descriptif, fk_objet, date_creation, date_modification, certitude) VALUES (75, '1450', 25, NULL, NULL, NULL, 1181, '2015-11-06 18:13:56.804955+01', NULL, ' ');
INSERT INTO date_objet (pk_date_objet, date_iso, fk_type_date_param, libelle_original_date, notes, descriptif, fk_objet, date_creation, date_modification, certitude) VALUES (76, '1451', 25, NULL, NULL, NULL, 1077, '2015-11-06 18:13:56.804955+01', NULL, 'p');
INSERT INTO date_objet (pk_date_objet, date_iso, fk_type_date_param, libelle_original_date, notes, descriptif, fk_objet, date_creation, date_modification, certitude) VALUES (77, '1451', 25, NULL, NULL, NULL, 1450, '2015-11-06 18:13:56.804955+01', NULL, 'p');
INSERT INTO date_objet (pk_date_objet, date_iso, fk_type_date_param, libelle_original_date, notes, descriptif, fk_objet, date_creation, date_modification, certitude) VALUES (78, '1451', 25, NULL, NULL, NULL, 1580, '2015-11-06 18:13:56.804955+01', NULL, 'p');
INSERT INTO date_objet (pk_date_objet, date_iso, fk_type_date_param, libelle_original_date, notes, descriptif, fk_objet, date_creation, date_modification, certitude) VALUES (79, '1451', 25, NULL, NULL, NULL, 1565, '2015-11-06 18:13:56.804955+01', NULL, 'p');
INSERT INTO date_objet (pk_date_objet, date_iso, fk_type_date_param, libelle_original_date, notes, descriptif, fk_objet, date_creation, date_modification, certitude) VALUES (80, '1451', 25, NULL, NULL, NULL, 1326, '2015-11-06 18:13:56.804955+01', NULL, 'p');
INSERT INTO date_objet (pk_date_objet, date_iso, fk_type_date_param, libelle_original_date, notes, descriptif, fk_objet, date_creation, date_modification, certitude) VALUES (81, '1451', 25, NULL, NULL, NULL, 892, '2015-11-06 18:13:56.804955+01', NULL, 'p');
INSERT INTO date_objet (pk_date_objet, date_iso, fk_type_date_param, libelle_original_date, notes, descriptif, fk_objet, date_creation, date_modification, certitude) VALUES (82, '1451', 25, NULL, NULL, NULL, 1235, '2015-11-06 18:13:56.804955+01', NULL, 'p');
INSERT INTO date_objet (pk_date_objet, date_iso, fk_type_date_param, libelle_original_date, notes, descriptif, fk_objet, date_creation, date_modification, certitude) VALUES (83, '1451', 25, NULL, NULL, NULL, 835, '2015-11-06 18:13:56.804955+01', NULL, 'p');
INSERT INTO date_objet (pk_date_objet, date_iso, fk_type_date_param, libelle_original_date, notes, descriptif, fk_objet, date_creation, date_modification, certitude) VALUES (84, '1451', 25, NULL, NULL, NULL, 1169, '2015-11-06 18:13:56.804955+01', NULL, 'p');
INSERT INTO date_objet (pk_date_objet, date_iso, fk_type_date_param, libelle_original_date, notes, descriptif, fk_objet, date_creation, date_modification, certitude) VALUES (85, '1451', 25, NULL, NULL, NULL, 905, '2015-11-06 18:13:56.804955+01', NULL, 'p');
INSERT INTO date_objet (pk_date_objet, date_iso, fk_type_date_param, libelle_original_date, notes, descriptif, fk_objet, date_creation, date_modification, certitude) VALUES (86, '1451', 25, NULL, NULL, NULL, 1066, '2015-11-06 18:13:56.804955+01', NULL, 'p');
INSERT INTO date_objet (pk_date_objet, date_iso, fk_type_date_param, libelle_original_date, notes, descriptif, fk_objet, date_creation, date_modification, certitude) VALUES (87, '1451', 25, NULL, NULL, NULL, 1333, '2015-11-06 18:13:56.804955+01', NULL, 'p');
INSERT INTO date_objet (pk_date_objet, date_iso, fk_type_date_param, libelle_original_date, notes, descriptif, fk_objet, date_creation, date_modification, certitude) VALUES (88, '1451', 25, NULL, NULL, NULL, 1067, '2015-11-06 18:13:56.804955+01', NULL, 'p');
INSERT INTO date_objet (pk_date_objet, date_iso, fk_type_date_param, libelle_original_date, notes, descriptif, fk_objet, date_creation, date_modification, certitude) VALUES (89, '1451', 25, NULL, NULL, NULL, 1173, '2015-11-06 18:13:56.804955+01', NULL, 'p');
INSERT INTO date_objet (pk_date_objet, date_iso, fk_type_date_param, libelle_original_date, notes, descriptif, fk_objet, date_creation, date_modification, certitude) VALUES (90, '1451', 25, NULL, NULL, NULL, 934, '2015-11-06 18:13:56.804955+01', NULL, 'p');
INSERT INTO date_objet (pk_date_objet, date_iso, fk_type_date_param, libelle_original_date, notes, descriptif, fk_objet, date_creation, date_modification, certitude) VALUES (91, '1454', 25, NULL, NULL, NULL, 887, '2015-11-06 18:13:56.804955+01', NULL, ' ');
INSERT INTO date_objet (pk_date_objet, date_iso, fk_type_date_param, libelle_original_date, notes, descriptif, fk_objet, date_creation, date_modification, certitude) VALUES (92, '1460', 25, NULL, NULL, NULL, 984, '2015-11-06 18:13:56.804955+01', NULL, ' ');
INSERT INTO date_objet (pk_date_objet, date_iso, fk_type_date_param, libelle_original_date, notes, descriptif, fk_objet, date_creation, date_modification, certitude) VALUES (93, '1467', 25, NULL, NULL, NULL, 1522, '2015-11-06 18:13:56.804955+01', NULL, ' ');
INSERT INTO date_objet (pk_date_objet, date_iso, fk_type_date_param, libelle_original_date, notes, descriptif, fk_objet, date_creation, date_modification, certitude) VALUES (94, '1468', 25, NULL, NULL, NULL, 1191, '2015-11-06 18:13:56.804955+01', NULL, ' ');
INSERT INTO date_objet (pk_date_objet, date_iso, fk_type_date_param, libelle_original_date, notes, descriptif, fk_objet, date_creation, date_modification, certitude) VALUES (95, '1470', 25, NULL, NULL, NULL, 1128, '2015-11-06 18:13:56.804955+01', NULL, ' ');
INSERT INTO date_objet (pk_date_objet, date_iso, fk_type_date_param, libelle_original_date, notes, descriptif, fk_objet, date_creation, date_modification, certitude) VALUES (96, '1470', 25, NULL, NULL, NULL, 1141, '2015-11-06 18:13:56.804955+01', NULL, ' ');
INSERT INTO date_objet (pk_date_objet, date_iso, fk_type_date_param, libelle_original_date, notes, descriptif, fk_objet, date_creation, date_modification, certitude) VALUES (97, '1472', 25, NULL, NULL, NULL, 1005, '2015-11-06 18:13:56.804955+01', NULL, ' ');
INSERT INTO date_objet (pk_date_objet, date_iso, fk_type_date_param, libelle_original_date, notes, descriptif, fk_objet, date_creation, date_modification, certitude) VALUES (98, '1472', 25, NULL, NULL, NULL, 945, '2015-11-06 18:13:56.804955+01', NULL, ' ');
INSERT INTO date_objet (pk_date_objet, date_iso, fk_type_date_param, libelle_original_date, notes, descriptif, fk_objet, date_creation, date_modification, certitude) VALUES (99, '1473', 25, NULL, NULL, NULL, 1572, '2015-11-06 18:13:56.804955+01', NULL, ' ');
INSERT INTO date_objet (pk_date_objet, date_iso, fk_type_date_param, libelle_original_date, notes, descriptif, fk_objet, date_creation, date_modification, certitude) VALUES (100, '1473', 25, NULL, NULL, NULL, 1207, '2015-11-06 18:13:56.804955+01', NULL, ' ');
INSERT INTO date_objet (pk_date_objet, date_iso, fk_type_date_param, libelle_original_date, notes, descriptif, fk_objet, date_creation, date_modification, certitude) VALUES (101, '1476', 25, NULL, NULL, NULL, 1536, '2015-11-06 18:13:56.804955+01', NULL, ' ');
INSERT INTO date_objet (pk_date_objet, date_iso, fk_type_date_param, libelle_original_date, notes, descriptif, fk_objet, date_creation, date_modification, certitude) VALUES (102, '1477', 25, NULL, NULL, NULL, 919, '2015-11-06 18:13:56.804955+01', NULL, ' ');
INSERT INTO date_objet (pk_date_objet, date_iso, fk_type_date_param, libelle_original_date, notes, descriptif, fk_objet, date_creation, date_modification, certitude) VALUES (103, '1478', 25, NULL, NULL, NULL, 1115, '2015-11-06 18:13:56.804955+01', NULL, ' ');
INSERT INTO date_objet (pk_date_objet, date_iso, fk_type_date_param, libelle_original_date, notes, descriptif, fk_objet, date_creation, date_modification, certitude) VALUES (104, '1478', 25, NULL, NULL, NULL, 961, '2015-11-06 18:13:56.804955+01', NULL, ' ');
INSERT INTO date_objet (pk_date_objet, date_iso, fk_type_date_param, libelle_original_date, notes, descriptif, fk_objet, date_creation, date_modification, certitude) VALUES (105, '1479', 25, NULL, NULL, NULL, 1100, '2015-11-06 18:13:56.804955+01', NULL, ' ');
INSERT INTO date_objet (pk_date_objet, date_iso, fk_type_date_param, libelle_original_date, notes, descriptif, fk_objet, date_creation, date_modification, certitude) VALUES (106, '1479', 25, NULL, NULL, NULL, 1007, '2015-11-06 18:13:56.804955+01', NULL, ' ');
INSERT INTO date_objet (pk_date_objet, date_iso, fk_type_date_param, libelle_original_date, notes, descriptif, fk_objet, date_creation, date_modification, certitude) VALUES (107, '1480', 25, NULL, NULL, NULL, 942, '2015-11-06 18:13:56.804955+01', NULL, ' ');
INSERT INTO date_objet (pk_date_objet, date_iso, fk_type_date_param, libelle_original_date, notes, descriptif, fk_objet, date_creation, date_modification, certitude) VALUES (108, '1480', 25, NULL, NULL, NULL, 1149, '2015-11-06 18:13:56.804955+01', NULL, ' ');
INSERT INTO date_objet (pk_date_objet, date_iso, fk_type_date_param, libelle_original_date, notes, descriptif, fk_objet, date_creation, date_modification, certitude) VALUES (109, '1487', 25, NULL, NULL, NULL, 1072, '2015-11-06 18:13:56.804955+01', NULL, ' ');
INSERT INTO date_objet (pk_date_objet, date_iso, fk_type_date_param, libelle_original_date, notes, descriptif, fk_objet, date_creation, date_modification, certitude) VALUES (110, '1489', 25, NULL, NULL, NULL, 1451, '2015-11-06 18:13:56.804955+01', NULL, ' ');
INSERT INTO date_objet (pk_date_objet, date_iso, fk_type_date_param, libelle_original_date, notes, descriptif, fk_objet, date_creation, date_modification, certitude) VALUES (111, '1490', 25, NULL, NULL, NULL, 1241, '2015-11-06 18:13:56.804955+01', NULL, ' ');
INSERT INTO date_objet (pk_date_objet, date_iso, fk_type_date_param, libelle_original_date, notes, descriptif, fk_objet, date_creation, date_modification, certitude) VALUES (112, '1492', 25, NULL, NULL, NULL, 1477, '2015-11-06 18:13:56.804955+01', NULL, ' ');
INSERT INTO date_objet (pk_date_objet, date_iso, fk_type_date_param, libelle_original_date, notes, descriptif, fk_objet, date_creation, date_modification, certitude) VALUES (113, '1492', 25, NULL, NULL, NULL, 888, '2015-11-06 18:13:56.804955+01', NULL, ' ');
INSERT INTO date_objet (pk_date_objet, date_iso, fk_type_date_param, libelle_original_date, notes, descriptif, fk_objet, date_creation, date_modification, certitude) VALUES (114, '1492', 25, NULL, NULL, NULL, 1255, '2015-11-06 18:13:56.804955+01', NULL, ' ');
INSERT INTO date_objet (pk_date_objet, date_iso, fk_type_date_param, libelle_original_date, notes, descriptif, fk_objet, date_creation, date_modification, certitude) VALUES (115, '1494', 25, NULL, NULL, NULL, 1222, '2015-11-06 18:13:56.804955+01', NULL, ' ');
INSERT INTO date_objet (pk_date_objet, date_iso, fk_type_date_param, libelle_original_date, notes, descriptif, fk_objet, date_creation, date_modification, certitude) VALUES (116, '1495', 25, NULL, NULL, NULL, 901, '2015-11-06 18:13:56.804955+01', NULL, ' ');
INSERT INTO date_objet (pk_date_objet, date_iso, fk_type_date_param, libelle_original_date, notes, descriptif, fk_objet, date_creation, date_modification, certitude) VALUES (117, '1692', 25, NULL, NULL, NULL, 1493, '2015-11-06 18:13:56.804955+01', NULL, ' ');
INSERT INTO date_objet (pk_date_objet, date_iso, fk_type_date_param, libelle_original_date, notes, descriptif, fk_objet, date_creation, date_modification, certitude) VALUES (118, '1498', 25, NULL, NULL, NULL, 909, '2015-11-06 18:13:56.804955+01', NULL, ' ');
INSERT INTO date_objet (pk_date_objet, date_iso, fk_type_date_param, libelle_original_date, notes, descriptif, fk_objet, date_creation, date_modification, certitude) VALUES (119, '1499', 25, NULL, NULL, NULL, 969, '2015-11-06 18:13:56.804955+01', NULL, ' ');
INSERT INTO date_objet (pk_date_objet, date_iso, fk_type_date_param, libelle_original_date, notes, descriptif, fk_objet, date_creation, date_modification, certitude) VALUES (120, '1499', 25, NULL, NULL, NULL, 897, '2015-11-06 18:13:56.804955+01', NULL, ' ');
INSERT INTO date_objet (pk_date_objet, date_iso, fk_type_date_param, libelle_original_date, notes, descriptif, fk_objet, date_creation, date_modification, certitude) VALUES (121, '1499', 25, NULL, NULL, NULL, 1469, '2015-11-06 18:13:56.804955+01', NULL, ' ');
INSERT INTO date_objet (pk_date_objet, date_iso, fk_type_date_param, libelle_original_date, notes, descriptif, fk_objet, date_creation, date_modification, certitude) VALUES (122, '1499', 25, NULL, NULL, NULL, 1317, '2015-11-06 18:13:56.804955+01', NULL, ' ');
INSERT INTO date_objet (pk_date_objet, date_iso, fk_type_date_param, libelle_original_date, notes, descriptif, fk_objet, date_creation, date_modification, certitude) VALUES (123, '1500', 25, NULL, NULL, NULL, 999, '2015-11-06 18:13:56.804955+01', NULL, ' ');
INSERT INTO date_objet (pk_date_objet, date_iso, fk_type_date_param, libelle_original_date, notes, descriptif, fk_objet, date_creation, date_modification, certitude) VALUES (124, '1500', 25, NULL, NULL, NULL, 1576, '2015-11-06 18:13:56.804955+01', NULL, ' ');
INSERT INTO date_objet (pk_date_objet, date_iso, fk_type_date_param, libelle_original_date, notes, descriptif, fk_objet, date_creation, date_modification, certitude) VALUES (125, '1500', 25, NULL, NULL, NULL, 1392, '2015-11-06 18:13:56.804955+01', NULL, ' ');
INSERT INTO date_objet (pk_date_objet, date_iso, fk_type_date_param, libelle_original_date, notes, descriptif, fk_objet, date_creation, date_modification, certitude) VALUES (126, '1501', 25, NULL, NULL, NULL, 1431, '2015-11-06 18:13:56.804955+01', NULL, ' ');
INSERT INTO date_objet (pk_date_objet, date_iso, fk_type_date_param, libelle_original_date, notes, descriptif, fk_objet, date_creation, date_modification, certitude) VALUES (127, '1502', 25, NULL, NULL, NULL, 1278, '2015-11-06 18:13:56.804955+01', NULL, ' ');
INSERT INTO date_objet (pk_date_objet, date_iso, fk_type_date_param, libelle_original_date, notes, descriptif, fk_objet, date_creation, date_modification, certitude) VALUES (128, '1503', 25, NULL, NULL, NULL, 1455, '2015-11-06 18:13:56.804955+01', NULL, ' ');
INSERT INTO date_objet (pk_date_objet, date_iso, fk_type_date_param, libelle_original_date, notes, descriptif, fk_objet, date_creation, date_modification, certitude) VALUES (129, '1503', 25, NULL, NULL, NULL, 1374, '2015-11-06 18:13:56.804955+01', NULL, ' ');
INSERT INTO date_objet (pk_date_objet, date_iso, fk_type_date_param, libelle_original_date, notes, descriptif, fk_objet, date_creation, date_modification, certitude) VALUES (130, '1504', 25, NULL, NULL, NULL, 1404, '2015-11-06 18:13:56.804955+01', NULL, ' ');
INSERT INTO date_objet (pk_date_objet, date_iso, fk_type_date_param, libelle_original_date, notes, descriptif, fk_objet, date_creation, date_modification, certitude) VALUES (131, '1504', 25, NULL, NULL, NULL, 1443, '2015-11-06 18:13:56.804955+01', NULL, ' ');
INSERT INTO date_objet (pk_date_objet, date_iso, fk_type_date_param, libelle_original_date, notes, descriptif, fk_objet, date_creation, date_modification, certitude) VALUES (132, '1505', 25, NULL, NULL, NULL, 1440, '2015-11-06 18:13:56.804955+01', NULL, ' ');
INSERT INTO date_objet (pk_date_objet, date_iso, fk_type_date_param, libelle_original_date, notes, descriptif, fk_objet, date_creation, date_modification, certitude) VALUES (133, '1505', 25, NULL, NULL, NULL, 1142, '2015-11-06 18:13:56.804955+01', NULL, ' ');
INSERT INTO date_objet (pk_date_objet, date_iso, fk_type_date_param, libelle_original_date, notes, descriptif, fk_objet, date_creation, date_modification, certitude) VALUES (134, '1674', 25, NULL, NULL, NULL, 1548, '2015-11-06 18:13:56.804955+01', NULL, ' ');
INSERT INTO date_objet (pk_date_objet, date_iso, fk_type_date_param, libelle_original_date, notes, descriptif, fk_objet, date_creation, date_modification, certitude) VALUES (135, '1508', 25, NULL, NULL, NULL, 1080, '2015-11-06 18:13:56.804955+01', NULL, ' ');
INSERT INTO date_objet (pk_date_objet, date_iso, fk_type_date_param, libelle_original_date, notes, descriptif, fk_objet, date_creation, date_modification, certitude) VALUES (136, '1508', 25, NULL, NULL, NULL, 1373, '2015-11-06 18:13:56.804955+01', NULL, ' ');
INSERT INTO date_objet (pk_date_objet, date_iso, fk_type_date_param, libelle_original_date, notes, descriptif, fk_objet, date_creation, date_modification, certitude) VALUES (137, '1509', 25, NULL, NULL, NULL, 1303, '2015-11-06 18:13:56.804955+01', NULL, ' ');
INSERT INTO date_objet (pk_date_objet, date_iso, fk_type_date_param, libelle_original_date, notes, descriptif, fk_objet, date_creation, date_modification, certitude) VALUES (138, '1510', 25, NULL, NULL, NULL, 1194, '2015-11-06 18:13:56.804955+01', NULL, ' ');
INSERT INTO date_objet (pk_date_objet, date_iso, fk_type_date_param, libelle_original_date, notes, descriptif, fk_objet, date_creation, date_modification, certitude) VALUES (139, '1510', 25, NULL, NULL, NULL, 1094, '2015-11-06 18:13:56.804955+01', NULL, ' ');
INSERT INTO date_objet (pk_date_objet, date_iso, fk_type_date_param, libelle_original_date, notes, descriptif, fk_objet, date_creation, date_modification, certitude) VALUES (140, '1511', 25, NULL, NULL, NULL, 1531, '2015-11-06 18:13:56.804955+01', NULL, ' ');
INSERT INTO date_objet (pk_date_objet, date_iso, fk_type_date_param, libelle_original_date, notes, descriptif, fk_objet, date_creation, date_modification, certitude) VALUES (141, '1511', 25, NULL, NULL, NULL, 1244, '2015-11-06 18:13:56.804955+01', NULL, ' ');
INSERT INTO date_objet (pk_date_objet, date_iso, fk_type_date_param, libelle_original_date, notes, descriptif, fk_objet, date_creation, date_modification, certitude) VALUES (142, '1511', 25, NULL, NULL, NULL, 936, '2015-11-06 18:13:56.804955+01', NULL, ' ');
INSERT INTO date_objet (pk_date_objet, date_iso, fk_type_date_param, libelle_original_date, notes, descriptif, fk_objet, date_creation, date_modification, certitude) VALUES (143, '1512', 25, NULL, NULL, NULL, 1432, '2015-11-06 18:13:56.804955+01', NULL, ' ');
INSERT INTO date_objet (pk_date_objet, date_iso, fk_type_date_param, libelle_original_date, notes, descriptif, fk_objet, date_creation, date_modification, certitude) VALUES (144, '1512', 25, NULL, NULL, NULL, 1231, '2015-11-06 18:13:56.804955+01', NULL, ' ');
INSERT INTO date_objet (pk_date_objet, date_iso, fk_type_date_param, libelle_original_date, notes, descriptif, fk_objet, date_creation, date_modification, certitude) VALUES (145, '1513', 25, NULL, NULL, NULL, 1150, '2015-11-06 18:13:56.804955+01', NULL, ' ');
INSERT INTO date_objet (pk_date_objet, date_iso, fk_type_date_param, libelle_original_date, notes, descriptif, fk_objet, date_creation, date_modification, certitude) VALUES (146, '1514', 25, NULL, NULL, NULL, 1208, '2015-11-06 18:13:56.804955+01', NULL, ' ');
INSERT INTO date_objet (pk_date_objet, date_iso, fk_type_date_param, libelle_original_date, notes, descriptif, fk_objet, date_creation, date_modification, certitude) VALUES (147, '1515', 25, NULL, NULL, NULL, 1516, '2015-11-06 18:13:56.804955+01', NULL, ' ');
INSERT INTO date_objet (pk_date_objet, date_iso, fk_type_date_param, libelle_original_date, notes, descriptif, fk_objet, date_creation, date_modification, certitude) VALUES (148, '1515', 25, NULL, NULL, NULL, 1154, '2015-11-06 18:13:56.804955+01', NULL, ' ');
INSERT INTO date_objet (pk_date_objet, date_iso, fk_type_date_param, libelle_original_date, notes, descriptif, fk_objet, date_creation, date_modification, certitude) VALUES (149, '1516', 25, NULL, NULL, NULL, 1164, '2015-11-06 18:13:56.804955+01', NULL, ' ');
INSERT INTO date_objet (pk_date_objet, date_iso, fk_type_date_param, libelle_original_date, notes, descriptif, fk_objet, date_creation, date_modification, certitude) VALUES (150, '1517', 25, NULL, NULL, NULL, 981, '2015-11-06 18:13:56.804955+01', NULL, ' ');
INSERT INTO date_objet (pk_date_objet, date_iso, fk_type_date_param, libelle_original_date, notes, descriptif, fk_objet, date_creation, date_modification, certitude) VALUES (151, '1520', 25, NULL, NULL, NULL, 1356, '2015-11-06 18:13:56.804955+01', NULL, ' ');
INSERT INTO date_objet (pk_date_objet, date_iso, fk_type_date_param, libelle_original_date, notes, descriptif, fk_objet, date_creation, date_modification, certitude) VALUES (152, '1520', 25, NULL, NULL, NULL, 1152, '2015-11-06 18:13:56.804955+01', NULL, ' ');
INSERT INTO date_objet (pk_date_objet, date_iso, fk_type_date_param, libelle_original_date, notes, descriptif, fk_objet, date_creation, date_modification, certitude) VALUES (153, '1521', 25, NULL, NULL, NULL, 1171, '2015-11-06 18:13:56.804955+01', NULL, ' ');
INSERT INTO date_objet (pk_date_objet, date_iso, fk_type_date_param, libelle_original_date, notes, descriptif, fk_objet, date_creation, date_modification, certitude) VALUES (154, '1521', 25, NULL, NULL, NULL, 1254, '2015-11-06 18:13:56.804955+01', NULL, ' ');
INSERT INTO date_objet (pk_date_objet, date_iso, fk_type_date_param, libelle_original_date, notes, descriptif, fk_objet, date_creation, date_modification, certitude) VALUES (155, '1522', 25, NULL, NULL, NULL, 988, '2015-11-06 18:13:56.804955+01', NULL, ' ');
INSERT INTO date_objet (pk_date_objet, date_iso, fk_type_date_param, libelle_original_date, notes, descriptif, fk_objet, date_creation, date_modification, certitude) VALUES (156, '1523', 25, NULL, NULL, NULL, 840, '2015-11-06 18:13:56.804955+01', NULL, ' ');
INSERT INTO date_objet (pk_date_objet, date_iso, fk_type_date_param, libelle_original_date, notes, descriptif, fk_objet, date_creation, date_modification, certitude) VALUES (157, '1523', 25, NULL, NULL, NULL, 1106, '2015-11-06 18:13:56.804955+01', NULL, ' ');
INSERT INTO date_objet (pk_date_objet, date_iso, fk_type_date_param, libelle_original_date, notes, descriptif, fk_objet, date_creation, date_modification, certitude) VALUES (158, '1707', 25, NULL, NULL, NULL, 921, '2015-11-06 18:13:56.804955+01', NULL, ' ');
INSERT INTO date_objet (pk_date_objet, date_iso, fk_type_date_param, libelle_original_date, notes, descriptif, fk_objet, date_creation, date_modification, certitude) VALUES (159, '1525', 25, NULL, NULL, NULL, 889, '2015-11-06 18:13:56.804955+01', NULL, ' ');
INSERT INTO date_objet (pk_date_objet, date_iso, fk_type_date_param, libelle_original_date, notes, descriptif, fk_objet, date_creation, date_modification, certitude) VALUES (160, '1525', 25, NULL, NULL, NULL, 1514, '2015-11-06 18:13:56.804955+01', NULL, ' ');
INSERT INTO date_objet (pk_date_objet, date_iso, fk_type_date_param, libelle_original_date, notes, descriptif, fk_objet, date_creation, date_modification, certitude) VALUES (161, '1526', 25, NULL, NULL, NULL, 1176, '2015-11-06 18:13:56.804955+01', NULL, ' ');
INSERT INTO date_objet (pk_date_objet, date_iso, fk_type_date_param, libelle_original_date, notes, descriptif, fk_objet, date_creation, date_modification, certitude) VALUES (162, '1527', 25, NULL, NULL, NULL, 1247, '2015-11-06 18:13:56.804955+01', NULL, ' ');
INSERT INTO date_objet (pk_date_objet, date_iso, fk_type_date_param, libelle_original_date, notes, descriptif, fk_objet, date_creation, date_modification, certitude) VALUES (163, '1528', 25, NULL, NULL, NULL, 886, '2015-11-06 18:13:56.804955+01', NULL, ' ');
INSERT INTO date_objet (pk_date_objet, date_iso, fk_type_date_param, libelle_original_date, notes, descriptif, fk_objet, date_creation, date_modification, certitude) VALUES (164, '1530', 25, NULL, NULL, NULL, 1343, '2015-11-06 18:13:56.804955+01', NULL, ' ');
INSERT INTO date_objet (pk_date_objet, date_iso, fk_type_date_param, libelle_original_date, notes, descriptif, fk_objet, date_creation, date_modification, certitude) VALUES (165, '1530', 25, NULL, NULL, NULL, 1357, '2015-11-06 18:13:56.804955+01', NULL, ' ');
INSERT INTO date_objet (pk_date_objet, date_iso, fk_type_date_param, libelle_original_date, notes, descriptif, fk_objet, date_creation, date_modification, certitude) VALUES (166, '1530', 25, NULL, NULL, NULL, 850, '2015-11-06 18:13:56.804955+01', NULL, ' ');
INSERT INTO date_objet (pk_date_objet, date_iso, fk_type_date_param, libelle_original_date, notes, descriptif, fk_objet, date_creation, date_modification, certitude) VALUES (167, '1531', 25, NULL, NULL, NULL, 1174, '2015-11-06 18:13:56.804955+01', NULL, ' ');
INSERT INTO date_objet (pk_date_objet, date_iso, fk_type_date_param, libelle_original_date, notes, descriptif, fk_objet, date_creation, date_modification, certitude) VALUES (168, '1531', 25, NULL, NULL, NULL, 1069, '2015-11-06 18:13:56.804955+01', NULL, ' ');
INSERT INTO date_objet (pk_date_objet, date_iso, fk_type_date_param, libelle_original_date, notes, descriptif, fk_objet, date_creation, date_modification, certitude) VALUES (169, '1531', 25, NULL, NULL, NULL, 1382, '2015-11-06 18:13:56.804955+01', NULL, ' ');
INSERT INTO date_objet (pk_date_objet, date_iso, fk_type_date_param, libelle_original_date, notes, descriptif, fk_objet, date_creation, date_modification, certitude) VALUES (170, '1531', 25, NULL, NULL, NULL, 1473, '2015-11-06 18:13:56.804955+01', NULL, ' ');
INSERT INTO date_objet (pk_date_objet, date_iso, fk_type_date_param, libelle_original_date, notes, descriptif, fk_objet, date_creation, date_modification, certitude) VALUES (171, '1532', 25, NULL, NULL, NULL, 1189, '2015-11-06 18:13:56.804955+01', NULL, ' ');
INSERT INTO date_objet (pk_date_objet, date_iso, fk_type_date_param, libelle_original_date, notes, descriptif, fk_objet, date_creation, date_modification, certitude) VALUES (172, '1536', 25, NULL, NULL, NULL, 1245, '2015-11-06 18:13:56.804955+01', NULL, ' ');
INSERT INTO date_objet (pk_date_objet, date_iso, fk_type_date_param, libelle_original_date, notes, descriptif, fk_objet, date_creation, date_modification, certitude) VALUES (173, '1537', 25, NULL, NULL, NULL, 977, '2015-11-06 18:13:56.804955+01', NULL, ' ');
INSERT INTO date_objet (pk_date_objet, date_iso, fk_type_date_param, libelle_original_date, notes, descriptif, fk_objet, date_creation, date_modification, certitude) VALUES (174, '1537', 25, NULL, NULL, NULL, 1170, '2015-11-06 18:13:56.804955+01', NULL, ' ');
INSERT INTO date_objet (pk_date_objet, date_iso, fk_type_date_param, libelle_original_date, notes, descriptif, fk_objet, date_creation, date_modification, certitude) VALUES (175, '1538', 25, NULL, NULL, NULL, 989, '2015-11-06 18:13:56.804955+01', NULL, ' ');
INSERT INTO date_objet (pk_date_objet, date_iso, fk_type_date_param, libelle_original_date, notes, descriptif, fk_objet, date_creation, date_modification, certitude) VALUES (176, '1539', 25, NULL, NULL, NULL, 1265, '2015-11-06 18:13:56.804955+01', NULL, ' ');
INSERT INTO date_objet (pk_date_objet, date_iso, fk_type_date_param, libelle_original_date, notes, descriptif, fk_objet, date_creation, date_modification, certitude) VALUES (177, '1540', 25, NULL, NULL, NULL, 1340, '2015-11-06 18:13:56.804955+01', NULL, ' ');
INSERT INTO date_objet (pk_date_objet, date_iso, fk_type_date_param, libelle_original_date, notes, descriptif, fk_objet, date_creation, date_modification, certitude) VALUES (178, '1541', 25, NULL, NULL, NULL, 1351, '2015-11-06 18:13:56.804955+01', NULL, ' ');
INSERT INTO date_objet (pk_date_objet, date_iso, fk_type_date_param, libelle_original_date, notes, descriptif, fk_objet, date_creation, date_modification, certitude) VALUES (179, '1544', 25, NULL, NULL, NULL, 1190, '2015-11-06 18:13:56.804955+01', NULL, ' ');
INSERT INTO date_objet (pk_date_objet, date_iso, fk_type_date_param, libelle_original_date, notes, descriptif, fk_objet, date_creation, date_modification, certitude) VALUES (180, '1545', 25, NULL, NULL, NULL, 1153, '2015-11-06 18:13:56.804955+01', NULL, ' ');
INSERT INTO date_objet (pk_date_objet, date_iso, fk_type_date_param, libelle_original_date, notes, descriptif, fk_objet, date_creation, date_modification, certitude) VALUES (181, '1545', 25, NULL, NULL, NULL, 1084, '2015-11-06 18:13:56.804955+01', NULL, ' ');
INSERT INTO date_objet (pk_date_objet, date_iso, fk_type_date_param, libelle_original_date, notes, descriptif, fk_objet, date_creation, date_modification, certitude) VALUES (182, '1546', 25, NULL, NULL, NULL, 1175, '2015-11-06 18:13:56.804955+01', NULL, ' ');
INSERT INTO date_objet (pk_date_objet, date_iso, fk_type_date_param, libelle_original_date, notes, descriptif, fk_objet, date_creation, date_modification, certitude) VALUES (183, '1547', 25, NULL, NULL, NULL, 1271, '2015-11-06 18:13:56.804955+01', NULL, ' ');
INSERT INTO date_objet (pk_date_objet, date_iso, fk_type_date_param, libelle_original_date, notes, descriptif, fk_objet, date_creation, date_modification, certitude) VALUES (184, '1547', 25, NULL, NULL, NULL, 1004, '2015-11-06 18:13:56.804955+01', NULL, ' ');
INSERT INTO date_objet (pk_date_objet, date_iso, fk_type_date_param, libelle_original_date, notes, descriptif, fk_objet, date_creation, date_modification, certitude) VALUES (185, '1548', 25, NULL, NULL, NULL, 1561, '2015-11-06 18:13:56.804955+01', NULL, ' ');
INSERT INTO date_objet (pk_date_objet, date_iso, fk_type_date_param, libelle_original_date, notes, descriptif, fk_objet, date_creation, date_modification, certitude) VALUES (186, '1548', 25, NULL, NULL, NULL, 953, '2015-11-06 18:13:56.804955+01', NULL, ' ');
INSERT INTO date_objet (pk_date_objet, date_iso, fk_type_date_param, libelle_original_date, notes, descriptif, fk_objet, date_creation, date_modification, certitude) VALUES (187, '1549', 25, NULL, NULL, NULL, 1281, '2015-11-06 18:13:56.804955+01', NULL, ' ');
INSERT INTO date_objet (pk_date_objet, date_iso, fk_type_date_param, libelle_original_date, notes, descriptif, fk_objet, date_creation, date_modification, certitude) VALUES (188, '1550', 25, NULL, NULL, NULL, 949, '2015-11-06 18:13:56.804955+01', NULL, ' ');
INSERT INTO date_objet (pk_date_objet, date_iso, fk_type_date_param, libelle_original_date, notes, descriptif, fk_objet, date_creation, date_modification, certitude) VALUES (189, '1550', 25, NULL, NULL, NULL, 965, '2015-11-06 18:13:56.804955+01', NULL, ' ');
INSERT INTO date_objet (pk_date_objet, date_iso, fk_type_date_param, libelle_original_date, notes, descriptif, fk_objet, date_creation, date_modification, certitude) VALUES (190, '1550', 25, NULL, NULL, NULL, 1412, '2015-11-06 18:13:56.804955+01', NULL, ' ');
INSERT INTO date_objet (pk_date_objet, date_iso, fk_type_date_param, libelle_original_date, notes, descriptif, fk_objet, date_creation, date_modification, certitude) VALUES (191, '1550', 25, NULL, NULL, NULL, 1532, '2015-11-06 18:13:56.804955+01', NULL, ' ');
INSERT INTO date_objet (pk_date_objet, date_iso, fk_type_date_param, libelle_original_date, notes, descriptif, fk_objet, date_creation, date_modification, certitude) VALUES (192, '1550', 25, NULL, NULL, NULL, 1524, '2015-11-06 18:13:56.804955+01', NULL, ' ');
INSERT INTO date_objet (pk_date_objet, date_iso, fk_type_date_param, libelle_original_date, notes, descriptif, fk_objet, date_creation, date_modification, certitude) VALUES (193, '1651', 25, NULL, NULL, NULL, 1540, '2015-11-06 18:13:56.804955+01', NULL, 'p');
INSERT INTO date_objet (pk_date_objet, date_iso, fk_type_date_param, libelle_original_date, notes, descriptif, fk_objet, date_creation, date_modification, certitude) VALUES (194, '1551', 25, NULL, NULL, NULL, 1458, '2015-11-06 18:13:56.804955+01', NULL, 'p');
INSERT INTO date_objet (pk_date_objet, date_iso, fk_type_date_param, libelle_original_date, notes, descriptif, fk_objet, date_creation, date_modification, certitude) VALUES (195, '1551', 25, NULL, NULL, NULL, 951, '2015-11-06 18:13:56.804955+01', NULL, 'p');
INSERT INTO date_objet (pk_date_objet, date_iso, fk_type_date_param, libelle_original_date, notes, descriptif, fk_objet, date_creation, date_modification, certitude) VALUES (196, '1551', 25, NULL, NULL, NULL, 1457, '2015-11-06 18:13:56.804955+01', NULL, 'p');
INSERT INTO date_objet (pk_date_objet, date_iso, fk_type_date_param, libelle_original_date, notes, descriptif, fk_objet, date_creation, date_modification, certitude) VALUES (197, '1551', 25, NULL, NULL, NULL, 1139, '2015-11-06 18:13:56.804955+01', NULL, 'p');
INSERT INTO date_objet (pk_date_objet, date_iso, fk_type_date_param, libelle_original_date, notes, descriptif, fk_objet, date_creation, date_modification, certitude) VALUES (198, '1551', 25, NULL, NULL, NULL, 1123, '2015-11-06 18:13:56.804955+01', NULL, 'p');
INSERT INTO date_objet (pk_date_objet, date_iso, fk_type_date_param, libelle_original_date, notes, descriptif, fk_objet, date_creation, date_modification, certitude) VALUES (199, '1551', 25, NULL, NULL, NULL, 1497, '2015-11-06 18:13:56.804955+01', NULL, 'p');
INSERT INTO date_objet (pk_date_objet, date_iso, fk_type_date_param, libelle_original_date, notes, descriptif, fk_objet, date_creation, date_modification, certitude) VALUES (200, '1551', 25, NULL, NULL, NULL, 1286, '2015-11-06 18:13:56.804955+01', NULL, ' ');
INSERT INTO date_objet (pk_date_objet, date_iso, fk_type_date_param, libelle_original_date, notes, descriptif, fk_objet, date_creation, date_modification, certitude) VALUES (201, '1551', 25, NULL, NULL, NULL, 1215, '2015-11-06 18:13:56.804955+01', NULL, 'p');
INSERT INTO date_objet (pk_date_objet, date_iso, fk_type_date_param, libelle_original_date, notes, descriptif, fk_objet, date_creation, date_modification, certitude) VALUES (202, '1551', 25, NULL, NULL, NULL, 1311, '2015-11-06 18:13:56.804955+01', NULL, 'p');
INSERT INTO date_objet (pk_date_objet, date_iso, fk_type_date_param, libelle_original_date, notes, descriptif, fk_objet, date_creation, date_modification, certitude) VALUES (203, '1551', 25, NULL, NULL, NULL, 865, '2015-11-06 18:13:56.804955+01', NULL, 'p');
INSERT INTO date_objet (pk_date_objet, date_iso, fk_type_date_param, libelle_original_date, notes, descriptif, fk_objet, date_creation, date_modification, certitude) VALUES (204, '1551', 25, NULL, NULL, NULL, 1470, '2015-11-06 18:13:56.804955+01', NULL, 'p');
INSERT INTO date_objet (pk_date_objet, date_iso, fk_type_date_param, libelle_original_date, notes, descriptif, fk_objet, date_creation, date_modification, certitude) VALUES (205, '1551', 25, NULL, NULL, NULL, 855, '2015-11-06 18:13:56.804955+01', NULL, 'p');
INSERT INTO date_objet (pk_date_objet, date_iso, fk_type_date_param, libelle_original_date, notes, descriptif, fk_objet, date_creation, date_modification, certitude) VALUES (206, '1551', 25, NULL, NULL, NULL, 900, '2015-11-06 18:13:56.804955+01', NULL, 'p');
INSERT INTO date_objet (pk_date_objet, date_iso, fk_type_date_param, libelle_original_date, notes, descriptif, fk_objet, date_creation, date_modification, certitude) VALUES (207, '1551', 25, NULL, NULL, NULL, 1232, '2015-11-06 18:13:56.804955+01', NULL, 'p');
INSERT INTO date_objet (pk_date_objet, date_iso, fk_type_date_param, libelle_original_date, notes, descriptif, fk_objet, date_creation, date_modification, certitude) VALUES (208, '1551', 25, NULL, NULL, NULL, 1129, '2015-11-06 18:13:56.804955+01', NULL, 'p');
INSERT INTO date_objet (pk_date_objet, date_iso, fk_type_date_param, libelle_original_date, notes, descriptif, fk_objet, date_creation, date_modification, certitude) VALUES (209, '1551', 25, NULL, NULL, NULL, 1193, '2015-11-06 18:13:56.804955+01', NULL, 'p');
INSERT INTO date_objet (pk_date_objet, date_iso, fk_type_date_param, libelle_original_date, notes, descriptif, fk_objet, date_creation, date_modification, certitude) VALUES (210, '1650', 25, NULL, NULL, NULL, 944, '2015-11-06 18:13:56.804955+01', NULL, ' ');
INSERT INTO date_objet (pk_date_objet, date_iso, fk_type_date_param, libelle_original_date, notes, descriptif, fk_objet, date_creation, date_modification, certitude) VALUES (211, '1551', 25, NULL, NULL, NULL, 1463, '2015-11-06 18:13:56.804955+01', NULL, 'p');
INSERT INTO date_objet (pk_date_objet, date_iso, fk_type_date_param, libelle_original_date, notes, descriptif, fk_objet, date_creation, date_modification, certitude) VALUES (212, '1551', 25, NULL, NULL, NULL, 1464, '2015-11-06 18:13:56.804955+01', NULL, 'p');
INSERT INTO date_objet (pk_date_objet, date_iso, fk_type_date_param, libelle_original_date, notes, descriptif, fk_objet, date_creation, date_modification, certitude) VALUES (213, '1551', 25, NULL, NULL, NULL, 970, '2015-11-06 18:13:56.804955+01', NULL, 'p');
INSERT INTO date_objet (pk_date_objet, date_iso, fk_type_date_param, libelle_original_date, notes, descriptif, fk_objet, date_creation, date_modification, certitude) VALUES (214, '1551', 25, NULL, NULL, NULL, 1293, '2015-11-06 18:13:56.804955+01', NULL, 'p');
INSERT INTO date_objet (pk_date_objet, date_iso, fk_type_date_param, libelle_original_date, notes, descriptif, fk_objet, date_creation, date_modification, certitude) VALUES (215, '1551', 25, NULL, NULL, NULL, 1330, '2015-11-06 18:13:56.804955+01', NULL, 'p');
INSERT INTO date_objet (pk_date_objet, date_iso, fk_type_date_param, libelle_original_date, notes, descriptif, fk_objet, date_creation, date_modification, certitude) VALUES (216, '1551', 25, NULL, NULL, NULL, 1584, '2015-11-06 18:13:56.804955+01', NULL, 'p');
INSERT INTO date_objet (pk_date_objet, date_iso, fk_type_date_param, libelle_original_date, notes, descriptif, fk_objet, date_creation, date_modification, certitude) VALUES (217, '1551', 25, NULL, NULL, NULL, 957, '2015-11-06 18:13:56.804955+01', NULL, 'p');
INSERT INTO date_objet (pk_date_objet, date_iso, fk_type_date_param, libelle_original_date, notes, descriptif, fk_objet, date_creation, date_modification, certitude) VALUES (218, '1551', 25, NULL, NULL, NULL, 1327, '2015-11-06 18:13:56.804955+01', NULL, 'p');
INSERT INTO date_objet (pk_date_objet, date_iso, fk_type_date_param, libelle_original_date, notes, descriptif, fk_objet, date_creation, date_modification, certitude) VALUES (219, '1551', 25, NULL, NULL, NULL, 1413, '2015-11-06 18:13:56.804955+01', NULL, 'p');
INSERT INTO date_objet (pk_date_objet, date_iso, fk_type_date_param, libelle_original_date, notes, descriptif, fk_objet, date_creation, date_modification, certitude) VALUES (220, '1551', 25, NULL, NULL, NULL, 1043, '2015-11-06 18:13:56.804955+01', NULL, 'p');
INSERT INTO date_objet (pk_date_objet, date_iso, fk_type_date_param, libelle_original_date, notes, descriptif, fk_objet, date_creation, date_modification, certitude) VALUES (221, '1551', 25, NULL, NULL, NULL, 1182, '2015-11-06 18:13:56.804955+01', NULL, 'p');
INSERT INTO date_objet (pk_date_objet, date_iso, fk_type_date_param, libelle_original_date, notes, descriptif, fk_objet, date_creation, date_modification, certitude) VALUES (222, '1551', 25, NULL, NULL, NULL, 1044, '2015-11-06 18:13:56.804955+01', NULL, ' ');
INSERT INTO date_objet (pk_date_objet, date_iso, fk_type_date_param, libelle_original_date, notes, descriptif, fk_objet, date_creation, date_modification, certitude) VALUES (223, '1551', 25, NULL, NULL, NULL, 1482, '2015-11-06 18:13:56.804955+01', NULL, 'p');
INSERT INTO date_objet (pk_date_objet, date_iso, fk_type_date_param, libelle_original_date, notes, descriptif, fk_objet, date_creation, date_modification, certitude) VALUES (224, '1551', 25, NULL, NULL, NULL, 1358, '2015-11-06 18:13:56.804955+01', NULL, 'p');
INSERT INTO date_objet (pk_date_objet, date_iso, fk_type_date_param, libelle_original_date, notes, descriptif, fk_objet, date_creation, date_modification, certitude) VALUES (225, '1551', 25, NULL, NULL, NULL, 1284, '2015-11-06 18:13:56.804955+01', NULL, 'p');
INSERT INTO date_objet (pk_date_objet, date_iso, fk_type_date_param, libelle_original_date, notes, descriptif, fk_objet, date_creation, date_modification, certitude) VALUES (226, '1551', 25, NULL, NULL, NULL, 1400, '2015-11-06 18:13:56.804955+01', NULL, 'p');
INSERT INTO date_objet (pk_date_objet, date_iso, fk_type_date_param, libelle_original_date, notes, descriptif, fk_objet, date_creation, date_modification, certitude) VALUES (227, '1551', 25, NULL, NULL, NULL, 1566, '2015-11-06 18:13:56.804955+01', NULL, 'p');
INSERT INTO date_objet (pk_date_objet, date_iso, fk_type_date_param, libelle_original_date, notes, descriptif, fk_objet, date_creation, date_modification, certitude) VALUES (228, '1551', 25, NULL, NULL, NULL, 1410, '2015-11-06 18:13:56.804955+01', NULL, 'p');
INSERT INTO date_objet (pk_date_objet, date_iso, fk_type_date_param, libelle_original_date, notes, descriptif, fk_objet, date_creation, date_modification, certitude) VALUES (229, '1551', 25, NULL, NULL, NULL, 982, '2015-11-06 18:13:56.804955+01', NULL, 'p');
INSERT INTO date_objet (pk_date_objet, date_iso, fk_type_date_param, libelle_original_date, notes, descriptif, fk_objet, date_creation, date_modification, certitude) VALUES (230, '1551', 25, NULL, NULL, NULL, 1478, '2015-11-06 18:13:56.804955+01', NULL, 'p');
INSERT INTO date_objet (pk_date_objet, date_iso, fk_type_date_param, libelle_original_date, notes, descriptif, fk_objet, date_creation, date_modification, certitude) VALUES (231, '1551', 25, NULL, NULL, NULL, 1288, '2015-11-06 18:13:56.804955+01', NULL, 'p');
INSERT INTO date_objet (pk_date_objet, date_iso, fk_type_date_param, libelle_original_date, notes, descriptif, fk_objet, date_creation, date_modification, certitude) VALUES (232, '1551', 25, NULL, NULL, NULL, 1058, '2015-11-06 18:13:56.804955+01', NULL, 'p');
INSERT INTO date_objet (pk_date_objet, date_iso, fk_type_date_param, libelle_original_date, notes, descriptif, fk_objet, date_creation, date_modification, certitude) VALUES (233, '1552', 25, NULL, NULL, NULL, 1402, '2015-11-06 18:13:56.804955+01', NULL, ' ');
INSERT INTO date_objet (pk_date_objet, date_iso, fk_type_date_param, libelle_original_date, notes, descriptif, fk_objet, date_creation, date_modification, certitude) VALUES (234, '1553', 25, NULL, NULL, NULL, 1145, '2015-11-06 18:13:56.804955+01', NULL, ' ');
INSERT INTO date_objet (pk_date_objet, date_iso, fk_type_date_param, libelle_original_date, notes, descriptif, fk_objet, date_creation, date_modification, certitude) VALUES (235, '1554', 25, NULL, NULL, NULL, 1423, '2015-11-06 18:13:56.804955+01', NULL, ' ');
INSERT INTO date_objet (pk_date_objet, date_iso, fk_type_date_param, libelle_original_date, notes, descriptif, fk_objet, date_creation, date_modification, certitude) VALUES (236, '1570', 25, NULL, NULL, NULL, 971, '2015-11-06 18:13:56.804955+01', NULL, ' ');
INSERT INTO date_objet (pk_date_objet, date_iso, fk_type_date_param, libelle_original_date, notes, descriptif, fk_objet, date_creation, date_modification, certitude) VALUES (237, '1555', 25, NULL, NULL, NULL, 920, '2015-11-06 18:13:56.804955+01', NULL, ' ');
INSERT INTO date_objet (pk_date_objet, date_iso, fk_type_date_param, libelle_original_date, notes, descriptif, fk_objet, date_creation, date_modification, certitude) VALUES (238, '1555', 25, NULL, NULL, NULL, 1257, '2015-11-06 18:13:56.804955+01', NULL, ' ');
INSERT INTO date_objet (pk_date_objet, date_iso, fk_type_date_param, libelle_original_date, notes, descriptif, fk_objet, date_creation, date_modification, certitude) VALUES (239, '1556', 25, NULL, NULL, NULL, 1437, '2015-11-06 18:13:56.804955+01', NULL, ' ');
INSERT INTO date_objet (pk_date_objet, date_iso, fk_type_date_param, libelle_original_date, notes, descriptif, fk_objet, date_creation, date_modification, certitude) VALUES (240, '1724', 25, NULL, NULL, NULL, 1539, '2015-11-06 18:13:56.804955+01', NULL, ' ');
INSERT INTO date_objet (pk_date_objet, date_iso, fk_type_date_param, libelle_original_date, notes, descriptif, fk_objet, date_creation, date_modification, certitude) VALUES (241, '1557', 25, NULL, NULL, NULL, 917, '2015-11-06 18:13:56.804955+01', NULL, ' ');
INSERT INTO date_objet (pk_date_objet, date_iso, fk_type_date_param, libelle_original_date, notes, descriptif, fk_objet, date_creation, date_modification, certitude) VALUES (242, '1558', 25, NULL, NULL, NULL, 1285, '2015-11-06 18:13:56.804955+01', NULL, ' ');
INSERT INTO date_objet (pk_date_objet, date_iso, fk_type_date_param, libelle_original_date, notes, descriptif, fk_objet, date_creation, date_modification, certitude) VALUES (243, '1559', 25, NULL, NULL, NULL, 1038, '2015-11-06 18:13:56.804955+01', NULL, ' ');
INSERT INTO date_objet (pk_date_objet, date_iso, fk_type_date_param, libelle_original_date, notes, descriptif, fk_objet, date_creation, date_modification, certitude) VALUES (244, '1560', 25, NULL, NULL, NULL, 1307, '2015-11-06 18:13:56.804955+01', NULL, ' ');
INSERT INTO date_objet (pk_date_objet, date_iso, fk_type_date_param, libelle_original_date, notes, descriptif, fk_objet, date_creation, date_modification, certitude) VALUES (245, '1560', 25, NULL, NULL, NULL, 1456, '2015-11-06 18:13:56.804955+01', NULL, ' ');
INSERT INTO date_objet (pk_date_objet, date_iso, fk_type_date_param, libelle_original_date, notes, descriptif, fk_objet, date_creation, date_modification, certitude) VALUES (246, '1561', 25, NULL, NULL, NULL, 1381, '2015-11-06 18:13:56.804955+01', NULL, ' ');
INSERT INTO date_objet (pk_date_objet, date_iso, fk_type_date_param, libelle_original_date, notes, descriptif, fk_objet, date_creation, date_modification, certitude) VALUES (247, '1561', 25, NULL, NULL, NULL, 1095, '2015-11-06 18:13:56.804955+01', NULL, ' ');
INSERT INTO date_objet (pk_date_objet, date_iso, fk_type_date_param, libelle_original_date, notes, descriptif, fk_objet, date_creation, date_modification, certitude) VALUES (248, '1561', 25, NULL, NULL, NULL, 1547, '2015-11-06 18:13:56.804955+01', NULL, ' ');
INSERT INTO date_objet (pk_date_objet, date_iso, fk_type_date_param, libelle_original_date, notes, descriptif, fk_objet, date_creation, date_modification, certitude) VALUES (249, '1561', 25, NULL, NULL, NULL, 1362, '2015-11-06 18:13:56.804955+01', NULL, ' ');
INSERT INTO date_objet (pk_date_objet, date_iso, fk_type_date_param, libelle_original_date, notes, descriptif, fk_objet, date_creation, date_modification, certitude) VALUES (250, '1561', 25, NULL, NULL, NULL, 853, '2015-11-06 18:13:56.804955+01', NULL, ' ');
INSERT INTO date_objet (pk_date_objet, date_iso, fk_type_date_param, libelle_original_date, notes, descriptif, fk_objet, date_creation, date_modification, certitude) VALUES (251, '1561', 25, NULL, NULL, NULL, 1342, '2015-11-06 18:13:56.804955+01', NULL, ' ');
INSERT INTO date_objet (pk_date_objet, date_iso, fk_type_date_param, libelle_original_date, notes, descriptif, fk_objet, date_creation, date_modification, certitude) VALUES (252, '1561', 25, NULL, NULL, NULL, 873, '2015-11-06 18:13:56.804955+01', NULL, ' ');
INSERT INTO date_objet (pk_date_objet, date_iso, fk_type_date_param, libelle_original_date, notes, descriptif, fk_objet, date_creation, date_modification, certitude) VALUES (253, '1562', 25, NULL, NULL, NULL, 1360, '2015-11-06 18:13:56.804955+01', NULL, ' ');
INSERT INTO date_objet (pk_date_objet, date_iso, fk_type_date_param, libelle_original_date, notes, descriptif, fk_objet, date_creation, date_modification, certitude) VALUES (254, '1562', 25, NULL, NULL, NULL, 1272, '2015-11-06 18:13:56.804955+01', NULL, ' ');
INSERT INTO date_objet (pk_date_objet, date_iso, fk_type_date_param, libelle_original_date, notes, descriptif, fk_objet, date_creation, date_modification, certitude) VALUES (255, '1564', 25, NULL, NULL, NULL, 959, '2015-11-06 18:13:56.804955+01', NULL, ' ');
INSERT INTO date_objet (pk_date_objet, date_iso, fk_type_date_param, libelle_original_date, notes, descriptif, fk_objet, date_creation, date_modification, certitude) VALUES (256, '1564', 25, NULL, NULL, NULL, 1167, '2015-11-06 18:13:56.804955+01', NULL, ' ');
INSERT INTO date_objet (pk_date_objet, date_iso, fk_type_date_param, libelle_original_date, notes, descriptif, fk_objet, date_creation, date_modification, certitude) VALUES (257, '1565', 25, NULL, NULL, NULL, 993, '2015-11-06 18:13:56.804955+01', NULL, ' ');
INSERT INTO date_objet (pk_date_objet, date_iso, fk_type_date_param, libelle_original_date, notes, descriptif, fk_objet, date_creation, date_modification, certitude) VALUES (258, '1565', 25, NULL, NULL, NULL, 1389, '2015-11-06 18:13:56.804955+01', NULL, ' ');
INSERT INTO date_objet (pk_date_objet, date_iso, fk_type_date_param, libelle_original_date, notes, descriptif, fk_objet, date_creation, date_modification, certitude) VALUES (259, '1565', 25, NULL, NULL, NULL, 1028, '2015-11-06 18:13:56.804955+01', NULL, ' ');
INSERT INTO date_objet (pk_date_objet, date_iso, fk_type_date_param, libelle_original_date, notes, descriptif, fk_objet, date_creation, date_modification, certitude) VALUES (260, '1565', 25, NULL, NULL, NULL, 1137, '2015-11-06 18:13:56.804955+01', NULL, ' ');
INSERT INTO date_objet (pk_date_objet, date_iso, fk_type_date_param, libelle_original_date, notes, descriptif, fk_objet, date_creation, date_modification, certitude) VALUES (261, '1735', 25, NULL, NULL, NULL, 1237, '2015-11-06 18:13:56.804955+01', NULL, ' ');
INSERT INTO date_objet (pk_date_objet, date_iso, fk_type_date_param, libelle_original_date, notes, descriptif, fk_objet, date_creation, date_modification, certitude) VALUES (262, '1566', 25, NULL, NULL, NULL, 1461, '2015-11-06 18:13:56.804955+01', NULL, ' ');
INSERT INTO date_objet (pk_date_objet, date_iso, fk_type_date_param, libelle_original_date, notes, descriptif, fk_objet, date_creation, date_modification, certitude) VALUES (263, '1566', 25, NULL, NULL, NULL, 1471, '2015-11-06 18:13:56.804955+01', NULL, ' ');
INSERT INTO date_objet (pk_date_objet, date_iso, fk_type_date_param, libelle_original_date, notes, descriptif, fk_objet, date_creation, date_modification, certitude) VALUES (264, '1566', 25, NULL, NULL, NULL, 1295, '2015-11-06 18:13:56.804955+01', NULL, ' ');
INSERT INTO date_objet (pk_date_objet, date_iso, fk_type_date_param, libelle_original_date, notes, descriptif, fk_objet, date_creation, date_modification, certitude) VALUES (265, '1566', 25, NULL, NULL, NULL, 847, '2015-11-06 18:13:56.804955+01', NULL, ' ');
INSERT INTO date_objet (pk_date_objet, date_iso, fk_type_date_param, libelle_original_date, notes, descriptif, fk_objet, date_creation, date_modification, certitude) VALUES (266, '1567', 25, NULL, NULL, NULL, 1064, '2015-11-06 18:13:56.804955+01', NULL, ' ');
INSERT INTO date_objet (pk_date_objet, date_iso, fk_type_date_param, libelle_original_date, notes, descriptif, fk_objet, date_creation, date_modification, certitude) VALUES (267, '1568', 25, NULL, NULL, NULL, 1345, '2015-11-06 18:13:56.804955+01', NULL, ' ');
INSERT INTO date_objet (pk_date_objet, date_iso, fk_type_date_param, libelle_original_date, notes, descriptif, fk_objet, date_creation, date_modification, certitude) VALUES (268, '1568', 25, NULL, NULL, NULL, 890, '2015-11-06 18:13:56.804955+01', NULL, ' ');
INSERT INTO date_objet (pk_date_objet, date_iso, fk_type_date_param, libelle_original_date, notes, descriptif, fk_objet, date_creation, date_modification, certitude) VALUES (269, '1569', 25, NULL, NULL, NULL, 1384, '2015-11-06 18:13:56.804955+01', NULL, ' ');
INSERT INTO date_objet (pk_date_objet, date_iso, fk_type_date_param, libelle_original_date, notes, descriptif, fk_objet, date_creation, date_modification, certitude) VALUES (270, '1570', 25, NULL, NULL, NULL, 1070, '2015-11-06 18:13:56.804955+01', NULL, ' ');
INSERT INTO date_objet (pk_date_objet, date_iso, fk_type_date_param, libelle_original_date, notes, descriptif, fk_objet, date_creation, date_modification, certitude) VALUES (271, '1571', 25, NULL, NULL, NULL, 1248, '2015-11-06 18:13:56.804955+01', NULL, ' ');
INSERT INTO date_objet (pk_date_objet, date_iso, fk_type_date_param, libelle_original_date, notes, descriptif, fk_objet, date_creation, date_modification, certitude) VALUES (272, '1571', 25, NULL, NULL, NULL, 1308, '2015-11-06 18:13:56.804955+01', NULL, ' ');
INSERT INTO date_objet (pk_date_objet, date_iso, fk_type_date_param, libelle_original_date, notes, descriptif, fk_objet, date_creation, date_modification, certitude) VALUES (273, '1571', 25, NULL, NULL, NULL, 1355, '2015-11-06 18:13:56.804955+01', NULL, ' ');
INSERT INTO date_objet (pk_date_objet, date_iso, fk_type_date_param, libelle_original_date, notes, descriptif, fk_objet, date_creation, date_modification, certitude) VALUES (274, '1571', 25, NULL, NULL, NULL, 1101, '2015-11-06 18:13:56.804955+01', NULL, ' ');
INSERT INTO date_objet (pk_date_objet, date_iso, fk_type_date_param, libelle_original_date, notes, descriptif, fk_objet, date_creation, date_modification, certitude) VALUES (275, '1571', 25, NULL, NULL, NULL, 1379, '2015-11-06 18:13:56.804955+01', NULL, ' ');
INSERT INTO date_objet (pk_date_objet, date_iso, fk_type_date_param, libelle_original_date, notes, descriptif, fk_objet, date_creation, date_modification, certitude) VALUES (276, '1572', 25, NULL, NULL, NULL, 1510, '2015-11-06 18:13:56.804955+01', NULL, ' ');
INSERT INTO date_objet (pk_date_objet, date_iso, fk_type_date_param, libelle_original_date, notes, descriptif, fk_objet, date_creation, date_modification, certitude) VALUES (277, '1572', 25, NULL, NULL, NULL, 1224, '2015-11-06 18:13:56.804955+01', NULL, ' ');
INSERT INTO date_objet (pk_date_objet, date_iso, fk_type_date_param, libelle_original_date, notes, descriptif, fk_objet, date_creation, date_modification, certitude) VALUES (278, '1575', 25, NULL, NULL, NULL, 1352, '2015-11-06 18:13:56.804955+01', NULL, ' ');
INSERT INTO date_objet (pk_date_objet, date_iso, fk_type_date_param, libelle_original_date, notes, descriptif, fk_objet, date_creation, date_modification, certitude) VALUES (279, '1575', 25, NULL, NULL, NULL, 1074, '2015-11-06 18:13:56.804955+01', NULL, ' ');
INSERT INTO date_objet (pk_date_objet, date_iso, fk_type_date_param, libelle_original_date, notes, descriptif, fk_objet, date_creation, date_modification, certitude) VALUES (280, '1578', 25, NULL, NULL, NULL, 1575, '2015-11-06 18:13:56.804955+01', NULL, ' ');
INSERT INTO date_objet (pk_date_objet, date_iso, fk_type_date_param, libelle_original_date, notes, descriptif, fk_objet, date_creation, date_modification, certitude) VALUES (281, '1578', 25, NULL, NULL, NULL, 848, '2015-11-06 18:13:56.804955+01', NULL, ' ');
INSERT INTO date_objet (pk_date_objet, date_iso, fk_type_date_param, libelle_original_date, notes, descriptif, fk_objet, date_creation, date_modification, certitude) VALUES (282, '1580', 25, NULL, NULL, NULL, 1136, '2015-11-06 18:13:56.804955+01', NULL, ' ');
INSERT INTO date_objet (pk_date_objet, date_iso, fk_type_date_param, libelle_original_date, notes, descriptif, fk_objet, date_creation, date_modification, certitude) VALUES (283, '1580', 25, NULL, NULL, NULL, 1202, '2015-11-06 18:13:56.804955+01', NULL, ' ');
INSERT INTO date_objet (pk_date_objet, date_iso, fk_type_date_param, libelle_original_date, notes, descriptif, fk_objet, date_creation, date_modification, certitude) VALUES (284, '1580', 25, NULL, NULL, NULL, 1577, '2015-11-06 18:13:56.804955+01', NULL, ' ');
INSERT INTO date_objet (pk_date_objet, date_iso, fk_type_date_param, libelle_original_date, notes, descriptif, fk_objet, date_creation, date_modification, certitude) VALUES (285, '1580', 25, NULL, NULL, NULL, 861, '2015-11-06 18:13:56.804955+01', NULL, ' ');
INSERT INTO date_objet (pk_date_objet, date_iso, fk_type_date_param, libelle_original_date, notes, descriptif, fk_objet, date_creation, date_modification, certitude) VALUES (286, '1580', 25, NULL, NULL, NULL, 1454, '2015-11-06 18:13:56.804955+01', NULL, ' ');
INSERT INTO date_objet (pk_date_objet, date_iso, fk_type_date_param, libelle_original_date, notes, descriptif, fk_objet, date_creation, date_modification, certitude) VALUES (287, '1580', 25, NULL, NULL, NULL, 1223, '2015-11-06 18:13:56.804955+01', NULL, ' ');
INSERT INTO date_objet (pk_date_objet, date_iso, fk_type_date_param, libelle_original_date, notes, descriptif, fk_objet, date_creation, date_modification, certitude) VALUES (288, '1581', 25, NULL, NULL, NULL, 1312, '2015-11-06 18:13:56.804955+01', NULL, ' ');
INSERT INTO date_objet (pk_date_objet, date_iso, fk_type_date_param, libelle_original_date, notes, descriptif, fk_objet, date_creation, date_modification, certitude) VALUES (289, '1582', 25, NULL, NULL, NULL, 1506, '2015-11-06 18:13:56.804955+01', NULL, ' ');
INSERT INTO date_objet (pk_date_objet, date_iso, fk_type_date_param, libelle_original_date, notes, descriptif, fk_objet, date_creation, date_modification, certitude) VALUES (290, '1582', 25, NULL, NULL, NULL, 1550, '2015-11-06 18:13:56.804955+01', NULL, ' ');
INSERT INTO date_objet (pk_date_objet, date_iso, fk_type_date_param, libelle_original_date, notes, descriptif, fk_objet, date_creation, date_modification, certitude) VALUES (291, '1582', 25, NULL, NULL, NULL, 1279, '2015-11-06 18:13:56.804955+01', NULL, ' ');
INSERT INTO date_objet (pk_date_objet, date_iso, fk_type_date_param, libelle_original_date, notes, descriptif, fk_objet, date_creation, date_modification, certitude) VALUES (292, '1582', 25, NULL, NULL, NULL, 1270, '2015-11-06 18:13:56.804955+01', NULL, ' ');
INSERT INTO date_objet (pk_date_objet, date_iso, fk_type_date_param, libelle_original_date, notes, descriptif, fk_objet, date_creation, date_modification, certitude) VALUES (293, '1583', 25, NULL, NULL, NULL, 1421, '2015-11-06 18:13:56.804955+01', NULL, ' ');
INSERT INTO date_objet (pk_date_objet, date_iso, fk_type_date_param, libelle_original_date, notes, descriptif, fk_objet, date_creation, date_modification, certitude) VALUES (294, '1583', 25, NULL, NULL, NULL, 1294, '2015-11-06 18:13:56.804955+01', NULL, ' ');
INSERT INTO date_objet (pk_date_objet, date_iso, fk_type_date_param, libelle_original_date, notes, descriptif, fk_objet, date_creation, date_modification, certitude) VALUES (295, '1584', 25, NULL, NULL, NULL, 1395, '2015-11-06 18:13:56.804955+01', NULL, ' ');
INSERT INTO date_objet (pk_date_objet, date_iso, fk_type_date_param, libelle_original_date, notes, descriptif, fk_objet, date_creation, date_modification, certitude) VALUES (296, '1584', 25, NULL, NULL, NULL, 1490, '2015-11-06 18:13:56.804955+01', NULL, ' ');
INSERT INTO date_objet (pk_date_objet, date_iso, fk_type_date_param, libelle_original_date, notes, descriptif, fk_objet, date_creation, date_modification, certitude) VALUES (297, '1584', 25, NULL, NULL, NULL, 1216, '2015-11-06 18:13:56.804955+01', NULL, ' ');
INSERT INTO date_objet (pk_date_objet, date_iso, fk_type_date_param, libelle_original_date, notes, descriptif, fk_objet, date_creation, date_modification, certitude) VALUES (298, '1585', 25, NULL, NULL, NULL, 1300, '2015-11-06 18:13:56.804955+01', NULL, ' ');
INSERT INTO date_objet (pk_date_objet, date_iso, fk_type_date_param, libelle_original_date, notes, descriptif, fk_objet, date_creation, date_modification, certitude) VALUES (299, '1585', 25, NULL, NULL, NULL, 1201, '2015-11-06 18:13:56.804955+01', NULL, ' ');
INSERT INTO date_objet (pk_date_objet, date_iso, fk_type_date_param, libelle_original_date, notes, descriptif, fk_objet, date_creation, date_modification, certitude) VALUES (300, '1585', 25, NULL, NULL, NULL, 1063, '2015-11-06 18:13:56.804955+01', NULL, ' ');
INSERT INTO date_objet (pk_date_objet, date_iso, fk_type_date_param, libelle_original_date, notes, descriptif, fk_objet, date_creation, date_modification, certitude) VALUES (301, '1585', 25, NULL, NULL, NULL, 1008, '2015-11-06 18:13:56.804955+01', NULL, ' ');
INSERT INTO date_objet (pk_date_objet, date_iso, fk_type_date_param, libelle_original_date, notes, descriptif, fk_objet, date_creation, date_modification, certitude) VALUES (302, '1586', 25, NULL, NULL, NULL, 1583, '2015-11-06 18:13:56.804955+01', NULL, ' ');
INSERT INTO date_objet (pk_date_objet, date_iso, fk_type_date_param, libelle_original_date, notes, descriptif, fk_objet, date_creation, date_modification, certitude) VALUES (303, '1586', 25, NULL, NULL, NULL, 1183, '2015-11-06 18:13:56.804955+01', NULL, ' ');
INSERT INTO date_objet (pk_date_objet, date_iso, fk_type_date_param, libelle_original_date, notes, descriptif, fk_objet, date_creation, date_modification, certitude) VALUES (304, '1587', 25, NULL, NULL, NULL, 867, '2015-11-06 18:13:56.804955+01', NULL, ' ');
INSERT INTO date_objet (pk_date_objet, date_iso, fk_type_date_param, libelle_original_date, notes, descriptif, fk_objet, date_creation, date_modification, certitude) VALUES (305, '1587', 25, NULL, NULL, NULL, 1158, '2015-11-06 18:13:56.804955+01', NULL, ' ');
INSERT INTO date_objet (pk_date_objet, date_iso, fk_type_date_param, libelle_original_date, notes, descriptif, fk_objet, date_creation, date_modification, certitude) VALUES (306, '1587', 25, NULL, NULL, NULL, 1567, '2015-11-06 18:13:56.804955+01', NULL, ' ');
INSERT INTO date_objet (pk_date_objet, date_iso, fk_type_date_param, libelle_original_date, notes, descriptif, fk_objet, date_creation, date_modification, certitude) VALUES (307, '1588', 25, NULL, NULL, NULL, 1112, '2015-11-06 18:13:56.804955+01', NULL, ' ');
INSERT INTO date_objet (pk_date_objet, date_iso, fk_type_date_param, libelle_original_date, notes, descriptif, fk_objet, date_creation, date_modification, certitude) VALUES (308, '1588', 25, NULL, NULL, NULL, 1513, '2015-11-06 18:13:56.804955+01', NULL, ' ');
INSERT INTO date_objet (pk_date_objet, date_iso, fk_type_date_param, libelle_original_date, notes, descriptif, fk_objet, date_creation, date_modification, certitude) VALUES (309, '1650', 25, NULL, NULL, NULL, 1057, '2015-11-06 18:13:56.804955+01', NULL, ' ');
INSERT INTO date_objet (pk_date_objet, date_iso, fk_type_date_param, libelle_original_date, notes, descriptif, fk_objet, date_creation, date_modification, certitude) VALUES (310, '1651', 25, NULL, NULL, NULL, 1073, '2015-11-06 18:13:56.804955+01', NULL, 'p');
INSERT INTO date_objet (pk_date_objet, date_iso, fk_type_date_param, libelle_original_date, notes, descriptif, fk_objet, date_creation, date_modification, certitude) VALUES (311, '1651', 25, NULL, NULL, NULL, 1491, '2015-11-06 18:13:56.804955+01', NULL, 'p');
INSERT INTO date_objet (pk_date_objet, date_iso, fk_type_date_param, libelle_original_date, notes, descriptif, fk_objet, date_creation, date_modification, certitude) VALUES (312, '1651', 25, NULL, NULL, NULL, 856, '2015-11-06 18:13:56.804955+01', NULL, 'p');
INSERT INTO date_objet (pk_date_objet, date_iso, fk_type_date_param, libelle_original_date, notes, descriptif, fk_objet, date_creation, date_modification, certitude) VALUES (313, '1590', 25, NULL, NULL, NULL, 1140, '2015-11-06 18:13:56.804955+01', NULL, ' ');
INSERT INTO date_objet (pk_date_objet, date_iso, fk_type_date_param, libelle_original_date, notes, descriptif, fk_objet, date_creation, date_modification, certitude) VALUES (314, '1590', 25, NULL, NULL, NULL, 1242, '2015-11-06 18:13:56.804955+01', NULL, ' ');
INSERT INTO date_objet (pk_date_objet, date_iso, fk_type_date_param, libelle_original_date, notes, descriptif, fk_objet, date_creation, date_modification, certitude) VALUES (315, '1591', 25, NULL, NULL, NULL, 1353, '2015-11-06 18:13:56.804955+01', NULL, ' ');
INSERT INTO date_objet (pk_date_objet, date_iso, fk_type_date_param, libelle_original_date, notes, descriptif, fk_objet, date_creation, date_modification, certitude) VALUES (316, '1591', 25, NULL, NULL, NULL, 1256, '2015-11-06 18:13:56.804955+01', NULL, ' ');
INSERT INTO date_objet (pk_date_objet, date_iso, fk_type_date_param, libelle_original_date, notes, descriptif, fk_objet, date_creation, date_modification, certitude) VALUES (317, '1592', 25, NULL, NULL, NULL, 1211, '2015-11-06 18:13:56.804955+01', NULL, ' ');
INSERT INTO date_objet (pk_date_objet, date_iso, fk_type_date_param, libelle_original_date, notes, descriptif, fk_objet, date_creation, date_modification, certitude) VALUES (318, '1592', 25, NULL, NULL, NULL, 1376, '2015-11-06 18:13:56.804955+01', NULL, ' ');
INSERT INTO date_objet (pk_date_objet, date_iso, fk_type_date_param, libelle_original_date, notes, descriptif, fk_objet, date_creation, date_modification, certitude) VALUES (319, '1592', 25, NULL, NULL, NULL, 866, '2015-11-06 18:13:56.804955+01', NULL, ' ');
INSERT INTO date_objet (pk_date_objet, date_iso, fk_type_date_param, libelle_original_date, notes, descriptif, fk_objet, date_creation, date_modification, certitude) VALUES (320, '1592', 25, NULL, NULL, NULL, 1405, '2015-11-06 18:13:56.804955+01', NULL, ' ');
INSERT INTO date_objet (pk_date_objet, date_iso, fk_type_date_param, libelle_original_date, notes, descriptif, fk_objet, date_creation, date_modification, certitude) VALUES (321, '1595', 25, NULL, NULL, NULL, 1092, '2015-11-06 18:13:56.804955+01', NULL, ' ');
INSERT INTO date_objet (pk_date_objet, date_iso, fk_type_date_param, libelle_original_date, notes, descriptif, fk_objet, date_creation, date_modification, certitude) VALUES (322, '1595', 25, NULL, NULL, NULL, 926, '2015-11-06 18:13:56.804955+01', NULL, ' ');
INSERT INTO date_objet (pk_date_objet, date_iso, fk_type_date_param, libelle_original_date, notes, descriptif, fk_objet, date_creation, date_modification, certitude) VALUES (323, '1595', 25, NULL, NULL, NULL, 983, '2015-11-06 18:13:56.804955+01', NULL, ' ');
INSERT INTO date_objet (pk_date_objet, date_iso, fk_type_date_param, libelle_original_date, notes, descriptif, fk_objet, date_creation, date_modification, certitude) VALUES (324, '1596', 25, NULL, NULL, NULL, 857, '2015-11-06 18:13:56.804955+01', NULL, ' ');
INSERT INTO date_objet (pk_date_objet, date_iso, fk_type_date_param, libelle_original_date, notes, descriptif, fk_objet, date_creation, date_modification, certitude) VALUES (325, '1596', 25, NULL, NULL, NULL, 943, '2015-11-06 18:13:56.804955+01', NULL, ' ');
INSERT INTO date_objet (pk_date_objet, date_iso, fk_type_date_param, libelle_original_date, notes, descriptif, fk_objet, date_creation, date_modification, certitude) VALUES (326, '1596', 25, NULL, NULL, NULL, 1219, '2015-11-06 18:13:56.804955+01', NULL, ' ');
INSERT INTO date_objet (pk_date_objet, date_iso, fk_type_date_param, libelle_original_date, notes, descriptif, fk_objet, date_creation, date_modification, certitude) VALUES (327, '1597', 25, NULL, NULL, NULL, 1314, '2015-11-06 18:13:56.804955+01', NULL, ' ');
INSERT INTO date_objet (pk_date_objet, date_iso, fk_type_date_param, libelle_original_date, notes, descriptif, fk_objet, date_creation, date_modification, certitude) VALUES (328, '1598', 25, NULL, NULL, NULL, 1062, '2015-11-06 18:13:56.804955+01', NULL, ' ');
INSERT INTO date_objet (pk_date_objet, date_iso, fk_type_date_param, libelle_original_date, notes, descriptif, fk_objet, date_creation, date_modification, certitude) VALUES (329, '1598', 25, NULL, NULL, NULL, 1465, '2015-11-06 18:13:56.804955+01', NULL, ' ');
INSERT INTO date_objet (pk_date_objet, date_iso, fk_type_date_param, libelle_original_date, notes, descriptif, fk_objet, date_creation, date_modification, certitude) VALUES (330, '1598', 25, NULL, NULL, NULL, 859, '2015-11-06 18:13:56.804955+01', NULL, ' ');
INSERT INTO date_objet (pk_date_objet, date_iso, fk_type_date_param, libelle_original_date, notes, descriptif, fk_objet, date_creation, date_modification, certitude) VALUES (331, '1599', 25, NULL, NULL, NULL, 1050, '2015-11-06 18:13:56.804955+01', NULL, ' ');
INSERT INTO date_objet (pk_date_objet, date_iso, fk_type_date_param, libelle_original_date, notes, descriptif, fk_objet, date_creation, date_modification, certitude) VALUES (332, '1599', 25, NULL, NULL, NULL, 1177, '2015-11-06 18:13:56.804955+01', NULL, ' ');
INSERT INTO date_objet (pk_date_objet, date_iso, fk_type_date_param, libelle_original_date, notes, descriptif, fk_objet, date_creation, date_modification, certitude) VALUES (333, '1600', 25, NULL, NULL, NULL, 1012, '2015-11-06 18:13:56.804955+01', NULL, ' ');
INSERT INTO date_objet (pk_date_objet, date_iso, fk_type_date_param, libelle_original_date, notes, descriptif, fk_objet, date_creation, date_modification, certitude) VALUES (334, '1600', 25, NULL, NULL, NULL, 1078, '2015-11-06 18:13:56.804955+01', NULL, ' ');
INSERT INTO date_objet (pk_date_objet, date_iso, fk_type_date_param, libelle_original_date, notes, descriptif, fk_objet, date_creation, date_modification, certitude) VALUES (335, '1600', 25, NULL, NULL, NULL, 1430, '2015-11-06 18:13:56.804955+01', NULL, ' ');
INSERT INTO date_objet (pk_date_objet, date_iso, fk_type_date_param, libelle_original_date, notes, descriptif, fk_objet, date_creation, date_modification, certitude) VALUES (336, '1600', 25, NULL, NULL, NULL, 1259, '2015-11-06 18:13:56.804955+01', NULL, ' ');
INSERT INTO date_objet (pk_date_objet, date_iso, fk_type_date_param, libelle_original_date, notes, descriptif, fk_objet, date_creation, date_modification, certitude) VALUES (337, '1601', 25, NULL, NULL, NULL, 1148, '2015-11-06 18:13:56.804955+01', NULL, ' ');
INSERT INTO date_objet (pk_date_objet, date_iso, fk_type_date_param, libelle_original_date, notes, descriptif, fk_objet, date_creation, date_modification, certitude) VALUES (338, '1601', 25, NULL, NULL, NULL, 902, '2015-11-06 18:13:56.804955+01', NULL, ' ');
INSERT INTO date_objet (pk_date_objet, date_iso, fk_type_date_param, libelle_original_date, notes, descriptif, fk_objet, date_creation, date_modification, certitude) VALUES (339, '1651', 25, NULL, NULL, NULL, 1275, '2015-11-06 18:13:56.804955+01', NULL, 'p');
INSERT INTO date_objet (pk_date_objet, date_iso, fk_type_date_param, libelle_original_date, notes, descriptif, fk_objet, date_creation, date_modification, certitude) VALUES (340, '1651', 25, NULL, NULL, NULL, 992, '2015-11-06 18:13:56.804955+01', NULL, 'p');
INSERT INTO date_objet (pk_date_objet, date_iso, fk_type_date_param, libelle_original_date, notes, descriptif, fk_objet, date_creation, date_modification, certitude) VALUES (341, '1651', 25, NULL, NULL, NULL, 1570, '2015-11-06 18:13:56.804955+01', NULL, 'p');
INSERT INTO date_objet (pk_date_objet, date_iso, fk_type_date_param, libelle_original_date, notes, descriptif, fk_objet, date_creation, date_modification, certitude) VALUES (342, '1601', 25, NULL, NULL, NULL, 1291, '2015-11-06 18:13:56.804955+01', NULL, ' ');
INSERT INTO date_objet (pk_date_objet, date_iso, fk_type_date_param, libelle_original_date, notes, descriptif, fk_objet, date_creation, date_modification, certitude) VALUES (343, '1601', 25, NULL, NULL, NULL, 872, '2015-11-06 18:13:56.804955+01', NULL, ' ');
INSERT INTO date_objet (pk_date_objet, date_iso, fk_type_date_param, libelle_original_date, notes, descriptif, fk_objet, date_creation, date_modification, certitude) VALUES (344, '1602', 25, NULL, NULL, NULL, 1393, '2015-11-06 18:13:56.804955+01', NULL, ' ');
INSERT INTO date_objet (pk_date_objet, date_iso, fk_type_date_param, libelle_original_date, notes, descriptif, fk_objet, date_creation, date_modification, certitude) VALUES (345, '1602', 25, NULL, NULL, NULL, 964, '2015-11-06 18:13:56.804955+01', NULL, ' ');
INSERT INTO date_objet (pk_date_objet, date_iso, fk_type_date_param, libelle_original_date, notes, descriptif, fk_objet, date_creation, date_modification, certitude) VALUES (346, '1602', 25, NULL, NULL, NULL, 1298, '2015-11-06 18:13:56.804955+01', NULL, ' ');
INSERT INTO date_objet (pk_date_objet, date_iso, fk_type_date_param, libelle_original_date, notes, descriptif, fk_objet, date_creation, date_modification, certitude) VALUES (347, '1602', 25, NULL, NULL, NULL, 1552, '2015-11-06 18:13:56.804955+01', NULL, ' ');
INSERT INTO date_objet (pk_date_objet, date_iso, fk_type_date_param, libelle_original_date, notes, descriptif, fk_objet, date_creation, date_modification, certitude) VALUES (348, '1602', 25, NULL, NULL, NULL, 1574, '2015-11-06 18:13:56.804955+01', NULL, ' ');
INSERT INTO date_objet (pk_date_objet, date_iso, fk_type_date_param, libelle_original_date, notes, descriptif, fk_objet, date_creation, date_modification, certitude) VALUES (349, '1604', 25, NULL, NULL, NULL, 1511, '2015-11-06 18:13:56.804955+01', NULL, ' ');
INSERT INTO date_objet (pk_date_objet, date_iso, fk_type_date_param, libelle_original_date, notes, descriptif, fk_objet, date_creation, date_modification, certitude) VALUES (350, '1605', 25, NULL, NULL, NULL, 1563, '2015-11-06 18:13:56.804955+01', NULL, ' ');
INSERT INTO date_objet (pk_date_objet, date_iso, fk_type_date_param, libelle_original_date, notes, descriptif, fk_objet, date_creation, date_modification, certitude) VALUES (351, '1605', 25, NULL, NULL, NULL, 1269, '2015-11-06 18:13:56.804955+01', NULL, ' ');
INSERT INTO date_objet (pk_date_objet, date_iso, fk_type_date_param, libelle_original_date, notes, descriptif, fk_objet, date_creation, date_modification, certitude) VALUES (352, '1606', 25, NULL, NULL, NULL, 1246, '2015-11-06 18:13:56.804955+01', NULL, ' ');
INSERT INTO date_objet (pk_date_objet, date_iso, fk_type_date_param, libelle_original_date, notes, descriptif, fk_objet, date_creation, date_modification, certitude) VALUES (353, '1608', 25, NULL, NULL, NULL, 1414, '2015-11-06 18:13:56.804955+01', NULL, ' ');
INSERT INTO date_objet (pk_date_objet, date_iso, fk_type_date_param, libelle_original_date, notes, descriptif, fk_objet, date_creation, date_modification, certitude) VALUES (354, '1608', 25, NULL, NULL, NULL, 1411, '2015-11-06 18:13:56.804955+01', NULL, ' ');
INSERT INTO date_objet (pk_date_objet, date_iso, fk_type_date_param, libelle_original_date, notes, descriptif, fk_objet, date_creation, date_modification, certitude) VALUES (355, '1608', 25, NULL, NULL, NULL, 1557, '2015-11-06 18:13:56.804955+01', NULL, ' ');
INSERT INTO date_objet (pk_date_objet, date_iso, fk_type_date_param, libelle_original_date, notes, descriptif, fk_objet, date_creation, date_modification, certitude) VALUES (356, '1610', 25, NULL, NULL, NULL, 1467, '2015-11-06 18:13:56.804955+01', NULL, ' ');
INSERT INTO date_objet (pk_date_objet, date_iso, fk_type_date_param, libelle_original_date, notes, descriptif, fk_objet, date_creation, date_modification, certitude) VALUES (357, '1610', 25, NULL, NULL, NULL, 1507, '2015-11-06 18:13:56.804955+01', NULL, ' ');
INSERT INTO date_objet (pk_date_objet, date_iso, fk_type_date_param, libelle_original_date, notes, descriptif, fk_objet, date_creation, date_modification, certitude) VALUES (358, '1611', 25, NULL, NULL, NULL, 1365, '2015-11-06 18:13:56.804955+01', NULL, ' ');
INSERT INTO date_objet (pk_date_objet, date_iso, fk_type_date_param, libelle_original_date, notes, descriptif, fk_objet, date_creation, date_modification, certitude) VALUES (359, '1611', 25, NULL, NULL, NULL, 1526, '2015-11-06 18:13:56.804955+01', NULL, ' ');
INSERT INTO date_objet (pk_date_objet, date_iso, fk_type_date_param, libelle_original_date, notes, descriptif, fk_objet, date_creation, date_modification, certitude) VALUES (360, '1612', 25, NULL, NULL, NULL, 1441, '2015-11-06 18:13:56.804955+01', NULL, ' ');
INSERT INTO date_objet (pk_date_objet, date_iso, fk_type_date_param, libelle_original_date, notes, descriptif, fk_objet, date_creation, date_modification, certitude) VALUES (361, '1613', 25, NULL, NULL, NULL, 995, '2015-11-06 18:13:56.804955+01', NULL, ' ');
INSERT INTO date_objet (pk_date_objet, date_iso, fk_type_date_param, libelle_original_date, notes, descriptif, fk_objet, date_creation, date_modification, certitude) VALUES (362, '1613', 25, NULL, NULL, NULL, 1429, '2015-11-06 18:13:56.804955+01', NULL, ' ');
INSERT INTO date_objet (pk_date_objet, date_iso, fk_type_date_param, libelle_original_date, notes, descriptif, fk_objet, date_creation, date_modification, certitude) VALUES (363, '1613', 25, NULL, NULL, NULL, 1103, '2015-11-06 18:13:56.804955+01', NULL, ' ');
INSERT INTO date_objet (pk_date_objet, date_iso, fk_type_date_param, libelle_original_date, notes, descriptif, fk_objet, date_creation, date_modification, certitude) VALUES (364, '1614', 25, NULL, NULL, NULL, 860, '2015-11-06 18:13:56.804955+01', NULL, ' ');
INSERT INTO date_objet (pk_date_objet, date_iso, fk_type_date_param, libelle_original_date, notes, descriptif, fk_objet, date_creation, date_modification, certitude) VALUES (365, '1615', 25, NULL, NULL, NULL, 1523, '2015-11-06 18:13:56.804955+01', NULL, ' ');
INSERT INTO date_objet (pk_date_objet, date_iso, fk_type_date_param, libelle_original_date, notes, descriptif, fk_objet, date_creation, date_modification, certitude) VALUES (366, '1616', 25, NULL, NULL, NULL, 910, '2015-11-06 18:13:56.804955+01', NULL, ' ');
INSERT INTO date_objet (pk_date_objet, date_iso, fk_type_date_param, libelle_original_date, notes, descriptif, fk_objet, date_creation, date_modification, certitude) VALUES (367, '1617', 25, NULL, NULL, NULL, 954, '2015-11-06 18:13:56.804955+01', NULL, ' ');
INSERT INTO date_objet (pk_date_objet, date_iso, fk_type_date_param, libelle_original_date, notes, descriptif, fk_objet, date_creation, date_modification, certitude) VALUES (368, '1617', 25, NULL, NULL, NULL, 1156, '2015-11-06 18:13:56.804955+01', NULL, ' ');
INSERT INTO date_objet (pk_date_objet, date_iso, fk_type_date_param, libelle_original_date, notes, descriptif, fk_objet, date_creation, date_modification, certitude) VALUES (369, '1618', 25, NULL, NULL, NULL, 1318, '2015-11-06 18:13:56.804955+01', NULL, ' ');
INSERT INTO date_objet (pk_date_objet, date_iso, fk_type_date_param, libelle_original_date, notes, descriptif, fk_objet, date_creation, date_modification, certitude) VALUES (370, '1620', 25, NULL, NULL, NULL, 1267, '2015-11-06 18:13:56.804955+01', NULL, ' ');
INSERT INTO date_objet (pk_date_objet, date_iso, fk_type_date_param, libelle_original_date, notes, descriptif, fk_objet, date_creation, date_modification, certitude) VALUES (371, '1620', 25, NULL, NULL, NULL, 1155, '2015-11-06 18:13:56.804955+01', NULL, ' ');
INSERT INTO date_objet (pk_date_objet, date_iso, fk_type_date_param, libelle_original_date, notes, descriptif, fk_objet, date_creation, date_modification, certitude) VALUES (372, '1621', 25, NULL, NULL, NULL, 1178, '2015-11-06 18:13:56.804955+01', NULL, ' ');
INSERT INTO date_objet (pk_date_objet, date_iso, fk_type_date_param, libelle_original_date, notes, descriptif, fk_objet, date_creation, date_modification, certitude) VALUES (373, '1622', 25, NULL, NULL, NULL, 1485, '2015-11-06 18:13:56.804955+01', NULL, ' ');
INSERT INTO date_objet (pk_date_objet, date_iso, fk_type_date_param, libelle_original_date, notes, descriptif, fk_objet, date_creation, date_modification, certitude) VALUES (374, '1622', 25, NULL, NULL, NULL, 946, '2015-11-06 18:13:56.804955+01', NULL, ' ');
INSERT INTO date_objet (pk_date_objet, date_iso, fk_type_date_param, libelle_original_date, notes, descriptif, fk_objet, date_creation, date_modification, certitude) VALUES (375, '1622', 25, NULL, NULL, NULL, 1612, '2015-11-06 18:13:56.804955+01', NULL, ' ');
INSERT INTO date_objet (pk_date_objet, date_iso, fk_type_date_param, libelle_original_date, notes, descriptif, fk_objet, date_creation, date_modification, certitude) VALUES (376, '1622', 25, NULL, NULL, NULL, 1366, '2015-11-06 18:13:56.804955+01', NULL, ' ');
INSERT INTO date_objet (pk_date_objet, date_iso, fk_type_date_param, libelle_original_date, notes, descriptif, fk_objet, date_creation, date_modification, certitude) VALUES (377, '1623', 25, NULL, NULL, NULL, 1587, '2015-11-06 18:13:56.804955+01', NULL, ' ');
INSERT INTO date_objet (pk_date_objet, date_iso, fk_type_date_param, libelle_original_date, notes, descriptif, fk_objet, date_creation, date_modification, certitude) VALUES (378, '1624', 25, NULL, NULL, NULL, 1110, '2015-11-06 18:13:56.804955+01', NULL, ' ');
INSERT INTO date_objet (pk_date_objet, date_iso, fk_type_date_param, libelle_original_date, notes, descriptif, fk_objet, date_creation, date_modification, certitude) VALUES (379, '1625', 25, NULL, NULL, NULL, 1337, '2015-11-06 18:13:56.804955+01', NULL, ' ');
INSERT INTO date_objet (pk_date_objet, date_iso, fk_type_date_param, libelle_original_date, notes, descriptif, fk_objet, date_creation, date_modification, certitude) VALUES (380, '1625', 25, NULL, NULL, NULL, 1268, '2015-11-06 18:13:56.804955+01', NULL, ' ');
INSERT INTO date_objet (pk_date_objet, date_iso, fk_type_date_param, libelle_original_date, notes, descriptif, fk_objet, date_creation, date_modification, certitude) VALUES (381, '1625', 25, NULL, NULL, NULL, 1130, '2015-11-06 18:13:56.804955+01', NULL, ' ');
INSERT INTO date_objet (pk_date_objet, date_iso, fk_type_date_param, libelle_original_date, notes, descriptif, fk_objet, date_creation, date_modification, certitude) VALUES (382, '1625', 25, NULL, NULL, NULL, 1009, '2015-11-06 18:13:56.804955+01', NULL, ' ');
INSERT INTO date_objet (pk_date_objet, date_iso, fk_type_date_param, libelle_original_date, notes, descriptif, fk_objet, date_creation, date_modification, certitude) VALUES (383, '1625', 25, NULL, NULL, NULL, 1055, '2015-11-06 18:13:56.804955+01', NULL, ' ');
INSERT INTO date_objet (pk_date_objet, date_iso, fk_type_date_param, libelle_original_date, notes, descriptif, fk_objet, date_creation, date_modification, certitude) VALUES (384, '1625', 25, NULL, NULL, NULL, 1370, '2015-11-06 18:13:56.804955+01', NULL, ' ');
INSERT INTO date_objet (pk_date_objet, date_iso, fk_type_date_param, libelle_original_date, notes, descriptif, fk_objet, date_creation, date_modification, certitude) VALUES (385, '1625', 25, NULL, NULL, NULL, 1280, '2015-11-06 18:13:56.804955+01', NULL, ' ');
INSERT INTO date_objet (pk_date_objet, date_iso, fk_type_date_param, libelle_original_date, notes, descriptif, fk_objet, date_creation, date_modification, certitude) VALUES (386, '1626', 25, NULL, NULL, NULL, 1289, '2015-11-06 18:13:56.804955+01', NULL, ' ');
INSERT INTO date_objet (pk_date_objet, date_iso, fk_type_date_param, libelle_original_date, notes, descriptif, fk_objet, date_creation, date_modification, certitude) VALUES (387, '1627', 25, NULL, NULL, NULL, 1096, '2015-11-06 18:13:56.804955+01', NULL, ' ');
INSERT INTO date_objet (pk_date_objet, date_iso, fk_type_date_param, libelle_original_date, notes, descriptif, fk_objet, date_creation, date_modification, certitude) VALUES (388, '1628', 25, NULL, NULL, NULL, 1377, '2015-11-06 18:13:56.804955+01', NULL, ' ');
INSERT INTO date_objet (pk_date_objet, date_iso, fk_type_date_param, libelle_original_date, notes, descriptif, fk_objet, date_creation, date_modification, certitude) VALUES (389, '1628', 25, NULL, NULL, NULL, 869, '2015-11-06 18:13:56.804955+01', NULL, ' ');
INSERT INTO date_objet (pk_date_objet, date_iso, fk_type_date_param, libelle_original_date, notes, descriptif, fk_objet, date_creation, date_modification, certitude) VALUES (390, '1629', 25, NULL, NULL, NULL, 938, '2015-11-06 18:13:56.804955+01', NULL, ' ');
INSERT INTO date_objet (pk_date_objet, date_iso, fk_type_date_param, libelle_original_date, notes, descriptif, fk_objet, date_creation, date_modification, certitude) VALUES (391, '1630', 25, NULL, NULL, NULL, 1059, '2015-11-06 18:13:56.804955+01', NULL, ' ');
INSERT INTO date_objet (pk_date_objet, date_iso, fk_type_date_param, libelle_original_date, notes, descriptif, fk_objet, date_creation, date_modification, certitude) VALUES (392, '1630', 25, NULL, NULL, NULL, 1124, '2015-11-06 18:13:56.804955+01', NULL, ' ');
INSERT INTO date_objet (pk_date_objet, date_iso, fk_type_date_param, libelle_original_date, notes, descriptif, fk_objet, date_creation, date_modification, certitude) VALUES (393, '1630', 25, NULL, NULL, NULL, 1544, '2015-11-06 18:13:56.804955+01', NULL, ' ');
INSERT INTO date_objet (pk_date_objet, date_iso, fk_type_date_param, libelle_original_date, notes, descriptif, fk_objet, date_creation, date_modification, certitude) VALUES (394, '1631', 25, NULL, NULL, NULL, 941, '2015-11-06 18:13:56.804955+01', NULL, ' ');
INSERT INTO date_objet (pk_date_objet, date_iso, fk_type_date_param, libelle_original_date, notes, descriptif, fk_objet, date_creation, date_modification, certitude) VALUES (395, '1631', 25, NULL, NULL, NULL, 1093, '2015-11-06 18:13:56.804955+01', NULL, ' ');
INSERT INTO date_objet (pk_date_objet, date_iso, fk_type_date_param, libelle_original_date, notes, descriptif, fk_objet, date_creation, date_modification, certitude) VALUES (396, '1632', 25, NULL, NULL, NULL, 1545, '2015-11-06 18:13:56.804955+01', NULL, ' ');
INSERT INTO date_objet (pk_date_objet, date_iso, fk_type_date_param, libelle_original_date, notes, descriptif, fk_objet, date_creation, date_modification, certitude) VALUES (397, '1633', 25, NULL, NULL, NULL, 933, '2015-11-06 18:13:56.804955+01', NULL, ' ');
INSERT INTO date_objet (pk_date_objet, date_iso, fk_type_date_param, libelle_original_date, notes, descriptif, fk_objet, date_creation, date_modification, certitude) VALUES (398, '1633', 25, NULL, NULL, NULL, 1475, '2015-11-06 18:13:56.804955+01', NULL, ' ');
INSERT INTO date_objet (pk_date_objet, date_iso, fk_type_date_param, libelle_original_date, notes, descriptif, fk_objet, date_creation, date_modification, certitude) VALUES (399, '1633', 25, NULL, NULL, NULL, 1108, '2015-11-06 18:13:56.804955+01', NULL, ' ');
INSERT INTO date_objet (pk_date_objet, date_iso, fk_type_date_param, libelle_original_date, notes, descriptif, fk_objet, date_creation, date_modification, certitude) VALUES (400, '1633', 25, NULL, NULL, NULL, 1274, '2015-11-06 18:13:56.804955+01', NULL, ' ');
INSERT INTO date_objet (pk_date_objet, date_iso, fk_type_date_param, libelle_original_date, notes, descriptif, fk_objet, date_creation, date_modification, certitude) VALUES (401, '1633', 25, NULL, NULL, NULL, 1217, '2015-11-06 18:13:56.804955+01', NULL, ' ');
INSERT INTO date_objet (pk_date_objet, date_iso, fk_type_date_param, libelle_original_date, notes, descriptif, fk_objet, date_creation, date_modification, certitude) VALUES (402, '1633', 25, NULL, NULL, NULL, 1559, '2015-11-06 18:13:56.804955+01', NULL, ' ');
INSERT INTO date_objet (pk_date_objet, date_iso, fk_type_date_param, libelle_original_date, notes, descriptif, fk_objet, date_creation, date_modification, certitude) VALUES (403, '1635', 25, NULL, NULL, NULL, 1556, '2015-11-06 18:13:56.804955+01', NULL, ' ');
INSERT INTO date_objet (pk_date_objet, date_iso, fk_type_date_param, libelle_original_date, notes, descriptif, fk_objet, date_creation, date_modification, certitude) VALUES (404, '1636', 25, NULL, NULL, NULL, 939, '2015-11-06 18:13:56.804955+01', NULL, ' ');
INSERT INTO date_objet (pk_date_objet, date_iso, fk_type_date_param, libelle_original_date, notes, descriptif, fk_objet, date_creation, date_modification, certitude) VALUES (405, '1637', 25, NULL, NULL, NULL, 1041, '2015-11-06 18:13:56.804955+01', NULL, ' ');
INSERT INTO date_objet (pk_date_objet, date_iso, fk_type_date_param, libelle_original_date, notes, descriptif, fk_objet, date_creation, date_modification, certitude) VALUES (406, '1637', 25, NULL, NULL, NULL, 1000, '2015-11-06 18:13:56.804955+01', NULL, ' ');
INSERT INTO date_objet (pk_date_objet, date_iso, fk_type_date_param, libelle_original_date, notes, descriptif, fk_objet, date_creation, date_modification, certitude) VALUES (407, '1638', 25, NULL, NULL, NULL, 1143, '2015-11-06 18:13:56.804955+01', NULL, ' ');
INSERT INTO date_objet (pk_date_objet, date_iso, fk_type_date_param, libelle_original_date, notes, descriptif, fk_objet, date_creation, date_modification, certitude) VALUES (408, '1638', 25, NULL, NULL, NULL, 1338, '2015-11-06 18:13:56.804955+01', NULL, ' ');
INSERT INTO date_objet (pk_date_objet, date_iso, fk_type_date_param, libelle_original_date, notes, descriptif, fk_objet, date_creation, date_modification, certitude) VALUES (409, '1638', 25, NULL, NULL, NULL, 1406, '2015-11-06 18:13:56.804955+01', NULL, ' ');
INSERT INTO date_objet (pk_date_objet, date_iso, fk_type_date_param, libelle_original_date, notes, descriptif, fk_objet, date_creation, date_modification, certitude) VALUES (410, '1655', 25, NULL, NULL, NULL, 1097, '2015-11-06 18:13:56.804955+01', NULL, ' ');
INSERT INTO date_objet (pk_date_objet, date_iso, fk_type_date_param, libelle_original_date, notes, descriptif, fk_objet, date_creation, date_modification, certitude) VALUES (411, '1638', 25, NULL, NULL, NULL, 1581, '2015-11-06 18:13:56.804955+01', NULL, ' ');
INSERT INTO date_objet (pk_date_objet, date_iso, fk_type_date_param, libelle_original_date, notes, descriptif, fk_objet, date_creation, date_modification, certitude) VALUES (412, '1640', 25, NULL, NULL, NULL, 1052, '2015-11-06 18:13:56.804955+01', NULL, ' ');
INSERT INTO date_objet (pk_date_objet, date_iso, fk_type_date_param, libelle_original_date, notes, descriptif, fk_objet, date_creation, date_modification, certitude) VALUES (413, '1640', 25, NULL, NULL, NULL, 1290, '2015-11-06 18:13:56.804955+01', NULL, ' ');
INSERT INTO date_objet (pk_date_objet, date_iso, fk_type_date_param, libelle_original_date, notes, descriptif, fk_objet, date_creation, date_modification, certitude) VALUES (414, '1642', 25, NULL, NULL, NULL, 1010, '2015-11-06 18:13:56.804955+01', NULL, ' ');
INSERT INTO date_objet (pk_date_objet, date_iso, fk_type_date_param, libelle_original_date, notes, descriptif, fk_objet, date_creation, date_modification, certitude) VALUES (415, '1642', 25, NULL, NULL, NULL, 1502, '2015-11-06 18:13:56.804955+01', NULL, ' ');
INSERT INTO date_objet (pk_date_objet, date_iso, fk_type_date_param, libelle_original_date, notes, descriptif, fk_objet, date_creation, date_modification, certitude) VALUES (416, '1642', 25, NULL, NULL, NULL, 1538, '2015-11-06 18:13:56.804955+01', NULL, ' ');
INSERT INTO date_objet (pk_date_objet, date_iso, fk_type_date_param, libelle_original_date, notes, descriptif, fk_objet, date_creation, date_modification, certitude) VALUES (417, '1642', 25, NULL, NULL, NULL, 928, '2015-11-06 18:13:56.804955+01', NULL, ' ');
INSERT INTO date_objet (pk_date_objet, date_iso, fk_type_date_param, libelle_original_date, notes, descriptif, fk_objet, date_creation, date_modification, certitude) VALUES (418, '1643', 25, NULL, NULL, NULL, 1445, '2015-11-06 18:13:56.804955+01', NULL, ' ');
INSERT INTO date_objet (pk_date_objet, date_iso, fk_type_date_param, libelle_original_date, notes, descriptif, fk_objet, date_creation, date_modification, certitude) VALUES (419, '1644', 25, NULL, NULL, NULL, 893, '2015-11-06 18:13:56.804955+01', NULL, ' ');
INSERT INTO date_objet (pk_date_objet, date_iso, fk_type_date_param, libelle_original_date, notes, descriptif, fk_objet, date_creation, date_modification, certitude) VALUES (420, '1644', 25, NULL, NULL, NULL, 975, '2015-11-06 18:13:56.804955+01', NULL, ' ');
INSERT INTO date_objet (pk_date_objet, date_iso, fk_type_date_param, libelle_original_date, notes, descriptif, fk_objet, date_creation, date_modification, certitude) VALUES (421, '1644', 25, NULL, NULL, NULL, 1401, '2015-11-06 18:13:56.804955+01', NULL, ' ');
INSERT INTO date_objet (pk_date_objet, date_iso, fk_type_date_param, libelle_original_date, notes, descriptif, fk_objet, date_creation, date_modification, certitude) VALUES (422, '1645', 25, NULL, NULL, NULL, 854, '2015-11-06 18:13:56.804955+01', NULL, ' ');
INSERT INTO date_objet (pk_date_objet, date_iso, fk_type_date_param, libelle_original_date, notes, descriptif, fk_objet, date_creation, date_modification, certitude) VALUES (423, '1645', 25, NULL, NULL, NULL, 1321, '2015-11-06 18:13:56.804955+01', NULL, ' ');
INSERT INTO date_objet (pk_date_objet, date_iso, fk_type_date_param, libelle_original_date, notes, descriptif, fk_objet, date_creation, date_modification, certitude) VALUES (424, '1645', 25, NULL, NULL, NULL, 882, '2015-11-06 18:13:56.804955+01', NULL, ' ');
INSERT INTO date_objet (pk_date_objet, date_iso, fk_type_date_param, libelle_original_date, notes, descriptif, fk_objet, date_creation, date_modification, certitude) VALUES (425, '1646', 25, NULL, NULL, NULL, 1042, '2015-11-06 18:13:56.804955+01', NULL, ' ');
INSERT INTO date_objet (pk_date_objet, date_iso, fk_type_date_param, libelle_original_date, notes, descriptif, fk_objet, date_creation, date_modification, certitude) VALUES (426, '1646', 25, NULL, NULL, NULL, 1615, '2015-11-06 18:13:56.804955+01', NULL, ' ');
INSERT INTO date_objet (pk_date_objet, date_iso, fk_type_date_param, libelle_original_date, notes, descriptif, fk_objet, date_creation, date_modification, certitude) VALUES (427, '1646', 25, NULL, NULL, NULL, 1446, '2015-11-06 18:13:56.804955+01', NULL, ' ');
INSERT INTO date_objet (pk_date_objet, date_iso, fk_type_date_param, libelle_original_date, notes, descriptif, fk_objet, date_creation, date_modification, certitude) VALUES (428, '1646', 25, NULL, NULL, NULL, 841, '2015-11-06 18:13:56.804955+01', NULL, ' ');
INSERT INTO date_objet (pk_date_objet, date_iso, fk_type_date_param, libelle_original_date, notes, descriptif, fk_objet, date_creation, date_modification, certitude) VALUES (429, '1646', 25, NULL, NULL, NULL, 927, '2015-11-06 18:13:56.804955+01', NULL, ' ');
INSERT INTO date_objet (pk_date_objet, date_iso, fk_type_date_param, libelle_original_date, notes, descriptif, fk_objet, date_creation, date_modification, certitude) VALUES (430, '1648', 25, NULL, NULL, NULL, 1172, '2015-11-06 18:13:56.804955+01', NULL, ' ');
INSERT INTO date_objet (pk_date_objet, date_iso, fk_type_date_param, libelle_original_date, notes, descriptif, fk_objet, date_creation, date_modification, certitude) VALUES (431, '1648', 25, NULL, NULL, NULL, 1079, '2015-11-06 18:13:56.804955+01', NULL, ' ');
INSERT INTO date_objet (pk_date_objet, date_iso, fk_type_date_param, libelle_original_date, notes, descriptif, fk_objet, date_creation, date_modification, certitude) VALUES (432, '1151', 25, NULL, NULL, NULL, 1589, '2015-11-06 18:13:56.804955+01', NULL, 'p');
INSERT INTO date_objet (pk_date_objet, date_iso, fk_type_date_param, libelle_original_date, notes, descriptif, fk_objet, date_creation, date_modification, certitude) VALUES (433, '1288', 25, NULL, NULL, NULL, 1603, '2015-11-06 18:13:56.804955+01', NULL, ' ');
INSERT INTO date_objet (pk_date_objet, date_iso, fk_type_date_param, libelle_original_date, notes, descriptif, fk_objet, date_creation, date_modification, certitude) VALUES (434, '1351', 25, NULL, NULL, NULL, 1590, '2015-11-06 18:13:56.804955+01', NULL, 'p');
INSERT INTO date_objet (pk_date_objet, date_iso, fk_type_date_param, libelle_original_date, notes, descriptif, fk_objet, date_creation, date_modification, certitude) VALUES (435, '1451', 25, NULL, NULL, NULL, 1604, '2015-11-06 18:13:56.804955+01', NULL, 'p');
INSERT INTO date_objet (pk_date_objet, date_iso, fk_type_date_param, libelle_original_date, notes, descriptif, fk_objet, date_creation, date_modification, certitude) VALUES (436, '1491', 25, NULL, NULL, NULL, 1608, '2015-11-06 18:13:56.804955+01', NULL, ' ');
INSERT INTO date_objet (pk_date_objet, date_iso, fk_type_date_param, libelle_original_date, notes, descriptif, fk_objet, date_creation, date_modification, certitude) VALUES (437, '1520', 25, NULL, NULL, NULL, 1618, '2015-11-06 18:13:56.804955+01', NULL, ' ');
INSERT INTO date_objet (pk_date_objet, date_iso, fk_type_date_param, libelle_original_date, notes, descriptif, fk_objet, date_creation, date_modification, certitude) VALUES (438, '1524', 25, NULL, NULL, NULL, 1588, '2015-11-06 18:13:56.804955+01', NULL, ' ');
INSERT INTO date_objet (pk_date_objet, date_iso, fk_type_date_param, libelle_original_date, notes, descriptif, fk_objet, date_creation, date_modification, certitude) VALUES (439, '1536', 25, NULL, NULL, NULL, 1601, '2015-11-06 18:13:56.804955+01', NULL, ' ');
INSERT INTO date_objet (pk_date_objet, date_iso, fk_type_date_param, libelle_original_date, notes, descriptif, fk_objet, date_creation, date_modification, certitude) VALUES (440, '1546', 25, NULL, NULL, NULL, 1596, '2015-11-06 18:13:56.804955+01', NULL, ' ');
INSERT INTO date_objet (pk_date_objet, date_iso, fk_type_date_param, libelle_original_date, notes, descriptif, fk_objet, date_creation, date_modification, certitude) VALUES (441, '1551', 25, NULL, NULL, NULL, 1613, '2015-11-06 18:13:56.804955+01', NULL, 'p');
INSERT INTO date_objet (pk_date_objet, date_iso, fk_type_date_param, libelle_original_date, notes, descriptif, fk_objet, date_creation, date_modification, certitude) VALUES (442, '1656', 25, NULL, NULL, NULL, 1296, '2015-11-06 18:13:56.804955+01', NULL, ' ');
INSERT INTO date_objet (pk_date_objet, date_iso, fk_type_date_param, libelle_original_date, notes, descriptif, fk_objet, date_creation, date_modification, certitude) VALUES (443, '1675', 25, NULL, NULL, NULL, 1026, '2015-11-06 18:13:56.804955+01', NULL, ' ');
INSERT INTO date_objet (pk_date_objet, date_iso, fk_type_date_param, libelle_original_date, notes, descriptif, fk_objet, date_creation, date_modification, certitude) VALUES (444, '1551', 25, NULL, NULL, NULL, 1592, '2015-11-06 18:13:56.804955+01', NULL, 'p');
INSERT INTO date_objet (pk_date_objet, date_iso, fk_type_date_param, libelle_original_date, notes, descriptif, fk_objet, date_creation, date_modification, certitude) VALUES (445, '1551', 25, NULL, NULL, NULL, 1609, '2015-11-06 18:13:56.804955+01', NULL, 'p');
INSERT INTO date_objet (pk_date_objet, date_iso, fk_type_date_param, libelle_original_date, notes, descriptif, fk_objet, date_creation, date_modification, certitude) VALUES (446, '1718', 25, NULL, NULL, NULL, 1350, '2015-11-06 18:13:56.804955+01', NULL, ' ');
INSERT INTO date_objet (pk_date_objet, date_iso, fk_type_date_param, libelle_original_date, notes, descriptif, fk_objet, date_creation, date_modification, certitude) VALUES (447, '1651', 25, NULL, NULL, NULL, 1203, '2015-11-06 18:13:56.804955+01', NULL, 'p');
INSERT INTO date_objet (pk_date_objet, date_iso, fk_type_date_param, libelle_original_date, notes, descriptif, fk_objet, date_creation, date_modification, certitude) VALUES (448, '1572', 25, NULL, NULL, NULL, 1602, '2015-11-06 18:13:56.804955+01', NULL, ' ');
INSERT INTO date_objet (pk_date_objet, date_iso, fk_type_date_param, libelle_original_date, notes, descriptif, fk_objet, date_creation, date_modification, certitude) VALUES (449, '1572', 25, NULL, NULL, NULL, 1597, '2015-11-06 18:13:56.804955+01', NULL, ' ');
INSERT INTO date_objet (pk_date_objet, date_iso, fk_type_date_param, libelle_original_date, notes, descriptif, fk_objet, date_creation, date_modification, certitude) VALUES (450, '1575', 25, NULL, NULL, NULL, 1599, '2015-11-06 18:13:56.804955+01', NULL, ' ');
INSERT INTO date_objet (pk_date_objet, date_iso, fk_type_date_param, libelle_original_date, notes, descriptif, fk_objet, date_creation, date_modification, certitude) VALUES (451, '1588', 25, NULL, NULL, NULL, 1586, '2015-11-06 18:13:56.804955+01', NULL, ' ');
INSERT INTO date_objet (pk_date_objet, date_iso, fk_type_date_param, libelle_original_date, notes, descriptif, fk_objet, date_creation, date_modification, certitude) VALUES (452, '1610', 25, NULL, NULL, NULL, 1593, '2015-11-06 18:13:56.804955+01', NULL, ' ');
INSERT INTO date_objet (pk_date_objet, date_iso, fk_type_date_param, libelle_original_date, notes, descriptif, fk_objet, date_creation, date_modification, certitude) VALUES (453, '1642', 25, NULL, NULL, NULL, 1606, '2015-11-06 18:13:56.804955+01', NULL, ' ');
INSERT INTO date_objet (pk_date_objet, date_iso, fk_type_date_param, libelle_original_date, notes, descriptif, fk_objet, date_creation, date_modification, certitude) VALUES (454, '1651', 25, NULL, NULL, NULL, 1372, '2015-11-06 18:13:56.804955+01', NULL, 'p');
INSERT INTO date_objet (pk_date_objet, date_iso, fk_type_date_param, libelle_original_date, notes, descriptif, fk_objet, date_creation, date_modification, certitude) VALUES (455, '1651', 25, NULL, NULL, NULL, 1082, '2015-11-06 18:13:56.804955+01', NULL, ' ');
INSERT INTO date_objet (pk_date_objet, date_iso, fk_type_date_param, libelle_original_date, notes, descriptif, fk_objet, date_creation, date_modification, certitude) VALUES (456, '1651', 25, NULL, NULL, NULL, 1032, '2015-11-06 18:13:56.804955+01', NULL, 'p');
INSERT INTO date_objet (pk_date_objet, date_iso, fk_type_date_param, libelle_original_date, notes, descriptif, fk_objet, date_creation, date_modification, certitude) VALUES (457, '1651', 25, NULL, NULL, NULL, 1087, '2015-11-06 18:13:56.804955+01', NULL, 'p');
INSERT INTO date_objet (pk_date_objet, date_iso, fk_type_date_param, libelle_original_date, notes, descriptif, fk_objet, date_creation, date_modification, certitude) VALUES (458, '1651', 25, NULL, NULL, NULL, 1378, '2015-11-06 18:13:56.804955+01', NULL, 'p');
INSERT INTO date_objet (pk_date_objet, date_iso, fk_type_date_param, libelle_original_date, notes, descriptif, fk_objet, date_creation, date_modification, certitude) VALUES (459, '1651', 25, NULL, NULL, NULL, 1419, '2015-11-06 18:13:56.804955+01', NULL, ' ');
INSERT INTO date_objet (pk_date_objet, date_iso, fk_type_date_param, libelle_original_date, notes, descriptif, fk_objet, date_creation, date_modification, certitude) VALUES (460, '1651', 25, NULL, NULL, NULL, 1088, '2015-11-06 18:13:56.804955+01', NULL, 'p');
INSERT INTO date_objet (pk_date_objet, date_iso, fk_type_date_param, libelle_original_date, notes, descriptif, fk_objet, date_creation, date_modification, certitude) VALUES (461, '1651', 25, NULL, NULL, NULL, 1107, '2015-11-06 18:13:56.804955+01', NULL, 'p');
INSERT INTO date_objet (pk_date_objet, date_iso, fk_type_date_param, libelle_original_date, notes, descriptif, fk_objet, date_creation, date_modification, certitude) VALUES (462, '1651', 25, NULL, NULL, NULL, 1013, '2015-11-06 18:13:56.804955+01', NULL, 'p');
INSERT INTO date_objet (pk_date_objet, date_iso, fk_type_date_param, libelle_original_date, notes, descriptif, fk_objet, date_creation, date_modification, certitude) VALUES (463, '1651', 25, NULL, NULL, NULL, 894, '2015-11-06 18:13:56.804955+01', NULL, 'p');
INSERT INTO date_objet (pk_date_objet, date_iso, fk_type_date_param, libelle_original_date, notes, descriptif, fk_objet, date_creation, date_modification, certitude) VALUES (464, '1651', 25, NULL, NULL, NULL, 1282, '2015-11-06 18:13:56.804955+01', NULL, 'p');
INSERT INTO date_objet (pk_date_objet, date_iso, fk_type_date_param, libelle_original_date, notes, descriptif, fk_objet, date_creation, date_modification, certitude) VALUES (465, '1651', 25, NULL, NULL, NULL, 1319, '2015-11-06 18:13:56.804955+01', NULL, 'p');
INSERT INTO date_objet (pk_date_objet, date_iso, fk_type_date_param, libelle_original_date, notes, descriptif, fk_objet, date_creation, date_modification, certitude) VALUES (466, '1651', 25, NULL, NULL, NULL, 1258, '2015-11-06 18:13:56.804955+01', NULL, 'p');
INSERT INTO date_objet (pk_date_objet, date_iso, fk_type_date_param, libelle_original_date, notes, descriptif, fk_objet, date_creation, date_modification, certitude) VALUES (467, '1651', 25, NULL, NULL, NULL, 1508, '2015-11-06 18:13:56.804955+01', NULL, 'p');
INSERT INTO date_objet (pk_date_objet, date_iso, fk_type_date_param, libelle_original_date, notes, descriptif, fk_objet, date_creation, date_modification, certitude) VALUES (468, '1651', 25, NULL, NULL, NULL, 1132, '2015-11-06 18:13:56.804955+01', NULL, 'p');
INSERT INTO date_objet (pk_date_objet, date_iso, fk_type_date_param, libelle_original_date, notes, descriptif, fk_objet, date_creation, date_modification, certitude) VALUES (469, '1651', 25, NULL, NULL, NULL, 874, '2015-11-06 18:13:56.804955+01', NULL, 'p');
INSERT INTO date_objet (pk_date_objet, date_iso, fk_type_date_param, libelle_original_date, notes, descriptif, fk_objet, date_creation, date_modification, certitude) VALUES (470, '1651', 25, NULL, NULL, NULL, 1385, '2015-11-06 18:13:56.804955+01', NULL, 'p');
INSERT INTO date_objet (pk_date_objet, date_iso, fk_type_date_param, libelle_original_date, notes, descriptif, fk_objet, date_creation, date_modification, certitude) VALUES (471, '1651', 25, NULL, NULL, NULL, 1048, '2015-11-06 18:13:56.804955+01', NULL, 'p');
INSERT INTO date_objet (pk_date_objet, date_iso, fk_type_date_param, libelle_original_date, notes, descriptif, fk_objet, date_creation, date_modification, certitude) VALUES (472, '1652', 25, NULL, NULL, NULL, 1390, '2015-11-06 18:13:56.804955+01', NULL, ' ');
INSERT INTO date_objet (pk_date_objet, date_iso, fk_type_date_param, libelle_original_date, notes, descriptif, fk_objet, date_creation, date_modification, certitude) VALUES (473, '1652', 25, NULL, NULL, NULL, 1292, '2015-11-06 18:13:56.804955+01', NULL, ' ');
INSERT INTO date_objet (pk_date_objet, date_iso, fk_type_date_param, libelle_original_date, notes, descriptif, fk_objet, date_creation, date_modification, certitude) VALUES (474, '1652', 25, NULL, NULL, NULL, 1192, '2015-11-06 18:13:56.804955+01', NULL, ' ');
INSERT INTO date_objet (pk_date_objet, date_iso, fk_type_date_param, libelle_original_date, notes, descriptif, fk_objet, date_creation, date_modification, certitude) VALUES (475, '1653', 25, NULL, NULL, NULL, 1304, '2015-11-06 18:13:56.804955+01', NULL, ' ');
INSERT INTO date_objet (pk_date_objet, date_iso, fk_type_date_param, libelle_original_date, notes, descriptif, fk_objet, date_creation, date_modification, certitude) VALUES (476, '1654', 25, NULL, NULL, NULL, 1520, '2015-11-06 18:13:56.804955+01', NULL, ' ');
INSERT INTO date_objet (pk_date_objet, date_iso, fk_type_date_param, libelle_original_date, notes, descriptif, fk_objet, date_creation, date_modification, certitude) VALUES (477, '1654', 25, NULL, NULL, NULL, 1426, '2015-11-06 18:13:56.804955+01', NULL, ' ');
INSERT INTO date_objet (pk_date_objet, date_iso, fk_type_date_param, libelle_original_date, notes, descriptif, fk_objet, date_creation, date_modification, certitude) VALUES (478, '1654', 25, NULL, NULL, NULL, 1578, '2015-11-06 18:13:56.804955+01', NULL, ' ');
INSERT INTO date_objet (pk_date_objet, date_iso, fk_type_date_param, libelle_original_date, notes, descriptif, fk_objet, date_creation, date_modification, certitude) VALUES (479, '1654', 25, NULL, NULL, NULL, 1089, '2015-11-06 18:13:56.804955+01', NULL, ' ');
INSERT INTO date_objet (pk_date_objet, date_iso, fk_type_date_param, libelle_original_date, notes, descriptif, fk_objet, date_creation, date_modification, certitude) VALUES (480, '1654', 25, NULL, NULL, NULL, 974, '2015-11-06 18:13:56.804955+01', NULL, ' ');
INSERT INTO date_objet (pk_date_objet, date_iso, fk_type_date_param, libelle_original_date, notes, descriptif, fk_objet, date_creation, date_modification, certitude) VALUES (481, '1654', 25, NULL, NULL, NULL, 1083, '2015-11-06 18:13:56.804955+01', NULL, ' ');
INSERT INTO date_objet (pk_date_objet, date_iso, fk_type_date_param, libelle_original_date, notes, descriptif, fk_objet, date_creation, date_modification, certitude) VALUES (482, '1654', 25, NULL, NULL, NULL, 1045, '2015-11-06 18:13:56.804955+01', NULL, ' ');
INSERT INTO date_objet (pk_date_objet, date_iso, fk_type_date_param, libelle_original_date, notes, descriptif, fk_objet, date_creation, date_modification, certitude) VALUES (483, '1655', 25, NULL, NULL, NULL, 1024, '2015-11-06 18:13:56.804955+01', NULL, ' ');
INSERT INTO date_objet (pk_date_objet, date_iso, fk_type_date_param, libelle_original_date, notes, descriptif, fk_objet, date_creation, date_modification, certitude) VALUES (484, '1656', 25, NULL, NULL, NULL, 1462, '2015-11-06 18:13:56.804955+01', NULL, ' ');
INSERT INTO date_objet (pk_date_objet, date_iso, fk_type_date_param, libelle_original_date, notes, descriptif, fk_objet, date_creation, date_modification, certitude) VALUES (485, '1656', 25, NULL, NULL, NULL, 842, '2015-11-06 18:13:56.804955+01', NULL, ' ');
INSERT INTO date_objet (pk_date_objet, date_iso, fk_type_date_param, libelle_original_date, notes, descriptif, fk_objet, date_creation, date_modification, certitude) VALUES (486, '1656', 25, NULL, NULL, NULL, 1521, '2015-11-06 18:13:56.804955+01', NULL, ' ');
INSERT INTO date_objet (pk_date_objet, date_iso, fk_type_date_param, libelle_original_date, notes, descriptif, fk_objet, date_creation, date_modification, certitude) VALUES (487, '1657', 25, NULL, NULL, NULL, 1049, '2015-11-06 18:13:56.804955+01', NULL, ' ');
INSERT INTO date_objet (pk_date_objet, date_iso, fk_type_date_param, libelle_original_date, notes, descriptif, fk_objet, date_creation, date_modification, certitude) VALUES (488, '1657', 25, NULL, NULL, NULL, 1018, '2015-11-06 18:13:56.804955+01', NULL, ' ');
INSERT INTO date_objet (pk_date_objet, date_iso, fk_type_date_param, libelle_original_date, notes, descriptif, fk_objet, date_creation, date_modification, certitude) VALUES (489, '1659', 25, NULL, NULL, NULL, 1021, '2015-11-06 18:13:56.804955+01', NULL, ' ');
INSERT INTO date_objet (pk_date_objet, date_iso, fk_type_date_param, libelle_original_date, notes, descriptif, fk_objet, date_creation, date_modification, certitude) VALUES (490, '1659', 25, NULL, NULL, NULL, 966, '2015-11-06 18:13:56.804955+01', NULL, ' ');
INSERT INTO date_objet (pk_date_objet, date_iso, fk_type_date_param, libelle_original_date, notes, descriptif, fk_objet, date_creation, date_modification, certitude) VALUES (491, '1660', 25, NULL, NULL, NULL, 1466, '2015-11-06 18:13:56.804955+01', NULL, ' ');
INSERT INTO date_objet (pk_date_objet, date_iso, fk_type_date_param, libelle_original_date, notes, descriptif, fk_objet, date_creation, date_modification, certitude) VALUES (492, '1660', 25, NULL, NULL, NULL, 979, '2015-11-06 18:13:56.804955+01', NULL, ' ');
INSERT INTO date_objet (pk_date_objet, date_iso, fk_type_date_param, libelle_original_date, notes, descriptif, fk_objet, date_creation, date_modification, certitude) VALUES (493, '1661', 25, NULL, NULL, NULL, 1380, '2015-11-06 18:13:56.804955+01', NULL, ' ');
INSERT INTO date_objet (pk_date_objet, date_iso, fk_type_date_param, libelle_original_date, notes, descriptif, fk_objet, date_creation, date_modification, certitude) VALUES (494, '1662', 25, NULL, NULL, NULL, 1363, '2015-11-06 18:13:56.804955+01', NULL, ' ');
INSERT INTO date_objet (pk_date_objet, date_iso, fk_type_date_param, libelle_original_date, notes, descriptif, fk_objet, date_creation, date_modification, certitude) VALUES (495, '1662', 25, NULL, NULL, NULL, 878, '2015-11-06 18:13:56.804955+01', NULL, ' ');
INSERT INTO date_objet (pk_date_objet, date_iso, fk_type_date_param, libelle_original_date, notes, descriptif, fk_objet, date_creation, date_modification, certitude) VALUES (496, '1663', 25, NULL, NULL, NULL, 1029, '2015-11-06 18:13:56.804955+01', NULL, ' ');
INSERT INTO date_objet (pk_date_objet, date_iso, fk_type_date_param, libelle_original_date, notes, descriptif, fk_objet, date_creation, date_modification, certitude) VALUES (497, '1663', 25, NULL, NULL, NULL, 1309, '2015-11-06 18:13:56.804955+01', NULL, ' ');
INSERT INTO date_objet (pk_date_objet, date_iso, fk_type_date_param, libelle_original_date, notes, descriptif, fk_objet, date_creation, date_modification, certitude) VALUES (498, '1663', 25, NULL, NULL, NULL, 1165, '2015-11-06 18:13:56.804955+01', NULL, ' ');
INSERT INTO date_objet (pk_date_objet, date_iso, fk_type_date_param, libelle_original_date, notes, descriptif, fk_objet, date_creation, date_modification, certitude) VALUES (499, '1664', 25, NULL, NULL, NULL, 1260, '2015-11-06 18:13:56.804955+01', NULL, ' ');
INSERT INTO date_objet (pk_date_objet, date_iso, fk_type_date_param, libelle_original_date, notes, descriptif, fk_objet, date_creation, date_modification, certitude) VALUES (500, '1664', 25, NULL, NULL, NULL, 1486, '2015-11-06 18:13:56.804955+01', NULL, ' ');
INSERT INTO date_objet (pk_date_objet, date_iso, fk_type_date_param, libelle_original_date, notes, descriptif, fk_objet, date_creation, date_modification, certitude) VALUES (501, '1667', 25, NULL, NULL, NULL, 1287, '2015-11-06 18:13:56.804955+01', NULL, ' ');
INSERT INTO date_objet (pk_date_objet, date_iso, fk_type_date_param, libelle_original_date, notes, descriptif, fk_objet, date_creation, date_modification, certitude) VALUES (502, '1667', 25, NULL, NULL, NULL, 1250, '2015-11-06 18:13:56.804955+01', NULL, ' ');
INSERT INTO date_objet (pk_date_objet, date_iso, fk_type_date_param, libelle_original_date, notes, descriptif, fk_objet, date_creation, date_modification, certitude) VALUES (503, '1667', 25, NULL, NULL, NULL, 1610, '2015-11-06 18:13:56.804955+01', NULL, ' ');
INSERT INTO date_objet (pk_date_objet, date_iso, fk_type_date_param, libelle_original_date, notes, descriptif, fk_objet, date_creation, date_modification, certitude) VALUES (504, '1667', 25, NULL, NULL, NULL, 1099, '2015-11-06 18:13:56.804955+01', NULL, ' ');
INSERT INTO date_objet (pk_date_objet, date_iso, fk_type_date_param, libelle_original_date, notes, descriptif, fk_objet, date_creation, date_modification, certitude) VALUES (505, '1669', 25, NULL, NULL, NULL, 1600, '2015-11-06 18:13:56.804955+01', NULL, ' ');
INSERT INTO date_objet (pk_date_objet, date_iso, fk_type_date_param, libelle_original_date, notes, descriptif, fk_objet, date_creation, date_modification, certitude) VALUES (506, '1669', 25, NULL, NULL, NULL, 955, '2015-11-06 18:13:56.804955+01', NULL, ' ');
INSERT INTO date_objet (pk_date_objet, date_iso, fk_type_date_param, libelle_original_date, notes, descriptif, fk_objet, date_creation, date_modification, certitude) VALUES (507, '1670', 25, NULL, NULL, NULL, 1408, '2015-11-06 18:13:56.804955+01', NULL, ' ');
INSERT INTO date_objet (pk_date_objet, date_iso, fk_type_date_param, libelle_original_date, notes, descriptif, fk_objet, date_creation, date_modification, certitude) VALUES (508, '1671', 25, NULL, NULL, NULL, 1056, '2015-11-06 18:13:56.804955+01', NULL, ' ');
INSERT INTO date_objet (pk_date_objet, date_iso, fk_type_date_param, libelle_original_date, notes, descriptif, fk_objet, date_creation, date_modification, certitude) VALUES (509, '1671', 25, NULL, NULL, NULL, 1297, '2015-11-06 18:13:56.804955+01', NULL, ' ');
INSERT INTO date_objet (pk_date_objet, date_iso, fk_type_date_param, libelle_original_date, notes, descriptif, fk_objet, date_creation, date_modification, certitude) VALUES (511, '1671', 25, NULL, NULL, NULL, 1116, '2015-11-06 18:13:56.804955+01', NULL, ' ');
INSERT INTO date_objet (pk_date_objet, date_iso, fk_type_date_param, libelle_original_date, notes, descriptif, fk_objet, date_creation, date_modification, certitude) VALUES (512, '1671', 25, NULL, NULL, NULL, 1527, '2015-11-06 18:13:56.804955+01', NULL, ' ');
INSERT INTO date_objet (pk_date_objet, date_iso, fk_type_date_param, libelle_original_date, notes, descriptif, fk_objet, date_creation, date_modification, certitude) VALUES (513, '1671', 25, NULL, NULL, NULL, 940, '2015-11-06 18:13:56.804955+01', NULL, ' ');
INSERT INTO date_objet (pk_date_objet, date_iso, fk_type_date_param, libelle_original_date, notes, descriptif, fk_objet, date_creation, date_modification, certitude) VALUES (514, '1672', 25, NULL, NULL, NULL, 950, '2015-11-06 18:13:56.804955+01', NULL, ' ');
INSERT INTO date_objet (pk_date_objet, date_iso, fk_type_date_param, libelle_original_date, notes, descriptif, fk_objet, date_creation, date_modification, certitude) VALUES (515, '1672', 25, NULL, NULL, NULL, 879, '2015-11-06 18:13:56.804955+01', NULL, ' ');
INSERT INTO date_objet (pk_date_objet, date_iso, fk_type_date_param, libelle_original_date, notes, descriptif, fk_objet, date_creation, date_modification, certitude) VALUES (516, '1674', 25, NULL, NULL, NULL, 898, '2015-11-06 18:13:56.804955+01', NULL, ' ');
INSERT INTO date_objet (pk_date_objet, date_iso, fk_type_date_param, libelle_original_date, notes, descriptif, fk_objet, date_creation, date_modification, certitude) VALUES (517, '1675', 25, NULL, NULL, NULL, 1011, '2015-11-06 18:13:56.804955+01', NULL, ' ');
INSERT INTO date_objet (pk_date_objet, date_iso, fk_type_date_param, libelle_original_date, notes, descriptif, fk_objet, date_creation, date_modification, certitude) VALUES (518, '1675', 25, NULL, NULL, NULL, 1277, '2015-11-06 18:13:56.804955+01', NULL, ' ');
INSERT INTO date_objet (pk_date_objet, date_iso, fk_type_date_param, libelle_original_date, notes, descriptif, fk_objet, date_creation, date_modification, certitude) VALUES (519, '1676', 25, NULL, NULL, NULL, 1569, '2015-11-06 18:13:56.804955+01', NULL, ' ');
INSERT INTO date_objet (pk_date_objet, date_iso, fk_type_date_param, libelle_original_date, notes, descriptif, fk_objet, date_creation, date_modification, certitude) VALUES (520, '1677', 25, NULL, NULL, NULL, 1487, '2015-11-06 18:13:56.804955+01', NULL, ' ');
INSERT INTO date_objet (pk_date_objet, date_iso, fk_type_date_param, libelle_original_date, notes, descriptif, fk_objet, date_creation, date_modification, certitude) VALUES (521, '1735', 25, NULL, NULL, NULL, 1243, '2015-11-06 18:13:56.804955+01', NULL, ' ');
INSERT INTO date_objet (pk_date_objet, date_iso, fk_type_date_param, libelle_original_date, notes, descriptif, fk_objet, date_creation, date_modification, certitude) VALUES (522, '1677', 25, NULL, NULL, NULL, 1546, '2015-11-06 18:13:56.804955+01', NULL, ' ');
INSERT INTO date_objet (pk_date_objet, date_iso, fk_type_date_param, libelle_original_date, notes, descriptif, fk_objet, date_creation, date_modification, certitude) VALUES (523, '1677', 25, NULL, NULL, NULL, 1512, '2015-11-06 18:13:56.804955+01', NULL, ' ');
INSERT INTO date_objet (pk_date_objet, date_iso, fk_type_date_param, libelle_original_date, notes, descriptif, fk_objet, date_creation, date_modification, certitude) VALUES (524, '1678', 25, NULL, NULL, NULL, 838, '2015-11-06 18:13:56.804955+01', NULL, ' ');
INSERT INTO date_objet (pk_date_objet, date_iso, fk_type_date_param, libelle_original_date, notes, descriptif, fk_objet, date_creation, date_modification, certitude) VALUES (525, '1678', 25, NULL, NULL, NULL, 1422, '2015-11-06 18:13:56.804955+01', NULL, ' ');
INSERT INTO date_objet (pk_date_objet, date_iso, fk_type_date_param, libelle_original_date, notes, descriptif, fk_objet, date_creation, date_modification, certitude) VALUES (526, '1678', 25, NULL, NULL, NULL, 875, '2015-11-06 18:13:56.804955+01', NULL, ' ');
INSERT INTO date_objet (pk_date_objet, date_iso, fk_type_date_param, libelle_original_date, notes, descriptif, fk_objet, date_creation, date_modification, certitude) VALUES (527, '1678', 25, NULL, NULL, NULL, 1472, '2015-11-06 18:13:56.804955+01', NULL, ' ');
INSERT INTO date_objet (pk_date_objet, date_iso, fk_type_date_param, libelle_original_date, notes, descriptif, fk_objet, date_creation, date_modification, certitude) VALUES (528, '1678', 25, NULL, NULL, NULL, 1329, '2015-11-06 18:13:56.804955+01', NULL, ' ');
INSERT INTO date_objet (pk_date_objet, date_iso, fk_type_date_param, libelle_original_date, notes, descriptif, fk_objet, date_creation, date_modification, certitude) VALUES (529, '1679', 25, NULL, NULL, NULL, 1209, '2015-11-06 18:13:56.804955+01', NULL, ' ');
INSERT INTO date_objet (pk_date_objet, date_iso, fk_type_date_param, libelle_original_date, notes, descriptif, fk_objet, date_creation, date_modification, certitude) VALUES (530, '1679', 25, NULL, NULL, NULL, 932, '2015-11-06 18:13:56.804955+01', NULL, ' ');
INSERT INTO date_objet (pk_date_objet, date_iso, fk_type_date_param, libelle_original_date, notes, descriptif, fk_objet, date_creation, date_modification, certitude) VALUES (531, '1679', 25, NULL, NULL, NULL, 1138, '2015-11-06 18:13:56.804955+01', NULL, ' ');
INSERT INTO date_objet (pk_date_objet, date_iso, fk_type_date_param, libelle_original_date, notes, descriptif, fk_objet, date_creation, date_modification, certitude) VALUES (532, '1680', 25, NULL, NULL, NULL, 1068, '2015-11-06 18:13:56.804955+01', NULL, ' ');
INSERT INTO date_objet (pk_date_objet, date_iso, fk_type_date_param, libelle_original_date, notes, descriptif, fk_objet, date_creation, date_modification, certitude) VALUES (533, '1680', 25, NULL, NULL, NULL, 1253, '2015-11-06 18:13:56.804955+01', NULL, ' ');
INSERT INTO date_objet (pk_date_objet, date_iso, fk_type_date_param, libelle_original_date, notes, descriptif, fk_objet, date_creation, date_modification, certitude) VALUES (534, '1681', 25, NULL, NULL, NULL, 1023, '2015-11-06 18:13:56.804955+01', NULL, ' ');
INSERT INTO date_objet (pk_date_objet, date_iso, fk_type_date_param, libelle_original_date, notes, descriptif, fk_objet, date_creation, date_modification, certitude) VALUES (535, '1682', 25, NULL, NULL, NULL, 1407, '2015-11-06 18:13:56.804955+01', NULL, ' ');
INSERT INTO date_objet (pk_date_objet, date_iso, fk_type_date_param, libelle_original_date, notes, descriptif, fk_objet, date_creation, date_modification, certitude) VALUES (536, '1683', 25, NULL, NULL, NULL, 1206, '2015-11-06 18:13:56.804955+01', NULL, ' ');
INSERT INTO date_objet (pk_date_objet, date_iso, fk_type_date_param, libelle_original_date, notes, descriptif, fk_objet, date_creation, date_modification, certitude) VALUES (537, '1684', 25, NULL, NULL, NULL, 1225, '2015-11-06 18:13:56.804955+01', NULL, ' ');
INSERT INTO date_objet (pk_date_objet, date_iso, fk_type_date_param, libelle_original_date, notes, descriptif, fk_objet, date_creation, date_modification, certitude) VALUES (538, '1685', 25, NULL, NULL, NULL, 863, '2015-11-06 18:13:56.804955+01', NULL, ' ');
INSERT INTO date_objet (pk_date_objet, date_iso, fk_type_date_param, libelle_original_date, notes, descriptif, fk_objet, date_creation, date_modification, certitude) VALUES (539, '1685', 25, NULL, NULL, NULL, 1227, '2015-11-06 18:13:56.804955+01', NULL, ' ');
INSERT INTO date_objet (pk_date_objet, date_iso, fk_type_date_param, libelle_original_date, notes, descriptif, fk_objet, date_creation, date_modification, certitude) VALUES (540, '1685', 25, NULL, NULL, NULL, 1444, '2015-11-06 18:13:56.804955+01', NULL, ' ');
INSERT INTO date_objet (pk_date_objet, date_iso, fk_type_date_param, libelle_original_date, notes, descriptif, fk_objet, date_creation, date_modification, certitude) VALUES (541, '1686', 25, NULL, NULL, NULL, 1251, '2015-11-06 18:13:56.804955+01', NULL, ' ');
INSERT INTO date_objet (pk_date_objet, date_iso, fk_type_date_param, libelle_original_date, notes, descriptif, fk_objet, date_creation, date_modification, certitude) VALUES (542, '1687', 25, NULL, NULL, NULL, 1034, '2015-11-06 18:13:56.804955+01', NULL, ' ');
INSERT INTO date_objet (pk_date_objet, date_iso, fk_type_date_param, libelle_original_date, notes, descriptif, fk_objet, date_creation, date_modification, certitude) VALUES (543, '1687', 25, NULL, NULL, NULL, 1503, '2015-11-06 18:13:56.804955+01', NULL, ' ');
INSERT INTO date_objet (pk_date_objet, date_iso, fk_type_date_param, libelle_original_date, notes, descriptif, fk_objet, date_creation, date_modification, certitude) VALUES (544, '1703', 25, NULL, NULL, NULL, 1199, '2015-11-06 18:13:56.804955+01', NULL, ' ');
INSERT INTO date_objet (pk_date_objet, date_iso, fk_type_date_param, libelle_original_date, notes, descriptif, fk_objet, date_creation, date_modification, certitude) VALUES (545, '1688', 25, NULL, NULL, NULL, 884, '2015-11-06 18:13:56.804955+01', NULL, ' ');
INSERT INTO date_objet (pk_date_objet, date_iso, fk_type_date_param, libelle_original_date, notes, descriptif, fk_objet, date_creation, date_modification, certitude) VALUES (546, '1688', 25, NULL, NULL, NULL, 1228, '2015-11-06 18:13:56.804955+01', NULL, ' ');
INSERT INTO date_objet (pk_date_objet, date_iso, fk_type_date_param, libelle_original_date, notes, descriptif, fk_objet, date_creation, date_modification, certitude) VALUES (547, '1688', 25, NULL, NULL, NULL, 1198, '2015-11-06 18:13:56.804955+01', NULL, ' ');
INSERT INTO date_objet (pk_date_objet, date_iso, fk_type_date_param, libelle_original_date, notes, descriptif, fk_objet, date_creation, date_modification, certitude) VALUES (548, '1688', 25, NULL, NULL, NULL, 829, '2015-11-06 18:13:56.804955+01', NULL, ' ');
INSERT INTO date_objet (pk_date_objet, date_iso, fk_type_date_param, libelle_original_date, notes, descriptif, fk_objet, date_creation, date_modification, certitude) VALUES (549, '1689', 25, NULL, NULL, NULL, 972, '2015-11-06 18:13:56.804955+01', NULL, ' ');
INSERT INTO date_objet (pk_date_objet, date_iso, fk_type_date_param, libelle_original_date, notes, descriptif, fk_objet, date_creation, date_modification, certitude) VALUES (550, '1689', 25, NULL, NULL, NULL, 1479, '2015-11-06 18:13:56.804955+01', NULL, ' ');
INSERT INTO date_objet (pk_date_objet, date_iso, fk_type_date_param, libelle_original_date, notes, descriptif, fk_objet, date_creation, date_modification, certitude) VALUES (551, '1689', 25, NULL, NULL, NULL, 1195, '2015-11-06 18:13:56.804955+01', NULL, ' ');
INSERT INTO date_objet (pk_date_objet, date_iso, fk_type_date_param, libelle_original_date, notes, descriptif, fk_objet, date_creation, date_modification, certitude) VALUES (552, '1690', 25, NULL, NULL, NULL, 1261, '2015-11-06 18:13:56.804955+01', NULL, ' ');
INSERT INTO date_objet (pk_date_objet, date_iso, fk_type_date_param, libelle_original_date, notes, descriptif, fk_objet, date_creation, date_modification, certitude) VALUES (553, '1691', 25, NULL, NULL, NULL, 1433, '2015-11-06 18:13:56.804955+01', NULL, ' ');
INSERT INTO date_objet (pk_date_objet, date_iso, fk_type_date_param, libelle_original_date, notes, descriptif, fk_objet, date_creation, date_modification, certitude) VALUES (554, '1692', 25, NULL, NULL, NULL, 1117, '2015-11-06 18:13:56.804955+01', NULL, ' ');
INSERT INTO date_objet (pk_date_objet, date_iso, fk_type_date_param, libelle_original_date, notes, descriptif, fk_objet, date_creation, date_modification, certitude) VALUES (555, '1692', 25, NULL, NULL, NULL, 913, '2015-11-06 18:13:56.804955+01', NULL, ' ');
INSERT INTO date_objet (pk_date_objet, date_iso, fk_type_date_param, libelle_original_date, notes, descriptif, fk_objet, date_creation, date_modification, certitude) VALUES (556, '1693', 25, NULL, NULL, NULL, 1558, '2015-11-06 18:13:56.804955+01', NULL, ' ');
INSERT INTO date_objet (pk_date_objet, date_iso, fk_type_date_param, libelle_original_date, notes, descriptif, fk_objet, date_creation, date_modification, certitude) VALUES (557, '1693', 25, NULL, NULL, NULL, 916, '2015-11-06 18:13:56.804955+01', NULL, ' ');
INSERT INTO date_objet (pk_date_objet, date_iso, fk_type_date_param, libelle_original_date, notes, descriptif, fk_objet, date_creation, date_modification, certitude) VALUES (558, '1694', 25, NULL, NULL, NULL, 1226, '2015-11-06 18:13:56.804955+01', NULL, ' ');
INSERT INTO date_objet (pk_date_objet, date_iso, fk_type_date_param, libelle_original_date, notes, descriptif, fk_objet, date_creation, date_modification, certitude) VALUES (559, '1697', 25, NULL, NULL, NULL, 880, '2015-11-06 18:13:56.804955+01', NULL, ' ');
INSERT INTO date_objet (pk_date_objet, date_iso, fk_type_date_param, libelle_original_date, notes, descriptif, fk_objet, date_creation, date_modification, certitude) VALUES (560, '1698', 25, NULL, NULL, NULL, 1495, '2015-11-06 18:13:56.804955+01', NULL, ' ');
INSERT INTO date_objet (pk_date_objet, date_iso, fk_type_date_param, libelle_original_date, notes, descriptif, fk_objet, date_creation, date_modification, certitude) VALUES (561, '1698', 25, NULL, NULL, NULL, 1492, '2015-11-06 18:13:56.804955+01', NULL, ' ');
INSERT INTO date_objet (pk_date_objet, date_iso, fk_type_date_param, libelle_original_date, notes, descriptif, fk_objet, date_creation, date_modification, certitude) VALUES (562, '1698', 25, NULL, NULL, NULL, 1305, '2015-11-06 18:13:56.804955+01', NULL, ' ');
INSERT INTO date_objet (pk_date_objet, date_iso, fk_type_date_param, libelle_original_date, notes, descriptif, fk_objet, date_creation, date_modification, certitude) VALUES (563, '1699', 25, NULL, NULL, NULL, 1367, '2015-11-06 18:13:56.804955+01', NULL, ' ');
INSERT INTO date_objet (pk_date_objet, date_iso, fk_type_date_param, libelle_original_date, notes, descriptif, fk_objet, date_creation, date_modification, certitude) VALUES (564, '1699', 25, NULL, NULL, NULL, 903, '2015-11-06 18:13:56.804955+01', NULL, ' ');
INSERT INTO date_objet (pk_date_objet, date_iso, fk_type_date_param, libelle_original_date, notes, descriptif, fk_objet, date_creation, date_modification, certitude) VALUES (565, '1700', 25, NULL, NULL, NULL, 1494, '2015-11-06 18:13:56.804955+01', NULL, ' ');
INSERT INTO date_objet (pk_date_objet, date_iso, fk_type_date_param, libelle_original_date, notes, descriptif, fk_objet, date_creation, date_modification, certitude) VALUES (566, '1700', 25, NULL, NULL, NULL, 1434, '2015-11-06 18:13:56.804955+01', NULL, ' ');
INSERT INTO date_objet (pk_date_objet, date_iso, fk_type_date_param, libelle_original_date, notes, descriptif, fk_objet, date_creation, date_modification, certitude) VALUES (567, '1701', 25, NULL, NULL, NULL, 1146, '2015-11-06 18:13:56.804955+01', NULL, ' ');
INSERT INTO date_objet (pk_date_objet, date_iso, fk_type_date_param, libelle_original_date, notes, descriptif, fk_objet, date_creation, date_modification, certitude) VALUES (568, '1701', 25, NULL, NULL, NULL, 922, '2015-11-06 18:13:56.804955+01', NULL, ' ');
INSERT INTO date_objet (pk_date_objet, date_iso, fk_type_date_param, libelle_original_date, notes, descriptif, fk_objet, date_creation, date_modification, certitude) VALUES (569, '1701', 25, NULL, NULL, NULL, 978, '2015-11-06 18:13:56.804955+01', NULL, ' ');
INSERT INTO date_objet (pk_date_objet, date_iso, fk_type_date_param, libelle_original_date, notes, descriptif, fk_objet, date_creation, date_modification, certitude) VALUES (570, '1701', 25, NULL, NULL, NULL, 836, '2015-11-06 18:13:56.804955+01', NULL, ' ');
INSERT INTO date_objet (pk_date_objet, date_iso, fk_type_date_param, libelle_original_date, notes, descriptif, fk_objet, date_creation, date_modification, certitude) VALUES (571, '1701', 25, NULL, NULL, NULL, 1233, '2015-11-06 18:13:56.804955+01', NULL, ' ');
INSERT INTO date_objet (pk_date_objet, date_iso, fk_type_date_param, libelle_original_date, notes, descriptif, fk_objet, date_creation, date_modification, certitude) VALUES (572, '1702', 25, NULL, NULL, NULL, 1564, '2015-11-06 18:13:56.804955+01', NULL, ' ');
INSERT INTO date_objet (pk_date_objet, date_iso, fk_type_date_param, libelle_original_date, notes, descriptif, fk_objet, date_creation, date_modification, certitude) VALUES (573, '1703', 25, NULL, NULL, NULL, 1316, '2015-11-06 18:13:56.804955+01', NULL, ' ');
INSERT INTO date_objet (pk_date_objet, date_iso, fk_type_date_param, libelle_original_date, notes, descriptif, fk_objet, date_creation, date_modification, certitude) VALUES (574, '1703', 25, NULL, NULL, NULL, 1435, '2015-11-06 18:13:56.804955+01', NULL, ' ');
INSERT INTO date_objet (pk_date_objet, date_iso, fk_type_date_param, libelle_original_date, notes, descriptif, fk_objet, date_creation, date_modification, certitude) VALUES (575, '1704', 25, NULL, NULL, NULL, 1039, '2015-11-06 18:13:56.804955+01', NULL, ' ');
INSERT INTO date_objet (pk_date_objet, date_iso, fk_type_date_param, libelle_original_date, notes, descriptif, fk_objet, date_creation, date_modification, certitude) VALUES (576, '1704', 25, NULL, NULL, NULL, 1001, '2015-11-06 18:13:56.804955+01', NULL, ' ');
INSERT INTO date_objet (pk_date_objet, date_iso, fk_type_date_param, libelle_original_date, notes, descriptif, fk_objet, date_creation, date_modification, certitude) VALUES (577, '1704', 25, NULL, NULL, NULL, 1537, '2015-11-06 18:13:56.804955+01', NULL, ' ');
INSERT INTO date_objet (pk_date_objet, date_iso, fk_type_date_param, libelle_original_date, notes, descriptif, fk_objet, date_creation, date_modification, certitude) VALUES (578, '1704', 25, NULL, NULL, NULL, 996, '2015-11-06 18:13:56.804955+01', NULL, ' ');
INSERT INTO date_objet (pk_date_objet, date_iso, fk_type_date_param, libelle_original_date, notes, descriptif, fk_objet, date_creation, date_modification, certitude) VALUES (579, '1704', 25, NULL, NULL, NULL, 1030, '2015-11-06 18:13:56.804955+01', NULL, ' ');
INSERT INTO date_objet (pk_date_objet, date_iso, fk_type_date_param, libelle_original_date, notes, descriptif, fk_objet, date_creation, date_modification, certitude) VALUES (580, '1704', 25, NULL, NULL, NULL, 1200, '2015-11-06 18:13:56.804955+01', NULL, ' ');
INSERT INTO date_objet (pk_date_objet, date_iso, fk_type_date_param, libelle_original_date, notes, descriptif, fk_objet, date_creation, date_modification, certitude) VALUES (581, '1705', 25, NULL, NULL, NULL, 1014, '2015-11-06 18:13:56.804955+01', NULL, ' ');
INSERT INTO date_objet (pk_date_objet, date_iso, fk_type_date_param, libelle_original_date, notes, descriptif, fk_objet, date_creation, date_modification, certitude) VALUES (582, '1706', 25, NULL, NULL, NULL, 876, '2015-11-06 18:13:56.804955+01', NULL, ' ');
INSERT INTO date_objet (pk_date_objet, date_iso, fk_type_date_param, libelle_original_date, notes, descriptif, fk_objet, date_creation, date_modification, certitude) VALUES (583, '1706', 25, NULL, NULL, NULL, 1501, '2015-11-06 18:13:56.804955+01', NULL, ' ');
INSERT INTO date_objet (pk_date_objet, date_iso, fk_type_date_param, libelle_original_date, notes, descriptif, fk_objet, date_creation, date_modification, certitude) VALUES (584, '1706', 25, NULL, NULL, NULL, 1562, '2015-11-06 18:13:56.804955+01', NULL, ' ');
INSERT INTO date_objet (pk_date_objet, date_iso, fk_type_date_param, libelle_original_date, notes, descriptif, fk_objet, date_creation, date_modification, certitude) VALUES (585, '1707', 25, NULL, NULL, NULL, 1585, '2015-11-06 18:13:56.804955+01', NULL, ' ');
INSERT INTO date_objet (pk_date_objet, date_iso, fk_type_date_param, libelle_original_date, notes, descriptif, fk_objet, date_creation, date_modification, certitude) VALUES (586, '1707', 25, NULL, NULL, NULL, 1571, '2015-11-06 18:13:56.804955+01', NULL, ' ');
INSERT INTO date_objet (pk_date_objet, date_iso, fk_type_date_param, libelle_original_date, notes, descriptif, fk_objet, date_creation, date_modification, certitude) VALUES (587, '1707', 25, NULL, NULL, NULL, 1403, '2015-11-06 18:13:56.804955+01', NULL, ' ');
INSERT INTO date_objet (pk_date_objet, date_iso, fk_type_date_param, libelle_original_date, notes, descriptif, fk_objet, date_creation, date_modification, certitude) VALUES (588, '1707', 25, NULL, NULL, NULL, 1186, '2015-11-06 18:13:56.804955+01', NULL, ' ');
INSERT INTO date_objet (pk_date_objet, date_iso, fk_type_date_param, libelle_original_date, notes, descriptif, fk_objet, date_creation, date_modification, certitude) VALUES (589, '1708', 25, NULL, NULL, NULL, 870, '2015-11-06 18:13:56.804955+01', NULL, ' ');
INSERT INTO date_objet (pk_date_objet, date_iso, fk_type_date_param, libelle_original_date, notes, descriptif, fk_objet, date_creation, date_modification, certitude) VALUES (590, '1709', 25, NULL, NULL, NULL, 1236, '2015-11-06 18:13:56.804955+01', NULL, ' ');
INSERT INTO date_objet (pk_date_objet, date_iso, fk_type_date_param, libelle_original_date, notes, descriptif, fk_objet, date_creation, date_modification, certitude) VALUES (591, '1709', 25, NULL, NULL, NULL, 985, '2015-11-06 18:13:56.804955+01', NULL, ' ');
INSERT INTO date_objet (pk_date_objet, date_iso, fk_type_date_param, libelle_original_date, notes, descriptif, fk_objet, date_creation, date_modification, certitude) VALUES (592, '1710', 25, NULL, NULL, NULL, 832, '2015-11-06 18:13:56.804955+01', NULL, ' ');
INSERT INTO date_objet (pk_date_objet, date_iso, fk_type_date_param, libelle_original_date, notes, descriptif, fk_objet, date_creation, date_modification, certitude) VALUES (593, '1710', 25, NULL, NULL, NULL, 990, '2015-11-06 18:13:56.804955+01', NULL, ' ');
INSERT INTO date_objet (pk_date_objet, date_iso, fk_type_date_param, libelle_original_date, notes, descriptif, fk_objet, date_creation, date_modification, certitude) VALUES (594, '1710', 25, NULL, NULL, NULL, 1452, '2015-11-06 18:13:56.804955+01', NULL, ' ');
INSERT INTO date_objet (pk_date_objet, date_iso, fk_type_date_param, libelle_original_date, notes, descriptif, fk_objet, date_creation, date_modification, certitude) VALUES (595, '1710', 25, NULL, NULL, NULL, 1616, '2015-11-06 18:13:56.804955+01', NULL, ' ');
INSERT INTO date_objet (pk_date_objet, date_iso, fk_type_date_param, libelle_original_date, notes, descriptif, fk_objet, date_creation, date_modification, certitude) VALUES (596, '1711', 25, NULL, NULL, NULL, 1104, '2015-11-06 18:13:56.804955+01', NULL, ' ');
INSERT INTO date_objet (pk_date_objet, date_iso, fk_type_date_param, libelle_original_date, notes, descriptif, fk_objet, date_creation, date_modification, certitude) VALUES (597, '1711', 25, NULL, NULL, NULL, 837, '2015-11-06 18:13:56.804955+01', NULL, ' ');
INSERT INTO date_objet (pk_date_objet, date_iso, fk_type_date_param, libelle_original_date, notes, descriptif, fk_objet, date_creation, date_modification, certitude) VALUES (598, '1711', 25, NULL, NULL, NULL, 968, '2015-11-06 18:13:56.804955+01', NULL, ' ');
INSERT INTO date_objet (pk_date_objet, date_iso, fk_type_date_param, libelle_original_date, notes, descriptif, fk_objet, date_creation, date_modification, certitude) VALUES (599, '1711', 25, NULL, NULL, NULL, 1582, '2015-11-06 18:13:56.804955+01', NULL, ' ');
INSERT INTO date_objet (pk_date_objet, date_iso, fk_type_date_param, libelle_original_date, notes, descriptif, fk_objet, date_creation, date_modification, certitude) VALUES (600, '1711', 25, NULL, NULL, NULL, 935, '2015-11-06 18:13:56.804955+01', NULL, ' ');
INSERT INTO date_objet (pk_date_objet, date_iso, fk_type_date_param, libelle_original_date, notes, descriptif, fk_objet, date_creation, date_modification, certitude) VALUES (601, '1711', 25, NULL, NULL, NULL, 1388, '2015-11-06 18:13:56.804955+01', NULL, ' ');
INSERT INTO date_objet (pk_date_objet, date_iso, fk_type_date_param, libelle_original_date, notes, descriptif, fk_objet, date_creation, date_modification, certitude) VALUES (602, '1712', 25, NULL, NULL, NULL, 1135, '2015-11-06 18:13:56.804955+01', NULL, ' ');
INSERT INTO date_objet (pk_date_objet, date_iso, fk_type_date_param, libelle_original_date, notes, descriptif, fk_objet, date_creation, date_modification, certitude) VALUES (603, '1712', 25, NULL, NULL, NULL, 1102, '2015-11-06 18:13:56.804955+01', NULL, ' ');
INSERT INTO date_objet (pk_date_objet, date_iso, fk_type_date_param, libelle_original_date, notes, descriptif, fk_objet, date_creation, date_modification, certitude) VALUES (604, '1713', 25, NULL, NULL, NULL, 918, '2015-11-06 18:13:56.804955+01', NULL, ' ');
INSERT INTO date_objet (pk_date_objet, date_iso, fk_type_date_param, libelle_original_date, notes, descriptif, fk_objet, date_creation, date_modification, certitude) VALUES (605, '1713', 25, NULL, NULL, NULL, 844, '2015-11-06 18:13:56.804955+01', NULL, ' ');
INSERT INTO date_objet (pk_date_objet, date_iso, fk_type_date_param, libelle_original_date, notes, descriptif, fk_objet, date_creation, date_modification, certitude) VALUES (606, '1713', 25, NULL, NULL, NULL, 1591, '2015-11-06 18:13:56.804955+01', NULL, ' ');
INSERT INTO date_objet (pk_date_objet, date_iso, fk_type_date_param, libelle_original_date, notes, descriptif, fk_objet, date_creation, date_modification, certitude) VALUES (607, '1714', 25, NULL, NULL, NULL, 1554, '2015-11-06 18:13:56.804955+01', NULL, ' ');
INSERT INTO date_objet (pk_date_objet, date_iso, fk_type_date_param, libelle_original_date, notes, descriptif, fk_objet, date_creation, date_modification, certitude) VALUES (608, '1724', 25, NULL, NULL, NULL, 1533, '2015-11-06 18:13:56.804955+01', NULL, ' ');
INSERT INTO date_objet (pk_date_objet, date_iso, fk_type_date_param, libelle_original_date, notes, descriptif, fk_objet, date_creation, date_modification, certitude) VALUES (609, '1714', 25, NULL, NULL, NULL, 1159, '2015-11-06 18:13:56.804955+01', NULL, ' ');
INSERT INTO date_objet (pk_date_objet, date_iso, fk_type_date_param, libelle_original_date, notes, descriptif, fk_objet, date_creation, date_modification, certitude) VALUES (610, '1714', 25, NULL, NULL, NULL, 1349, '2015-11-06 18:13:56.804955+01', NULL, ' ');
INSERT INTO date_objet (pk_date_objet, date_iso, fk_type_date_param, libelle_original_date, notes, descriptif, fk_objet, date_creation, date_modification, certitude) VALUES (611, '1714', 25, NULL, NULL, NULL, 1611, '2015-11-06 18:13:56.804955+01', NULL, ' ');
INSERT INTO date_objet (pk_date_objet, date_iso, fk_type_date_param, libelle_original_date, notes, descriptif, fk_objet, date_creation, date_modification, certitude) VALUES (612, '1715', 25, NULL, NULL, NULL, 915, '2015-11-06 18:13:56.804955+01', NULL, ' ');
INSERT INTO date_objet (pk_date_objet, date_iso, fk_type_date_param, libelle_original_date, notes, descriptif, fk_objet, date_creation, date_modification, certitude) VALUES (613, '1715', 25, NULL, NULL, NULL, 962, '2015-11-06 18:13:56.804955+01', NULL, ' ');
INSERT INTO date_objet (pk_date_objet, date_iso, fk_type_date_param, libelle_original_date, notes, descriptif, fk_objet, date_creation, date_modification, certitude) VALUES (614, '1716', 25, NULL, NULL, NULL, 1617, '2015-11-06 18:13:56.804955+01', NULL, ' ');
INSERT INTO date_objet (pk_date_objet, date_iso, fk_type_date_param, libelle_original_date, notes, descriptif, fk_objet, date_creation, date_modification, certitude) VALUES (615, '1716', 25, NULL, NULL, NULL, 1160, '2015-11-06 18:13:56.804955+01', NULL, ' ');
INSERT INTO date_objet (pk_date_objet, date_iso, fk_type_date_param, libelle_original_date, notes, descriptif, fk_objet, date_creation, date_modification, certitude) VALUES (616, '1716', 25, NULL, NULL, NULL, 1483, '2015-11-06 18:13:56.804955+01', NULL, ' ');
INSERT INTO date_objet (pk_date_objet, date_iso, fk_type_date_param, libelle_original_date, notes, descriptif, fk_objet, date_creation, date_modification, certitude) VALUES (617, '1716', 25, NULL, NULL, NULL, 1549, '2015-11-06 18:13:56.804955+01', NULL, ' ');
INSERT INTO date_objet (pk_date_objet, date_iso, fk_type_date_param, libelle_original_date, notes, descriptif, fk_objet, date_creation, date_modification, certitude) VALUES (618, '1717', 25, NULL, NULL, NULL, 1394, '2015-11-06 18:13:56.804955+01', NULL, ' ');
INSERT INTO date_objet (pk_date_objet, date_iso, fk_type_date_param, libelle_original_date, notes, descriptif, fk_objet, date_creation, date_modification, certitude) VALUES (619, '1717', 25, NULL, NULL, NULL, 1179, '2015-11-06 18:13:56.804955+01', NULL, ' ');
INSERT INTO date_objet (pk_date_objet, date_iso, fk_type_date_param, libelle_original_date, notes, descriptif, fk_objet, date_creation, date_modification, certitude) VALUES (620, '1718', 25, NULL, NULL, NULL, 1525, '2015-11-06 18:13:56.804955+01', NULL, ' ');
INSERT INTO date_objet (pk_date_objet, date_iso, fk_type_date_param, libelle_original_date, notes, descriptif, fk_objet, date_creation, date_modification, certitude) VALUES (621, '1718', 25, NULL, NULL, NULL, 906, '2015-11-06 18:13:56.804955+01', NULL, ' ');
INSERT INTO date_objet (pk_date_objet, date_iso, fk_type_date_param, libelle_original_date, notes, descriptif, fk_objet, date_creation, date_modification, certitude) VALUES (622, '1718', 25, NULL, NULL, NULL, 1310, '2015-11-06 18:13:56.804955+01', NULL, ' ');
INSERT INTO date_objet (pk_date_objet, date_iso, fk_type_date_param, libelle_original_date, notes, descriptif, fk_objet, date_creation, date_modification, certitude) VALUES (623, '1718', 25, NULL, NULL, NULL, 1427, '2015-11-06 18:13:56.804955+01', NULL, ' ');
INSERT INTO date_objet (pk_date_objet, date_iso, fk_type_date_param, libelle_original_date, notes, descriptif, fk_objet, date_creation, date_modification, certitude) VALUES (624, '1718', 25, NULL, NULL, NULL, 1346, '2015-11-06 18:13:56.804955+01', NULL, ' ');
INSERT INTO date_objet (pk_date_objet, date_iso, fk_type_date_param, libelle_original_date, notes, descriptif, fk_objet, date_creation, date_modification, certitude) VALUES (625, '1718', 25, NULL, NULL, NULL, 1500, '2015-11-06 18:13:56.804955+01', NULL, ' ');
INSERT INTO date_objet (pk_date_objet, date_iso, fk_type_date_param, libelle_original_date, notes, descriptif, fk_objet, date_creation, date_modification, certitude) VALUES (626, '1718', 25, NULL, NULL, NULL, 1594, '2015-11-06 18:13:56.804955+01', NULL, ' ');
INSERT INTO date_objet (pk_date_objet, date_iso, fk_type_date_param, libelle_original_date, notes, descriptif, fk_objet, date_creation, date_modification, certitude) VALUES (627, '1719', 25, NULL, NULL, NULL, 1168, '2015-11-06 18:13:56.804955+01', NULL, ' ');
INSERT INTO date_objet (pk_date_objet, date_iso, fk_type_date_param, libelle_original_date, notes, descriptif, fk_objet, date_creation, date_modification, certitude) VALUES (628, '1719', 25, NULL, NULL, NULL, 1315, '2015-11-06 18:13:56.804955+01', NULL, ' ');
INSERT INTO date_objet (pk_date_objet, date_iso, fk_type_date_param, libelle_original_date, notes, descriptif, fk_objet, date_creation, date_modification, certitude) VALUES (629, '1720', 25, NULL, NULL, NULL, 1027, '2015-11-06 18:13:56.804955+01', NULL, ' ');
INSERT INTO date_objet (pk_date_objet, date_iso, fk_type_date_param, libelle_original_date, notes, descriptif, fk_objet, date_creation, date_modification, certitude) VALUES (630, '1722', 25, NULL, NULL, NULL, 868, '2015-11-06 18:13:56.804955+01', NULL, ' ');
INSERT INTO date_objet (pk_date_objet, date_iso, fk_type_date_param, libelle_original_date, notes, descriptif, fk_objet, date_creation, date_modification, certitude) VALUES (631, '1722', 25, NULL, NULL, NULL, 834, '2015-11-06 18:13:56.804955+01', NULL, ' ');
INSERT INTO date_objet (pk_date_objet, date_iso, fk_type_date_param, libelle_original_date, notes, descriptif, fk_objet, date_creation, date_modification, certitude) VALUES (632, '1722', 25, NULL, NULL, NULL, 1213, '2015-11-06 18:13:56.804955+01', NULL, ' ');
INSERT INTO date_objet (pk_date_objet, date_iso, fk_type_date_param, libelle_original_date, notes, descriptif, fk_objet, date_creation, date_modification, certitude) VALUES (633, '1722', 25, NULL, NULL, NULL, 1448, '2015-11-06 18:13:56.804955+01', NULL, ' ');
INSERT INTO date_objet (pk_date_objet, date_iso, fk_type_date_param, libelle_original_date, notes, descriptif, fk_objet, date_creation, date_modification, certitude) VALUES (634, '1723', 25, NULL, NULL, NULL, 881, '2015-11-06 18:13:56.804955+01', NULL, ' ');
INSERT INTO date_objet (pk_date_objet, date_iso, fk_type_date_param, libelle_original_date, notes, descriptif, fk_objet, date_creation, date_modification, certitude) VALUES (635, '1723', 25, NULL, NULL, NULL, 1163, '2015-11-06 18:13:56.804955+01', NULL, ' ');
INSERT INTO date_objet (pk_date_objet, date_iso, fk_type_date_param, libelle_original_date, notes, descriptif, fk_objet, date_creation, date_modification, certitude) VALUES (636, '1723', 25, NULL, NULL, NULL, 1541, '2015-11-06 18:13:56.804955+01', NULL, ' ');
INSERT INTO date_objet (pk_date_objet, date_iso, fk_type_date_param, libelle_original_date, notes, descriptif, fk_objet, date_creation, date_modification, certitude) VALUES (637, '1723', 25, NULL, NULL, NULL, 937, '2015-11-06 18:13:56.804955+01', NULL, ' ');
INSERT INTO date_objet (pk_date_objet, date_iso, fk_type_date_param, libelle_original_date, notes, descriptif, fk_objet, date_creation, date_modification, certitude) VALUES (638, '1723', 25, NULL, NULL, NULL, 1229, '2015-11-06 18:13:56.804955+01', NULL, ' ');
INSERT INTO date_objet (pk_date_objet, date_iso, fk_type_date_param, libelle_original_date, notes, descriptif, fk_objet, date_creation, date_modification, certitude) VALUES (639, '1723', 25, NULL, NULL, NULL, 1035, '2015-11-06 18:13:56.804955+01', NULL, ' ');
INSERT INTO date_objet (pk_date_objet, date_iso, fk_type_date_param, libelle_original_date, notes, descriptif, fk_objet, date_creation, date_modification, certitude) VALUES (640, '1723', 25, NULL, NULL, NULL, 967, '2015-11-06 18:13:56.804955+01', NULL, ' ');
INSERT INTO date_objet (pk_date_objet, date_iso, fk_type_date_param, libelle_original_date, notes, descriptif, fk_objet, date_creation, date_modification, certitude) VALUES (641, '1724', 25, NULL, NULL, NULL, 1505, '2015-11-06 18:13:56.804955+01', NULL, ' ');
INSERT INTO date_objet (pk_date_objet, date_iso, fk_type_date_param, libelle_original_date, notes, descriptif, fk_objet, date_creation, date_modification, certitude) VALUES (642, '1724', 25, NULL, NULL, NULL, 1568, '2015-11-06 18:13:56.804955+01', NULL, ' ');
INSERT INTO date_objet (pk_date_objet, date_iso, fk_type_date_param, libelle_original_date, notes, descriptif, fk_objet, date_creation, date_modification, certitude) VALUES (643, '1725', 25, NULL, NULL, NULL, 1328, '2015-11-06 18:13:56.804955+01', NULL, ' ');
INSERT INTO date_objet (pk_date_objet, date_iso, fk_type_date_param, libelle_original_date, notes, descriptif, fk_objet, date_creation, date_modification, certitude) VALUES (644, '1725', 25, NULL, NULL, NULL, 1344, '2015-11-06 18:13:56.804955+01', NULL, ' ');
INSERT INTO date_objet (pk_date_objet, date_iso, fk_type_date_param, libelle_original_date, notes, descriptif, fk_objet, date_creation, date_modification, certitude) VALUES (645, '1725', 25, NULL, NULL, NULL, 1517, '2015-11-06 18:13:56.804955+01', NULL, ' ');
INSERT INTO date_objet (pk_date_objet, date_iso, fk_type_date_param, libelle_original_date, notes, descriptif, fk_objet, date_creation, date_modification, certitude) VALUES (646, '1735', 25, NULL, NULL, NULL, 1006, '2015-11-06 18:13:56.804955+01', NULL, ' ');
INSERT INTO date_objet (pk_date_objet, date_iso, fk_type_date_param, libelle_original_date, notes, descriptif, fk_objet, date_creation, date_modification, certitude) VALUES (647, '1727', 25, NULL, NULL, NULL, 1325, '2015-11-06 18:13:56.804955+01', NULL, ' ');
INSERT INTO date_objet (pk_date_objet, date_iso, fk_type_date_param, libelle_original_date, notes, descriptif, fk_objet, date_creation, date_modification, certitude) VALUES (648, '1728', 25, NULL, NULL, NULL, 830, '2015-11-06 18:13:56.804955+01', NULL, ' ');
INSERT INTO date_objet (pk_date_objet, date_iso, fk_type_date_param, libelle_original_date, notes, descriptif, fk_objet, date_creation, date_modification, certitude) VALUES (649, '1728', 25, NULL, NULL, NULL, 1335, '2015-11-06 18:13:56.804955+01', NULL, ' ');
INSERT INTO date_objet (pk_date_objet, date_iso, fk_type_date_param, libelle_original_date, notes, descriptif, fk_objet, date_creation, date_modification, certitude) VALUES (650, '1728', 25, NULL, NULL, NULL, 1468, '2015-11-06 18:13:56.804955+01', NULL, ' ');
INSERT INTO date_objet (pk_date_objet, date_iso, fk_type_date_param, libelle_original_date, notes, descriptif, fk_objet, date_creation, date_modification, certitude) VALUES (651, '1728', 25, NULL, NULL, NULL, 1036, '2015-11-06 18:13:56.804955+01', NULL, ' ');
INSERT INTO date_objet (pk_date_objet, date_iso, fk_type_date_param, libelle_original_date, notes, descriptif, fk_objet, date_creation, date_modification, certitude) VALUES (652, '1729', 25, NULL, NULL, NULL, 952, '2015-11-06 18:13:56.804955+01', NULL, ' ');
INSERT INTO date_objet (pk_date_objet, date_iso, fk_type_date_param, libelle_original_date, notes, descriptif, fk_objet, date_creation, date_modification, certitude) VALUES (653, '1730', 25, NULL, NULL, NULL, 947, '2015-11-06 18:13:56.804955+01', NULL, ' ');
INSERT INTO date_objet (pk_date_objet, date_iso, fk_type_date_param, libelle_original_date, notes, descriptif, fk_objet, date_creation, date_modification, certitude) VALUES (654, '1730', 25, NULL, NULL, NULL, 1184, '2015-11-06 18:13:56.804955+01', NULL, ' ');
INSERT INTO date_objet (pk_date_objet, date_iso, fk_type_date_param, libelle_original_date, notes, descriptif, fk_objet, date_creation, date_modification, certitude) VALUES (655, '1730', 25, NULL, NULL, NULL, 1157, '2015-11-06 18:13:56.804955+01', NULL, ' ');
INSERT INTO date_objet (pk_date_objet, date_iso, fk_type_date_param, libelle_original_date, notes, descriptif, fk_objet, date_creation, date_modification, certitude) VALUES (656, '1730', 25, NULL, NULL, NULL, 1499, '2015-11-06 18:13:56.804955+01', NULL, ' ');
INSERT INTO date_objet (pk_date_objet, date_iso, fk_type_date_param, libelle_original_date, notes, descriptif, fk_objet, date_creation, date_modification, certitude) VALUES (657, '1730', 25, NULL, NULL, NULL, 1409, '2015-11-06 18:13:56.804955+01', NULL, ' ');
INSERT INTO date_objet (pk_date_objet, date_iso, fk_type_date_param, libelle_original_date, notes, descriptif, fk_objet, date_creation, date_modification, certitude) VALUES (658, '1730', 25, NULL, NULL, NULL, 1220, '2015-11-06 18:13:56.804955+01', NULL, ' ');
INSERT INTO date_objet (pk_date_objet, date_iso, fk_type_date_param, libelle_original_date, notes, descriptif, fk_objet, date_creation, date_modification, certitude) VALUES (659, '1730', 25, NULL, NULL, NULL, 1481, '2015-11-06 18:13:56.804955+01', NULL, ' ');
INSERT INTO date_objet (pk_date_objet, date_iso, fk_type_date_param, libelle_original_date, notes, descriptif, fk_objet, date_creation, date_modification, certitude) VALUES (660, '1731', 25, NULL, NULL, NULL, 1607, '2015-11-06 18:13:56.804955+01', NULL, ' ');
INSERT INTO date_objet (pk_date_objet, date_iso, fk_type_date_param, libelle_original_date, notes, descriptif, fk_objet, date_creation, date_modification, certitude) VALUES (661, '1731', 25, NULL, NULL, NULL, 896, '2015-11-06 18:13:56.804955+01', NULL, ' ');
INSERT INTO date_objet (pk_date_objet, date_iso, fk_type_date_param, libelle_original_date, notes, descriptif, fk_objet, date_creation, date_modification, certitude) VALUES (662, '1731', 25, NULL, NULL, NULL, 1416, '2015-11-06 18:13:56.804955+01', NULL, ' ');
INSERT INTO date_objet (pk_date_objet, date_iso, fk_type_date_param, libelle_original_date, notes, descriptif, fk_objet, date_creation, date_modification, certitude) VALUES (663, '1732', 25, NULL, NULL, NULL, 1046, '2015-11-06 18:13:56.804955+01', NULL, ' ');
INSERT INTO date_objet (pk_date_objet, date_iso, fk_type_date_param, libelle_original_date, notes, descriptif, fk_objet, date_creation, date_modification, certitude) VALUES (664, '1732', 25, NULL, NULL, NULL, 885, '2015-11-06 18:13:56.804955+01', NULL, ' ');
INSERT INTO date_objet (pk_date_objet, date_iso, fk_type_date_param, libelle_original_date, notes, descriptif, fk_objet, date_creation, date_modification, certitude) VALUES (665, '1732', 25, NULL, NULL, NULL, 1240, '2015-11-06 18:13:56.804955+01', NULL, ' ');
INSERT INTO date_objet (pk_date_objet, date_iso, fk_type_date_param, libelle_original_date, notes, descriptif, fk_objet, date_creation, date_modification, certitude) VALUES (666, '1732', 25, NULL, NULL, NULL, 1573, '2015-11-06 18:13:56.804955+01', NULL, ' ');
INSERT INTO date_objet (pk_date_objet, date_iso, fk_type_date_param, libelle_original_date, notes, descriptif, fk_objet, date_creation, date_modification, certitude) VALUES (667, '1733', 25, NULL, NULL, NULL, 1383, '2015-11-06 18:13:56.804955+01', NULL, ' ');
INSERT INTO date_objet (pk_date_objet, date_iso, fk_type_date_param, libelle_original_date, notes, descriptif, fk_objet, date_creation, date_modification, certitude) VALUES (668, '1733', 25, NULL, NULL, NULL, 1196, '2015-11-06 18:13:56.804955+01', NULL, ' ');
INSERT INTO date_objet (pk_date_objet, date_iso, fk_type_date_param, libelle_original_date, notes, descriptif, fk_objet, date_creation, date_modification, certitude) VALUES (669, '1733', 25, NULL, NULL, NULL, 1147, '2015-11-06 18:13:56.804955+01', NULL, ' ');
INSERT INTO date_objet (pk_date_objet, date_iso, fk_type_date_param, libelle_original_date, notes, descriptif, fk_objet, date_creation, date_modification, certitude) VALUES (670, '1733', 25, NULL, NULL, NULL, 1331, '2015-11-06 18:13:56.804955+01', NULL, ' ');
INSERT INTO date_objet (pk_date_objet, date_iso, fk_type_date_param, libelle_original_date, notes, descriptif, fk_objet, date_creation, date_modification, certitude) VALUES (671, '1734', 25, NULL, NULL, NULL, 1051, '2015-11-06 18:13:56.804955+01', NULL, ' ');
INSERT INTO date_objet (pk_date_objet, date_iso, fk_type_date_param, libelle_original_date, notes, descriptif, fk_objet, date_creation, date_modification, certitude) VALUES (672, '1734', 25, NULL, NULL, NULL, 1180, '2015-11-06 18:13:56.804955+01', NULL, ' ');
INSERT INTO date_objet (pk_date_objet, date_iso, fk_type_date_param, libelle_original_date, notes, descriptif, fk_objet, date_creation, date_modification, certitude) VALUES (673, '1734', 25, NULL, NULL, NULL, 1263, '2015-11-06 18:13:56.804955+01', NULL, ' ');
INSERT INTO date_objet (pk_date_objet, date_iso, fk_type_date_param, libelle_original_date, notes, descriptif, fk_objet, date_creation, date_modification, certitude) VALUES (674, '1734', 25, NULL, NULL, NULL, 1386, '2015-11-06 18:13:56.804955+01', NULL, ' ');
INSERT INTO date_objet (pk_date_objet, date_iso, fk_type_date_param, libelle_original_date, notes, descriptif, fk_objet, date_creation, date_modification, certitude) VALUES (675, '1736', 25, NULL, NULL, NULL, 1341, '2015-11-06 18:13:56.804955+01', NULL, ' ');
INSERT INTO date_objet (pk_date_objet, date_iso, fk_type_date_param, libelle_original_date, notes, descriptif, fk_objet, date_creation, date_modification, certitude) VALUES (676, '1736', 25, NULL, NULL, NULL, 1420, '2015-11-06 18:13:56.804955+01', NULL, ' ');
INSERT INTO date_objet (pk_date_objet, date_iso, fk_type_date_param, libelle_original_date, notes, descriptif, fk_objet, date_creation, date_modification, certitude) VALUES (677, '1736', 25, NULL, NULL, NULL, 1033, '2015-11-06 18:13:56.804955+01', NULL, ' ');
INSERT INTO date_objet (pk_date_objet, date_iso, fk_type_date_param, libelle_original_date, notes, descriptif, fk_objet, date_creation, date_modification, certitude) VALUES (678, '1736', 25, NULL, NULL, NULL, 998, '2015-11-06 18:13:56.804955+01', NULL, ' ');
INSERT INTO date_objet (pk_date_objet, date_iso, fk_type_date_param, libelle_original_date, notes, descriptif, fk_objet, date_creation, date_modification, certitude) VALUES (679, '1737', 25, NULL, NULL, NULL, 1071, '2015-11-06 18:13:56.804955+01', NULL, ' ');
INSERT INTO date_objet (pk_date_objet, date_iso, fk_type_date_param, libelle_original_date, notes, descriptif, fk_objet, date_creation, date_modification, certitude) VALUES (680, '1737', 25, NULL, NULL, NULL, 1476, '2015-11-06 18:13:56.804955+01', NULL, ' ');
INSERT INTO date_objet (pk_date_objet, date_iso, fk_type_date_param, libelle_original_date, notes, descriptif, fk_objet, date_creation, date_modification, certitude) VALUES (681, '1737', 25, NULL, NULL, NULL, 1515, '2015-11-06 18:13:56.804955+01', NULL, ' ');
INSERT INTO date_objet (pk_date_objet, date_iso, fk_type_date_param, libelle_original_date, notes, descriptif, fk_objet, date_creation, date_modification, certitude) VALUES (682, '1737', 25, NULL, NULL, NULL, 907, '2015-11-06 18:13:56.804955+01', NULL, ' ');
INSERT INTO date_objet (pk_date_objet, date_iso, fk_type_date_param, libelle_original_date, notes, descriptif, fk_objet, date_creation, date_modification, certitude) VALUES (683, '1738', 25, NULL, NULL, NULL, 1221, '2015-11-06 18:13:56.804955+01', NULL, ' ');
INSERT INTO date_objet (pk_date_objet, date_iso, fk_type_date_param, libelle_original_date, notes, descriptif, fk_objet, date_creation, date_modification, certitude) VALUES (684, '1738', 25, NULL, NULL, NULL, 858, '2015-11-06 18:13:56.804955+01', NULL, ' ');
INSERT INTO date_objet (pk_date_objet, date_iso, fk_type_date_param, libelle_original_date, notes, descriptif, fk_objet, date_creation, date_modification, certitude) VALUES (685, '1738', 25, NULL, NULL, NULL, 839, '2015-11-06 18:13:56.804955+01', NULL, ' ');
INSERT INTO date_objet (pk_date_objet, date_iso, fk_type_date_param, libelle_original_date, notes, descriptif, fk_objet, date_creation, date_modification, certitude) VALUES (686, '1738', 25, NULL, NULL, NULL, 1264, '2015-11-06 18:13:56.804955+01', NULL, ' ');
INSERT INTO date_objet (pk_date_objet, date_iso, fk_type_date_param, libelle_original_date, notes, descriptif, fk_objet, date_creation, date_modification, certitude) VALUES (687, '1738', 25, NULL, NULL, NULL, 1518, '2015-11-06 18:13:56.804955+01', NULL, ' ');
INSERT INTO date_objet (pk_date_objet, date_iso, fk_type_date_param, libelle_original_date, notes, descriptif, fk_objet, date_creation, date_modification, certitude) VALUES (688, '1739', 25, NULL, NULL, NULL, 1336, '2015-11-06 18:13:56.804955+01', NULL, ' ');
INSERT INTO date_objet (pk_date_objet, date_iso, fk_type_date_param, libelle_original_date, notes, descriptif, fk_objet, date_creation, date_modification, certitude) VALUES (689, '1739', 25, NULL, NULL, NULL, 1415, '2015-11-06 18:13:56.804955+01', NULL, ' ');
INSERT INTO date_objet (pk_date_objet, date_iso, fk_type_date_param, libelle_original_date, notes, descriptif, fk_objet, date_creation, date_modification, certitude) VALUES (690, '1739', 25, NULL, NULL, NULL, 1162, '2015-11-06 18:13:56.804955+01', NULL, ' ');
INSERT INTO date_objet (pk_date_objet, date_iso, fk_type_date_param, libelle_original_date, notes, descriptif, fk_objet, date_creation, date_modification, certitude) VALUES (691, '1739', 25, NULL, NULL, NULL, 1090, '2015-11-06 18:13:56.804955+01', NULL, ' ');
INSERT INTO date_objet (pk_date_objet, date_iso, fk_type_date_param, libelle_original_date, notes, descriptif, fk_objet, date_creation, date_modification, certitude) VALUES (692, '1740', 25, NULL, NULL, NULL, 1120, '2015-11-06 18:13:56.804955+01', NULL, ' ');
INSERT INTO date_objet (pk_date_objet, date_iso, fk_type_date_param, libelle_original_date, notes, descriptif, fk_objet, date_creation, date_modification, certitude) VALUES (693, '1740', 25, NULL, NULL, NULL, 986, '2015-11-06 18:13:56.804955+01', NULL, ' ');
INSERT INTO date_objet (pk_date_objet, date_iso, fk_type_date_param, libelle_original_date, notes, descriptif, fk_objet, date_creation, date_modification, certitude) VALUES (694, '1740', 25, NULL, NULL, NULL, 1133, '2015-11-06 18:13:56.804955+01', NULL, ' ');
INSERT INTO date_objet (pk_date_objet, date_iso, fk_type_date_param, libelle_original_date, notes, descriptif, fk_objet, date_creation, date_modification, certitude) VALUES (695, '1740', 25, NULL, NULL, NULL, 891, '2015-11-06 18:13:56.804955+01', NULL, ' ');
INSERT INTO date_objet (pk_date_objet, date_iso, fk_type_date_param, libelle_original_date, notes, descriptif, fk_objet, date_creation, date_modification, certitude) VALUES (696, '1740', 25, NULL, NULL, NULL, 994, '2015-11-06 18:13:56.804955+01', NULL, ' ');
INSERT INTO date_objet (pk_date_objet, date_iso, fk_type_date_param, libelle_original_date, notes, descriptif, fk_objet, date_creation, date_modification, certitude) VALUES (697, '1740', 25, NULL, NULL, NULL, 925, '2015-11-06 18:13:56.804955+01', NULL, ' ');
INSERT INTO date_objet (pk_date_objet, date_iso, fk_type_date_param, libelle_original_date, notes, descriptif, fk_objet, date_creation, date_modification, certitude) VALUES (698, '1740', 25, NULL, NULL, NULL, 1166, '2015-11-06 18:13:56.804955+01', NULL, ' ');
INSERT INTO date_objet (pk_date_objet, date_iso, fk_type_date_param, libelle_original_date, notes, descriptif, fk_objet, date_creation, date_modification, certitude) VALUES (699, '1741', 25, NULL, NULL, NULL, 1428, '2015-11-06 18:13:56.804955+01', NULL, ' ');
INSERT INTO date_objet (pk_date_objet, date_iso, fk_type_date_param, libelle_original_date, notes, descriptif, fk_objet, date_creation, date_modification, certitude) VALUES (700, '1741', 25, NULL, NULL, NULL, 908, '2015-11-06 18:13:56.804955+01', NULL, ' ');
INSERT INTO date_objet (pk_date_objet, date_iso, fk_type_date_param, libelle_original_date, notes, descriptif, fk_objet, date_creation, date_modification, certitude) VALUES (701, '1741', 25, NULL, NULL, NULL, 991, '2015-11-06 18:13:56.804955+01', NULL, ' ');
INSERT INTO date_objet (pk_date_objet, date_iso, fk_type_date_param, libelle_original_date, notes, descriptif, fk_objet, date_creation, date_modification, certitude) VALUES (702, '1742', 25, NULL, NULL, NULL, 931, '2015-11-06 18:13:56.804955+01', NULL, ' ');
INSERT INTO date_objet (pk_date_objet, date_iso, fk_type_date_param, libelle_original_date, notes, descriptif, fk_objet, date_creation, date_modification, certitude) VALUES (703, '1742', 25, NULL, NULL, NULL, 911, '2015-11-06 18:13:56.804955+01', NULL, ' ');
INSERT INTO date_objet (pk_date_objet, date_iso, fk_type_date_param, libelle_original_date, notes, descriptif, fk_objet, date_creation, date_modification, certitude) VALUES (704, '1743', 25, NULL, NULL, NULL, 1238, '2015-11-06 18:13:56.804955+01', NULL, ' ');
INSERT INTO date_objet (pk_date_objet, date_iso, fk_type_date_param, libelle_original_date, notes, descriptif, fk_objet, date_creation, date_modification, certitude) VALUES (705, '1743', 25, NULL, NULL, NULL, 1439, '2015-11-06 18:13:56.804955+01', NULL, ' ');
INSERT INTO date_objet (pk_date_objet, date_iso, fk_type_date_param, libelle_original_date, notes, descriptif, fk_objet, date_creation, date_modification, certitude) VALUES (706, '1743', 25, NULL, NULL, NULL, 831, '2015-11-06 18:13:56.804955+01', NULL, ' ');
INSERT INTO date_objet (pk_date_objet, date_iso, fk_type_date_param, libelle_original_date, notes, descriptif, fk_objet, date_creation, date_modification, certitude) VALUES (707, '1744', 25, NULL, NULL, NULL, 1334, '2015-11-06 18:13:56.804955+01', NULL, ' ');
INSERT INTO date_objet (pk_date_objet, date_iso, fk_type_date_param, libelle_original_date, notes, descriptif, fk_objet, date_creation, date_modification, certitude) VALUES (708, '1744', 25, NULL, NULL, NULL, 1453, '2015-11-06 18:13:56.804955+01', NULL, ' ');
INSERT INTO date_objet (pk_date_objet, date_iso, fk_type_date_param, libelle_original_date, notes, descriptif, fk_objet, date_creation, date_modification, certitude) VALUES (709, '1744', 25, NULL, NULL, NULL, 1234, '2015-11-06 18:13:56.804955+01', NULL, ' ');
INSERT INTO date_objet (pk_date_objet, date_iso, fk_type_date_param, libelle_original_date, notes, descriptif, fk_objet, date_creation, date_modification, certitude) VALUES (710, '1744', 25, NULL, NULL, NULL, 1474, '2015-11-06 18:13:56.804955+01', NULL, ' ');
INSERT INTO date_objet (pk_date_objet, date_iso, fk_type_date_param, libelle_original_date, notes, descriptif, fk_objet, date_creation, date_modification, certitude) VALUES (711, '1744', 25, NULL, NULL, NULL, 914, '2015-11-06 18:13:56.804955+01', NULL, ' ');
INSERT INTO date_objet (pk_date_objet, date_iso, fk_type_date_param, libelle_original_date, notes, descriptif, fk_objet, date_creation, date_modification, certitude) VALUES (712, '1745', 25, NULL, NULL, NULL, 976, '2015-11-06 18:13:56.804955+01', NULL, ' ');
INSERT INTO date_objet (pk_date_objet, date_iso, fk_type_date_param, libelle_original_date, notes, descriptif, fk_objet, date_creation, date_modification, certitude) VALUES (713, '1745', 25, NULL, NULL, NULL, 973, '2015-11-06 18:13:56.804955+01', NULL, ' ');
INSERT INTO date_objet (pk_date_objet, date_iso, fk_type_date_param, libelle_original_date, notes, descriptif, fk_objet, date_creation, date_modification, certitude) VALUES (714, '1745', 25, NULL, NULL, NULL, 1359, '2015-11-06 18:13:56.804955+01', NULL, ' ');
INSERT INTO date_objet (pk_date_objet, date_iso, fk_type_date_param, libelle_original_date, notes, descriptif, fk_objet, date_creation, date_modification, certitude) VALUES (715, '1745', 25, NULL, NULL, NULL, 1347, '2015-11-06 18:13:56.804955+01', NULL, ' ');
INSERT INTO date_objet (pk_date_objet, date_iso, fk_type_date_param, libelle_original_date, notes, descriptif, fk_objet, date_creation, date_modification, certitude) VALUES (716, '1745', 25, NULL, NULL, NULL, 1322, '2015-11-06 18:13:56.804955+01', NULL, ' ');
INSERT INTO date_objet (pk_date_objet, date_iso, fk_type_date_param, libelle_original_date, notes, descriptif, fk_objet, date_creation, date_modification, certitude) VALUES (717, '1745', 25, NULL, NULL, NULL, 1015, '2015-11-06 18:13:56.804955+01', NULL, ' ');
INSERT INTO date_objet (pk_date_objet, date_iso, fk_type_date_param, libelle_original_date, notes, descriptif, fk_objet, date_creation, date_modification, certitude) VALUES (718, '1746', 25, NULL, NULL, NULL, 1003, '2015-11-06 18:13:56.804955+01', NULL, ' ');
INSERT INTO date_objet (pk_date_objet, date_iso, fk_type_date_param, libelle_original_date, notes, descriptif, fk_objet, date_creation, date_modification, certitude) VALUES (719, '1746', 25, NULL, NULL, NULL, 1424, '2015-11-06 18:13:56.804955+01', NULL, ' ');
INSERT INTO date_objet (pk_date_objet, date_iso, fk_type_date_param, libelle_original_date, notes, descriptif, fk_objet, date_creation, date_modification, certitude) VALUES (720, '1746', 25, NULL, NULL, NULL, 1262, '2015-11-06 18:13:56.804955+01', NULL, ' ');
INSERT INTO date_objet (pk_date_objet, date_iso, fk_type_date_param, libelle_original_date, notes, descriptif, fk_objet, date_creation, date_modification, certitude) VALUES (721, '1746', 25, NULL, NULL, NULL, 997, '2015-11-06 18:13:56.804955+01', NULL, ' ');
INSERT INTO date_objet (pk_date_objet, date_iso, fk_type_date_param, libelle_original_date, notes, descriptif, fk_objet, date_creation, date_modification, certitude) VALUES (722, '1746', 25, NULL, NULL, NULL, 1081, '2015-11-06 18:13:56.804955+01', NULL, ' ');
INSERT INTO date_objet (pk_date_objet, date_iso, fk_type_date_param, libelle_original_date, notes, descriptif, fk_objet, date_creation, date_modification, certitude) VALUES (723, '1751', 25, NULL, NULL, NULL, 1301, '2015-11-06 18:13:56.804955+01', NULL, 'p');
INSERT INTO date_objet (pk_date_objet, date_iso, fk_type_date_param, libelle_original_date, notes, descriptif, fk_objet, date_creation, date_modification, certitude) VALUES (724, '1747', 25, NULL, NULL, NULL, 1387, '2015-11-06 18:13:56.804955+01', NULL, ' ');
INSERT INTO date_objet (pk_date_objet, date_iso, fk_type_date_param, libelle_original_date, notes, descriptif, fk_objet, date_creation, date_modification, certitude) VALUES (725, '1747', 25, NULL, NULL, NULL, 1397, '2015-11-06 18:13:56.804955+01', NULL, ' ');
INSERT INTO date_objet (pk_date_objet, date_iso, fk_type_date_param, libelle_original_date, notes, descriptif, fk_objet, date_creation, date_modification, certitude) VALUES (726, '1747', 25, NULL, NULL, NULL, 1085, '2015-11-06 18:13:56.804955+01', NULL, ' ');
INSERT INTO date_objet (pk_date_objet, date_iso, fk_type_date_param, libelle_original_date, notes, descriptif, fk_objet, date_creation, date_modification, certitude) VALUES (727, '1748', 25, NULL, NULL, NULL, 1459, '2015-11-06 18:13:56.804955+01', NULL, ' ');
INSERT INTO date_objet (pk_date_objet, date_iso, fk_type_date_param, libelle_original_date, notes, descriptif, fk_objet, date_creation, date_modification, certitude) VALUES (728, '1754', 25, NULL, NULL, NULL, 1398, '2015-11-06 18:13:56.804955+01', NULL, ' ');
INSERT INTO date_objet (pk_date_objet, date_iso, fk_type_date_param, libelle_original_date, notes, descriptif, fk_objet, date_creation, date_modification, certitude) VALUES (729, '1748', 25, NULL, NULL, NULL, 1091, '2015-11-06 18:13:56.804955+01', NULL, ' ');
INSERT INTO date_objet (pk_date_objet, date_iso, fk_type_date_param, libelle_original_date, notes, descriptif, fk_objet, date_creation, date_modification, certitude) VALUES (730, '1748', 25, NULL, NULL, NULL, 1121, '2015-11-06 18:13:56.804955+01', NULL, ' ');
INSERT INTO date_objet (pk_date_objet, date_iso, fk_type_date_param, libelle_original_date, notes, descriptif, fk_objet, date_creation, date_modification, certitude) VALUES (731, '1748', 25, NULL, NULL, NULL, 1460, '2015-11-06 18:13:56.804955+01', NULL, ' ');
INSERT INTO date_objet (pk_date_objet, date_iso, fk_type_date_param, libelle_original_date, notes, descriptif, fk_objet, date_creation, date_modification, certitude) VALUES (732, '1748', 25, NULL, NULL, NULL, 1025, '2015-11-06 18:13:56.804955+01', NULL, ' ');
INSERT INTO date_objet (pk_date_objet, date_iso, fk_type_date_param, libelle_original_date, notes, descriptif, fk_objet, date_creation, date_modification, certitude) VALUES (733, '1749', 25, NULL, NULL, NULL, 1218, '2015-11-06 18:13:56.804955+01', NULL, ' ');
INSERT INTO date_objet (pk_date_objet, date_iso, fk_type_date_param, libelle_original_date, notes, descriptif, fk_objet, date_creation, date_modification, certitude) VALUES (734, '1749', 25, NULL, NULL, NULL, 1105, '2015-11-06 18:13:56.804955+01', NULL, ' ');
INSERT INTO date_objet (pk_date_objet, date_iso, fk_type_date_param, libelle_original_date, notes, descriptif, fk_objet, date_creation, date_modification, certitude) VALUES (735, '1749', 25, NULL, NULL, NULL, 1266, '2015-11-06 18:13:56.804955+01', NULL, ' ');
INSERT INTO date_objet (pk_date_objet, date_iso, fk_type_date_param, libelle_original_date, notes, descriptif, fk_objet, date_creation, date_modification, certitude) VALUES (736, '1749', 25, NULL, NULL, NULL, 1438, '2015-11-06 18:13:56.804955+01', NULL, ' ');
INSERT INTO date_objet (pk_date_objet, date_iso, fk_type_date_param, libelle_original_date, notes, descriptif, fk_objet, date_creation, date_modification, certitude) VALUES (737, '1749', 25, NULL, NULL, NULL, 1496, '2015-11-06 18:13:56.804955+01', NULL, ' ');
INSERT INTO date_objet (pk_date_objet, date_iso, fk_type_date_param, libelle_original_date, notes, descriptif, fk_objet, date_creation, date_modification, certitude) VALUES (738, '1749', 25, NULL, NULL, NULL, 1161, '2015-11-06 18:13:56.804955+01', NULL, ' ');
INSERT INTO date_objet (pk_date_objet, date_iso, fk_type_date_param, libelle_original_date, notes, descriptif, fk_objet, date_creation, date_modification, certitude) VALUES (739, '1751', 25, NULL, NULL, NULL, 1019, '2015-11-06 18:13:56.804955+01', NULL, 'p');
INSERT INTO date_objet (pk_date_objet, date_iso, fk_type_date_param, libelle_original_date, notes, descriptif, fk_objet, date_creation, date_modification, certitude) VALUES (740, '1749', 25, NULL, NULL, NULL, 1442, '2015-11-06 18:13:56.804955+01', NULL, ' ');
INSERT INTO date_objet (pk_date_objet, date_iso, fk_type_date_param, libelle_original_date, notes, descriptif, fk_objet, date_creation, date_modification, certitude) VALUES (741, '1750', 25, NULL, NULL, NULL, 1113, '2015-11-06 18:13:56.804955+01', NULL, ' ');
INSERT INTO date_objet (pk_date_objet, date_iso, fk_type_date_param, libelle_original_date, notes, descriptif, fk_objet, date_creation, date_modification, certitude) VALUES (742, '1750', 25, NULL, NULL, NULL, 1488, '2015-11-06 18:13:56.804955+01', NULL, ' ');
INSERT INTO date_objet (pk_date_objet, date_iso, fk_type_date_param, libelle_original_date, notes, descriptif, fk_objet, date_creation, date_modification, certitude) VALUES (743, '1750', 25, NULL, NULL, NULL, 1273, '2015-11-06 18:13:56.804955+01', NULL, ' ');
INSERT INTO date_objet (pk_date_objet, date_iso, fk_type_date_param, libelle_original_date, notes, descriptif, fk_objet, date_creation, date_modification, certitude) VALUES (744, '1750', 25, NULL, NULL, NULL, 1075, '2015-11-06 18:13:56.804955+01', NULL, ' ');
INSERT INTO date_objet (pk_date_objet, date_iso, fk_type_date_param, libelle_original_date, notes, descriptif, fk_objet, date_creation, date_modification, certitude) VALUES (745, '1750', 25, NULL, NULL, NULL, 1368, '2015-11-06 18:13:56.804955+01', NULL, ' ');
INSERT INTO date_objet (pk_date_objet, date_iso, fk_type_date_param, libelle_original_date, notes, descriptif, fk_objet, date_creation, date_modification, certitude) VALUES (746, '1750', 25, NULL, NULL, NULL, 1204, '2015-11-06 18:13:56.804955+01', NULL, ' ');
INSERT INTO date_objet (pk_date_objet, date_iso, fk_type_date_param, libelle_original_date, notes, descriptif, fk_objet, date_creation, date_modification, certitude) VALUES (747, '1751', 25, NULL, NULL, NULL, 1504, '2015-11-06 18:13:56.804955+01', NULL, 'p');
INSERT INTO date_objet (pk_date_objet, date_iso, fk_type_date_param, libelle_original_date, notes, descriptif, fk_objet, date_creation, date_modification, certitude) VALUES (748, '1751', 25, NULL, NULL, NULL, 1519, '2015-11-06 18:13:56.804955+01', NULL, ' ');
INSERT INTO date_objet (pk_date_objet, date_iso, fk_type_date_param, libelle_original_date, notes, descriptif, fk_objet, date_creation, date_modification, certitude) VALUES (749, '1751', 25, NULL, NULL, NULL, 1332, '2015-11-06 18:13:56.804955+01', NULL, ' ');
INSERT INTO date_objet (pk_date_objet, date_iso, fk_type_date_param, libelle_original_date, notes, descriptif, fk_objet, date_creation, date_modification, certitude) VALUES (750, '1751', 25, NULL, NULL, NULL, 1399, '2015-11-06 18:13:56.804955+01', NULL, 'p');
INSERT INTO date_objet (pk_date_objet, date_iso, fk_type_date_param, libelle_original_date, notes, descriptif, fk_objet, date_creation, date_modification, certitude) VALUES (751, '1751', 25, NULL, NULL, NULL, 864, '2015-11-06 18:13:56.804955+01', NULL, 'p');
INSERT INTO date_objet (pk_date_objet, date_iso, fk_type_date_param, libelle_original_date, notes, descriptif, fk_objet, date_creation, date_modification, certitude) VALUES (752, '1751', 25, NULL, NULL, NULL, 1489, '2015-11-06 18:13:56.804955+01', NULL, 'p');
INSERT INTO date_objet (pk_date_objet, date_iso, fk_type_date_param, libelle_original_date, notes, descriptif, fk_objet, date_creation, date_modification, certitude) VALUES (753, '1751', 25, NULL, NULL, NULL, 1151, '2015-11-06 18:13:56.804955+01', NULL, 'p');
INSERT INTO date_objet (pk_date_objet, date_iso, fk_type_date_param, libelle_original_date, notes, descriptif, fk_objet, date_creation, date_modification, certitude) VALUES (754, '1751', 25, NULL, NULL, NULL, 843, '2015-11-06 18:13:56.804955+01', NULL, 'p');
INSERT INTO date_objet (pk_date_objet, date_iso, fk_type_date_param, libelle_original_date, notes, descriptif, fk_objet, date_creation, date_modification, certitude) VALUES (755, '1751', 25, NULL, NULL, NULL, 871, '2015-11-06 18:13:56.804955+01', NULL, 'p');
INSERT INTO date_objet (pk_date_objet, date_iso, fk_type_date_param, libelle_original_date, notes, descriptif, fk_objet, date_creation, date_modification, certitude) VALUES (756, '1751', 25, NULL, NULL, NULL, 956, '2015-11-06 18:13:56.804955+01', NULL, 'p');
INSERT INTO date_objet (pk_date_objet, date_iso, fk_type_date_param, libelle_original_date, notes, descriptif, fk_objet, date_creation, date_modification, certitude) VALUES (757, '1751', 25, NULL, NULL, NULL, 1031, '2015-11-06 18:13:56.804955+01', NULL, 'p');
INSERT INTO date_objet (pk_date_objet, date_iso, fk_type_date_param, libelle_original_date, notes, descriptif, fk_objet, date_creation, date_modification, certitude) VALUES (758, '1751', 25, NULL, NULL, NULL, 1299, '2015-11-06 18:13:56.804955+01', NULL, 'p');
INSERT INTO date_objet (pk_date_objet, date_iso, fk_type_date_param, libelle_original_date, notes, descriptif, fk_objet, date_creation, date_modification, certitude) VALUES (759, '1751', 25, NULL, NULL, NULL, 980, '2015-11-06 18:13:56.804955+01', NULL, 'p');
INSERT INTO date_objet (pk_date_objet, date_iso, fk_type_date_param, libelle_original_date, notes, descriptif, fk_objet, date_creation, date_modification, certitude) VALUES (760, '1751', 25, NULL, NULL, NULL, 1542, '2015-11-06 18:13:56.804955+01', NULL, 'p');
INSERT INTO date_objet (pk_date_objet, date_iso, fk_type_date_param, libelle_original_date, notes, descriptif, fk_objet, date_creation, date_modification, certitude) VALUES (761, '1751', 25, NULL, NULL, NULL, 1016, '2015-11-06 18:13:56.804955+01', NULL, 'p');
INSERT INTO date_objet (pk_date_objet, date_iso, fk_type_date_param, libelle_original_date, notes, descriptif, fk_objet, date_creation, date_modification, certitude) VALUES (762, '1751', 25, NULL, NULL, NULL, 1313, '2015-11-06 18:13:56.804955+01', NULL, 'p');
INSERT INTO date_objet (pk_date_objet, date_iso, fk_type_date_param, libelle_original_date, notes, descriptif, fk_objet, date_creation, date_modification, certitude) VALUES (763, '1751', 25, NULL, NULL, NULL, 1534, '2015-11-06 18:13:56.804955+01', NULL, 'p');
INSERT INTO date_objet (pk_date_objet, date_iso, fk_type_date_param, libelle_original_date, notes, descriptif, fk_objet, date_creation, date_modification, certitude) VALUES (764, '1751', 25, NULL, NULL, NULL, 1480, '2015-11-06 18:13:56.804955+01', NULL, 'p');
INSERT INTO date_objet (pk_date_objet, date_iso, fk_type_date_param, libelle_original_date, notes, descriptif, fk_objet, date_creation, date_modification, certitude) VALUES (765, '1751', 25, NULL, NULL, NULL, 1447, '2015-11-06 18:13:56.804955+01', NULL, 'p');
INSERT INTO date_objet (pk_date_objet, date_iso, fk_type_date_param, libelle_original_date, notes, descriptif, fk_objet, date_creation, date_modification, certitude) VALUES (766, '1751', 25, NULL, NULL, NULL, 1125, '2015-11-06 18:13:56.804955+01', NULL, 'p');
INSERT INTO date_objet (pk_date_objet, date_iso, fk_type_date_param, libelle_original_date, notes, descriptif, fk_objet, date_creation, date_modification, certitude) VALUES (767, '1751', 25, NULL, NULL, NULL, 1065, '2015-11-06 18:13:56.804955+01', NULL, 'p');
INSERT INTO date_objet (pk_date_objet, date_iso, fk_type_date_param, libelle_original_date, notes, descriptif, fk_objet, date_creation, date_modification, certitude) VALUES (768, '1751', 25, NULL, NULL, NULL, 1060, '2015-11-06 18:13:56.804955+01', NULL, 'p');
INSERT INTO date_objet (pk_date_objet, date_iso, fk_type_date_param, libelle_original_date, notes, descriptif, fk_objet, date_creation, date_modification, certitude) VALUES (769, '1751', 25, NULL, NULL, NULL, 960, '2015-11-06 18:13:56.804955+01', NULL, 'p');
INSERT INTO date_objet (pk_date_objet, date_iso, fk_type_date_param, libelle_original_date, notes, descriptif, fk_objet, date_creation, date_modification, certitude) VALUES (770, '1751', 25, NULL, NULL, NULL, 958, '2015-11-06 18:13:56.804955+01', NULL, 'p');
INSERT INTO date_objet (pk_date_objet, date_iso, fk_type_date_param, libelle_original_date, notes, descriptif, fk_objet, date_creation, date_modification, certitude) VALUES (771, '1751', 25, NULL, NULL, NULL, 1109, '2015-11-06 18:13:56.804955+01', NULL, ' ');
INSERT INTO date_objet (pk_date_objet, date_iso, fk_type_date_param, libelle_original_date, notes, descriptif, fk_objet, date_creation, date_modification, certitude) VALUES (772, '1751', 25, NULL, NULL, NULL, 1061, '2015-11-06 18:13:56.804955+01', NULL, 'p');
INSERT INTO date_objet (pk_date_objet, date_iso, fk_type_date_param, libelle_original_date, notes, descriptif, fk_objet, date_creation, date_modification, certitude) VALUES (773, '1751', 25, NULL, NULL, NULL, 929, '2015-11-06 18:13:56.804955+01', NULL, 'p');
INSERT INTO date_objet (pk_date_objet, date_iso, fk_type_date_param, libelle_original_date, notes, descriptif, fk_objet, date_creation, date_modification, certitude) VALUES (774, '1751', 25, NULL, NULL, NULL, 1614, '2015-11-06 18:13:56.804955+01', NULL, 'p');
INSERT INTO date_objet (pk_date_objet, date_iso, fk_type_date_param, libelle_original_date, notes, descriptif, fk_objet, date_creation, date_modification, certitude) VALUES (775, '1752', 25, NULL, NULL, NULL, 1595, '2015-11-06 18:13:56.804955+01', NULL, ' ');
INSERT INTO date_objet (pk_date_objet, date_iso, fk_type_date_param, libelle_original_date, notes, descriptif, fk_objet, date_creation, date_modification, certitude) VALUES (776, '1752', 25, NULL, NULL, NULL, 1252, '2015-11-06 18:13:56.804955+01', NULL, ' ');
INSERT INTO date_objet (pk_date_objet, date_iso, fk_type_date_param, libelle_original_date, notes, descriptif, fk_objet, date_creation, date_modification, certitude) VALUES (777, '1752', 25, NULL, NULL, NULL, 1040, '2015-11-06 18:13:56.804955+01', NULL, ' ');
INSERT INTO date_objet (pk_date_objet, date_iso, fk_type_date_param, libelle_original_date, notes, descriptif, fk_objet, date_creation, date_modification, certitude) VALUES (778, '1759', 25, NULL, NULL, NULL, 1364, '2015-11-06 18:13:56.804955+01', NULL, ' ');
INSERT INTO date_objet (pk_date_objet, date_iso, fk_type_date_param, libelle_original_date, notes, descriptif, fk_objet, date_creation, date_modification, certitude) VALUES (779, '1752', 25, NULL, NULL, NULL, 1002, '2015-11-06 18:13:56.804955+01', NULL, ' ');
INSERT INTO date_objet (pk_date_objet, date_iso, fk_type_date_param, libelle_original_date, notes, descriptif, fk_objet, date_creation, date_modification, certitude) VALUES (780, '1752', 25, NULL, NULL, NULL, 1323, '2015-11-06 18:13:56.804955+01', NULL, ' ');
INSERT INTO date_objet (pk_date_objet, date_iso, fk_type_date_param, libelle_original_date, notes, descriptif, fk_objet, date_creation, date_modification, certitude) VALUES (781, '1753', 25, NULL, NULL, NULL, 948, '2015-11-06 18:13:56.804955+01', NULL, ' ');
INSERT INTO date_objet (pk_date_objet, date_iso, fk_type_date_param, libelle_original_date, notes, descriptif, fk_objet, date_creation, date_modification, certitude) VALUES (782, '1754', 25, NULL, NULL, NULL, 1375, '2015-11-06 18:13:56.804955+01', NULL, ' ');
INSERT INTO date_objet (pk_date_objet, date_iso, fk_type_date_param, libelle_original_date, notes, descriptif, fk_objet, date_creation, date_modification, certitude) VALUES (783, '1754', 25, NULL, NULL, NULL, 1020, '2015-11-06 18:13:56.804955+01', NULL, ' ');
INSERT INTO date_objet (pk_date_objet, date_iso, fk_type_date_param, libelle_original_date, notes, descriptif, fk_objet, date_creation, date_modification, certitude) VALUES (784, '1754', 25, NULL, NULL, NULL, 1354, '2015-11-06 18:13:56.804955+01', NULL, ' ');
INSERT INTO date_objet (pk_date_objet, date_iso, fk_type_date_param, libelle_original_date, notes, descriptif, fk_objet, date_creation, date_modification, certitude) VALUES (785, '1754', 25, NULL, NULL, NULL, 1187, '2015-11-06 18:13:56.804955+01', NULL, ' ');
INSERT INTO date_objet (pk_date_objet, date_iso, fk_type_date_param, libelle_original_date, notes, descriptif, fk_objet, date_creation, date_modification, certitude) VALUES (786, '1755', 25, NULL, NULL, NULL, 1391, '2015-11-06 18:13:56.804955+01', NULL, ' ');
INSERT INTO date_objet (pk_date_objet, date_iso, fk_type_date_param, libelle_original_date, notes, descriptif, fk_objet, date_creation, date_modification, certitude) VALUES (787, '1755', 25, NULL, NULL, NULL, 1528, '2015-11-06 18:13:56.804955+01', NULL, ' ');
INSERT INTO date_objet (pk_date_objet, date_iso, fk_type_date_param, libelle_original_date, notes, descriptif, fk_objet, date_creation, date_modification, certitude) VALUES (788, '1755', 25, NULL, NULL, NULL, 1348, '2015-11-06 18:13:56.804955+01', NULL, ' ');
INSERT INTO date_objet (pk_date_objet, date_iso, fk_type_date_param, libelle_original_date, notes, descriptif, fk_objet, date_creation, date_modification, certitude) VALUES (789, '1755', 25, NULL, NULL, NULL, 899, '2015-11-06 18:13:56.804955+01', NULL, ' ');
INSERT INTO date_objet (pk_date_objet, date_iso, fk_type_date_param, libelle_original_date, notes, descriptif, fk_objet, date_creation, date_modification, certitude) VALUES (790, '1755', 25, NULL, NULL, NULL, 1543, '2015-11-06 18:13:56.804955+01', NULL, ' ');
INSERT INTO date_objet (pk_date_objet, date_iso, fk_type_date_param, libelle_original_date, notes, descriptif, fk_objet, date_creation, date_modification, certitude) VALUES (791, '1755', 25, NULL, NULL, NULL, 1119, '2015-11-06 18:13:56.804955+01', NULL, ' ');
INSERT INTO date_objet (pk_date_objet, date_iso, fk_type_date_param, libelle_original_date, notes, descriptif, fk_objet, date_creation, date_modification, certitude) VALUES (792, '1755', 25, NULL, NULL, NULL, 1098, '2015-11-06 18:13:56.804955+01', NULL, ' ');
INSERT INTO date_objet (pk_date_objet, date_iso, fk_type_date_param, libelle_original_date, notes, descriptif, fk_objet, date_creation, date_modification, certitude) VALUES (793, '1755', 25, NULL, NULL, NULL, 1605, '2015-11-06 18:13:56.804955+01', NULL, ' ');
INSERT INTO date_objet (pk_date_objet, date_iso, fk_type_date_param, libelle_original_date, notes, descriptif, fk_objet, date_creation, date_modification, certitude) VALUES (794, '1755', 25, NULL, NULL, NULL, 1212, '2015-11-06 18:13:56.804955+01', NULL, ' ');
INSERT INTO date_objet (pk_date_objet, date_iso, fk_type_date_param, libelle_original_date, notes, descriptif, fk_objet, date_creation, date_modification, certitude) VALUES (795, '1756', 25, NULL, NULL, NULL, 1396, '2015-11-06 18:13:56.804955+01', NULL, ' ');
INSERT INTO date_objet (pk_date_objet, date_iso, fk_type_date_param, libelle_original_date, notes, descriptif, fk_objet, date_creation, date_modification, certitude) VALUES (796, '1756', 25, NULL, NULL, NULL, 862, '2015-11-06 18:13:56.804955+01', NULL, ' ');
INSERT INTO date_objet (pk_date_objet, date_iso, fk_type_date_param, libelle_original_date, notes, descriptif, fk_objet, date_creation, date_modification, certitude) VALUES (797, '1756', 25, NULL, NULL, NULL, 1276, '2015-11-06 18:13:56.804955+01', NULL, ' ');
INSERT INTO date_objet (pk_date_objet, date_iso, fk_type_date_param, libelle_original_date, notes, descriptif, fk_objet, date_creation, date_modification, certitude) VALUES (798, '1756', 25, NULL, NULL, NULL, 1076, '2015-11-06 18:13:56.804955+01', NULL, ' ');
INSERT INTO date_objet (pk_date_objet, date_iso, fk_type_date_param, libelle_original_date, notes, descriptif, fk_objet, date_creation, date_modification, certitude) VALUES (799, '1756', 25, NULL, NULL, NULL, 1054, '2015-11-06 18:13:56.804955+01', NULL, ' ');
INSERT INTO date_objet (pk_date_objet, date_iso, fk_type_date_param, libelle_original_date, notes, descriptif, fk_objet, date_creation, date_modification, certitude) VALUES (800, '1757', 25, NULL, NULL, NULL, 930, '2015-11-06 18:13:56.804955+01', NULL, ' ');
INSERT INTO date_objet (pk_date_objet, date_iso, fk_type_date_param, libelle_original_date, notes, descriptif, fk_objet, date_creation, date_modification, certitude) VALUES (801, '1757', 25, NULL, NULL, NULL, 1579, '2015-11-06 18:13:56.804955+01', NULL, ' ');
INSERT INTO date_objet (pk_date_objet, date_iso, fk_type_date_param, libelle_original_date, notes, descriptif, fk_objet, date_creation, date_modification, certitude) VALUES (802, '1758', 25, NULL, NULL, NULL, 1230, '2015-11-06 18:13:56.804955+01', NULL, ' ');
INSERT INTO date_objet (pk_date_objet, date_iso, fk_type_date_param, libelle_original_date, notes, descriptif, fk_objet, date_creation, date_modification, certitude) VALUES (803, '1759', 25, NULL, NULL, NULL, 1417, '2015-11-06 18:13:56.804955+01', NULL, ' ');
INSERT INTO date_objet (pk_date_objet, date_iso, fk_type_date_param, libelle_original_date, notes, descriptif, fk_objet, date_creation, date_modification, certitude) VALUES (804, '1759', 25, NULL, NULL, NULL, 1498, '2015-11-06 18:13:56.804955+01', NULL, ' ');
INSERT INTO date_objet (pk_date_objet, date_iso, fk_type_date_param, libelle_original_date, notes, descriptif, fk_objet, date_creation, date_modification, certitude) VALUES (805, '1759', 25, NULL, NULL, NULL, 1302, '2015-11-06 18:13:56.804955+01', NULL, ' ');
INSERT INTO date_objet (pk_date_objet, date_iso, fk_type_date_param, libelle_original_date, notes, descriptif, fk_objet, date_creation, date_modification, certitude) VALUES (806, '1760', 25, NULL, NULL, NULL, 1598, '2015-11-06 18:13:56.804955+01', NULL, ' ');
INSERT INTO date_objet (pk_date_objet, date_iso, fk_type_date_param, libelle_original_date, notes, descriptif, fk_objet, date_creation, date_modification, certitude) VALUES (807, '1760', 25, NULL, NULL, NULL, 1022, '2015-11-06 18:13:56.804955+01', NULL, ' ');
INSERT INTO date_objet (pk_date_objet, date_iso, fk_type_date_param, libelle_original_date, notes, descriptif, fk_objet, date_creation, date_modification, certitude) VALUES (809, '1550', 25, NULL, NULL, NULL, 1619, '2015-11-09 21:17:29.787913+01', '2015-11-09 21:17:58.333961+01', NULL);
INSERT INTO date_objet (pk_date_objet, date_iso, fk_type_date_param, libelle_original_date, notes, descriptif, fk_objet, date_creation, date_modification, certitude) VALUES (808, '1551', 25, NULL, NULL, NULL, 1620, '2015-11-09 21:16:59.121158+01', '2015-11-09 21:18:14.77701+01', NULL);


--
-- TOC entry 2413 (class 0 OID 0)
-- Dependencies: 187
-- Name: date_objet_pk_date_objet_seq; Type: SEQUENCE SET; Schema: objets; Owner: -
--

SELECT pg_catalog.setval('date_objet_pk_date_objet_seq', 809, true);


--
-- TOC entry 2396 (class 0 OID 22737)
-- Dependencies: 179
-- Data for Name: nom_objet; Type: TABLE DATA; Schema: objets; Owner: -
--

INSERT INTO nom_objet (pk_nom_objet, nom, langue, notes, fk_objet, est_standard, date_creation, date_modification, fk_type_nom_param, date_debut, date_fin) VALUES (8, 'concerner', NULL, NULL, 10, true, '2015-09-30 17:45:49.20009+02', NULL, 15, NULL, NULL);
INSERT INTO nom_objet (pk_nom_objet, nom, langue, notes, fk_objet, est_standard, date_creation, date_modification, fk_type_nom_param, date_debut, date_fin) VALUES (9, 'Naissance', NULL, NULL, 11, true, '2015-09-30 17:52:16.518456+02', NULL, 15, NULL, NULL);
INSERT INTO nom_objet (pk_nom_objet, nom, langue, notes, fk_objet, est_standard, date_creation, date_modification, fk_type_nom_param, date_debut, date_fin) VALUES (10, 'Naissance', NULL, NULL, 12, true, '2015-09-30 17:53:02.319296+02', NULL, 15, NULL, NULL);
INSERT INTO nom_objet (pk_nom_objet, nom, langue, notes, fk_objet, est_standard, date_creation, date_modification, fk_type_nom_param, date_debut, date_fin) VALUES (11, 'Naissance de Kepler', NULL, NULL, 13, true, '2015-09-30 17:56:09.260378+02', NULL, 15, NULL, NULL);
INSERT INTO nom_objet (pk_nom_objet, nom, langue, notes, fk_objet, est_standard, date_creation, date_modification, fk_type_nom_param, date_debut, date_fin) VALUES (36, 'Haincmar de Reims, (titre), ed. par NN (Patrologia latina, 612), Paris 1860', NULL, NULL, 35, true, '2015-10-13 17:46:12.942494+02', NULL, 15, NULL, NULL);
INSERT INTO nom_objet (pk_nom_objet, nom, langue, notes, fk_objet, est_standard, date_creation, date_modification, fk_type_nom_param, date_debut, date_fin) VALUES (4, 'Astronomie', NULL, NULL, 6, true, '2015-09-28 21:48:24.513948+02', '2015-10-02 23:15:26.894269+02', 15, NULL, NULL);
INSERT INTO nom_objet (pk_nom_objet, nom, langue, notes, fk_objet, est_standard, date_creation, date_modification, fk_type_nom_param, date_debut, date_fin) VALUES (6, 'Element biographique', NULL, NULL, 8, true, '2015-09-30 17:26:14.167382+02', '2015-10-04 07:38:56.716102+02', 15, NULL, NULL);
INSERT INTO nom_objet (pk_nom_objet, nom, langue, notes, fk_objet, est_standard, date_creation, date_modification, fk_type_nom_param, date_debut, date_fin) VALUES (12, 'Caractérisation synthètique', NULL, NULL, 14, true, '2015-09-30 23:14:59.243403+02', '2015-10-04 07:39:28.32644+02', 15, NULL, NULL);
INSERT INTO nom_objet (pk_nom_objet, nom, langue, notes, fk_objet, est_standard, date_creation, date_modification, fk_type_nom_param, date_debut, date_fin) VALUES (39, 'Willem Jacob''s Gravesande', NULL, NULL, 829, true, '2015-11-06 16:04:13.593497+01', NULL, 15, NULL, NULL);
INSERT INTO nom_objet (pk_nom_objet, nom, langue, notes, fk_objet, est_standard, date_creation, date_modification, fk_type_nom_param, date_debut, date_fin) VALUES (16, 'Philosophe', NULL, NULL, 18, true, '2015-10-04 08:15:39.193019+02', NULL, 15, NULL, NULL);
INSERT INTO nom_objet (pk_nom_objet, nom, langue, notes, fk_objet, est_standard, date_creation, date_modification, fk_type_nom_param, date_debut, date_fin) VALUES (40, 'Chrysologue de Gy', NULL, NULL, 830, true, '2015-11-06 16:04:13.593497+01', NULL, 15, NULL, NULL);
INSERT INTO nom_objet (pk_nom_objet, nom, langue, notes, fk_objet, est_standard, date_creation, date_modification, fk_type_nom_param, date_debut, date_fin) VALUES (41, 'Jean-Antoine-Nicolas de Caritat Condorcet', NULL, NULL, 831, true, '2015-11-06 16:04:13.593497+01', NULL, 15, NULL, NULL);
INSERT INTO nom_objet (pk_nom_objet, nom, langue, notes, fk_objet, est_standard, date_creation, date_modification, fk_type_nom_param, date_debut, date_fin) VALUES (17, 'Savant', NULL, NULL, 19, true, '2015-10-04 08:38:15.524569+02', '2015-10-04 08:38:35.212498+02', 15, NULL, NULL);
INSERT INTO nom_objet (pk_nom_objet, nom, langue, notes, fk_objet, est_standard, date_creation, date_modification, fk_type_nom_param, date_debut, date_fin) VALUES (42, 'Georg Matthias Bose', NULL, NULL, 832, true, '2015-11-06 16:04:13.593497+01', NULL, 15, NULL, NULL);
INSERT INTO nom_objet (pk_nom_objet, nom, langue, notes, fk_objet, est_standard, date_creation, date_modification, fk_type_nom_param, date_debut, date_fin) VALUES (43, 'Blaise Pascal', NULL, NULL, 833, true, '2015-11-06 16:04:13.593497+01', NULL, 15, NULL, NULL);
INSERT INTO nom_objet (pk_nom_objet, nom, langue, notes, fk_objet, est_standard, date_creation, date_modification, fk_type_nom_param, date_debut, date_fin) VALUES (44, 'Jean Chappe d''Auteroche', NULL, NULL, 834, true, '2015-11-06 16:04:13.593497+01', NULL, 15, NULL, NULL);
INSERT INTO nom_objet (pk_nom_objet, nom, langue, notes, fk_objet, est_standard, date_creation, date_modification, fk_type_nom_param, date_debut, date_fin) VALUES (45, 'Giovanni Benedetto Moncetto', NULL, NULL, 835, true, '2015-11-06 16:04:13.593497+01', NULL, 15, NULL, NULL);
INSERT INTO nom_objet (pk_nom_objet, nom, langue, notes, fk_objet, est_standard, date_creation, date_modification, fk_type_nom_param, date_debut, date_fin) VALUES (18, 'Notice', NULL, NULL, 20, true, '2015-10-04 10:40:12.841066+02', NULL, 15, NULL, NULL);
INSERT INTO nom_objet (pk_nom_objet, nom, langue, notes, fk_objet, est_standard, date_creation, date_modification, fk_type_nom_param, date_debut, date_fin) VALUES (46, 'Johannes Nicolaus Frobesius', NULL, NULL, 836, true, '2015-11-06 16:04:13.593497+01', NULL, 15, NULL, NULL);
INSERT INTO nom_objet (pk_nom_objet, nom, langue, notes, fk_objet, est_standard, date_creation, date_modification, fk_type_nom_param, date_debut, date_fin) VALUES (47, 'François Jacquier', NULL, NULL, 837, true, '2015-11-06 16:04:13.593497+01', NULL, 15, NULL, NULL);
INSERT INTO nom_objet (pk_nom_objet, nom, langue, notes, fk_objet, est_standard, date_creation, date_modification, fk_type_nom_param, date_debut, date_fin) VALUES (48, 'Gerard Keulen', NULL, NULL, 838, true, '2015-11-06 16:04:13.593497+01', NULL, 15, NULL, NULL);
INSERT INTO nom_objet (pk_nom_objet, nom, langue, notes, fk_objet, est_standard, date_creation, date_modification, fk_type_nom_param, date_debut, date_fin) VALUES (49, 'Joseph-François Marie', NULL, NULL, 839, true, '2015-11-06 16:04:13.593497+01', NULL, 15, NULL, NULL);
INSERT INTO nom_objet (pk_nom_objet, nom, langue, notes, fk_objet, est_standard, date_creation, date_modification, fk_type_nom_param, date_debut, date_fin) VALUES (35, 'Source', NULL, NULL, 34, true, '2015-10-13 17:42:49.184459+02', '2015-11-09 19:02:28.873888+01', 15, NULL, NULL);
INSERT INTO nom_objet (pk_nom_objet, nom, langue, notes, fk_objet, est_standard, date_creation, date_modification, fk_type_nom_param, date_debut, date_fin) VALUES (1, 'Kepler, Jean', NULL, NULL, 2, true, '2015-09-25 22:42:29.469598+02', '2015-10-04 22:52:57.837407+02', 15, NULL, NULL);
INSERT INTO nom_objet (pk_nom_objet, nom, langue, notes, fk_objet, est_standard, date_creation, date_modification, fk_type_nom_param, date_debut, date_fin) VALUES (19, 'Galilei, Galileo', NULL, NULL, 7, true, '2015-10-04 23:06:33.201954+02', NULL, 15, NULL, NULL);
INSERT INTO nom_objet (pk_nom_objet, nom, langue, notes, fk_objet, est_standard, date_creation, date_modification, fk_type_nom_param, date_debut, date_fin) VALUES (20, 'Weil der Stadt', NULL, NULL, 21, true, '2015-10-05 08:46:30.390569+02', NULL, 15, NULL, NULL);
INSERT INTO nom_objet (pk_nom_objet, nom, langue, notes, fk_objet, est_standard, date_creation, date_modification, fk_type_nom_param, date_debut, date_fin) VALUES (21, 'localiser', NULL, NULL, 22, true, '2015-10-05 08:48:23.727187+02', NULL, 15, NULL, NULL);
INSERT INTO nom_objet (pk_nom_objet, nom, langue, notes, fk_objet, est_standard, date_creation, date_modification, fk_type_nom_param, date_debut, date_fin) VALUES (22, 'naître', NULL, NULL, 23, true, '2015-10-05 08:59:20.720318+02', NULL, 15, NULL, NULL);
INSERT INTO nom_objet (pk_nom_objet, nom, langue, notes, fk_objet, est_standard, date_creation, date_modification, fk_type_nom_param, date_debut, date_fin) VALUES (14, 'Mathématicien', NULL, NULL, 16, true, '2015-10-03 09:57:19.385319+02', '2015-10-05 09:08:21.000977+02', 15, NULL, NULL);
INSERT INTO nom_objet (pk_nom_objet, nom, langue, notes, fk_objet, est_standard, date_creation, date_modification, fk_type_nom_param, date_debut, date_fin) VALUES (15, 'Nicolas Claude Fabri de Peiresc', NULL, NULL, 17, true, '2015-10-03 09:57:48.242165+02', '2015-10-05 13:51:05.754774+02', 15, NULL, NULL);
INSERT INTO nom_objet (pk_nom_objet, nom, langue, notes, fk_objet, est_standard, date_creation, date_modification, fk_type_nom_param, date_debut, date_fin) VALUES (13, 'Mathématiques', NULL, NULL, 15, true, '2015-10-02 23:54:54.414336+02', '2015-10-05 13:52:36.540175+02', 15, NULL, NULL);
INSERT INTO nom_objet (pk_nom_objet, nom, langue, notes, fk_objet, est_standard, date_creation, date_modification, fk_type_nom_param, date_debut, date_fin) VALUES (24, 'Astrologue', NULL, NULL, 25, true, '2015-10-06 04:36:45.268944+02', NULL, 15, NULL, NULL);
INSERT INTO nom_objet (pk_nom_objet, nom, langue, notes, fk_objet, est_standard, date_creation, date_modification, fk_type_nom_param, date_debut, date_fin) VALUES (23, 'Astronome', NULL, NULL, 24, true, '2015-10-06 04:31:50.321678+02', '2015-10-06 04:40:17.798511+02', 15, NULL, NULL);
INSERT INTO nom_objet (pk_nom_objet, nom, langue, notes, fk_objet, est_standard, date_creation, date_modification, fk_type_nom_param, date_debut, date_fin) VALUES (50, 'Giovanni Maria Bonardo', NULL, NULL, 840, true, '2015-11-06 16:04:13.593497+01', NULL, 15, NULL, NULL);
INSERT INTO nom_objet (pk_nom_objet, nom, langue, notes, fk_objet, est_standard, date_creation, date_modification, fk_type_nom_param, date_debut, date_fin) VALUES (51, 'John Flamsteed', NULL, NULL, 841, true, '2015-11-06 16:04:13.593497+01', NULL, 15, NULL, NULL);
INSERT INTO nom_objet (pk_nom_objet, nom, langue, notes, fk_objet, est_standard, date_creation, date_modification, fk_type_nom_param, date_debut, date_fin) VALUES (52, 'Nicolaas Hartsoeker', NULL, NULL, 842, true, '2015-11-06 16:04:13.593497+01', NULL, 15, NULL, NULL);
INSERT INTO nom_objet (pk_nom_objet, nom, langue, notes, fk_objet, est_standard, date_creation, date_modification, fk_type_nom_param, date_debut, date_fin) VALUES (25, 'Écrivain', NULL, NULL, 26, true, '2015-10-06 15:18:36.039768+02', NULL, 15, NULL, NULL);
INSERT INTO nom_objet (pk_nom_objet, nom, langue, notes, fk_objet, est_standard, date_creation, date_modification, fk_type_nom_param, date_debut, date_fin) VALUES (26, 'Grammairien', NULL, NULL, 27, true, '2015-10-06 22:29:01.129391+02', NULL, 15, NULL, NULL);
INSERT INTO nom_objet (pk_nom_objet, nom, langue, notes, fk_objet, est_standard, date_creation, date_modification, fk_type_nom_param, date_debut, date_fin) VALUES (27, 'Médecin', NULL, NULL, 28, true, '2015-10-06 22:31:41.356626+02', NULL, 15, NULL, NULL);
INSERT INTO nom_objet (pk_nom_objet, nom, langue, notes, fk_objet, est_standard, date_creation, date_modification, fk_type_nom_param, date_debut, date_fin) VALUES (28, 'Géographe', NULL, NULL, 29, true, '2015-10-06 22:43:37.318267+02', NULL, 15, NULL, NULL);
INSERT INTO nom_objet (pk_nom_objet, nom, langue, notes, fk_objet, est_standard, date_creation, date_modification, fk_type_nom_param, date_debut, date_fin) VALUES (53, 'Hector-Jean Legros', NULL, NULL, 843, true, '2015-11-06 16:04:13.593497+01', NULL, 15, NULL, NULL);
INSERT INTO nom_objet (pk_nom_objet, nom, langue, notes, fk_objet, est_standard, date_creation, date_modification, fk_type_nom_param, date_debut, date_fin) VALUES (54, 'Giammaria Ortes', NULL, NULL, 844, true, '2015-11-06 16:04:13.593497+01', NULL, 15, NULL, NULL);
INSERT INTO nom_objet (pk_nom_objet, nom, langue, notes, fk_objet, est_standard, date_creation, date_modification, fk_type_nom_param, date_debut, date_fin) VALUES (3, 'Notices tirées de la BNF', NULL, NULL, 5, true, '2015-09-26 10:20:04.358098+02', '2015-10-07 11:07:56.252943+02', 15, NULL, NULL);
INSERT INTO nom_objet (pk_nom_objet, nom, langue, notes, fk_objet, est_standard, date_creation, date_modification, fk_type_nom_param, date_debut, date_fin) VALUES (29, 'Nicolas Copernic', 'fra', NULL, 30, true, '2015-10-13 15:01:29.86825+02', '2015-10-13 15:06:25.611116+02', 15, NULL, NULL);
INSERT INTO nom_objet (pk_nom_objet, nom, langue, notes, fk_objet, est_standard, date_creation, date_modification, fk_type_nom_param, date_debut, date_fin) VALUES (30, 'Mikołaj Kopernik', 'pol', 'Vérifier le code du nom', 30, false, '2015-10-13 15:07:15.243613+02', NULL, 15, NULL, NULL);
INSERT INTO nom_objet (pk_nom_objet, nom, langue, notes, fk_objet, est_standard, date_creation, date_modification, fk_type_nom_param, date_debut, date_fin) VALUES (55, 'Jean de Murs', NULL, NULL, 845, true, '2015-11-06 16:04:13.593497+01', NULL, 15, NULL, NULL);
INSERT INTO nom_objet (pk_nom_objet, nom, langue, notes, fk_objet, est_standard, date_creation, date_modification, fk_type_nom_param, date_debut, date_fin) VALUES (56, 'Maḥmūd ibn Mas´ūd Quṭb al-Dīn al- Šīrāzī', NULL, NULL, 846, true, '2015-11-06 16:04:13.593497+01', NULL, 15, NULL, NULL);
INSERT INTO nom_objet (pk_nom_objet, nom, langue, notes, fk_objet, est_standard, date_creation, date_modification, fk_type_nom_param, date_debut, date_fin) VALUES (32, 'Maffeo Barberini', NULL, NULL, 31, false, '2015-10-13 15:12:33.247422+02', NULL, 15, NULL, '1623-08-05');
INSERT INTO nom_objet (pk_nom_objet, nom, langue, notes, fk_objet, est_standard, date_creation, date_modification, fk_type_nom_param, date_debut, date_fin) VALUES (31, 'Urbain VIII', NULL, NULL, 31, true, '2015-10-13 15:09:58.391533+02', '2015-10-13 15:13:25.58489+02', 12, '1623-08-06', NULL);
INSERT INTO nom_objet (pk_nom_objet, nom, langue, notes, fk_objet, est_standard, date_creation, date_modification, fk_type_nom_param, date_debut, date_fin) VALUES (33, 'Kepler [Texte imprimé] : la physique céleste : autour de l''"Astronomia Nova" (1609)
Les Belles Lettres / 2011', NULL, NULL, 32, true, '2015-10-13 15:37:11.24158+02', NULL, 15, NULL, NULL);
INSERT INTO nom_objet (pk_nom_objet, nom, langue, notes, fk_objet, est_standard, date_creation, date_modification, fk_type_nom_param, date_debut, date_fin) VALUES (34, 'Mes notes sur le livre : Kpler ...', NULL, NULL, 33, true, '2015-10-13 15:43:05.942249+02', NULL, 15, NULL, NULL);
INSERT INTO nom_objet (pk_nom_objet, nom, langue, notes, fk_objet, est_standard, date_creation, date_modification, fk_type_nom_param, date_debut, date_fin) VALUES (57, 'Marinus Ghetaldus', NULL, NULL, 847, true, '2015-11-06 16:04:13.593497+01', NULL, 15, NULL, NULL);
INSERT INTO nom_objet (pk_nom_objet, nom, langue, notes, fk_objet, est_standard, date_creation, date_modification, fk_type_nom_param, date_debut, date_fin) VALUES (58, 'Sybrandt Hansz. Cardinael', NULL, NULL, 848, true, '2015-11-06 16:04:13.593497+01', NULL, 15, NULL, NULL);
INSERT INTO nom_objet (pk_nom_objet, nom, langue, notes, fk_objet, est_standard, date_creation, date_modification, fk_type_nom_param, date_debut, date_fin) VALUES (59, 'Petrus Philomena de Dacia', NULL, NULL, 849, true, '2015-11-06 16:04:13.593497+01', NULL, 15, NULL, NULL);
INSERT INTO nom_objet (pk_nom_objet, nom, langue, notes, fk_objet, est_standard, date_creation, date_modification, fk_type_nom_param, date_debut, date_fin) VALUES (60, 'Jean Péna', NULL, NULL, 850, true, '2015-11-06 16:04:13.593497+01', NULL, 15, NULL, NULL);
INSERT INTO nom_objet (pk_nom_objet, nom, langue, notes, fk_objet, est_standard, date_creation, date_modification, fk_type_nom_param, date_debut, date_fin) VALUES (61, 'Blaise-François de Pagan', NULL, NULL, 851, true, '2015-11-06 16:04:13.593497+01', NULL, 15, NULL, NULL);
INSERT INTO nom_objet (pk_nom_objet, nom, langue, notes, fk_objet, est_standard, date_creation, date_modification, fk_type_nom_param, date_debut, date_fin) VALUES (62, 'al-Muẓaffar ibn Muḥammad Šaraf al-Dīn Ṭūsī', NULL, NULL, 852, true, '2015-11-06 16:04:13.593497+01', NULL, 15, NULL, NULL);
INSERT INTO nom_objet (pk_nom_objet, nom, langue, notes, fk_objet, est_standard, date_creation, date_modification, fk_type_nom_param, date_debut, date_fin) VALUES (63, 'Jean Tarde', NULL, NULL, 853, true, '2015-11-06 16:04:13.593497+01', NULL, 15, NULL, NULL);
INSERT INTO nom_objet (pk_nom_objet, nom, langue, notes, fk_objet, est_standard, date_creation, date_modification, fk_type_nom_param, date_debut, date_fin) VALUES (64, 'Carlos de Sigüenza y Góngora', NULL, NULL, 854, true, '2015-11-06 16:04:13.593497+01', NULL, 15, NULL, NULL);
INSERT INTO nom_objet (pk_nom_objet, nom, langue, notes, fk_objet, est_standard, date_creation, date_modification, fk_type_nom_param, date_debut, date_fin) VALUES (65, 'Girolamo Mercurio', NULL, NULL, 855, true, '2015-11-06 16:04:13.593497+01', NULL, 15, NULL, NULL);
INSERT INTO nom_objet (pk_nom_objet, nom, langue, notes, fk_objet, est_standard, date_creation, date_modification, fk_type_nom_param, date_debut, date_fin) VALUES (66, 'Arent Roggeveen', NULL, NULL, 856, true, '2015-11-06 16:04:13.593497+01', NULL, 15, NULL, NULL);
INSERT INTO nom_objet (pk_nom_objet, nom, langue, notes, fk_objet, est_standard, date_creation, date_modification, fk_type_nom_param, date_debut, date_fin) VALUES (67, 'Daniel Mögling', NULL, NULL, 857, true, '2015-11-06 16:04:13.593497+01', NULL, 15, NULL, NULL);
INSERT INTO nom_objet (pk_nom_objet, nom, langue, notes, fk_objet, est_standard, date_creation, date_modification, fk_type_nom_param, date_debut, date_fin) VALUES (68, 'Flecheux', NULL, NULL, 858, true, '2015-11-06 16:04:13.593497+01', NULL, 15, NULL, NULL);
INSERT INTO nom_objet (pk_nom_objet, nom, langue, notes, fk_objet, est_standard, date_creation, date_modification, fk_type_nom_param, date_debut, date_fin) VALUES (69, 'Pierre Petit', NULL, NULL, 859, true, '2015-11-06 16:04:13.593497+01', NULL, 15, NULL, NULL);
INSERT INTO nom_objet (pk_nom_objet, nom, langue, notes, fk_objet, est_standard, date_creation, date_modification, fk_type_nom_param, date_debut, date_fin) VALUES (70, 'Tommaso Cornelio', NULL, NULL, 860, true, '2015-11-06 16:04:13.593497+01', NULL, 15, NULL, NULL);
INSERT INTO nom_objet (pk_nom_objet, nom, langue, notes, fk_objet, est_standard, date_creation, date_modification, fk_type_nom_param, date_debut, date_fin) VALUES (71, 'Johann Faulhaber', NULL, NULL, 861, true, '2015-11-06 16:04:13.593497+01', NULL, 15, NULL, NULL);
INSERT INTO nom_objet (pk_nom_objet, nom, langue, notes, fk_objet, est_standard, date_creation, date_modification, fk_type_nom_param, date_debut, date_fin) VALUES (72, 'Alexandre Ruelle', NULL, NULL, 862, true, '2015-11-06 16:04:13.593497+01', NULL, 15, NULL, NULL);
INSERT INTO nom_objet (pk_nom_objet, nom, langue, notes, fk_objet, est_standard, date_creation, date_modification, fk_type_nom_param, date_debut, date_fin) VALUES (73, 'Brook Taylor', NULL, NULL, 863, true, '2015-11-06 16:04:13.593497+01', NULL, 15, NULL, NULL);
INSERT INTO nom_objet (pk_nom_objet, nom, langue, notes, fk_objet, est_standard, date_creation, date_modification, fk_type_nom_param, date_debut, date_fin) VALUES (74, 'Bernard Violle', NULL, NULL, 864, true, '2015-11-06 16:04:13.593497+01', NULL, 15, NULL, NULL);
INSERT INTO nom_objet (pk_nom_objet, nom, langue, notes, fk_objet, est_standard, date_creation, date_modification, fk_type_nom_param, date_debut, date_fin) VALUES (75, 'Francisco Zarzoso', NULL, NULL, 865, true, '2015-11-06 16:04:13.593497+01', NULL, 15, NULL, NULL);
INSERT INTO nom_objet (pk_nom_objet, nom, langue, notes, fk_objet, est_standard, date_creation, date_modification, fk_type_nom_param, date_debut, date_fin) VALUES (76, 'Pierre Gassendi', NULL, NULL, 866, true, '2015-11-06 16:04:13.593497+01', NULL, 15, NULL, NULL);
INSERT INTO nom_objet (pk_nom_objet, nom, langue, notes, fk_objet, est_standard, date_creation, date_modification, fk_type_nom_param, date_debut, date_fin) VALUES (77, 'Benedetto Castelli', NULL, NULL, 867, true, '2015-11-06 16:04:13.593497+01', NULL, 15, NULL, NULL);
INSERT INTO nom_objet (pk_nom_objet, nom, langue, notes, fk_objet, est_standard, date_creation, date_modification, fk_type_nom_param, date_debut, date_fin) VALUES (78, 'Charles Walmesley', NULL, NULL, 868, true, '2015-11-06 16:04:13.593497+01', NULL, 15, NULL, NULL);
INSERT INTO nom_objet (pk_nom_objet, nom, langue, notes, fk_objet, est_standard, date_creation, date_modification, fk_type_nom_param, date_debut, date_fin) VALUES (79, 'Johannes Hudde', NULL, NULL, 869, true, '2015-11-06 16:04:13.593497+01', NULL, 15, NULL, NULL);
INSERT INTO nom_objet (pk_nom_objet, nom, langue, notes, fk_objet, est_standard, date_creation, date_modification, fk_type_nom_param, date_debut, date_fin) VALUES (80, 'Giovanni Francesco Mauro Melchior Salvemini da Castiglione', NULL, NULL, 870, true, '2015-11-06 16:04:13.593497+01', NULL, 15, NULL, NULL);
INSERT INTO nom_objet (pk_nom_objet, nom, langue, notes, fk_objet, est_standard, date_creation, date_modification, fk_type_nom_param, date_debut, date_fin) VALUES (81, 'Henri Jurain', NULL, NULL, 871, true, '2015-11-06 16:04:13.593497+01', NULL, 15, NULL, NULL);
INSERT INTO nom_objet (pk_nom_objet, nom, langue, notes, fk_objet, est_standard, date_creation, date_modification, fk_type_nom_param, date_debut, date_fin) VALUES (82, 'Pierre de Fermat', NULL, NULL, 872, true, '2015-11-06 16:04:13.593497+01', NULL, 15, NULL, NULL);
INSERT INTO nom_objet (pk_nom_objet, nom, langue, notes, fk_objet, est_standard, date_creation, date_modification, fk_type_nom_param, date_debut, date_fin) VALUES (83, 'Philippus Lansbergen', NULL, NULL, 873, true, '2015-11-06 16:04:13.593497+01', NULL, 15, NULL, NULL);
INSERT INTO nom_objet (pk_nom_objet, nom, langue, notes, fk_objet, est_standard, date_creation, date_modification, fk_type_nom_param, date_debut, date_fin) VALUES (84, 'Le Demaine Godalles', NULL, NULL, 874, true, '2015-11-06 16:04:13.593497+01', NULL, 15, NULL, NULL);
INSERT INTO nom_objet (pk_nom_objet, nom, langue, notes, fk_objet, est_standard, date_creation, date_modification, fk_type_nom_param, date_debut, date_fin) VALUES (85, 'Jean-Jacques Dortous de Mairan', NULL, NULL, 875, true, '2015-11-06 16:04:13.593497+01', NULL, 15, NULL, NULL);
INSERT INTO nom_objet (pk_nom_objet, nom, langue, notes, fk_objet, est_standard, date_creation, date_modification, fk_type_nom_param, date_debut, date_fin) VALUES (86, 'Edme-Gilles Guyot', NULL, NULL, 876, true, '2015-11-06 16:04:13.593497+01', NULL, 15, NULL, NULL);
INSERT INTO nom_objet (pk_nom_objet, nom, langue, notes, fk_objet, est_standard, date_creation, date_modification, fk_type_nom_param, date_debut, date_fin) VALUES (87, 'Jordanus Nemorarius', NULL, NULL, 877, true, '2015-11-06 16:04:13.593497+01', NULL, 15, NULL, NULL);
INSERT INTO nom_objet (pk_nom_objet, nom, langue, notes, fk_objet, est_standard, date_creation, date_modification, fk_type_nom_param, date_debut, date_fin) VALUES (7, 'Résumé de la notice', NULL, NULL, 9, true, '2015-09-30 17:31:31.168992+02', '2015-11-09 19:05:25.836996+01', 15, NULL, NULL);
INSERT INTO nom_objet (pk_nom_objet, nom, langue, notes, fk_objet, est_standard, date_creation, date_modification, fk_type_nom_param, date_debut, date_fin) VALUES (2, 'Notices issues de fr.wikipedia', NULL, NULL, 3, true, '2015-09-25 22:44:01.114866+02', '2015-11-10 15:29:26.376954+01', 15, NULL, NULL);
INSERT INTO nom_objet (pk_nom_objet, nom, langue, notes, fk_objet, est_standard, date_creation, date_modification, fk_type_nom_param, date_debut, date_fin) VALUES (37, 'Notices BNF avec annotation sémantique', NULL, NULL, 36, true, '2015-11-05 22:03:44.180655+01', '2015-11-25 08:58:06.819811+01', 15, NULL, NULL);
INSERT INTO nom_objet (pk_nom_objet, nom, langue, notes, fk_objet, est_standard, date_creation, date_modification, fk_type_nom_param, date_debut, date_fin) VALUES (38, 'Notices BNF avec ''ud''', NULL, NULL, 37, true, '2015-11-05 22:11:29.331634+01', '2015-11-11 23:16:39.658673+01', 15, NULL, NULL);
INSERT INTO nom_objet (pk_nom_objet, nom, langue, notes, fk_objet, est_standard, date_creation, date_modification, fk_type_nom_param, date_debut, date_fin) VALUES (88, 'Paolo Mattia Doria', NULL, NULL, 878, true, '2015-11-06 16:04:13.593497+01', NULL, 15, NULL, NULL);
INSERT INTO nom_objet (pk_nom_objet, nom, langue, notes, fk_objet, est_standard, date_creation, date_modification, fk_type_nom_param, date_debut, date_fin) VALUES (89, 'Johann Jacob ScheuchzerZ', NULL, NULL, 879, true, '2015-11-06 16:04:13.593497+01', NULL, 15, NULL, NULL);
INSERT INTO nom_objet (pk_nom_objet, nom, langue, notes, fk_objet, est_standard, date_creation, date_modification, fk_type_nom_param, date_debut, date_fin) VALUES (90, 'Dominique-François Rivard', NULL, NULL, 880, true, '2015-11-06 16:04:13.593497+01', NULL, 15, NULL, NULL);
INSERT INTO nom_objet (pk_nom_objet, nom, langue, notes, fk_objet, est_standard, date_creation, date_modification, fk_type_nom_param, date_debut, date_fin) VALUES (91, 'Baien Miura', NULL, NULL, 881, true, '2015-11-06 16:04:13.593497+01', NULL, 15, NULL, NULL);
INSERT INTO nom_objet (pk_nom_objet, nom, langue, notes, fk_objet, est_standard, date_creation, date_modification, fk_type_nom_param, date_debut, date_fin) VALUES (92, 'Maximilian Rassler', NULL, NULL, 882, true, '2015-11-06 16:04:13.593497+01', NULL, 15, NULL, NULL);
INSERT INTO nom_objet (pk_nom_objet, nom, langue, notes, fk_objet, est_standard, date_creation, date_modification, fk_type_nom_param, date_debut, date_fin) VALUES (93, 'Emmanuel ben Jacob de Tarascon Bonfils', NULL, NULL, 883, true, '2015-11-06 16:04:13.593497+01', NULL, 15, NULL, NULL);
INSERT INTO nom_objet (pk_nom_objet, nom, langue, notes, fk_objet, est_standard, date_creation, date_modification, fk_type_nom_param, date_debut, date_fin) VALUES (94, 'Joseph-Nicolas Delisle', NULL, NULL, 884, true, '2015-11-06 16:04:13.593497+01', NULL, 15, NULL, NULL);
INSERT INTO nom_objet (pk_nom_objet, nom, langue, notes, fk_objet, est_standard, date_creation, date_modification, fk_type_nom_param, date_debut, date_fin) VALUES (95, 'Jérôme de La Lande', NULL, NULL, 885, true, '2015-11-06 16:04:13.593497+01', NULL, 15, NULL, NULL);
INSERT INTO nom_objet (pk_nom_objet, nom, langue, notes, fk_objet, est_standard, date_creation, date_modification, fk_type_nom_param, date_debut, date_fin) VALUES (96, 'Adam Lonicer', NULL, NULL, 886, true, '2015-11-06 16:04:13.593497+01', NULL, 15, NULL, NULL);
INSERT INTO nom_objet (pk_nom_objet, nom, langue, notes, fk_objet, est_standard, date_creation, date_modification, fk_type_nom_param, date_debut, date_fin) VALUES (97, 'Girolamo Donato', NULL, NULL, 887, true, '2015-11-06 16:04:13.593497+01', NULL, 15, NULL, NULL);
INSERT INTO nom_objet (pk_nom_objet, nom, langue, notes, fk_objet, est_standard, date_creation, date_modification, fk_type_nom_param, date_debut, date_fin) VALUES (98, 'Jean Borrel', NULL, NULL, 888, true, '2015-11-06 16:04:13.593497+01', NULL, 15, NULL, NULL);
INSERT INTO nom_objet (pk_nom_objet, nom, langue, notes, fk_objet, est_standard, date_creation, date_modification, fk_type_nom_param, date_debut, date_fin) VALUES (99, 'Tadeáš Hájek', NULL, NULL, 889, true, '2015-11-06 16:04:13.593497+01', NULL, 15, NULL, NULL);
INSERT INTO nom_objet (pk_nom_objet, nom, langue, notes, fk_objet, est_standard, date_creation, date_modification, fk_type_nom_param, date_debut, date_fin) VALUES (100, 'P. Jacques de Guernisac', NULL, NULL, 890, true, '2015-11-06 16:04:13.593497+01', NULL, 15, NULL, NULL);
INSERT INTO nom_objet (pk_nom_objet, nom, langue, notes, fk_objet, est_standard, date_creation, date_modification, fk_type_nom_param, date_debut, date_fin) VALUES (101, 'Nicola Spedalieri', NULL, NULL, 891, true, '2015-11-06 16:04:13.593497+01', NULL, 15, NULL, NULL);
INSERT INTO nom_objet (pk_nom_objet, nom, langue, notes, fk_objet, est_standard, date_creation, date_modification, fk_type_nom_param, date_debut, date_fin) VALUES (102, 'Gaspar Torrella', NULL, NULL, 892, true, '2015-11-06 16:04:13.593497+01', NULL, 15, NULL, NULL);
INSERT INTO nom_objet (pk_nom_objet, nom, langue, notes, fk_objet, est_standard, date_creation, date_modification, fk_type_nom_param, date_debut, date_fin) VALUES (103, 'Antoine Thomas', NULL, NULL, 893, true, '2015-11-06 16:04:13.593497+01', NULL, 15, NULL, NULL);
INSERT INTO nom_objet (pk_nom_objet, nom, langue, notes, fk_objet, est_standard, date_creation, date_modification, fk_type_nom_param, date_debut, date_fin) VALUES (104, 'Jean Glover', NULL, NULL, 894, true, '2015-11-06 16:04:13.593497+01', NULL, 15, NULL, NULL);
INSERT INTO nom_objet (pk_nom_objet, nom, langue, notes, fk_objet, est_standard, date_creation, date_modification, fk_type_nom_param, date_debut, date_fin) VALUES (105, 'Hui Yang', NULL, NULL, 895, true, '2015-11-06 16:04:13.593497+01', NULL, 15, NULL, NULL);
INSERT INTO nom_objet (pk_nom_objet, nom, langue, notes, fk_objet, est_standard, date_creation, date_modification, fk_type_nom_param, date_debut, date_fin) VALUES (106, 'Girolamo Francisco Cristiani', NULL, NULL, 896, true, '2015-11-06 16:04:13.593497+01', NULL, 15, NULL, NULL);
INSERT INTO nom_objet (pk_nom_objet, nom, langue, notes, fk_objet, est_standard, date_creation, date_modification, fk_type_nom_param, date_debut, date_fin) VALUES (107, 'Giovanni Agostino Abate', NULL, NULL, 897, true, '2015-11-06 16:04:13.593497+01', NULL, 15, NULL, NULL);
INSERT INTO nom_objet (pk_nom_objet, nom, langue, notes, fk_objet, est_standard, date_creation, date_modification, fk_type_nom_param, date_debut, date_fin) VALUES (108, 'Julien Mahuet', NULL, NULL, 898, true, '2015-11-06 16:04:13.593497+01', NULL, 15, NULL, NULL);
INSERT INTO nom_objet (pk_nom_objet, nom, langue, notes, fk_objet, est_standard, date_creation, date_modification, fk_type_nom_param, date_debut, date_fin) VALUES (109, 'Gaspard-Clair-François-Marie Riche de Prony', NULL, NULL, 899, true, '2015-11-06 16:04:13.593497+01', NULL, 15, NULL, NULL);
INSERT INTO nom_objet (pk_nom_objet, nom, langue, notes, fk_objet, est_standard, date_creation, date_modification, fk_type_nom_param, date_debut, date_fin) VALUES (110, 'Giuseppe Unicorno', NULL, NULL, 900, true, '2015-11-06 16:04:13.593497+01', NULL, 15, NULL, NULL);
INSERT INTO nom_objet (pk_nom_objet, nom, langue, notes, fk_objet, est_standard, date_creation, date_modification, fk_type_nom_param, date_debut, date_fin) VALUES (111, 'Petrus Apian', NULL, NULL, 901, true, '2015-11-06 16:04:13.593497+01', NULL, 15, NULL, NULL);
INSERT INTO nom_objet (pk_nom_objet, nom, langue, notes, fk_objet, est_standard, date_creation, date_modification, fk_type_nom_param, date_debut, date_fin) VALUES (112, 'Florimond de Beaune', NULL, NULL, 902, true, '2015-11-06 16:04:13.593497+01', NULL, 15, NULL, NULL);
INSERT INTO nom_objet (pk_nom_objet, nom, langue, notes, fk_objet, est_standard, date_creation, date_modification, fk_type_nom_param, date_debut, date_fin) VALUES (113, 'Johann Ludwig Levin Gebhardi', NULL, NULL, 903, true, '2015-11-06 16:04:13.593497+01', NULL, 15, NULL, NULL);
INSERT INTO nom_objet (pk_nom_objet, nom, langue, notes, fk_objet, est_standard, date_creation, date_modification, fk_type_nom_param, date_debut, date_fin) VALUES (114, 'Grégoire Chioniadès', NULL, NULL, 904, true, '2015-11-06 16:04:13.593497+01', NULL, 15, NULL, NULL);
INSERT INTO nom_objet (pk_nom_objet, nom, langue, notes, fk_objet, est_standard, date_creation, date_modification, fk_type_nom_param, date_debut, date_fin) VALUES (115, 'Guillaume Hobit', NULL, NULL, 905, true, '2015-11-06 16:04:13.593497+01', NULL, 15, NULL, NULL);
INSERT INTO nom_objet (pk_nom_objet, nom, langue, notes, fk_objet, est_standard, date_creation, date_modification, fk_type_nom_param, date_debut, date_fin) VALUES (116, 'Claude-François Berthelot', NULL, NULL, 906, true, '2015-11-06 16:04:13.593497+01', NULL, 15, NULL, NULL);
INSERT INTO nom_objet (pk_nom_objet, nom, langue, notes, fk_objet, est_standard, date_creation, date_modification, fk_type_nom_param, date_debut, date_fin) VALUES (117, 'William Bayly', NULL, NULL, 907, true, '2015-11-06 16:04:13.593497+01', NULL, 15, NULL, NULL);
INSERT INTO nom_objet (pk_nom_objet, nom, langue, notes, fk_objet, est_standard, date_creation, date_modification, fk_type_nom_param, date_debut, date_fin) VALUES (118, 'Stanislaw Wydra', NULL, NULL, 908, true, '2015-11-06 16:04:13.593497+01', NULL, 15, NULL, NULL);
INSERT INTO nom_objet (pk_nom_objet, nom, langue, notes, fk_objet, est_standard, date_creation, date_modification, fk_type_nom_param, date_debut, date_fin) VALUES (119, 'Andreas Osiander', NULL, NULL, 909, true, '2015-11-06 16:04:13.593497+01', NULL, 15, NULL, NULL);
INSERT INTO nom_objet (pk_nom_objet, nom, langue, notes, fk_objet, est_standard, date_creation, date_modification, fk_type_nom_param, date_debut, date_fin) VALUES (120, 'John Wallis', NULL, NULL, 910, true, '2015-11-06 16:04:13.593497+01', NULL, 15, NULL, NULL);
INSERT INTO nom_objet (pk_nom_objet, nom, langue, notes, fk_objet, est_standard, date_creation, date_modification, fk_type_nom_param, date_debut, date_fin) VALUES (121, 'Jacques Poitevin', NULL, NULL, 911, true, '2015-11-06 16:04:13.593497+01', NULL, 15, NULL, NULL);
INSERT INTO nom_objet (pk_nom_objet, nom, langue, notes, fk_objet, est_standard, date_creation, date_modification, fk_type_nom_param, date_debut, date_fin) VALUES (122, 'Démétrius Triclinius', NULL, NULL, 912, true, '2015-11-06 16:04:13.593497+01', NULL, 15, NULL, NULL);
INSERT INTO nom_objet (pk_nom_objet, nom, langue, notes, fk_objet, est_standard, date_creation, date_modification, fk_type_nom_param, date_debut, date_fin) VALUES (123, 'Petrus Van Musschenbroek', NULL, NULL, 913, true, '2015-11-06 16:04:13.593497+01', NULL, 15, NULL, NULL);
INSERT INTO nom_objet (pk_nom_objet, nom, langue, notes, fk_objet, est_standard, date_creation, date_modification, fk_type_nom_param, date_debut, date_fin) VALUES (124, 'Pierre Méchain', NULL, NULL, 914, true, '2015-11-06 16:04:13.593497+01', NULL, 15, NULL, NULL);
INSERT INTO nom_objet (pk_nom_objet, nom, langue, notes, fk_objet, est_standard, date_creation, date_modification, fk_type_nom_param, date_debut, date_fin) VALUES (125, 'François-Joachim Duport-Dutertre', NULL, NULL, 915, true, '2015-11-06 16:04:13.593497+01', NULL, 15, NULL, NULL);
INSERT INTO nom_objet (pk_nom_objet, nom, langue, notes, fk_objet, est_standard, date_creation, date_modification, fk_type_nom_param, date_debut, date_fin) VALUES (126, 'Giovanni Bianchi', NULL, NULL, 916, true, '2015-11-06 16:04:13.593497+01', NULL, 15, NULL, NULL);
INSERT INTO nom_objet (pk_nom_objet, nom, langue, notes, fk_objet, est_standard, date_creation, date_modification, fk_type_nom_param, date_debut, date_fin) VALUES (127, 'Guillaume de Nautonier', NULL, NULL, 917, true, '2015-11-06 16:04:13.593497+01', NULL, 15, NULL, NULL);
INSERT INTO nom_objet (pk_nom_objet, nom, langue, notes, fk_objet, est_standard, date_creation, date_modification, fk_type_nom_param, date_debut, date_fin) VALUES (128, 'Alexis Claude Clairaut', NULL, NULL, 918, true, '2015-11-06 16:04:13.593497+01', NULL, 15, NULL, NULL);
INSERT INTO nom_objet (pk_nom_objet, nom, langue, notes, fk_objet, est_standard, date_creation, date_modification, fk_type_nom_param, date_debut, date_fin) VALUES (129, 'Johann Schöner', NULL, NULL, 919, true, '2015-11-06 16:04:13.593497+01', NULL, 15, NULL, NULL);
INSERT INTO nom_objet (pk_nom_objet, nom, langue, notes, fk_objet, est_standard, date_creation, date_modification, fk_type_nom_param, date_debut, date_fin) VALUES (130, 'Giovanni Antonio Magini', NULL, NULL, 920, true, '2015-11-06 16:04:13.593497+01', NULL, 15, NULL, NULL);
INSERT INTO nom_objet (pk_nom_objet, nom, langue, notes, fk_objet, est_standard, date_creation, date_modification, fk_type_nom_param, date_debut, date_fin) VALUES (131, 'Francesco Ottavio Magnocavalli', NULL, NULL, 921, true, '2015-11-06 16:04:13.593497+01', NULL, 15, NULL, NULL);
INSERT INTO nom_objet (pk_nom_objet, nom, langue, notes, fk_objet, est_standard, date_creation, date_modification, fk_type_nom_param, date_debut, date_fin) VALUES (132, 'Charles-Marie de La Condamine', NULL, NULL, 922, true, '2015-11-06 16:04:13.593497+01', NULL, 15, NULL, NULL);
INSERT INTO nom_objet (pk_nom_objet, nom, langue, notes, fk_objet, est_standard, date_creation, date_modification, fk_type_nom_param, date_debut, date_fin) VALUES (133, 'Andalò Di Negro', NULL, NULL, 923, true, '2015-11-06 16:04:13.593497+01', NULL, 15, NULL, NULL);
INSERT INTO nom_objet (pk_nom_objet, nom, langue, notes, fk_objet, est_standard, date_creation, date_modification, fk_type_nom_param, date_debut, date_fin) VALUES (134, 'Bhāskarācārya', NULL, NULL, 924, true, '2015-11-06 16:04:13.593497+01', NULL, 15, NULL, NULL);
INSERT INTO nom_objet (pk_nom_objet, nom, langue, notes, fk_objet, est_standard, date_creation, date_modification, fk_type_nom_param, date_debut, date_fin) VALUES (135, 'Thomas Bugge', NULL, NULL, 925, true, '2015-11-06 16:04:13.593497+01', NULL, 15, NULL, NULL);
INSERT INTO nom_objet (pk_nom_objet, nom, langue, notes, fk_objet, est_standard, date_creation, date_modification, fk_type_nom_param, date_debut, date_fin) VALUES (136, 'Pierre Bardin', NULL, NULL, 926, true, '2015-11-06 16:04:13.593497+01', NULL, 15, NULL, NULL);
INSERT INTO nom_objet (pk_nom_objet, nom, langue, notes, fk_objet, est_standard, date_creation, date_modification, fk_type_nom_param, date_debut, date_fin) VALUES (137, 'John Flamsteed', NULL, NULL, 927, true, '2015-11-06 16:04:13.593497+01', NULL, 15, NULL, NULL);
INSERT INTO nom_objet (pk_nom_objet, nom, langue, notes, fk_objet, est_standard, date_creation, date_modification, fk_type_nom_param, date_debut, date_fin) VALUES (138, 'Michel Mourgues', NULL, NULL, 928, true, '2015-11-06 16:04:13.593497+01', NULL, 15, NULL, NULL);
INSERT INTO nom_objet (pk_nom_objet, nom, langue, notes, fk_objet, est_standard, date_creation, date_modification, fk_type_nom_param, date_debut, date_fin) VALUES (139, 'Vérologue', NULL, NULL, 929, true, '2015-11-06 16:04:13.593497+01', NULL, 15, NULL, NULL);
INSERT INTO nom_objet (pk_nom_objet, nom, langue, notes, fk_objet, est_standard, date_creation, date_modification, fk_type_nom_param, date_debut, date_fin) VALUES (140, 'Carl-Christian von Langsdorf', NULL, NULL, 930, true, '2015-11-06 16:04:13.593497+01', NULL, 15, NULL, NULL);
INSERT INTO nom_objet (pk_nom_objet, nom, langue, notes, fk_objet, est_standard, date_creation, date_modification, fk_type_nom_param, date_debut, date_fin) VALUES (141, 'Georg Jonathan von Holland', NULL, NULL, 931, true, '2015-11-06 16:04:13.593497+01', NULL, 15, NULL, NULL);
INSERT INTO nom_objet (pk_nom_objet, nom, langue, notes, fk_objet, est_standard, date_creation, date_modification, fk_type_nom_param, date_debut, date_fin) VALUES (142, 'Christian Wolff', NULL, NULL, 932, true, '2015-11-06 16:04:13.593497+01', NULL, 15, NULL, NULL);
INSERT INTO nom_objet (pk_nom_objet, nom, langue, notes, fk_objet, est_standard, date_creation, date_modification, fk_type_nom_param, date_debut, date_fin) VALUES (143, 'Alessandro Marchetti', NULL, NULL, 933, true, '2015-11-06 16:04:13.593497+01', NULL, 15, NULL, NULL);
INSERT INTO nom_objet (pk_nom_objet, nom, langue, notes, fk_objet, est_standard, date_creation, date_modification, fk_type_nom_param, date_debut, date_fin) VALUES (144, 'Willem Gilliszoon', NULL, NULL, 934, true, '2015-11-06 16:04:13.593497+01', NULL, 15, NULL, NULL);
INSERT INTO nom_objet (pk_nom_objet, nom, langue, notes, fk_objet, est_standard, date_creation, date_modification, fk_type_nom_param, date_debut, date_fin) VALUES (145, 'Pierre Joseph de Rivaz', NULL, NULL, 935, true, '2015-11-06 16:04:13.593497+01', NULL, 15, NULL, NULL);
INSERT INTO nom_objet (pk_nom_objet, nom, langue, notes, fk_objet, est_standard, date_creation, date_modification, fk_type_nom_param, date_debut, date_fin) VALUES (146, 'Juanelo Turriano', NULL, NULL, 936, true, '2015-11-06 16:04:13.593497+01', NULL, 15, NULL, NULL);
INSERT INTO nom_objet (pk_nom_objet, nom, langue, notes, fk_objet, est_standard, date_creation, date_modification, fk_type_nom_param, date_debut, date_fin) VALUES (147, 'Johann Tobias Mayer', NULL, NULL, 937, true, '2015-11-06 16:04:13.593497+01', NULL, 15, NULL, NULL);
INSERT INTO nom_objet (pk_nom_objet, nom, langue, notes, fk_objet, est_standard, date_creation, date_modification, fk_type_nom_param, date_debut, date_fin) VALUES (148, 'Christiaan Huygens', NULL, NULL, 938, true, '2015-11-06 16:04:13.593497+01', NULL, 15, NULL, NULL);
INSERT INTO nom_objet (pk_nom_objet, nom, langue, notes, fk_objet, est_standard, date_creation, date_modification, fk_type_nom_param, date_debut, date_fin) VALUES (149, 'Ignace-Gaston Pardies', NULL, NULL, 939, true, '2015-11-06 16:04:13.593497+01', NULL, 15, NULL, NULL);
INSERT INTO nom_objet (pk_nom_objet, nom, langue, notes, fk_objet, est_standard, date_creation, date_modification, fk_type_nom_param, date_debut, date_fin) VALUES (150, 'John Keill', NULL, NULL, 940, true, '2015-11-06 16:04:13.593497+01', NULL, 15, NULL, NULL);
INSERT INTO nom_objet (pk_nom_objet, nom, langue, notes, fk_objet, est_standard, date_creation, date_modification, fk_type_nom_param, date_debut, date_fin) VALUES (151, 'Adam Adamady Kochánski', NULL, NULL, 941, true, '2015-11-06 16:04:13.593497+01', NULL, 15, NULL, NULL);
INSERT INTO nom_objet (pk_nom_objet, nom, langue, notes, fk_objet, est_standard, date_creation, date_modification, fk_type_nom_param, date_debut, date_fin) VALUES (152, 'Prospero Calano', NULL, NULL, 942, true, '2015-11-06 16:04:13.593497+01', NULL, 15, NULL, NULL);
INSERT INTO nom_objet (pk_nom_objet, nom, langue, notes, fk_objet, est_standard, date_creation, date_modification, fk_type_nom_param, date_debut, date_fin) VALUES (153, 'Jacob Golius', NULL, NULL, 943, true, '2015-11-06 16:04:13.593497+01', NULL, 15, NULL, NULL);
INSERT INTO nom_objet (pk_nom_objet, nom, langue, notes, fk_objet, est_standard, date_creation, date_modification, fk_type_nom_param, date_debut, date_fin) VALUES (154, 'Jean Le Febvre', NULL, NULL, 944, true, '2015-11-06 16:04:13.593497+01', NULL, 15, NULL, NULL);
INSERT INTO nom_objet (pk_nom_objet, nom, langue, notes, fk_objet, est_standard, date_creation, date_modification, fk_type_nom_param, date_debut, date_fin) VALUES (155, 'Josse Clicthove', NULL, NULL, 945, true, '2015-11-06 16:04:13.593497+01', NULL, 15, NULL, NULL);
INSERT INTO nom_objet (pk_nom_objet, nom, langue, notes, fk_objet, est_standard, date_creation, date_modification, fk_type_nom_param, date_debut, date_fin) VALUES (156, 'Jean Bertet', NULL, NULL, 946, true, '2015-11-06 16:04:13.593497+01', NULL, 15, NULL, NULL);
INSERT INTO nom_objet (pk_nom_objet, nom, langue, notes, fk_objet, est_standard, date_creation, date_modification, fk_type_nom_param, date_debut, date_fin) VALUES (157, 'Charles Bossut', NULL, NULL, 947, true, '2015-11-06 16:04:13.593497+01', NULL, 15, NULL, NULL);
INSERT INTO nom_objet (pk_nom_objet, nom, langue, notes, fk_objet, est_standard, date_creation, date_modification, fk_type_nom_param, date_debut, date_fin) VALUES (158, 'François Gattey', NULL, NULL, 948, true, '2015-11-06 16:04:13.593497+01', NULL, 15, NULL, NULL);
INSERT INTO nom_objet (pk_nom_objet, nom, langue, notes, fk_objet, est_standard, date_creation, date_modification, fk_type_nom_param, date_debut, date_fin) VALUES (159, 'Francisco Sánchez', NULL, NULL, 949, true, '2015-11-06 16:04:13.593497+01', NULL, 15, NULL, NULL);
INSERT INTO nom_objet (pk_nom_objet, nom, langue, notes, fk_objet, est_standard, date_creation, date_modification, fk_type_nom_param, date_debut, date_fin) VALUES (160, 'Étienne-Simon de Gamaches', NULL, NULL, 950, true, '2015-11-06 16:04:13.593497+01', NULL, 15, NULL, NULL);
INSERT INTO nom_objet (pk_nom_objet, nom, langue, notes, fk_objet, est_standard, date_creation, date_modification, fk_type_nom_param, date_debut, date_fin) VALUES (161, 'Anthoine Cathalan', NULL, NULL, 951, true, '2015-11-06 16:04:13.593497+01', NULL, 15, NULL, NULL);
INSERT INTO nom_objet (pk_nom_objet, nom, langue, notes, fk_objet, est_standard, date_creation, date_modification, fk_type_nom_param, date_debut, date_fin) VALUES (162, 'Antonio Eximeno', NULL, NULL, 952, true, '2015-11-06 16:04:13.593497+01', NULL, 15, NULL, NULL);
INSERT INTO nom_objet (pk_nom_objet, nom, langue, notes, fk_objet, est_standard, date_creation, date_modification, fk_type_nom_param, date_debut, date_fin) VALUES (163, 'Simon Stevin', NULL, NULL, 953, true, '2015-11-06 16:04:13.593497+01', NULL, 15, NULL, NULL);
INSERT INTO nom_objet (pk_nom_objet, nom, langue, notes, fk_objet, est_standard, date_creation, date_modification, fk_type_nom_param, date_debut, date_fin) VALUES (164, 'Jonas Moore', NULL, NULL, 954, true, '2015-11-06 16:04:13.593497+01', NULL, 15, NULL, NULL);
INSERT INTO nom_objet (pk_nom_objet, nom, langue, notes, fk_objet, est_standard, date_creation, date_modification, fk_type_nom_param, date_debut, date_fin) VALUES (165, 'Leonhard Christoph Sturm', NULL, NULL, 955, true, '2015-11-06 16:04:13.593497+01', NULL, 15, NULL, NULL);
INSERT INTO nom_objet (pk_nom_objet, nom, langue, notes, fk_objet, est_standard, date_creation, date_modification, fk_type_nom_param, date_debut, date_fin) VALUES (166, 'J.-B.-M. Duprat', NULL, NULL, 956, true, '2015-11-06 16:04:13.593497+01', NULL, 15, NULL, NULL);
INSERT INTO nom_objet (pk_nom_objet, nom, langue, notes, fk_objet, est_standard, date_creation, date_modification, fk_type_nom_param, date_debut, date_fin) VALUES (167, 'Johann Georg Locher', NULL, NULL, 957, true, '2015-11-06 16:04:13.593497+01', NULL, 15, NULL, NULL);
INSERT INTO nom_objet (pk_nom_objet, nom, langue, notes, fk_objet, est_standard, date_creation, date_modification, fk_type_nom_param, date_debut, date_fin) VALUES (168, 'Olaf Söderberg', NULL, NULL, 958, true, '2015-11-06 16:04:13.593497+01', NULL, 15, NULL, NULL);
INSERT INTO nom_objet (pk_nom_objet, nom, langue, notes, fk_objet, est_standard, date_creation, date_modification, fk_type_nom_param, date_debut, date_fin) VALUES (169, 'Galileo Galilei', NULL, NULL, 959, true, '2015-11-06 16:04:13.593497+01', NULL, 15, NULL, NULL);
INSERT INTO nom_objet (pk_nom_objet, nom, langue, notes, fk_objet, est_standard, date_creation, date_modification, fk_type_nom_param, date_debut, date_fin) VALUES (170, 'Nicolas Leverdé', NULL, NULL, 960, true, '2015-11-06 16:04:13.593497+01', NULL, 15, NULL, NULL);
INSERT INTO nom_objet (pk_nom_objet, nom, langue, notes, fk_objet, est_standard, date_creation, date_modification, fk_type_nom_param, date_debut, date_fin) VALUES (171, 'Girolamo Francastoro', NULL, NULL, 961, true, '2015-11-06 16:04:13.593497+01', NULL, 15, NULL, NULL);
INSERT INTO nom_objet (pk_nom_objet, nom, langue, notes, fk_objet, est_standard, date_creation, date_modification, fk_type_nom_param, date_debut, date_fin) VALUES (172, 'Pierre-Charles Le Monnier', NULL, NULL, 962, true, '2015-11-06 16:04:13.593497+01', NULL, 15, NULL, NULL);
INSERT INTO nom_objet (pk_nom_objet, nom, langue, notes, fk_objet, est_standard, date_creation, date_modification, fk_type_nom_param, date_debut, date_fin) VALUES (173, 'Georgius de Hungaria', NULL, NULL, 963, true, '2015-11-06 16:04:13.593497+01', NULL, 15, NULL, NULL);
INSERT INTO nom_objet (pk_nom_objet, nom, langue, notes, fk_objet, est_standard, date_creation, date_modification, fk_type_nom_param, date_debut, date_fin) VALUES (174, 'Gilles Personne de Roberval', NULL, NULL, 964, true, '2015-11-06 16:04:13.593497+01', NULL, 15, NULL, NULL);
INSERT INTO nom_objet (pk_nom_objet, nom, langue, notes, fk_objet, est_standard, date_creation, date_modification, fk_type_nom_param, date_debut, date_fin) VALUES (175, 'Giovanni Battista Crispo', NULL, NULL, 965, true, '2015-11-06 16:04:13.593497+01', NULL, 15, NULL, NULL);
INSERT INTO nom_objet (pk_nom_objet, nom, langue, notes, fk_objet, est_standard, date_creation, date_modification, fk_type_nom_param, date_debut, date_fin) VALUES (176, 'Philippe Desplaces', NULL, NULL, 966, true, '2015-11-06 16:04:13.593497+01', NULL, 15, NULL, NULL);
INSERT INTO nom_objet (pk_nom_objet, nom, langue, notes, fk_objet, est_standard, date_creation, date_modification, fk_type_nom_param, date_debut, date_fin) VALUES (177, 'Tobias Mayer', NULL, NULL, 967, true, '2015-11-06 16:04:13.593497+01', NULL, 15, NULL, NULL);
INSERT INTO nom_objet (pk_nom_objet, nom, langue, notes, fk_objet, est_standard, date_creation, date_modification, fk_type_nom_param, date_debut, date_fin) VALUES (178, 'Laura Bassi', NULL, NULL, 968, true, '2015-11-06 16:04:13.593497+01', NULL, 15, NULL, NULL);
INSERT INTO nom_objet (pk_nom_objet, nom, langue, notes, fk_objet, est_standard, date_creation, date_modification, fk_type_nom_param, date_debut, date_fin) VALUES (179, 'Garcia da Orta', NULL, NULL, 969, true, '2015-11-06 16:04:13.593497+01', NULL, 15, NULL, NULL);
INSERT INTO nom_objet (pk_nom_objet, nom, langue, notes, fk_objet, est_standard, date_creation, date_modification, fk_type_nom_param, date_debut, date_fin) VALUES (180, 'Jean de Seville', NULL, NULL, 970, true, '2015-11-06 16:04:13.593497+01', NULL, 15, NULL, NULL);
INSERT INTO nom_objet (pk_nom_objet, nom, langue, notes, fk_objet, est_standard, date_creation, date_modification, fk_type_nom_param, date_debut, date_fin) VALUES (181, 'Andrea Argoli', NULL, NULL, 971, true, '2015-11-06 16:04:13.593497+01', NULL, 15, NULL, NULL);
INSERT INTO nom_objet (pk_nom_objet, nom, langue, notes, fk_objet, est_standard, date_creation, date_modification, fk_type_nom_param, date_debut, date_fin) VALUES (182, 'Antoine Gaubil', NULL, NULL, 972, true, '2015-11-06 16:04:13.593497+01', NULL, 15, NULL, NULL);
INSERT INTO nom_objet (pk_nom_objet, nom, langue, notes, fk_objet, est_standard, date_creation, date_modification, fk_type_nom_param, date_debut, date_fin) VALUES (183, 'Claude-François Guillemeau de Fréval', NULL, NULL, 973, true, '2015-11-06 16:04:13.593497+01', NULL, 15, NULL, NULL);
INSERT INTO nom_objet (pk_nom_objet, nom, langue, notes, fk_objet, est_standard, date_creation, date_modification, fk_type_nom_param, date_debut, date_fin) VALUES (184, 'Philippe Avril', NULL, NULL, 974, true, '2015-11-06 16:04:13.593497+01', NULL, 15, NULL, NULL);
INSERT INTO nom_objet (pk_nom_objet, nom, langue, notes, fk_objet, est_standard, date_creation, date_modification, fk_type_nom_param, date_debut, date_fin) VALUES (185, 'Johann Jakob Zimmermann', NULL, NULL, 975, true, '2015-11-06 16:04:13.593497+01', NULL, 15, NULL, NULL);
INSERT INTO nom_objet (pk_nom_objet, nom, langue, notes, fk_objet, est_standard, date_creation, date_modification, fk_type_nom_param, date_debut, date_fin) VALUES (186, 'Caspar Wessel', NULL, NULL, 976, true, '2015-11-06 16:04:13.593497+01', NULL, 15, NULL, NULL);
INSERT INTO nom_objet (pk_nom_objet, nom, langue, notes, fk_objet, est_standard, date_creation, date_modification, fk_type_nom_param, date_debut, date_fin) VALUES (187, 'Christophorus Clavius', NULL, NULL, 977, true, '2015-11-06 16:04:13.593497+01', NULL, 15, NULL, NULL);
INSERT INTO nom_objet (pk_nom_objet, nom, langue, notes, fk_objet, est_standard, date_creation, date_modification, fk_type_nom_param, date_debut, date_fin) VALUES (188, 'Georg Wolfgang Krafft', NULL, NULL, 978, true, '2015-11-06 16:04:13.593497+01', NULL, 15, NULL, NULL);
INSERT INTO nom_objet (pk_nom_objet, nom, langue, notes, fk_objet, est_standard, date_creation, date_modification, fk_type_nom_param, date_debut, date_fin) VALUES (189, 'Thomas Fantet de Lagny', NULL, NULL, 979, true, '2015-11-06 16:04:13.593497+01', NULL, 15, NULL, NULL);
INSERT INTO nom_objet (pk_nom_objet, nom, langue, notes, fk_objet, est_standard, date_creation, date_modification, fk_type_nom_param, date_debut, date_fin) VALUES (190, 'James Dodson', NULL, NULL, 980, true, '2015-11-06 16:04:13.593497+01', NULL, 15, NULL, NULL);
INSERT INTO nom_objet (pk_nom_objet, nom, langue, notes, fk_objet, est_standard, date_creation, date_modification, fk_type_nom_param, date_debut, date_fin) VALUES (191, 'Jacques Peletier', NULL, NULL, 981, true, '2015-11-06 16:04:13.593497+01', NULL, 15, NULL, NULL);
INSERT INTO nom_objet (pk_nom_objet, nom, langue, notes, fk_objet, est_standard, date_creation, date_modification, fk_type_nom_param, date_debut, date_fin) VALUES (192, 'Pierre Le Voirier', NULL, NULL, 982, true, '2015-11-06 16:04:13.593497+01', NULL, 15, NULL, NULL);
INSERT INTO nom_objet (pk_nom_objet, nom, langue, notes, fk_objet, est_standard, date_creation, date_modification, fk_type_nom_param, date_debut, date_fin) VALUES (193, 'Pierre Bourdin', NULL, NULL, 983, true, '2015-11-06 16:04:13.593497+01', NULL, 15, NULL, NULL);
INSERT INTO nom_objet (pk_nom_objet, nom, langue, notes, fk_objet, est_standard, date_creation, date_modification, fk_type_nom_param, date_debut, date_fin) VALUES (194, 'Eliya Delmedigo', NULL, NULL, 984, true, '2015-11-06 16:04:13.593497+01', NULL, 15, NULL, NULL);
INSERT INTO nom_objet (pk_nom_objet, nom, langue, notes, fk_objet, est_standard, date_creation, date_modification, fk_type_nom_param, date_debut, date_fin) VALUES (195, 'Giordano Riccati', NULL, NULL, 985, true, '2015-11-06 16:04:13.593497+01', NULL, 15, NULL, NULL);
INSERT INTO nom_objet (pk_nom_objet, nom, langue, notes, fk_objet, est_standard, date_creation, date_modification, fk_type_nom_param, date_debut, date_fin) VALUES (196, 'Jacques-André Mallet', NULL, NULL, 986, true, '2015-11-06 16:04:13.593497+01', NULL, 15, NULL, NULL);
INSERT INTO nom_objet (pk_nom_objet, nom, langue, notes, fk_objet, est_standard, date_creation, date_modification, fk_type_nom_param, date_debut, date_fin) VALUES (197, 'Witelo', NULL, NULL, 987, true, '2015-11-06 16:04:13.593497+01', NULL, 15, NULL, NULL);
INSERT INTO nom_objet (pk_nom_objet, nom, langue, notes, fk_objet, est_standard, date_creation, date_modification, fk_type_nom_param, date_debut, date_fin) VALUES (198, 'Hermann Witekind', NULL, NULL, 988, true, '2015-11-06 16:04:13.593497+01', NULL, 15, NULL, NULL);
INSERT INTO nom_objet (pk_nom_objet, nom, langue, notes, fk_objet, est_standard, date_creation, date_modification, fk_type_nom_param, date_debut, date_fin) VALUES (199, 'Giovanni Paolo Gallucci', NULL, NULL, 989, true, '2015-11-06 16:04:13.593497+01', NULL, 15, NULL, NULL);
INSERT INTO nom_objet (pk_nom_objet, nom, langue, notes, fk_objet, est_standard, date_creation, date_modification, fk_type_nom_param, date_debut, date_fin) VALUES (200, 'Jacques Audierne', NULL, NULL, 990, true, '2015-11-06 16:04:13.593497+01', NULL, 15, NULL, NULL);
INSERT INTO nom_objet (pk_nom_objet, nom, langue, notes, fk_objet, est_standard, date_creation, date_modification, fk_type_nom_param, date_debut, date_fin) VALUES (201, 'Vincenzo Chiminello', NULL, NULL, 991, true, '2015-11-06 16:04:13.593497+01', NULL, 15, NULL, NULL);
INSERT INTO nom_objet (pk_nom_objet, nom, langue, notes, fk_objet, est_standard, date_creation, date_modification, fk_type_nom_param, date_debut, date_fin) VALUES (202, 'Caspar Dauthendey', NULL, NULL, 992, true, '2015-11-06 16:04:13.593497+01', NULL, 15, NULL, NULL);
INSERT INTO nom_objet (pk_nom_objet, nom, langue, notes, fk_objet, est_standard, date_creation, date_modification, fk_type_nom_param, date_debut, date_fin) VALUES (203, 'Edward Brerewood', NULL, NULL, 993, true, '2015-11-06 16:04:13.593497+01', NULL, 15, NULL, NULL);
INSERT INTO nom_objet (pk_nom_objet, nom, langue, notes, fk_objet, est_standard, date_creation, date_modification, fk_type_nom_param, date_debut, date_fin) VALUES (204, 'Nicolas-Antoine Nouet', NULL, NULL, 994, true, '2015-11-06 16:04:13.593497+01', NULL, 15, NULL, NULL);
INSERT INTO nom_objet (pk_nom_objet, nom, langue, notes, fk_objet, est_standard, date_creation, date_modification, fk_type_nom_param, date_debut, date_fin) VALUES (205, 'Francesco Maria Grimaldi', NULL, NULL, 995, true, '2015-11-06 16:04:13.593497+01', NULL, 15, NULL, NULL);
INSERT INTO nom_objet (pk_nom_objet, nom, langue, notes, fk_objet, est_standard, date_creation, date_modification, fk_type_nom_param, date_debut, date_fin) VALUES (206, 'Jacopo Belgrado', NULL, NULL, 996, true, '2015-11-06 16:04:13.593497+01', NULL, 15, NULL, NULL);
INSERT INTO nom_objet (pk_nom_objet, nom, langue, notes, fk_objet, est_standard, date_creation, date_modification, fk_type_nom_param, date_debut, date_fin) VALUES (207, 'Giuseppe Piazzi', NULL, NULL, 997, true, '2015-11-06 16:04:13.593497+01', NULL, 15, NULL, NULL);
INSERT INTO nom_objet (pk_nom_objet, nom, langue, notes, fk_objet, est_standard, date_creation, date_modification, fk_type_nom_param, date_debut, date_fin) VALUES (208, 'Joseph-Louis Lagrange', NULL, NULL, 998, true, '2015-11-06 16:04:13.593497+01', NULL, 15, NULL, NULL);
INSERT INTO nom_objet (pk_nom_objet, nom, langue, notes, fk_objet, est_standard, date_creation, date_modification, fk_type_nom_param, date_debut, date_fin) VALUES (209, 'Johannes Dryander', NULL, NULL, 999, true, '2015-11-06 16:04:13.593497+01', NULL, 15, NULL, NULL);
INSERT INTO nom_objet (pk_nom_objet, nom, langue, notes, fk_objet, est_standard, date_creation, date_modification, fk_type_nom_param, date_debut, date_fin) VALUES (210, 'Julius Reichelt', NULL, NULL, 1000, true, '2015-11-06 16:04:13.593497+01', NULL, 15, NULL, NULL);
INSERT INTO nom_objet (pk_nom_objet, nom, langue, notes, fk_objet, est_standard, date_creation, date_modification, fk_type_nom_param, date_debut, date_fin) VALUES (211, 'Guillaume Le Blond', NULL, NULL, 1001, true, '2015-11-06 16:04:13.593497+01', NULL, 15, NULL, NULL);
INSERT INTO nom_objet (pk_nom_objet, nom, langue, notes, fk_objet, est_standard, date_creation, date_modification, fk_type_nom_param, date_debut, date_fin) VALUES (212, 'Jean-Baptiste Pérès', NULL, NULL, 1002, true, '2015-11-06 16:04:13.593497+01', NULL, 15, NULL, NULL);
INSERT INTO nom_objet (pk_nom_objet, nom, langue, notes, fk_objet, est_standard, date_creation, date_modification, fk_type_nom_param, date_debut, date_fin) VALUES (213, 'Gaetano Del Ricco', NULL, NULL, 1003, true, '2015-11-06 16:04:13.593497+01', NULL, 15, NULL, NULL);
INSERT INTO nom_objet (pk_nom_objet, nom, langue, notes, fk_objet, est_standard, date_creation, date_modification, fk_type_nom_param, date_debut, date_fin) VALUES (214, 'Nicodemus Frischlin', NULL, NULL, 1004, true, '2015-11-06 16:04:13.593497+01', NULL, 15, NULL, NULL);
INSERT INTO nom_objet (pk_nom_objet, nom, langue, notes, fk_objet, est_standard, date_creation, date_modification, fk_type_nom_param, date_debut, date_fin) VALUES (215, 'Johann Stöffler', NULL, NULL, 1005, true, '2015-11-06 16:04:13.593497+01', NULL, 15, NULL, NULL);
INSERT INTO nom_objet (pk_nom_objet, nom, langue, notes, fk_objet, est_standard, date_creation, date_modification, fk_type_nom_param, date_debut, date_fin) VALUES (216, 'Gregorio Fontana', NULL, NULL, 1006, true, '2015-11-06 16:04:13.593497+01', NULL, 15, NULL, NULL);
INSERT INTO nom_objet (pk_nom_objet, nom, langue, notes, fk_objet, est_standard, date_creation, date_modification, fk_type_nom_param, date_debut, date_fin) VALUES (217, 'Charles de Bovelles', NULL, NULL, 1007, true, '2015-11-06 16:04:13.593497+01', NULL, 15, NULL, NULL);
INSERT INTO nom_objet (pk_nom_objet, nom, langue, notes, fk_objet, est_standard, date_creation, date_modification, fk_type_nom_param, date_debut, date_fin) VALUES (218, 'Philipp Müller', NULL, NULL, 1008, true, '2015-11-06 16:04:13.593497+01', NULL, 15, NULL, NULL);
INSERT INTO nom_objet (pk_nom_objet, nom, langue, notes, fk_objet, est_standard, date_creation, date_modification, fk_type_nom_param, date_debut, date_fin) VALUES (219, 'Johan de Witt', NULL, NULL, 1009, true, '2015-11-06 16:04:13.593497+01', NULL, 15, NULL, NULL);
INSERT INTO nom_objet (pk_nom_objet, nom, langue, notes, fk_objet, est_standard, date_creation, date_modification, fk_type_nom_param, date_debut, date_fin) VALUES (220, 'Denis Papin', NULL, NULL, 1010, true, '2015-11-06 16:04:13.593497+01', NULL, 15, NULL, NULL);
INSERT INTO nom_objet (pk_nom_objet, nom, langue, notes, fk_objet, est_standard, date_creation, date_modification, fk_type_nom_param, date_debut, date_fin) VALUES (221, 'Guillaume Delisle', NULL, NULL, 1011, true, '2015-11-06 16:04:13.593497+01', NULL, 15, NULL, NULL);
INSERT INTO nom_objet (pk_nom_objet, nom, langue, notes, fk_objet, est_standard, date_creation, date_modification, fk_type_nom_param, date_debut, date_fin) VALUES (222, 'Adriaan Vlacq', NULL, NULL, 1012, true, '2015-11-06 16:04:13.593497+01', NULL, 15, NULL, NULL);
INSERT INTO nom_objet (pk_nom_objet, nom, langue, notes, fk_objet, est_standard, date_creation, date_modification, fk_type_nom_param, date_debut, date_fin) VALUES (223, 'Jean Bachou', NULL, NULL, 1013, true, '2015-11-06 16:04:13.593497+01', NULL, 15, NULL, NULL);
INSERT INTO nom_objet (pk_nom_objet, nom, langue, notes, fk_objet, est_standard, date_creation, date_modification, fk_type_nom_param, date_debut, date_fin) VALUES (224, 'John Nourse', NULL, NULL, 1014, true, '2015-11-06 16:04:13.593497+01', NULL, 15, NULL, NULL);
INSERT INTO nom_objet (pk_nom_objet, nom, langue, notes, fk_objet, est_standard, date_creation, date_modification, fk_type_nom_param, date_debut, date_fin) VALUES (225, 'Nicolas Charles Romme', NULL, NULL, 1015, true, '2015-11-06 16:04:13.593497+01', NULL, 15, NULL, NULL);
INSERT INTO nom_objet (pk_nom_objet, nom, langue, notes, fk_objet, est_standard, date_creation, date_modification, fk_type_nom_param, date_debut, date_fin) VALUES (226, 'Joseph Mouchet', NULL, NULL, 1016, true, '2015-11-06 16:04:13.593497+01', NULL, 15, NULL, NULL);
INSERT INTO nom_objet (pk_nom_objet, nom, langue, notes, fk_objet, est_standard, date_creation, date_modification, fk_type_nom_param, date_debut, date_fin) VALUES (227, 'Georg von Peurbach', NULL, NULL, 1017, true, '2015-11-06 16:04:13.593497+01', NULL, 15, NULL, NULL);
INSERT INTO nom_objet (pk_nom_objet, nom, langue, notes, fk_objet, est_standard, date_creation, date_modification, fk_type_nom_param, date_debut, date_fin) VALUES (228, 'Jean-Matthieu de Chazelles', NULL, NULL, 1018, true, '2015-11-06 16:04:13.593497+01', NULL, 15, NULL, NULL);
INSERT INTO nom_objet (pk_nom_objet, nom, langue, notes, fk_objet, est_standard, date_creation, date_modification, fk_type_nom_param, date_debut, date_fin) VALUES (229, 'Marie de La Fresnaye', NULL, NULL, 1019, true, '2015-11-06 16:04:13.593497+01', NULL, 15, NULL, NULL);
INSERT INTO nom_objet (pk_nom_objet, nom, langue, notes, fk_objet, est_standard, date_creation, date_modification, fk_type_nom_param, date_debut, date_fin) VALUES (230, 'Colin Mackenzie', NULL, NULL, 1020, true, '2015-11-06 16:04:13.593497+01', NULL, 15, NULL, NULL);
INSERT INTO nom_objet (pk_nom_objet, nom, langue, notes, fk_objet, est_standard, date_creation, date_modification, fk_type_nom_param, date_debut, date_fin) VALUES (231, 'Joseph Saurin', NULL, NULL, 1021, true, '2015-11-06 16:04:13.593497+01', NULL, 15, NULL, NULL);
INSERT INTO nom_objet (pk_nom_objet, nom, langue, notes, fk_objet, est_standard, date_creation, date_modification, fk_type_nom_param, date_debut, date_fin) VALUES (232, 'Nicolas Antoine Guillard', NULL, NULL, 1022, true, '2015-11-06 16:04:13.593497+01', NULL, 15, NULL, NULL);
INSERT INTO nom_objet (pk_nom_objet, nom, langue, notes, fk_objet, est_standard, date_creation, date_modification, fk_type_nom_param, date_debut, date_fin) VALUES (233, 'Paolino Chelucci', NULL, NULL, 1023, true, '2015-11-06 16:04:13.593497+01', NULL, 15, NULL, NULL);
INSERT INTO nom_objet (pk_nom_objet, nom, langue, notes, fk_objet, est_standard, date_creation, date_modification, fk_type_nom_param, date_debut, date_fin) VALUES (234, 'Louis Lecomte', NULL, NULL, 1024, true, '2015-11-06 16:04:13.593497+01', NULL, 15, NULL, NULL);
INSERT INTO nom_objet (pk_nom_objet, nom, langue, notes, fk_objet, est_standard, date_creation, date_modification, fk_type_nom_param, date_debut, date_fin) VALUES (235, 'Thaddäus Rinderle', NULL, NULL, 1025, true, '2015-11-06 16:04:13.593497+01', NULL, 15, NULL, NULL);
INSERT INTO nom_objet (pk_nom_objet, nom, langue, notes, fk_objet, est_standard, date_creation, date_modification, fk_type_nom_param, date_debut, date_fin) VALUES (236, 'Humphry Ditton', NULL, NULL, 1026, true, '2015-11-06 16:04:13.593497+01', NULL, 15, NULL, NULL);
INSERT INTO nom_objet (pk_nom_objet, nom, langue, notes, fk_objet, est_standard, date_creation, date_modification, fk_type_nom_param, date_debut, date_fin) VALUES (237, 'Jens Kraft', NULL, NULL, 1027, true, '2015-11-06 16:04:13.593497+01', NULL, 15, NULL, NULL);
INSERT INTO nom_objet (pk_nom_objet, nom, langue, notes, fk_objet, est_standard, date_creation, date_modification, fk_type_nom_param, date_debut, date_fin) VALUES (238, 'Paolo Antonio Foscarini', NULL, NULL, 1028, true, '2015-11-06 16:04:13.593497+01', NULL, 15, NULL, NULL);
INSERT INTO nom_objet (pk_nom_objet, nom, langue, notes, fk_objet, est_standard, date_creation, date_modification, fk_type_nom_param, date_debut, date_fin) VALUES (239, 'Jean-Pierre de Crousaz', NULL, NULL, 1029, true, '2015-11-06 16:04:13.593497+01', NULL, 15, NULL, NULL);
INSERT INTO nom_objet (pk_nom_objet, nom, langue, notes, fk_objet, est_standard, date_creation, date_modification, fk_type_nom_param, date_debut, date_fin) VALUES (240, 'Johann Andreas von Segner', NULL, NULL, 1030, true, '2015-11-06 16:04:13.593497+01', NULL, 15, NULL, NULL);
INSERT INTO nom_objet (pk_nom_objet, nom, langue, notes, fk_objet, est_standard, date_creation, date_modification, fk_type_nom_param, date_debut, date_fin) VALUES (241, 'J.P. Audiffred', NULL, NULL, 1031, true, '2015-11-06 16:04:13.593497+01', NULL, 15, NULL, NULL);
INSERT INTO nom_objet (pk_nom_objet, nom, langue, notes, fk_objet, est_standard, date_creation, date_modification, fk_type_nom_param, date_debut, date_fin) VALUES (242, 'Federico Gualdi', NULL, NULL, 1032, true, '2015-11-06 16:04:13.593497+01', NULL, 15, NULL, NULL);
INSERT INTO nom_objet (pk_nom_objet, nom, langue, notes, fk_objet, est_standard, date_creation, date_modification, fk_type_nom_param, date_debut, date_fin) VALUES (243, 'Johann Nicolai Tetens', NULL, NULL, 1033, true, '2015-11-06 16:04:13.593497+01', NULL, 15, NULL, NULL);
INSERT INTO nom_objet (pk_nom_objet, nom, langue, notes, fk_objet, est_standard, date_creation, date_modification, fk_type_nom_param, date_debut, date_fin) VALUES (244, 'Nicolas Bernoulli', NULL, NULL, 1034, true, '2015-11-06 16:04:13.593497+01', NULL, 15, NULL, NULL);
INSERT INTO nom_objet (pk_nom_objet, nom, langue, notes, fk_objet, est_standard, date_creation, date_modification, fk_type_nom_param, date_debut, date_fin) VALUES (245, 'Nicole-Reine Lepaute', NULL, NULL, 1035, true, '2015-11-06 16:04:13.593497+01', NULL, 15, NULL, NULL);
INSERT INTO nom_objet (pk_nom_objet, nom, langue, notes, fk_objet, est_standard, date_creation, date_modification, fk_type_nom_param, date_debut, date_fin) VALUES (246, 'Paolo Frisi', NULL, NULL, 1036, true, '2015-11-06 16:04:13.593497+01', NULL, 15, NULL, NULL);
INSERT INTO nom_objet (pk_nom_objet, nom, langue, notes, fk_objet, est_standard, date_creation, date_modification, fk_type_nom_param, date_debut, date_fin) VALUES (247, 'Luca Pacioli', NULL, NULL, 1037, true, '2015-11-06 16:04:13.593497+01', NULL, 15, NULL, NULL);
INSERT INTO nom_objet (pk_nom_objet, nom, langue, notes, fk_objet, est_standard, date_creation, date_modification, fk_type_nom_param, date_debut, date_fin) VALUES (248, 'Jean-Édouard Du Monin', NULL, NULL, 1038, true, '2015-11-06 16:04:13.593497+01', NULL, 15, NULL, NULL);
INSERT INTO nom_objet (pk_nom_objet, nom, langue, notes, fk_objet, est_standard, date_creation, date_modification, fk_type_nom_param, date_debut, date_fin) VALUES (249, 'Gabriel Cramer', NULL, NULL, 1039, true, '2015-11-06 16:04:13.593497+01', NULL, 15, NULL, NULL);
INSERT INTO nom_objet (pk_nom_objet, nom, langue, notes, fk_objet, est_standard, date_creation, date_modification, fk_type_nom_param, date_debut, date_fin) VALUES (250, 'Jean-Baptiste Labey', NULL, NULL, 1040, true, '2015-11-06 16:04:13.593497+01', NULL, 15, NULL, NULL);
INSERT INTO nom_objet (pk_nom_objet, nom, langue, notes, fk_objet, est_standard, date_creation, date_modification, fk_type_nom_param, date_debut, date_fin) VALUES (251, 'Elias van Lennep', NULL, NULL, 1041, true, '2015-11-06 16:04:13.593497+01', NULL, 15, NULL, NULL);
INSERT INTO nom_objet (pk_nom_objet, nom, langue, notes, fk_objet, est_standard, date_creation, date_modification, fk_type_nom_param, date_debut, date_fin) VALUES (252, 'Elena Lucrezia Cornaro Piscopia', NULL, NULL, 1042, true, '2015-11-06 16:04:13.593497+01', NULL, 15, NULL, NULL);
INSERT INTO nom_objet (pk_nom_objet, nom, langue, notes, fk_objet, est_standard, date_creation, date_modification, fk_type_nom_param, date_debut, date_fin) VALUES (253, 'Martin Basanier', NULL, NULL, 1043, true, '2015-11-06 16:04:13.593497+01', NULL, 15, NULL, NULL);
INSERT INTO nom_objet (pk_nom_objet, nom, langue, notes, fk_objet, est_standard, date_creation, date_modification, fk_type_nom_param, date_debut, date_fin) VALUES (254, 'Nicolaus Reimarus Ursus', NULL, NULL, 1044, true, '2015-11-06 16:04:13.593497+01', NULL, 15, NULL, NULL);
INSERT INTO nom_objet (pk_nom_objet, nom, langue, notes, fk_objet, est_standard, date_creation, date_modification, fk_type_nom_param, date_debut, date_fin) VALUES (255, 'Pierre Varignon', NULL, NULL, 1045, true, '2015-11-06 16:04:13.593497+01', NULL, 15, NULL, NULL);
INSERT INTO nom_objet (pk_nom_objet, nom, langue, notes, fk_objet, est_standard, date_creation, date_modification, fk_type_nom_param, date_debut, date_fin) VALUES (256, 'Diderich Christian Fester', NULL, NULL, 1046, true, '2015-11-06 16:04:13.593497+01', NULL, 15, NULL, NULL);
INSERT INTO nom_objet (pk_nom_objet, nom, langue, notes, fk_objet, est_standard, date_creation, date_modification, fk_type_nom_param, date_debut, date_fin) VALUES (257, 'Ǧamšīd ibn Masʿūd Ġiyāṯ al-Dīn al- Kāšī', NULL, NULL, 1047, true, '2015-11-06 16:04:13.593497+01', NULL, 15, NULL, NULL);
INSERT INTO nom_objet (pk_nom_objet, nom, langue, notes, fk_objet, est_standard, date_creation, date_modification, fk_type_nom_param, date_debut, date_fin) VALUES (258, 'René Gaultier de Maignannes', NULL, NULL, 1048, true, '2015-11-06 16:04:13.593497+01', NULL, 15, NULL, NULL);
INSERT INTO nom_objet (pk_nom_objet, nom, langue, notes, fk_objet, est_standard, date_creation, date_modification, fk_type_nom_param, date_debut, date_fin) VALUES (259, 'Jean-Mathieu de Chazelles', NULL, NULL, 1049, true, '2015-11-06 16:04:13.593497+01', NULL, 15, NULL, NULL);
INSERT INTO nom_objet (pk_nom_objet, nom, langue, notes, fk_objet, est_standard, date_creation, date_modification, fk_type_nom_param, date_debut, date_fin) VALUES (260, 'Adam Olearius', NULL, NULL, 1050, true, '2015-11-06 16:04:13.593497+01', NULL, 15, NULL, NULL);
INSERT INTO nom_objet (pk_nom_objet, nom, langue, notes, fk_objet, est_standard, date_creation, date_modification, fk_type_nom_param, date_debut, date_fin) VALUES (261, 'Achille Pierre Dionis du Séjour', NULL, NULL, 1051, true, '2015-11-06 16:04:13.593497+01', NULL, 15, NULL, NULL);
INSERT INTO nom_objet (pk_nom_objet, nom, langue, notes, fk_objet, est_standard, date_creation, date_modification, fk_type_nom_param, date_debut, date_fin) VALUES (262, 'Philippe de La Hire', NULL, NULL, 1052, true, '2015-11-06 16:04:13.593497+01', NULL, 15, NULL, NULL);
INSERT INTO nom_objet (pk_nom_objet, nom, langue, notes, fk_objet, est_standard, date_creation, date_modification, fk_type_nom_param, date_debut, date_fin) VALUES (263, 'Hermann de Carinthie', NULL, NULL, 1053, true, '2015-11-06 16:04:13.593497+01', NULL, 15, NULL, NULL);
INSERT INTO nom_objet (pk_nom_objet, nom, langue, notes, fk_objet, est_standard, date_creation, date_modification, fk_type_nom_param, date_debut, date_fin) VALUES (264, 'Joseph Mollet', NULL, NULL, 1054, true, '2015-11-06 16:04:13.593497+01', NULL, 15, NULL, NULL);
INSERT INTO nom_objet (pk_nom_objet, nom, langue, notes, fk_objet, est_standard, date_creation, date_modification, fk_type_nom_param, date_debut, date_fin) VALUES (265, 'Johann Hecker', NULL, NULL, 1055, true, '2015-11-06 16:04:13.593497+01', NULL, 15, NULL, NULL);
INSERT INTO nom_objet (pk_nom_objet, nom, langue, notes, fk_objet, est_standard, date_creation, date_modification, fk_type_nom_param, date_debut, date_fin) VALUES (266, 'Guido Grandi', NULL, NULL, 1056, true, '2015-11-06 16:04:13.593497+01', NULL, 15, NULL, NULL);
INSERT INTO nom_objet (pk_nom_objet, nom, langue, notes, fk_objet, est_standard, date_creation, date_modification, fk_type_nom_param, date_debut, date_fin) VALUES (267, 'Michelangelo Fardella', NULL, NULL, 1057, true, '2015-11-06 16:04:13.593497+01', NULL, 15, NULL, NULL);
INSERT INTO nom_objet (pk_nom_objet, nom, langue, notes, fk_objet, est_standard, date_creation, date_modification, fk_type_nom_param, date_debut, date_fin) VALUES (268, 'William Welwod', NULL, NULL, 1058, true, '2015-11-06 16:04:13.593497+01', NULL, 15, NULL, NULL);
INSERT INTO nom_objet (pk_nom_objet, nom, langue, notes, fk_objet, est_standard, date_creation, date_modification, fk_type_nom_param, date_debut, date_fin) VALUES (269, 'Allain Manesson-Mallet', NULL, NULL, 1059, true, '2015-11-06 16:04:13.593497+01', NULL, 15, NULL, NULL);
INSERT INTO nom_objet (pk_nom_objet, nom, langue, notes, fk_objet, est_standard, date_creation, date_modification, fk_type_nom_param, date_debut, date_fin) VALUES (270, 'Mathurin-Georges Girault de Keroudou', NULL, NULL, 1060, true, '2015-11-06 16:04:13.593497+01', NULL, 15, NULL, NULL);
INSERT INTO nom_objet (pk_nom_objet, nom, langue, notes, fk_objet, est_standard, date_creation, date_modification, fk_type_nom_param, date_debut, date_fin) VALUES (271, 'Trabaud', NULL, NULL, 1061, true, '2015-11-06 16:04:13.593497+01', NULL, 15, NULL, NULL);
INSERT INTO nom_objet (pk_nom_objet, nom, langue, notes, fk_objet, est_standard, date_creation, date_modification, fk_type_nom_param, date_debut, date_fin) VALUES (272, 'Bonaventura Cavalieri', NULL, NULL, 1062, true, '2015-11-06 16:04:13.593497+01', NULL, 15, NULL, NULL);
INSERT INTO nom_objet (pk_nom_objet, nom, langue, notes, fk_objet, est_standard, date_creation, date_modification, fk_type_nom_param, date_debut, date_fin) VALUES (273, 'Melchior Inchofer', NULL, NULL, 1063, true, '2015-11-06 16:04:13.593497+01', NULL, 15, NULL, NULL);
INSERT INTO nom_objet (pk_nom_objet, nom, langue, notes, fk_objet, est_standard, date_creation, date_modification, fk_type_nom_param, date_debut, date_fin) VALUES (274, 'François de Aguilón', NULL, NULL, 1064, true, '2015-11-06 16:04:13.593497+01', NULL, 15, NULL, NULL);
INSERT INTO nom_objet (pk_nom_objet, nom, langue, notes, fk_objet, est_standard, date_creation, date_modification, fk_type_nom_param, date_debut, date_fin) VALUES (275, 'Marie-Louise Cartan', NULL, NULL, 1065, true, '2015-11-06 16:04:13.593497+01', NULL, 15, NULL, NULL);
INSERT INTO nom_objet (pk_nom_objet, nom, langue, notes, fk_objet, est_standard, date_creation, date_modification, fk_type_nom_param, date_debut, date_fin) VALUES (276, 'Jacob Köbel', NULL, NULL, 1066, true, '2015-11-06 16:04:13.593497+01', NULL, 15, NULL, NULL);
INSERT INTO nom_objet (pk_nom_objet, nom, langue, notes, fk_objet, est_standard, date_creation, date_modification, fk_type_nom_param, date_debut, date_fin) VALUES (277, 'Rāmacandrācārya', NULL, NULL, 1067, true, '2015-11-06 16:04:13.593497+01', NULL, 15, NULL, NULL);
INSERT INTO nom_objet (pk_nom_objet, nom, langue, notes, fk_objet, est_standard, date_creation, date_modification, fk_type_nom_param, date_debut, date_fin) VALUES (278, 'Claude Richer', NULL, NULL, 1068, true, '2015-11-06 16:04:13.593497+01', NULL, 15, NULL, NULL);
INSERT INTO nom_objet (pk_nom_objet, nom, langue, notes, fk_objet, est_standard, date_creation, date_modification, fk_type_nom_param, date_debut, date_fin) VALUES (279, 'Ercole Bottrigari', NULL, NULL, 1069, true, '2015-11-06 16:04:13.593497+01', NULL, 15, NULL, NULL);
INSERT INTO nom_objet (pk_nom_objet, nom, langue, notes, fk_objet, est_standard, date_creation, date_modification, fk_type_nom_param, date_debut, date_fin) VALUES (280, 'Erasmus Schmied', NULL, NULL, 1070, true, '2015-11-06 16:04:13.593497+01', NULL, 15, NULL, NULL);
INSERT INTO nom_objet (pk_nom_objet, nom, langue, notes, fk_objet, est_standard, date_creation, date_modification, fk_type_nom_param, date_debut, date_fin) VALUES (281, 'Francesco Venini', NULL, NULL, 1071, true, '2015-11-06 16:04:13.593497+01', NULL, 15, NULL, NULL);
INSERT INTO nom_objet (pk_nom_objet, nom, langue, notes, fk_objet, est_standard, date_creation, date_modification, fk_type_nom_param, date_debut, date_fin) VALUES (282, 'Michael Stifel', NULL, NULL, 1072, true, '2015-11-06 16:04:13.593497+01', NULL, 15, NULL, NULL);
INSERT INTO nom_objet (pk_nom_objet, nom, langue, notes, fk_objet, est_standard, date_creation, date_modification, fk_type_nom_param, date_debut, date_fin) VALUES (283, 'Andreas Cellarius', NULL, NULL, 1073, true, '2015-11-06 16:04:13.593497+01', NULL, 15, NULL, NULL);
INSERT INTO nom_objet (pk_nom_objet, nom, langue, notes, fk_objet, est_standard, date_creation, date_modification, fk_type_nom_param, date_debut, date_fin) VALUES (284, 'Octavio Pisani', NULL, NULL, 1074, true, '2015-11-06 16:04:13.593497+01', NULL, 15, NULL, NULL);
INSERT INTO nom_objet (pk_nom_objet, nom, langue, notes, fk_objet, est_standard, date_creation, date_modification, fk_type_nom_param, date_debut, date_fin) VALUES (285, 'Nicolas-Maurice Chompré', NULL, NULL, 1075, true, '2015-11-06 16:04:13.593497+01', NULL, 15, NULL, NULL);
INSERT INTO nom_objet (pk_nom_objet, nom, langue, notes, fk_objet, est_standard, date_creation, date_modification, fk_type_nom_param, date_debut, date_fin) VALUES (286, 'Jan Chrzciciel Władysław Śniadecki', NULL, NULL, 1076, true, '2015-11-06 16:04:13.593497+01', NULL, 15, NULL, NULL);
INSERT INTO nom_objet (pk_nom_objet, nom, langue, notes, fk_objet, est_standard, date_creation, date_modification, fk_type_nom_param, date_debut, date_fin) VALUES (287, 'Agostino Ricci', NULL, NULL, 1077, true, '2015-11-06 16:04:13.593497+01', NULL, 15, NULL, NULL);
INSERT INTO nom_objet (pk_nom_objet, nom, langue, notes, fk_objet, est_standard, date_creation, date_modification, fk_type_nom_param, date_debut, date_fin) VALUES (288, 'Antoine de Laloubère', NULL, NULL, 1078, true, '2015-11-06 16:04:13.593497+01', NULL, 15, NULL, NULL);
INSERT INTO nom_objet (pk_nom_objet, nom, langue, notes, fk_objet, est_standard, date_creation, date_modification, fk_type_nom_param, date_debut, date_fin) VALUES (289, 'Tommaso Ceva', NULL, NULL, 1079, true, '2015-11-06 16:04:13.593497+01', NULL, 15, NULL, NULL);
INSERT INTO nom_objet (pk_nom_objet, nom, langue, notes, fk_objet, est_standard, date_creation, date_modification, fk_type_nom_param, date_debut, date_fin) VALUES (290, 'Alessandro Piccolomini', NULL, NULL, 1080, true, '2015-11-06 16:04:13.593497+01', NULL, 15, NULL, NULL);
INSERT INTO nom_objet (pk_nom_objet, nom, langue, notes, fk_objet, est_standard, date_creation, date_modification, fk_type_nom_param, date_debut, date_fin) VALUES (291, 'Jean-Claude-Gauthier-Louis de Benaben', NULL, NULL, 1081, true, '2015-11-06 16:04:13.593497+01', NULL, 15, NULL, NULL);
INSERT INTO nom_objet (pk_nom_objet, nom, langue, notes, fk_objet, est_standard, date_creation, date_modification, fk_type_nom_param, date_debut, date_fin) VALUES (292, 'Ehrenfried Walter von Tschirnhaus', NULL, NULL, 1082, true, '2015-11-06 16:04:13.593497+01', NULL, 15, NULL, NULL);
INSERT INTO nom_objet (pk_nom_objet, nom, langue, notes, fk_objet, est_standard, date_creation, date_modification, fk_type_nom_param, date_debut, date_fin) VALUES (293, 'Philippe Naudé', NULL, NULL, 1083, true, '2015-11-06 16:04:13.593497+01', NULL, 15, NULL, NULL);
INSERT INTO nom_objet (pk_nom_objet, nom, langue, notes, fk_objet, est_standard, date_creation, date_modification, fk_type_nom_param, date_debut, date_fin) VALUES (294, 'Renward Cysat', NULL, NULL, 1084, true, '2015-11-06 16:04:13.593497+01', NULL, 15, NULL, NULL);
INSERT INTO nom_objet (pk_nom_objet, nom, langue, notes, fk_objet, est_standard, date_creation, date_modification, fk_type_nom_param, date_debut, date_fin) VALUES (295, 'Johann Elert Bode', NULL, NULL, 1085, true, '2015-11-06 16:04:13.593497+01', NULL, 15, NULL, NULL);
INSERT INTO nom_objet (pk_nom_objet, nom, langue, notes, fk_objet, est_standard, date_creation, date_modification, fk_type_nom_param, date_debut, date_fin) VALUES (296, 'Thomas Bradwardine', NULL, NULL, 1086, true, '2015-11-06 16:04:13.593497+01', NULL, 15, NULL, NULL);
INSERT INTO nom_objet (pk_nom_objet, nom, langue, notes, fk_objet, est_standard, date_creation, date_modification, fk_type_nom_param, date_debut, date_fin) VALUES (297, 'Francesco Levera', NULL, NULL, 1087, true, '2015-11-06 16:04:13.593497+01', NULL, 15, NULL, NULL);
INSERT INTO nom_objet (pk_nom_objet, nom, langue, notes, fk_objet, est_standard, date_creation, date_modification, fk_type_nom_param, date_debut, date_fin) VALUES (298, 'Guisnée', NULL, NULL, 1088, true, '2015-11-06 16:04:13.593497+01', NULL, 15, NULL, NULL);
INSERT INTO nom_objet (pk_nom_objet, nom, langue, notes, fk_objet, est_standard, date_creation, date_modification, fk_type_nom_param, date_debut, date_fin) VALUES (299, 'Jean-François Gerbillon', NULL, NULL, 1089, true, '2015-11-06 16:04:13.593497+01', NULL, 15, NULL, NULL);
INSERT INTO nom_objet (pk_nom_objet, nom, langue, notes, fk_objet, est_standard, date_creation, date_modification, fk_type_nom_param, date_debut, date_fin) VALUES (300, 'José Antonio Alzate y Ramírez', NULL, NULL, 1090, true, '2015-11-06 16:04:13.593497+01', NULL, 15, NULL, NULL);
INSERT INTO nom_objet (pk_nom_objet, nom, langue, notes, fk_objet, est_standard, date_creation, date_modification, fk_type_nom_param, date_debut, date_fin) VALUES (301, 'Jean-Dominique Cassini', NULL, NULL, 1091, true, '2015-11-06 16:04:13.593497+01', NULL, 15, NULL, NULL);
INSERT INTO nom_objet (pk_nom_objet, nom, langue, notes, fk_objet, est_standard, date_creation, date_modification, fk_type_nom_param, date_debut, date_fin) VALUES (302, 'Albert Girard', NULL, NULL, 1092, true, '2015-11-06 16:04:13.593497+01', NULL, 15, NULL, NULL);
INSERT INTO nom_objet (pk_nom_objet, nom, langue, notes, fk_objet, est_standard, date_creation, date_modification, fk_type_nom_param, date_debut, date_fin) VALUES (303, 'Francesco Lana Terzi', NULL, NULL, 1093, true, '2015-11-06 16:04:13.593497+01', NULL, 15, NULL, NULL);
INSERT INTO nom_objet (pk_nom_objet, nom, langue, notes, fk_objet, est_standard, date_creation, date_modification, fk_type_nom_param, date_debut, date_fin) VALUES (304, 'Pietro Cataneo', NULL, NULL, 1094, true, '2015-11-06 16:04:13.593497+01', NULL, 15, NULL, NULL);
INSERT INTO nom_objet (pk_nom_objet, nom, langue, notes, fk_objet, est_standard, date_creation, date_modification, fk_type_nom_param, date_debut, date_fin) VALUES (305, 'Bartholomäus Pitiscus', NULL, NULL, 1095, true, '2015-11-06 16:04:13.593497+01', NULL, 15, NULL, NULL);
INSERT INTO nom_objet (pk_nom_objet, nom, langue, notes, fk_objet, est_standard, date_creation, date_modification, fk_type_nom_param, date_debut, date_fin) VALUES (306, 'John Ray', NULL, NULL, 1096, true, '2015-11-06 16:04:13.593497+01', NULL, 15, NULL, NULL);
INSERT INTO nom_objet (pk_nom_objet, nom, langue, notes, fk_objet, est_standard, date_creation, date_modification, fk_type_nom_param, date_debut, date_fin) VALUES (307, 'Simon Tyssot de Patot', NULL, NULL, 1097, true, '2015-11-06 16:04:13.593497+01', NULL, 15, NULL, NULL);
INSERT INTO nom_objet (pk_nom_objet, nom, langue, notes, fk_objet, est_standard, date_creation, date_modification, fk_type_nom_param, date_debut, date_fin) VALUES (308, 'Nicolas B. Halma', NULL, NULL, 1098, true, '2015-11-06 16:04:13.593497+01', NULL, 15, NULL, NULL);
INSERT INTO nom_objet (pk_nom_objet, nom, langue, notes, fk_objet, est_standard, date_creation, date_modification, fk_type_nom_param, date_debut, date_fin) VALUES (309, 'William Whiston', NULL, NULL, 1099, true, '2015-11-06 16:04:13.593497+01', NULL, 15, NULL, NULL);
INSERT INTO nom_objet (pk_nom_objet, nom, langue, notes, fk_objet, est_standard, date_creation, date_modification, fk_type_nom_param, date_debut, date_fin) VALUES (310, 'Celio Calcagnini', NULL, NULL, 1100, true, '2015-11-06 16:04:13.593497+01', NULL, 15, NULL, NULL);
INSERT INTO nom_objet (pk_nom_objet, nom, langue, notes, fk_objet, est_standard, date_creation, date_modification, fk_type_nom_param, date_debut, date_fin) VALUES (311, 'Johannes Kepler', NULL, NULL, 1101, true, '2015-11-06 16:04:13.593497+01', NULL, 15, NULL, NULL);
INSERT INTO nom_objet (pk_nom_objet, nom, langue, notes, fk_objet, est_standard, date_creation, date_modification, fk_type_nom_param, date_debut, date_fin) VALUES (312, 'Samuel König', NULL, NULL, 1102, true, '2015-11-06 16:04:13.593497+01', NULL, 15, NULL, NULL);
INSERT INTO nom_objet (pk_nom_objet, nom, langue, notes, fk_objet, est_standard, date_creation, date_modification, fk_type_nom_param, date_debut, date_fin) VALUES (313, 'Jean François Nicéron', NULL, NULL, 1103, true, '2015-11-06 16:04:13.593497+01', NULL, 15, NULL, NULL);
INSERT INTO nom_objet (pk_nom_objet, nom, langue, notes, fk_objet, est_standard, date_creation, date_modification, fk_type_nom_param, date_debut, date_fin) VALUES (314, 'Alexandre-Gui Pingré', NULL, NULL, 1104, true, '2015-11-06 16:04:13.593497+01', NULL, 15, NULL, NULL);
INSERT INTO nom_objet (pk_nom_objet, nom, langue, notes, fk_objet, est_standard, date_creation, date_modification, fk_type_nom_param, date_debut, date_fin) VALUES (315, 'Henri Bouchon-Dubournial', NULL, NULL, 1105, true, '2015-11-06 16:04:13.593497+01', NULL, 15, NULL, NULL);
INSERT INTO nom_objet (pk_nom_objet, nom, langue, notes, fk_objet, est_standard, date_creation, date_modification, fk_type_nom_param, date_debut, date_fin) VALUES (316, 'Juan de Yciar', NULL, NULL, 1106, true, '2015-11-06 16:04:13.593497+01', NULL, 15, NULL, NULL);
INSERT INTO nom_objet (pk_nom_objet, nom, langue, notes, fk_objet, est_standard, date_creation, date_modification, fk_type_nom_param, date_debut, date_fin) VALUES (317, 'Jacques Mengau', NULL, NULL, 1107, true, '2015-11-06 16:04:13.593497+01', NULL, 15, NULL, NULL);
INSERT INTO nom_objet (pk_nom_objet, nom, langue, notes, fk_objet, est_standard, date_creation, date_modification, fk_type_nom_param, date_debut, date_fin) VALUES (318, 'Geminiano Montanari', NULL, NULL, 1108, true, '2015-11-06 16:04:13.593497+01', NULL, 15, NULL, NULL);
INSERT INTO nom_objet (pk_nom_objet, nom, langue, notes, fk_objet, est_standard, date_creation, date_modification, fk_type_nom_param, date_debut, date_fin) VALUES (319, 'Théodore Bouys', NULL, NULL, 1109, true, '2015-11-06 16:04:13.593497+01', NULL, 15, NULL, NULL);
INSERT INTO nom_objet (pk_nom_objet, nom, langue, notes, fk_objet, est_standard, date_creation, date_modification, fk_type_nom_param, date_debut, date_fin) VALUES (320, 'Camillo Guarino Guarini', NULL, NULL, 1110, true, '2015-11-06 16:04:13.593497+01', NULL, 15, NULL, NULL);
INSERT INTO nom_objet (pk_nom_objet, nom, langue, notes, fk_objet, est_standard, date_creation, date_modification, fk_type_nom_param, date_debut, date_fin) VALUES (321, 'Lorenzo Buonincontri', NULL, NULL, 1111, true, '2015-11-06 16:04:13.593497+01', NULL, 15, NULL, NULL);
INSERT INTO nom_objet (pk_nom_objet, nom, langue, notes, fk_objet, est_standard, date_creation, date_modification, fk_type_nom_param, date_debut, date_fin) VALUES (322, 'François Derand', NULL, NULL, 1112, true, '2015-11-06 16:04:13.593497+01', NULL, 15, NULL, NULL);
INSERT INTO nom_objet (pk_nom_objet, nom, langue, notes, fk_objet, est_standard, date_creation, date_modification, fk_type_nom_param, date_debut, date_fin) VALUES (323, 'Caroline Lucretia Herschel', NULL, NULL, 1113, true, '2015-11-06 16:04:13.593497+01', NULL, 15, NULL, NULL);
INSERT INTO nom_objet (pk_nom_objet, nom, langue, notes, fk_objet, est_standard, date_creation, date_modification, fk_type_nom_param, date_debut, date_fin) VALUES (324, 'Jacopo da Firenze', NULL, NULL, 1114, true, '2015-11-06 16:04:13.593497+01', NULL, 15, NULL, NULL);
INSERT INTO nom_objet (pk_nom_objet, nom, langue, notes, fk_objet, est_standard, date_creation, date_modification, fk_type_nom_param, date_debut, date_fin) VALUES (325, 'Girolamo Fracastoro', NULL, NULL, 1115, true, '2015-11-06 16:04:13.593497+01', NULL, 15, NULL, NULL);
INSERT INTO nom_objet (pk_nom_objet, nom, langue, notes, fk_objet, est_standard, date_creation, date_modification, fk_type_nom_param, date_debut, date_fin) VALUES (326, 'Johann Gabriel Doppelmayr', NULL, NULL, 1116, true, '2015-11-06 16:04:13.593497+01', NULL, 15, NULL, NULL);
INSERT INTO nom_objet (pk_nom_objet, nom, langue, notes, fk_objet, est_standard, date_creation, date_modification, fk_type_nom_param, date_debut, date_fin) VALUES (327, 'Esprit Pezenas', NULL, NULL, 1117, true, '2015-11-06 16:04:13.593497+01', NULL, 15, NULL, NULL);
INSERT INTO nom_objet (pk_nom_objet, nom, langue, notes, fk_objet, est_standard, date_creation, date_modification, fk_type_nom_param, date_debut, date_fin) VALUES (328, 'Jacopo Dondi', NULL, NULL, 1118, true, '2015-11-06 16:04:13.593497+01', NULL, 15, NULL, NULL);
INSERT INTO nom_objet (pk_nom_objet, nom, langue, notes, fk_objet, est_standard, date_creation, date_modification, fk_type_nom_param, date_debut, date_fin) VALUES (329, 'Louis Courcier', NULL, NULL, 1119, true, '2015-11-06 16:04:13.593497+01', NULL, 15, NULL, NULL);
INSERT INTO nom_objet (pk_nom_objet, nom, langue, notes, fk_objet, est_standard, date_creation, date_modification, fk_type_nom_param, date_debut, date_fin) VALUES (330, 'András Dugonics', NULL, NULL, 1120, true, '2015-11-06 16:04:13.593497+01', NULL, 15, NULL, NULL);
INSERT INTO nom_objet (pk_nom_objet, nom, langue, notes, fk_objet, est_standard, date_creation, date_modification, fk_type_nom_param, date_debut, date_fin) VALUES (331, 'Pietro Cossali', NULL, NULL, 1121, true, '2015-11-06 16:04:13.593497+01', NULL, 15, NULL, NULL);
INSERT INTO nom_objet (pk_nom_objet, nom, langue, notes, fk_objet, est_standard, date_creation, date_modification, fk_type_nom_param, date_debut, date_fin) VALUES (332, 'Jean Pecham', NULL, NULL, 1122, true, '2015-11-06 16:04:13.593497+01', NULL, 15, NULL, NULL);
INSERT INTO nom_objet (pk_nom_objet, nom, langue, notes, fk_objet, est_standard, date_creation, date_modification, fk_type_nom_param, date_debut, date_fin) VALUES (333, 'Camillo Agrippa', NULL, NULL, 1123, true, '2015-11-06 16:04:13.593497+01', NULL, 15, NULL, NULL);
INSERT INTO nom_objet (pk_nom_objet, nom, langue, notes, fk_objet, est_standard, date_creation, date_modification, fk_type_nom_param, date_debut, date_fin) VALUES (334, 'Isaac Barrow', NULL, NULL, 1124, true, '2015-11-06 16:04:13.593497+01', NULL, 15, NULL, NULL);
INSERT INTO nom_objet (pk_nom_objet, nom, langue, notes, fk_objet, est_standard, date_creation, date_modification, fk_type_nom_param, date_debut, date_fin) VALUES (335, 'Madame Bailly', NULL, NULL, 1125, true, '2015-11-06 16:04:13.593497+01', NULL, 15, NULL, NULL);
INSERT INTO nom_objet (pk_nom_objet, nom, langue, notes, fk_objet, est_standard, date_creation, date_modification, fk_type_nom_param, date_debut, date_fin) VALUES (336, 'Henri Baten', NULL, NULL, 1126, true, '2015-11-06 16:04:13.593497+01', NULL, 15, NULL, NULL);
INSERT INTO nom_objet (pk_nom_objet, nom, langue, notes, fk_objet, est_standard, date_creation, date_modification, fk_type_nom_param, date_debut, date_fin) VALUES (337, 'Naǧm al-Dīn al- Miṣrī', NULL, NULL, 1127, true, '2015-11-06 16:04:13.593497+01', NULL, 15, NULL, NULL);
INSERT INTO nom_objet (pk_nom_objet, nom, langue, notes, fk_objet, est_standard, date_creation, date_modification, fk_type_nom_param, date_debut, date_fin) VALUES (338, 'Jakob Ziegler', NULL, NULL, 1128, true, '2015-11-06 16:04:13.593497+01', NULL, 15, NULL, NULL);
INSERT INTO nom_objet (pk_nom_objet, nom, langue, notes, fk_objet, est_standard, date_creation, date_modification, fk_type_nom_param, date_debut, date_fin) VALUES (339, 'Jacques Besson', NULL, NULL, 1129, true, '2015-11-06 16:04:13.593497+01', NULL, 15, NULL, NULL);
INSERT INTO nom_objet (pk_nom_objet, nom, langue, notes, fk_objet, est_standard, date_creation, date_modification, fk_type_nom_param, date_debut, date_fin) VALUES (340, 'Jean-Dominique Cassini', NULL, NULL, 1130, true, '2015-11-06 16:04:13.593497+01', NULL, 15, NULL, NULL);
INSERT INTO nom_objet (pk_nom_objet, nom, langue, notes, fk_objet, est_standard, date_creation, date_modification, fk_type_nom_param, date_debut, date_fin) VALUES (341, 'Geršon ben Salomon d''Arles', NULL, NULL, 1131, true, '2015-11-06 16:04:13.593497+01', NULL, 15, NULL, NULL);
INSERT INTO nom_objet (pk_nom_objet, nom, langue, notes, fk_objet, est_standard, date_creation, date_modification, fk_type_nom_param, date_debut, date_fin) VALUES (342, 'Le Blanc', NULL, NULL, 1132, true, '2015-11-06 16:04:13.593497+01', NULL, 15, NULL, NULL);
INSERT INTO nom_objet (pk_nom_objet, nom, langue, notes, fk_objet, est_standard, date_creation, date_modification, fk_type_nom_param, date_debut, date_fin) VALUES (343, 'Joseph Anton Slop von Cadenberg', NULL, NULL, 1133, true, '2015-11-06 16:04:13.593497+01', NULL, 15, NULL, NULL);
INSERT INTO nom_objet (pk_nom_objet, nom, langue, notes, fk_objet, est_standard, date_creation, date_modification, fk_type_nom_param, date_debut, date_fin) VALUES (344, 'Johannes Regiomontanus', NULL, NULL, 1134, true, '2015-11-06 16:04:13.593497+01', NULL, 15, NULL, NULL);
INSERT INTO nom_objet (pk_nom_objet, nom, langue, notes, fk_objet, est_standard, date_creation, date_modification, fk_type_nom_param, date_debut, date_fin) VALUES (345, 'Jean-Paul de Gua de Malves', NULL, NULL, 1135, true, '2015-11-06 16:04:13.593497+01', NULL, 15, NULL, NULL);
INSERT INTO nom_objet (pk_nom_objet, nom, langue, notes, fk_objet, est_standard, date_creation, date_modification, fk_type_nom_param, date_debut, date_fin) VALUES (346, 'Cristóvão Ferreira', NULL, NULL, 1136, true, '2015-11-06 16:04:13.593497+01', NULL, 15, NULL, NULL);
INSERT INTO nom_objet (pk_nom_objet, nom, langue, notes, fk_objet, est_standard, date_creation, date_modification, fk_type_nom_param, date_debut, date_fin) VALUES (347, 'Scipione Chiaramonti', NULL, NULL, 1137, true, '2015-11-06 16:04:13.593497+01', NULL, 15, NULL, NULL);
INSERT INTO nom_objet (pk_nom_objet, nom, langue, notes, fk_objet, est_standard, date_creation, date_modification, fk_type_nom_param, date_debut, date_fin) VALUES (348, 'Firmin Abauzit', NULL, NULL, 1138, true, '2015-11-06 16:04:13.593497+01', NULL, 15, NULL, NULL);
INSERT INTO nom_objet (pk_nom_objet, nom, langue, notes, fk_objet, est_standard, date_creation, date_modification, fk_type_nom_param, date_debut, date_fin) VALUES (349, 'Bernardo Gamucci', NULL, NULL, 1139, true, '2015-11-06 16:04:13.593497+01', NULL, 15, NULL, NULL);
INSERT INTO nom_objet (pk_nom_objet, nom, langue, notes, fk_objet, est_standard, date_creation, date_modification, fk_type_nom_param, date_debut, date_fin) VALUES (350, 'Eberhard Welper', NULL, NULL, 1140, true, '2015-11-06 16:04:13.593497+01', NULL, 15, NULL, NULL);
INSERT INTO nom_objet (pk_nom_objet, nom, langue, notes, fk_objet, est_standard, date_creation, date_modification, fk_type_nom_param, date_debut, date_fin) VALUES (351, 'Pedro Ciruelo', NULL, NULL, 1141, true, '2015-11-06 16:04:13.593497+01', NULL, 15, NULL, NULL);
INSERT INTO nom_objet (pk_nom_objet, nom, langue, notes, fk_objet, est_standard, date_creation, date_modification, fk_type_nom_param, date_debut, date_fin) VALUES (352, 'Benedictus Aretius', NULL, NULL, 1142, true, '2015-11-06 16:04:13.593497+01', NULL, 15, NULL, NULL);
INSERT INTO nom_objet (pk_nom_objet, nom, langue, notes, fk_objet, est_standard, date_creation, date_modification, fk_type_nom_param, date_debut, date_fin) VALUES (353, 'François Barrême', NULL, NULL, 1143, true, '2015-11-06 16:04:13.593497+01', NULL, 15, NULL, NULL);
INSERT INTO nom_objet (pk_nom_objet, nom, langue, notes, fk_objet, est_standard, date_creation, date_modification, fk_type_nom_param, date_debut, date_fin) VALUES (354, 'Johannes de Sacro Bosco', NULL, NULL, 1144, true, '2015-11-06 16:04:13.593497+01', NULL, 15, NULL, NULL);
INSERT INTO nom_objet (pk_nom_objet, nom, langue, notes, fk_objet, est_standard, date_creation, date_modification, fk_type_nom_param, date_debut, date_fin) VALUES (355, 'Bernardino Baldi', NULL, NULL, 1145, true, '2015-11-06 16:04:13.593497+01', NULL, 15, NULL, NULL);
INSERT INTO nom_objet (pk_nom_objet, nom, langue, notes, fk_objet, est_standard, date_creation, date_modification, fk_type_nom_param, date_debut, date_fin) VALUES (356, 'Anders Celsius', NULL, NULL, 1146, true, '2015-11-06 16:04:13.593497+01', NULL, 15, NULL, NULL);
INSERT INTO nom_objet (pk_nom_objet, nom, langue, notes, fk_objet, est_standard, date_creation, date_modification, fk_type_nom_param, date_debut, date_fin) VALUES (357, 'Jean-Charles Borda', NULL, NULL, 1147, true, '2015-11-06 16:04:13.593497+01', NULL, 15, NULL, NULL);
INSERT INTO nom_objet (pk_nom_objet, nom, langue, notes, fk_objet, est_standard, date_creation, date_modification, fk_type_nom_param, date_debut, date_fin) VALUES (358, 'Emmanuel Maignan', NULL, NULL, 1148, true, '2015-11-06 16:04:13.593497+01', NULL, 15, NULL, NULL);
INSERT INTO nom_objet (pk_nom_objet, nom, langue, notes, fk_objet, est_standard, date_creation, date_modification, fk_type_nom_param, date_debut, date_fin) VALUES (359, 'Vannoccio Biringuccio', NULL, NULL, 1149, true, '2015-11-06 16:04:13.593497+01', NULL, 15, NULL, NULL);
INSERT INTO nom_objet (pk_nom_objet, nom, langue, notes, fk_objet, est_standard, date_creation, date_modification, fk_type_nom_param, date_debut, date_fin) VALUES (360, 'Juan Pérez de Moya', NULL, NULL, 1150, true, '2015-11-06 16:04:13.593497+01', NULL, 15, NULL, NULL);
INSERT INTO nom_objet (pk_nom_objet, nom, langue, notes, fk_objet, est_standard, date_creation, date_modification, fk_type_nom_param, date_debut, date_fin) VALUES (361, 'Guillelmus Beer', NULL, NULL, 1151, true, '2015-11-06 16:04:13.593497+01', NULL, 15, NULL, NULL);
INSERT INTO nom_objet (pk_nom_objet, nom, langue, notes, fk_objet, est_standard, date_creation, date_modification, fk_type_nom_param, date_debut, date_fin) VALUES (362, 'Melchior Ayrer', NULL, NULL, 1152, true, '2015-11-06 16:04:13.593497+01', NULL, 15, NULL, NULL);
INSERT INTO nom_objet (pk_nom_objet, nom, langue, notes, fk_objet, est_standard, date_creation, date_modification, fk_type_nom_param, date_debut, date_fin) VALUES (363, 'Guidobaldo Dal Monte', NULL, NULL, 1153, true, '2015-11-06 16:04:13.593497+01', NULL, 15, NULL, NULL);
INSERT INTO nom_objet (pk_nom_objet, nom, langue, notes, fk_objet, est_standard, date_creation, date_modification, fk_type_nom_param, date_debut, date_fin) VALUES (364, 'Petrus Ramus', NULL, NULL, 1154, true, '2015-11-06 16:04:13.593497+01', NULL, 15, NULL, NULL);
INSERT INTO nom_objet (pk_nom_objet, nom, langue, notes, fk_objet, est_standard, date_creation, date_modification, fk_type_nom_param, date_debut, date_fin) VALUES (365, 'Jean Picard', NULL, NULL, 1155, true, '2015-11-06 16:04:13.593497+01', NULL, 15, NULL, NULL);
INSERT INTO nom_objet (pk_nom_objet, nom, langue, notes, fk_objet, est_standard, date_creation, date_modification, fk_type_nom_param, date_debut, date_fin) VALUES (366, 'Tito Livio Burattini', NULL, NULL, 1156, true, '2015-11-06 16:04:13.593497+01', NULL, 15, NULL, NULL);
INSERT INTO nom_objet (pk_nom_objet, nom, langue, notes, fk_objet, est_standard, date_creation, date_modification, fk_type_nom_param, date_debut, date_fin) VALUES (367, 'Charles Messier', NULL, NULL, 1157, true, '2015-11-06 16:04:13.593497+01', NULL, 15, NULL, NULL);
INSERT INTO nom_objet (pk_nom_objet, nom, langue, notes, fk_objet, est_standard, date_creation, date_modification, fk_type_nom_param, date_debut, date_fin) VALUES (368, 'Joachim Jungius', NULL, NULL, 1158, true, '2015-11-06 16:04:13.593497+01', NULL, 15, NULL, NULL);
INSERT INTO nom_objet (pk_nom_objet, nom, langue, notes, fk_objet, est_standard, date_creation, date_modification, fk_type_nom_param, date_debut, date_fin) VALUES (369, 'César-François Cassini de Thury', NULL, NULL, 1159, true, '2015-11-06 16:04:13.593497+01', NULL, 15, NULL, NULL);
INSERT INTO nom_objet (pk_nom_objet, nom, langue, notes, fk_objet, est_standard, date_creation, date_modification, fk_type_nom_param, date_debut, date_fin) VALUES (370, 'Eugénios Voúlgaris', NULL, NULL, 1160, true, '2015-11-06 16:04:13.593497+01', NULL, 15, NULL, NULL);
INSERT INTO nom_objet (pk_nom_objet, nom, langue, notes, fk_objet, est_standard, date_creation, date_modification, fk_type_nom_param, date_debut, date_fin) VALUES (371, 'Vincenzo De Filippis', NULL, NULL, 1161, true, '2015-11-06 16:04:13.593497+01', NULL, 15, NULL, NULL);
INSERT INTO nom_objet (pk_nom_objet, nom, langue, notes, fk_objet, est_standard, date_creation, date_modification, fk_type_nom_param, date_debut, date_fin) VALUES (372, 'Johann Schultz', NULL, NULL, 1162, true, '2015-11-06 16:04:13.593497+01', NULL, 15, NULL, NULL);
INSERT INTO nom_objet (pk_nom_objet, nom, langue, notes, fk_objet, est_standard, date_creation, date_modification, fk_type_nom_param, date_debut, date_fin) VALUES (373, 'Didier Robert de Vaugondy', NULL, NULL, 1163, true, '2015-11-06 16:04:13.593497+01', NULL, 15, NULL, NULL);
INSERT INTO nom_objet (pk_nom_objet, nom, langue, notes, fk_objet, est_standard, date_creation, date_modification, fk_type_nom_param, date_debut, date_fin) VALUES (374, 'Jean-Pierre de Mesmes', NULL, NULL, 1164, true, '2015-11-06 16:04:13.593497+01', NULL, 15, NULL, NULL);
INSERT INTO nom_objet (pk_nom_objet, nom, langue, notes, fk_objet, est_standard, date_creation, date_modification, fk_type_nom_param, date_debut, date_fin) VALUES (375, 'John Craig', NULL, NULL, 1165, true, '2015-11-06 16:04:13.593497+01', NULL, 15, NULL, NULL);
INSERT INTO nom_objet (pk_nom_objet, nom, langue, notes, fk_objet, est_standard, date_creation, date_modification, fk_type_nom_param, date_debut, date_fin) VALUES (376, 'Vicente Tofiño de San Miguel', NULL, NULL, 1166, true, '2015-11-06 16:04:13.593497+01', NULL, 15, NULL, NULL);
INSERT INTO nom_objet (pk_nom_objet, nom, langue, notes, fk_objet, est_standard, date_creation, date_modification, fk_type_nom_param, date_debut, date_fin) VALUES (377, 'Luis Teixeira', NULL, NULL, 1167, true, '2015-11-06 16:04:13.593497+01', NULL, 15, NULL, NULL);
INSERT INTO nom_objet (pk_nom_objet, nom, langue, notes, fk_objet, est_standard, date_creation, date_modification, fk_type_nom_param, date_debut, date_fin) VALUES (378, 'Abraham Gotthelf Kästner', NULL, NULL, 1168, true, '2015-11-06 16:04:13.593497+01', NULL, 15, NULL, NULL);
INSERT INTO nom_objet (pk_nom_objet, nom, langue, notes, fk_objet, est_standard, date_creation, date_modification, fk_type_nom_param, date_debut, date_fin) VALUES (379, 'Giovanni Bianchini', NULL, NULL, 1169, true, '2015-11-06 16:04:13.593497+01', NULL, 15, NULL, NULL);
INSERT INTO nom_objet (pk_nom_objet, nom, langue, notes, fk_objet, est_standard, date_creation, date_modification, fk_type_nom_param, date_debut, date_fin) VALUES (380, 'Francesco Barozzi', NULL, NULL, 1170, true, '2015-11-06 16:04:13.593497+01', NULL, 15, NULL, NULL);
INSERT INTO nom_objet (pk_nom_objet, nom, langue, notes, fk_objet, est_standard, date_creation, date_modification, fk_type_nom_param, date_debut, date_fin) VALUES (381, 'Nicolaus Gugler', NULL, NULL, 1171, true, '2015-11-06 16:04:13.593497+01', NULL, 15, NULL, NULL);
INSERT INTO nom_objet (pk_nom_objet, nom, langue, notes, fk_objet, est_standard, date_creation, date_modification, fk_type_nom_param, date_debut, date_fin) VALUES (382, 'Niccolò Partenio Giannettasio', NULL, NULL, 1172, true, '2015-11-06 16:04:13.593497+01', NULL, 15, NULL, NULL);
INSERT INTO nom_objet (pk_nom_objet, nom, langue, notes, fk_objet, est_standard, date_creation, date_modification, fk_type_nom_param, date_debut, date_fin) VALUES (383, 'Sigismondo Fanti', NULL, NULL, 1173, true, '2015-11-06 16:04:13.593497+01', NULL, 15, NULL, NULL);
INSERT INTO nom_objet (pk_nom_objet, nom, langue, notes, fk_objet, est_standard, date_creation, date_modification, fk_type_nom_param, date_debut, date_fin) VALUES (384, 'Conradus Dasypodius', NULL, NULL, 1174, true, '2015-11-06 16:04:13.593497+01', NULL, 15, NULL, NULL);
INSERT INTO nom_objet (pk_nom_objet, nom, langue, notes, fk_objet, est_standard, date_creation, date_modification, fk_type_nom_param, date_debut, date_fin) VALUES (385, 'Tycho Brahe', NULL, NULL, 1175, true, '2015-11-06 16:04:13.593497+01', NULL, 15, NULL, NULL);
INSERT INTO nom_objet (pk_nom_objet, nom, langue, notes, fk_objet, est_standard, date_creation, date_modification, fk_type_nom_param, date_debut, date_fin) VALUES (386, 'Taqī al-Dīn Muḥammad Ibn Maʿrūf', NULL, NULL, 1176, true, '2015-11-06 16:04:13.593497+01', NULL, 15, NULL, NULL);
INSERT INTO nom_objet (pk_nom_objet, nom, langue, notes, fk_objet, est_standard, date_creation, date_modification, fk_type_nom_param, date_debut, date_fin) VALUES (387, 'Jacob Aertsz Colom', NULL, NULL, 1177, true, '2015-11-06 16:04:13.593497+01', NULL, 15, NULL, NULL);
INSERT INTO nom_objet (pk_nom_objet, nom, langue, notes, fk_objet, est_standard, date_creation, date_modification, fk_type_nom_param, date_debut, date_fin) VALUES (388, 'Claude-François Milliet de Chales', NULL, NULL, 1178, true, '2015-11-06 16:04:13.593497+01', NULL, 15, NULL, NULL);
INSERT INTO nom_objet (pk_nom_objet, nom, langue, notes, fk_objet, est_standard, date_creation, date_modification, fk_type_nom_param, date_debut, date_fin) VALUES (389, 'Josef Anton Nagel', NULL, NULL, 1179, true, '2015-11-06 16:04:13.593497+01', NULL, 15, NULL, NULL);
INSERT INTO nom_objet (pk_nom_objet, nom, langue, notes, fk_objet, est_standard, date_creation, date_modification, fk_type_nom_param, date_debut, date_fin) VALUES (390, 'Baudouin de Guémadeuc', NULL, NULL, 1180, true, '2015-11-06 16:04:13.593497+01', NULL, 15, NULL, NULL);
INSERT INTO nom_objet (pk_nom_objet, nom, langue, notes, fk_objet, est_standard, date_creation, date_modification, fk_type_nom_param, date_debut, date_fin) VALUES (391, 'Konrad Türst', NULL, NULL, 1181, true, '2015-11-06 16:04:13.593497+01', NULL, 15, NULL, NULL);
INSERT INTO nom_objet (pk_nom_objet, nom, langue, notes, fk_objet, est_standard, date_creation, date_modification, fk_type_nom_param, date_debut, date_fin) VALUES (392, 'Martinus Hortensius', NULL, NULL, 1182, true, '2015-11-06 16:04:13.593497+01', NULL, 15, NULL, NULL);
INSERT INTO nom_objet (pk_nom_objet, nom, langue, notes, fk_objet, est_standard, date_creation, date_modification, fk_type_nom_param, date_debut, date_fin) VALUES (393, 'Niccolò Zucchi', NULL, NULL, 1183, true, '2015-11-06 16:04:13.593497+01', NULL, 15, NULL, NULL);
INSERT INTO nom_objet (pk_nom_objet, nom, langue, notes, fk_objet, est_standard, date_creation, date_modification, fk_type_nom_param, date_debut, date_fin) VALUES (394, 'Charles Bossut', NULL, NULL, 1184, true, '2015-11-06 16:04:13.593497+01', NULL, 15, NULL, NULL);
INSERT INTO nom_objet (pk_nom_objet, nom, langue, notes, fk_objet, est_standard, date_creation, date_modification, fk_type_nom_param, date_debut, date_fin) VALUES (395, 'Giovanni Dondi dall''Orologio', NULL, NULL, 1185, true, '2015-11-06 16:04:13.593497+01', NULL, 15, NULL, NULL);
INSERT INTO nom_objet (pk_nom_objet, nom, langue, notes, fk_objet, est_standard, date_creation, date_modification, fk_type_nom_param, date_debut, date_fin) VALUES (396, 'Leonhard Euler', NULL, NULL, 1186, true, '2015-11-06 16:04:13.593497+01', NULL, 15, NULL, NULL);
INSERT INTO nom_objet (pk_nom_objet, nom, langue, notes, fk_objet, est_standard, date_creation, date_modification, fk_type_nom_param, date_debut, date_fin) VALUES (397, 'Nicolas-François Canard', NULL, NULL, 1187, true, '2015-11-06 16:04:13.593497+01', NULL, 15, NULL, NULL);
INSERT INTO nom_objet (pk_nom_objet, nom, langue, notes, fk_objet, est_standard, date_creation, date_modification, fk_type_nom_param, date_debut, date_fin) VALUES (398, 'ʿAlī ibn Muḥammad al- Qalaṣādī', NULL, NULL, 1188, true, '2015-11-06 16:04:13.593497+01', NULL, 15, NULL, NULL);
INSERT INTO nom_objet (pk_nom_objet, nom, langue, notes, fk_objet, est_standard, date_creation, date_modification, fk_type_nom_param, date_debut, date_fin) VALUES (399, 'Fabrizio Mordente', NULL, NULL, 1189, true, '2015-11-06 16:04:13.593497+01', NULL, 15, NULL, NULL);
INSERT INTO nom_objet (pk_nom_objet, nom, langue, notes, fk_objet, est_standard, date_creation, date_modification, fk_type_nom_param, date_debut, date_fin) VALUES (400, 'Giovanni di Strasoldo', NULL, NULL, 1190, true, '2015-11-06 16:04:13.593497+01', NULL, 15, NULL, NULL);
INSERT INTO nom_objet (pk_nom_objet, nom, langue, notes, fk_objet, est_standard, date_creation, date_modification, fk_type_nom_param, date_debut, date_fin) VALUES (401, 'Johannes Werner', NULL, NULL, 1191, true, '2015-11-06 16:04:13.593497+01', NULL, 15, NULL, NULL);
INSERT INTO nom_objet (pk_nom_objet, nom, langue, notes, fk_objet, est_standard, date_creation, date_modification, fk_type_nom_param, date_debut, date_fin) VALUES (402, 'Nicolas Bion', NULL, NULL, 1192, true, '2015-11-06 16:04:13.593497+01', NULL, 15, NULL, NULL);
INSERT INTO nom_objet (pk_nom_objet, nom, langue, notes, fk_objet, est_standard, date_creation, date_modification, fk_type_nom_param, date_debut, date_fin) VALUES (403, 'Jacques Maretz', NULL, NULL, 1193, true, '2015-11-06 16:04:13.593497+01', NULL, 15, NULL, NULL);
INSERT INTO nom_objet (pk_nom_objet, nom, langue, notes, fk_objet, est_standard, date_creation, date_modification, fk_type_nom_param, date_debut, date_fin) VALUES (404, 'Jean Gosselin', NULL, NULL, 1194, true, '2015-11-06 16:04:13.593497+01', NULL, 15, NULL, NULL);
INSERT INTO nom_objet (pk_nom_objet, nom, langue, notes, fk_objet, est_standard, date_creation, date_modification, fk_type_nom_param, date_debut, date_fin) VALUES (405, 'Robert Smith', NULL, NULL, 1195, true, '2015-11-06 16:04:13.593497+01', NULL, 15, NULL, NULL);
INSERT INTO nom_objet (pk_nom_objet, nom, langue, notes, fk_objet, est_standard, date_creation, date_modification, fk_type_nom_param, date_debut, date_fin) VALUES (406, 'János Sajnovics', NULL, NULL, 1196, true, '2015-11-06 16:04:13.593497+01', NULL, 15, NULL, NULL);
INSERT INTO nom_objet (pk_nom_objet, nom, langue, notes, fk_objet, est_standard, date_creation, date_modification, fk_type_nom_param, date_debut, date_fin) VALUES (407, 'Moḥamad ben Moḥamad Naṣīr al-Dīn Ṭōsī', NULL, NULL, 1197, true, '2015-11-06 16:04:13.593497+01', NULL, 15, NULL, NULL);
INSERT INTO nom_objet (pk_nom_objet, nom, langue, notes, fk_objet, est_standard, date_creation, date_modification, fk_type_nom_param, date_debut, date_fin) VALUES (408, 'Pierre Brumoy', NULL, NULL, 1198, true, '2015-11-06 16:04:13.593497+01', NULL, 15, NULL, NULL);
INSERT INTO nom_objet (pk_nom_objet, nom, langue, notes, fk_objet, est_standard, date_creation, date_modification, fk_type_nom_param, date_debut, date_fin) VALUES (409, 'Bernard-Laurent Soumille', NULL, NULL, 1199, true, '2015-11-06 16:04:13.593497+01', NULL, 15, NULL, NULL);
INSERT INTO nom_objet (pk_nom_objet, nom, langue, notes, fk_objet, est_standard, date_creation, date_modification, fk_type_nom_param, date_debut, date_fin) VALUES (410, 'Louis Godin', NULL, NULL, 1200, true, '2015-11-06 16:04:13.593497+01', NULL, 15, NULL, NULL);
INSERT INTO nom_objet (pk_nom_objet, nom, langue, notes, fk_objet, est_standard, date_creation, date_modification, fk_type_nom_param, date_debut, date_fin) VALUES (411, 'Mario Guiducci', NULL, NULL, 1201, true, '2015-11-06 16:04:13.593497+01', NULL, 15, NULL, NULL);
INSERT INTO nom_objet (pk_nom_objet, nom, langue, notes, fk_objet, est_standard, date_creation, date_modification, fk_type_nom_param, date_debut, date_fin) VALUES (412, 'Godfried Wendelen', NULL, NULL, 1202, true, '2015-11-06 16:04:13.593497+01', NULL, 15, NULL, NULL);
INSERT INTO nom_objet (pk_nom_objet, nom, langue, notes, fk_objet, est_standard, date_creation, date_modification, fk_type_nom_param, date_debut, date_fin) VALUES (413, 'Claude Irson', NULL, NULL, 1203, true, '2015-11-06 16:04:13.593497+01', NULL, 15, NULL, NULL);
INSERT INTO nom_objet (pk_nom_objet, nom, langue, notes, fk_objet, est_standard, date_creation, date_modification, fk_type_nom_param, date_debut, date_fin) VALUES (414, 'Simon Lhuilier', NULL, NULL, 1204, true, '2015-11-06 16:04:13.593497+01', NULL, 15, NULL, NULL);
INSERT INTO nom_objet (pk_nom_objet, nom, langue, notes, fk_objet, est_standard, date_creation, date_modification, fk_type_nom_param, date_debut, date_fin) VALUES (415, 'Barlaam de Seminara', NULL, NULL, 1205, true, '2015-11-06 16:04:13.593497+01', NULL, 15, NULL, NULL);
INSERT INTO nom_objet (pk_nom_objet, nom, langue, notes, fk_objet, est_standard, date_creation, date_modification, fk_type_nom_param, date_debut, date_fin) VALUES (416, 'Noël Regnault', NULL, NULL, 1206, true, '2015-11-06 16:04:13.593497+01', NULL, 15, NULL, NULL);
INSERT INTO nom_objet (pk_nom_objet, nom, langue, notes, fk_objet, est_standard, date_creation, date_modification, fk_type_nom_param, date_debut, date_fin) VALUES (417, 'Nicolas Copernic', NULL, NULL, 1207, true, '2015-11-06 16:04:13.593497+01', NULL, 15, NULL, NULL);
INSERT INTO nom_objet (pk_nom_objet, nom, langue, notes, fk_objet, est_standard, date_creation, date_modification, fk_type_nom_param, date_debut, date_fin) VALUES (418, 'Rheticus', NULL, NULL, 1208, true, '2015-11-06 16:04:13.593497+01', NULL, 15, NULL, NULL);
INSERT INTO nom_objet (pk_nom_objet, nom, langue, notes, fk_objet, est_standard, date_creation, date_modification, fk_type_nom_param, date_debut, date_fin) VALUES (419, 'Bernardino Zendrini', NULL, NULL, 1209, true, '2015-11-06 16:04:13.593497+01', NULL, 15, NULL, NULL);
INSERT INTO nom_objet (pk_nom_objet, nom, langue, notes, fk_objet, est_standard, date_creation, date_modification, fk_type_nom_param, date_debut, date_fin) VALUES (420, 'Nīlakaṇṭha Somayajī', NULL, NULL, 1210, true, '2015-11-06 16:04:13.593497+01', NULL, 15, NULL, NULL);
INSERT INTO nom_objet (pk_nom_objet, nom, langue, notes, fk_objet, est_standard, date_creation, date_modification, fk_type_nom_param, date_debut, date_fin) VALUES (421, 'Giovanni Battista Vertova', NULL, NULL, 1211, true, '2015-11-06 16:04:13.593497+01', NULL, 15, NULL, NULL);
INSERT INTO nom_objet (pk_nom_objet, nom, langue, notes, fk_objet, est_standard, date_creation, date_modification, fk_type_nom_param, date_debut, date_fin) VALUES (422, 'Pierre Tédenat', NULL, NULL, 1212, true, '2015-11-06 16:04:13.593497+01', NULL, 15, NULL, NULL);
INSERT INTO nom_objet (pk_nom_objet, nom, langue, notes, fk_objet, est_standard, date_creation, date_modification, fk_type_nom_param, date_debut, date_fin) VALUES (423, 'Jean-Louis Dupain-Triel', NULL, NULL, 1213, true, '2015-11-06 16:04:13.593497+01', NULL, 15, NULL, NULL);
INSERT INTO nom_objet (pk_nom_objet, nom, langue, notes, fk_objet, est_standard, date_creation, date_modification, fk_type_nom_param, date_debut, date_fin) VALUES (424, 'Alexandre de Villedieu', NULL, NULL, 1214, true, '2015-11-06 16:04:13.593497+01', NULL, 15, NULL, NULL);
INSERT INTO nom_objet (pk_nom_objet, nom, langue, notes, fk_objet, est_standard, date_creation, date_modification, fk_type_nom_param, date_debut, date_fin) VALUES (425, 'Francesco Feliciano', NULL, NULL, 1215, true, '2015-11-06 16:04:13.593497+01', NULL, 15, NULL, NULL);
INSERT INTO nom_objet (pk_nom_objet, nom, langue, notes, fk_objet, est_standard, date_creation, date_modification, fk_type_nom_param, date_debut, date_fin) VALUES (426, 'James Hume', NULL, NULL, 1216, true, '2015-11-06 16:04:13.593497+01', NULL, 15, NULL, NULL);
INSERT INTO nom_objet (pk_nom_objet, nom, langue, notes, fk_objet, est_standard, date_creation, date_modification, fk_type_nom_param, date_debut, date_fin) VALUES (427, 'Giovanni Giustino Ciampini', NULL, NULL, 1217, true, '2015-11-06 16:04:13.593497+01', NULL, 15, NULL, NULL);
INSERT INTO nom_objet (pk_nom_objet, nom, langue, notes, fk_objet, est_standard, date_creation, date_modification, fk_type_nom_param, date_debut, date_fin) VALUES (428, 'Giuseppe CalandrelliZ', NULL, NULL, 1218, true, '2015-11-06 16:04:13.593497+01', NULL, 15, NULL, NULL);
INSERT INTO nom_objet (pk_nom_objet, nom, langue, notes, fk_objet, est_standard, date_creation, date_modification, fk_type_nom_param, date_debut, date_fin) VALUES (429, 'René Descartes', NULL, NULL, 1219, true, '2015-11-06 16:04:13.593497+01', NULL, 15, NULL, NULL);
INSERT INTO nom_objet (pk_nom_objet, nom, langue, notes, fk_objet, est_standard, date_creation, date_modification, fk_type_nom_param, date_debut, date_fin) VALUES (430, 'Joseph-Aignan Sigaud de La Fond', NULL, NULL, 1220, true, '2015-11-06 16:04:13.593497+01', NULL, 15, NULL, NULL);
INSERT INTO nom_objet (pk_nom_objet, nom, langue, notes, fk_objet, est_standard, date_creation, date_modification, fk_type_nom_param, date_debut, date_fin) VALUES (431, 'Charles-Joseph Mathon de La Cour', NULL, NULL, 1221, true, '2015-11-06 16:04:13.593497+01', NULL, 15, NULL, NULL);
INSERT INTO nom_objet (pk_nom_objet, nom, langue, notes, fk_objet, est_standard, date_creation, date_modification, fk_type_nom_param, date_debut, date_fin) VALUES (432, 'Oronce Fine', NULL, NULL, 1222, true, '2015-11-06 16:04:13.593497+01', NULL, 15, NULL, NULL);
INSERT INTO nom_objet (pk_nom_objet, nom, langue, notes, fk_objet, est_standard, date_creation, date_modification, fk_type_nom_param, date_debut, date_fin) VALUES (433, 'Willebrordus Snellius', NULL, NULL, 1223, true, '2015-11-06 16:04:13.593497+01', NULL, 15, NULL, NULL);
INSERT INTO nom_objet (pk_nom_objet, nom, langue, notes, fk_objet, est_standard, date_creation, date_modification, fk_type_nom_param, date_debut, date_fin) VALUES (434, 'Thomas Lydyat', NULL, NULL, 1224, true, '2015-11-06 16:04:13.593497+01', NULL, 15, NULL, NULL);
INSERT INTO nom_objet (pk_nom_objet, nom, langue, notes, fk_objet, est_standard, date_creation, date_modification, fk_type_nom_param, date_debut, date_fin) VALUES (435, 'Johann Matthias Hase', NULL, NULL, 1225, true, '2015-11-06 16:04:13.593497+01', NULL, 15, NULL, NULL);
INSERT INTO nom_objet (pk_nom_objet, nom, langue, notes, fk_objet, est_standard, date_creation, date_modification, fk_type_nom_param, date_debut, date_fin) VALUES (436, 'Christfried Kirch', NULL, NULL, 1226, true, '2015-11-06 16:04:13.593497+01', NULL, 15, NULL, NULL);
INSERT INTO nom_objet (pk_nom_objet, nom, langue, notes, fk_objet, est_standard, date_creation, date_modification, fk_type_nom_param, date_debut, date_fin) VALUES (437, 'Giovanni Poleni', NULL, NULL, 1227, true, '2015-11-06 16:04:13.593497+01', NULL, 15, NULL, NULL);
INSERT INTO nom_objet (pk_nom_objet, nom, langue, notes, fk_objet, est_standard, date_creation, date_modification, fk_type_nom_param, date_debut, date_fin) VALUES (438, 'Louis-Bertrand Castel', NULL, NULL, 1228, true, '2015-11-06 16:04:13.593497+01', NULL, 15, NULL, NULL);
INSERT INTO nom_objet (pk_nom_objet, nom, langue, notes, fk_objet, est_standard, date_creation, date_modification, fk_type_nom_param, date_debut, date_fin) VALUES (439, 'Johann Tobias Mayer', NULL, NULL, 1229, true, '2015-11-06 16:04:13.593497+01', NULL, 15, NULL, NULL);
INSERT INTO nom_objet (pk_nom_objet, nom, langue, notes, fk_objet, est_standard, date_creation, date_modification, fk_type_nom_param, date_debut, date_fin) VALUES (440, 'Alexandre-Balthazar-Laurent Grimod de La Reynière', NULL, NULL, 1230, true, '2015-11-06 16:04:13.593497+01', NULL, 15, NULL, NULL);
INSERT INTO nom_objet (pk_nom_objet, nom, langue, notes, fk_objet, est_standard, date_creation, date_modification, fk_type_nom_param, date_debut, date_fin) VALUES (441, 'Giovanni Battista Amico', NULL, NULL, 1231, true, '2015-11-06 16:04:13.593497+01', NULL, 15, NULL, NULL);
INSERT INTO nom_objet (pk_nom_objet, nom, langue, notes, fk_objet, est_standard, date_creation, date_modification, fk_type_nom_param, date_debut, date_fin) VALUES (442, 'Helisaeus Röslin', NULL, NULL, 1232, true, '2015-11-06 16:04:13.593497+01', NULL, 15, NULL, NULL);
INSERT INTO nom_objet (pk_nom_objet, nom, langue, notes, fk_objet, est_standard, date_creation, date_modification, fk_type_nom_param, date_debut, date_fin) VALUES (443, 'Niccolò de Martino', NULL, NULL, 1233, true, '2015-11-06 16:04:13.593497+01', NULL, 15, NULL, NULL);
INSERT INTO nom_objet (pk_nom_objet, nom, langue, notes, fk_objet, est_standard, date_creation, date_modification, fk_type_nom_param, date_debut, date_fin) VALUES (444, 'Jean Bernoulli', NULL, NULL, 1234, true, '2015-11-06 16:04:13.593497+01', NULL, 15, NULL, NULL);
INSERT INTO nom_objet (pk_nom_objet, nom, langue, notes, fk_objet, est_standard, date_creation, date_modification, fk_type_nom_param, date_debut, date_fin) VALUES (445, 'Giovanni Antonio Tagliente', NULL, NULL, 1235, true, '2015-11-06 16:04:13.593497+01', NULL, 15, NULL, NULL);
INSERT INTO nom_objet (pk_nom_objet, nom, langue, notes, fk_objet, est_standard, date_creation, date_modification, fk_type_nom_param, date_debut, date_fin) VALUES (446, 'Eustachio Zanotti', NULL, NULL, 1236, true, '2015-11-06 16:04:13.593497+01', NULL, 15, NULL, NULL);
INSERT INTO nom_objet (pk_nom_objet, nom, langue, notes, fk_objet, est_standard, date_creation, date_modification, fk_type_nom_param, date_debut, date_fin) VALUES (447, 'Alexandre-Théophile Vandermonde', NULL, NULL, 1237, true, '2015-11-06 16:04:13.593497+01', NULL, 15, NULL, NULL);
INSERT INTO nom_objet (pk_nom_objet, nom, langue, notes, fk_objet, est_standard, date_creation, date_modification, fk_type_nom_param, date_debut, date_fin) VALUES (448, 'Antonio CagnoliZ', NULL, NULL, 1238, true, '2015-11-06 16:04:13.593497+01', NULL, 15, NULL, NULL);
INSERT INTO nom_objet (pk_nom_objet, nom, langue, notes, fk_objet, est_standard, date_creation, date_modification, fk_type_nom_param, date_debut, date_fin) VALUES (449, 'Théodore Métochite', NULL, NULL, 1239, true, '2015-11-06 16:04:13.593497+01', NULL, 15, NULL, NULL);
INSERT INTO nom_objet (pk_nom_objet, nom, langue, notes, fk_objet, est_standard, date_creation, date_modification, fk_type_nom_param, date_debut, date_fin) VALUES (450, 'Maurille-Antoine Moithey', NULL, NULL, 1240, true, '2015-11-06 16:04:13.593497+01', NULL, 15, NULL, NULL);
INSERT INTO nom_objet (pk_nom_objet, nom, langue, notes, fk_objet, est_standard, date_creation, date_modification, fk_type_nom_param, date_debut, date_fin) VALUES (451, 'Albert Pighius', NULL, NULL, 1241, true, '2015-11-06 16:04:13.593497+01', NULL, 15, NULL, NULL);
INSERT INTO nom_objet (pk_nom_objet, nom, langue, notes, fk_objet, est_standard, date_creation, date_modification, fk_type_nom_param, date_debut, date_fin) VALUES (452, 'Johannes Wilhelm Lauremberg', NULL, NULL, 1242, true, '2015-11-06 16:04:13.593497+01', NULL, 15, NULL, NULL);
INSERT INTO nom_objet (pk_nom_objet, nom, langue, notes, fk_objet, est_standard, date_creation, date_modification, fk_type_nom_param, date_debut, date_fin) VALUES (453, 'Antonio Maria Lorgna', NULL, NULL, 1243, true, '2015-11-06 16:04:13.593497+01', NULL, 15, NULL, NULL);
INSERT INTO nom_objet (pk_nom_objet, nom, langue, notes, fk_objet, est_standard, date_creation, date_modification, fk_type_nom_param, date_debut, date_fin) VALUES (454, 'Giovanni Battista Amici', NULL, NULL, 1244, true, '2015-11-06 16:04:13.593497+01', NULL, 15, NULL, NULL);
INSERT INTO nom_objet (pk_nom_objet, nom, langue, notes, fk_objet, est_standard, date_creation, date_modification, fk_type_nom_param, date_debut, date_fin) VALUES (455, 'Egnatio Danti', NULL, NULL, 1245, true, '2015-11-06 16:04:13.593497+01', NULL, 15, NULL, NULL);
INSERT INTO nom_objet (pk_nom_objet, nom, langue, notes, fk_objet, est_standard, date_creation, date_modification, fk_type_nom_param, date_debut, date_fin) VALUES (456, 'Juan de Caramuel y Lobkowitz', NULL, NULL, 1246, true, '2015-11-06 16:04:13.593497+01', NULL, 15, NULL, NULL);
INSERT INTO nom_objet (pk_nom_objet, nom, langue, notes, fk_objet, est_standard, date_creation, date_modification, fk_type_nom_param, date_debut, date_fin) VALUES (457, 'John Dee', NULL, NULL, 1247, true, '2015-11-06 16:04:13.593497+01', NULL, 15, NULL, NULL);
INSERT INTO nom_objet (pk_nom_objet, nom, langue, notes, fk_objet, est_standard, date_creation, date_modification, fk_type_nom_param, date_debut, date_fin) VALUES (458, 'Anders Bure', NULL, NULL, 1248, true, '2015-11-06 16:04:13.593497+01', NULL, 15, NULL, NULL);
INSERT INTO nom_objet (pk_nom_objet, nom, langue, notes, fk_objet, est_standard, date_creation, date_modification, fk_type_nom_param, date_debut, date_fin) VALUES (459, 'Ugolino Pisani', NULL, NULL, 1249, true, '2015-11-06 16:04:13.593497+01', NULL, 15, NULL, NULL);
INSERT INTO nom_objet (pk_nom_objet, nom, langue, notes, fk_objet, est_standard, date_creation, date_modification, fk_type_nom_param, date_debut, date_fin) VALUES (460, 'Girolamo Saccheri', NULL, NULL, 1250, true, '2015-11-06 16:04:13.593497+01', NULL, 15, NULL, NULL);
INSERT INTO nom_objet (pk_nom_objet, nom, langue, notes, fk_objet, est_standard, date_creation, date_modification, fk_type_nom_param, date_debut, date_fin) VALUES (461, 'Jai Singh', NULL, NULL, 1251, true, '2015-11-06 16:04:13.593497+01', NULL, 15, NULL, NULL);
INSERT INTO nom_objet (pk_nom_objet, nom, langue, notes, fk_objet, est_standard, date_creation, date_modification, fk_type_nom_param, date_debut, date_fin) VALUES (462, 'Barnaba Oriani', NULL, NULL, 1252, true, '2015-11-06 16:04:13.593497+01', NULL, 15, NULL, NULL);
INSERT INTO nom_objet (pk_nom_objet, nom, langue, notes, fk_objet, est_standard, date_creation, date_modification, fk_type_nom_param, date_debut, date_fin) VALUES (463, 'Pierre Jartoux', NULL, NULL, 1253, true, '2015-11-06 16:04:13.593497+01', NULL, 15, NULL, NULL);
INSERT INTO nom_objet (pk_nom_objet, nom, langue, notes, fk_objet, est_standard, date_creation, date_modification, fk_type_nom_param, date_debut, date_fin) VALUES (464, 'Valentin Mennher', NULL, NULL, 1254, true, '2015-11-06 16:04:13.593497+01', NULL, 15, NULL, NULL);
INSERT INTO nom_objet (pk_nom_objet, nom, langue, notes, fk_objet, est_standard, date_creation, date_modification, fk_type_nom_param, date_debut, date_fin) VALUES (465, 'Pedro Nunez', NULL, NULL, 1255, true, '2015-11-06 16:04:13.593497+01', NULL, 15, NULL, NULL);
INSERT INTO nom_objet (pk_nom_objet, nom, langue, notes, fk_objet, est_standard, date_creation, date_modification, fk_type_nom_param, date_debut, date_fin) VALUES (466, 'Joseph Salomon Delmedigo', NULL, NULL, 1256, true, '2015-11-06 16:04:13.593497+01', NULL, 15, NULL, NULL);
INSERT INTO nom_objet (pk_nom_objet, nom, langue, notes, fk_objet, est_standard, date_creation, date_modification, fk_type_nom_param, date_debut, date_fin) VALUES (467, 'Jean Du Temps', NULL, NULL, 1257, true, '2015-11-06 16:04:13.593497+01', NULL, 15, NULL, NULL);
INSERT INTO nom_objet (pk_nom_objet, nom, langue, notes, fk_objet, est_standard, date_creation, date_modification, fk_type_nom_param, date_debut, date_fin) VALUES (468, 'Joanne Westenburg', NULL, NULL, 1258, true, '2015-11-06 16:04:13.593497+01', NULL, 15, NULL, NULL);
INSERT INTO nom_objet (pk_nom_objet, nom, langue, notes, fk_objet, est_standard, date_creation, date_modification, fk_type_nom_param, date_debut, date_fin) VALUES (469, 'Jakob Bartsch', NULL, NULL, 1259, true, '2015-11-06 16:04:13.593497+01', NULL, 15, NULL, NULL);
INSERT INTO nom_objet (pk_nom_objet, nom, langue, notes, fk_objet, est_standard, date_creation, date_modification, fk_type_nom_param, date_debut, date_fin) VALUES (470, 'Katahiro Takebe', NULL, NULL, 1260, true, '2015-11-06 16:04:13.593497+01', NULL, 15, NULL, NULL);
INSERT INTO nom_objet (pk_nom_objet, nom, langue, notes, fk_objet, est_standard, date_creation, date_modification, fk_type_nom_param, date_debut, date_fin) VALUES (471, 'Christian Goldbach', NULL, NULL, 1261, true, '2015-11-06 16:04:13.593497+01', NULL, 15, NULL, NULL);
INSERT INTO nom_objet (pk_nom_objet, nom, langue, notes, fk_objet, est_standard, date_creation, date_modification, fk_type_nom_param, date_debut, date_fin) VALUES (472, 'Giovanni Battista Venturi', NULL, NULL, 1262, true, '2015-11-06 16:04:13.593497+01', NULL, 15, NULL, NULL);
INSERT INTO nom_objet (pk_nom_objet, nom, langue, notes, fk_objet, est_standard, date_creation, date_modification, fk_type_nom_param, date_debut, date_fin) VALUES (473, 'Charles Duvaucel', NULL, NULL, 1263, true, '2015-11-06 16:04:13.593497+01', NULL, 15, NULL, NULL);
INSERT INTO nom_objet (pk_nom_objet, nom, langue, notes, fk_objet, est_standard, date_creation, date_modification, fk_type_nom_param, date_debut, date_fin) VALUES (474, 'Thomas Abbt', NULL, NULL, 1264, true, '2015-11-06 16:04:13.593497+01', NULL, 15, NULL, NULL);
INSERT INTO nom_objet (pk_nom_objet, nom, langue, notes, fk_objet, est_standard, date_creation, date_modification, fk_type_nom_param, date_debut, date_fin) VALUES (475, 'Philips Mor', NULL, NULL, 1265, true, '2015-11-06 16:04:13.593497+01', NULL, 15, NULL, NULL);
INSERT INTO nom_objet (pk_nom_objet, nom, langue, notes, fk_objet, est_standard, date_creation, date_modification, fk_type_nom_param, date_debut, date_fin) VALUES (476, 'Jean-Baptiste Delambre', NULL, NULL, 1266, true, '2015-11-06 16:04:13.593497+01', NULL, 15, NULL, NULL);
INSERT INTO nom_objet (pk_nom_objet, nom, langue, notes, fk_objet, est_standard, date_creation, date_modification, fk_type_nom_param, date_debut, date_fin) VALUES (477, 'Charles Cavendish', NULL, NULL, 1267, true, '2015-11-06 16:04:13.593497+01', NULL, 15, NULL, NULL);
INSERT INTO nom_objet (pk_nom_objet, nom, langue, notes, fk_objet, est_standard, date_creation, date_modification, fk_type_nom_param, date_debut, date_fin) VALUES (478, 'Erhard Weigel', NULL, NULL, 1268, true, '2015-11-06 16:04:13.593497+01', NULL, 15, NULL, NULL);
INSERT INTO nom_objet (pk_nom_objet, nom, langue, notes, fk_objet, est_standard, date_creation, date_modification, fk_type_nom_param, date_debut, date_fin) VALUES (479, 'Ismaël Boulliau', NULL, NULL, 1269, true, '2015-11-06 16:04:13.593497+01', NULL, 15, NULL, NULL);
INSERT INTO nom_objet (pk_nom_objet, nom, langue, notes, fk_objet, est_standard, date_creation, date_modification, fk_type_nom_param, date_debut, date_fin) VALUES (480, 'Matthias Bernegger', NULL, NULL, 1270, true, '2015-11-06 16:04:13.593497+01', NULL, 15, NULL, NULL);
INSERT INTO nom_objet (pk_nom_objet, nom, langue, notes, fk_objet, est_standard, date_creation, date_modification, fk_type_nom_param, date_debut, date_fin) VALUES (481, 'Muḥammad ibn al-Ḥusayan Bahāʼ al-Dīn ʿĀmilī', NULL, NULL, 1271, true, '2015-11-06 16:04:13.593497+01', NULL, 15, NULL, NULL);
INSERT INTO nom_objet (pk_nom_objet, nom, langue, notes, fk_objet, est_standard, date_creation, date_modification, fk_type_nom_param, date_debut, date_fin) VALUES (482, 'Guangqi Xu', NULL, NULL, 1272, true, '2015-11-06 16:04:13.593497+01', NULL, 15, NULL, NULL);
INSERT INTO nom_objet (pk_nom_objet, nom, langue, notes, fk_objet, est_standard, date_creation, date_modification, fk_type_nom_param, date_debut, date_fin) VALUES (483, 'Lorenzo Mascheroni', NULL, NULL, 1273, true, '2015-11-06 16:04:13.593497+01', NULL, 15, NULL, NULL);
INSERT INTO nom_objet (pk_nom_objet, nom, langue, notes, fk_objet, est_standard, date_creation, date_modification, fk_type_nom_param, date_debut, date_fin) VALUES (484, 'Gerhard Wolter Molanus', NULL, NULL, 1274, true, '2015-11-06 16:04:13.593497+01', NULL, 15, NULL, NULL);
INSERT INTO nom_objet (pk_nom_objet, nom, langue, notes, fk_objet, est_standard, date_creation, date_modification, fk_type_nom_param, date_debut, date_fin) VALUES (485, 'Bingzhen Jiao', NULL, NULL, 1275, true, '2015-11-06 16:04:13.593497+01', NULL, 15, NULL, NULL);
INSERT INTO nom_objet (pk_nom_objet, nom, langue, notes, fk_objet, est_standard, date_creation, date_modification, fk_type_nom_param, date_debut, date_fin) VALUES (486, 'Ernst Gottfried Fischer', NULL, NULL, 1276, true, '2015-11-06 16:04:13.593497+01', NULL, 15, NULL, NULL);
INSERT INTO nom_objet (pk_nom_objet, nom, langue, notes, fk_objet, est_standard, date_creation, date_modification, fk_type_nom_param, date_debut, date_fin) VALUES (487, 'Yves-Marie André', NULL, NULL, 1277, true, '2015-11-06 16:04:13.593497+01', NULL, 15, NULL, NULL);
INSERT INTO nom_objet (pk_nom_objet, nom, langue, notes, fk_objet, est_standard, date_creation, date_modification, fk_type_nom_param, date_debut, date_fin) VALUES (488, 'Pedro Nunes', NULL, NULL, 1278, true, '2015-11-06 16:04:13.593497+01', NULL, 15, NULL, NULL);
INSERT INTO nom_objet (pk_nom_objet, nom, langue, notes, fk_objet, est_standard, date_creation, date_modification, fk_type_nom_param, date_debut, date_fin) VALUES (489, 'Mario Bettini', NULL, NULL, 1279, true, '2015-11-06 16:04:13.593497+01', NULL, 15, NULL, NULL);
INSERT INTO nom_objet (pk_nom_objet, nom, langue, notes, fk_objet, est_standard, date_creation, date_modification, fk_type_nom_param, date_debut, date_fin) VALUES (490, 'Samuel Morland', NULL, NULL, 1280, true, '2015-11-06 16:04:13.593497+01', NULL, 15, NULL, NULL);
INSERT INTO nom_objet (pk_nom_objet, nom, langue, notes, fk_objet, est_standard, date_creation, date_modification, fk_type_nom_param, date_debut, date_fin) VALUES (491, 'Michel Coignet', NULL, NULL, 1281, true, '2015-11-06 16:04:13.593497+01', NULL, 15, NULL, NULL);
INSERT INTO nom_objet (pk_nom_objet, nom, langue, notes, fk_objet, est_standard, date_creation, date_modification, fk_type_nom_param, date_debut, date_fin) VALUES (492, 'Jean-Baptiste Delure', NULL, NULL, 1282, true, '2015-11-06 16:04:13.593497+01', NULL, 15, NULL, NULL);
INSERT INTO nom_objet (pk_nom_objet, nom, langue, notes, fk_objet, est_standard, date_creation, date_modification, fk_type_nom_param, date_debut, date_fin) VALUES (493, 'Giovanni Pontano', NULL, NULL, 1283, true, '2015-11-06 16:04:13.593497+01', NULL, 15, NULL, NULL);
INSERT INTO nom_objet (pk_nom_objet, nom, langue, notes, fk_objet, est_standard, date_creation, date_modification, fk_type_nom_param, date_debut, date_fin) VALUES (494, 'Peter Laicksteen', NULL, NULL, 1284, true, '2015-11-06 16:04:13.593497+01', NULL, 15, NULL, NULL);
INSERT INTO nom_objet (pk_nom_objet, nom, langue, notes, fk_objet, est_standard, date_creation, date_modification, fk_type_nom_param, date_debut, date_fin) VALUES (495, 'Christoph Meurer', NULL, NULL, 1285, true, '2015-11-06 16:04:13.593497+01', NULL, 15, NULL, NULL);
INSERT INTO nom_objet (pk_nom_objet, nom, langue, notes, fk_objet, est_standard, date_creation, date_modification, fk_type_nom_param, date_debut, date_fin) VALUES (496, 'Faustus Verantius', NULL, NULL, 1286, true, '2015-11-06 16:04:13.593497+01', NULL, 15, NULL, NULL);
INSERT INTO nom_objet (pk_nom_objet, nom, langue, notes, fk_objet, est_standard, date_creation, date_modification, fk_type_nom_param, date_debut, date_fin) VALUES (497, 'Abraham de Moivre', NULL, NULL, 1287, true, '2015-11-06 16:04:13.593497+01', NULL, 15, NULL, NULL);
INSERT INTO nom_objet (pk_nom_objet, nom, langue, notes, fk_objet, est_standard, date_creation, date_modification, fk_type_nom_param, date_debut, date_fin) VALUES (498, 'Walther Hermann Ryff', NULL, NULL, 1288, true, '2015-11-06 16:04:13.593497+01', NULL, 15, NULL, NULL);
INSERT INTO nom_objet (pk_nom_objet, nom, langue, notes, fk_objet, est_standard, date_creation, date_modification, fk_type_nom_param, date_debut, date_fin) VALUES (499, 'Pietro Mengoli', NULL, NULL, 1289, true, '2015-11-06 16:04:13.593497+01', NULL, 15, NULL, NULL);
INSERT INTO nom_objet (pk_nom_objet, nom, langue, notes, fk_objet, est_standard, date_creation, date_modification, fk_type_nom_param, date_debut, date_fin) VALUES (500, 'Pierre Ango', NULL, NULL, 1290, true, '2015-11-06 16:04:13.593497+01', NULL, 15, NULL, NULL);
INSERT INTO nom_objet (pk_nom_objet, nom, langue, notes, fk_objet, est_standard, date_creation, date_modification, fk_type_nom_param, date_debut, date_fin) VALUES (501, 'Ovidio Montalbani', NULL, NULL, 1291, true, '2015-11-06 16:04:13.593497+01', NULL, 15, NULL, NULL);
INSERT INTO nom_objet (pk_nom_objet, nom, langue, notes, fk_objet, est_standard, date_creation, date_modification, fk_type_nom_param, date_debut, date_fin) VALUES (502, 'Michel Rolle', NULL, NULL, 1292, true, '2015-11-06 16:04:13.593497+01', NULL, 15, NULL, NULL);
INSERT INTO nom_objet (pk_nom_objet, nom, langue, notes, fk_objet, est_standard, date_creation, date_modification, fk_type_nom_param, date_debut, date_fin) VALUES (503, 'Jean Maria Coloni', NULL, NULL, 1293, true, '2015-11-06 16:04:13.593497+01', NULL, 15, NULL, NULL);
INSERT INTO nom_objet (pk_nom_objet, nom, langue, notes, fk_objet, est_standard, date_creation, date_modification, fk_type_nom_param, date_debut, date_fin) VALUES (504, 'Orazio Grassi', NULL, NULL, 1294, true, '2015-11-06 16:04:13.593497+01', NULL, 15, NULL, NULL);
INSERT INTO nom_objet (pk_nom_objet, nom, langue, notes, fk_objet, est_standard, date_creation, date_modification, fk_type_nom_param, date_debut, date_fin) VALUES (505, 'Marco Antonio De Dominis', NULL, NULL, 1295, true, '2015-11-06 16:04:13.593497+01', NULL, 15, NULL, NULL);
INSERT INTO nom_objet (pk_nom_objet, nom, langue, notes, fk_objet, est_standard, date_creation, date_modification, fk_type_nom_param, date_debut, date_fin) VALUES (506, 'Edmund Halley', NULL, NULL, 1296, true, '2015-11-06 16:04:13.593497+01', NULL, 15, NULL, NULL);
INSERT INTO nom_objet (pk_nom_objet, nom, langue, notes, fk_objet, est_standard, date_creation, date_modification, fk_type_nom_param, date_debut, date_fin) VALUES (507, 'Johann Gabriel Doppelmayr', NULL, NULL, 1297, true, '2015-11-06 16:04:13.593497+01', NULL, 15, NULL, NULL);
INSERT INTO nom_objet (pk_nom_objet, nom, langue, notes, fk_objet, est_standard, date_creation, date_modification, fk_type_nom_param, date_debut, date_fin) VALUES (508, 'Jacques de Billy', NULL, NULL, 1298, true, '2015-11-06 16:04:13.593497+01', NULL, 15, NULL, NULL);
INSERT INTO nom_objet (pk_nom_objet, nom, langue, notes, fk_objet, est_standard, date_creation, date_modification, fk_type_nom_param, date_debut, date_fin) VALUES (509, 'Jacques Baradelle', NULL, NULL, 1299, true, '2015-11-06 16:04:13.593497+01', NULL, 15, NULL, NULL);
INSERT INTO nom_objet (pk_nom_objet, nom, langue, notes, fk_objet, est_standard, date_creation, date_modification, fk_type_nom_param, date_debut, date_fin) VALUES (510, 'Claude Mydorge', NULL, NULL, 1300, true, '2015-11-06 16:04:13.593497+01', NULL, 15, NULL, NULL);
INSERT INTO nom_objet (pk_nom_objet, nom, langue, notes, fk_objet, est_standard, date_creation, date_modification, fk_type_nom_param, date_debut, date_fin) VALUES (511, 'G.-F. Olivier', NULL, NULL, 1301, true, '2015-11-06 16:04:13.593497+01', NULL, 15, NULL, NULL);
INSERT INTO nom_objet (pk_nom_objet, nom, langue, notes, fk_objet, est_standard, date_creation, date_modification, fk_type_nom_param, date_debut, date_fin) VALUES (512, 'Thomas Keith', NULL, NULL, 1302, true, '2015-11-06 16:04:13.593497+01', NULL, 15, NULL, NULL);
INSERT INTO nom_objet (pk_nom_objet, nom, langue, notes, fk_objet, est_standard, date_creation, date_modification, fk_type_nom_param, date_debut, date_fin) VALUES (513, 'Federico Commandino', NULL, NULL, 1303, true, '2015-11-06 16:04:13.593497+01', NULL, 15, NULL, NULL);
INSERT INTO nom_objet (pk_nom_objet, nom, langue, notes, fk_objet, est_standard, date_creation, date_modification, fk_type_nom_param, date_debut, date_fin) VALUES (514, 'José Chaffrion', NULL, NULL, 1304, true, '2015-11-06 16:04:13.593497+01', NULL, 15, NULL, NULL);
INSERT INTO nom_objet (pk_nom_objet, nom, langue, notes, fk_objet, est_standard, date_creation, date_modification, fk_type_nom_param, date_debut, date_fin) VALUES (515, 'Pierre-Louis Moreau de Maupertuis', NULL, NULL, 1305, true, '2015-11-06 16:04:13.593497+01', NULL, 15, NULL, NULL);
INSERT INTO nom_objet (pk_nom_objet, nom, langue, notes, fk_objet, est_standard, date_creation, date_modification, fk_type_nom_param, date_debut, date_fin) VALUES (516, 'al-Mufaḍḍal ibn ʿUmar Aṯīr al-Dīn al-Abharī', NULL, NULL, 1306, true, '2015-11-06 16:04:13.593497+01', NULL, 15, NULL, NULL);
INSERT INTO nom_objet (pk_nom_objet, nom, langue, notes, fk_objet, est_standard, date_creation, date_modification, fk_type_nom_param, date_debut, date_fin) VALUES (517, 'Thomas Hariot', NULL, NULL, 1307, true, '2015-11-06 16:04:13.593497+01', NULL, 15, NULL, NULL);
INSERT INTO nom_objet (pk_nom_objet, nom, langue, notes, fk_objet, est_standard, date_creation, date_modification, fk_type_nom_param, date_debut, date_fin) VALUES (518, 'Giovanni Branca', NULL, NULL, 1308, true, '2015-11-06 16:04:13.593497+01', NULL, 15, NULL, NULL);
INSERT INTO nom_objet (pk_nom_objet, nom, langue, notes, fk_objet, est_standard, date_creation, date_modification, fk_type_nom_param, date_debut, date_fin) VALUES (519, 'Johann Balthasar Lauterbach', NULL, NULL, 1309, true, '2015-11-06 16:04:13.593497+01', NULL, 15, NULL, NULL);
INSERT INTO nom_objet (pk_nom_objet, nom, langue, notes, fk_objet, est_standard, date_creation, date_modification, fk_type_nom_param, date_debut, date_fin) VALUES (520, 'François-César Le Tellier Courtanvaux', NULL, NULL, 1310, true, '2015-11-06 16:04:13.593497+01', NULL, 15, NULL, NULL);
INSERT INTO nom_objet (pk_nom_objet, nom, langue, notes, fk_objet, est_standard, date_creation, date_modification, fk_type_nom_param, date_debut, date_fin) VALUES (521, 'Francis Van Schoten', NULL, NULL, 1311, true, '2015-11-06 16:04:13.593497+01', NULL, 15, NULL, NULL);
INSERT INTO nom_objet (pk_nom_objet, nom, langue, notes, fk_objet, est_standard, date_creation, date_modification, fk_type_nom_param, date_debut, date_fin) VALUES (522, 'Claude-Gaspard Bachet', NULL, NULL, 1312, true, '2015-11-06 16:04:13.593497+01', NULL, 15, NULL, NULL);
INSERT INTO nom_objet (pk_nom_objet, nom, langue, notes, fk_objet, est_standard, date_creation, date_modification, fk_type_nom_param, date_debut, date_fin) VALUES (523, 'Joseph-Louis Vincens de Mauléon de Causans', NULL, NULL, 1313, true, '2015-11-06 16:04:13.593497+01', NULL, 15, NULL, NULL);
INSERT INTO nom_objet (pk_nom_objet, nom, langue, notes, fk_objet, est_standard, date_creation, date_modification, fk_type_nom_param, date_debut, date_fin) VALUES (524, 'Giovanni Battista Hodierna', NULL, NULL, 1314, true, '2015-11-06 16:04:13.593497+01', NULL, 15, NULL, NULL);
INSERT INTO nom_objet (pk_nom_objet, nom, langue, notes, fk_objet, est_standard, date_creation, date_modification, fk_type_nom_param, date_debut, date_fin) VALUES (525, 'Giuseppe Toaldo', NULL, NULL, 1315, true, '2015-11-06 16:04:13.593497+01', NULL, 15, NULL, NULL);
INSERT INTO nom_objet (pk_nom_objet, nom, langue, notes, fk_objet, est_standard, date_creation, date_modification, fk_type_nom_param, date_debut, date_fin) VALUES (526, 'Antoine Deparcieux', NULL, NULL, 1316, true, '2015-11-06 16:04:13.593497+01', NULL, 15, NULL, NULL);
INSERT INTO nom_objet (pk_nom_objet, nom, langue, notes, fk_objet, est_standard, date_creation, date_modification, fk_type_nom_param, date_debut, date_fin) VALUES (527, 'Johann Carion', NULL, NULL, 1317, true, '2015-11-06 16:04:13.593497+01', NULL, 15, NULL, NULL);
INSERT INTO nom_objet (pk_nom_objet, nom, langue, notes, fk_objet, est_standard, date_creation, date_modification, fk_type_nom_param, date_debut, date_fin) VALUES (528, 'Anthelme', NULL, NULL, 1318, true, '2015-11-06 16:04:13.593497+01', NULL, 15, NULL, NULL);
INSERT INTO nom_objet (pk_nom_objet, nom, langue, notes, fk_objet, est_standard, date_creation, date_modification, fk_type_nom_param, date_debut, date_fin) VALUES (529, 'Joachim d'' Alencé', NULL, NULL, 1319, true, '2015-11-06 16:04:13.593497+01', NULL, 15, NULL, NULL);
INSERT INTO nom_objet (pk_nom_objet, nom, langue, notes, fk_objet, est_standard, date_creation, date_modification, fk_type_nom_param, date_debut, date_fin) VALUES (530, 'Théodore Méliténiote', NULL, NULL, 1320, true, '2015-11-06 16:04:13.593497+01', NULL, 15, NULL, NULL);
INSERT INTO nom_objet (pk_nom_objet, nom, langue, notes, fk_objet, est_standard, date_creation, date_modification, fk_type_nom_param, date_debut, date_fin) VALUES (531, 'Eusebio Francisco Kino', NULL, NULL, 1321, true, '2015-11-06 16:04:13.593497+01', NULL, 15, NULL, NULL);
INSERT INTO nom_objet (pk_nom_objet, nom, langue, notes, fk_objet, est_standard, date_creation, date_modification, fk_type_nom_param, date_debut, date_fin) VALUES (532, 'Johann Hieronymus Schröter', NULL, NULL, 1322, true, '2015-11-06 16:04:13.593497+01', NULL, 15, NULL, NULL);
INSERT INTO nom_objet (pk_nom_objet, nom, langue, notes, fk_objet, est_standard, date_creation, date_modification, fk_type_nom_param, date_debut, date_fin) VALUES (533, 'Marc-Auguste Pictet', NULL, NULL, 1323, true, '2015-11-06 16:04:13.593497+01', NULL, 15, NULL, NULL);
INSERT INTO nom_objet (pk_nom_objet, nom, langue, notes, fk_objet, est_standard, date_creation, date_modification, fk_type_nom_param, date_debut, date_fin) VALUES (534, 'Richard of Wallingford', NULL, NULL, 1324, true, '2015-11-06 16:04:13.593497+01', NULL, 15, NULL, NULL);
INSERT INTO nom_objet (pk_nom_objet, nom, langue, notes, fk_objet, est_standard, date_creation, date_modification, fk_type_nom_param, date_debut, date_fin) VALUES (535, 'Rigobert Bonne', NULL, NULL, 1325, true, '2015-11-06 16:04:13.593497+01', NULL, 15, NULL, NULL);
INSERT INTO nom_objet (pk_nom_objet, nom, langue, notes, fk_objet, est_standard, date_creation, date_modification, fk_type_nom_param, date_debut, date_fin) VALUES (536, 'Bartolomeo da Messina', NULL, NULL, 1326, true, '2015-11-06 16:04:13.593497+01', NULL, 15, NULL, NULL);
INSERT INTO nom_objet (pk_nom_objet, nom, langue, notes, fk_objet, est_standard, date_creation, date_modification, fk_type_nom_param, date_debut, date_fin) VALUES (537, 'Juan de Rojas Sarmiento', NULL, NULL, 1327, true, '2015-11-06 16:04:13.593497+01', NULL, 15, NULL, NULL);
INSERT INTO nom_objet (pk_nom_objet, nom, langue, notes, fk_objet, est_standard, date_creation, date_modification, fk_type_nom_param, date_debut, date_fin) VALUES (538, 'Guillaume-Hyacinthe-Joseph-Jean-Baptiste Le Gentil de La Galaisière', NULL, NULL, 1328, true, '2015-11-06 16:04:13.593497+01', NULL, 15, NULL, NULL);
INSERT INTO nom_objet (pk_nom_objet, nom, langue, notes, fk_objet, est_standard, date_creation, date_modification, fk_type_nom_param, date_debut, date_fin) VALUES (539, 'Pierre Rémond de Montmort', NULL, NULL, 1329, true, '2015-11-06 16:04:13.593497+01', NULL, 15, NULL, NULL);
INSERT INTO nom_objet (pk_nom_objet, nom, langue, notes, fk_objet, est_standard, date_creation, date_modification, fk_type_nom_param, date_debut, date_fin) VALUES (540, 'Jean Tagaut', NULL, NULL, 1330, true, '2015-11-06 16:04:13.593497+01', NULL, 15, NULL, NULL);
INSERT INTO nom_objet (pk_nom_objet, nom, langue, notes, fk_objet, est_standard, date_creation, date_modification, fk_type_nom_param, date_debut, date_fin) VALUES (541, 'Samuel Horsley', NULL, NULL, 1331, true, '2015-11-06 16:04:13.593497+01', NULL, 15, NULL, NULL);
INSERT INTO nom_objet (pk_nom_objet, nom, langue, notes, fk_objet, est_standard, date_creation, date_modification, fk_type_nom_param, date_debut, date_fin) VALUES (542, 'Antide Janvier', NULL, NULL, 1332, true, '2015-11-06 16:04:13.593497+01', NULL, 15, NULL, NULL);
INSERT INTO nom_objet (pk_nom_objet, nom, langue, notes, fk_objet, est_standard, date_creation, date_modification, fk_type_nom_param, date_debut, date_fin) VALUES (543, 'Louis Boulengier', NULL, NULL, 1333, true, '2015-11-06 16:04:13.593497+01', NULL, 15, NULL, NULL);
INSERT INTO nom_objet (pk_nom_objet, nom, langue, notes, fk_objet, est_standard, date_creation, date_modification, fk_type_nom_param, date_debut, date_fin) VALUES (544, 'Etienne Lenoir', NULL, NULL, 1334, true, '2015-11-06 16:04:13.593497+01', NULL, 15, NULL, NULL);
INSERT INTO nom_objet (pk_nom_objet, nom, langue, notes, fk_objet, est_standard, date_creation, date_modification, fk_type_nom_param, date_debut, date_fin) VALUES (545, 'Jean-Henri Lambert', NULL, NULL, 1335, true, '2015-11-06 16:04:13.593497+01', NULL, 15, NULL, NULL);
INSERT INTO nom_objet (pk_nom_objet, nom, langue, notes, fk_objet, est_standard, date_creation, date_modification, fk_type_nom_param, date_debut, date_fin) VALUES (546, 'Ermenegildo Pini', NULL, NULL, 1336, true, '2015-11-06 16:04:13.593497+01', NULL, 15, NULL, NULL);
INSERT INTO nom_objet (pk_nom_objet, nom, langue, notes, fk_objet, est_standard, date_creation, date_modification, fk_type_nom_param, date_debut, date_fin) VALUES (547, 'Christoph Wittich', NULL, NULL, 1337, true, '2015-11-06 16:04:13.593497+01', NULL, 15, NULL, NULL);
INSERT INTO nom_objet (pk_nom_objet, nom, langue, notes, fk_objet, est_standard, date_creation, date_modification, fk_type_nom_param, date_debut, date_fin) VALUES (548, 'Georg Christoph Eimmart', NULL, NULL, 1338, true, '2015-11-06 16:04:13.593497+01', NULL, 15, NULL, NULL);
INSERT INTO nom_objet (pk_nom_objet, nom, langue, notes, fk_objet, est_standard, date_creation, date_modification, fk_type_nom_param, date_debut, date_fin) VALUES (549, 'Bartolomeo da Parma', NULL, NULL, 1339, true, '2015-11-06 16:04:13.593497+01', NULL, 15, NULL, NULL);
INSERT INTO nom_objet (pk_nom_objet, nom, langue, notes, fk_objet, est_standard, date_creation, date_modification, fk_type_nom_param, date_debut, date_fin) VALUES (550, 'François Viète', NULL, NULL, 1340, true, '2015-11-06 16:04:13.593497+01', NULL, 15, NULL, NULL);
INSERT INTO nom_objet (pk_nom_objet, nom, langue, notes, fk_objet, est_standard, date_creation, date_modification, fk_type_nom_param, date_debut, date_fin) VALUES (551, 'Giovanni-Antonio Rizzi-Zannoni', NULL, NULL, 1341, true, '2015-11-06 16:04:13.593497+01', NULL, 15, NULL, NULL);
INSERT INTO nom_objet (pk_nom_objet, nom, langue, notes, fk_objet, est_standard, date_creation, date_modification, fk_type_nom_param, date_debut, date_fin) VALUES (552, 'P. Christoph Grienberger', NULL, NULL, 1342, true, '2015-11-06 16:04:13.593497+01', NULL, 15, NULL, NULL);
INSERT INTO nom_objet (pk_nom_objet, nom, langue, notes, fk_objet, est_standard, date_creation, date_modification, fk_type_nom_param, date_debut, date_fin) VALUES (553, 'Cornelius Blockland', NULL, NULL, 1343, true, '2015-11-06 16:04:13.593497+01', NULL, 15, NULL, NULL);
INSERT INTO nom_objet (pk_nom_objet, nom, langue, notes, fk_objet, est_standard, date_creation, date_modification, fk_type_nom_param, date_debut, date_fin) VALUES (554, 'Jean-Étienne Montucla', NULL, NULL, 1344, true, '2015-11-06 16:04:13.593497+01', NULL, 15, NULL, NULL);
INSERT INTO nom_objet (pk_nom_objet, nom, langue, notes, fk_objet, est_standard, date_creation, date_modification, fk_type_nom_param, date_debut, date_fin) VALUES (555, 'Johann Hartmann', NULL, NULL, 1345, true, '2015-11-06 16:04:13.593497+01', NULL, 15, NULL, NULL);
INSERT INTO nom_objet (pk_nom_objet, nom, langue, notes, fk_objet, est_standard, date_creation, date_modification, fk_type_nom_param, date_debut, date_fin) VALUES (556, 'István Hatvani', NULL, NULL, 1346, true, '2015-11-06 16:04:13.593497+01', NULL, 15, NULL, NULL);
INSERT INTO nom_objet (pk_nom_objet, nom, langue, notes, fk_objet, est_standard, date_creation, date_modification, fk_type_nom_param, date_debut, date_fin) VALUES (557, 'Fulcrand Jean Joseph Aigrefeuille', NULL, NULL, 1347, true, '2015-11-06 16:04:13.593497+01', NULL, 15, NULL, NULL);
INSERT INTO nom_objet (pk_nom_objet, nom, langue, notes, fk_objet, est_standard, date_creation, date_modification, fk_type_nom_param, date_debut, date_fin) VALUES (558, 'Emmanuel-Étienne Duvillard de Durand', NULL, NULL, 1348, true, '2015-11-06 16:04:13.593497+01', NULL, 15, NULL, NULL);
INSERT INTO nom_objet (pk_nom_objet, nom, langue, notes, fk_objet, est_standard, date_creation, date_modification, fk_type_nom_param, date_debut, date_fin) VALUES (559, 'Giovanni Battista Audiffredi', NULL, NULL, 1349, true, '2015-11-06 16:04:13.593497+01', NULL, 15, NULL, NULL);
INSERT INTO nom_objet (pk_nom_objet, nom, langue, notes, fk_objet, est_standard, date_creation, date_modification, fk_type_nom_param, date_debut, date_fin) VALUES (560, 'Maria Gaetana Agnesi', NULL, NULL, 1350, true, '2015-11-06 16:04:13.593497+01', NULL, 15, NULL, NULL);
INSERT INTO nom_objet (pk_nom_objet, nom, langue, notes, fk_objet, est_standard, date_creation, date_modification, fk_type_nom_param, date_debut, date_fin) VALUES (561, 'Cormopede', NULL, NULL, 1351, true, '2015-11-06 16:04:13.593497+01', NULL, 15, NULL, NULL);
INSERT INTO nom_objet (pk_nom_objet, nom, langue, notes, fk_objet, est_standard, date_creation, date_modification, fk_type_nom_param, date_debut, date_fin) VALUES (562, 'Christoph Scheiner', NULL, NULL, 1352, true, '2015-11-06 16:04:13.593497+01', NULL, 15, NULL, NULL);
INSERT INTO nom_objet (pk_nom_objet, nom, langue, notes, fk_objet, est_standard, date_creation, date_modification, fk_type_nom_param, date_debut, date_fin) VALUES (563, 'Jean Leurechon', NULL, NULL, 1353, true, '2015-11-06 16:04:13.593497+01', NULL, 15, NULL, NULL);
INSERT INTO nom_objet (pk_nom_objet, nom, langue, notes, fk_objet, est_standard, date_creation, date_modification, fk_type_nom_param, date_debut, date_fin) VALUES (564, 'Jean-Baptiste Meusnier de La Place', NULL, NULL, 1354, true, '2015-11-06 16:04:13.593497+01', NULL, 15, NULL, NULL);
INSERT INTO nom_objet (pk_nom_objet, nom, langue, notes, fk_objet, est_standard, date_creation, date_modification, fk_type_nom_param, date_debut, date_fin) VALUES (565, 'Johannes Isaacus Pontanus', NULL, NULL, 1355, true, '2015-11-06 16:04:13.593497+01', NULL, 15, NULL, NULL);
INSERT INTO nom_objet (pk_nom_objet, nom, langue, notes, fk_objet, est_standard, date_creation, date_modification, fk_type_nom_param, date_debut, date_fin) VALUES (566, 'Jeronimo Munoz', NULL, NULL, 1356, true, '2015-11-06 16:04:13.593497+01', NULL, 15, NULL, NULL);
INSERT INTO nom_objet (pk_nom_objet, nom, langue, notes, fk_objet, est_standard, date_creation, date_modification, fk_type_nom_param, date_debut, date_fin) VALUES (567, 'Giovanni Battista Benedetti', NULL, NULL, 1357, true, '2015-11-06 16:04:13.593497+01', NULL, 15, NULL, NULL);
INSERT INTO nom_objet (pk_nom_objet, nom, langue, notes, fk_objet, est_standard, date_creation, date_modification, fk_type_nom_param, date_debut, date_fin) VALUES (568, 'Paul Yvon', NULL, NULL, 1358, true, '2015-11-06 16:04:13.593497+01', NULL, 15, NULL, NULL);
INSERT INTO nom_objet (pk_nom_objet, nom, langue, notes, fk_objet, est_standard, date_creation, date_modification, fk_type_nom_param, date_debut, date_fin) VALUES (569, 'Franz von Paula Triesnecker', NULL, NULL, 1359, true, '2015-11-06 16:04:13.593497+01', NULL, 15, NULL, NULL);
INSERT INTO nom_objet (pk_nom_objet, nom, langue, notes, fk_objet, est_standard, date_creation, date_modification, fk_type_nom_param, date_debut, date_fin) VALUES (570, 'Christen Sørensen Longomontanus', NULL, NULL, 1360, true, '2015-11-06 16:04:13.593497+01', NULL, 15, NULL, NULL);
INSERT INTO nom_objet (pk_nom_objet, nom, langue, notes, fk_objet, est_standard, date_creation, date_modification, fk_type_nom_param, date_debut, date_fin) VALUES (571, 'Leonardo Fibonacci', NULL, NULL, 1361, true, '2015-11-06 16:04:13.593497+01', NULL, 15, NULL, NULL);
INSERT INTO nom_objet (pk_nom_objet, nom, langue, notes, fk_objet, est_standard, date_creation, date_modification, fk_type_nom_param, date_debut, date_fin) VALUES (572, 'Jean Tarde', NULL, NULL, 1362, true, '2015-11-06 16:04:13.593497+01', NULL, 15, NULL, NULL);
INSERT INTO nom_objet (pk_nom_objet, nom, langue, notes, fk_objet, est_standard, date_creation, date_modification, fk_type_nom_param, date_debut, date_fin) VALUES (573, 'Francesco Bianchini', NULL, NULL, 1363, true, '2015-11-06 16:04:13.593497+01', NULL, 15, NULL, NULL);
INSERT INTO nom_objet (pk_nom_objet, nom, langue, notes, fk_objet, est_standard, date_creation, date_modification, fk_type_nom_param, date_debut, date_fin) VALUES (574, 'Louis-François-Antoine Arbogast', NULL, NULL, 1364, true, '2015-11-06 16:04:13.593497+01', NULL, 15, NULL, NULL);
INSERT INTO nom_objet (pk_nom_objet, nom, langue, notes, fk_objet, est_standard, date_creation, date_modification, fk_type_nom_param, date_debut, date_fin) VALUES (575, 'Jan Heweliusz', NULL, NULL, 1365, true, '2015-11-06 16:04:13.593497+01', NULL, 15, NULL, NULL);
INSERT INTO nom_objet (pk_nom_objet, nom, langue, notes, fk_objet, est_standard, date_creation, date_modification, fk_type_nom_param, date_debut, date_fin) VALUES (576, 'Vincenzo Viviani', NULL, NULL, 1366, true, '2015-11-06 16:04:13.593497+01', NULL, 15, NULL, NULL);
INSERT INTO nom_objet (pk_nom_objet, nom, langue, notes, fk_objet, est_standard, date_creation, date_modification, fk_type_nom_param, date_debut, date_fin) VALUES (577, 'Charles-Étienne-Louis Camus', NULL, NULL, 1367, true, '2015-11-06 16:04:13.593497+01', NULL, 15, NULL, NULL);
INSERT INTO nom_objet (pk_nom_objet, nom, langue, notes, fk_objet, est_standard, date_creation, date_modification, fk_type_nom_param, date_debut, date_fin) VALUES (578, 'Scipione Breislak', NULL, NULL, 1368, true, '2015-11-06 16:04:13.593497+01', NULL, 15, NULL, NULL);
INSERT INTO nom_objet (pk_nom_objet, nom, langue, notes, fk_objet, est_standard, date_creation, date_modification, fk_type_nom_param, date_debut, date_fin) VALUES (579, 'Jacob ben Machir', NULL, NULL, 1369, true, '2015-11-06 16:04:13.593497+01', NULL, 15, NULL, NULL);
INSERT INTO nom_objet (pk_nom_objet, nom, langue, notes, fk_objet, est_standard, date_creation, date_modification, fk_type_nom_param, date_debut, date_fin) VALUES (580, 'Rasmus Bartholin', NULL, NULL, 1370, true, '2015-11-06 16:04:13.593497+01', NULL, 15, NULL, NULL);
INSERT INTO nom_objet (pk_nom_objet, nom, langue, notes, fk_objet, est_standard, date_creation, date_modification, fk_type_nom_param, date_debut, date_fin) VALUES (581, 'Jacques Ozanam', NULL, NULL, 1371, true, '2015-11-06 16:04:13.593497+01', NULL, 15, NULL, NULL);
INSERT INTO nom_objet (pk_nom_objet, nom, langue, notes, fk_objet, est_standard, date_creation, date_modification, fk_type_nom_param, date_debut, date_fin) VALUES (582, 'de La Roche', NULL, NULL, 1372, true, '2015-11-06 16:04:13.593497+01', NULL, 15, NULL, NULL);
INSERT INTO nom_objet (pk_nom_objet, nom, langue, notes, fk_objet, est_standard, date_creation, date_modification, fk_type_nom_param, date_debut, date_fin) VALUES (583, 'Gemma Frisius', NULL, NULL, 1373, true, '2015-11-06 16:04:13.593497+01', NULL, 15, NULL, NULL);
INSERT INTO nom_objet (pk_nom_objet, nom, langue, notes, fk_objet, est_standard, date_creation, date_modification, fk_type_nom_param, date_debut, date_fin) VALUES (584, 'Jean Cousin', NULL, NULL, 1374, true, '2015-11-06 16:04:13.593497+01', NULL, 15, NULL, NULL);
INSERT INTO nom_objet (pk_nom_objet, nom, langue, notes, fk_objet, est_standard, date_creation, date_modification, fk_type_nom_param, date_debut, date_fin) VALUES (585, 'Antoine de La Salle', NULL, NULL, 1375, true, '2015-11-06 16:04:13.593497+01', NULL, 15, NULL, NULL);
INSERT INTO nom_objet (pk_nom_objet, nom, langue, notes, fk_objet, est_standard, date_creation, date_modification, fk_type_nom_param, date_debut, date_fin) VALUES (586, 'Johann Adam Schall von Bell', NULL, NULL, 1376, true, '2015-11-06 16:04:13.593497+01', NULL, 15, NULL, NULL);
INSERT INTO nom_objet (pk_nom_objet, nom, langue, notes, fk_objet, est_standard, date_creation, date_modification, fk_type_nom_param, date_debut, date_fin) VALUES (587, 'Heinrich Scherer', NULL, NULL, 1377, true, '2015-11-06 16:04:13.593497+01', NULL, 15, NULL, NULL);
INSERT INTO nom_objet (pk_nom_objet, nom, langue, notes, fk_objet, est_standard, date_creation, date_modification, fk_type_nom_param, date_debut, date_fin) VALUES (588, 'François Chevalier', NULL, NULL, 1378, true, '2015-11-06 16:04:13.593497+01', NULL, 15, NULL, NULL);
INSERT INTO nom_objet (pk_nom_objet, nom, langue, notes, fk_objet, est_standard, date_creation, date_modification, fk_type_nom_param, date_debut, date_fin) VALUES (589, 'Willem Jansz Blaeu', NULL, NULL, 1379, true, '2015-11-06 16:04:13.593497+01', NULL, 15, NULL, NULL);
INSERT INTO nom_objet (pk_nom_objet, nom, langue, notes, fk_objet, est_standard, date_creation, date_modification, fk_type_nom_param, date_debut, date_fin) VALUES (590, 'Guillaume-François-Antoine de L''Hospital', NULL, NULL, 1380, true, '2015-11-06 16:04:13.593497+01', NULL, 15, NULL, NULL);
INSERT INTO nom_objet (pk_nom_objet, nom, langue, notes, fk_objet, est_standard, date_creation, date_modification, fk_type_nom_param, date_debut, date_fin) VALUES (591, 'Adrianus Romanus', NULL, NULL, 1381, true, '2015-11-06 16:04:13.593497+01', NULL, 15, NULL, NULL);
INSERT INTO nom_objet (pk_nom_objet, nom, langue, notes, fk_objet, est_standard, date_creation, date_modification, fk_type_nom_param, date_debut, date_fin) VALUES (592, 'Giuseppe Moletti', NULL, NULL, 1382, true, '2015-11-06 16:04:13.593497+01', NULL, 15, NULL, NULL);
INSERT INTO nom_objet (pk_nom_objet, nom, langue, notes, fk_objet, est_standard, date_creation, date_modification, fk_type_nom_param, date_debut, date_fin) VALUES (593, 'Jacques-François Dicquemare', NULL, NULL, 1383, true, '2015-11-06 16:04:13.593497+01', NULL, 15, NULL, NULL);
INSERT INTO nom_objet (pk_nom_objet, nom, langue, notes, fk_objet, est_standard, date_creation, date_modification, fk_type_nom_param, date_debut, date_fin) VALUES (594, 'Mutio Oddi', NULL, NULL, 1384, true, '2015-11-06 16:04:13.593497+01', NULL, 15, NULL, NULL);
INSERT INTO nom_objet (pk_nom_objet, nom, langue, notes, fk_objet, est_standard, date_creation, date_modification, fk_type_nom_param, date_debut, date_fin) VALUES (595, 'Philip Lea', NULL, NULL, 1385, true, '2015-11-06 16:04:13.593497+01', NULL, 15, NULL, NULL);
INSERT INTO nom_objet (pk_nom_objet, nom, langue, notes, fk_objet, est_standard, date_creation, date_modification, fk_type_nom_param, date_debut, date_fin) VALUES (596, 'Mathieu Bernard Goudin', NULL, NULL, 1386, true, '2015-11-06 16:04:13.593497+01', NULL, 15, NULL, NULL);
INSERT INTO nom_objet (pk_nom_objet, nom, langue, notes, fk_objet, est_standard, date_creation, date_modification, fk_type_nom_param, date_debut, date_fin) VALUES (597, 'Jean Foucaud', NULL, NULL, 1387, true, '2015-11-06 16:04:13.593497+01', NULL, 15, NULL, NULL);
INSERT INTO nom_objet (pk_nom_objet, nom, langue, notes, fk_objet, est_standard, date_creation, date_modification, fk_type_nom_param, date_debut, date_fin) VALUES (598, 'Rugerius Josephus Boscovich', NULL, NULL, 1388, true, '2015-11-06 16:04:13.593497+01', NULL, 15, NULL, NULL);
INSERT INTO nom_objet (pk_nom_objet, nom, langue, notes, fk_objet, est_standard, date_creation, date_modification, fk_type_nom_param, date_debut, date_fin) VALUES (599, 'Eilhard Lubin', NULL, NULL, 1389, true, '2015-11-06 16:04:13.593497+01', NULL, 15, NULL, NULL);
INSERT INTO nom_objet (pk_nom_objet, nom, langue, notes, fk_objet, est_standard, date_creation, date_modification, fk_type_nom_param, date_debut, date_fin) VALUES (600, 'David François de Merveilleux', NULL, NULL, 1390, true, '2015-11-06 16:04:13.593497+01', NULL, 15, NULL, NULL);
INSERT INTO nom_objet (pk_nom_objet, nom, langue, notes, fk_objet, est_standard, date_creation, date_modification, fk_type_nom_param, date_debut, date_fin) VALUES (601, 'Charles-Étienne Coquebert de Montbret', NULL, NULL, 1391, true, '2015-11-06 16:04:13.593497+01', NULL, 15, NULL, NULL);
INSERT INTO nom_objet (pk_nom_objet, nom, langue, notes, fk_objet, est_standard, date_creation, date_modification, fk_type_nom_param, date_debut, date_fin) VALUES (602, 'Niccolò Tartaglia', NULL, NULL, 1392, true, '2015-11-06 16:04:13.593497+01', NULL, 15, NULL, NULL);
INSERT INTO nom_objet (pk_nom_objet, nom, langue, notes, fk_objet, est_standard, date_creation, date_modification, fk_type_nom_param, date_debut, date_fin) VALUES (603, 'Athanasius Kircher', NULL, NULL, 1393, true, '2015-11-06 16:04:13.593497+01', NULL, 15, NULL, NULL);
INSERT INTO nom_objet (pk_nom_objet, nom, langue, notes, fk_objet, est_standard, date_creation, date_modification, fk_type_nom_param, date_debut, date_fin) VALUES (604, 'D'' Alembert', NULL, NULL, 1394, true, '2015-11-06 16:04:13.593497+01', NULL, 15, NULL, NULL);
INSERT INTO nom_objet (pk_nom_objet, nom, langue, notes, fk_objet, est_standard, date_creation, date_modification, fk_type_nom_param, date_debut, date_fin) VALUES (605, 'Filippo Finella', NULL, NULL, 1395, true, '2015-11-06 16:04:13.593497+01', NULL, 15, NULL, NULL);
INSERT INTO nom_objet (pk_nom_objet, nom, langue, notes, fk_objet, est_standard, date_creation, date_modification, fk_type_nom_param, date_debut, date_fin) VALUES (606, 'Agricol-Joseph-François-Xavier-Pierre-Esprit-Simon-Paul-Antoine Fortia d''Urban', NULL, NULL, 1396, true, '2015-11-06 16:04:13.593497+01', NULL, 15, NULL, NULL);
INSERT INTO nom_objet (pk_nom_objet, nom, langue, notes, fk_objet, est_standard, date_creation, date_modification, fk_type_nom_param, date_debut, date_fin) VALUES (607, 'Jean-Baptiste Bernard', NULL, NULL, 1397, true, '2015-11-06 16:04:13.593497+01', NULL, 15, NULL, NULL);
INSERT INTO nom_objet (pk_nom_objet, nom, langue, notes, fk_objet, est_standard, date_creation, date_modification, fk_type_nom_param, date_debut, date_fin) VALUES (608, 'Franz Xaver von Zach', NULL, NULL, 1398, true, '2015-11-06 16:04:13.593497+01', NULL, 15, NULL, NULL);
INSERT INTO nom_objet (pk_nom_objet, nom, langue, notes, fk_objet, est_standard, date_creation, date_modification, fk_type_nom_param, date_debut, date_fin) VALUES (609, 'Bazaine', NULL, NULL, 1399, true, '2015-11-06 16:04:13.593497+01', NULL, 15, NULL, NULL);
INSERT INTO nom_objet (pk_nom_objet, nom, langue, notes, fk_objet, est_standard, date_creation, date_modification, fk_type_nom_param, date_debut, date_fin) VALUES (610, 'Phillebert Charpentier', NULL, NULL, 1400, true, '2015-11-06 16:04:13.593497+01', NULL, 15, NULL, NULL);
INSERT INTO nom_objet (pk_nom_objet, nom, langue, notes, fk_objet, est_standard, date_creation, date_modification, fk_type_nom_param, date_debut, date_fin) VALUES (611, 'Ole Rømer', NULL, NULL, 1401, true, '2015-11-06 16:04:13.593497+01', NULL, 15, NULL, NULL);
INSERT INTO nom_objet (pk_nom_objet, nom, langue, notes, fk_objet, est_standard, date_creation, date_modification, fk_type_nom_param, date_debut, date_fin) VALUES (612, 'Jost Bürgi', NULL, NULL, 1402, true, '2015-11-06 16:04:13.593497+01', NULL, 15, NULL, NULL);
INSERT INTO nom_objet (pk_nom_objet, nom, langue, notes, fk_objet, est_standard, date_creation, date_modification, fk_type_nom_param, date_debut, date_fin) VALUES (613, 'José Quiroga', NULL, NULL, 1403, true, '2015-11-06 16:04:13.593497+01', NULL, 15, NULL, NULL);
INSERT INTO nom_objet (pk_nom_objet, nom, langue, notes, fk_objet, est_standard, date_creation, date_modification, fk_type_nom_param, date_debut, date_fin) VALUES (614, 'Ciriaco Strozzi', NULL, NULL, 1404, true, '2015-11-06 16:04:13.593497+01', NULL, 15, NULL, NULL);
INSERT INTO nom_objet (pk_nom_objet, nom, langue, notes, fk_objet, est_standard, date_creation, date_modification, fk_type_nom_param, date_debut, date_fin) VALUES (615, 'Wilhelm Schickard', NULL, NULL, 1405, true, '2015-11-06 16:04:13.593497+01', NULL, 15, NULL, NULL);
INSERT INTO nom_objet (pk_nom_objet, nom, langue, notes, fk_objet, est_standard, date_creation, date_modification, fk_type_nom_param, date_debut, date_fin) VALUES (616, 'James Gregory', NULL, NULL, 1406, true, '2015-11-06 16:04:13.593497+01', NULL, 15, NULL, NULL);
INSERT INTO nom_objet (pk_nom_objet, nom, langue, notes, fk_objet, est_standard, date_creation, date_modification, fk_type_nom_param, date_debut, date_fin) VALUES (617, 'Roger Cotes', NULL, NULL, 1407, true, '2015-11-06 16:04:13.593497+01', NULL, 15, NULL, NULL);
INSERT INTO nom_objet (pk_nom_objet, nom, langue, notes, fk_objet, est_standard, date_creation, date_modification, fk_type_nom_param, date_debut, date_fin) VALUES (618, 'Jean Terrasson', NULL, NULL, 1408, true, '2015-11-06 16:04:13.593497+01', NULL, 15, NULL, NULL);
INSERT INTO nom_objet (pk_nom_objet, nom, langue, notes, fk_objet, est_standard, date_creation, date_modification, fk_type_nom_param, date_debut, date_fin) VALUES (619, 'Jean-Baptiste de Laborde', NULL, NULL, 1409, true, '2015-11-06 16:04:13.593497+01', NULL, 15, NULL, NULL);
INSERT INTO nom_objet (pk_nom_objet, nom, langue, notes, fk_objet, est_standard, date_creation, date_modification, fk_type_nom_param, date_debut, date_fin) VALUES (620, 'Pierre Hérigone', NULL, NULL, 1410, true, '2015-11-06 16:04:13.593497+01', NULL, 15, NULL, NULL);
INSERT INTO nom_objet (pk_nom_objet, nom, langue, notes, fk_objet, est_standard, date_creation, date_modification, fk_type_nom_param, date_debut, date_fin) VALUES (621, 'Gaspar Schott', NULL, NULL, 1411, true, '2015-11-06 16:04:13.593497+01', NULL, 15, NULL, NULL);
INSERT INTO nom_objet (pk_nom_objet, nom, langue, notes, fk_objet, est_standard, date_creation, date_modification, fk_type_nom_param, date_debut, date_fin) VALUES (622, 'John Napier', NULL, NULL, 1412, true, '2015-11-06 16:04:13.593497+01', NULL, 15, NULL, NULL);
INSERT INTO nom_objet (pk_nom_objet, nom, langue, notes, fk_objet, est_standard, date_creation, date_modification, fk_type_nom_param, date_debut, date_fin) VALUES (623, 'Marc Duncan', NULL, NULL, 1413, true, '2015-11-06 16:04:13.593497+01', NULL, 15, NULL, NULL);
INSERT INTO nom_objet (pk_nom_objet, nom, langue, notes, fk_objet, est_standard, date_creation, date_modification, fk_type_nom_param, date_debut, date_fin) VALUES (624, 'Evangelista Torricelli', NULL, NULL, 1414, true, '2015-11-06 16:04:13.593497+01', NULL, 15, NULL, NULL);
INSERT INTO nom_objet (pk_nom_objet, nom, langue, notes, fk_objet, est_standard, date_creation, date_modification, fk_type_nom_param, date_debut, date_fin) VALUES (625, 'Jean-Louis Pictet', NULL, NULL, 1415, true, '2015-11-06 16:04:13.593497+01', NULL, 15, NULL, NULL);
INSERT INTO nom_objet (pk_nom_objet, nom, langue, notes, fk_objet, est_standard, date_creation, date_modification, fk_type_nom_param, date_debut, date_fin) VALUES (626, 'Nicolas-Claude Duval-Le Roy', NULL, NULL, 1416, true, '2015-11-06 16:04:13.593497+01', NULL, 15, NULL, NULL);
INSERT INTO nom_objet (pk_nom_objet, nom, langue, notes, fk_objet, est_standard, date_creation, date_modification, fk_type_nom_param, date_debut, date_fin) VALUES (627, 'Johann Christoph Schuster', NULL, NULL, 1417, true, '2015-11-06 16:04:13.593497+01', NULL, 15, NULL, NULL);
INSERT INTO nom_objet (pk_nom_objet, nom, langue, notes, fk_objet, est_standard, date_creation, date_modification, fk_type_nom_param, date_debut, date_fin) VALUES (628, 'Blasius de Parma', NULL, NULL, 1418, true, '2015-11-06 16:04:13.593497+01', NULL, 15, NULL, NULL);
INSERT INTO nom_objet (pk_nom_objet, nom, langue, notes, fk_objet, est_standard, date_creation, date_modification, fk_type_nom_param, date_debut, date_fin) VALUES (629, 'François Noël', NULL, NULL, 1419, true, '2015-11-06 16:04:13.593497+01', NULL, 15, NULL, NULL);
INSERT INTO nom_objet (pk_nom_objet, nom, langue, notes, fk_objet, est_standard, date_creation, date_modification, fk_type_nom_param, date_debut, date_fin) VALUES (630, 'Jean Sylvain Bailly', NULL, NULL, 1420, true, '2015-11-06 16:04:13.593497+01', NULL, 15, NULL, NULL);
INSERT INTO nom_objet (pk_nom_objet, nom, langue, notes, fk_objet, est_standard, date_creation, date_modification, fk_type_nom_param, date_debut, date_fin) VALUES (631, 'Jean-Baptiste Morin', NULL, NULL, 1421, true, '2015-11-06 16:04:13.593497+01', NULL, 15, NULL, NULL);
INSERT INTO nom_objet (pk_nom_objet, nom, langue, notes, fk_objet, est_standard, date_creation, date_modification, fk_type_nom_param, date_debut, date_fin) VALUES (632, 'Jacob Hermann', NULL, NULL, 1422, true, '2015-11-06 16:04:13.593497+01', NULL, 15, NULL, NULL);
INSERT INTO nom_objet (pk_nom_objet, nom, langue, notes, fk_objet, est_standard, date_creation, date_modification, fk_type_nom_param, date_debut, date_fin) VALUES (633, 'Jacob Christmann', NULL, NULL, 1423, true, '2015-11-06 16:04:13.593497+01', NULL, 15, NULL, NULL);
INSERT INTO nom_objet (pk_nom_objet, nom, langue, notes, fk_objet, est_standard, date_creation, date_modification, fk_type_nom_param, date_debut, date_fin) VALUES (634, 'Gaspard Monge', NULL, NULL, 1424, true, '2015-11-06 16:04:13.593497+01', NULL, 15, NULL, NULL);
INSERT INTO nom_objet (pk_nom_objet, nom, langue, notes, fk_objet, est_standard, date_creation, date_modification, fk_type_nom_param, date_debut, date_fin) VALUES (635, 'Paolo dal Pozzo Toscanelli', NULL, NULL, 1425, true, '2015-11-06 16:04:13.593497+01', NULL, 15, NULL, NULL);
INSERT INTO nom_objet (pk_nom_objet, nom, langue, notes, fk_objet, est_standard, date_creation, date_modification, fk_type_nom_param, date_debut, date_fin) VALUES (636, 'Jacques Bernoulli', NULL, NULL, 1426, true, '2015-11-06 16:04:13.593497+01', NULL, 15, NULL, NULL);
INSERT INTO nom_objet (pk_nom_objet, nom, langue, notes, fk_objet, est_standard, date_creation, date_modification, fk_type_nom_param, date_debut, date_fin) VALUES (637, 'Gaspard-François-Anne de Forbin', NULL, NULL, 1427, true, '2015-11-06 16:04:13.593497+01', NULL, 15, NULL, NULL);
INSERT INTO nom_objet (pk_nom_objet, nom, langue, notes, fk_objet, est_standard, date_creation, date_modification, fk_type_nom_param, date_debut, date_fin) VALUES (638, 'Alexis Rochon', NULL, NULL, 1428, true, '2015-11-06 16:04:13.593497+01', NULL, 15, NULL, NULL);
INSERT INTO nom_objet (pk_nom_objet, nom, langue, notes, fk_objet, est_standard, date_creation, date_modification, fk_type_nom_param, date_debut, date_fin) VALUES (639, 'François Chauveau', NULL, NULL, 1429, true, '2015-11-06 16:04:13.593497+01', NULL, 15, NULL, NULL);
INSERT INTO nom_objet (pk_nom_objet, nom, langue, notes, fk_objet, est_standard, date_creation, date_modification, fk_type_nom_param, date_debut, date_fin) VALUES (640, 'Giacomo Oddi', NULL, NULL, 1430, true, '2015-11-06 16:04:13.593497+01', NULL, 15, NULL, NULL);
INSERT INTO nom_objet (pk_nom_objet, nom, langue, notes, fk_objet, est_standard, date_creation, date_modification, fk_type_nom_param, date_debut, date_fin) VALUES (641, 'Gerolamo Cardano', NULL, NULL, 1431, true, '2015-11-06 16:04:13.593497+01', NULL, 15, NULL, NULL);
INSERT INTO nom_objet (pk_nom_objet, nom, langue, notes, fk_objet, est_standard, date_creation, date_modification, fk_type_nom_param, date_debut, date_fin) VALUES (642, 'Gerard Mercator', NULL, NULL, 1432, true, '2015-11-06 16:04:13.593497+01', NULL, 15, NULL, NULL);
INSERT INTO nom_objet (pk_nom_objet, nom, langue, notes, fk_objet, est_standard, date_creation, date_modification, fk_type_nom_param, date_debut, date_fin) VALUES (643, 'Johann Friedrich Weidler', NULL, NULL, 1433, true, '2015-11-06 16:04:13.593497+01', NULL, 15, NULL, NULL);
INSERT INTO nom_objet (pk_nom_objet, nom, langue, notes, fk_objet, est_standard, date_creation, date_modification, fk_type_nom_param, date_debut, date_fin) VALUES (644, 'Sámuel Mikoviny', NULL, NULL, 1434, true, '2015-11-06 16:04:13.593497+01', NULL, 15, NULL, NULL);
INSERT INTO nom_objet (pk_nom_objet, nom, langue, notes, fk_objet, est_standard, date_creation, date_modification, fk_type_nom_param, date_debut, date_fin) VALUES (645, 'Thomas Le Seur', NULL, NULL, 1435, true, '2015-11-06 16:04:13.593497+01', NULL, 15, NULL, NULL);
INSERT INTO nom_objet (pk_nom_objet, nom, langue, notes, fk_objet, est_standard, date_creation, date_modification, fk_type_nom_param, date_debut, date_fin) VALUES (646, 'ʿAbd al-Ġaffār ibn ʿAbd al-Karīm Naǧm al-Dīn al- Qazwīnī', NULL, NULL, 1436, true, '2015-11-06 16:04:13.593497+01', NULL, 15, NULL, NULL);
INSERT INTO nom_objet (pk_nom_objet, nom, langue, notes, fk_objet, est_standard, date_creation, date_modification, fk_type_nom_param, date_debut, date_fin) VALUES (647, 'Sethus Calvisius', NULL, NULL, 1437, true, '2015-11-06 16:04:13.593497+01', NULL, 15, NULL, NULL);
INSERT INTO nom_objet (pk_nom_objet, nom, langue, notes, fk_objet, est_standard, date_creation, date_modification, fk_type_nom_param, date_debut, date_fin) VALUES (648, 'Paul-Louis Cirodde', NULL, NULL, 1438, true, '2015-11-06 16:04:13.593497+01', NULL, 15, NULL, NULL);
INSERT INTO nom_objet (pk_nom_objet, nom, langue, notes, fk_objet, est_standard, date_creation, date_modification, fk_type_nom_param, date_debut, date_fin) VALUES (649, 'Eberhard August Wilhelm von Zimmermann', NULL, NULL, 1439, true, '2015-11-06 16:04:13.593497+01', NULL, 15, NULL, NULL);
INSERT INTO nom_objet (pk_nom_objet, nom, langue, notes, fk_objet, est_standard, date_creation, date_modification, fk_type_nom_param, date_debut, date_fin) VALUES (650, 'Achille Pirminius Gasser', NULL, NULL, 1440, true, '2015-11-06 16:04:13.593497+01', NULL, 15, NULL, NULL);
INSERT INTO nom_objet (pk_nom_objet, nom, langue, notes, fk_objet, est_standard, date_creation, date_modification, fk_type_nom_param, date_debut, date_fin) VALUES (651, 'Michael Floris Van Langren', NULL, NULL, 1441, true, '2015-11-06 16:04:13.593497+01', NULL, 15, NULL, NULL);
INSERT INTO nom_objet (pk_nom_objet, nom, langue, notes, fk_objet, est_standard, date_creation, date_modification, fk_type_nom_param, date_debut, date_fin) VALUES (652, 'William Faden', NULL, NULL, 1442, true, '2015-11-06 16:04:13.593497+01', NULL, 15, NULL, NULL);
INSERT INTO nom_objet (pk_nom_objet, nom, langue, notes, fk_objet, est_standard, date_creation, date_modification, fk_type_nom_param, date_debut, date_fin) VALUES (653, 'Jacques Bassantin', NULL, NULL, 1443, true, '2015-11-06 16:04:13.593497+01', NULL, 15, NULL, NULL);
INSERT INTO nom_objet (pk_nom_objet, nom, langue, notes, fk_objet, est_standard, date_creation, date_modification, fk_type_nom_param, date_debut, date_fin) VALUES (654, 'Jean-Edme Gallimard', NULL, NULL, 1444, true, '2015-11-06 16:04:13.593497+01', NULL, 15, NULL, NULL);
INSERT INTO nom_objet (pk_nom_objet, nom, langue, notes, fk_objet, est_standard, date_creation, date_modification, fk_type_nom_param, date_debut, date_fin) VALUES (655, 'Jean Jombert', NULL, NULL, 1445, true, '2015-11-06 16:04:13.593497+01', NULL, 15, NULL, NULL);
INSERT INTO nom_objet (pk_nom_objet, nom, langue, notes, fk_objet, est_standard, date_creation, date_modification, fk_type_nom_param, date_debut, date_fin) VALUES (656, 'Harald Vallerius', NULL, NULL, 1446, true, '2015-11-06 16:04:13.593497+01', NULL, 15, NULL, NULL);
INSERT INTO nom_objet (pk_nom_objet, nom, langue, notes, fk_objet, est_standard, date_creation, date_modification, fk_type_nom_param, date_debut, date_fin) VALUES (657, 'Louis Duprat-Duverger', NULL, NULL, 1447, true, '2015-11-06 16:04:13.593497+01', NULL, 15, NULL, NULL);
INSERT INTO nom_objet (pk_nom_objet, nom, langue, notes, fk_objet, est_standard, date_creation, date_modification, fk_type_nom_param, date_debut, date_fin) VALUES (658, 'Louis-Jacques Goussier', NULL, NULL, 1448, true, '2015-11-06 16:04:13.593497+01', NULL, 15, NULL, NULL);
INSERT INTO nom_objet (pk_nom_objet, nom, langue, notes, fk_objet, est_standard, date_creation, date_modification, fk_type_nom_param, date_debut, date_fin) VALUES (659, 'Abū ʿAbd Allâh Muḥammad al- Baqqār', NULL, NULL, 1449, true, '2015-11-06 16:04:13.593497+01', NULL, 15, NULL, NULL);
INSERT INTO nom_objet (pk_nom_objet, nom, langue, notes, fk_objet, est_standard, date_creation, date_modification, fk_type_nom_param, date_debut, date_fin) VALUES (660, 'Andrea Corsali', NULL, NULL, 1450, true, '2015-11-06 16:04:13.593497+01', NULL, 15, NULL, NULL);
INSERT INTO nom_objet (pk_nom_objet, nom, langue, notes, fk_objet, est_standard, date_creation, date_modification, fk_type_nom_param, date_debut, date_fin) VALUES (661, 'Sebastian Münster', NULL, NULL, 1451, true, '2015-11-06 16:04:13.593497+01', NULL, 15, NULL, NULL);
INSERT INTO nom_objet (pk_nom_objet, nom, langue, notes, fk_objet, est_standard, date_creation, date_modification, fk_type_nom_param, date_debut, date_fin) VALUES (662, 'Johann Bernoulli', NULL, NULL, 1452, true, '2015-11-06 16:04:13.593497+01', NULL, 15, NULL, NULL);
INSERT INTO nom_objet (pk_nom_objet, nom, langue, notes, fk_objet, est_standard, date_creation, date_modification, fk_type_nom_param, date_debut, date_fin) VALUES (663, 'François Callet', NULL, NULL, 1453, true, '2015-11-06 16:04:13.593497+01', NULL, 15, NULL, NULL);
INSERT INTO nom_objet (pk_nom_objet, nom, langue, notes, fk_objet, est_standard, date_creation, date_modification, fk_type_nom_param, date_debut, date_fin) VALUES (664, 'Nicolas-Claude Fabri Peiresc', NULL, NULL, 1454, true, '2015-11-06 16:04:13.593497+01', NULL, 15, NULL, NULL);
INSERT INTO nom_objet (pk_nom_objet, nom, langue, notes, fk_objet, est_standard, date_creation, date_modification, fk_type_nom_param, date_debut, date_fin) VALUES (665, 'Cosimo Bartoli', NULL, NULL, 1455, true, '2015-11-06 16:04:13.593497+01', NULL, 15, NULL, NULL);
INSERT INTO nom_objet (pk_nom_objet, nom, langue, notes, fk_objet, est_standard, date_creation, date_modification, fk_type_nom_param, date_debut, date_fin) VALUES (666, 'Thomas Harriot', NULL, NULL, 1456, true, '2015-11-06 16:04:13.593497+01', NULL, 15, NULL, NULL);
INSERT INTO nom_objet (pk_nom_objet, nom, langue, notes, fk_objet, est_standard, date_creation, date_modification, fk_type_nom_param, date_debut, date_fin) VALUES (667, 'Bartolomeo Crescenzio', NULL, NULL, 1457, true, '2015-11-06 16:04:13.593497+01', NULL, 15, NULL, NULL);
INSERT INTO nom_objet (pk_nom_objet, nom, langue, notes, fk_objet, est_standard, date_creation, date_modification, fk_type_nom_param, date_debut, date_fin) VALUES (668, 'al-Silahî Nasuh', NULL, NULL, 1458, true, '2015-11-06 16:04:13.593497+01', NULL, 15, NULL, NULL);
INSERT INTO nom_objet (pk_nom_objet, nom, langue, notes, fk_objet, est_standard, date_creation, date_modification, fk_type_nom_param, date_debut, date_fin) VALUES (669, 'Andreas Riedel', NULL, NULL, 1459, true, '2015-11-06 16:04:13.593497+01', NULL, 15, NULL, NULL);
INSERT INTO nom_objet (pk_nom_objet, nom, langue, notes, fk_objet, est_standard, date_creation, date_modification, fk_type_nom_param, date_debut, date_fin) VALUES (670, 'Pons-Joseph Bernard', NULL, NULL, 1460, true, '2015-11-06 16:04:13.593497+01', NULL, 15, NULL, NULL);
INSERT INTO nom_objet (pk_nom_objet, nom, langue, notes, fk_objet, est_standard, date_creation, date_modification, fk_type_nom_param, date_debut, date_fin) VALUES (671, 'Fr. François d'' Aguillon', NULL, NULL, 1461, true, '2015-11-06 16:04:13.593497+01', NULL, 15, NULL, NULL);
INSERT INTO nom_objet (pk_nom_objet, nom, langue, notes, fk_objet, est_standard, date_creation, date_modification, fk_type_nom_param, date_debut, date_fin) VALUES (672, 'Claude de Visdelou', NULL, NULL, 1462, true, '2015-11-06 16:04:13.593497+01', NULL, 15, NULL, NULL);
INSERT INTO nom_objet (pk_nom_objet, nom, langue, notes, fk_objet, est_standard, date_creation, date_modification, fk_type_nom_param, date_debut, date_fin) VALUES (673, 'Jamet Mettayer', NULL, NULL, 1463, true, '2015-11-06 16:04:13.593497+01', NULL, 15, NULL, NULL);
INSERT INTO nom_objet (pk_nom_objet, nom, langue, notes, fk_objet, est_standard, date_creation, date_modification, fk_type_nom_param, date_debut, date_fin) VALUES (674, 'Jean Brohon', NULL, NULL, 1464, true, '2015-11-06 16:04:13.593497+01', NULL, 15, NULL, NULL);
INSERT INTO nom_objet (pk_nom_objet, nom, langue, notes, fk_objet, est_standard, date_creation, date_modification, fk_type_nom_param, date_debut, date_fin) VALUES (675, 'Giovanni Battista Riccioli', NULL, NULL, 1465, true, '2015-11-06 16:04:13.593497+01', NULL, 15, NULL, NULL);
INSERT INTO nom_objet (pk_nom_objet, nom, langue, notes, fk_objet, est_standard, date_creation, date_modification, fk_type_nom_param, date_debut, date_fin) VALUES (676, 'Louis Feuillée', NULL, NULL, 1466, true, '2015-11-06 16:04:13.593497+01', NULL, 15, NULL, NULL);
INSERT INTO nom_objet (pk_nom_objet, nom, langue, notes, fk_objet, est_standard, date_creation, date_modification, fk_type_nom_param, date_debut, date_fin) VALUES (677, 'Giovan Battista Nicolosi', NULL, NULL, 1467, true, '2015-11-06 16:04:13.593497+01', NULL, 15, NULL, NULL);
INSERT INTO nom_objet (pk_nom_objet, nom, langue, notes, fk_objet, est_standard, date_creation, date_modification, fk_type_nom_param, date_debut, date_fin) VALUES (678, 'Le P.  Chrysologue', NULL, NULL, 1468, true, '2015-11-06 16:04:13.593497+01', NULL, 15, NULL, NULL);
INSERT INTO nom_objet (pk_nom_objet, nom, langue, notes, fk_objet, est_standard, date_creation, date_modification, fk_type_nom_param, date_debut, date_fin) VALUES (679, 'Joachim Sterck van Ringelberg', NULL, NULL, 1469, true, '2015-11-06 16:04:13.593497+01', NULL, 15, NULL, NULL);
INSERT INTO nom_objet (pk_nom_objet, nom, langue, notes, fk_objet, est_standard, date_creation, date_modification, fk_type_nom_param, date_debut, date_fin) VALUES (680, 'Giacomo Lanteri', NULL, NULL, 1470, true, '2015-11-06 16:04:13.593497+01', NULL, 15, NULL, NULL);
INSERT INTO nom_objet (pk_nom_objet, nom, langue, notes, fk_objet, est_standard, date_creation, date_modification, fk_type_nom_param, date_debut, date_fin) VALUES (681, 'Georg Ludwig Frobenius', NULL, NULL, 1471, true, '2015-11-06 16:04:13.593497+01', NULL, 15, NULL, NULL);
INSERT INTO nom_objet (pk_nom_objet, nom, langue, notes, fk_objet, est_standard, date_creation, date_modification, fk_type_nom_param, date_debut, date_fin) VALUES (682, 'Louis Bourguet', NULL, NULL, 1472, true, '2015-11-06 16:04:13.593497+01', NULL, 15, NULL, NULL);
INSERT INTO nom_objet (pk_nom_objet, nom, langue, notes, fk_objet, est_standard, date_creation, date_modification, fk_type_nom_param, date_debut, date_fin) VALUES (683, 'Philip Apian', NULL, NULL, 1473, true, '2015-11-06 16:04:13.593497+01', NULL, 15, NULL, NULL);
INSERT INTO nom_objet (pk_nom_objet, nom, langue, notes, fk_objet, est_standard, date_creation, date_modification, fk_type_nom_param, date_debut, date_fin) VALUES (684, 'José Anastácio da Cunha', NULL, NULL, 1474, true, '2015-11-06 16:04:13.593497+01', NULL, 15, NULL, NULL);
INSERT INTO nom_objet (pk_nom_objet, nom, langue, notes, fk_objet, est_standard, date_creation, date_modification, fk_type_nom_param, date_debut, date_fin) VALUES (685, 'Donato Rossetti', NULL, NULL, 1475, true, '2015-11-06 16:04:13.593497+01', NULL, 15, NULL, NULL);
INSERT INTO nom_objet (pk_nom_objet, nom, langue, notes, fk_objet, est_standard, date_creation, date_modification, fk_type_nom_param, date_debut, date_fin) VALUES (686, 'Giuseppe Maria Pagnini', NULL, NULL, 1476, true, '2015-11-06 16:04:13.593497+01', NULL, 15, NULL, NULL);
INSERT INTO nom_objet (pk_nom_objet, nom, langue, notes, fk_objet, est_standard, date_creation, date_modification, fk_type_nom_param, date_debut, date_fin) VALUES (687, 'Heinrich Schreiber', NULL, NULL, 1477, true, '2015-11-06 16:04:13.593497+01', NULL, 15, NULL, NULL);
INSERT INTO nom_objet (pk_nom_objet, nom, langue, notes, fk_objet, est_standard, date_creation, date_modification, fk_type_nom_param, date_debut, date_fin) VALUES (688, 'Teodato Osio', NULL, NULL, 1478, true, '2015-11-06 16:04:13.593497+01', NULL, 15, NULL, NULL);
INSERT INTO nom_objet (pk_nom_objet, nom, langue, notes, fk_objet, est_standard, date_creation, date_modification, fk_type_nom_param, date_debut, date_fin) VALUES (689, 'Giovanni Gaetano Bottari', NULL, NULL, 1479, true, '2015-11-06 16:04:13.593497+01', NULL, 15, NULL, NULL);
INSERT INTO nom_objet (pk_nom_objet, nom, langue, notes, fk_objet, est_standard, date_creation, date_modification, fk_type_nom_param, date_debut, date_fin) VALUES (690, 'Le Ratz de Lanthenée', NULL, NULL, 1480, true, '2015-11-06 16:04:13.593497+01', NULL, 15, NULL, NULL);
INSERT INTO nom_objet (pk_nom_objet, nom, langue, notes, fk_objet, est_standard, date_creation, date_modification, fk_type_nom_param, date_debut, date_fin) VALUES (691, 'Pierre-Thomas Antelmy', NULL, NULL, 1481, true, '2015-11-06 16:04:13.593497+01', NULL, 15, NULL, NULL);
INSERT INTO nom_objet (pk_nom_objet, nom, langue, notes, fk_objet, est_standard, date_creation, date_modification, fk_type_nom_param, date_debut, date_fin) VALUES (692, 'Paschasius Hamellius', NULL, NULL, 1482, true, '2015-11-06 16:04:13.593497+01', NULL, 15, NULL, NULL);
INSERT INTO nom_objet (pk_nom_objet, nom, langue, notes, fk_objet, est_standard, date_creation, date_modification, fk_type_nom_param, date_debut, date_fin) VALUES (693, 'Gottfried Ploucquet', NULL, NULL, 1483, true, '2015-11-06 16:04:13.593497+01', NULL, 15, NULL, NULL);
INSERT INTO nom_objet (pk_nom_objet, nom, langue, notes, fk_objet, est_standard, date_creation, date_modification, fk_type_nom_param, date_debut, date_fin) VALUES (694, 'Prosdocimus de Beldemandis', NULL, NULL, 1484, true, '2015-11-06 16:04:13.593497+01', NULL, 15, NULL, NULL);
INSERT INTO nom_objet (pk_nom_objet, nom, langue, notes, fk_objet, est_standard, date_creation, date_modification, fk_type_nom_param, date_debut, date_fin) VALUES (695, 'Adrien Auzout', NULL, NULL, 1485, true, '2015-11-06 16:04:13.593497+01', NULL, 15, NULL, NULL);
INSERT INTO nom_objet (pk_nom_objet, nom, langue, notes, fk_objet, est_standard, date_creation, date_modification, fk_type_nom_param, date_debut, date_fin) VALUES (696, 'Lothar Zumbach von Coesfeld', NULL, NULL, 1486, true, '2015-11-06 16:04:13.593497+01', NULL, 15, NULL, NULL);
INSERT INTO nom_objet (pk_nom_objet, nom, langue, notes, fk_objet, est_standard, date_creation, date_modification, fk_type_nom_param, date_debut, date_fin) VALUES (697, 'Gabriel Philippe de La Hire', NULL, NULL, 1487, true, '2015-11-06 16:04:13.593497+01', NULL, 15, NULL, NULL);
INSERT INTO nom_objet (pk_nom_objet, nom, langue, notes, fk_objet, est_standard, date_creation, date_modification, fk_type_nom_param, date_debut, date_fin) VALUES (698, 'Gilbert Romme', NULL, NULL, 1488, true, '2015-11-06 16:04:13.593497+01', NULL, 15, NULL, NULL);
INSERT INTO nom_objet (pk_nom_objet, nom, langue, notes, fk_objet, est_standard, date_creation, date_modification, fk_type_nom_param, date_debut, date_fin) VALUES (699, 'Bonaventure Abat', NULL, NULL, 1489, true, '2015-11-06 16:04:13.593497+01', NULL, 15, NULL, NULL);
INSERT INTO nom_objet (pk_nom_objet, nom, langue, notes, fk_objet, est_standard, date_creation, date_modification, fk_type_nom_param, date_debut, date_fin) VALUES (700, 'Grégoire de Saint-Vincent', NULL, NULL, 1490, true, '2015-11-06 16:04:13.593497+01', NULL, 15, NULL, NULL);
INSERT INTO nom_objet (pk_nom_objet, nom, langue, notes, fk_objet, est_standard, date_creation, date_modification, fk_type_nom_param, date_debut, date_fin) VALUES (701, 'Antoine-François Payen', NULL, NULL, 1491, true, '2015-11-06 16:04:13.593497+01', NULL, 15, NULL, NULL);
INSERT INTO nom_objet (pk_nom_objet, nom, langue, notes, fk_objet, est_standard, date_creation, date_modification, fk_type_nom_param, date_debut, date_fin) VALUES (702, 'Colin MacLaurin', NULL, NULL, 1492, true, '2015-11-06 16:04:13.593497+01', NULL, 15, NULL, NULL);
INSERT INTO nom_objet (pk_nom_objet, nom, langue, notes, fk_objet, est_standard, date_creation, date_modification, fk_type_nom_param, date_debut, date_fin) VALUES (703, 'James Stirling', NULL, NULL, 1493, true, '2015-11-06 16:04:13.593497+01', NULL, 15, NULL, NULL);
INSERT INTO nom_objet (pk_nom_objet, nom, langue, notes, fk_objet, est_standard, date_creation, date_modification, fk_type_nom_param, date_debut, date_fin) VALUES (704, 'Daniel Bernoulli', NULL, NULL, 1494, true, '2015-11-06 16:04:13.593497+01', NULL, 15, NULL, NULL);
INSERT INTO nom_objet (pk_nom_objet, nom, langue, notes, fk_objet, est_standard, date_creation, date_modification, fk_type_nom_param, date_debut, date_fin) VALUES (705, 'Abbé Deidier', NULL, NULL, 1495, true, '2015-11-06 16:04:13.593497+01', NULL, 15, NULL, NULL);
INSERT INTO nom_objet (pk_nom_objet, nom, langue, notes, fk_objet, est_standard, date_creation, date_modification, fk_type_nom_param, date_debut, date_fin) VALUES (706, 'Pierre-Simon de Laplace', NULL, NULL, 1496, true, '2015-11-06 16:04:13.593497+01', NULL, 15, NULL, NULL);
INSERT INTO nom_objet (pk_nom_objet, nom, langue, notes, fk_objet, est_standard, date_creation, date_modification, fk_type_nom_param, date_debut, date_fin) VALUES (707, 'Didier Henrion', NULL, NULL, 1497, true, '2015-11-06 16:04:13.593497+01', NULL, 15, NULL, NULL);
INSERT INTO nom_objet (pk_nom_objet, nom, langue, notes, fk_objet, est_standard, date_creation, date_modification, fk_type_nom_param, date_debut, date_fin) VALUES (708, 'Pierre-René-Auguste Bremond d''Ars', NULL, NULL, 1498, true, '2015-11-06 16:04:13.593497+01', NULL, 15, NULL, NULL);
INSERT INTO nom_objet (pk_nom_objet, nom, langue, notes, fk_objet, est_standard, date_creation, date_modification, fk_type_nom_param, date_debut, date_fin) VALUES (709, 'Étienne Bezout', NULL, NULL, 1499, true, '2015-11-06 16:04:13.593497+01', NULL, 15, NULL, NULL);
INSERT INTO nom_objet (pk_nom_objet, nom, langue, notes, fk_objet, est_standard, date_creation, date_modification, fk_type_nom_param, date_debut, date_fin) VALUES (710, 'Jean-Philippe Loys de Chéseaux', NULL, NULL, 1500, true, '2015-11-06 16:04:13.593497+01', NULL, 15, NULL, NULL);
INSERT INTO nom_objet (pk_nom_objet, nom, langue, notes, fk_objet, est_standard, date_creation, date_modification, fk_type_nom_param, date_debut, date_fin) VALUES (711, 'Girolamo Settimo', NULL, NULL, 1501, true, '2015-11-06 16:04:13.593497+01', NULL, 15, NULL, NULL);
INSERT INTO nom_objet (pk_nom_objet, nom, langue, notes, fk_objet, est_standard, date_creation, date_modification, fk_type_nom_param, date_debut, date_fin) VALUES (712, 'Isaac Newton', NULL, NULL, 1502, true, '2015-11-06 16:04:13.593497+01', NULL, 15, NULL, NULL);
INSERT INTO nom_objet (pk_nom_objet, nom, langue, notes, fk_objet, est_standard, date_creation, date_modification, fk_type_nom_param, date_debut, date_fin) VALUES (713, 'Robert Simson', NULL, NULL, 1503, true, '2015-11-06 16:04:13.593497+01', NULL, 15, NULL, NULL);
INSERT INTO nom_objet (pk_nom_objet, nom, langue, notes, fk_objet, est_standard, date_creation, date_modification, fk_type_nom_param, date_debut, date_fin) VALUES (714, 'Alliette', NULL, NULL, 1504, true, '2015-11-06 16:04:13.593497+01', NULL, 15, NULL, NULL);
INSERT INTO nom_objet (pk_nom_objet, nom, langue, notes, fk_objet, est_standard, date_creation, date_modification, fk_type_nom_param, date_debut, date_fin) VALUES (715, 'Edme-Sébastien Jeaurat', NULL, NULL, 1505, true, '2015-11-06 16:04:13.593497+01', NULL, 15, NULL, NULL);
INSERT INTO nom_objet (pk_nom_objet, nom, langue, notes, fk_objet, est_standard, date_creation, date_modification, fk_type_nom_param, date_debut, date_fin) VALUES (716, 'Alexandre Anderson', NULL, NULL, 1506, true, '2015-11-06 16:04:13.593497+01', NULL, 15, NULL, NULL);
INSERT INTO nom_objet (pk_nom_objet, nom, langue, notes, fk_objet, est_standard, date_creation, date_modification, fk_type_nom_param, date_debut, date_fin) VALUES (717, 'Józef Naronowicz-Naroński', NULL, NULL, 1507, true, '2015-11-06 16:04:13.593497+01', NULL, 15, NULL, NULL);
INSERT INTO nom_objet (pk_nom_objet, nom, langue, notes, fk_objet, est_standard, date_creation, date_modification, fk_type_nom_param, date_debut, date_fin) VALUES (718, 'Johann Andreas Planer', NULL, NULL, 1508, true, '2015-11-06 16:04:13.593497+01', NULL, 15, NULL, NULL);
INSERT INTO nom_objet (pk_nom_objet, nom, langue, notes, fk_objet, est_standard, date_creation, date_modification, fk_type_nom_param, date_debut, date_fin) VALUES (719, 'David ben Yom-Tov Poel', NULL, NULL, 1509, true, '2015-11-06 16:04:13.593497+01', NULL, 15, NULL, NULL);
INSERT INTO nom_objet (pk_nom_objet, nom, langue, notes, fk_objet, est_standard, date_creation, date_modification, fk_type_nom_param, date_debut, date_fin) VALUES (720, 'Cornelius Drebbel', NULL, NULL, 1510, true, '2015-11-06 16:04:13.593497+01', NULL, 15, NULL, NULL);
INSERT INTO nom_objet (pk_nom_objet, nom, langue, notes, fk_objet, est_standard, date_creation, date_modification, fk_type_nom_param, date_debut, date_fin) VALUES (721, 'Claude Hardy', NULL, NULL, 1511, true, '2015-11-06 16:04:13.593497+01', NULL, 15, NULL, NULL);
INSERT INTO nom_objet (pk_nom_objet, nom, langue, notes, fk_objet, est_standard, date_creation, date_modification, fk_type_nom_param, date_debut, date_fin) VALUES (722, 'Joseph Privat de Molières', NULL, NULL, 1512, true, '2015-11-06 16:04:13.593497+01', NULL, 15, NULL, NULL);
INSERT INTO nom_objet (pk_nom_objet, nom, langue, notes, fk_objet, est_standard, date_creation, date_modification, fk_type_nom_param, date_debut, date_fin) VALUES (723, 'Marin Mersenne', NULL, NULL, 1513, true, '2015-11-06 16:04:13.593497+01', NULL, 15, NULL, NULL);
INSERT INTO nom_objet (pk_nom_objet, nom, langue, notes, fk_objet, est_standard, date_creation, date_modification, fk_type_nom_param, date_debut, date_fin) VALUES (724, 'Tilemann Stella', NULL, NULL, 1514, true, '2015-11-06 16:04:13.593497+01', NULL, 15, NULL, NULL);
INSERT INTO nom_objet (pk_nom_objet, nom, langue, notes, fk_objet, est_standard, date_creation, date_modification, fk_type_nom_param, date_debut, date_fin) VALUES (725, 'Tommaso Valperga di Caluso', NULL, NULL, 1515, true, '2015-11-06 16:04:13.593497+01', NULL, 15, NULL, NULL);
INSERT INTO nom_objet (pk_nom_objet, nom, langue, notes, fk_objet, est_standard, date_creation, date_modification, fk_type_nom_param, date_debut, date_fin) VALUES (726, 'Bernardino Baldini', NULL, NULL, 1516, true, '2015-11-06 16:04:13.593497+01', NULL, 15, NULL, NULL);
INSERT INTO nom_objet (pk_nom_objet, nom, langue, notes, fk_objet, est_standard, date_creation, date_modification, fk_type_nom_param, date_debut, date_fin) VALUES (727, 'Louis-Charles Desnos', NULL, NULL, 1517, true, '2015-11-06 16:04:13.593497+01', NULL, 15, NULL, NULL);
INSERT INTO nom_objet (pk_nom_objet, nom, langue, notes, fk_objet, est_standard, date_creation, date_modification, fk_type_nom_param, date_debut, date_fin) VALUES (728, 'William Herschel', NULL, NULL, 1518, true, '2015-11-06 16:04:13.593497+01', NULL, 15, NULL, NULL);
INSERT INTO nom_objet (pk_nom_objet, nom, langue, notes, fk_objet, est_standard, date_creation, date_modification, fk_type_nom_param, date_debut, date_fin) VALUES (729, 'André-Charles Brotier', NULL, NULL, 1519, true, '2015-11-06 16:04:13.593497+01', NULL, 15, NULL, NULL);
INSERT INTO nom_objet (pk_nom_objet, nom, langue, notes, fk_objet, est_standard, date_creation, date_modification, fk_type_nom_param, date_debut, date_fin) VALUES (730, 'Bernard Nieuwentijt', NULL, NULL, 1520, true, '2015-11-06 16:04:13.593497+01', NULL, 15, NULL, NULL);
INSERT INTO nom_objet (pk_nom_objet, nom, langue, notes, fk_objet, est_standard, date_creation, date_modification, fk_type_nom_param, date_debut, date_fin) VALUES (731, 'William Molyneux', NULL, NULL, 1521, true, '2015-11-06 16:04:13.593497+01', NULL, 15, NULL, NULL);
INSERT INTO nom_objet (pk_nom_objet, nom, langue, notes, fk_objet, est_standard, date_creation, date_modification, fk_type_nom_param, date_debut, date_fin) VALUES (732, 'Lodovico Pontico Virunio', NULL, NULL, 1522, true, '2015-11-06 16:04:13.593497+01', NULL, 15, NULL, NULL);
INSERT INTO nom_objet (pk_nom_objet, nom, langue, notes, fk_objet, est_standard, date_creation, date_modification, fk_type_nom_param, date_debut, date_fin) VALUES (733, 'Frans Van Schooten', NULL, NULL, 1523, true, '2015-11-06 16:04:13.593497+01', NULL, 15, NULL, NULL);
INSERT INTO nom_objet (pk_nom_objet, nom, langue, notes, fk_objet, est_standard, date_creation, date_modification, fk_type_nom_param, date_debut, date_fin) VALUES (734, 'Sigfridus Aronus Forsius', NULL, NULL, 1524, true, '2015-11-06 16:04:13.593497+01', NULL, 15, NULL, NULL);
INSERT INTO nom_objet (pk_nom_objet, nom, langue, notes, fk_objet, est_standard, date_creation, date_modification, fk_type_nom_param, date_debut, date_fin) VALUES (735, 'Augustin Darquier de Pellepoix', NULL, NULL, 1525, true, '2015-11-06 16:04:13.593497+01', NULL, 15, NULL, NULL);
INSERT INTO nom_objet (pk_nom_objet, nom, langue, notes, fk_objet, est_standard, date_creation, date_modification, fk_type_nom_param, date_debut, date_fin) VALUES (736, 'John Pell', NULL, NULL, 1526, true, '2015-11-06 16:04:13.593497+01', NULL, 15, NULL, NULL);
INSERT INTO nom_objet (pk_nom_objet, nom, langue, notes, fk_objet, est_standard, date_creation, date_modification, fk_type_nom_param, date_debut, date_fin) VALUES (737, 'Johann Heinrich Müller', NULL, NULL, 1527, true, '2015-11-06 16:04:13.593497+01', NULL, 15, NULL, NULL);
INSERT INTO nom_objet (pk_nom_objet, nom, langue, notes, fk_objet, est_standard, date_creation, date_modification, fk_type_nom_param, date_debut, date_fin) VALUES (738, 'Claude Philippe Bertrand Bertrand', NULL, NULL, 1528, true, '2015-11-06 16:04:13.593497+01', NULL, 15, NULL, NULL);
INSERT INTO nom_objet (pk_nom_objet, nom, langue, notes, fk_objet, est_standard, date_creation, date_modification, fk_type_nom_param, date_debut, date_fin) VALUES (739, 'Antonio Manetti', NULL, NULL, 1529, true, '2015-11-06 16:04:13.593497+01', NULL, 15, NULL, NULL);
INSERT INTO nom_objet (pk_nom_objet, nom, langue, notes, fk_objet, est_standard, date_creation, date_modification, fk_type_nom_param, date_debut, date_fin) VALUES (740, 'Johannes Danck', NULL, NULL, 1530, true, '2015-11-06 16:04:13.593497+01', NULL, 15, NULL, NULL);
INSERT INTO nom_objet (pk_nom_objet, nom, langue, notes, fk_objet, est_standard, date_creation, date_modification, fk_type_nom_param, date_debut, date_fin) VALUES (741, 'Erasmus Oswald Schreckenfuchs', NULL, NULL, 1531, true, '2015-11-06 16:04:13.593497+01', NULL, 15, NULL, NULL);
INSERT INTO nom_objet (pk_nom_objet, nom, langue, notes, fk_objet, est_standard, date_creation, date_modification, fk_type_nom_param, date_debut, date_fin) VALUES (742, 'Michael Moestlin', NULL, NULL, 1532, true, '2015-11-06 16:04:13.593497+01', NULL, 15, NULL, NULL);
INSERT INTO nom_objet (pk_nom_objet, nom, langue, notes, fk_objet, est_standard, date_creation, date_modification, fk_type_nom_param, date_debut, date_fin) VALUES (743, 'Georges Louis Lesage', NULL, NULL, 1533, true, '2015-11-06 16:04:13.593497+01', NULL, 15, NULL, NULL);
INSERT INTO nom_objet (pk_nom_objet, nom, langue, notes, fk_objet, est_standard, date_creation, date_modification, fk_type_nom_param, date_debut, date_fin) VALUES (744, 'Le Professeur de mathématiques du Collège national de Toul', NULL, NULL, 1534, true, '2015-11-06 16:04:13.593497+01', NULL, 15, NULL, NULL);
INSERT INTO nom_objet (pk_nom_objet, nom, langue, notes, fk_objet, est_standard, date_creation, date_modification, fk_type_nom_param, date_debut, date_fin) VALUES (745, 'Piero della Francesca', NULL, NULL, 1535, true, '2015-11-06 16:04:13.593497+01', NULL, 15, NULL, NULL);
INSERT INTO nom_objet (pk_nom_objet, nom, langue, notes, fk_objet, est_standard, date_creation, date_modification, fk_type_nom_param, date_debut, date_fin) VALUES (746, 'Luca Gaurico', NULL, NULL, 1536, true, '2015-11-06 16:04:13.593497+01', NULL, 15, NULL, NULL);
INSERT INTO nom_objet (pk_nom_objet, nom, langue, notes, fk_objet, est_standard, date_creation, date_modification, fk_type_nom_param, date_debut, date_fin) VALUES (747, 'Henri Michel Sauvage', NULL, NULL, 1537, true, '2015-11-06 16:04:13.593497+01', NULL, 15, NULL, NULL);
INSERT INTO nom_objet (pk_nom_objet, nom, langue, notes, fk_objet, est_standard, date_creation, date_modification, fk_type_nom_param, date_debut, date_fin) VALUES (748, 'Johann Welper', NULL, NULL, 1538, true, '2015-11-06 16:04:13.593497+01', NULL, 15, NULL, NULL);
INSERT INTO nom_objet (pk_nom_objet, nom, langue, notes, fk_objet, est_standard, date_creation, date_modification, fk_type_nom_param, date_debut, date_fin) VALUES (749, 'François Para Du Phanjas', NULL, NULL, 1539, true, '2015-11-06 16:04:13.593497+01', NULL, 15, NULL, NULL);
INSERT INTO nom_objet (pk_nom_objet, nom, langue, notes, fk_objet, est_standard, date_creation, date_modification, fk_type_nom_param, date_debut, date_fin) VALUES (750, 'Claude Comiers', NULL, NULL, 1540, true, '2015-11-06 16:04:13.593497+01', NULL, 15, NULL, NULL);
INSERT INTO nom_objet (pk_nom_objet, nom, langue, notes, fk_objet, est_standard, date_creation, date_modification, fk_type_nom_param, date_debut, date_fin) VALUES (751, 'Étienne-Nicolas Blondeau', NULL, NULL, 1541, true, '2015-11-06 16:04:13.593497+01', NULL, 15, NULL, NULL);
INSERT INTO nom_objet (pk_nom_objet, nom, langue, notes, fk_objet, est_standard, date_creation, date_modification, fk_type_nom_param, date_debut, date_fin) VALUES (752, 'Jean-Louis Gœury', NULL, NULL, 1542, true, '2015-11-06 16:04:13.593497+01', NULL, 15, NULL, NULL);
INSERT INTO nom_objet (pk_nom_objet, nom, langue, notes, fk_objet, est_standard, date_creation, date_modification, fk_type_nom_param, date_debut, date_fin) VALUES (753, 'Jean Anthelme Brillat-Savarin', NULL, NULL, 1543, true, '2015-11-06 16:04:13.593497+01', NULL, 15, NULL, NULL);
INSERT INTO nom_objet (pk_nom_objet, nom, langue, notes, fk_objet, est_standard, date_creation, date_modification, fk_type_nom_param, date_debut, date_fin) VALUES (754, 'Jean Richer', NULL, NULL, 1544, true, '2015-11-06 16:04:13.593497+01', NULL, 15, NULL, NULL);
INSERT INTO nom_objet (pk_nom_objet, nom, langue, notes, fk_objet, est_standard, date_creation, date_modification, fk_type_nom_param, date_debut, date_fin) VALUES (755, 'Christopher Wren', NULL, NULL, 1545, true, '2015-11-06 16:04:13.593497+01', NULL, 15, NULL, NULL);
INSERT INTO nom_objet (pk_nom_objet, nom, langue, notes, fk_objet, est_standard, date_creation, date_modification, fk_type_nom_param, date_debut, date_fin) VALUES (756, 'Jacques Cassini', NULL, NULL, 1546, true, '2015-11-06 16:04:13.593497+01', NULL, 15, NULL, NULL);
INSERT INTO nom_objet (pk_nom_objet, nom, langue, notes, fk_objet, est_standard, date_creation, date_modification, fk_type_nom_param, date_debut, date_fin) VALUES (757, 'Henry Briggs', NULL, NULL, 1547, true, '2015-11-06 16:04:13.593497+01', NULL, 15, NULL, NULL);
INSERT INTO nom_objet (pk_nom_objet, nom, langue, notes, fk_objet, est_standard, date_creation, date_modification, fk_type_nom_param, date_debut, date_fin) VALUES (758, 'Eustachio Manfredi', NULL, NULL, 1548, true, '2015-11-06 16:04:13.593497+01', NULL, 15, NULL, NULL);
INSERT INTO nom_objet (pk_nom_objet, nom, langue, notes, fk_objet, est_standard, date_creation, date_modification, fk_type_nom_param, date_debut, date_fin) VALUES (759, 'Leonardo Ximenes', NULL, NULL, 1549, true, '2015-11-06 16:04:13.593497+01', NULL, 15, NULL, NULL);
INSERT INTO nom_objet (pk_nom_objet, nom, langue, notes, fk_objet, est_standard, date_creation, date_modification, fk_type_nom_param, date_debut, date_fin) VALUES (760, 'Jean François', NULL, NULL, 1550, true, '2015-11-06 16:04:13.593497+01', NULL, 15, NULL, NULL);
INSERT INTO nom_objet (pk_nom_objet, nom, langue, notes, fk_objet, est_standard, date_creation, date_modification, fk_type_nom_param, date_debut, date_fin) VALUES (761, 'Campanus de Novare', NULL, NULL, 1551, true, '2015-11-06 16:04:13.593497+01', NULL, 15, NULL, NULL);
INSERT INTO nom_objet (pk_nom_objet, nom, langue, notes, fk_objet, est_standard, date_creation, date_modification, fk_type_nom_param, date_debut, date_fin) VALUES (762, 'John Greaves', NULL, NULL, 1552, true, '2015-11-06 16:04:13.593497+01', NULL, 15, NULL, NULL);
INSERT INTO nom_objet (pk_nom_objet, nom, langue, notes, fk_objet, est_standard, date_creation, date_modification, fk_type_nom_param, date_debut, date_fin) VALUES (763, 'Isaac ben Joseph Israeli', NULL, NULL, 1553, true, '2015-11-06 16:04:13.593497+01', NULL, 15, NULL, NULL);
INSERT INTO nom_objet (pk_nom_objet, nom, langue, notes, fk_objet, est_standard, date_creation, date_modification, fk_type_nom_param, date_debut, date_fin) VALUES (764, 'Alessandro Vittorio Papacino d''Antoni', NULL, NULL, 1554, true, '2015-11-06 16:04:13.593497+01', NULL, 15, NULL, NULL);
INSERT INTO nom_objet (pk_nom_objet, nom, langue, notes, fk_objet, est_standard, date_creation, date_modification, fk_type_nom_param, date_debut, date_fin) VALUES (765, 'Giacomo Allegretti', NULL, NULL, 1555, true, '2015-11-06 16:04:13.593497+01', NULL, 15, NULL, NULL);
INSERT INTO nom_objet (pk_nom_objet, nom, langue, notes, fk_objet, est_standard, date_creation, date_modification, fk_type_nom_param, date_debut, date_fin) VALUES (766, 'Johann Christoph Sturm', NULL, NULL, 1556, true, '2015-11-06 16:04:13.593497+01', NULL, 15, NULL, NULL);
INSERT INTO nom_objet (pk_nom_objet, nom, langue, notes, fk_objet, est_standard, date_creation, date_modification, fk_type_nom_param, date_debut, date_fin) VALUES (767, 'Giovanni Alfonso Borelli', NULL, NULL, 1557, true, '2015-11-06 16:04:13.593497+01', NULL, 15, NULL, NULL);
INSERT INTO nom_objet (pk_nom_objet, nom, langue, notes, fk_objet, est_standard, date_creation, date_modification, fk_type_nom_param, date_debut, date_fin) VALUES (768, 'Diego de Torres Villarroel', NULL, NULL, 1558, true, '2015-11-06 16:04:13.593497+01', NULL, 15, NULL, NULL);
INSERT INTO nom_objet (pk_nom_objet, nom, langue, notes, fk_objet, est_standard, date_creation, date_modification, fk_type_nom_param, date_debut, date_fin) VALUES (769, 'Vitale Giordano', NULL, NULL, 1559, true, '2015-11-06 16:04:13.593497+01', NULL, 15, NULL, NULL);
INSERT INTO nom_objet (pk_nom_objet, nom, langue, notes, fk_objet, est_standard, date_creation, date_modification, fk_type_nom_param, date_debut, date_fin) VALUES (770, 'Hermann le Dalmate', NULL, NULL, 1560, true, '2015-11-06 16:04:13.593497+01', NULL, 15, NULL, NULL);
INSERT INTO nom_objet (pk_nom_objet, nom, langue, notes, fk_objet, est_standard, date_creation, date_modification, fk_type_nom_param, date_debut, date_fin) VALUES (771, 'Michele Zappulo', NULL, NULL, 1561, true, '2015-11-06 16:04:13.593497+01', NULL, 15, NULL, NULL);
INSERT INTO nom_objet (pk_nom_objet, nom, langue, notes, fk_objet, est_standard, date_creation, date_modification, fk_type_nom_param, date_debut, date_fin) VALUES (772, 'Giuseppe Maria Asclepi', NULL, NULL, 1562, true, '2015-11-06 16:04:13.593497+01', NULL, 15, NULL, NULL);
INSERT INTO nom_objet (pk_nom_objet, nom, langue, notes, fk_objet, est_standard, date_creation, date_modification, fk_type_nom_param, date_debut, date_fin) VALUES (773, 'Bernard Frénicle de Bessy', NULL, NULL, 1563, true, '2015-11-06 16:04:13.593497+01', NULL, 15, NULL, NULL);
INSERT INTO nom_objet (pk_nom_objet, nom, langue, notes, fk_objet, est_standard, date_creation, date_modification, fk_type_nom_param, date_debut, date_fin) VALUES (774, 'Johann Lorenz Schmidt', NULL, NULL, 1564, true, '2015-11-06 16:04:13.593497+01', NULL, 15, NULL, NULL);
INSERT INTO nom_objet (pk_nom_objet, nom, langue, notes, fk_objet, est_standard, date_creation, date_modification, fk_type_nom_param, date_debut, date_fin) VALUES (775, 'Antonio Dolciati', NULL, NULL, 1565, true, '2015-11-06 16:04:13.593497+01', NULL, 15, NULL, NULL);
INSERT INTO nom_objet (pk_nom_objet, nom, langue, notes, fk_objet, est_standard, date_creation, date_modification, fk_type_nom_param, date_debut, date_fin) VALUES (776, 'Pierre Forcadel', NULL, NULL, 1566, true, '2015-11-06 16:04:13.593497+01', NULL, 15, NULL, NULL);
INSERT INTO nom_objet (pk_nom_objet, nom, langue, notes, fk_objet, est_standard, date_creation, date_modification, fk_type_nom_param, date_debut, date_fin) VALUES (777, 'Libert Froidmont', NULL, NULL, 1567, true, '2015-11-06 16:04:13.593497+01', NULL, 15, NULL, NULL);
INSERT INTO nom_objet (pk_nom_objet, nom, langue, notes, fk_objet, est_standard, date_creation, date_modification, fk_type_nom_param, date_debut, date_fin) VALUES (778, 'Guillaume-Germain Guyot', NULL, NULL, 1568, true, '2015-11-06 16:04:13.593497+01', NULL, 15, NULL, NULL);
INSERT INTO nom_objet (pk_nom_objet, nom, langue, notes, fk_objet, est_standard, date_creation, date_modification, fk_type_nom_param, date_debut, date_fin) VALUES (779, 'Jacopo Francesco Riccati', NULL, NULL, 1569, true, '2015-11-06 16:04:13.593497+01', NULL, 15, NULL, NULL);
INSERT INTO nom_objet (pk_nom_objet, nom, langue, notes, fk_objet, est_standard, date_creation, date_modification, fk_type_nom_param, date_debut, date_fin) VALUES (780, 'Claude Bonjour', NULL, NULL, 1570, true, '2015-11-06 16:04:13.593497+01', NULL, 15, NULL, NULL);
INSERT INTO nom_objet (pk_nom_objet, nom, langue, notes, fk_objet, est_standard, date_creation, date_modification, fk_type_nom_param, date_debut, date_fin) VALUES (781, 'Jean Paul Grandjean de Fouchy', NULL, NULL, 1571, true, '2015-11-06 16:04:13.593497+01', NULL, 15, NULL, NULL);
INSERT INTO nom_objet (pk_nom_objet, nom, langue, notes, fk_objet, est_standard, date_creation, date_modification, fk_type_nom_param, date_debut, date_fin) VALUES (782, 'Bartolomeo Zamberti', NULL, NULL, 1572, true, '2015-11-06 16:04:13.593497+01', NULL, 15, NULL, NULL);
INSERT INTO nom_objet (pk_nom_objet, nom, langue, notes, fk_objet, est_standard, date_creation, date_modification, fk_type_nom_param, date_debut, date_fin) VALUES (783, 'Nevil Maskelyne', NULL, NULL, 1573, true, '2015-11-06 16:04:13.593497+01', NULL, 15, NULL, NULL);
INSERT INTO nom_objet (pk_nom_objet, nom, langue, notes, fk_objet, est_standard, date_creation, date_modification, fk_type_nom_param, date_debut, date_fin) VALUES (784, 'Pierre Gautruche', NULL, NULL, 1574, true, '2015-11-06 16:04:13.593497+01', NULL, 15, NULL, NULL);
INSERT INTO nom_objet (pk_nom_objet, nom, langue, notes, fk_objet, est_standard, date_creation, date_modification, fk_type_nom_param, date_debut, date_fin) VALUES (785, 'Francesco Ingoli', NULL, NULL, 1575, true, '2015-11-06 16:04:13.593497+01', NULL, 15, NULL, NULL);
INSERT INTO nom_objet (pk_nom_objet, nom, langue, notes, fk_objet, est_standard, date_creation, date_modification, fk_type_nom_param, date_debut, date_fin) VALUES (786, 'Johannes Voegelin', NULL, NULL, 1576, true, '2015-11-06 16:04:13.593497+01', NULL, 15, NULL, NULL);
INSERT INTO nom_objet (pk_nom_objet, nom, langue, notes, fk_objet, est_standard, date_creation, date_modification, fk_type_nom_param, date_debut, date_fin) VALUES (787, 'Joannes Michael Gigas', NULL, NULL, 1577, true, '2015-11-06 16:04:13.593497+01', NULL, 15, NULL, NULL);
INSERT INTO nom_objet (pk_nom_objet, nom, langue, notes, fk_objet, est_standard, date_creation, date_modification, fk_type_nom_param, date_debut, date_fin) VALUES (788, 'Jean Pigeon', NULL, NULL, 1578, true, '2015-11-06 16:04:13.593497+01', NULL, 15, NULL, NULL);
INSERT INTO nom_objet (pk_nom_objet, nom, langue, notes, fk_objet, est_standard, date_creation, date_modification, fk_type_nom_param, date_debut, date_fin) VALUES (789, 'Dominique Blanqui', NULL, NULL, 1579, true, '2015-11-06 16:04:13.593497+01', NULL, 15, NULL, NULL);
INSERT INTO nom_objet (pk_nom_objet, nom, langue, notes, fk_objet, est_standard, date_creation, date_modification, fk_type_nom_param, date_debut, date_fin) VALUES (790, 'Anianus', NULL, NULL, 1580, true, '2015-11-06 16:04:13.593497+01', NULL, 15, NULL, NULL);
INSERT INTO nom_objet (pk_nom_objet, nom, langue, notes, fk_objet, est_standard, date_creation, date_modification, fk_type_nom_param, date_debut, date_fin) VALUES (791, 'Jean Bonfa', NULL, NULL, 1581, true, '2015-11-06 16:04:13.593497+01', NULL, 15, NULL, NULL);
INSERT INTO nom_objet (pk_nom_objet, nom, langue, notes, fk_objet, est_standard, date_creation, date_modification, fk_type_nom_param, date_debut, date_fin) VALUES (792, 'Ottaviano Cametti', NULL, NULL, 1582, true, '2015-11-06 16:04:13.593497+01', NULL, 15, NULL, NULL);
INSERT INTO nom_objet (pk_nom_objet, nom, langue, notes, fk_objet, est_standard, date_creation, date_modification, fk_type_nom_param, date_debut, date_fin) VALUES (793, 'Jean L''Hoste', NULL, NULL, 1583, true, '2015-11-06 16:04:13.593497+01', NULL, 15, NULL, NULL);
INSERT INTO nom_objet (pk_nom_objet, nom, langue, notes, fk_objet, est_standard, date_creation, date_modification, fk_type_nom_param, date_debut, date_fin) VALUES (794, 'Joannes Portantius', NULL, NULL, 1584, true, '2015-11-06 16:04:13.593497+01', NULL, 15, NULL, NULL);
INSERT INTO nom_objet (pk_nom_objet, nom, langue, notes, fk_objet, est_standard, date_creation, date_modification, fk_type_nom_param, date_debut, date_fin) VALUES (795, 'Benjamin Robins', NULL, NULL, 1585, true, '2015-11-06 16:04:13.593497+01', NULL, 15, NULL, NULL);
INSERT INTO nom_objet (pk_nom_objet, nom, langue, notes, fk_objet, est_standard, date_creation, date_modification, fk_type_nom_param, date_debut, date_fin) VALUES (796, 'Jacques Grandami', NULL, NULL, 1586, true, '2015-11-06 16:04:13.593497+01', NULL, 15, NULL, NULL);
INSERT INTO nom_objet (pk_nom_objet, nom, langue, notes, fk_objet, est_standard, date_creation, date_modification, fk_type_nom_param, date_debut, date_fin) VALUES (797, 'Ferdinand Verbiest', NULL, NULL, 1587, true, '2015-11-06 16:04:13.593497+01', NULL, 15, NULL, NULL);
INSERT INTO nom_objet (pk_nom_objet, nom, langue, notes, fk_objet, est_standard, date_creation, date_modification, fk_type_nom_param, date_debut, date_fin) VALUES (798, 'Jacques Charpentier', NULL, NULL, 1588, true, '2015-11-06 16:04:13.593497+01', NULL, 15, NULL, NULL);
INSERT INTO nom_objet (pk_nom_objet, nom, langue, notes, fk_objet, est_standard, date_creation, date_modification, fk_type_nom_param, date_debut, date_fin) VALUES (799, 'Robertus Castrensis', NULL, NULL, 1589, true, '2015-11-06 16:04:13.593497+01', NULL, 15, NULL, NULL);
INSERT INTO nom_objet (pk_nom_objet, nom, langue, notes, fk_objet, est_standard, date_creation, date_modification, fk_type_nom_param, date_debut, date_fin) VALUES (800, 'Taddeo da Parma', NULL, NULL, 1590, true, '2015-11-06 16:04:13.593497+01', NULL, 15, NULL, NULL);
INSERT INTO nom_objet (pk_nom_objet, nom, langue, notes, fk_objet, est_standard, date_creation, date_modification, fk_type_nom_param, date_debut, date_fin) VALUES (801, 'Nicolas-Louis de La Caille', NULL, NULL, 1591, true, '2015-11-06 16:04:13.593497+01', NULL, 15, NULL, NULL);
INSERT INTO nom_objet (pk_nom_objet, nom, langue, notes, fk_objet, est_standard, date_creation, date_modification, fk_type_nom_param, date_debut, date_fin) VALUES (802, 'Claude de Boissière', NULL, NULL, 1592, true, '2015-11-06 16:04:13.593497+01', NULL, 15, NULL, NULL);
INSERT INTO nom_objet (pk_nom_objet, nom, langue, notes, fk_objet, est_standard, date_creation, date_modification, fk_type_nom_param, date_debut, date_fin) VALUES (803, 'Maria Cunitia', NULL, NULL, 1593, true, '2015-11-06 16:04:13.593497+01', NULL, 15, NULL, NULL);
INSERT INTO nom_objet (pk_nom_objet, nom, langue, notes, fk_objet, est_standard, date_creation, date_modification, fk_type_nom_param, date_debut, date_fin) VALUES (804, 'Joseph Amiot', NULL, NULL, 1594, true, '2015-11-06 16:04:13.593497+01', NULL, 15, NULL, NULL);
INSERT INTO nom_objet (pk_nom_objet, nom, langue, notes, fk_objet, est_standard, date_creation, date_modification, fk_type_nom_param, date_debut, date_fin) VALUES (805, 'Adrien-Marie Legendre', NULL, NULL, 1595, true, '2015-11-06 16:04:13.593497+01', NULL, 15, NULL, NULL);
INSERT INTO nom_objet (pk_nom_objet, nom, langue, notes, fk_objet, est_standard, date_creation, date_modification, fk_type_nom_param, date_debut, date_fin) VALUES (806, 'Maurice Bressieu', NULL, NULL, 1596, true, '2015-11-06 16:04:13.593497+01', NULL, 15, NULL, NULL);
INSERT INTO nom_objet (pk_nom_objet, nom, langue, notes, fk_objet, est_standard, date_creation, date_modification, fk_type_nom_param, date_debut, date_fin) VALUES (807, 'Samuel Marolois', NULL, NULL, 1597, true, '2015-11-06 16:04:13.593497+01', NULL, 15, NULL, NULL);
INSERT INTO nom_objet (pk_nom_objet, nom, langue, notes, fk_objet, est_standard, date_creation, date_modification, fk_type_nom_param, date_debut, date_fin) VALUES (808, 'Giovanni Paradisi', NULL, NULL, 1598, true, '2015-11-06 16:04:13.593497+01', NULL, 15, NULL, NULL);
INSERT INTO nom_objet (pk_nom_objet, nom, langue, notes, fk_objet, est_standard, date_creation, date_modification, fk_type_nom_param, date_debut, date_fin) VALUES (809, 'Michelangelo Galilei', NULL, NULL, 1599, true, '2015-11-06 16:04:13.593497+01', NULL, 15, NULL, NULL);
INSERT INTO nom_objet (pk_nom_objet, nom, langue, notes, fk_objet, est_standard, date_creation, date_modification, fk_type_nom_param, date_debut, date_fin) VALUES (810, 'Guillaume Bonjour', NULL, NULL, 1600, true, '2015-11-06 16:04:13.593497+01', NULL, 15, NULL, NULL);
INSERT INTO nom_objet (pk_nom_objet, nom, langue, notes, fk_objet, est_standard, date_creation, date_modification, fk_type_nom_param, date_debut, date_fin) VALUES (811, 'Henri de Monantheuil', NULL, NULL, 1601, true, '2015-11-06 16:04:13.593497+01', NULL, 15, NULL, NULL);
INSERT INTO nom_objet (pk_nom_objet, nom, langue, notes, fk_objet, est_standard, date_creation, date_modification, fk_type_nom_param, date_debut, date_fin) VALUES (812, 'Rodolphus Goclenius', NULL, NULL, 1602, true, '2015-11-06 16:04:13.593497+01', NULL, 15, NULL, NULL);
INSERT INTO nom_objet (pk_nom_objet, nom, langue, notes, fk_objet, est_standard, date_creation, date_modification, fk_type_nom_param, date_debut, date_fin) VALUES (813, 'Gersonide', NULL, NULL, 1603, true, '2015-11-06 16:04:13.593497+01', NULL, 15, NULL, NULL);
INSERT INTO nom_objet (pk_nom_objet, nom, langue, notes, fk_objet, est_standard, date_creation, date_modification, fk_type_nom_param, date_debut, date_fin) VALUES (814, 'Giovanni Abiosi', NULL, NULL, 1604, true, '2015-11-06 16:04:13.593497+01', NULL, 15, NULL, NULL);
INSERT INTO nom_objet (pk_nom_objet, nom, langue, notes, fk_objet, est_standard, date_creation, date_modification, fk_type_nom_param, date_debut, date_fin) VALUES (815, 'Nikolaus von Fuss', NULL, NULL, 1605, true, '2015-11-06 16:04:13.593497+01', NULL, 15, NULL, NULL);
INSERT INTO nom_objet (pk_nom_objet, nom, langue, notes, fk_objet, est_standard, date_creation, date_modification, fk_type_nom_param, date_debut, date_fin) VALUES (816, 'Takakazu Seki', NULL, NULL, 1606, true, '2015-11-06 16:04:13.593497+01', NULL, 15, NULL, NULL);
INSERT INTO nom_objet (pk_nom_objet, nom, langue, notes, fk_objet, est_standard, date_creation, date_modification, fk_type_nom_param, date_debut, date_fin) VALUES (817, 'Benito Bails', NULL, NULL, 1607, true, '2015-11-06 16:04:13.593497+01', NULL, 15, NULL, NULL);
INSERT INTO nom_objet (pk_nom_objet, nom, langue, notes, fk_objet, est_standard, date_creation, date_modification, fk_type_nom_param, date_debut, date_fin) VALUES (818, 'Patrizio Tricasso', NULL, NULL, 1608, true, '2015-11-06 16:04:13.593497+01', NULL, 15, NULL, NULL);
INSERT INTO nom_objet (pk_nom_objet, nom, langue, notes, fk_objet, est_standard, date_creation, date_modification, fk_type_nom_param, date_debut, date_fin) VALUES (819, 'Eilhard Lubbin', NULL, NULL, 1609, true, '2015-11-06 16:04:13.593497+01', NULL, 15, NULL, NULL);
INSERT INTO nom_objet (pk_nom_objet, nom, langue, notes, fk_objet, est_standard, date_creation, date_modification, fk_type_nom_param, date_debut, date_fin) VALUES (820, 'Johann Bernoulli', NULL, NULL, 1610, true, '2015-11-06 16:04:13.593497+01', NULL, 15, NULL, NULL);
INSERT INTO nom_objet (pk_nom_objet, nom, langue, notes, fk_objet, est_standard, date_creation, date_modification, fk_type_nom_param, date_debut, date_fin) VALUES (821, 'John Winthrop', NULL, NULL, 1611, true, '2015-11-06 16:04:13.593497+01', NULL, 15, NULL, NULL);
INSERT INTO nom_objet (pk_nom_objet, nom, langue, notes, fk_objet, est_standard, date_creation, date_modification, fk_type_nom_param, date_debut, date_fin) VALUES (822, 'René-François De Sluse', NULL, NULL, 1612, true, '2015-11-06 16:04:13.593497+01', NULL, 15, NULL, NULL);
INSERT INTO nom_objet (pk_nom_objet, nom, langue, notes, fk_objet, est_standard, date_creation, date_modification, fk_type_nom_param, date_debut, date_fin) VALUES (823, 'Aegidius Martini', NULL, NULL, 1613, true, '2015-11-06 16:04:13.593497+01', NULL, 15, NULL, NULL);
INSERT INTO nom_objet (pk_nom_objet, nom, langue, notes, fk_objet, est_standard, date_creation, date_modification, fk_type_nom_param, date_debut, date_fin) VALUES (824, 'Veuve de Louis Courcier', NULL, NULL, 1614, true, '2015-11-06 16:04:13.593497+01', NULL, 15, NULL, NULL);
INSERT INTO nom_objet (pk_nom_objet, nom, langue, notes, fk_objet, est_standard, date_creation, date_modification, fk_type_nom_param, date_debut, date_fin) VALUES (825, 'Francesco Maria Pompeo Colonna', NULL, NULL, 1615, true, '2015-11-06 16:04:13.593497+01', NULL, 15, NULL, NULL);
INSERT INTO nom_objet (pk_nom_objet, nom, langue, notes, fk_objet, est_standard, date_creation, date_modification, fk_type_nom_param, date_debut, date_fin) VALUES (826, 'Thomas Simpson', NULL, NULL, 1616, true, '2015-11-06 16:04:13.593497+01', NULL, 15, NULL, NULL);
INSERT INTO nom_objet (pk_nom_objet, nom, langue, notes, fk_objet, est_standard, date_creation, date_modification, fk_type_nom_param, date_debut, date_fin) VALUES (827, 'André-Pierre Le Guay de Prémontval', NULL, NULL, 1617, true, '2015-11-06 16:04:13.593497+01', NULL, 15, NULL, NULL);
INSERT INTO nom_objet (pk_nom_objet, nom, langue, notes, fk_objet, est_standard, date_creation, date_modification, fk_type_nom_param, date_debut, date_fin) VALUES (828, 'Livio Sanuto', NULL, NULL, 1618, true, '2015-11-06 16:04:13.593497+01', NULL, 15, NULL, NULL);
INSERT INTO nom_objet (pk_nom_objet, nom, langue, notes, fk_objet, est_standard, date_creation, date_modification, fk_type_nom_param, date_debut, date_fin) VALUES (829, 'Maestlin, Michael', NULL, NULL, 1619, true, '2015-11-09 20:49:27.523476+01', '2015-11-09 21:17:58.333961+01', 15, NULL, NULL);
INSERT INTO nom_objet (pk_nom_objet, nom, langue, notes, fk_objet, est_standard, date_creation, date_modification, fk_type_nom_param, date_debut, date_fin) VALUES (831, 'Enseignement', NULL, NULL, 1621, true, '2015-11-09 22:47:05.88286+01', NULL, 15, NULL, NULL);
INSERT INTO nom_objet (pk_nom_objet, nom, langue, notes, fk_objet, est_standard, date_creation, date_modification, fk_type_nom_param, date_debut, date_fin) VALUES (830, 'Grienberger, Christoph', NULL, NULL, 1620, true, '2015-11-09 21:16:14.612612+01', '2015-11-09 21:18:14.77701+01', 15, NULL, NULL);
INSERT INTO nom_objet (pk_nom_objet, nom, langue, notes, fk_objet, est_standard, date_creation, date_modification, fk_type_nom_param, date_debut, date_fin) VALUES (832, 'enseigné (être)', NULL, NULL, 1622, true, '2015-11-09 22:55:11.522404+01', NULL, 15, NULL, NULL);
INSERT INTO nom_objet (pk_nom_objet, nom, langue, notes, fk_objet, est_standard, date_creation, date_modification, fk_type_nom_param, date_debut, date_fin) VALUES (833, 'exercé (être)', NULL, NULL, 1623, true, '2015-11-09 22:55:53.606288+01', NULL, 15, NULL, NULL);
INSERT INTO nom_objet (pk_nom_objet, nom, langue, notes, fk_objet, est_standard, date_creation, date_modification, fk_type_nom_param, date_debut, date_fin) VALUES (834, 'exercer', NULL, NULL, 1624, true, '2015-11-09 22:56:49.257973+01', NULL, 15, NULL, NULL);
INSERT INTO nom_objet (pk_nom_objet, nom, langue, notes, fk_objet, est_standard, date_creation, date_modification, fk_type_nom_param, date_debut, date_fin) VALUES (835, 'Professeur', NULL, NULL, 1625, true, '2015-11-09 23:15:10.594084+01', NULL, 15, NULL, NULL);
INSERT INTO nom_objet (pk_nom_objet, nom, langue, notes, fk_objet, est_standard, date_creation, date_modification, fk_type_nom_param, date_debut, date_fin) VALUES (836, 'Caractéristiques d''un objet', NULL, NULL, 1626, true, '2015-11-10 08:30:34.176083+01', NULL, 15, NULL, NULL);
INSERT INTO nom_objet (pk_nom_objet, nom, langue, notes, fk_objet, est_standard, date_creation, date_modification, fk_type_nom_param, date_debut, date_fin) VALUES (837, 'typer', NULL, NULL, 1627, true, '2015-11-10 08:45:58.265717+01', NULL, 15, NULL, NULL);
INSERT INTO nom_objet (pk_nom_objet, nom, langue, notes, fk_objet, est_standard, date_creation, date_modification, fk_type_nom_param, date_debut, date_fin) VALUES (838, 'caractériser', NULL, NULL, 1628, true, '2015-11-10 08:46:54.63968+01', NULL, 15, NULL, NULL);
INSERT INTO nom_objet (pk_nom_objet, nom, langue, notes, fk_objet, est_standard, date_creation, date_modification, fk_type_nom_param, date_debut, date_fin) VALUES (839, 'Théologien', NULL, NULL, 1629, true, '2015-11-10 22:00:21.157754+01', NULL, 15, NULL, NULL);
INSERT INTO nom_objet (pk_nom_objet, nom, langue, notes, fk_objet, est_standard, date_creation, date_modification, fk_type_nom_param, date_debut, date_fin) VALUES (840, 'Physicien', NULL, NULL, 1630, true, '2015-11-10 22:13:25.653964+01', NULL, 15, NULL, NULL);
INSERT INTO nom_objet (pk_nom_objet, nom, langue, notes, fk_objet, est_standard, date_creation, date_modification, fk_type_nom_param, date_debut, date_fin) VALUES (841, 'Libraire', NULL, NULL, 1631, true, '2015-11-13 17:45:46.72275+01', NULL, 15, NULL, NULL);
INSERT INTO nom_objet (pk_nom_objet, nom, langue, notes, fk_objet, est_standard, date_creation, date_modification, fk_type_nom_param, date_debut, date_fin) VALUES (842, 'Imprimeur', NULL, NULL, 1632, true, '2015-11-13 17:58:26.832029+01', NULL, 15, NULL, NULL);
INSERT INTO nom_objet (pk_nom_objet, nom, langue, notes, fk_objet, est_standard, date_creation, date_modification, fk_type_nom_param, date_debut, date_fin) VALUES (843, 'Ingénieur', NULL, NULL, 1633, true, '2015-11-13 18:00:15.934578+01', NULL, 15, NULL, NULL);
INSERT INTO nom_objet (pk_nom_objet, nom, langue, notes, fk_objet, est_standard, date_creation, date_modification, fk_type_nom_param, date_debut, date_fin) VALUES (844, 'Chimiste', NULL, NULL, 1634, true, '2015-11-13 18:02:31.108708+01', NULL, 15, NULL, NULL);
INSERT INTO nom_objet (pk_nom_objet, nom, langue, notes, fk_objet, est_standard, date_creation, date_modification, fk_type_nom_param, date_debut, date_fin) VALUES (845, 'Architecte', NULL, NULL, 1635, true, '2015-11-13 18:09:46.344278+01', NULL, 15, NULL, NULL);
INSERT INTO nom_objet (pk_nom_objet, nom, langue, notes, fk_objet, est_standard, date_creation, date_modification, fk_type_nom_param, date_debut, date_fin) VALUES (846, 'Cartographe', NULL, NULL, 1636, true, '2015-11-13 18:12:35.512831+01', NULL, 15, NULL, NULL);


--
-- TOC entry 2414 (class 0 OID 0)
-- Dependencies: 180
-- Name: nom_objet_cle_nom_objet_seq; Type: SEQUENCE SET; Schema: objets; Owner: -
--

SELECT pg_catalog.setval('nom_objet_cle_nom_objet_seq', 846, true);


--
-- TOC entry 2398 (class 0 OID 22746)
-- Dependencies: 181
-- Data for Name: objet; Type: TABLE DATA; Schema: objets; Owner: -
--

INSERT INTO objet (pk_objet, definition, notes, date_creation, date_modification, cle_importation, cle_importation_txt, longitude, latitude, texte_xml, fk_type_objet_param, genre, texte, langue_texte) VALUES (34, 'Ce concept indique la source d''un texte, d''une connaissance, etc.', NULL, '2015-10-13 17:42:49.184459+02', '2015-11-09 19:02:28.873888+01', NULL, NULL, NULL, NULL, NULL, 3, NULL, NULL, NULL);
INSERT INTO objet (pk_objet, definition, notes, date_creation, date_modification, cle_importation, cle_importation_txt, longitude, latitude, texte_xml, fk_type_objet_param, genre, texte, langue_texte) VALUES (1197, 'Mathématicien et astronome', NULL, '2015-11-06 15:07:57.421147+01', '2015-11-09 14:28:49.740493+01', NULL, 'http://data.bnf.fr/ark:/12148/cb12399386c#foaf:Person', NULL, NULL, NULL, 8, NULL, 'http://data.bnf.fr/ark:/12148/cb12399386c#foaf:Person', NULL);
INSERT INTO objet (pk_objet, definition, notes, date_creation, date_modification, cle_importation, cle_importation_txt, longitude, latitude, texte_xml, fk_type_objet_param, genre, texte, langue_texte) VALUES (35, NULL, NULL, '2015-10-13 17:46:12.942494+02', '2015-11-06 18:03:40.521576+01', NULL, NULL, NULL, NULL, NULL, 5, NULL, NULL, NULL);
INSERT INTO objet (pk_objet, definition, notes, date_creation, date_modification, cle_importation, cle_importation_txt, longitude, latitude, texte_xml, fk_type_objet_param, genre, texte, langue_texte) VALUES (9, 'Tout résumé synthétique placé au début d''une notice de dictionnaire qui résume les traits essentiels de l''objet concerné par la notice (acteur, institution, etc.)', NULL, '2015-09-30 17:31:31.168992+02', '2015-11-09 19:05:25.836996+01', NULL, NULL, NULL, NULL, NULL, 3, NULL, NULL, NULL);
INSERT INTO objet (pk_objet, definition, notes, date_creation, date_modification, cle_importation, cle_importation_txt, longitude, latitude, texte_xml, fk_type_objet_param, genre, texte, langue_texte) VALUES (1619, 'Astronome', NULL, '2015-11-09 20:49:27.523476+01', '2015-11-09 21:17:58.333961+01', NULL, NULL, NULL, NULL, NULL, 1, NULL, NULL, NULL);
INSERT INTO objet (pk_objet, definition, notes, date_creation, date_modification, cle_importation, cle_importation_txt, longitude, latitude, texte_xml, fk_type_objet_param, genre, texte, langue_texte) VALUES (1620, 'Jésuite, astronome', NULL, '2015-11-09 21:16:14.612612+01', '2015-11-09 21:18:14.77701+01', NULL, NULL, NULL, NULL, NULL, 1, NULL, NULL, NULL);
INSERT INTO objet (pk_objet, definition, notes, date_creation, date_modification, cle_importation, cle_importation_txt, longitude, latitude, texte_xml, fk_type_objet_param, genre, texte, langue_texte) VALUES (1621, 'Exercer la fonction d''enseigner, avec indication de l''institution auprès de laquelle s''exerce l''enseignement et des matières enseignées. (TyIn97)', NULL, '2015-11-09 22:47:05.88286+01', NULL, NULL, NULL, NULL, NULL, NULL, 37, NULL, NULL, NULL);
INSERT INTO objet (pk_objet, definition, notes, date_creation, date_modification, cle_importation, cle_importation_txt, longitude, latitude, texte_xml, fk_type_objet_param, genre, texte, langue_texte) VALUES (1622, 'Associe une matière enseignée', NULL, '2015-11-09 22:55:11.522404+01', NULL, NULL, NULL, NULL, NULL, NULL, 38, NULL, NULL, NULL);
INSERT INTO objet (pk_objet, definition, notes, date_creation, date_modification, cle_importation, cle_importation_txt, longitude, latitude, texte_xml, fk_type_objet_param, genre, texte, langue_texte) VALUES (904, 'Astronome, physicien et médecin byzantin. - Évêque de Tabriz, Iran', NULL, '2015-11-06 15:07:57.421147+01', '2015-11-09 14:28:49.740493+01', NULL, 'http://data.bnf.fr/ark:/12148/cb12007088c#foaf:Person', NULL, NULL, NULL, 8, NULL, 'http://data.bnf.fr/ark:/12148/cb12007088c#foaf:Person', NULL);
INSERT INTO objet (pk_objet, definition, notes, date_creation, date_modification, cle_importation, cle_importation_txt, longitude, latitude, texte_xml, fk_type_objet_param, genre, texte, langue_texte) VALUES (1193, 'Dessinateur et graveur, mathématicien', NULL, '2015-11-06 15:07:57.421147+01', '2015-11-09 14:28:49.740493+01', NULL, 'http://data.bnf.fr/ark:/12148/cb153705873#foaf:Person', NULL, NULL, NULL, 8, NULL, 'http://data.bnf.fr/ark:/12148/cb153705873#foaf:Person', NULL);
INSERT INTO objet (pk_objet, definition, notes, date_creation, date_modification, cle_importation, cle_importation_txt, longitude, latitude, texte_xml, fk_type_objet_param, genre, texte, langue_texte) VALUES (1623, 'Une profession ou tout autre caractère social qui est exercé', NULL, '2015-11-09 22:55:53.606288+01', NULL, NULL, NULL, NULL, NULL, NULL, 38, NULL, NULL, NULL);
INSERT INTO objet (pk_objet, definition, notes, date_creation, date_modification, cle_importation, cle_importation_txt, longitude, latitude, texte_xml, fk_type_objet_param, genre, texte, langue_texte) VALUES (1624, 'Exercer un métier, un enseignement, ... – associe l''acteur qui exerce', NULL, '2015-11-09 22:56:49.257973+01', NULL, NULL, NULL, NULL, NULL, NULL, 38, NULL, NULL, NULL);
INSERT INTO objet (pk_objet, definition, notes, date_creation, date_modification, cle_importation, cle_importation_txt, longitude, latitude, texte_xml, fk_type_objet_param, genre, texte, langue_texte) VALUES (1625, 'Personne qui enseigne une discipline, une technique, un art.', NULL, '2015-11-09 23:15:10.594084+01', NULL, NULL, NULL, NULL, NULL, NULL, 4, NULL, NULL, NULL);
INSERT INTO objet (pk_objet, definition, notes, date_creation, date_modification, cle_importation, cle_importation_txt, longitude, latitude, texte_xml, fk_type_objet_param, genre, texte, langue_texte) VALUES (856, 'Mathématicien, navigateur et hydrographe', NULL, '2015-11-06 15:07:57.421147+01', '2015-11-09 14:28:49.740493+01', NULL, 'http://data.bnf.fr/ark:/12148/cb153879695#foaf:Person', NULL, NULL, NULL, 8, NULL, 'http://data.bnf.fr/ark:/12148/cb153879695#foaf:Person', NULL);
INSERT INTO objet (pk_objet, definition, notes, date_creation, date_modification, cle_importation, cle_importation_txt, longitude, latitude, texte_xml, fk_type_objet_param, genre, texte, langue_texte) VALUES (1626, 'Les informations de ce type sont utilisées pour exprimer une caractéristique d''un objet à un moment donné', NULL, '2015-11-10 08:30:34.176083+01', NULL, NULL, NULL, NULL, NULL, NULL, 37, NULL, NULL, NULL);
INSERT INTO objet (pk_objet, definition, notes, date_creation, date_modification, cle_importation, cle_importation_txt, longitude, latitude, texte_xml, fk_type_objet_param, genre, texte, langue_texte) VALUES (851, 'Ingénieur et astronome', NULL, '2015-11-06 15:07:57.421147+01', '2015-11-09 14:28:49.740493+01', NULL, 'http://data.bnf.fr/ark:/12148/cb12155087r#foaf:Person', NULL, NULL, NULL, 8, NULL, 'http://data.bnf.fr/ark:/12148/cb12155087r#foaf:Person', NULL);
INSERT INTO objet (pk_objet, definition, notes, date_creation, date_modification, cle_importation, cle_importation_txt, longitude, latitude, texte_xml, fk_type_objet_param, genre, texte, langue_texte) VALUES (1627, 'Associe un type sour forme d''objet abstrait', NULL, '2015-11-10 08:45:58.265717+01', NULL, NULL, NULL, NULL, NULL, NULL, 38, NULL, NULL, NULL);
INSERT INTO objet (pk_objet, definition, notes, date_creation, date_modification, cle_importation, cle_importation_txt, longitude, latitude, texte_xml, fk_type_objet_param, genre, texte, langue_texte) VALUES (1628, 'Associe une caractéristique sous forme d''objet abstrait', NULL, '2015-11-10 08:46:54.63968+01', NULL, NULL, NULL, NULL, NULL, NULL, 38, NULL, NULL, NULL);
INSERT INTO objet (pk_objet, definition, notes, date_creation, date_modification, cle_importation, cle_importation_txt, longitude, latitude, texte_xml, fk_type_objet_param, genre, texte, langue_texte) VALUES (1126, 'Philosophe et théologien. - Astronome. - Poète et musicien', NULL, '2015-11-06 15:07:57.421147+01', '2015-11-09 14:28:49.740493+01', NULL, 'http://data.bnf.fr/ark:/12148/cb12220635h#foaf:Person', NULL, NULL, NULL, 8, NULL, 'http://data.bnf.fr/ark:/12148/cb12220635h#foaf:Person', NULL);
INSERT INTO objet (pk_objet, definition, notes, date_creation, date_modification, cle_importation, cle_importation_txt, longitude, latitude, texte_xml, fk_type_objet_param, genre, texte, langue_texte) VALUES (1306, 'Philosophe, logicien, astronome', NULL, '2015-11-06 15:07:57.421147+01', '2015-11-09 14:28:49.740493+01', NULL, 'http://data.bnf.fr/ark:/12148/cb15935708x#foaf:Person', NULL, NULL, NULL, 8, NULL, 'http://data.bnf.fr/ark:/12148/cb15935708x#foaf:Person', NULL);
INSERT INTO objet (pk_objet, definition, notes, date_creation, date_modification, cle_importation, cle_importation_txt, longitude, latitude, texte_xml, fk_type_objet_param, genre, texte, langue_texte) VALUES (20, 'Descriptif synthétique des caractéristiques d''un objet, tel un article de dictionnaire, etc.', NULL, '2015-10-04 10:40:12.841066+02', '2015-11-06 18:03:40.521576+01', NULL, NULL, NULL, NULL, NULL, 3, NULL, NULL, NULL);
INSERT INTO objet (pk_objet, definition, notes, date_creation, date_modification, cle_importation, cle_importation_txt, longitude, latitude, texte_xml, fk_type_objet_param, genre, texte, langue_texte) VALUES (6, 'Discipline qui étudie les mouvements des astres', NULL, '2015-09-28 21:20:15.740526+02', '2015-11-06 18:03:40.521576+01', NULL, NULL, NULL, NULL, NULL, 3, NULL, NULL, NULL);
INSERT INTO objet (pk_objet, definition, notes, date_creation, date_modification, cle_importation, cle_importation_txt, longitude, latitude, texte_xml, fk_type_objet_param, genre, texte, langue_texte) VALUES (11, 'Le fait de la naissance d''une personne, avec le lieu et la date', NULL, '2015-09-30 17:52:16.518456+02', '2015-11-06 18:03:40.521576+01', NULL, NULL, NULL, NULL, NULL, 37, NULL, NULL, NULL);
INSERT INTO objet (pk_objet, definition, notes, date_creation, date_modification, cle_importation, cle_importation_txt, longitude, latitude, texte_xml, fk_type_objet_param, genre, texte, langue_texte) VALUES (12, 'La mention de la naissance d''une personne, avec le lieu et la date', NULL, '2015-09-30 17:53:02.319296+02', '2015-11-06 18:03:40.521576+01', NULL, NULL, NULL, NULL, NULL, 36, NULL, NULL, NULL);
INSERT INTO objet (pk_objet, definition, notes, date_creation, date_modification, cle_importation, cle_importation_txt, longitude, latitude, texte_xml, fk_type_objet_param, genre, texte, langue_texte) VALUES (10, 'Associe l''objet concerné par l''unité de connaissance', NULL, '2015-09-30 17:45:49.20009+02', '2015-11-06 18:03:40.521576+01', NULL, NULL, NULL, NULL, NULL, 38, NULL, NULL, NULL);
INSERT INTO objet (pk_objet, definition, notes, date_creation, date_modification, cle_importation, cle_importation_txt, longitude, latitude, texte_xml, fk_type_objet_param, genre, texte, langue_texte) VALUES (13, NULL, NULL, '2015-09-30 17:56:09.260378+02', '2015-11-06 18:03:40.521576+01', NULL, NULL, NULL, NULL, NULL, 33, NULL, NULL, NULL);
INSERT INTO objet (pk_objet, definition, notes, date_creation, date_modification, cle_importation, cle_importation_txt, longitude, latitude, texte_xml, fk_type_objet_param, genre, texte, langue_texte) VALUES (1339, 'Astrologue, géomancien et astronome. Fut professeur à l''Université de Bologne (1288-1297)', NULL, '2015-11-06 15:07:57.421147+01', '2015-11-09 14:28:49.740493+01', NULL, 'http://data.bnf.fr/ark:/12148/cb144790439#foaf:Person', NULL, NULL, NULL, 8, NULL, 'http://data.bnf.fr/ark:/12148/cb144790439#foaf:Person', NULL);
INSERT INTO objet (pk_objet, definition, notes, date_creation, date_modification, cle_importation, cle_importation_txt, longitude, latitude, texte_xml, fk_type_objet_param, genre, texte, langue_texte) VALUES (1551, 'Astronome. - Mathématicien, commentateur d''Euclide', NULL, '2015-11-06 15:07:57.421147+01', '2015-11-09 14:28:49.740493+01', NULL, 'http://data.bnf.fr/ark:/12148/cb124917005#foaf:Person', NULL, NULL, NULL, 8, NULL, 'http://data.bnf.fr/ark:/12148/cb124917005#foaf:Person', NULL);
INSERT INTO objet (pk_objet, definition, notes, date_creation, date_modification, cle_importation, cle_importation_txt, longitude, latitude, texte_xml, fk_type_objet_param, genre, texte, langue_texte) VALUES (1509, 'Philosophe. - Médecin. - Père de l''astronome Jacob Poel', NULL, '2015-11-06 15:07:57.421147+01', '2015-11-09 14:28:49.740493+01', NULL, 'http://data.bnf.fr/ark:/12148/cb16540698w#foaf:Person', NULL, NULL, NULL, 8, NULL, 'http://data.bnf.fr/ark:/12148/cb16540698w#foaf:Person', NULL);
INSERT INTO objet (pk_objet, definition, notes, date_creation, date_modification, cle_importation, cle_importation_txt, longitude, latitude, texte_xml, fk_type_objet_param, genre, texte, langue_texte) VALUES (912, 'Philologue. - Mathématicien et astrologue', NULL, '2015-11-06 15:07:57.421147+01', '2015-11-09 14:28:49.740493+01', NULL, 'http://data.bnf.fr/ark:/12148/cb12311753x#foaf:Person', NULL, NULL, NULL, 8, NULL, 'http://data.bnf.fr/ark:/12148/cb12311753x#foaf:Person', NULL);
INSERT INTO objet (pk_objet, definition, notes, date_creation, date_modification, cle_importation, cle_importation_txt, longitude, latitude, texte_xml, fk_type_objet_param, genre, texte, langue_texte) VALUES (1131, 'Éxégète. - Astronome', NULL, '2015-11-06 15:07:57.421147+01', '2015-11-09 14:28:49.740493+01', NULL, 'http://data.bnf.fr/ark:/12148/cb134867338#foaf:Person', NULL, NULL, NULL, 8, NULL, 'http://data.bnf.fr/ark:/12148/cb134867338#foaf:Person', NULL);
INSERT INTO objet (pk_objet, definition, notes, date_creation, date_modification, cle_importation, cle_importation_txt, longitude, latitude, texte_xml, fk_type_objet_param, genre, texte, langue_texte) VALUES (895, 'Mathématicien chinois. En activité entre 1261 et 1275', NULL, '2015-11-06 15:07:57.421147+01', '2015-11-09 14:28:49.740493+01', NULL, 'http://data.bnf.fr/ark:/12148/cb13746624q#foaf:Person', NULL, NULL, NULL, 8, NULL, 'http://data.bnf.fr/ark:/12148/cb13746624q#foaf:Person', NULL);
INSERT INTO objet (pk_objet, definition, notes, date_creation, date_modification, cle_importation, cle_importation_txt, longitude, latitude, texte_xml, fk_type_objet_param, genre, texte, langue_texte) VALUES (1553, 'Astronome. - Elève d''Asher ben Jehiel', NULL, '2015-11-06 15:07:57.421147+01', '2015-11-09 14:28:49.740493+01', NULL, 'http://data.bnf.fr/ark:/12148/cb16540863s#foaf:Person', NULL, NULL, NULL, 8, NULL, 'http://data.bnf.fr/ark:/12148/cb16540863s#foaf:Person', NULL);
INSERT INTO objet (pk_objet, definition, notes, date_creation, date_modification, cle_importation, cle_importation_txt, longitude, latitude, texte_xml, fk_type_objet_param, genre, texte, langue_texte) VALUES (1114, 'Mathématicien. - Actif en 1307', NULL, '2015-11-06 15:07:57.421147+01', '2015-11-09 14:28:49.740493+01', NULL, 'http://data.bnf.fr/ark:/12148/cb157815579#foaf:Person', NULL, NULL, NULL, 8, NULL, 'http://data.bnf.fr/ark:/12148/cb157815579#foaf:Person', NULL);
INSERT INTO objet (pk_objet, definition, notes, date_creation, date_modification, cle_importation, cle_importation_txt, longitude, latitude, texte_xml, fk_type_objet_param, genre, texte, langue_texte) VALUES (877, 'Mathématicien. - Probablement d''origine italienne', NULL, '2015-11-06 15:07:57.421147+01', '2015-11-09 14:28:49.740493+01', NULL, 'http://data.bnf.fr/ark:/12148/cb11986727x#foaf:Person', NULL, NULL, NULL, 8, NULL, 'http://data.bnf.fr/ark:/12148/cb11986727x#foaf:Person', NULL);
INSERT INTO objet (pk_objet, definition, notes, date_creation, date_modification, cle_importation, cle_importation_txt, longitude, latitude, texte_xml, fk_type_objet_param, genre, texte, langue_texte) VALUES (849, 'Mathématicien, astronome, philosophe. - Attesté entre 1290 et 1300. - Élève à l''Université de Bologne (1291-1292) puis de Paris. - Chanoine de Roskilde, Danemark. - A distinguer de Petrus de Dacia, recteur de l''Université de Paris en 1327', NULL, '2015-11-06 15:07:57.421147+01', '2015-11-09 14:28:49.740493+01', NULL, 'http://data.bnf.fr/ark:/12148/cb11887258w#foaf:Person', NULL, NULL, NULL, 8, NULL, 'http://data.bnf.fr/ark:/12148/cb11887258w#foaf:Person', NULL);
INSERT INTO objet (pk_objet, definition, notes, date_creation, date_modification, cle_importation, cle_importation_txt, longitude, latitude, texte_xml, fk_type_objet_param, genre, texte, langue_texte) VALUES (1436, 'Mathématicien et jurisconsulte chaféite', NULL, '2015-11-06 15:07:57.421147+01', '2015-11-09 14:28:49.740493+01', NULL, 'http://data.bnf.fr/ark:/12148/cb155674927#foaf:Person', NULL, NULL, NULL, 8, NULL, 'http://data.bnf.fr/ark:/12148/cb155674927#foaf:Person', NULL);
INSERT INTO objet (pk_objet, definition, notes, date_creation, date_modification, cle_importation, cle_importation_txt, longitude, latitude, texte_xml, fk_type_objet_param, genre, texte, langue_texte) VALUES (923, 'Astronome. - Précepteur de Boccace. - Ambassadeur de la République de Gênes auprès de l''empereur Alexis Comnène (en 1314)', NULL, '2015-11-06 15:07:57.421147+01', '2015-11-09 14:28:49.740493+01', NULL, 'http://data.bnf.fr/ark:/12148/cb121998732#foaf:Person', NULL, NULL, NULL, 8, NULL, 'http://data.bnf.fr/ark:/12148/cb121998732#foaf:Person', NULL);
INSERT INTO objet (pk_objet, definition, notes, date_creation, date_modification, cle_importation, cle_importation_txt, longitude, latitude, texte_xml, fk_type_objet_param, genre, texte, langue_texte) VALUES (1239, 'Homme d''état, philosophe, poète, astronome et rhéteur', NULL, '2015-11-06 15:07:57.421147+01', '2015-11-09 14:28:49.740493+01', NULL, 'http://data.bnf.fr/ark:/12148/cb12000562c#foaf:Person', NULL, NULL, NULL, 8, NULL, 'http://data.bnf.fr/ark:/12148/cb12000562c#foaf:Person', NULL);
INSERT INTO objet (pk_objet, definition, notes, date_creation, date_modification, cle_importation, cle_importation_txt, longitude, latitude, texte_xml, fk_type_objet_param, genre, texte, langue_texte) VALUES (2, 'Astronome, mathématicien de l''empereur du Saint-Empire', NULL, '2015-09-25 22:41:54.367439+02', '2015-11-06 18:03:40.521576+01', NULL, NULL, NULL, NULL, NULL, 1, 'm', NULL, NULL);
INSERT INTO objet (pk_objet, definition, notes, date_creation, date_modification, cle_importation, cle_importation_txt, longitude, latitude, texte_xml, fk_type_objet_param, genre, texte, langue_texte) VALUES (7, 'Astronome et mathématicien', NULL, '2015-09-28 22:42:59.619909+02', '2015-11-06 18:03:40.521576+01', NULL, NULL, NULL, NULL, NULL, 1, 'm', NULL, NULL);
INSERT INTO objet (pk_objet, definition, notes, date_creation, date_modification, cle_importation, cle_importation_txt, longitude, latitude, texte_xml, fk_type_objet_param, genre, texte, langue_texte) VALUES (21, NULL, NULL, '2015-10-05 08:46:30.390569+02', '2015-11-06 18:03:40.521576+01', NULL, NULL, 8.86666699999999963, 48.75, NULL, 9, NULL, NULL, NULL);
INSERT INTO objet (pk_objet, definition, notes, date_creation, date_modification, cle_importation, cle_importation_txt, longitude, latitude, texte_xml, fk_type_objet_param, genre, texte, langue_texte) VALUES (22, 'Associe un objet qui localiser l''unité de connaissance', NULL, '2015-10-05 08:48:23.727187+02', '2015-11-06 18:03:40.521576+01', NULL, NULL, NULL, NULL, NULL, 38, NULL, NULL, NULL);
INSERT INTO objet (pk_objet, definition, notes, date_creation, date_modification, cle_importation, cle_importation_txt, longitude, latitude, texte_xml, fk_type_objet_param, genre, texte, langue_texte) VALUES (23, 'Associe l''acteur concern; par l''UC ''naissance''', NULL, '2015-10-05 08:59:20.720318+02', '2015-11-06 18:03:40.521576+01', NULL, NULL, NULL, NULL, NULL, 38, NULL, NULL, NULL);
INSERT INTO objet (pk_objet, definition, notes, date_creation, date_modification, cle_importation, cle_importation_txt, longitude, latitude, texte_xml, fk_type_objet_param, genre, texte, langue_texte) VALUES (16, 'Celui ou celle qui pratique ou enseigne les mathématiques', NULL, '2015-10-03 09:57:19.385319+02', '2015-11-06 18:03:40.521576+01', NULL, NULL, NULL, NULL, NULL, 4, NULL, 'test', NULL);
INSERT INTO objet (pk_objet, definition, notes, date_creation, date_modification, cle_importation, cle_importation_txt, longitude, latitude, texte_xml, fk_type_objet_param, genre, texte, langue_texte) VALUES (17, NULL, NULL, '2015-10-03 09:57:48.242165+02', '2015-11-06 18:03:40.521576+01', NULL, NULL, NULL, NULL, NULL, 1, 'm', NULL, NULL);
INSERT INTO objet (pk_objet, definition, notes, date_creation, date_modification, cle_importation, cle_importation_txt, longitude, latitude, texte_xml, fk_type_objet_param, genre, texte, langue_texte) VALUES (1205, 'Moine basilien, abbé du Saint-Esprit à Constantinople (1331), évêque de Gérace (1342-1348). - Théologien, philosophe, mathématicien, astronome et helléniste', NULL, '2015-11-06 15:07:57.421147+01', '2015-11-09 14:28:49.740493+01', NULL, 'http://data.bnf.fr/ark:/12148/cb13549924x#foaf:Person', NULL, NULL, NULL, 8, NULL, 'http://data.bnf.fr/ark:/12148/cb13549924x#foaf:Person', NULL);
INSERT INTO objet (pk_objet, definition, notes, date_creation, date_modification, cle_importation, cle_importation_txt, longitude, latitude, texte_xml, fk_type_objet_param, genre, texte, langue_texte) VALUES (15, 'Discipline enseignée dans les universités qui s''intéresse aux nombres et à leurs relations', NULL, '2015-10-02 23:54:54.414336+02', '2015-11-06 18:03:40.521576+01', NULL, NULL, NULL, NULL, NULL, 3, NULL, NULL, NULL);
INSERT INTO objet (pk_objet, definition, notes, date_creation, date_modification, cle_importation, cle_importation_txt, longitude, latitude, texte_xml, fk_type_objet_param, genre, texte, langue_texte) VALUES (25, 'Celui ou celle qui pratique ou enseigne l''astrologie', NULL, '2015-10-06 04:36:45.268944+02', '2015-11-06 18:03:40.521576+01', NULL, NULL, NULL, NULL, NULL, 4, NULL, NULL, NULL);
INSERT INTO objet (pk_objet, definition, notes, date_creation, date_modification, cle_importation, cle_importation_txt, longitude, latitude, texte_xml, fk_type_objet_param, genre, texte, langue_texte) VALUES (1118, 'Philosophe, astronome, médecin italien célèbre pour la construction d''une pendule astrale à Padoue. - Père de Giovanni Dondi', NULL, '2015-11-06 15:07:57.421147+01', '2015-11-09 14:28:49.740493+01', NULL, 'http://data.bnf.fr/ark:/12148/cb124119184#foaf:Person', NULL, NULL, NULL, 8, NULL, 'http://data.bnf.fr/ark:/12148/cb124119184#foaf:Person', NULL);
INSERT INTO objet (pk_objet, definition, notes, date_creation, date_modification, cle_importation, cle_importation_txt, longitude, latitude, texte_xml, fk_type_objet_param, genre, texte, langue_texte) VALUES (24, 'Personne qui pratique ou enseigne l''astronomie', NULL, '2015-10-06 04:31:50.321678+02', '2015-11-06 18:03:40.521576+01', NULL, NULL, NULL, NULL, NULL, 4, NULL, NULL, NULL);
INSERT INTO objet (pk_objet, definition, notes, date_creation, date_modification, cle_importation, cle_importation_txt, longitude, latitude, texte_xml, fk_type_objet_param, genre, texte, langue_texte) VALUES (1086, 'Mathématicien, philosophe et théologien. - Surnommé le "Doctor Profundus". - Archevêque de Canterbury en 1349', NULL, '2015-11-06 15:07:57.421147+01', '2015-11-09 14:28:49.740493+01', NULL, 'http://data.bnf.fr/ark:/12148/cb12269047v#foaf:Person', NULL, NULL, NULL, 8, NULL, 'http://data.bnf.fr/ark:/12148/cb12269047v#foaf:Person', NULL);
INSERT INTO objet (pk_objet, definition, notes, date_creation, date_modification, cle_importation, cle_importation_txt, longitude, latitude, texte_xml, fk_type_objet_param, genre, texte, langue_texte) VALUES (1324, 'Mathématicien. - Astronome. - Abbé du monastère bénédictin de St Albans', NULL, '2015-11-06 15:07:57.421147+01', '2015-11-09 14:28:49.740493+01', NULL, 'http://data.bnf.fr/ark:/12148/cb12128305h#foaf:Person', NULL, NULL, NULL, 8, NULL, 'http://data.bnf.fr/ark:/12148/cb12128305h#foaf:Person', NULL);
INSERT INTO objet (pk_objet, definition, notes, date_creation, date_modification, cle_importation, cle_importation_txt, longitude, latitude, texte_xml, fk_type_objet_param, genre, texte, langue_texte) VALUES (3, NULL, NULL, '2015-09-25 22:47:03.926285+02', '2015-11-10 15:29:26.376954+01', NULL, NULL, NULL, NULL, '<root>
<ud>
<eud>Michael Maestlin</eud>

<ud ana="9">
<in ana="11"><en ref="1619"  ana="23">Michael Maestlin</en> (aussi appelé Mästlin, Möstlin, ou Moestlin), né le <dat when="15500930" type="du">30 septembre 1550</dat> à <en type="li" ana="22">Göppingen en Bade-Wurtemberg</en></in>, mort le 20 octobre 1631 à Tübingen, est un astronome et mathématicien allemand, connu pour être le mentor de Johannes Kepler.
</ud>



<ud>
<eud>Carrière</eud>

Maestlin a étudié la théologie, les mathématiques et l''astronomie au Tübinger Stift à Tübingen, une ville du Wurtemberg. Il a obtenu la maîtrise en 1571 et est devenu en 1576 un diacre luthérien à Backnang, tout en continuant ses études dans cette ville.

<in ana="1621"><dat when="1580" type="dd">En 1580</dat>, <en ref="1619"  ana="1624">il</en> est devenu <en><en ref="1625"  ana="1623">professeur</en> de <en ref="15"  ana="1622">mathématiques</en></en> à l''<en ana="10">université de <en type="li">Heidelberg</en></en>[jusqu''en <dat when="1583" type="df">1583</dat>]</in>. Il a écrit une introduction populaire à l''astronomie, en 1582. <in ana="1621"><en ref="1619"  ana="1624">Il</en> a enseigné ensuite à l''<en ana="10">université de <en type="li">Tübingen</en></en> à partir de <dat when="1583" type="dd">1583</dat>, à l''âge de 47 ans</in>.

Il comptait parmi ses étudiants Johannes Kepler (1571-1630)1. Bien qu''il enseignât au départ la représentation géocentrique traditionnelle du Système solaire selon Ptolémée, Maestlin était aussi l''un des premiers à accepter et à enseigner la représentation héliocentrique de Copernic. Maestlin correspondait fréquemment avec Kepler et joua un rôle significatif dans son adoption du système copernicien. On attribue aussi l''adoption de l''héliocentrisme par Galilée à Maestlin2.

Le premier calcul connu de l''inverse du nombre d''or où il donne la valeur « environ 0.6180340 » a été écrit en 1597 par Maestlin dans une lettre à Kepler.
</ud>
<ud ana="34">https://fr.wikipedia.org/w/index.php?title=Michael_Maestlin&amp;oldid=115018735</ud>
</ud>



<ud>
<eud>Christopher Grienberger</eud>

<ud ana="9"><in ana="11"><en ref="1620"  ana="23">Christopher Grienberger</en> (aussi écrit Christopher Gruemberger, ou encore Grinberg, Bamberger, ou Gamberger, voire Panberger), né le <dat when="15510702" type="du">2 juillet 1551</dat> à <en type="li" ana="22">Hall dans le Tyrol</en></in>, et mort le 11 mars 1636 à Rome, est prêtre jésuite autrichien, mathématicien et professeur au Collège romain. Un cratère lunaire est nommé en son honneur Gruemberger.</ud>

<ud>
<eud>Biographie</eud>
Grienberger entre dans la Compagnie de Jésus le 20 août 1580. Après des études de rhétorique à Prague (1583–1584), il devient professeur de mathématiques à Olomouc en 1587. On le retrouve à Vienne, de 1589 à 1591, où il enseigne la théologie et les mathématiques.

En 1595, il rejoint Clavius à Rome, et en 1597, il enseigne à Graz, où il approche Johannes Kepler.

Ami de Marin Ghetaldi durant de longues années, il assista celui-ci dans ses expériences. En correspondance avec Galilée et Clavius, il succéda à celui-ci à la direction du Collège romain en 1612. Quelque sympathie qu''il eût pour les théories de Galilée, il fut obligé de défendre, sur ordre du Père général des jésuites, Claudio Acquaviva, les théories aristotéliciennes d''une Terre immobile.

Dans une lettre de 1634 adressée à Élie Diodati (en), il confesse à ce propos :

    « Si Galilée avait su se garder la bienveillance des pères du collège romain, il aurait pu vivre tranquille en ce monde, et rien de malheureux ne lui serait arrivé ; il aurait pu écrire à sa convenance, sur chaque sujet, et même sur le mouvement de la terre. »</ud>

<ud>
<eud>Travaux</eud>

On ne connaît souvent de lui qu''un catalogue d''étoiles nouvellement découvertes et des tables trigonométriques.

Par ailleurs, il apporta son aide aux autres mathématiciens de l''époque, comme Mario Bettinus et Giuseppe Biancani.

Le premier écrit, dans la préface de son ouvrage, Universae Philosophiae Mathematicae (1642)1 :

    « J''ai bénéficié, mon lecteur, de l''esprit et de l''industrie du très instruit et extrêmement modeste homme, Grienberger, qui, alors qu''il aurait découvert de nombreuses merveilles par lui-même, a préféré se mettre au service des inventions et pour la gloire d''autres personnes. »

Il se livra enfin à des travaux d''optique et on lui doit un montage astronomique des jumelles, utilisant le système équatorial, précédant le télescope, et nommé le montage allemand.

D''autre part, il prépara l''expédition de Johann Adam Schall von Bell et d''autres missionnaires jésuites en Chine.
</ud>


<ud ana="34">Source : https://fr.wikipedia.org/w/index.php?title=Christopher_Grienberger&amp;oldid=116722907</ud>
</ud>





<ud>
<eud>Giovanni Antonio Magini</eud>

<ud ana="9">Giovanni Antonio Magini (en latin, Maginus) (Padoue, 13 juin 1555 - Bologne, 11 février 1617) était un astronome, un astrologue, un cartographe, un mathématicien et un universitaire italien.
</ud>

<ud>
<eud>Biographie</eud>

Fils de Pasquale Magini, un citoyen de Padoue, sa ville natale, Giovanni Antonio Magini a suivi des études en philosophie à Bologne en 1579.

Se consacrant ensuite à l''astronomie, il a écrit en 1582 Ephemerides coelestium motuum, traduit l''année suivante en italien.

En 1588, il a été choisi devant Galilée pour occuper la chaire de mathématiques de l''université de Bologne après la mort de Egnatio Danti. Magini a soutenu une vision géocentrique du monde, a contrario du système héliocentrique émergent de Copernic. Magini a conçu sa propre théorie planétaire, la préférant aux autres existantes. Le système de Magini était composé de onze sphères tournantes, qu''il a décrit dans Novæ cœlestium orbium theoricæ congruentes cum observationibus N. Copernici (Venise, 1589).

Dans De Planis Triangulis (Venise, 1592), il s''est intéressé à l''utilisation des quadrants dans la topographie et à l''astronomie. En 1592, Magini a publié Tabula tetragonica et en 1606, il a conçu des tables trigonométriques extrêmement précises. Il a aussi travaillé sur la géométrie de la sphère et ses applications à la trigonométrie, pour lesquelles il a inventé des dispositifs calculateurs. Il a également travaillé sur le problème des miroirs et il a publié sur la théorie des miroirs sphériques concaves.

En 1593, Il fait partie des mathématiciens du monde entier pressenti par Adrien Romain pour résoudre son équation de degrés 45, et dont François Viète triomphera.

Il a aussi publié un commentaire sur Geographia de Ptolémée (Cologne, 1596).

En tant que cartographe, il a travaillé toute sa vie à la préparation de Italia ou Atlante geografico d''Italia (Atlas géographique de l''Italie), imprimé après sa mort par son fils en 1620. Il a été conçu pour inclure les cartes de toutes les régions de l''Italie avec la nomenclature exacte et des notes historiques.

Il s''est également intéressé à la métoposcopie et devint en 1599, l''astrologue officiel du duc de Mantoue.

Il correspondait avec Tycho Brahe, Clavius, Abraham Ortelius et Johannes Kepler. Sa correspondance a été éditée en 1886 par Antonio Favaro.

Il est mort à Bologne.
</ud>

<ud ana="34">https://fr.wikipedia.org/w/index.php?title=Giovanni_Antonio_Magini&amp;oldid=118941415</ud>
</ud>








<ud>
<eud>Nicolas-Claude Fabri de Peiresc</eud>

<ud ana="9"><in ana="11"><en ref="17"  ana="23">Nicolas-Claude Fabri de Peiresc</en> (également orthographié de Peyresc), né le <dat when="15801201" type="du">1er décembre 1580</dat> à <en type="li" ana="22">Belgentier</en></in> et mort le 24 juin 1637 à Aix-en-Provence, est un intellectuel de l''époque baroque, conseiller au Parlement de Provence, scientifique, homme de lettres, astronome et collectionneur.

Il est connu notamment pour avoir entrepris de dresser la première carte de la Lune fondée sur des observations télescopiques.
</ud>



<ud>
<eud>Biographie</eud>
Jeunesse et formation
Armes des Fabri de Rians1, famille dont est issu Fabri de Peiresc.

Claude Fabri naît à Belgentier, où ses parents, aixois, se sont réfugiés afin d’échapper à la peste qui sévit à Aix. Il prend en 1604 le nom de Peiresc, terroir des Alpes-de-Haute-Provence (aujourd''hui Peyresq) qui lui vient de son père et où il n''a jamais mis les pieds2.

Il fait des études de philosophie et ressent de l’intérêt pour l''astronomie, les mathématiques, les langues, etc.3.

Appartenant à une famille de robe, il apprend le droit et est attiré par l''archéologie, ce qui lui permet de poursuivre ses études en Italie. Il revient en France en 1602 afin de préparer son doctorat à l''université de Montpellier et en 1604 il soutient sa thèse, obtenant le grade de docteur en Droit.

Il fait de nombreux voyages (Paris, Londres, région des Flandres) avant d''être nommé conseiller au parlement de Provence2.</ud>


<ud>
<eud>Un éminent collectionneur d''art</eud>

Peiresc constitue dans sa demeure d''Aix-en-Provence, un cabinet, véritable musée où se côtoient sculptures antiques, peintures modernes, médailles, bibliothèque, et un jardin d''acclimatation.

Il fait représenter ces objets précieux, dont de nombreux vases antiques, sous forme de dessins réunis dans deux recueils; l''un d''eux, cédé avec sa collection par l''abbé de Marolles à Louis XIV, intègre en 1667 la bibliothèque royale et est inventorié en 1684 (mention de 158 pièces); l''autre, légué par Henri du Bouchet à l''abbaye de Saint-Victor et qui est utilisé en 1719 par dom Bernard de Montfaucon pour son Antiquité expliquée et représentée en figures, transite vers 1797 par l''hôtel de ville de Paris. En 1766 Joly, garde des Estampes du Roi, en dresse un inventaire détaillé. Réunis, les deux volumes sont reliés sous le Premier Empire (Bibliothèque Nationale de France).

Peiresc est un exemple de grand intellectuel, à la charnière de la Renaissance et de l''essor scientifique moderne, ce qui lui vaut le titre de « Prince de la république des Lettres ».
</ud>


<ud>
<eud>Un épistolier infatigable</eud>

S''il fut un politique remarqué dans sa région, Fabri de Peiresc est aussi un infatigable épistolier avec ses 10 000 lettres. Il est en correspondance régulière avec Malherbe, Hugo Grotius, les frères Dupuy, avec le frère du cardinal Richelieu, Jean Barclay, Rubens, Gassendi, dont il est le grand ami, mais aussi Galilée4 et Campanella pour lesquels il lutte afin de les défendre des attaques de l''Inquisition.

Sans qu’on sache comment il se l’est procuré, il offre l’ivoire Barberini, une exceptionnelle œuvre byzantine en ivoire, au cardinal Francesco Barberini, œuvre qui appartient au Louvre depuis 1899.

Sa correspondance avec Malherbe permet de mieux comprendre la personnalité du fils de celui-ci, tué en duel par Pierre-Paul de Fortia de Piles avec l’aide de Gaspard de Covet de Marignane le 13 juillet 1627. Ce drame ravage Malherbe de douleur, qui en meurt l''année suivante.


Le chercheur

Début juillet 1608, les faubourgs d''Aix-en-Provence sont recouverts d''une pluie de « sang ». Quelques moines désireux d''exploiter la crédulité humaine n''hésitent pas à voir dans cet évènement des influences sataniques. Peiresc fait des relevés de cette pluie en recueillant quelques gouttes sur la muraille du cimetière de la cathédrale. Il découvre que ce liquide est laissé par les chrysalides des vanesses lorsqu''elles se muent en papillons (papillons qui avaient été observés)3. Le centre ville n''ayant pas été envahi, il est resté épargné. Cette explication scientifique ne calme pas la terreur populaire5.


Peiresc et l''astronomie

Son talent ne s''arrête pas là. Peiresc est aussi astronome et, à la suite de son ami Galilée, il observe les satellites de Jupiter dont il laisse des croquis montrant qu''il a très bien compris qu''il s''agit de satellites de cette planète. Il veut utiliser les disparitions de ces satellites pour améliorer la connaissance des longitudes et commence à dresser des tables très précises. Apprenant que Galilée a le même projet, il l''abandonne par déférence envers celui qu''il admire6.
Reproduction partielle d''un manuscrit de Peiresc conservé à la Bibliothèque Inguimbertine et montrant la première annonce de la découverte de la nébuleuse d''Orion faite par Peiresc le 26 novembre 1610.

Entre la fin novembre et le début décembre 1610, il découvre la nébuleuse d''Orion qu''il décrit dans ses manuscrits par ces mots :

    « In Orione media... ex duabus stellis composita nubecula quamdam illuminata prima fronte referabat coelo non oie sereno » (observation du 26 novembre 1610).

Il s''aperçoit que la méthode des satellites de Jupiter pour améliorer la connaissance des longitudes n''est pas commode à utiliser, notamment pour les marins. Il tente alors une méthode bien connue des astronomes qui consiste à observer un même phénomène depuis deux lieux distants (par exemple une éclipse de Lune). Pour cela, il coordonne l''observation de l''éclipse de Lune du 28 août 1635 en répartissant des observateurs tout le long de la Méditerranée ; ceci lui permet de constater que cette mer est en réalité plus courte de près de 1 000 km que ce que l''on croyait jusqu''alors6.

Avec l''appui de Gassendi qui l''avait baptisé "le prince des curieux", Peiresc demande au graveur Claude Mellan de dresser la première carte de la Lune fondée sur des observations télescopiques réalisées depuis l''observatoire personnel qu''il a mis en place sur le toit de sa demeure, mais sa mort, alors qu''il est le commanditaire et le financier du projet, va l''empêcher de mener à bien cette tâche.


Un savant éclectique

Peiresc est encore numismate7 (avec son médaillier de plus de 18 000 pièces), archéologue, amateur d''art, historien (il montre que Jules César, lors de sa conquête de l’Angleterre, n’est pas parti de Calais, mais de Saint-Omer), égyptologue, botaniste, zoologue (études sur les caméléons, les crocodiles, l''éléphant et l''alzaron, sorte de gazelle à tête de taureau venant de Nubie et aujourd''hui disparue), physiologiste, géographe (projet de construction d''un canal de Provence reliant Aix à Marseille), et écologiste.

Il s''intéresse également à la géologie et à la paléontologie8

Cet humaniste s''éteint à l''âge de 57 ans.
</ud>
<ud ana="34">https://fr.wikipedia.org/w/index.php?title=Nicolas-Claude_Fabri_de_Peiresc&amp;oldid=118560581</ud>
</ud>







<ud>
<eud>Philippe van Lansberge</eud>

<ud ana="9">Philippe van Lansberge, Lansberg ou Landsbergius est un mathématicien et astronome belge, né à Gand le 25 août 1561, mort après 1632 ; il est seigneur de Maulabeecke</ud>


<ud>
<eud>Biographie</eud>

Fils de Daniel van Lansberge, seigneur de Meulebeke, et de Paulinevan den Honigh. Ses parents l''élevèrent dans la religion protestante à laquelle il resta toujours attaché. Il étudia en Angleterre, revint à Gand, puis quitta derechef sa ville natale pour se fixer à Anvers vers 1580. Lorsqu''en 1585, la métropole commerciale retomba sous l''autorité de Philippe II d''Espagne, il abandonna la Belgique pour s''installer aux Pays-Bas, à Leyden, où il professa comme pasteur puis à Goes puis à Middelbourg, où il exerça la médecine et put surtout se livrer à ses études favorites, les mathématiques et l''astronomie. Il fut l''élève de Simon Stevin à Leyde, et se lia avec Willebrord Snell, qui partageait avec lui la même passion. Il mourut à Middelbourg le 8 novembre 1635 ou le 8 décembre 1632 selon différentes sources (dont Isaac Beeckman), laissant après lui dix enfants. Tallement des Reaux note dans ses historiettes qu''il fut un des rares européens à comprendre l''algèbre de François Viète ; Kepler se sert de ses calculs.

Lansberge fut partisan des hypothèses de Copernic et de Kepler (dont il n''acceptait pas la forme elliptique des orbites planétaires), ce qui lui valut de multiples désagréments de la part des pasteurs protestants.
</ud>


<ud ana="34">https://fr.wikipedia.org/w/index.php?title=Philippe_van_Lansberge&amp;oldid=116732291</ud>
</ud>
</root>', 8, NULL, '
{ud0}
{eud}Michael Maestlin{/eud}

{ud0_9}
{in0_11}{en1619_23}Michael Maestlin{/en} (aussi appelé Mästlin, Möstlin, ou Moestlin), né le {dat15500930_du}30 septembre 1550{/dat} à {en0li_22}Göppingen en Bade-Wurtemberg{/en}{/in}, mort le 20 octobre 1631 à Tübingen, est un astronome et mathématicien allemand, connu pour être le mentor de Johannes Kepler.
{/ud}



{ud0}
{eud}Carrière{/eud}

Maestlin a étudié la théologie, les mathématiques et l''astronomie au Tübinger Stift à Tübingen, une ville du Wurtemberg. Il a obtenu la maîtrise en 1571 et est devenu en 1576 un diacre luthérien à Backnang, tout en continuant ses études dans cette ville.

{in0_1621}{dat1580_dd}En 1580{/dat}, {en1619_1624}il{/en} est devenu {en0}{en1625_1623}professeur{/en} de {en15_1622}mathématiques{/en}{/en} à l''{en0_10}université de {en0li}Heidelberg{/en}{/en}[jusqu''en {dat1583_df}1583{/dat}]{/in}. Il a écrit une introduction populaire à l''astronomie, en 1582. {in0_1621}{en1619_1624}Il{/en} a enseigné ensuite à l''{en0_10}université de {en0li}Tübingen{/en}{/en} à partir de {dat1583_dd}1583{/dat}, à l''âge de 47 ans{/in}.

Il comptait parmi ses étudiants Johannes Kepler (1571-1630)1. Bien qu''il enseignât au départ la représentation géocentrique traditionnelle du Système solaire selon Ptolémée, Maestlin était aussi l''un des premiers à accepter et à enseigner la représentation héliocentrique de Copernic. Maestlin correspondait fréquemment avec Kepler et joua un rôle significatif dans son adoption du système copernicien. On attribue aussi l''adoption de l''héliocentrisme par Galilée à Maestlin2.

Le premier calcul connu de l''inverse du nombre d''or où il donne la valeur « environ 0.6180340 » a été écrit en 1597 par Maestlin dans une lettre à Kepler.
{/ud}
{ud0_34}https://fr.wikipedia.org/w/index.php?title=Michael_Maestlin&oldid=115018735{/ud}
{/ud}



{ud0}
{eud}Christopher Grienberger{/eud}

{ud0_9}{in0_11}{en1620_23}Christopher Grienberger{/en} (aussi écrit Christopher Gruemberger, ou encore Grinberg, Bamberger, ou Gamberger, voire Panberger), né le {dat15510702_du}2 juillet 1551{/dat} à {en0li_22}Hall dans le Tyrol{/en}{/in}, et mort le 11 mars 1636 à Rome, est prêtre jésuite autrichien, mathématicien et professeur au Collège romain. Un cratère lunaire est nommé en son honneur Gruemberger.{/ud}

{ud0}
{eud}Biographie{/eud}
Grienberger entre dans la Compagnie de Jésus le 20 août 1580. Après des études de rhétorique à Prague (1583–1584), il devient professeur de mathématiques à Olomouc en 1587. On le retrouve à Vienne, de 1589 à 1591, où il enseigne la théologie et les mathématiques.

En 1595, il rejoint Clavius à Rome, et en 1597, il enseigne à Graz, où il approche Johannes Kepler.

Ami de Marin Ghetaldi durant de longues années, il assista celui-ci dans ses expériences. En correspondance avec Galilée et Clavius, il succéda à celui-ci à la direction du Collège romain en 1612. Quelque sympathie qu''il eût pour les théories de Galilée, il fut obligé de défendre, sur ordre du Père général des jésuites, Claudio Acquaviva, les théories aristotéliciennes d''une Terre immobile.

Dans une lettre de 1634 adressée à Élie Diodati (en), il confesse à ce propos :

    « Si Galilée avait su se garder la bienveillance des pères du collège romain, il aurait pu vivre tranquille en ce monde, et rien de malheureux ne lui serait arrivé ; il aurait pu écrire à sa convenance, sur chaque sujet, et même sur le mouvement de la terre. »{/ud}

{ud0}
{eud}Travaux{/eud}

On ne connaît souvent de lui qu''un catalogue d''étoiles nouvellement découvertes et des tables trigonométriques.

Par ailleurs, il apporta son aide aux autres mathématiciens de l''époque, comme Mario Bettinus et Giuseppe Biancani.

Le premier écrit, dans la préface de son ouvrage, Universae Philosophiae Mathematicae (1642)1 :

    « J''ai bénéficié, mon lecteur, de l''esprit et de l''industrie du très instruit et extrêmement modeste homme, Grienberger, qui, alors qu''il aurait découvert de nombreuses merveilles par lui-même, a préféré se mettre au service des inventions et pour la gloire d''autres personnes. »

Il se livra enfin à des travaux d''optique et on lui doit un montage astronomique des jumelles, utilisant le système équatorial, précédant le télescope, et nommé le montage allemand.

D''autre part, il prépara l''expédition de Johann Adam Schall von Bell et d''autres missionnaires jésuites en Chine.
{/ud}


{ud0_34}Source : https://fr.wikipedia.org/w/index.php?title=Christopher_Grienberger&oldid=116722907{/ud}
{/ud}





{ud0}
{eud}Giovanni Antonio Magini{/eud}

{ud0_9}Giovanni Antonio Magini (en latin, Maginus) (Padoue, 13 juin 1555 - Bologne, 11 février 1617) était un astronome, un astrologue, un cartographe, un mathématicien et un universitaire italien.
{/ud}

{ud0}
{eud}Biographie{/eud}

Fils de Pasquale Magini, un citoyen de Padoue, sa ville natale, Giovanni Antonio Magini a suivi des études en philosophie à Bologne en 1579.

Se consacrant ensuite à l''astronomie, il a écrit en 1582 Ephemerides coelestium motuum, traduit l''année suivante en italien.

En 1588, il a été choisi devant Galilée pour occuper la chaire de mathématiques de l''université de Bologne après la mort de Egnatio Danti. Magini a soutenu une vision géocentrique du monde, a contrario du système héliocentrique émergent de Copernic. Magini a conçu sa propre théorie planétaire, la préférant aux autres existantes. Le système de Magini était composé de onze sphères tournantes, qu''il a décrit dans Novæ cœlestium orbium theoricæ congruentes cum observationibus N. Copernici (Venise, 1589).

Dans De Planis Triangulis (Venise, 1592), il s''est intéressé à l''utilisation des quadrants dans la topographie et à l''astronomie. En 1592, Magini a publié Tabula tetragonica et en 1606, il a conçu des tables trigonométriques extrêmement précises. Il a aussi travaillé sur la géométrie de la sphère et ses applications à la trigonométrie, pour lesquelles il a inventé des dispositifs calculateurs. Il a également travaillé sur le problème des miroirs et il a publié sur la théorie des miroirs sphériques concaves.

En 1593, Il fait partie des mathématiciens du monde entier pressenti par Adrien Romain pour résoudre son équation de degrés 45, et dont François Viète triomphera.

Il a aussi publié un commentaire sur Geographia de Ptolémée (Cologne, 1596).

En tant que cartographe, il a travaillé toute sa vie à la préparation de Italia ou Atlante geografico d''Italia (Atlas géographique de l''Italie), imprimé après sa mort par son fils en 1620. Il a été conçu pour inclure les cartes de toutes les régions de l''Italie avec la nomenclature exacte et des notes historiques.

Il s''est également intéressé à la métoposcopie et devint en 1599, l''astrologue officiel du duc de Mantoue.

Il correspondait avec Tycho Brahe, Clavius, Abraham Ortelius et Johannes Kepler. Sa correspondance a été éditée en 1886 par Antonio Favaro.

Il est mort à Bologne.
{/ud}

{ud0_34}https://fr.wikipedia.org/w/index.php?title=Giovanni_Antonio_Magini&oldid=118941415{/ud}
{/ud}








{ud0}
{eud}Nicolas-Claude Fabri de Peiresc{/eud}

{ud0_9}{in0_11}{en17_23}Nicolas-Claude Fabri de Peiresc{/en} (également orthographié de Peyresc), né le {dat15801201_du}1er décembre 1580{/dat} à {en0li_22}Belgentier{/en}{/in} et mort le 24 juin 1637 à Aix-en-Provence, est un intellectuel de l''époque baroque, conseiller au Parlement de Provence, scientifique, homme de lettres, astronome et collectionneur.

Il est connu notamment pour avoir entrepris de dresser la première carte de la Lune fondée sur des observations télescopiques.
{/ud}



{ud0}
{eud}Biographie{/eud}
Jeunesse et formation
Armes des Fabri de Rians1, famille dont est issu Fabri de Peiresc.

Claude Fabri naît à Belgentier, où ses parents, aixois, se sont réfugiés afin d’échapper à la peste qui sévit à Aix. Il prend en 1604 le nom de Peiresc, terroir des Alpes-de-Haute-Provence (aujourd''hui Peyresq) qui lui vient de son père et où il n''a jamais mis les pieds2.

Il fait des études de philosophie et ressent de l’intérêt pour l''astronomie, les mathématiques, les langues, etc.3.

Appartenant à une famille de robe, il apprend le droit et est attiré par l''archéologie, ce qui lui permet de poursuivre ses études en Italie. Il revient en France en 1602 afin de préparer son doctorat à l''université de Montpellier et en 1604 il soutient sa thèse, obtenant le grade de docteur en Droit.

Il fait de nombreux voyages (Paris, Londres, région des Flandres) avant d''être nommé conseiller au parlement de Provence2.{/ud}


{ud}
{eud}Un éminent collectionneur d''art{/eud}

Peiresc constitue dans sa demeure d''Aix-en-Provence, un cabinet, véritable musée où se côtoient sculptures antiques, peintures modernes, médailles, bibliothèque, et un jardin d''acclimatation.

Il fait représenter ces objets précieux, dont de nombreux vases antiques, sous forme de dessins réunis dans deux recueils; l''un d''eux, cédé avec sa collection par l''abbé de Marolles à Louis XIV, intègre en 1667 la bibliothèque royale et est inventorié en 1684 (mention de 158 pièces); l''autre, légué par Henri du Bouchet à l''abbaye de Saint-Victor et qui est utilisé en 1719 par dom Bernard de Montfaucon pour son Antiquité expliquée et représentée en figures, transite vers 1797 par l''hôtel de ville de Paris. En 1766 Joly, garde des Estampes du Roi, en dresse un inventaire détaillé. Réunis, les deux volumes sont reliés sous le Premier Empire (Bibliothèque Nationale de France).

Peiresc est un exemple de grand intellectuel, à la charnière de la Renaissance et de l''essor scientifique moderne, ce qui lui vaut le titre de « Prince de la république des Lettres ».
{/ud}


{ud}
{eud}Un épistolier infatigable{/eud}

S''il fut un politique remarqué dans sa région, Fabri de Peiresc est aussi un infatigable épistolier avec ses 10 000 lettres. Il est en correspondance régulière avec Malherbe, Hugo Grotius, les frères Dupuy, avec le frère du cardinal Richelieu, Jean Barclay, Rubens, Gassendi, dont il est le grand ami, mais aussi Galilée4 et Campanella pour lesquels il lutte afin de les défendre des attaques de l''Inquisition.

Sans qu’on sache comment il se l’est procuré, il offre l’ivoire Barberini, une exceptionnelle œuvre byzantine en ivoire, au cardinal Francesco Barberini, œuvre qui appartient au Louvre depuis 1899.

Sa correspondance avec Malherbe permet de mieux comprendre la personnalité du fils de celui-ci, tué en duel par Pierre-Paul de Fortia de Piles avec l’aide de Gaspard de Covet de Marignane le 13 juillet 1627. Ce drame ravage Malherbe de douleur, qui en meurt l''année suivante.


Le chercheur

Début juillet 1608, les faubourgs d''Aix-en-Provence sont recouverts d''une pluie de « sang ». Quelques moines désireux d''exploiter la crédulité humaine n''hésitent pas à voir dans cet évènement des influences sataniques. Peiresc fait des relevés de cette pluie en recueillant quelques gouttes sur la muraille du cimetière de la cathédrale. Il découvre que ce liquide est laissé par les chrysalides des vanesses lorsqu''elles se muent en papillons (papillons qui avaient été observés)3. Le centre ville n''ayant pas été envahi, il est resté épargné. Cette explication scientifique ne calme pas la terreur populaire5.


Peiresc et l''astronomie

Son talent ne s''arrête pas là. Peiresc est aussi astronome et, à la suite de son ami Galilée, il observe les satellites de Jupiter dont il laisse des croquis montrant qu''il a très bien compris qu''il s''agit de satellites de cette planète. Il veut utiliser les disparitions de ces satellites pour améliorer la connaissance des longitudes et commence à dresser des tables très précises. Apprenant que Galilée a le même projet, il l''abandonne par déférence envers celui qu''il admire6.
Reproduction partielle d''un manuscrit de Peiresc conservé à la Bibliothèque Inguimbertine et montrant la première annonce de la découverte de la nébuleuse d''Orion faite par Peiresc le 26 novembre 1610.

Entre la fin novembre et le début décembre 1610, il découvre la nébuleuse d''Orion qu''il décrit dans ses manuscrits par ces mots :

    « In Orione media... ex duabus stellis composita nubecula quamdam illuminata prima fronte referabat coelo non oie sereno » (observation du 26 novembre 1610).

Il s''aperçoit que la méthode des satellites de Jupiter pour améliorer la connaissance des longitudes n''est pas commode à utiliser, notamment pour les marins. Il tente alors une méthode bien connue des astronomes qui consiste à observer un même phénomène depuis deux lieux distants (par exemple une éclipse de Lune). Pour cela, il coordonne l''observation de l''éclipse de Lune du 28 août 1635 en répartissant des observateurs tout le long de la Méditerranée ; ceci lui permet de constater que cette mer est en réalité plus courte de près de 1 000 km que ce que l''on croyait jusqu''alors6.

Avec l''appui de Gassendi qui l''avait baptisé "le prince des curieux", Peiresc demande au graveur Claude Mellan de dresser la première carte de la Lune fondée sur des observations télescopiques réalisées depuis l''observatoire personnel qu''il a mis en place sur le toit de sa demeure, mais sa mort, alors qu''il est le commanditaire et le financier du projet, va l''empêcher de mener à bien cette tâche.


Un savant éclectique

Peiresc est encore numismate7 (avec son médaillier de plus de 18 000 pièces), archéologue, amateur d''art, historien (il montre que Jules César, lors de sa conquête de l’Angleterre, n’est pas parti de Calais, mais de Saint-Omer), égyptologue, botaniste, zoologue (études sur les caméléons, les crocodiles, l''éléphant et l''alzaron, sorte de gazelle à tête de taureau venant de Nubie et aujourd''hui disparue), physiologiste, géographe (projet de construction d''un canal de Provence reliant Aix à Marseille), et écologiste.

Il s''intéresse également à la géologie et à la paléontologie8

Cet humaniste s''éteint à l''âge de 57 ans.
{/ud}
{ud0_34}https://fr.wikipedia.org/w/index.php?title=Nicolas-Claude_Fabri_de_Peiresc&oldid=118560581{/ud}
{/ud}







{ud0}
{eud}Philippe van Lansberge{/eud}

{ud0_9}Philippe van Lansberge, Lansberg ou Landsbergius est un mathématicien et astronome belge, né à Gand le 25 août 1561, mort après 1632 ; il est seigneur de Maulabeecke{/ud}


{ud0}
{eud}Biographie{/eud}

Fils de Daniel van Lansberge, seigneur de Meulebeke, et de Paulinevan den Honigh. Ses parents l''élevèrent dans la religion protestante à laquelle il resta toujours attaché. Il étudia en Angleterre, revint à Gand, puis quitta derechef sa ville natale pour se fixer à Anvers vers 1580. Lorsqu''en 1585, la métropole commerciale retomba sous l''autorité de Philippe II d''Espagne, il abandonna la Belgique pour s''installer aux Pays-Bas, à Leyden, où il professa comme pasteur puis à Goes puis à Middelbourg, où il exerça la médecine et put surtout se livrer à ses études favorites, les mathématiques et l''astronomie. Il fut l''élève de Simon Stevin à Leyde, et se lia avec Willebrord Snell, qui partageait avec lui la même passion. Il mourut à Middelbourg le 8 novembre 1635 ou le 8 décembre 1632 selon différentes sources (dont Isaac Beeckman), laissant après lui dix enfants. Tallement des Reaux note dans ses historiettes qu''il fut un des rares européens à comprendre l''algèbre de François Viète ; Kepler se sert de ses calculs.

Lansberge fut partisan des hypothèses de Copernic et de Kepler (dont il n''acceptait pas la forme elliptique des orbites planétaires), ce qui lui valut de multiples désagréments de la part des pasteurs protestants.
{/ud}


{ud0_34}https://fr.wikipedia.org/w/index.php?title=Philippe_van_Lansberge&oldid=116732291{/ud}
{/ud}


', NULL);
INSERT INTO objet (pk_objet, definition, notes, date_creation, date_modification, cle_importation, cle_importation_txt, longitude, latitude, texte_xml, fk_type_objet_param, genre, texte, langue_texte) VALUES (36, 'Notices BNF (cf. objet ) avec encodage sémantique', NULL, '2015-11-05 22:03:44.180655+01', '2015-11-25 08:58:17.325144+01', NULL, NULL, NULL, NULL, '<root><ud>
Hermann de Carinthie (<en type="li">île de Korčula (Croatie)</en>, <dat when="1105">1105</dat>) <en ref="18" >Philosophe</en>, écrivain, <en ref="16" >mathématicien</en>, <en ref="25" >astrologue</en> et traducteur croate [http://data.bnf.fr/ark:/12148/cb16243624j#foaf:Person]
</ud>
<ud>
Hermann le Dalmate (<en type="li">Saint Peter en Istrie une partie du duché de Carinthie (au sud de l''Autriche)</en>, <dat when="1110">1110</dat>) <en ref="18" >Philosophe</en>, <en ref="24" >astronome</en>, <en ref="25" >astrologue</en>, <en ref="16" >mathématicien</en> et traducteur d''ouvrages scientifiques et de la littérature. - Il vint très jeune en 1135 en France à Paris et à Chartres. - Eut pour maître Thierry de Chartres. - L''abbé de Cluny, Pierre le Vénérable, poussa Herman à traduire à écrire sur la vie et l''oeuvre de Mahomet [http://data.bnf.fr/ark:/12148/cb12364029w#foaf:Person]
</ud>
<ud>
Bhāskarācārya (<en type="li">Dekkan, Inde</en>, <dat when="1114">1114</dat>) <en ref="16" >Mathématicien</en>. - <en ref="24" >Astronome</en>. - Fils de Maheśvara. - Auteur de :  "Siddhāntaśiromanī" (en 1150) ; "Karṇakutūhala" [http://data.bnf.fr/ark:/12148/cb14498624v#foaf:Person]
</ud>
<ud>
al-Muẓaffar ibn Muḥammad Šaraf al-Dīn Ṭūsī (<dat when="1151">1151</dat>) <en ref="16" >Mathématicien</en>. - Originaire de Ṭūs, Hamad̲ān, Mosul, Alep, Damas. - Écrivait vers 1209 [http://data.bnf.fr/ark:/12148/cb120864072#foaf:Person]
</ud>
<ud>
Johannes de Sacro Bosco (<dat when="1151">1151</dat>) <en ref="16" >Mathématicien</en>. - Chanoine prémontré de Holywood (comté de Dumfries, Écosse). - <in ana="1621">Professeur à l''Université de Paris</in>. - Semble être né à Halifax (Yorkshire, Angleterre). - Mort en 1256 ou 1244 [http://data.bnf.fr/ark:/12148/cb121284153#foaf:Person]
</ud>
<ud>
Robertus Castrensis (<dat when="1151">1151</dat>) Traducteur de traités scientifiques et de mathématiques. - Sa période d''activité se situe aux alentours de 1145 [http://data.bnf.fr/ark:/12148/cb12223624k#foaf:Person]
</ud>
<ud>
Alexandre de Villedieu (<en type="li">Villedieu (Manche)</en>, <dat when="1170">1170</dat>) Franciscain. - Grammairien, <en ref="16" >mathématicien</en> et poète. - Chanoine de la cathédrale Saint-André d''Avranches [http://data.bnf.fr/ark:/12148/cb12536245w#foaf:Person]
</ud>
<ud>
Leonardo Fibonacci (<dat when="1170">1170</dat>) <en ref="16" >Mathématicien</en>. - Surnommé Leonardo Pisano [http://data.bnf.fr/ark:/12148/cb13092437c#foaf:Person]
</ud>
<ud>
Moḥamad ben Moḥamad Naṣīr al-Dīn Ṭōsī (<en type="li">Tus (Iran)</en>, <dat when="1201">1201</dat>) <en ref="16" >Mathématicien</en> et <en ref="24" >astronome</en> [http://data.bnf.fr/ark:/12148/cb12399386c#foaf:Person]
</ud>
<ud>
Jean Pecham (<dat when="1220">1220</dat>) Provincial des franciscains d''Angleterre. - Archevêque de Cantorbéry (à partir de 1279). - <en ref="1629" >Théologien</en>, <en ref="16" >mathématicien</en> et <en ref="1630" >physicien</en> [http://data.bnf.fr/ark:/12148/cb12459837w#foaf:Person]
</ud>
<ud>
Witelo (<dat when="1220">1220</dat>) <en ref="18" >Philosophe</en> et <en ref="16" >mathématicien</en> [http://data.bnf.fr/ark:/12148/cb12054316n#foaf:Person]
</ud>
<ud>
Maḥmūd ibn Mas´ūd Quṭb al-Dīn al- Šīrāzī (<en type="li">Shīrāz</en>, <dat when="1236">1236</dat>) <en ref="24" >Astronome</en>, <en ref="28" >médecin</en>, <en ref="18" >philosophe</en> et <en ref="1629" >théologien</en> [http://data.bnf.fr/ark:/12148/cb12086388m#foaf:Person]
</ud>
<ud>
Jacob ben Machir (<en type="li">Marseille</en>, <dat when="1238">1238</dat>) <en ref="24" >Astronome</en>. - <en ref="28" >Médecin</en>. - Chancellier de la faculté de <en ref="28" >médecin</en>e de Montpellier [http://data.bnf.fr/ark:/12148/cb165406517#foaf:Person]
</ud>
<ud>
Grégoire Chioniadès (<dat when="1240">1240</dat>) <en ref="24" >Astronome</en>, <en ref="1630" >physicien</en> et <en ref="28" >médecin</en> byzantin. - Évêque de Tabriz, Iran [http://data.bnf.fr/ark:/12148/cb12007088c#foaf:Person]
</ud>
<ud>
Henri Baten (<dat when="1246">1246</dat>) <en ref="18" >Philosophe</en> et <en ref="1629" >théologien</en>. - <en ref="24" >Astronome</en>. - Poète et musicien [http://data.bnf.fr/ark:/12148/cb12220635h#foaf:Person]
</ud>
<ud>
al-Mufaḍḍal ibn ʿUmar Aṯīr al-Dīn al-Abharī (<dat when="1251">1251</dat>) <en ref="18" >Philosophe</en>, logicien, <en ref="24" >astronome</en> [http://data.bnf.fr/ark:/12148/cb15935708x#foaf:Person]
</ud>
<ud>
Bartolomeo da Parma (<dat when="1251">1251</dat>) <en ref="25" >Astrologue</en>, géomancien et <en ref="24" >astronome</en>. <in ana="1621">Fut professeur à l''Université de Bologne (1288-1297)</in> [http://data.bnf.fr/ark:/12148/cb144790439#foaf:Person]
</ud>
<ud>
Campanus de Novare (<dat when="1251">1251</dat>) <en ref="24" >Astronome</en>. - <en ref="16" >Mathématicien</en>, commentateur d''Euclide [http://data.bnf.fr/ark:/12148/cb124917005#foaf:Person]
</ud>
<ud>
David ben Yom-Tov Poel (<dat when="1251">1251</dat>) <en ref="18" >Philosophe</en>. - <en ref="28" >Médecin</en>. - Père de l''<en ref="24" >astronome</en> Jacob Poel [http://data.bnf.fr/ark:/12148/cb16540698w#foaf:Person]
</ud>
<ud>
Démétrius Triclinius (<en type="li">Thessalonique</en>, <dat when="1251">1251</dat>) Philologue. - <en ref="16" >Mathématicien</en> et <en ref="25" >astrologue</en> [http://data.bnf.fr/ark:/12148/cb12311753x#foaf:Person]
</ud>
<ud>
Geršon ben Salomon d''Arles (<en type="li">Béziers</en>, <dat when="1251">1251</dat>) Éxégète. - <en ref="24" >Astronome</en> [http://data.bnf.fr/ark:/12148/cb134867338#foaf:Person]
</ud>
<ud>
Hui Yang (<dat when="1251">1251</dat>) <en ref="16" >Mathématicien</en> chinois. En activité entre 1261 et 1275 [http://data.bnf.fr/ark:/12148/cb13746624q#foaf:Person]
</ud>
<ud>
Isaac ben Joseph Israeli (<dat when="1251">1251</dat>) <en ref="24" >Astronome</en>. - Elève d''Asher ben Jehiel [http://data.bnf.fr/ark:/12148/cb16540863s#foaf:Person]
</ud>
<ud>
Jacopo da Firenze (<dat when="1251">1251</dat>) <en ref="16" >Mathématicien</en>. - Actif en 1307 [http://data.bnf.fr/ark:/12148/cb157815579#foaf:Person]
</ud>
<ud>
Jordanus Nemorarius (<dat when="1251">1251</dat>) <en ref="16" >Mathématicien</en>. - Probablement d''origine italienne [http://data.bnf.fr/ark:/12148/cb11986727x#foaf:Person]
</ud>
<ud>
Petrus Philomena de Dacia (<dat when="1251">1251</dat>) <en ref="16" >Mathématicien</en>, <en ref="24" >astronome</en>, <en ref="18" >philosophe</en>. - Attesté entre 1290 et 1300. - Élève à l''Université de Bologne (1291-1292) puis de Paris. - Chanoine de Roskilde, Danemark. - A distinguer de Petrus de Dacia, recteur de l''Université de Paris en 1327 [http://data.bnf.fr/ark:/12148/cb11887258w#foaf:Person]
</ud>
<ud>
ʿAbd al-Ġaffār ibn ʿAbd al-Karīm Naǧm al-Dīn al- Qazwīnī (<dat when="1251">1251</dat>) <en ref="16" >Mathématicien</en> et jurisconsulte chaféite [http://data.bnf.fr/ark:/12148/cb155674927#foaf:Person]
</ud>
<ud>
Andalò Di Negro (<en type="li">Gênes (?), Italie</en>, <dat when="1260">1260</dat>) <en ref="24" >Astronome</en>. - Précepteur de Boccace. - Ambassadeur de la République de Gênes auprès de l''empereur Alexis Comnène (en 1314) [http://data.bnf.fr/ark:/12148/cb121998732#foaf:Person]
</ud>
<ud>
Théodore Métochite (<en type="li">Constantinople</en>, <dat when="1260">1260</dat>) Homme d''état, <en ref="18" >philosophe</en>, poète, <en ref="24" >astronome</en> et rhéteur [http://data.bnf.fr/ark:/12148/cb12000562c#foaf:Person]
</ud>
<ud>
Gersonide (Bagnols-sur-Cèze (<en type="li">Gard)</en>, <dat when="1288">1288</dat>) Exégète biblique, <en ref="16" >mathématicien</en>, <en ref="24" >astronome</en>, <en ref="18" >philosophe</en>, <en ref="1630" >physicien</en> [http://data.bnf.fr/ark:/12148/cb12131941j#foaf:Person]
</ud>
<ud>
Barlaam de Seminara (<dat when="1290">1290</dat>) Moine basilien, abbé du Saint-Esprit à Constantinople (<dat when="1331">1331</dat>), évêque de Gérace (1342-1348). - <en ref="1629" >Théologien</en>, <en ref="18" >philosophe</en>, <en ref="16" >mathématicien</en>, <en ref="24" >astronome</en> et helléniste [http://data.bnf.fr/ark:/12148/cb13549924x#foaf:Person]
</ud>
<ud>
Jacopo Dondi (<dat when="1290">1290</dat>) <en ref="18" >Philosophe</en>, <en ref="24" >astronome</en>, <en ref="28" >médecin</en> italien célèbre pour la construction d''une pendule astrale à Padoue. - Père de Giovanni Dondi [http://data.bnf.fr/ark:/12148/cb124119184#foaf:Person]
</ud>
<ud>
Thomas Bradwardine (<dat when="1290">1290</dat>) <en ref="16" >Mathématicien</en>, <en ref="18" >philosophe</en> et <en ref="1629" >théologien</en>. - Surnommé le "Doctor Profundus". - Archevêque de Canterbury en 1349 [http://data.bnf.fr/ark:/12148/cb12269047v#foaf:Person]
</ud>
<ud>
Richard of Wallingford (<dat when="1292">1292</dat>) <en ref="16" >Mathématicien</en>. - <en ref="24" >Astronome</en>. - Abbé du monastère bénédictin de St Albans [http://data.bnf.fr/ark:/12148/cb12128305h#foaf:Person]
</ud>
<ud>
Jean de Murs (<dat when="1300">1300</dat>) <en ref="24" >Astronome</en>, <en ref="16" >mathématicien</en> et théoricien de la musique. - Maître-ès-arts de l''Université de Paris (<dat when="1321">1321</dat>) [http://data.bnf.fr/ark:/12148/cb121715011#foaf:Person]
</ud>
<ud>
Giovanni Dondi dall''Orologio (<en type="li">Chiogga, Italie</en>, <dat when="1318">1318</dat>) <en ref="28" >Médecin</en> et poète. - <en ref="24" >Astronome</en> et horloger, a terminé l''horloge astronomique, installée par son père : Dondi, Jacopo (1298-1359), à Padoue ou Pavie, Italie [http://data.bnf.fr/ark:/12148/cb122241024#foaf:Person]
</ud>
<ud>
Giacomo Allegretti (<dat when="1325">1325</dat>) <en ref="28" >Médecin</en> , poète et <en ref="24" >astronome</en> [http://data.bnf.fr/ark:/12148/cb14405998n#foaf:Person]
</ud>
<ud>
Blasius de Parma (<dat when="1347">1347</dat>) <en ref="18" >Philosophe</en>, <en ref="16" >mathématicien</en>, <en ref="28" >médecin</en>. - Recteur de l''université de Parme (en 1412) [http://data.bnf.fr/ark:/12148/cb12182615f#foaf:Person]
</ud>
<ud>
Abū ʿAbd Allâh Muḥammad al- Baqqār (<dat when="1351">1351</dat>) <en ref="16" >Mathématicien</en> et <en ref="24" >astronome</en> [http://data.bnf.fr/ark:/12148/cb155102056#foaf:Person]
</ud>
<ud>
Emmanuel ben Jacob de Tarascon Bonfils (<dat when="1351">1351</dat>) <en ref="24" >Astronome</en>, <en ref="28" >médecin</en> et <en ref="16" >mathématicien</en> ayant vécu à Orange puis à Tarascon. Il est l''auteur de nombreux traités d''astronomie [http://data.bnf.fr/ark:/12148/cb15620448d#foaf:Person]
</ud>
<ud>
Ǧamšīd ibn Masʿūd Ġiyāṯ al-Dīn al- Kāšī (<dat when="1351">1351</dat>) <en ref="28" >Médecin</en>, <en ref="16" >mathématicien</en> et <en ref="24" >astronome</en> [http://data.bnf.fr/ark:/12148/cb11351746b#foaf:Person]
</ud>
<ud>
Johannes Danck (<dat when="1351">1351</dat>) <en ref="24" >Astronome</en>. - A enseigné à l''Université de Paris de 1327 à 1355 [http://data.bnf.fr/ark:/12148/cb12531239r#foaf:Person]
</ud>
<ud>
Naǧm al-Dīn al- Miṣrī (<dat when="1351">1351</dat>) Auteur supposé de traités portant sur les instruments astronomiques [http://data.bnf.fr/ark:/12148/cb14566743g#foaf:Person]
</ud>
<ud>
Prosdocimus de Beldemandis (<dat when="1351">1351</dat>) Théoricien de la musique, <en ref="16" >mathématicien</en> et <en ref="1630" >physicien</en> [http://data.bnf.fr/ark:/12148/cb127653823#foaf:Person]
</ud>
<ud>
Taddeo da Parma (<dat when="1351">1351</dat>) <en ref="18" >Philosophe</en> averroïste et <en ref="24" >astronome</en>. - A enseigné la philosophie à Bologne vers 1320 [http://data.bnf.fr/ark:/12148/cb10103512f#foaf:Person]
</ud>
<ud>
Théodore Méliténiote (<en type="li">Constantinople</en>, <dat when="1351">1351</dat>) Grand sacellaire de l''Église byzantine, maître des maîtres de l''École patriarcale et archidiacre du clergé palatin. - A laissé un ouvrage d''exégèse de l''Évangile, un traité d''astronomie et un poème allégorique [http://data.bnf.fr/ark:/12148/cb12153709d#foaf:Person]
</ud>
<ud>
Paolo dal Pozzo Toscanelli (<dat when="1397">1397</dat>) <en ref="16" >Mathématicien</en>, <en ref="1630" >physicien</en>, <en ref="29" >géographe</en>, <en ref="24" >astronome</en> et <en ref="25" >astrologue</en>. - Inventeur des gnomons modernes. - Conservateur de la Bibliothèque de Florence [http://data.bnf.fr/ark:/12148/cb12455406j#foaf:Person]
</ud>
<ud>
Ugolino Pisani (<en type="li">Parme, Italie</en>, <dat when="1405">1405</dat>) <en ref="18" >Philosophe</en>, <en ref="16" >mathématicien</en>, auteur de comédies [http://data.bnf.fr/ark:/12148/cb12689419t#foaf:Person]
</ud>
<ud>
Lorenzo Buonincontri (<en type="li">San Miniato, Italie</en>, <dat when="1411">1411</dat>) Militaire, <en ref="16" >mathématicien</en>, <en ref="24" >astronome</en>, <en ref="25" >astrologue</en>, poète et historien. - <in ana="1621">Professeur d''astronomie à Naples</in> [http://data.bnf.fr/ark:/12148/cb12536229n#foaf:Person]
</ud>
<ud>
ʿAlī ibn Muḥammad al- Qalaṣādī (<en type="li">Baza (Espagne)</en>, <dat when="1412">1412</dat>) <en ref="16" >Mathématicien</en>, <en ref="24" >astronome</en>, juriste et savant [http://data.bnf.fr/ark:/12148/cb12440997n#foaf:Person]
</ud>
<ud>
Piero della Francesca (<en type="li">Borgo San Sepolcro, Italie</en>, <dat when="1416">1416</dat>) Peintre. - A écrit des traités de mathématiques, perspective et géométrie et des écrits sur la science des couleurs et du paysage [http://data.bnf.fr/ark:/12148/cb12060279h#foaf:Person]
</ud>
<ud>
Georgius de Hungaria (<en type="li">Romosz, aujourd''hui Romos, Roumanie</en>, <dat when="1422">1422</dat>) Prisonnier des Turcs (1438-1458). - Dominicain. - <en ref="16" >Mathématicien</en> [http://data.bnf.fr/ark:/12148/cb130923013#foaf:Person]
</ud>
<ud>
Antonio Manetti (<en type="li">Florence, Italie</en>, <dat when="1423">1423</dat>) Homme de lettres. - <en ref="1635" >Architecte</en>, <en ref="24" >astronome</en>, <en ref="16" >mathématicien</en> [http://data.bnf.fr/ark:/12148/cb11914242h#foaf:Person]
</ud>
<ud>
Georg von Peurbach (<en type="li">Peuerbach, Autriche</en>, <dat when="1423">1423</dat>) <en ref="24" >Astronome</en> [http://data.bnf.fr/ark:/12148/cb12374660w#foaf:Person]
</ud>
<ud>
Giovanni Pontano (<en type="li">Cerreto di Spoleto (Perouse), Italie</en>, <dat when="1426">1426</dat>) Homme politique. - Humaniste. - Auteur de traités astronomiques et philosophiques [http://data.bnf.fr/ark:/12148/cb123298807#foaf:Person]
</ud>
<ud>
Johannes Regiomontanus (<en type="li">Königsberg, Allemagne</en>, <dat when="1436">1436</dat>) <en ref="24" >Astronome</en>. - <en ref="16" >Mathématicien</en> [http://data.bnf.fr/ark:/12148/cb12159829r#foaf:Person]
</ud>
<ud>
Nīlakaṇṭha Somayajī (<dat when="1443">1443</dat>) <en ref="24" >Astronome</en> et <en ref="16" >mathématicien</en> de l''école de Kerala (Inde) [http://data.bnf.fr/ark:/12148/cb165324540#foaf:Person]
</ud>
<ud>
Luca Pacioli (<dat when="1445">1445</dat>) <en ref="16" >Mathématicien</en>. - Franciscain [http://data.bnf.fr/ark:/12148/cb11918350c#foaf:Person]
</ud>
<ud>
Konrad Türst (<dat when="1450">1450</dat>) <en ref="16" >Mathématicien</en> suisse de Zürich [http://data.bnf.fr/ark:/12148/cb15336511g#foaf:Person]
</ud>
<ud>
Agostino Ricci (<dat when="1451">1451</dat>) <en ref="24" >Astronome</en> [http://data.bnf.fr/ark:/12148/cb12539498r#foaf:Person]
</ud>
<ud>
Andrea Corsali (<dat when="1451">1451</dat>) <en ref="24" >Astronome</en>, cosmographe, navigateur dans la péninsule arabique et aux Indes. - Pourrait avoir introduit l''imprimerie en Éthiopie (ca 1524), où vraisemblament il meurt [http://data.bnf.fr/ark:/12148/cb13517283d#foaf:Person]
</ud>
<ud>
Anianus (<dat when="1451">1451</dat>) <en ref="24" >Astronome</en> et poète [http://data.bnf.fr/ark:/12148/cb125156549#foaf:Person]
</ud>
<ud>
Antonio Dolciati (<dat when="1451">1451</dat>) Augustinien et <en ref="16" >mathématicien</en> [http://data.bnf.fr/ark:/12148/cb134854696#foaf:Person]
</ud>
<ud>
Bartolomeo da Messina (<dat when="1451">1451</dat>) Écclésiastique et <en ref="16" >mathématicien</en> [http://data.bnf.fr/ark:/12148/cb125393703#foaf:Person]
</ud>
<ud>
Gaspar Torrella (<dat when="1451">1451</dat>) <en ref="28" >Médecin</en> et <en ref="16" >mathématicien</en>. - Évêque de Santa-Giusta (Sardaigne) en 1494. - Originaire de Valence (Espagne) [http://data.bnf.fr/ark:/12148/cb13486025q#foaf:Person]
</ud>
<ud>
Giovanni Abiosi (<dat when="1451">1451</dat>) <en ref="28" >Médecin</en>, <en ref="24" >astronome</en>, <en ref="16" >mathématicien</en> et <en ref="18" >philosophe</en>. - Né à Bagnuolo (Royaume de Naples), mort vers 1500 [http://data.bnf.fr/ark:/12148/cb12537367q#foaf:Person]
</ud>
<ud>
Giovanni Antonio Tagliente (<dat when="1451">1451</dat>) Calligraphe. - <en ref="16" >Mathématicien</en> [http://data.bnf.fr/ark:/12148/cb12179148h#foaf:Person]
</ud>
<ud>
Giovanni Benedetto Moncetto (<dat when="1451">1451</dat>) Agostinien. - <en ref="1629" >Théologien</en>, <en ref="18" >philosophe</en> et <en ref="24" >astronome</en> [http://data.bnf.fr/ark:/12148/cb125688716#foaf:Person]
</ud>
<ud>
Giovanni Bianchini (<dat when="1451">1451</dat>) <en ref="24" >Astronome</en> mort après 1469 [http://data.bnf.fr/ark:/12148/cb16163624s#foaf:Person]
</ud>
<ud>
Guillaume Hobit (<dat when="1451">1451</dat>) <en ref="24" >Astronome</en> ; <en ref="25" >astrologue</en> de Philippe le Bon, duc de Bourgogne [http://data.bnf.fr/ark:/12148/cb15063496s#foaf:Person]
</ud>
<ud>
Jacob Köbel (<en type="li">Heidelberg, Allemagne</en>, <dat when="1451">1451</dat>) <en ref="16" >Mathématicien</en>, éditeur et <en ref="1631" >libraire</en> [http://data.bnf.fr/ark:/12148/cb10244031k#foaf:Person]
</ud>
<ud>
Louis Boulengier (<dat when="1451">1451</dat>) <en ref="24" >Astronome</en> et <en ref="29" >géographe</en> d''Albi [http://data.bnf.fr/ark:/12148/cb152949413#foaf:Person]
</ud>
<ud>
Rāmacandrācārya (<dat when="1451">1451</dat>) Grammairien et commentateur de Pāṇini (actif au 15e s.). - Fils de Kr̥ṣṇācārya. - A aussi écrit des ouvrages de philosophie (Vedānta) et d''astronomie [http://data.bnf.fr/ark:/12148/cb137708651#foaf:Person]
</ud>
<ud>
Sigismondo Fanti (<en type="li">Ferrare, Italie</en>, <dat when="1451">1451</dat>) Poète, <en ref="18" >philosophe</en> et <en ref="16" >mathématicien</en>. - Meurt après 1527 [http://data.bnf.fr/ark:/12148/cb12567416q#foaf:Person]
</ud>
<ud>
Willem Gilliszoon (<dat when="1451">1451</dat>) <en ref="24" >Astronome</en> et <en ref="16" >mathématicien</en>. - Originaire de Wissekerc (Zélande) [http://data.bnf.fr/ark:/12148/cb12548011q#foaf:Person]
</ud>
<ud>
Girolamo Donato (<dat when="1454">1454</dat>) Magistrat, poète, <en ref="18" >philosophe</en>, <en ref="1629" >théologien</en> et <en ref="16" >mathématicien</en>. - Fut gouverneur de Brescia (<dat when="1496">1496</dat>), de Ferrare (<dat when="1498">1498</dat>), ambassadeur de Venise près le pape Jules II (<dat when="1510">1510</dat>) [http://data.bnf.fr/ark:/12148/cb13325565p#foaf:Person]
</ud>
<ud>
Eliya Delmedigo (<dat when="1460">1460</dat>) <en ref="28" >Médecin</en>. - <en ref="24" >Astronome</en>. - <en ref="16" >Mathématicien</en>. - Né en Crète. - <en ref="18" >Philosophe</en>. - Maître d''hébreu de Pic de la Mirandole (1463-1494). - Commentateur des écrits d''Averroés (1126-1198) [http://data.bnf.fr/ark:/12148/cb122623668#foaf:Person]
</ud>
<ud>
Lodovico Pontico Virunio (<dat when="1467">1467</dat>) <in ana="1621">Professeur de lettres, <en ref="18" >philosophe</en></in>, <en ref="16" >mathématicien</en> et poète. - Fut chargé de l''éducation des fils de Ludovico Sforza, duc de Milan. - Eut l''intention de fonder une imprimerie grecque et latine à Reggio Emilia, mais ses caractères furent volés par Ludovico Bonaccioli, <en ref="28" >médecin</en> de la duchesse de Ferrare. - Né à Belluno, meurt à Bologne [http://data.bnf.fr/ark:/12148/cb13324006j#foaf:Person]
</ud>
<ud>
Johannes Werner (<en type="li">Nuremberg, Allemagne</en>, <dat when="1468">1468</dat>) <en ref="16" >Mathématicien</en>, <en ref="24" >astronome</en> et <en ref="1636" >cartographe</en> [http://data.bnf.fr/ark:/12148/cb154028305#foaf:Person]
</ud>
<ud>
Jakob Ziegler (<en type="li">Landau (Allemagne)</en>, <dat when="1470">1470</dat>) <en ref="1629" >Théologien</en>, <en ref="16" >mathématicien</en>, <en ref="24" >astronome</en> et <en ref="29" >géographe</en>. - <in ana="1621">Professeur de théologie.</in> - Commentateur et auteur d''ouvrages historiques et théologiques [http://data.bnf.fr/ark:/12148/cb15029346k#foaf:Person]
</ud>
<ud>
Pedro Ciruelo (<en type="li">Daroca, Espagne</en>, <dat when="1470">1470</dat>) <in ana="1621">Professeur de théologie à l''Université d''Alcala (1510-)</in>, chanoine de la cathédrale de cette ville. - Fut l''un des précepteurs de Philippe II. - Étudia à Salamanque et à Paris, où il édita des oeuvres mathématiques et scientifiques. - Est également l''auteur d''un traité sur la sorcellerie dont la traduction espagnole eut une diffusion importante [http://data.bnf.fr/ark:/12148/cb128071494#foaf:Person]
</ud>
<ud>
Johann Stöffler (<en type="li">Justingen, Allemagne</en>, <dat when="1472">1472</dat>) <en ref="24" >Astronome</en> et <en ref="16" >mathématicien</en> [http://data.bnf.fr/ark:/12148/cb125156905#foaf:Person]
</ud>
<ud>
Josse Clicthove (Nieuport, Pays-Bas, <dat when="1472">1472</dat>) <en ref="1629" >Théologien</en> et <en ref="16" >mathématicien</en>. - Théologal de Chartres. - Un des premiers à combattre les idées de Luther [http://data.bnf.fr/ark:/12148/cb12234610b#foaf:Person]
</ud>
<ud>
Bartolomeo Zamberti (<en type="li">Venise, Italie</en>, <dat when="1473">1473</dat>) <en ref="16" >Mathématicien</en> et humaniste. - <in ana="1621">Professeur de lettres.</in> - Notaire des Consuls des marchands de Venise [http://data.bnf.fr/ark:/12148/cb12033590z#foaf:Person]
</ud>
<ud>
Nicolas Copernic (<dat when="1473">1473</dat>) <en ref="24" >Astronome</en> [http://data.bnf.fr/ark:/12148/cb118976048#foaf:Person]
</ud>
<ud>
Luca Gaurico (<en type="li">Giffoni, Italie</en>, <dat when="1476">1476</dat>) Évêque de Civita Ducale (1545-1549). - <en ref="16" >Mathématicien</en>, <en ref="18" >philosophe</en>, <en ref="24" >astronome</en> et <en ref="25" >astrologue</en> [http://data.bnf.fr/ark:/12148/cb134849440#foaf:Person]
</ud>
<ud>
Johann Schöner (<dat when="1477">1477</dat>) Né à Karlstadt près de Würzburg. - Prédicateur protestant. - <en ref="24" >Astronome</en>. - <en ref="29" >Géographe</en>. - <in ana="1621">Professeur de mathématiques à Nuremberg.</in> - A aussi écrit en latin [http://data.bnf.fr/ark:/12148/cb119992233#foaf:Person]
</ud>
<ud>
Girolamo Fracastoro (<en type="li">Vérone, Italie</en>, <dat when="1478">1478</dat>) <en ref="28" >Médecin</en>, auteur du "De contagione et contagiosis morbis et curatione libri III" ; nommé par le pape Paul III <en ref="28" >médecin</en> officiel du Concile de Trente. - Auteur de poèmes en latin, d''oeuvres de géographie, d''astronomie, de physique, de théologie et de philosophie. - Élève de Pomponazzi, ami de Copernic [http://data.bnf.fr/ark:/12148/cb120587788#foaf:Person]
</ud>
<ud>
Girolamo Francastoro (<dat when="1478">1478</dat>) <en ref="28" >Médecin</en>, <en ref="24" >astronome</en>, géologiste, poète, précurseur de la notion de contagion [http://data.bnf.fr/ark:/12148/cb15699396m#foaf:Person]
</ud>
<ud>
Celio Calcagnini (<en type="li">Ferrare, Italie</en>, <dat when="1479">1479</dat>) Poète, philologue, <en ref="18" >philosophe</en> et <en ref="24" >astronome</en>. - Accompagna Hippolyte d''Este en Hongrie et en Pologne [http://data.bnf.fr/ark:/12148/cb122157991#foaf:Person]
</ud>
<ud>
Charles de Bovelles (<dat when="1479">1479</dat>) <en ref="18" >Philosophe</en>, <en ref="16" >mathématicien</en> et linguiste. - Chanoine de Noyon. - Né avant le 28 mars 1479 [http://data.bnf.fr/ark:/12148/cb118932166#foaf:Person]
</ud>
<ud>
Prospero Calano (<en type="li">Sarzana, Italie</en>, <dat when="1480">1480</dat>) <en ref="28" >Médecin</en>, <en ref="24" >astronome</en> et <en ref="18" >philosophe</en> [http://data.bnf.fr/ark:/12148/cb12568870v#foaf:Person]
</ud>
<ud>
Vannoccio Biringuccio (<en type="li">Sienne, Italie</en>, <dat when="1480">1480</dat>) <en ref="16" >Mathématicien</en>, chimiste, <en ref="1635" >architecte</en> et <en ref="1633" >ingénieur</en>, spécialiste en métallurgie [http://data.bnf.fr/ark:/12148/cb12195640k#foaf:Person]
</ud>
<ud>
Michael Stifel (<dat when="1487">1487</dat>) <en ref="1629" >Théologien</en> et <en ref="16" >mathématicien</en>. - Inventeur du logarithme. - Enseigna la théologie et les mathématiques à l''Université de Königsberg, puis les mathématiques à l''Université de Iéna [http://data.bnf.fr/ark:/12148/cb12795734z#foaf:Person]
</ud>
<ud>
Sebastian Münster (<en type="li">Ingelheim, Allemagne</en>, <dat when="1489">1489</dat>) Hébraïsant, <en ref="29" >géographe</en> et <en ref="16" >mathématicien</en> [http://data.bnf.fr/ark:/12148/cb11996987j#foaf:Person]
</ud>
<ud>
Albert Pighius (Kampen, Pays-Bas, <dat when="1490">1490</dat>) <en ref="1629" >Théologien</en>, <en ref="16" >mathématicien</en> et <en ref="24" >astronome</en> [http://data.bnf.fr/ark:/12148/cb10448635x#foaf:Person]
</ud>
<ud>
Patrizio Tricasso (<en type="li">Ceresara, Italie</en>, <dat when="1491">1491</dat>) Dominicain. - <en ref="16" >Mathématicien</en> et <en ref="25" >astrologue</en> [http://data.bnf.fr/ark:/12148/cb107034397#foaf:Person]
</ud>
<ud>
Heinrich Schreiber (<en type="li">Erfurt, Allemagne</en>, <dat when="1492">1492</dat>) <en ref="16" >Mathématicien</en> [http://data.bnf.fr/ark:/12148/cb10734904t#foaf:Person]
</ud>
<ud>
Jean Borrel (<dat when="1492">1492</dat>) Géomètre et <en ref="16" >mathématicien</en>. - Chanoine régulier de l''Ordre de Saint-Antoine [http://data.bnf.fr/ark:/12148/cb12515817n#foaf:Person]
</ud>
<ud>
Pedro Nunez (<dat when="1492">1492</dat>) <en ref="24" >Astronome</en> et <en ref="16" >mathématicien</en> [http://data.bnf.fr/ark:/12148/cb12548918m#foaf:Person]
</ud>
<ud>
Oronce Fine (Briançon (Hautes-Alpes), <dat when="1494">1494</dat>) Sieur de Champrouet. - <en ref="16" >Mathématicien</en> et <en ref="24" >astronome</en> [http://data.bnf.fr/ark:/12148/cb122937307#foaf:Person]
</ud>
<ud>
Petrus Apian (<en type="li">Leisnig (Allemagne)</en>, <dat when="1495">1495</dat>) <en ref="24" >Astronome</en>, <en ref="1636" >cartographe</en> et <en ref="16" >mathématicien</en>. - Nommé Chevalier de l''Empire par Charles Quint. - Surnom de : Bienewitz (ou Bennewitz), Peter [http://data.bnf.fr/ark:/12148/cb12515640m#foaf:Person]
</ud>
<ud>
Andreas Osiander (<en type="li">Gunzenhausen, Allemagne</en>, <dat when="1498">1498</dat>) <en ref="1629" >Théologien</en> protestant, <en ref="24" >astronome</en> et <en ref="16" >mathématicien</en>. - Parfois désigné sous le nom "Andreas Osiander l''Ancien" [http://data.bnf.fr/ark:/12148/cb11988942v#foaf:Person]
</ud>
<ud>
Garcia da Orta (<en type="li">Castelo di Vide, Portugal</en>, <dat when="1499">1499</dat>) <en ref="28" >Médecin</en> et naturaliste. - A enseigné les mathématiques à l''Université de Lisbonne [http://data.bnf.fr/ark:/12148/cb119983323#foaf:Person]
</ud>
<ud>
Giovanni Agostino Abate (<dat when="1499">1499</dat>) <en ref="16" >Mathématicien</en> et historien [http://data.bnf.fr/ark:/12148/cb14624324z#foaf:Person]
</ud>
<ud>
Joachim Sterck van Ringelberg (<en type="li">Anvers, Belgique</en>, <dat when="1499">1499</dat>) Humaniste, <en ref="16" >mathématicien</en> et <en ref="25" >astrologue</en>. - Meurt selon les sources le 1er janvier 1531, en 1536 ou en 1556 [http://data.bnf.fr/ark:/12148/cb10645118k#foaf:Person]
</ud>
<ud>
Johann Carion (<en type="li">Bietigheim, Allemagne</en>, <dat when="1499">1499</dat>) <en ref="25" >Astrologue</en> et <en ref="16" >mathématicien</en> [http://data.bnf.fr/ark:/12148/cb12805831h#foaf:Person]
</ud>
<ud>
Johannes Dryander (<en type="li">Wetter, Allemagne</en>, <dat when="1500">1500</dat>) <en ref="16" >Mathématicien</en>, <en ref="1630" >physicien</en> et <en ref="24" >astronome</en>, <in ana="1621">professeur à Marburg</in>, édité par Sebastian Münster et Abraham Ortelius [http://data.bnf.fr/ark:/12148/cb15379218m#foaf:Person]
</ud>
<ud>
Johannes Voegelin (<en type="li">Heilbronn, Allemagne</en>, <dat when="1500">1500</dat>) <en ref="24" >Astronome</en> et <en ref="16" >mathématicien</en>. - Professeur à l''Université de Vienne [http://data.bnf.fr/ark:/12148/cb10490264h#foaf:Person]
</ud>
<ud>
Niccolò Tartaglia (<dat when="1500">1500</dat>) <en ref="16" >Mathématicien</en>, <en ref="1633" >ingénieur</en> et <en ref="1635" >architecte</en>. - Pseudonyme de Niccolò Fontana [http://data.bnf.fr/ark:/12148/cb12914492r#foaf:Person]
</ud>
<ud>
Gerolamo Cardano (<en type="li">Pavie, Italie</en>, <dat when="1501">1501</dat>) <en ref="28" >Médecin</en>, <en ref="16" >mathématicien</en> et <en ref="18" >philosophe</en> [http://data.bnf.fr/ark:/12148/cb11895137c#foaf:Person]
</ud>
<ud>
Pedro Nunes (<en type="li">Alcácer do Sol (Portugal)</en>, <dat when="1502">1502</dat>) <en ref="24" >Astronome</en> et <en ref="16" >mathématicien</en> portugais [http://data.bnf.fr/ark:/12148/cb13510349t#foaf:Person]
</ud>
<ud>
Cosimo Bartoli (<en type="li">Florence, Italie</en>, <dat when="1503">1503</dat>) Ambassadeur, poète et <en ref="16" >mathématicien</en> [http://data.bnf.fr/ark:/12148/cb125520809#foaf:Person]
</ud>
<ud>
Jean Cousin (<en type="li">Soucy (Yonne, France)</en>, <dat when="1503">1503</dat>) Peintre, sculpteur, graveur, <en ref="1635" >architecte</en>, <en ref="16" >mathématicien</en> [http://data.bnf.fr/ark:/12148/cb12467444s#foaf:Person]
</ud>
<ud>
Ciriaco Strozzi (<en type="li">Capalle, Italie</en>, <dat when="1504">1504</dat>) Helléniste, <en ref="18" >philosophe</en>, <en ref="16" >mathématicien</en> et <en ref="1635" >architecte</en> [http://data.bnf.fr/ark:/12148/cb10418521b#foaf:Person]
</ud>
<ud>
Jacques Bassantin (<dat when="1504">1504</dat>) <en ref="24" >Astronome</en> et <en ref="16" >mathématicien</en> [http://data.bnf.fr/ark:/12148/cb12548014r#foaf:Person]
</ud>
<ud>
Achille Pirminius Gasser (<dat when="1505">1505</dat>) <en ref="28" >Médecin</en>, historien et <en ref="24" >astronome</en> [http://data.bnf.fr/ark:/12148/cb12516715x#foaf:Person]
</ud>
<ud>
Benedictus Aretius (<dat when="1505">1505</dat>) <en ref="1629" >Théologien</en> protestant. - Botaniste et <en ref="24" >astronome</en>. - <in ana="1621">Professeur de logique à l''Université de Marbourg</in>, puis <in ana="1621">professeur de théologie à Berne</in>. - Fut lié avec Conrad Gesner. - Né et mort à Berne [http://data.bnf.fr/ark:/12148/cb12515850g#foaf:Person]
</ud>
<ud>
Alessandro Piccolomini (<en type="li">Sienne, Italie</en>, <dat when="1508">1508</dat>) Écrivain, dramaturge, <en ref="24" >astronome</en> et traducteur d''oeuvres de l''Antiquité, de comédies, de traités philosophiques et scientifiques. - Membre de l''Accademia degli Intronati de Sienne, sous le pseudonyme : lo Stordito. - Archevêque de Patras et coadjuteur de l''archevêque de Sienne Francesco Bandini Piccolomini, du 28 juillet 1574 à 1578 [http://data.bnf.fr/ark:/12148/cb12240709n#foaf:Person]
</ud>
<ud>
Gemma Frisius (Dokkum (Pays-Bas), <dat when="1508">1508</dat>) <en ref="16" >Mathématicien</en> et <en ref="24" >astronome</en>. - Professeur et docteur en <en ref="28" >médecin</en>e de l''Université de Louvain [http://data.bnf.fr/ark:/12148/cb125195002#foaf:Person]
</ud>
<ud>
Federico Commandino (<en type="li">Sassocorvaro, Italie</en>, <dat when="1509">1509</dat>) <en ref="16" >Mathématicien</en>. - A été le tuteur du duc d''Urbino [http://data.bnf.fr/ark:/12148/cb12562850s#foaf:Person]
</ud>
<ud>
Jean Gosselin (<en type="li">Vire, Calvados</en>, <dat when="1510">1510</dat>) <en ref="25" >Astrologue</en> et <en ref="16" >mathématicien</en>. - Conservateur de la bibliothèque du roi [http://data.bnf.fr/ark:/12148/cb133321861#foaf:Person]
</ud>
<ud>
Pietro Cataneo (<dat when="1510">1510</dat>) <en ref="1635" >Architecte</en> et <en ref="16" >mathématicien</en> [http://data.bnf.fr/ark:/12148/cb12557068n#foaf:Person]
</ud>
<ud>
Erasmus Oswald Schreckenfuchs (<dat when="1511">1511</dat>) Hébraïsant. - <en ref="24" >Astronome</en> [http://data.bnf.fr/ark:/12148/cb12115338j#foaf:Person]
</ud>
<ud>
Giovanni Battista Amici (<en type="li">Cosenza, Italie</en>, <dat when="1511">1511</dat>) <en ref="24" >Astronome</en> [http://data.bnf.fr/ark:/12148/cb15583428k#foaf:Person]
</ud>
<ud>
Juanelo Turriano (<dat when="1511">1511</dat>) <en ref="16" >Mathématicien</en> et <en ref="1633" >ingénieur</en> [http://data.bnf.fr/ark:/12148/cb129309990#foaf:Person]
</ud>
<ud>
Gerard Mercator (<en type="li">Rupelmonde, Flandres</en>, <dat when="1512">1512</dat>) <en ref="29" >Géographe</en>, <en ref="1636" >cartographe</en>, cosmographe et <en ref="16" >mathématicien</en> [http://data.bnf.fr/ark:/12148/cb12789989j#foaf:Person]
</ud>
<ud>
Giovanni Battista Amico (<dat when="1512">1512</dat>) <en ref="18" >Philosophe</en>, <en ref="16" >mathématicien</en> et <en ref="25" >astrologue</en>. - Originaire de Cosenza, fut assassiné à Padoue [http://data.bnf.fr/ark:/12148/cb12570280s#foaf:Person]
</ud>
<ud>
Juan Pérez de Moya (<dat when="1513">1513</dat>) <en ref="16" >Mathématicien</en> et humaniste [http://data.bnf.fr/ark:/12148/cb12146300q#foaf:Person]
</ud>
<ud>
Rheticus (<dat when="1514">1514</dat>) <en ref="24" >Astronome</en> [http://data.bnf.fr/ark:/12148/cb13615799v#foaf:Person]
</ud>
<ud>
Bernardino Baldini (<dat when="1515">1515</dat>) Professeur de <en ref="28" >médecin</en>e à Pavie puis de mathématiques à Milan [http://data.bnf.fr/ark:/12148/cb13163998r#foaf:Person]
</ud>
<ud>
Petrus Ramus (<en type="li">Cuts (Aisne)</en>, <dat when="1515">1515</dat>) <en ref="18" >Philosophe</en>, grammairien, <en ref="16" >mathématicien</en> et humaniste. - Professeur de mathématique au Collège royal (Collège de France). - Se convertit au protestantisme et fut tué au cours du Massacre de la Saint-Barthélemy [http://data.bnf.fr/ark:/12148/cb120645094#foaf:Person]
</ud>
<ud>
Jean-Pierre de Mesmes (<dat when="1516">1516</dat>) Savant et poète. - Fils de Pierre de Mesmes, chambellan du roi de Navarre. - Etait lié avec Ronsard, du Bellay, Baïf, Charondas, Herberay, Jean Maugin, Ol. de Magny. - A était un des premiers auteurs à avoir écrit en français sur l''astronomie [http://data.bnf.fr/ark:/12148/cb125177720#foaf:Person]
</ud>
<ud>
Jacques Peletier (<dat when="1517">1517</dat>) Poète et critique humaniste. - <en ref="16" >Mathématicien</en>. - A participé à la réforme de l''orthographe. - Traducteur d''Horace [http://data.bnf.fr/ark:/12148/cb122992680#foaf:Person]
</ud>
<ud>
Jeronimo Munoz (<dat when="1520">1520</dat>) <en ref="24" >Astronome</en> [http://data.bnf.fr/ark:/12148/cb14646245j#foaf:Person]
</ud>
<ud>
Livio Sanuto (<dat when="1520">1520</dat>) <en ref="29" >Géographe</en> et <en ref="16" >mathématicien</en> à Venise, fabriquant d''un globe avec son frère Giulio en 1561 [http://data.bnf.fr/ark:/12148/cb153816227#foaf:Person]
</ud>
<ud>
Melchior Ayrer (<dat when="1520">1520</dat>) <en ref="16" >Mathématicien</en> [http://data.bnf.fr/ark:/12148/cb162974318#foaf:Person]
</ud>
<ud>
Nicolaus Gugler (<en type="li">Nuremberg (Allemagne)</en>, <dat when="1521">1521</dat>) <en ref="28" >Médecin</en> et <en ref="24" >astronome</en>, a reçu une formation de juriste. - Fils de Hans Gugler (1480-1560) [http://data.bnf.fr/ark:/12148/cb16504896w#foaf:Person]
</ud>
<ud>
Valentin Mennher (<dat when="1521">1521</dat>) <en ref="16" >Mathématicien</en>. - Membre de la guilde des instituteurs d''Anvers [http://data.bnf.fr/ark:/12148/cb12563197r#foaf:Person]
</ud>
<ud>
Hermann Witekind (<en type="li">Neuenrade (Allemagne)</en>, <dat when="1522">1522</dat>) <en ref="16" >Mathématicien</en> et humaniste [http://data.bnf.fr/ark:/12148/cb162248258#foaf:Person]
</ud>
<ud>
Giovanni Maria Bonardo (<en type="li">Fratta Polesine, Italie</en>, <dat when="1523">1523</dat>) Poète. - Agronome. - <en ref="24" >Astronome</en> [http://data.bnf.fr/ark:/12148/cb12181418p#foaf:Person]
</ud>
<ud>
Juan de Yciar (Durango (prov. de Vizcaya), <dat when="1523">1523</dat>) Pédagogue, <en ref="16" >mathématicien</en> et calligraphe [http://data.bnf.fr/ark:/12148/cb128696315#foaf:Person]
</ud>
<ud>
Jacques Charpentier (Clermont-en-Beauvaisis (<en type="li">Oise)</en>, <dat when="1524">1524</dat>) <en ref="18" >Philosophe</en> et <en ref="28" >médecin</en>. - Lecteur de mathématiques au Collège de France. - <en ref="28" >Médecin</en> du roi [http://data.bnf.fr/ark:/12148/cb121323921#foaf:Person]
</ud>
<ud>
Tadeáš Hájek (<en type="li">Prague</en>, <dat when="1525">1525</dat>) <en ref="16" >Mathématicien</en> et <en ref="28" >médecin</en>. - Reçu docteur à Bologne, occupa une chaire au Carolinum de Prague, fut premier <en ref="28" >médecin</en> des empereurs Maximilien II et Rodolphe II [http://data.bnf.fr/ark:/12148/cb13009688n#foaf:Person]
</ud>
<ud>
Tilemann Stella (<en type="li">Siegen (Allemagne)</en>, <dat when="1525">1525</dat>) <en ref="16" >Mathématicien</en>, <en ref="24" >astronome</en>, <en ref="29" >géographe</en>, <en ref="1635" >architecte</en> et bibliothécaire. - <en ref="1636" >Cartographe</en> à Wittenberg, ses cartes ont été éditées par Ortelius, Jode et Hondius [http://data.bnf.fr/ark:/12148/cb15376436c#foaf:Person]
</ud>
<ud>
Taqī al-Dīn Muḥammad Ibn Maʿrūf (<en type="li">Damas</en>, <dat when="1526">1526</dat>) <en ref="24" >Astronome</en> et <en ref="16" >mathématicien</en> ottoman [http://data.bnf.fr/ark:/12148/cb14599962n#foaf:Person]
</ud>
<ud>
John Dee (<dat when="1527">1527</dat>) <en ref="25" >Astrologue</en>, <en ref="16" >mathématicien</en> et antiquaire [http://data.bnf.fr/ark:/12148/cb119854464#foaf:Person]
</ud>
<ud>
Adam Lonicer (<en type="li">Marburg (Allemagne)</en>, <dat when="1528">1528</dat>) Medecin et botaniste. - Professeur de <en ref="28" >médecin</en>e, chimie et mathématiques. - Fils du <en ref="1629" >théologien</en> : Lonicer, Johann (1499-15969) [http://data.bnf.fr/ark:/12148/cb10279221n#foaf:Person]
</ud>
<ud>
Cornelius Blockland (<dat when="1530">1530</dat>) Musicien, <en ref="25" >astrologue</en>, <en ref="16" >mathématicien</en> et <en ref="28" >médecin</en>. - Actif de 1571 à 1586. - Frère du peintre Anthonie Blockland van Montfort [http://data.bnf.fr/ark:/12148/cb13497580p#foaf:Person]
</ud>
<ud>
Giovanni Battista Benedetti (<en type="li">Venise, Italie</en>, <dat when="1530">1530</dat>) <en ref="16" >Mathématicien</en> et <en ref="1633" >ingénieur</en>. - Fondateur de la géométrie analytique [http://data.bnf.fr/ark:/12148/cb11998820g#foaf:Person]
</ud>
<ud>
Jean Péna (<dat when="1530">1530</dat>) <en ref="16" >Mathématicien</en>, traducteur et éditeur de textes mathématiques et géométriques antiques [http://data.bnf.fr/ark:/12148/cb13483147k#foaf:Person]
</ud>
<ud>
Conradus Dasypodius (<en type="li">Frauenfeld, Suisse</en>, <dat when="1531">1531</dat>) <en ref="16" >Mathématicien</en>. - A tracé le plan de l''horloge astronomique de la cathédrale de Strasbourg [http://data.bnf.fr/ark:/12148/cb16534831x#foaf:Person]
</ud>
<ud>
Ercole Bottrigari (<dat when="1531">1531</dat>) Humaniste, <en ref="16" >mathématicien</en>, musicien, poète, linguiste et <en ref="18" >philosophe</en> [http://data.bnf.fr/ark:/12148/cb125347809#foaf:Person]
</ud>
<ud>
Giuseppe Moletti (<dat when="1531">1531</dat>) Cosmographe et <en ref="29" >géographe</en>. - Professeur de <en ref="28" >médecin</en>e, de mathématique et d''astronomie à l''Université de Padoue [http://data.bnf.fr/ark:/12148/cb134849518#foaf:Person]
</ud>
<ud>
Philip Apian (<en type="li">Ingoldstadt, Allemagne</en>, <dat when="1531">1531</dat>) <en ref="1636" >Cartographe</en>, <en ref="16" >mathématicien</en> et <en ref="1630" >physicien</en>. - Fils de Peter Apian, succède à son père à l''Université d''Ingolstadt [http://data.bnf.fr/ark:/12148/cb152383864#foaf:Person]
</ud>
<ud>
Fabrizio Mordente (<en type="li">Salerne, Italie</en>, <dat when="1532">1532</dat>) <en ref="16" >Mathématicien</en>. - A inventé le compas de proportion à huit points [http://data.bnf.fr/ark:/12148/cb14643668k#foaf:Person]
</ud>
<ud>
Egnatio Danti (<en type="li">Pérouse, Italie</en>, <dat when="1536">1536</dat>) <en ref="16" >Mathématicien</en>, <en ref="24" >astronome</en>, <en ref="1636" >cartographe</en> et cosmographe. - Dominicain [http://data.bnf.fr/ark:/12148/cb145332908#foaf:Person]
</ud>
<ud>
Henri de Monantheuil (<dat when="1536">1536</dat>) <en ref="16" >Mathématicien</en> et <en ref="28" >médecin</en>. - Régent de la Faculté de <en ref="28" >médecin</en>e de Paris, puis professeur de mathématiques au Collège de France (1574-). - Né à Reims, meurt à Paris [http://data.bnf.fr/ark:/12148/cb13006651k#foaf:Person]
</ud>
<ud>
Christophorus Clavius (<dat when="1537">1537</dat>) Jésuite, musicien et <in ana="1621">professeur de mathématiques</in>. - Fut chargé par Grégoire XIII de la réforme du calendrier [http://data.bnf.fr/ark:/12148/cb125466080#foaf:Person]
</ud>
<ud>
Francesco Barozzi (<en type="li">Heraklion, Grèce</en>, <dat when="1537">1537</dat>) <en ref="16" >Mathématicien</en> et <en ref="24" >astronome</en> [http://data.bnf.fr/ark:/12148/cb10462395x#foaf:Person]
</ud>
<ud>
Giovanni Paolo Gallucci (<en type="li">Salò, Italie</en>, <dat when="1538">1538</dat>) <en ref="24" >Astronome</en>. - Homme de lettres [http://data.bnf.fr/ark:/12148/cb106019703#foaf:Person]
</ud>
<ud>
Philips Mor (<dat when="1539">1539</dat>) Humaniste, <en ref="16" >mathématicien</en> et poète néolatin. - Chanoine du chapitre de St Salvator d''Utrecht. - Fils du peintre Anthonis Mor van Dashorst (Antonio Moro) [http://data.bnf.fr/ark:/12148/cb12384177f#foaf:Person]
</ud>
<ud>
François Viète (Fontenay-le-Comte (<en type="li">Vendée)</en>, <dat when="1540">1540</dat>) <en ref="16" >Mathématicien</en> [http://data.bnf.fr/ark:/12148/cb120511976#foaf:Person]
</ud>
<ud>
Cormopede (<dat when="1541">1541</dat>) <en ref="16" >Mathématicien</en> et <en ref="25" >astrologue</en>. - Gentilhomme de la maison du Comte de Sterckenberg. - Date de naissance présumée d''après le "portrait de Cormopede à l''âge de 51 ans" figurant au F. A. 2 de l''"Almanach des almanachs pour l''an MDXCIII" [http://data.bnf.fr/ark:/12148/cb13491791f#foaf:Person]
</ud>
<ud>
Giovanni di Strasoldo (<dat when="1544">1544</dat>) Noble. - Homme d''arme. - <en ref="16" >Mathématicien</en>. - Poète [http://data.bnf.fr/ark:/12148/cb15122132t#foaf:Person]
</ud>
<ud>
Guidobaldo Dal Monte (<dat when="1545">1545</dat>) <en ref="16" >Mathématicien</en> et <en ref="24" >astronome</en>. - Protégea <en ref="7" >Galilée</en> et lui fit obtenir sa première chaire à Pise. - Né à Pesaro, meurt dans son chateau de Monte Baroccio [http://data.bnf.fr/ark:/12148/cb135173214#foaf:Person]
</ud>
<ud>
Renward Cysat (<en type="li">Lucerne (Suisse)</en>, <dat when="1545">1545</dat>) Chancelier de la ville de Lucerne, Suisse. - Historien, dramaturge, pharmacien et naturaliste. - Père de : Cysat, Johann Baptist (1587-1653), <en ref="16" >mathématicien</en> et <en ref="24" >astronome</en> [http://data.bnf.fr/ark:/12148/cb12748433g#foaf:Person]
</ud>
<ud>
Maurice Bressieu (<dat when="1546">1546</dat>) <en ref="16" >Mathématicien</en>, <en ref="18" >philosophe</en> et humaniste. - Titulaire de la chaire de mathématiques au Collège de France (1575-), orateur des rois de France à Rome (1586-), intendant de la Bibliothèque vaticane [http://data.bnf.fr/ark:/12148/cb13495175h#foaf:Person]
</ud>
<ud>
Tycho Brahe (<en type="li">Knudstrup (Suède)</en>, <dat when="1546">1546</dat>) <en ref="24" >Astronome</en> [http://data.bnf.fr/ark:/12148/cb11893749j#foaf:Person]
</ud>
<ud>
Muḥammad ibn al-Ḥusayan Bahāʼ al-Dīn ʿĀmilī (<dat when="1547">1547</dat>) Érudit arabe, <en ref="18" >philosophe</en>, <en ref="1629" >théologien</en>, <en ref="24" >astronome</en>, grammairien, auteur d''anthologies [http://data.bnf.fr/ark:/12148/cb12451570z#foaf:Person]
</ud>
<ud>
Nicodemus Frischlin (<en type="li">Balingen, Allemagne</en>, <dat when="1547">1547</dat>) Philologue et écrivain. - A enseigné les belles-lettres et les mathématiques à l''Université de Tubingue. - Traducteur d''Aristophane, de Callimaque et de Tryphiodore. - Auteur d''une comédie, présentée devant l''empereur Rodolphe, qui lui décerna le titre de comte-palatin [http://data.bnf.fr/ark:/12148/cb12463064b#foaf:Person]
</ud>
<ud>
Michele Zappulo (<dat when="1548">1548</dat>) Docteur en droit canon et civil. - <en ref="24" >Astronome</en>, historien et poète [http://data.bnf.fr/ark:/12148/cb125454264#foaf:Person]
</ud>
<ud>
Simon Stevin (<en type="li">Bruges, Belgique</en>, <dat when="1548">1548</dat>) <in ana="1621">Professeur de mathématiques de Maurice de Nassau</in> [http://data.bnf.fr/ark:/12148/cb119941019#foaf:Person]
</ud>
<ud>
Michel Coignet (<dat when="1549">1549</dat>) <en ref="1633" >Ingénieur</en>, <en ref="16" >mathématicien</en>, fabricant d''instruments de navigation, poète [http://data.bnf.fr/ark:/12148/cb124231863#foaf:Person]
</ud>
<ud>
Francisco Sánchez (<dat when="1550">1550</dat>) <en ref="28" >Médecin</en>, <en ref="18" >philosophe</en>, <en ref="16" >mathématicien</en> et poète. - Également connu sous le pseudonyme d''El Escéptico [http://data.bnf.fr/ark:/12148/cb120172346#foaf:Person]
</ud>
<ud>
Giovanni Battista Crispo (<en type="li">Gallipoli, Italie</en>, <dat when="1550">1550</dat>) Prêtre. - <en ref="16" >Mathématicien</en>, <en ref="1629" >théologien</en> et homme de lettres [http://data.bnf.fr/ark:/12148/cb10615268s#foaf:Person]
</ud>
<ud>
John Napier (<dat when="1550">1550</dat>) <en ref="16" >Mathématicien</en> et <en ref="1629" >théologien</en>. - Baron de Merchiston [http://data.bnf.fr/ark:/12148/cb12353925j#foaf:Person]
</ud>
<ud>
Michael Moestlin (<dat when="1550">1550</dat>) Né à Göppingen (Wurtemberg). - <en ref="16" >Mathématicien</en>. - <en ref="24" >Astronome</en>. - Luthérien, hostile à la réforme grégorienne du calendrier [http://data.bnf.fr/ark:/12148/cb12330628m#foaf:Person]
</ud>
<ud>
Sigfridus Aronus Forsius (<dat when="1550">1550</dat>) <en ref="24" >Astronome</en> et <en ref="25" >astrologue</en> finlandais [http://data.bnf.fr/ark:/12148/cb131923734#foaf:Person]
</ud>
<ud>
Aegidius Martini (<dat when="1551">1551</dat>) <en ref="1636" >Cartographe</en>, <en ref="16" >mathématicien</en> [http://data.bnf.fr/ark:/12148/cb15376579x#foaf:Person]
</ud>
<ud>
al-Silahî Nasuh (<dat when="1551">1551</dat>) Savant, miniaturiste et calligraphe ottoman. - A écrit plusieurs ouvrages sur les armes et les combats, sur la géométrie et les mathématiques ainsi que sur l''histoire. - Inventeur du jeu de "matraque", il est mieux connu sous son surnom "Matrakçı" : "Matrakçı Nasuh Efendi", "Nasuh al-Silahî", "Matraki", "Nasuh el-Mitraki", "Nasuh üs-Silahi", "Matraqçi Nasuh", "Nasuh b. Abdullah" et "Nasuh b. Karagöz el-Bosnevi" sont parmi les autres formes de référence [http://data.bnf.fr/ark:/12148/cb119562090#foaf:Person]
</ud>
<ud>
Anthoine Cathalan (<dat when="1551">1551</dat>) <in ana="1621">Professeur de mathématiques </in>[http://data.bnf.fr/ark:/12148/cb14526861v#foaf:Person]
</ud>
<ud>
Bartolomeo Crescenzio (<dat when="1551">1551</dat>) <en ref="16" >Mathématicien</en>, <en ref="1633" >ingénieur</en> naval et voyageur. - Fut capitaine de galère de la marine pontificale [http://data.bnf.fr/ark:/12148/cb125466487#foaf:Person]
</ud>
<ud>
Bernardo Gamucci (<en type="li">San Gimignano, Italie</en>, <dat when="1551">1551</dat>) Archéologue, <en ref="1635" >architecte</en> et <en ref="16" >mathématicien</en> [http://data.bnf.fr/ark:/12148/cb10435220v#foaf:Person]
</ud>
<ud>
Camillo Agrippa (<dat when="1551">1551</dat>) <en ref="18" >Philosophe</en>, <en ref="16" >mathématicien</en>, <en ref="1635" >architecte</en> et <en ref="1633" >ingénieur</en>. - Est aussi l''auteur de l''un des premiers traité d''escrime [http://data.bnf.fr/ark:/12148/cb12536260s#foaf:Person]
</ud>
<ud>
Claude de Boissière (<dat when="1551">1551</dat>) <en ref="16" >Mathématicien</en>. - Auteur d''un "Art poétique" [http://data.bnf.fr/ark:/12148/cb12509709h#foaf:Person]
</ud>
<ud>
Didier Henrion (<dat when="1551">1551</dat>) <in ana="1621">Professeur de mathématiques à Paris</in>. - <en ref="1633" >Ingénieur</en> au service des Provinces-Unies. - N''est pas un pseudonyme de Clément Cyriaque de Mangin [http://data.bnf.fr/ark:/12148/cb144882445#foaf:Person]
</ud>
<ud>
Eilhard Lubbin (<dat when="1551">1551</dat>) <en ref="1636" >Cartographe</en> et <en ref="16" >mathématicien</en> à Rostock [http://data.bnf.fr/ark:/12148/cb153777849#foaf:Person]
</ud>
<ud>
Faustus Verantius (Sebenico aujord''hui Šibenik (<en type="li">Croatie)</en>, <dat when="1551">1551</dat>) Lexicographe, <en ref="1630" >physicien</en> et <en ref="16" >mathématicien</en>. - Évêque de Czanad (Hongrie) (<dat when="1594">1594</dat>) et de la République de Venise. - Neveu d''Antun Vrančić (1504-1573) [http://data.bnf.fr/ark:/12148/cb10703670x#foaf:Person]
</ud>
<ud>
Francesco Feliciano (<dat when="1551">1551</dat>) <en ref="16" >Mathématicien</en>, augustinien et miniaturiste [http://data.bnf.fr/ark:/12148/cb13485419n#foaf:Person]
</ud>
<ud>
Francis Van Schoten (<dat when="1551">1551</dat>) <in ana="1621">Professeur de mathématiques à Leyde</in>, <en ref="1636" >cartographe</en> [http://data.bnf.fr/ark:/12148/cb15337130w#foaf:Person]
</ud>
<ud>
Francisco Zarzoso (<en type="li">Cella, Espagne</en>, <dat when="1551">1551</dat>) <en ref="24" >Astronome</en> [http://data.bnf.fr/ark:/12148/cb119512329#foaf:Person]
</ud>
<ud>
Giacomo Lanteri (<en type="li">Paratico, Italie</en>, <dat when="1551">1551</dat>) <en ref="16" >Mathématicien</en> et <en ref="1633" >ingénieur</en> [http://data.bnf.fr/ark:/12148/cb104024969#foaf:Person]
</ud>
<ud>
Girolamo Mercurio (<dat when="1551">1551</dat>) Dominicain. - <en ref="28" >Médecin</en>, <in ana="1621">professeur de logique et de mathématique </in>[http://data.bnf.fr/ark:/12148/cb13484092c#foaf:Person]
</ud>
<ud>
Giuseppe Unicorno (<dat when="1551">1551</dat>) <en ref="16" >Mathématicien</en>. - <en ref="18" >Philosophe</en>. - <en ref="25" >Astrologue</en>. - Musicologue. - <en ref="1629" >Théologien</en>. - Originaire de Bergame [http://data.bnf.fr/ark:/12148/cb125394931#foaf:Person]
</ud>
<ud>
Helisaeus Röslin (<dat when="1551">1551</dat>) <en ref="16" >Mathématicien</en>. - <en ref="24" >Astronome</en>. - <en ref="28" >Médecin</en> (pratiquait à Strasbourg et Francfort) [http://data.bnf.fr/ark:/12148/cb132003253#foaf:Person]
</ud>
<ud>
Jacques Besson (<en type="li">Colombières (Italie)</en>, <dat when="1551">1551</dat>) <en ref="1633" >Ingénieur</en> et <en ref="16" >mathématicien</en>. - Né à Colombières, vallée d''Oulx (aujourd''hui en Italie), d''après Eugénie Droz [http://data.bnf.fr/ark:/12148/cb12376654f#foaf:Person]
</ud>
<ud>
Jacques Maretz (<dat when="1551">1551</dat>) Dessinateur et graveur, <en ref="16" >mathématicien</en> [http://data.bnf.fr/ark:/12148/cb153705873#foaf:Person]
</ud>
<ud>
Jamet Mettayer (<dat when="1551">1551</dat>) Autre(s) graphie(s) : Metayer ; Messor ; Metayerus ; Mettayier. - Variante(s) de prénom : Jean ; Jean Jamet. - <en ref="1632" >Imprimeur</en>-<en ref="1631" >libraire</en> ; <en ref="1632" >imprimeur</en> du Roi pour les mathématiques (<dat when="1580">1580</dat>) et <en ref="1632" >imprimeur</en> ordinaire du Roi (1583-1605). - En 1588, le roi Henri III le fait <en ref="1632" >imprimeur</en> officiel de sa congrégation des pénitents de l''Annonciation. De 1588 à 1594, il suit le Roi et la Cour à Blois puis  à Tours. - De retour à Paris, doit partager sa charge avec Pierre L''Huillier et Fédéric II Morel en vertu de l''arrêt du Conseil du 20 avril 1594. Revend à Tours son atelier et sa boutique à l''<en ref="1632" >imprimeur</en> Maurice Bouguereau. En mars  1596, le Roi l''associe à la Compagnie des usages avec Pierre L''Huillier. Décédé avant le 12 fév. 1605. Des publications paraissent encore sous son nom jusqu''en 1614. - A travaillé en association avec Mathurin Challenge (<dat when="1573">1573</dat>) et Barthélemy Gomet à Blois. S''associe à Tours (oct. 1591 - oct. 1593) avec Jean Richer, Claude de Monstr''oeil, Sébastien Molin, Mathieu I Guillemot, Georges Drobet et Marc Orry, son gendre. Travaille en association étroite avec Pierre L''Huillier et avec son fils Pierre Mettayer qui se trouvaient eux aussi à Tours [http://data.bnf.fr/ark:/12148/cb125031934#foaf:Person]
</ud>
<ud>
Jean Brohon (<dat when="1551">1551</dat>) <en ref="28" >Médecin</en>, botaniste et <en ref="24" >astronome</en>. - Fut recteur de l''Université de Caen [http://data.bnf.fr/ark:/12148/cb12545367f#foaf:Person]
</ud>
<ud>
Jean de Seville (<dat when="1551">1551</dat>) <en ref="16" >Mathématicien</en> et hydrographe [http://data.bnf.fr/ark:/12148/cb13496046w#foaf:Person]
</ud>
<ud>
Jean Maria Coloni (<dat when="1551">1551</dat>) Citoyen de Romans en Dauphiné. - <en ref="16" >Mathématicien</en> et <en ref="25" >astrologue</en> [http://data.bnf.fr/ark:/12148/cb13479237s#foaf:Person]
</ud>
<ud>
Jean Tagaut (<dat when="1551">1551</dat>) Poète. - <en ref="28" >Médecin</en>, <en ref="16" >mathématicien</en>, professeur à Lausanne et Genève [http://data.bnf.fr/ark:/12148/cb12249180j#foaf:Person]
</ud>
<ud>
Joannes Portantius (<dat when="1551">1551</dat>) <en ref="24" >Astronome</en>, <en ref="16" >mathématicien</en> et <en ref="29" >géographe</en> à Anvers, édité par Ortelius et De Jode [http://data.bnf.fr/ark:/12148/cb153817246#foaf:Person]
</ud>
<ud>
Johann Georg Locher (<dat when="1551">1551</dat>) <en ref="16" >Mathématicien</en> [http://data.bnf.fr/ark:/12148/cb13006978f#foaf:Person]
</ud>
<ud>
Juan de Rojas Sarmiento (<en type="li">Palencia, Espagne</en>, <dat when="1551">1551</dat>) <en ref="16" >Mathématicien</en> et <en ref="24" >astronome</en> [http://data.bnf.fr/ark:/12148/cb140653109#foaf:Person]
</ud>
<ud>
Marc Duncan (<dat when="1551">1551</dat>) <en ref="28" >Médecin</en>, originaire d''Écosse, s''établit à Saumur en 1606 à l''appel de l''Académie protestante de la ville. - Professeur de mathématiques, de grec et d''humanités [http://data.bnf.fr/ark:/12148/cb13006401g#foaf:Person]
</ud>
<ud>
Martin Basanier (<dat when="1551">1551</dat>) <en ref="16" >Mathématicien</en>, musicien [http://data.bnf.fr/ark:/12148/cb12510914p#foaf:Person]
</ud>
<ud>
Martinus Hortensius (<dat when="1551">1551</dat>) <en ref="24" >Astronome</en> [http://data.bnf.fr/ark:/12148/cb13007384z#foaf:Person]
</ud>
<ud>
Nicolaus Reimarus Ursus (<dat when="1551">1551</dat>) <en ref="16" >Mathématicien</en>. - <en ref="24" >Astronome</en> [http://data.bnf.fr/ark:/12148/cb145753184#foaf:Person]
</ud>
<ud>
Paschasius Hamellius (<dat when="1551">1551</dat>) <en ref="16" >Mathématicien</en> [http://data.bnf.fr/ark:/12148/cb13173242d#foaf:Person]
</ud>
<ud>
Paul Yvon (<dat when="1551">1551</dat>) <en ref="16" >Mathématicien</en>. - Achète la seigneurie de Laleu en 1592 et y fait construire le château. - Maire de La Rochelle en 1616. - S'' installe à Paris en décembre 1633 et abjure le protestantisme [http://data.bnf.fr/ark:/12148/cb12135021d#foaf:Person]
</ud>
<ud>
Peter Laicksteen (<dat when="1551">1551</dat>) <en ref="1636" >Cartographe</en> et <en ref="24" >astronome</en> [http://data.bnf.fr/ark:/12148/cb15370391s#foaf:Person]
</ud>
<ud>
Phillebert Charpentier (<dat when="1551">1551</dat>) Éditeur. - Marchand d''estampes et d''instruments de mathématiques [http://data.bnf.fr/ark:/12148/cb16553551w#foaf:Person]
</ud>
<ud>
Pierre Forcadel (<dat when="1551">1551</dat>) <en ref="16" >Mathématicien</en> [http://data.bnf.fr/ark:/12148/cb103947442#foaf:Person]
</ud>
<ud>
Pierre Hérigone (<dat when="1551">1551</dat>) <in ana="1621">Professeur de mathématiques à Paris</in>. - N''est pas un pseudonyme de Clément Cyriaque de Mangin [http://data.bnf.fr/ark:/12148/cb144882503#foaf:Person]
</ud>
<ud>
Pierre Le Voirier (<dat when="1551">1551</dat>) Autre(s) graphie(s) : Le Voirrier ; Le Verrier. - <en ref="1632" >Imprimeur</en> du Roi pour les mathématiques. - Beau-père de Mathieu I Guillemot (<dat when="1584">1584</dat>). Encore en activité le 31 déc. 1589. Décédé entre 1591 et le 7 nov. 1594 (compte de succession) [http://data.bnf.fr/ark:/12148/cb12230743m#foaf:Person]
</ud>
<ud>
Teodato Osio (<dat when="1551">1551</dat>) <en ref="16" >Mathématicien</en>. - Musicien [http://data.bnf.fr/ark:/12148/cb125559272#foaf:Person]
</ud>
<ud>
Walther Hermann Ryff (<dat when="1551">1551</dat>) Apothicaire, <en ref="28" >médecin</en>, <en ref="16" >mathématicien</en> et <en ref="1635" >architecte</en> [http://data.bnf.fr/ark:/12148/cb11948264d#foaf:Person]
</ud>
<ud>
William Welwod (<dat when="1551">1551</dat>) <en ref="16" >Mathématicien</en>. - <in ana="1621">Professeur de droit </in>[http://data.bnf.fr/ark:/12148/cb125630488#foaf:Person]
</ud>
<ud>
Jost Bürgi (<dat when="1552">1552</dat>) Horloger, <en ref="24" >astronome</en> et <en ref="16" >mathématicien</en> suisse [http://data.bnf.fr/ark:/12148/cb123814270#foaf:Person]
</ud>
<ud>
Bernardino Baldi (<en type="li">Urbino, Italie</en>, <dat when="1553">1553</dat>) Abbé de Guastalla. - Poète, prosateur, <en ref="16" >mathématicien</en> et historien. - Polyglotte, connaissait le grec et le latin, l''hébreu, l''arabe, le persan et le hongrois [http://data.bnf.fr/ark:/12148/cb12179488k#foaf:Person]
</ud>
<ud>
Jacob Christmann (<dat when="1554">1554</dat>) Orientaliste, <en ref="16" >mathématicien</en> et <en ref="24" >astronome</en>. - A été le premier à utiliser le télescope avec d''autres instruments comme le sextant [http://data.bnf.fr/ark:/12148/cb12560133s#foaf:Person]
</ud>
<ud>
Giovanni Antonio Magini (<en type="li">Padoue, Italie</en>, <dat when="1555">1555</dat>) <en ref="24" >Astronome</en>, <en ref="16" >mathématicien</en> et <en ref="29" >géographe</en>. - A occupé la chaire d''astronomie à l''Université de Bologne en 1588. - Auteur prétendu de prédictions et de nombreux almanachs publiés en France, en Allemagne et aux Pays-Bas jusqu''au 19e siècle [http://data.bnf.fr/ark:/12148/cb12162475b#foaf:Person]
</ud>
<ud>
Jean Du Temps (<dat when="1555">1555</dat>) Fils de l''avocat Jean Du Temps I, il fut lui-même avocat et avait des connaissances en astrologie et mathématique. Frère d''Adam Du Temps, spécialiste des fortifications qui participa peut-être à la carte du Blésois dont il est l''auteur [http://data.bnf.fr/ark:/12148/cb15302460t#foaf:Person]
</ud>
<ud>
Sethus Calvisius (<dat when="1556">1556</dat>) Organiste, compositeur et théoricien de la musique ; <en ref="24" >astronome</en> ; historien ; <en ref="1631" >libraire</en> et éditeur de musique. - Natif de Gorsleben près de Sachsenburg (Thuringe) et issu d''une famille paysanne. Après des études aux universités de Leipzig et Helmstedt, il devient à partir de 1581 et jusqu''à sa mort "cantor" de plusieurs églises de Leipzig successivement. Auteur de plusieurs ouvrages théoriques et compositions musicales, ainsi que d''un "Opus chronologicum" (1605 ; au moins 6 rééd.) et d''un "Elenchus calendarii Gregoriani" (<dat when="1612">1612</dat>). Décédé à Leipzig en nov. 1615. À distinguer du pasteur et prédicateur de Quedlinburg Sethus Calvisius (ou : Seth Kal(l)witz) (1639-1698), parfois appelé à tort "Sethus Calvisius le fils" [http://data.bnf.fr/ark:/12148/cb12875550d#foaf:Person]
</ud>
<ud>
Guillaume de Nautonier (<dat when="1557">1557</dat>) Savant, <en ref="16" >mathématicien</en>, <en ref="24" >astronome</en>, d''origine protestante, <en ref="29" >géographe</en> du roi Henri IV [http://data.bnf.fr/ark:/12148/cb12412403z#foaf:Person]
</ud>
<ud>
Christoph Meurer (<dat when="1558">1558</dat>) Professeur de mathématiques à Leipzig (<dat when="1613">1613</dat>). - <en ref="28" >Médecin</en> [http://data.bnf.fr/ark:/12148/cb14333201g#foaf:Person]
</ud>
<ud>
Jean-Édouard Du Monin (<dat when="1559">1559</dat>) <en ref="16" >Mathématicien</en> et spécialiste des langues anciennes. - Fut professeur à Paris, puis à Poitiers [http://data.bnf.fr/ark:/12148/cb12463074n#foaf:Person]
</ud>
<ud>
Thomas Hariot (<en type="li">Oxford, GB</en>, <dat when="1560">1560</dat>) <en ref="16" >Mathématicien</en> et <en ref="24" >astronome</en>. - Envoyé comme conseiller aux Amériques en 1585-86 [http://data.bnf.fr/ark:/12148/cb12215671c#foaf:Person]
</ud>
<ud>
Thomas Harriot (<dat when="1560">1560</dat>) <en ref="16" >Mathématicien</en>, <en ref="1630" >physicien</en> et <en ref="24" >astronome</en> anglais [http://data.bnf.fr/ark:/12148/cb124346111#foaf:Person]
</ud>
<ud>
Adrianus Romanus (<en type="li">Louvain</en>, <dat when="1561">1561</dat>) <en ref="28" >Médecin</en>, <en ref="16" >mathématicien</en> et voyageur. - Enseigna à Louvain et à Würzburg, fut <en ref="16" >mathématicien</en> royal en Pologne [http://data.bnf.fr/ark:/12148/cb12459969s#foaf:Person]
</ud>
<ud>
Bartholomäus Pitiscus (<dat when="1561">1561</dat>) A aussi écrit en latin. - Prédicateur protestant à la cour de l''Électeur palatin. - Également auteur d''ouvrages mathématiques [http://data.bnf.fr/ark:/12148/cb121457326#foaf:Person]
</ud>
<ud>
Henry Briggs (<dat when="1561">1561</dat>) <en ref="16" >Mathématicien</en> [http://data.bnf.fr/ark:/12148/cb12305061c#foaf:Person]
</ud>
<ud>
Jean Tarde (La Roque-Gageac (<en type="li">Dordogne)</en>, <dat when="1561">1561</dat>) <en ref="16" >Mathématicien</en>, historien, <en ref="29" >géographe</en> et <en ref="24" >astronome</en>. - Chanoine [http://data.bnf.fr/ark:/12148/cb12641353z#foaf:Person]
</ud>
<ud>
Jean Tarde (<dat when="1561">1561</dat>) Chanoine de Sarlat, <en ref="16" >mathématicien</en> et <en ref="1636" >cartographe</en> [http://data.bnf.fr/ark:/12148/cb153143878#foaf:Person]
</ud>
<ud>
P. Christoph Grienberger (<dat when="1561">1561</dat>) Jésuite, <en ref="16" >mathématicien</en>, <en ref="24" >astronome</en> et <en ref="1635" >architecte</en>. Il a realisé les plans du Collège d''Aurillac et du Charleville [http://data.bnf.fr/ark:/12148/cb10686921r#foaf:Person]
</ud>
<ud>
Philippus Lansbergen (<en type="li">Gand (Belgique)</en>, <dat when="1561">1561</dat>) <en ref="16" >Mathématicien</en>, <en ref="24" >astronome</en> et pasteur [http://data.bnf.fr/ark:/12148/cb130073828#foaf:Person]
</ud>
<ud>
Christen Sørensen Longomontanus (<dat when="1562">1562</dat>) <en ref="24" >Astronome</en> et <en ref="16" >mathématicien</en>. - Fut l''élève de Tycho-Brahé. - Professeur de hautes mathématiques à l''Université de Copenhague [http://data.bnf.fr/ark:/12148/cb13011001c#foaf:Person]
</ud>
<ud>
Guangqi Xu (<en type="li">Shanghai</en>, <dat when="1562">1562</dat>) Haut fonctionnaire chinois, initié et converti au christianisme par le père jésuite Matteo Ricci. - <en ref="16" >Mathématicien</en>. - <en ref="24" >Astronome</en>. - Disciple de Matteo Ricci [http://data.bnf.fr/ark:/12148/cb150892932#foaf:Person]
</ud>
<ud>
<en ref="7" >Galileo Galilei</en> (<en type="li">Pise, Italie</en>, <dat when="1564">1564</dat>) <en ref="1630" >Physicien</en>, <en ref="18" >philosophe</en>, <en ref="24" >astronome</en> [http://data.bnf.fr/ark:/12148/cb11903931b#foaf:Person]
</ud>
<ud>
Luis Teixeira (<dat when="1564">1564</dat>) Jésuite portugais, <en ref="16" >mathématicien</en> et <en ref="1636" >cartographe</en> actif de 1564 à 1613 [http://data.bnf.fr/ark:/12148/cb153361957#foaf:Person]
</ud>
<ud>
Edward Brerewood (<dat when="1565">1565</dat>) Antiquaire et <en ref="16" >mathématicien</en>, linguiste et humaniste. - Professeur d''astronomie au Gresham college de Londres [http://data.bnf.fr/ark:/12148/cb125109678#foaf:Person]
</ud>
<ud>
Eilhard Lubin (<dat when="1565">1565</dat>) Humaniste, philologue, <en ref="1636" >cartographe</en>, <en ref="1629" >théologien</en> et <en ref="16" >mathématicien</en> [http://data.bnf.fr/ark:/12148/cb15040859j#foaf:Person]
</ud>
<ud>
Paolo Antonio Foscarini (<en type="li">Montalto Uffugo, Italie</en>, <dat when="1565">1565</dat>) Carme. - <en ref="1629" >Théologien</en>. - <en ref="16" >Mathématicien</en> et <en ref="24" >astronome</en> [http://data.bnf.fr/ark:/12148/cb12377530d#foaf:Person]
</ud>
<ud>
Scipione Chiaramonti (<en type="li">Cesena, Italie</en>, <dat when="1565">1565</dat>) <en ref="24" >Astronome</en> et <en ref="18" >philosophe</en>. - Professeur de philosophie à l''Université de Pise [http://data.bnf.fr/ark:/12148/cb10545041n#foaf:Person]
</ud>
<ud>
Fr. François d'' Aguillon (<dat when="1566">1566</dat>) Jésuite, <en ref="1635" >architecte</en> et <en ref="16" >mathématicien</en>. Auteur d''un projet pour le noviciat de Tournai. Préposé de la Maison professe, professeur d''Anvers [http://data.bnf.fr/ark:/12148/cb16240952w#foaf:Person]
</ud>
<ud>
Georg Ludwig Frobenius (<dat when="1566">1566</dat>) <en ref="1631" >Libraire</en>. - Natif d''Iphofen, près de Wurzbourg. Titulaire d''une maîtrise de théologie. Après des études aux universités de Tübingen et Wittenberg, travaille avec l''<en ref="24" >astronome</en> Tycho Brahe jusqu''à la mort de celui-ci. Reçu ensuite bourgeois de Hambourg, où il s''établit <en ref="1631" >libraire</en> [http://data.bnf.fr/ark:/12148/cb12229506t#foaf:Person]
</ud>
<ud>
Marco Antonio De Dominis (l''île de Rab (<en type="li">Croatie)</en>, <dat when="1566">1566</dat>) <in ana="1621">Professeur de rhétorique, mathématiques et philosophie dans la Compagnie de Jésus, à Padoue et Brescia</in>. - Evêque de Segna (Senj ou Zengg en Croatie) de 1600 à 1602; de Spalato (Split) de 1602 à 1615. - Gagné au protestantisme et exilé en Angleterre, doyen de Windsor. - Abjure et rentre en grâce (<dat when="1622">1622</dat>) [http://data.bnf.fr/ark:/12148/cb121335726#foaf:Person]
</ud>
<ud>
Marinus Ghetaldus (Raguse aujourd''hui Dubrovnik (<en type="li">Croatie)</en>, <dat when="1566">1566</dat>) <en ref="16" >Mathématicien</en> et <en ref="1630" >physicien</en>. - Il exerça une grande influence sur le développement de l''application de l''algèbre à la géométrie. - Il mit au point le miroir parabolique, aujourd''hui conservé au National Maritime Museum de Londres. - Il collabora, entre autres, avec François Viète en France et avec <en ref="7" >Galilée</en> en Italie [http://data.bnf.fr/ark:/12148/cb146476018#foaf:Person]
</ud>
<ud>
François de Aguilón (<dat when="1567">1567</dat>) <en ref="1635" >Architecte</en> et <en ref="16" >mathématicien</en> belge d''origine espagnole [http://data.bnf.fr/ark:/12148/cb119998212#foaf:Person]
</ud>
<ud>
Johann Hartmann (<dat when="1568">1568</dat>) <en ref="16" >Mathématicien</en> et naturaliste. - Professeur de chimie à l''Université de Marburg [http://data.bnf.fr/ark:/12148/cb13009199x#foaf:Person]
</ud>
<ud>
P. Jacques de Guernisac (<dat when="1568">1568</dat>) Jésuite et <en ref="1635" >architecte</en>, professeur de mathématique à Pont-à-Mousson puis à La Flèche, recteur du collège des Jésuites de Quimper [http://data.bnf.fr/ark:/12148/cb16215104d#foaf:Person]
</ud>
<ud>
Mutio Oddi (<dat when="1569">1569</dat>) <en ref="16" >Mathématicien</en>. - <en ref="1635" >Architecte</en> [http://data.bnf.fr/ark:/12148/cb165299645#foaf:Person]
</ud>
<ud>
Andrea Argoli (<dat when="1570">1570</dat>) <en ref="16" >Mathématicien</en>. - <en ref="24" >Astronome</en>. - Professeur de mathématique à l''Université de Padoue [http://data.bnf.fr/ark:/12148/cb121593328#foaf:Person]
</ud>
<ud>
Erasmus Schmied (<dat when="1570">1570</dat>) Né à Delitzsch, près de Leipzig. - <in ana="1621">Professeur de grec et de mathématiques à Wittenberg </in>[http://data.bnf.fr/ark:/12148/cb12045847b#foaf:Person]
</ud>
<ud>
Anders Bure (<dat when="1571">1571</dat>) <en ref="1636" >Cartographe</en> et <en ref="16" >mathématicien</en> [http://data.bnf.fr/ark:/12148/cb14509982d#foaf:Person]
</ud>
<ud>
Giovanni Branca (<dat when="1571">1571</dat>) <en ref="1635" >Architecte</en>, <en ref="1633" >ingénieur</en> et <en ref="16" >mathématicien</en>. - Né à Pesaro, meurt à Pérouse [http://data.bnf.fr/ark:/12148/cb121826472#foaf:Person]
</ud>
<ud>
Johannes Isaacus Pontanus (<en type="li">Elseneur (Danemark)</en>, <dat when="1571">1571</dat>) Historien. - Philologue. - <in ana="1621">Professeur de mathématiques et de physique </in>[http://data.bnf.fr/ark:/12148/cb123875836#foaf:Person]
</ud>
<ud>
Johannes Kepler (<dat when="1571">1571</dat>) <en ref="24" >Astronome</en> et <en ref="16" >mathématicien</en> [http://data.bnf.fr/ark:/12148/cb11909597m#foaf:Person]
</ud>
<ud>
Willem Jansz Blaeu (<dat when="1571">1571</dat>) Autre(s) graphie(s) : Janssonius Blaeuw. - <en ref="1632" >Imprimeur</en>-<en ref="1631" >libraire</en> et éditeur de cartes et d''atlas. - Originaire d''Alkmaar ou des environs. Passe 2 ans auprès de Tycho Brahé au Danemark. À son retour à Amsterdam en 1596, s''établit <en ref="1636" >cartographe</en> et fabricant de globes terrestres et célestes. Monte ensuite une imprimerie et une fonderie. Également auteur d''ouvrages cartographiques et astronomiques [http://data.bnf.fr/ark:/12148/cb12169772t#foaf:Person]
</ud>
<ud>
Cornelius Drebbel (<dat when="1572">1572</dat>) Graveur. - <en ref="16" >Mathématicien</en>. - <en ref="1630" >Physicien</en>. - Chimiste [http://data.bnf.fr/ark:/12148/cb12382467g#foaf:Person]
</ud>
<ud>
Rodolphus Goclenius (<dat when="1572">1572</dat>) Docteur en <en ref="28" >médecin</en>e en 1601. - <in ana="1621">Professeur de physique en 1608</in>. - <in ana="1621">Professeur de mathématiques à l''Université de Marbourg en 1621</in> [http://data.bnf.fr/ark:/12148/cb121595722#foaf:Person]
</ud>
<ud>
Samuel Marolois (<dat when="1572">1572</dat>) <en ref="16" >Mathématicien</en> français ayant vécu une grande partie de sa vie aux Pays-Bas [http://data.bnf.fr/ark:/12148/cb14912871p#foaf:Person]
</ud>
<ud>
Thomas Lydyat (<en type="li">Okerton, GB</en>, <dat when="1572">1572</dat>) <en ref="16" >Mathématicien</en> et <en ref="24" >astronome</en> [http://data.bnf.fr/ark:/12148/cb12390032f#foaf:Person]
</ud>
<ud>
Christoph Scheiner (<dat when="1575">1575</dat>) Jésuite. - <en ref="1630" >Physicien</en>, <en ref="16" >mathématicien</en> et <en ref="24" >astronome</en> [http://data.bnf.fr/ark:/12148/cb13483688j#foaf:Person]
</ud>
<ud>
Michelangelo Galilei (<dat when="1575">1575</dat>) Luthiste et compositeur italien de la Renaissance. - Fils du compositeur et théoricien Vincenzo Galilei, et frère de l''<en ref="24" >astronome</en> <en ref="7" >Galileo Galilei</en> [http://data.bnf.fr/ark:/12148/cb140013401#foaf:Person]
</ud>
<ud>
Octavio Pisani (<en type="li">Naples, Italie</en>, <dat when="1575">1575</dat>) Cosmographe et <en ref="24" >astronome</en>, travaille à Anvers de 1612 à 1637 [http://data.bnf.fr/ark:/12148/cb15404394h#foaf:Person]
</ud>
<ud>
Francesco Ingoli (<en type="li">Ravenne (Italie)</en>, <dat when="1578">1578</dat>) Secrétaire de la propagande, débat avec Copernic (en 1616 et 1624) et écrit Relazione delle quattro parti del mondo avec pour objectif de soutenir missions et propagande religieuses. - Étudie l''astronomie, la cosmographie et la géographie et connait le grec, le français, l''espagnon et l''arabe. - Diplômé en droit civil et en droit canon à l''Université de Padoue, Italie [http://data.bnf.fr/ark:/12148/cb13749501h#foaf:Person]
</ud>
<ud>
Sybrandt Hansz. Cardinael (Harlingen (Pays-Bas), <dat when="1578">1578</dat>) <en ref="16" >Mathématicien</en> [http://data.bnf.fr/ark:/12148/cb15944052f#foaf:Person]
</ud>
<ud>
Cristóvão Ferreira (<dat when="1580">1580</dat>) Supérieur et procurateur de la mission jésuite au Japon, il abjura en 1633 et se convertit au zen. - Auteur en 1636 de la "Supercherie dévoilée". - Traducteur d''ouvrages d''astronomie et de chirurgie [http://data.bnf.fr/ark:/12148/cb13524212c#foaf:Person]
</ud>
<ud>
Godfried Wendelen (<dat when="1580">1580</dat>) <en ref="24" >Astronome</en> et géomètre. - Avocat au Parlement de Paris puis doyen du chapitre de Rothnac, Belgique [http://data.bnf.fr/ark:/12148/cb123969373#foaf:Person]
</ud>
<ud>
Joannes Michael Gigas (<dat when="1580">1580</dat>) Docteur, <en ref="16" >mathématicien</en> et <en ref="29" >géographe</en> édité par Blaeu et Hondius [http://data.bnf.fr/ark:/12148/cb153239798#foaf:Person]
</ud>
<ud>
Johann Faulhaber (<dat when="1580">1580</dat>) <en ref="16" >Mathématicien</en> allemand. S''est aussi intéressé à l''ingénierie des fortifications [http://data.bnf.fr/ark:/12148/cb137778453#foaf:Person]
</ud>
<ud>
Nicolas-Claude Fabri Peiresc (<en type="li">Belgentier (Var)</en>, <dat when="1580">1580</dat>) Conseiller au Parlement de Provence. - <en ref="24" >Astronome</en>, archéologue et naturaliste [http://data.bnf.fr/ark:/12148/cb11918940q#foaf:Person]
</ud>
<ud>
Willebrordus Snellius (Leyde, Pays-Bas, <dat when="1580">1580</dat>) <en ref="16" >Mathématicien</en>, <en ref="24" >astronome</en> et <en ref="29" >géographe</en> [http://data.bnf.fr/ark:/12148/cb15336105f#foaf:Person]
</ud>
<ud>
Claude-Gaspard Bachet (Bourg-en-Bresse (<en type="li">Ain)</en>, <dat when="1581">1581</dat>) <en ref="16" >Mathématicien</en> et littérateur. - Sieur de Méziriac. - Érudit, auteur de poèmes en français, italien et latin. - Membre de l''Académie française (élu en 1634) [http://data.bnf.fr/ark:/12148/cb120028244#foaf:Person]
</ud>
<ud>
Alexandre Anderson (<dat when="1582">1582</dat>) <en ref="16" >Mathématicien</en> [http://data.bnf.fr/ark:/12148/cb16296598k#foaf:Person]
</ud>
<ud>
Jean François (<dat when="1582">1582</dat>) Nom en religion de Jean Charnage. - Jésuite. - <in ana="1621">Professeur de philosophie et de mathématiques à La Flèche</in> [http://data.bnf.fr/ark:/12148/cb121629197#foaf:Person]
</ud>
<ud>
Mario Bettini (<en type="li">Bologne, Italie</en>, <dat when="1582">1582</dat>) Jésuite. - <en ref="18" >Philosophe</en> et <en ref="16" >mathématicien</en> [http://data.bnf.fr/ark:/12148/cb12545452p#foaf:Person]
</ud>
<ud>
Matthias Bernegger (<en type="li">Hallstatt (Autriche)</en>, <dat when="1582">1582</dat>) Philologue, historien, <en ref="16" >mathématicien</en> et <en ref="24" >astronome</en>. - Protestant. - Professeur d''histoire et d''éloquence à Strasbourg, recteur de l''Université de cette même ville [http://data.bnf.fr/ark:/12148/cb129928534#foaf:Person]
</ud>
<ud>
Jean-Baptiste Morin (Villefranche-sur-Saône (<en type="li">Rhône)</en>, <dat when="1583">1583</dat>) <en ref="24" >Astronome</en> et <en ref="16" >mathématicien</en> [http://data.bnf.fr/ark:/12148/cb11916881j#foaf:Person]
</ud>
<ud>
Orazio Grassi (<en type="li">Savone, Italie</en>, <dat when="1583">1583</dat>) Jésuite. - <en ref="16" >Mathématicien</en>, <en ref="24" >astronome</en> et <en ref="1635" >architecte</en> [http://data.bnf.fr/ark:/12148/cb125377863#foaf:Person]
</ud>
<ud>
Filippo Finella (<en type="li">Naples, Italie</en>, <dat when="1584">1584</dat>) <en ref="25" >Astrologue</en>. - <en ref="24" >Astronome</en>. - Auteur dramatique [http://data.bnf.fr/ark:/12148/cb122006609#foaf:Person]
</ud>
<ud>
Grégoire de Saint-Vincent (<dat when="1584">1584</dat>) <en ref="16" >Mathématicien</en>. - <en ref="24" >Astronome</en> [http://data.bnf.fr/ark:/12148/cb16197665z#foaf:Person]
</ud>
<ud>
James Hume (<dat when="1584">1584</dat>) <en ref="16" >Mathématicien</en>. - <en ref="24" >Astronome</en>. - Historien. - Hébraïsant. - Actif en 1639. - A vécu à Paris. - Fils de David Hume (1558-163.) et frère aîné de la poétesse et traductrice Anna Hume (1586?-16..) [http://data.bnf.fr/ark:/12148/cb12072629r#foaf:Person]
</ud>
<ud>
Claude Mydorge (<dat when="1585">1585</dat>) <en ref="16" >Mathématicien</en> et <en ref="1630" >physicien</en> [http://data.bnf.fr/ark:/12148/cb144888873#foaf:Person]
</ud>
<ud>
Mario Guiducci (<en type="li">Florence, Italie</en>, <dat when="1585">1585</dat>) Homme de lettres et <en ref="24" >astronome</en>. - A collaboré avec <en ref="7" >Galileo Galilei</en> [http://data.bnf.fr/ark:/12148/cb144609004#foaf:Person]
</ud>
<ud>
Melchior Inchofer (<en type="li">Vienne</en>, <dat when="1585">1585</dat>) Jésuite. - <en ref="18" >Philosophe</en>, <en ref="16" >mathématicien</en> et <en ref="1629" >théologien</en> professeur à Messine, Italie [http://data.bnf.fr/ark:/12148/cb10735485h#foaf:Person]
</ud>
<ud>
Philipp Müller (<dat when="1585">1585</dat>) <en ref="16" >Mathématicien</en>, <en ref="28" >médecin</en>, chimiste et botaniste. - Professeur à l''université de Leipzig [http://data.bnf.fr/ark:/12148/cb14065362j#foaf:Person]
</ud>
<ud>
Jean L''Hoste (<en type="li">Nancy</en>, <dat when="1586">1586</dat>) <en ref="1633" >Ingénieur</en>. - Intendant des fortifications du duc de Lorraine. - Professeur de droit et de mathématiques à Pont-à-Mousson [http://data.bnf.fr/ark:/12148/cb16628764j#foaf:Person]
</ud>
<ud>
Niccolò Zucchi (<en type="li">Parme, Italie</en>, <dat when="1586">1586</dat>) Jésuite. - Recteur du Collegio romano (1646-1649). - <en ref="24" >Astronome</en> [http://data.bnf.fr/ark:/12148/cb10077816w#foaf:Person]
</ud>
<ud>
Benedetto Castelli (<en type="li">Brescia, Italie</en>, <dat when="1587">1587</dat>) Dominicain. - <en ref="16" >Mathématicien</en>, inventeur et écrivain. - Disciple de <en ref="7" >Galilée</en>, dont il défendit les théories astronomiques [http://data.bnf.fr/ark:/12148/cb12545385c#foaf:Person]
</ud>
<ud>
Joachim Jungius (<dat when="1587">1587</dat>) Naturaliste, <en ref="16" >mathématicien</en> et <en ref="18" >philosophe</en> [http://data.bnf.fr/ark:/12148/cb120247195#foaf:Person]
</ud>
<ud>
Libert Froidmont (<en type="li">Liège</en>, <dat when="1587">1587</dat>) <en ref="1629" >Théologien</en>. - <en ref="16" >Mathématicien</en>, <en ref="1630" >physicien</en> et géologue [http://data.bnf.fr/ark:/12148/cb14462868z#foaf:Person]
</ud>
<ud>
François Derand (<dat when="1588">1588</dat>) Jésuite. - <in ana="1621">Professeur de grammaire et de mathématiques</in>. - <en ref="1635" >Architecte</en>. - Né à Vic s/Seille (Moselle), mort à Agde (Hérault) [http://data.bnf.fr/ark:/12148/cb13012148j#foaf:Person]
</ud>
<ud>
Jacques Grandami (<dat when="1588">1588</dat>) Jésuite. - <in ana="1621">Professeur de belles lettres, de philosophie et de théologie</in>, puis recteur de Bourges, Rennes, La Flèche, Tours et Rouen. - Visiteur de la province de France. - <en ref="24" >Astronome</en> [http://data.bnf.fr/ark:/12148/cb12155155d#foaf:Person]
</ud>
<ud>
Marin Mersenne (<dat when="1588">1588</dat>) <en ref="18" >Philosophe</en> et savant, <en ref="24" >astronome</en>, <en ref="16" >mathématicien</en>. - Théoricien de la musique. - Minime [http://data.bnf.fr/ark:/12148/cb119157157#foaf:Person]
</ud>
<ud>
Eberhard Welper (<dat when="1590">1590</dat>) <en ref="1632" >Imprimeur</en>-<en ref="1631" >libraire</en>. - Natif de Lohra (comté de Lohenstein, près de Marburg, Allemagne). <en ref="16" >Mathématicien</en>, <en ref="25" >astrologue</en> et <en ref="24" >astronome</en>, il se fixe à Strasbourg en 1618. Établi <en ref="1631" >libraire</en> en 1620 puis <en ref="1632" >imprimeur</en> dès 1621. Publie notamment chaque année un almanach et des prédictions. Auteur de plusieurs ouvrages scientifiques, dont des "Elementa geometrica..." (1re éd., <dat when="1620">1620</dat>), une "Gnomonica" (<dat when="1625">1625</dat>), un "Compendium astronomiae..." (<dat when="1634">1634</dat>) et un traité de la divination, "Rota-Fortunae, oder Glück-Rad..." (s. d., plusieurs rééd.). De 1634 à 1639, assure des fonctions d''enseignant au Gymnase (lycée) de Strasbourg. En 1654, sollicite en vain la charge d''<en ref="1632" >imprimeur</en> de l''évêché de Saverne. De 1653 à 1661, imprime sous le pseudonyme de Hartmann Bär quelques ouvrages pour l''académie des Jésuites à Molsheim. Son fils aîné Johann Welper (1642-1720) lui succède en 1664, mais des éditions paraissent encore sous son nom en 1689. Son autre fils Eberhard (II) Welper (1644-1670) sera lui aussi <en ref="16" >mathématicien</en>, <en ref="25" >astrologue</en> et <en ref="24" >astronome</en> [http://data.bnf.fr/ark:/12148/cb158750586#foaf:Person]
</ud>
<ud>
Johannes Wilhelm Lauremberg (<dat when="1590">1590</dat>) Auteur, <en ref="16" >mathématicien</en> et historien à Rostock [http://data.bnf.fr/ark:/12148/cb15377794m#foaf:Person]
</ud>
<ud>
Jean Leurechon (Bar-le-Duc, <dat when="1591">1591</dat>) Jésuite. - Professeur de philosophie et de mathématiques, à Pont-à-Mousson notamment. - Confesseur du duc de Lorraine Charles IV. - Henry Van Etten, qui signe la dédicace de la première édition des "Récréations mathématiques" n''est pas un pseudonyme de Jean Leurechon, mais le nom d''un de ses élèves, qui aurait réellement existé d''après Trevor H. Hall [http://data.bnf.fr/ark:/12148/cb13009618g#foaf:Person]
</ud>
<ud>
Joseph Salomon Delmedigo (<dat when="1591">1591</dat>) <en ref="28" >Médecin</en>. - <en ref="24" >Astronome</en>. - <en ref="16" >Mathématicien</en>. - Né en Crète. - Fils d''Eliya Delmedigo (1460-1497) [http://data.bnf.fr/ark:/12148/cb122623548#foaf:Person]
</ud>
<ud>
Giovanni Battista Vertova (<en type="li">Bergame, Italie</en>, <dat when="1592">1592</dat>) <en ref="16" >Mathématicien</en> et <en ref="1633" >ingénieur</en> militaire. - Chevalier de l''Ordre de Malte [http://data.bnf.fr/ark:/12148/cb15093021d#foaf:Person]
</ud>
<ud>
Johann Adam Schall von Bell (<dat when="1592">1592</dat>) Jésuite. - Missionnaire en Chine (de 1619 à sa mort). - <en ref="16" >Mathématicien</en>. - Conseiller et <en ref="24" >astronome</en> de la Cour impériale de Chine [http://data.bnf.fr/ark:/12148/cb12362941r#foaf:Person]
</ud>
<ud>
Pierre Gassendi (<en type="li">Champtercier, près de Digne</en>, <dat when="1592">1592</dat>) <en ref="18" >Philosophe</en>, <en ref="24" >astronome</en>, <en ref="16" >mathématicien</en>, <en ref="1630" >physicien</en>, docteur en théologie et théoricien de la musique. - Entre dans les ordres en 1615 [http://data.bnf.fr/ark:/12148/cb120250393#foaf:Person]
</ud>
<ud>
Wilhelm Schickard (<en type="li">Herrenberg, Allemagne</en>, <dat when="1592">1592</dat>) <en ref="16" >Mathématicien</en>, <en ref="24" >astronome</en>, professeur d''agriculture [http://data.bnf.fr/ark:/12148/cb11969696s#foaf:Person]
</ud>
<ud>
Albert Girard (Saint-Mihiel, <dat when="1595">1595</dat>) <en ref="16" >Mathématicien</en> et <en ref="1633" >ingénieur</en>. - <en ref="1633" >Ingénieur</en> dans l''armée de Frédéric de Nassau, prince d''Orange [http://data.bnf.fr/ark:/12148/cb121123333#foaf:Person]
</ud>
<ud>
Pierre Bardin (<en type="li">Rouen</en>, <dat when="1595">1595</dat>) Homme de lettres, <en ref="18" >philosophe</en> et <en ref="16" >mathématicien</en>. - Précepteur. - Membre de l''Académie française (élu en 1634) [http://data.bnf.fr/ark:/12148/cb125272379#foaf:Person]
</ud>
<ud>
Pierre Bourdin (<dat when="1595">1595</dat>) Jésuite. - <in ana="1621">Professeur de mathématiques</in> [http://data.bnf.fr/ark:/12148/cb123902440#foaf:Person]
</ud>
<ud>
Daniel Mögling (<en type="li">Böblingen</en>, <dat when="1596">1596</dat>) Alchimiste, rosicrucien, <en ref="28" >médecin</en> et <en ref="24" >astronome</en> [http://data.bnf.fr/ark:/12148/cb167575369#foaf:Person]
</ud>
<ud>
Jacob Golius (<dat when="1596">1596</dat>) Orientaliste. - <en ref="16" >Mathématicien</en>. - Philologue, spécialiste des littératures [http://data.bnf.fr/ark:/12148/cb123338386#foaf:Person]
</ud>
<ud>
René Descartes (Descartes (Indre-et-Loire), <dat when="1596">1596</dat>) <en ref="18" >Philosophe</en> et <en ref="16" >mathématicien</en> [http://data.bnf.fr/ark:/12148/cb11899775j#foaf:Person]
</ud>
<ud>
Giovanni Battista Hodierna (<dat when="1597">1597</dat>) <en ref="24" >Astronome</en> italien [http://data.bnf.fr/ark:/12148/cb120704558#foaf:Person]
</ud>
<ud>
Bonaventura Cavalieri (<en type="li">Milan, Italie</en>, <dat when="1598">1598</dat>) Jésuite. - <en ref="16" >Mathématicien</en>, géomètre et <en ref="24" >astronome</en>, disciple de <en ref="7" >Galilée</en>. - Fut professeur à l''Université de Bologne [http://data.bnf.fr/ark:/12148/cb12085151g#foaf:Person]
</ud>
<ud>
Giovanni Battista Riccioli (<en type="li">Ferrare, Italie</en>, <dat when="1598">1598</dat>) Jésuite. - <en ref="24" >Astronome</en>. - <in ana="1621">Professeur de lettres, de philosophie et de théologie, à Parme puis à Bologne</in>. - <en ref="16" >Mathématicien</en> et historien de la géographie [http://data.bnf.fr/ark:/12148/cb12546680q#foaf:Person]
</ud>
<ud>
Pierre Petit (<dat when="1598">1598</dat>) <en ref="16" >Mathématicien</en> et <en ref="1630" >physicien</en>. - Intendant général des ports et fortifications de France (<dat when="1649">1649</dat>) [http://data.bnf.fr/ark:/12148/cb123944733#foaf:Person]
</ud>
<ud>
Adam Olearius (<en type="li">Aschersleben, Allemagne</en>, <dat when="1599">1599</dat>) Voyageur, en particulier en Russie et en Perse. - <en ref="16" >Mathématicien</en> [http://data.bnf.fr/ark:/12148/cb12817277v#foaf:Person]
</ud>
<ud>
Jacob Aertsz Colom (<dat when="1599">1599</dat>) <en ref="16" >Mathématicien</en>, navigateur et <en ref="1636" >cartographe</en>. - <en ref="1632" >Imprimeur</en> à Amsterdam [http://data.bnf.fr/ark:/12148/cb153358650#foaf:Person]
</ud>
<ud>
Adriaan Vlacq (<dat when="1600">1600</dat>) Autre(s) graphie(s) : Ulack ; Vlac. - Variante(s) de prénom : Adriaen ; Adrien. - <en ref="1632" >Imprimeur</en>-<en ref="1631" >libraire</en>. - Originaire de Gouda. Édite différents périodiques dont "De Haegsche Vrijdaeghse Post-Tijdingen". A publié en 1659 une contrefaçon de Johannes Elzevier et de Pieter Leffen. A également publié sous les fausses adresses et pseudonymes de "Cologne, Pierre Du Marteau" et "Amsterdam, Peter Le Grand". - Également <en ref="16" >mathématicien</en> connu pour ses travaux sur les logarithmes et auteur d''ouvrages d''astronomie et de pamphlets en faveur des royalistes anglais en 1652-1655. Mort peu avant le 8 avril 1667. Des éd. paraissent encore sous son nom jusqu''en 1669, en association avec Johannes Vlacq [http://data.bnf.fr/ark:/12148/cb121635061#foaf:Person]
</ud>
<ud>
Antoine de Laloubère (<dat when="1600">1600</dat>) Jésuite. - <en ref="16" >Mathématicien</en> et géomètre, fut le premier scientifique à étudier les propriétés de l''hélice. - Polémiqua avec Pascal, qui l''appelle "Allouerus" dans l''"Histoire de la roulette". - <in ana="1621">Professeur de rhétorique, de théologie et de mathématiques au collège de Toulouse</in>. - Né à Rieux, meurt à Toulouse [http://data.bnf.fr/ark:/12148/cb13006798h#foaf:Person]
</ud>
<ud>
Giacomo Oddi (<dat when="1600">1600</dat>) <en ref="1636" >Cartographe</en> et <en ref="16" >mathématicien</en>. Etudie à Naples [http://data.bnf.fr/ark:/12148/cb153917817#foaf:Person]
</ud>
<ud>
Jakob Bartsch (<dat when="1600">1600</dat>) <en ref="28" >Médecin</en>. - <in ana="1621">Professeur de mathématiques à Strasbourg</in>. - <en ref="24" >Astronome</en>. - Gendre et collaborateur de l''<en ref="24" >astronome</en> Johann Kepler (1571-1630) [http://data.bnf.fr/ark:/12148/cb12163632v#foaf:Person]
</ud>
<ud>
Emmanuel Maignan (<dat when="1601">1601</dat>) Religieux minime. - <en ref="18" >Philosophe</en>, <en ref="16" >mathématicien</en> et peintre. - Membre de la Société des lanternistes [http://data.bnf.fr/ark:/12148/cb130127157#foaf:Person]
</ud>
<ud>
Florimond de Beaune (<dat when="1601">1601</dat>) <en ref="16" >Mathématicien</en> [http://data.bnf.fr/ark:/12148/cb11890827s#foaf:Person]
</ud>
<ud>
Ovidio Montalbani (<dat when="1601">1601</dat>) Docteur en philosophie et <en ref="28" >médecin</en>e de l'' Université de Bologne, professeur de mathématiques, chargé du musée Aldrovandi à partir de 1657, fut aussi un citoyen actif de Bologne, où il assura plusieurs magistratures ("giudice del Foro de mercanti, e de tribuni della plebe"). - Membre de l''Accademia dei Gelati de Bologne ("l''Innestato"), de l''Accademia degli Indomiti de Bologne ("lo Stellato"), et de l''Accademia della Notte de Bologne ("il Rugiadoso") [http://data.bnf.fr/ark:/12148/cb12064289s#foaf:Person]
</ud>
<ud>
Pierre de Fermat (Beaumont-de-Lomagne (Tarn-et-Garonne), <dat when="1601">1601</dat>) <en ref="16" >Mathématicien</en>, célèbre pour son théorème. - On lui doit aussi le Principe de Fermat en optique. - Conseiller au Parlement de Toulouse et commissaire en la chambre des requêtes du Palais à Toulouse (mai 1631) [http://data.bnf.fr/ark:/12148/cb11902568b#foaf:Person]
</ud>
<ud>
Athanasius Kircher (<en type="li">Geisa (Allemagne)</en>, <dat when="1602">1602</dat>) Jésuite. - <in ana="1621">Professeur de physique, de mathématiques et de langues orientales, Collegio Romano, Rome</in>. - Dessinateur et graveur [http://data.bnf.fr/ark:/12148/cb119097824#foaf:Person]
</ud>
<ud>
Gilles Personne de Roberval (<en type="li">Roberval, Oise</en>, <dat when="1602">1602</dat>) Professeur de philosophie (<dat when="1634">1634</dat>) et de mathématiques (<dat when="1655">1655</dat>) au Collège royal, Paris. - Membre fondateur de l''Académie royale des sciences [http://data.bnf.fr/ark:/12148/cb12144923j#foaf:Person]
</ud>
<ud>
Jacques de Billy (<dat when="1602">1602</dat>) Jésuite (à partir de 1619). - <en ref="16" >Mathématicien</en> et <en ref="24" >astronome</en> [http://data.bnf.fr/ark:/12148/cb123773436#foaf:Person]
</ud>
<ud>
John Greaves (<en type="li">Colemore, GB</en>, <dat when="1602">1602</dat>) <en ref="16" >Mathématicien</en>. - Orientaliste. - Professeur d''astronomie à Londres puis à Oxford [http://data.bnf.fr/ark:/12148/cb129277690#foaf:Person]
</ud>
<ud>
Pierre Gautruche (<dat when="1602">1602</dat>) Jésuite. - <in ana="1621">Professeur de philosophie, de théologie et de mathématiques</in>. - Identifié par certains à Pierre Gautier (1599-16..), luthiste et compositeur [http://data.bnf.fr/ark:/12148/cb121990328#foaf:Person]
</ud>
<ud>
Blaise-François de Pagan (<en type="li">Avignon</en>, <dat when="1604">1604</dat>) <en ref="1633" >Ingénieur</en> et <en ref="24" >astronome</en> [http://data.bnf.fr/ark:/12148/cb12155087r#foaf:Person]
</ud>
<ud>
Claude Hardy (<dat when="1604">1604</dat>) Fils de Sébastien Hardy. - Conseiller au Châtelet. - <en ref="16" >Mathématicien</en>. - Ami de Mydorge, Descartes et du Père Mersenne ; souvent cité dans la correspondance de ces deux derniers [http://data.bnf.fr/ark:/12148/cb12134536k#foaf:Person]
</ud>
<ud>
Bernard Frénicle de Bessy (<dat when="1605">1605</dat>) <en ref="16" >Mathématicien</en>, géomètre et arithméticien. - Membre de l''Académie des Sciences. - Conseiller à la Cour des monnaies [http://data.bnf.fr/ark:/12148/cb12459881c#foaf:Person]
</ud>
<ud>
Ismaël Boulliau (<en type="li">Loudun (Vienne)</en>, <dat when="1605">1605</dat>) <en ref="24" >Astronome</en>. - Secrétaire de Jacques Du Puy et attaché au président de Thou [http://data.bnf.fr/ark:/12148/cb124621511#foaf:Person]
</ud>
<ud>
Juan de Caramuel y Lobkowitz (<en type="li">Madrid</en>, <dat when="1606">1606</dat>) Cistercien. - Evêque de Satriano et Campagna (1657-1673) puis de Vigevano (1673-). - Humaniste, <en ref="1629" >théologien</en>, <en ref="16" >mathématicien</en>, <en ref="18" >philosophe</en> et <en ref="1635" >architecte</en>. - Défenseur de la doctrine probabiliste [http://data.bnf.fr/ark:/12148/cb12392566m#foaf:Person]
</ud>
<ud>
Evangelista Torricelli (<en type="li">Faenza, Italie</en>, <dat when="1608">1608</dat>) <en ref="1630" >Physicien</en> et <en ref="16" >mathématicien</en> [http://data.bnf.fr/ark:/12148/cb12117674q#foaf:Person]
</ud>
<ud>
Gaspar Schott (<en type="li">Königshaufen, Allemagne</en>, <dat when="1608">1608</dat>) <en ref="16" >Mathématicien</en> et <en ref="1630" >physicien</en>. - Jésuite [http://data.bnf.fr/ark:/12148/cb12519717b#foaf:Person]
</ud>
<ud>
Giovanni Alfonso Borelli (<en type="li">Naples, Italie</en>, <dat when="1608">1608</dat>) <en ref="16" >Mathématicien</en>, phycisien, <en ref="28" >médecin</en>, <en ref="18" >philosophe</en>. - Membre de l''Accademia del Cimento [http://data.bnf.fr/ark:/12148/cb12462534j#foaf:Person]
</ud>
<ud>
Giovan Battista Nicolosi (<en type="li">Paternò, Italie</en>, <dat when="1610">1610</dat>) <en ref="29" >Géographe</en> et <en ref="1636" >cartographe</en>. - Professeur de mathématiques et de géographie à l''Université de Rome [http://data.bnf.fr/ark:/12148/cb15404103t#foaf:Person]
</ud>
<ud>
Józef Naronowicz-Naroński (<dat when="1610">1610</dat>) <en ref="16" >Mathématicien</en>. - <en ref="1636" >Cartographe</en>. - <en ref="1635" >Architecte</en> au service de la famille Radzwill. - Né en Lituanie [http://data.bnf.fr/ark:/12148/cb150812338#foaf:Person]
</ud>
<ud>
Maria Cunitia (<dat when="1610">1610</dat>) <en ref="24" >Astronome</en> [http://data.bnf.fr/ark:/12148/cb162514419#foaf:Person]
</ud>
<ud>
Jan Heweliusz (<dat when="1611">1611</dat>) <en ref="24" >Astronome</en> [http://data.bnf.fr/ark:/12148/cb121054498#foaf:Person]
</ud>
<ud>
John Pell (<dat when="1611">1611</dat>) <en ref="16" >Mathématicien</en> [http://data.bnf.fr/ark:/12148/cb146515879#foaf:Person]
</ud>
<ud>
Michael Floris Van Langren (<dat when="1612">1612</dat>) <en ref="24" >Astronome</en> et <en ref="16" >mathématicien</en> du roi d''Espagne installé à Bruxelles [http://data.bnf.fr/ark:/12148/cb153283774#foaf:Person]
</ud>
<ud>
Francesco Maria Grimaldi (<dat when="1613">1613</dat>) Jésuite. - <en ref="18" >Philosophe</en>, <en ref="24" >astronome</en>, opticien et <in ana="1621">professeur de mathématiques</in>. - Né et mort à Bologne [http://data.bnf.fr/ark:/12148/cb13326913s#foaf:Person]
</ud>
<ud>
François Chauveau (<dat when="1613">1613</dat>) Grava des cartouches notamment pour Nicolas Sanson. Eut un neveu du nom de François Chauveau. Son frère, Jean-Baptiste, habile <en ref="1633" >ingénieur</en> et <en ref="16" >mathématicien</en> fut assassiné en 1670. [http://data.bnf.fr/ark:/12148/cb15302394v#foaf:Person]
</ud>
<ud>
Jean François Nicéron (<en type="li">Paris</en>, <dat when="1613">1613</dat>) Religieux de l''Ordre des minimes. - <en ref="16" >Mathématicien</en> [http://data.bnf.fr/ark:/12148/cb14404933t#foaf:Person]
</ud>
<ud>
Tommaso Cornelio (<en type="li">Rovito, Italie</en>, <dat when="1614">1614</dat>) <en ref="28" >Médecin</en>, <en ref="18" >philosophe</en> et <en ref="16" >mathématicien</en> [http://data.bnf.fr/ark:/12148/cb13484167f#foaf:Person]
</ud>
<ud>
Frans Van Schooten (<dat when="1615">1615</dat>) <en ref="16" >Mathématicien</en> [http://data.bnf.fr/ark:/12148/cb12529949q#foaf:Person]
</ud>
<ud>
John Wallis (<dat when="1616">1616</dat>) <en ref="16" >Mathématicien</en> [http://data.bnf.fr/ark:/12148/cb123396143#foaf:Person]
</ud>
<ud>
Jonas Moore (<dat when="1617">1617</dat>) <en ref="16" >Mathématicien</en> britannique. - S''est intéressé aux mathématiques appliquées (astronomie, cosmographie, architecture...) [http://data.bnf.fr/ark:/12148/cb135104102#foaf:Person]
</ud>
<ud>
Tito Livio Burattini (<en type="li">Agordo, Italie</en>, <dat when="1617">1617</dat>) <en ref="16" >Mathématicien</en>, <en ref="1636" >cartographe</en> et égyptologue [http://data.bnf.fr/ark:/12148/cb162142362#foaf:Person]
</ud>
<ud>
Anthelme (Chatenay-Vaudin (Haute-Marne), <dat when="1618">1618</dat>) Religieux de la Chartreuse de Dijon. - <en ref="24" >Astronome</en> [http://data.bnf.fr/ark:/12148/cb106267229#foaf:Person]
</ud>
<ud>
Charles Cavendish (<dat when="1620">1620</dat>) <en ref="16" >Mathématicien</en> [http://data.bnf.fr/ark:/12148/cb14651592w#foaf:Person]
</ud>
<ud>
Jean Picard (<en type="li">La Flèche (Sarthe)</en>, <dat when="1620">1620</dat>) <en ref="24" >Astronome</en>. - Membre de l''Académie des sciences (<dat when="1666">1666</dat>) [http://data.bnf.fr/ark:/12148/cb11941359d#foaf:Person]
</ud>
<ud>
Claude-François Milliet de Chales (<dat when="1621">1621</dat>) <en ref="16" >Mathématicien</en>. - Professeur d''hydrographie à Marseille [http://data.bnf.fr/ark:/12148/cb12397222c#foaf:Person]
</ud>
<ud>
Adrien Auzout (<en type="li">Rouen</en>, <dat when="1622">1622</dat>) <en ref="24" >Astronome</en>, <en ref="1630" >physicien</en> et <en ref="16" >mathématicien</en>. - A contribué au développement du micromètre [http://data.bnf.fr/ark:/12148/cb134752474#foaf:Person]
</ud>
<ud>
Jean Bertet (<dat when="1622">1622</dat>) Jésuite, quitte la Compagnie en 1681 pour entrer chez les Bénédictins. - <in ana="1621">Professeur de rhétorique, philosophie et mathématiques</in>. - Poète [http://data.bnf.fr/ark:/12148/cb11999230c#foaf:Person]
</ud>
<ud>
René-François De Sluse (<dat when="1622">1622</dat>) <en ref="16" >Mathématicien</en>. - Chanoine de la Cathédrale de Liège et abbé d''Amay [http://data.bnf.fr/ark:/12148/cb12427294z#foaf:Person]
</ud>
<ud>
Vincenzo Viviani (<en type="li">Florence, Italie</en>, <dat when="1622">1622</dat>) Florentin. - <en ref="16" >Mathématicien</en>. - Membre de l'' "accademia della Crusca" [http://data.bnf.fr/ark:/12148/cb12000373g#foaf:Person]
</ud>
<ud>
Blaise Pascal (Clermont-Ferrand (Puy-de-Dôme), <dat when="1623">1623</dat>) <en ref="16" >Mathématicien</en>, <en ref="1630" >physicien</en>, écrivain. - Frère de : Pascal, Jacqueline (1625-1661) [http://data.bnf.fr/ark:/12148/cb11918679x#foaf:Person]
</ud>
<ud>
Ferdinand Verbiest (<en type="li">Pitthem, Belgique</en>, <dat when="1623">1623</dat>) Jésuite, missionnaire en Chine. - <en ref="24" >Astronome</en>. - Fut placé à la tête du tribunal des mathématiques, chargé de la rédaction des éphémérides et de la direction des fonderies de canons. - A publié en langue chinoise, sous le nom de Nanhoai-jin, un grand nombre d''ouvrages scientifiques [http://data.bnf.fr/ark:/12148/cb12215344n#foaf:Person]
</ud>
<ud>
Camillo Guarino Guarini (<en type="li">Modène, Italie</en>, <dat when="1624">1624</dat>) Clerc régulier, théatin. - <en ref="1635" >Architecte</en> du duc de Savoie, <en ref="18" >philosophe</en> et <en ref="16" >mathématicien</en> [http://data.bnf.fr/ark:/12148/cb12348027r#foaf:Person]
</ud>
<ud>
Christoph Wittich (<dat when="1625">1625</dat>) <en ref="1629" >Théologien</en>. - <in ana="1621">Professeur de mathématiques et de théologie</in> [http://data.bnf.fr/ark:/12148/cb13014027s#foaf:Person]
</ud>
<ud>
Erhard Weigel (<dat when="1625">1625</dat>) <en ref="18" >Philosophe</en>. - <in ana="1621">Professeur de mathématiques, maître de Leibniz et de Pufendorf</in> [http://data.bnf.fr/ark:/12148/cb11935908x#foaf:Person]
</ud>
<ud>
Jean-Dominique Cassini (<en type="li">Perinaldo (comté de Nice)</en>, <dat when="1625">1625</dat>) Titulaire de la chaire d''astronomie de Bologne de 1650 à 1669, surintendant des eaux du Bolonais de 1657 à 1669, surintendant des eaux de l''Etat pontifical et titulaire d''autres charges auprès du pape. - Appelé en France an avril 1669 par Louis XIV. - Membre de l''Académie des sciences, directeur de l''Observatoire de Paris (à partir de 1672). - Naturalisé français en 1673 [http://data.bnf.fr/ark:/12148/cb121019904#foaf:Person]
</ud>
<ud>
Johan de Witt (Dordrecht, Pays-Bas, <dat when="1625">1625</dat>) Homme d''état et <en ref="16" >mathématicien</en>. - Grand pensionnaire de Hollande [http://data.bnf.fr/ark:/12148/cb13598046j#foaf:Person]
</ud>
<ud>
Johann Hecker (<en type="li">Gdansk (Pologne)</en>, <dat when="1625">1625</dat>) <en ref="24" >Astronome</en> [http://data.bnf.fr/ark:/12148/cb12875545t#foaf:Person]
</ud>
<ud>
Rasmus Bartholin (<en type="li">Roskilde, Danemark</en>, <dat when="1625">1625</dat>) <en ref="1630" >Physicien</en>. - <en ref="16" >Mathématicien</en>. - <en ref="28" >Médecin</en>. - Professeur de mathématiques et de <en ref="28" >médecin</en>e à Copenhague. - A découvert la difraction de la lumière. - Fils de Kaspar Bartholin [http://data.bnf.fr/ark:/12148/cb11890430k#foaf:Person]
</ud>
<ud>
Samuel Morland (<dat when="1625">1625</dat>) <en ref="16" >Mathématicien</en> et inventeur [http://data.bnf.fr/ark:/12148/cb10365749d#foaf:Person]
</ud>
<ud>
Pietro Mengoli (<en type="li">Bologne (Italie)</en>, <dat when="1626">1626</dat>) <en ref="16" >Mathématicien</en>. - Professeur de mécanique (1650-1678) puis titulaire de la chaire de mathématiques et d''astronomie (1678-1686) à l''université de Bologne [http://data.bnf.fr/ark:/12148/cb120851477#foaf:Person]
</ud>
<ud>
John Ray (<en type="li">Black Notley (Essex)</en>, <dat when="1627">1627</dat>) <in ana="1621">Professeur de mathématiques et de lettres</in>. - Naturaliste. - Botaniste. - Membre de la Société royale de Londres [http://data.bnf.fr/ark:/12148/cb12220184b#foaf:Person]
</ud>
<ud>
Heinrich Scherer (<dat when="1628">1628</dat>) Jésuite, <en ref="29" >géographe</en> et <in ana="1621">professeur de mathématiques à Munich</in> [http://data.bnf.fr/ark:/12148/cb15317471w#foaf:Person]
</ud>
<ud>
Johannes Hudde (<dat when="1628">1628</dat>) <en ref="16" >Mathématicien</en>, élève de Frans Van Schooten. - Bourgmestre de la ville d''Amsterdam [http://data.bnf.fr/ark:/12148/cb13488288n#foaf:Person]
</ud>
<ud>
Christiaan Huygens (<dat when="1629">1629</dat>) <en ref="16" >Mathématicien</en> et <en ref="24" >astronome</en>. - A vécu aux Pays-Bas et en France. - Élu membre de la "Royal society" de Londres (en 1663) [http://data.bnf.fr/ark:/12148/cb12192922r#foaf:Person]
</ud>
<ud>
Allain Manesson-Mallet (<en type="li">Paris (France)</en>, <dat when="1630">1630</dat>) <en ref="1633" >Ingénieur</en> et <en ref="1636" >cartographe</en>. - Maître de mathématiques des pages du roi de France, sergent-major d''artillerie du roi de Portugal [http://data.bnf.fr/ark:/12148/cb153363577#foaf:Person]
</ud>
<ud>
Isaac Barrow (<dat when="1630">1630</dat>) <en ref="16" >Mathématicien</en> et <en ref="1629" >théologien</en> [http://data.bnf.fr/ark:/12148/cb12340135q#foaf:Person]
</ud>
<ud>
Jean Richer (<dat when="1630">1630</dat>) <en ref="24" >Astronome</en> à l''Observatoire de Paris, il figure parmi les premiers membres de l''Académie des sciences (<dat when="1666">1666</dat>). - Chargé d''une mission géodésique à Cayenne (1672-73) [http://data.bnf.fr/ark:/12148/cb14064426q#foaf:Person]
</ud>
<ud>
Adam Adamady Kochánski (<dat when="1631">1631</dat>) <en ref="16" >Mathématicien</en> polonais, auteur de la rectification approchée de la circonférence. Réside en 1677 à Wroclaw [http://data.bnf.fr/ark:/12148/cb16187484g#foaf:Person]
</ud>
<ud>
Francesco Lana Terzi (<en type="li">Brescia, Italie</en>, <dat when="1631">1631</dat>) Jésuite. - <en ref="16" >Mathématicien</en>, naturaliste. - Pionnier de l''aéronautique [http://data.bnf.fr/ark:/12148/cb10681783j#foaf:Person]
</ud>
<ud>
Christopher Wren (<en type="li">East Knoyle, Wiltshire, GB</en>, <dat when="1632">1632</dat>) <en ref="1635" >Architecte</en>. - <en ref="16" >Mathématicien</en> et <en ref="24" >astronome</en>, Sir Christopher Wren fut l''un des membres fondateurs de la Société royale des sciences [http://data.bnf.fr/ark:/12148/cb121401670#foaf:Person]
</ud>
<ud>
Alessandro Marchetti (<en type="li">Empoli, Italie</en>, <dat when="1633">1633</dat>) Poète naturaliste, l''un des principaux animateurs du courant naturaliste toscan de la seconde moitié du XVIIe siècle. - Professeur de philosophie puis de mathématiques à l''Université de Pise [http://data.bnf.fr/ark:/12148/cb12570345j#foaf:Person]
</ud>
<ud>
Donato Rossetti (<en type="li">Livourne, Italie</en>, <dat when="1633">1633</dat>) <en ref="16" >Mathématicien</en>. - Professeur de philosophie au "Studio" de Pise [http://data.bnf.fr/ark:/12148/cb144820894#foaf:Person]
</ud>
<ud>
Geminiano Montanari (<en type="li">Modène, Italie</en>, <dat when="1633">1633</dat>) Docteur en droit, <en ref="16" >mathématicien</en> et <en ref="24" >astronome</en>. - Enseigne à Florence, Modène (1661-1664), Bologne (chaire de mathématiques, 1664-1677) et Padoue (chaire d''astronomie, 1678-1687). - Membre de l''Accademia dei Gelati ("l''Elevato") et de l''Accademia della Treccia de Bologne [http://data.bnf.fr/ark:/12148/cb12309300z#foaf:Person]
</ud>
<ud>
Gerhard Wolter Molanus (<dat when="1633">1633</dat>) <en ref="1629" >Théologien</en> luthérien. - <en ref="16" >Mathématicien</en> [http://data.bnf.fr/ark:/12148/cb12133744h#foaf:Person]
</ud>
<ud>
Giovanni Giustino Ciampini (<en type="li">Rome</en>, <dat when="1633">1633</dat>) Historien, archéologue, <en ref="16" >mathématicien</en>. - Membre de la Curie pontificale [http://data.bnf.fr/ark:/12148/cb14323561z#foaf:Person]
</ud>
<ud>
Vitale Giordano (<dat when="1633">1633</dat>) <en ref="16" >Mathématicien</en> [http://data.bnf.fr/ark:/12148/cb15520924m#foaf:Person]
</ud>
<ud>
Johann Christoph Sturm (<en type="li">Hilpolstein, Allemagne</en>, <dat when="1635">1635</dat>) <en ref="18" >Philosophe</en>, <en ref="16" >mathématicien</en> et <en ref="1630" >physicien</en>. - Professeur à l''université d''Altdorf [http://data.bnf.fr/ark:/12148/cb133240234#foaf:Person]
</ud>
<ud>
Ignace-Gaston Pardies (<dat when="1636">1636</dat>) <en ref="16" >Mathématicien</en>. - Jésuite. - Il a enseigné la philosophie puis les mathématiques au collège Louis-Le-Grand [http://data.bnf.fr/ark:/12148/cb12174258w#foaf:Person]
</ud>
<ud>
Elias van Lennep (Borculo, Pays-Bas, <dat when="1637">1637</dat>) Graveur. - <en ref="1633" >Ingénieur</en> et <en ref="16" >mathématicien</en> [http://data.bnf.fr/ark:/12148/cb15053499m#foaf:Person]
</ud>
<ud>
Julius Reichelt (<dat when="1637">1637</dat>) <en ref="16" >Mathématicien</en> strasbourgeois [http://data.bnf.fr/ark:/12148/cb15377331m#foaf:Person]
</ud>
<ud>
François Barrême (<en type="li">Tarascon, France</en>, <dat when="1638">1638</dat>) <en ref="16" >Mathématicien</en> et financier [http://data.bnf.fr/ark:/12148/cb118903320#foaf:Person]
</ud>
<ud>
Georg Christoph Eimmart (<en type="li">Ratisbonne (Allemagne)</en>, <dat when="1638">1638</dat>) Peintre d''histoire, portraitiste, graveur, <en ref="16" >mathématicien</en> et <en ref="24" >astronome</en>. - Fils et élève du peintre Georg-Christoph Eimmart (1603-1658), dit le vieux [http://data.bnf.fr/ark:/12148/cb12983761h#foaf:Person]
</ud>
<ud>
James Gregory (<dat when="1638">1638</dat>) <en ref="16" >Mathématicien</en> et opticien écossais [http://data.bnf.fr/ark:/12148/cb12459917j#foaf:Person]
</ud>
<ud>
Jean Bonfa (<en type="li">Nîmes</en>, <dat when="1638">1638</dat>) Est admis à la Société de Jésus en 1654. - Dans les années 1670 jusqu''en 1683, il enseigne les mathématiques et la théologie aux collèges jésuites de Grenoble, puis d''Avignon. - De 1680 à 1682, enseigne la géométrie et l''hydrographie. - Effectue des travaux astronomiques. - Devient membre correspondant de l''Académie royale des sciences (en 1699) [http://data.bnf.fr/ark:/12148/cb15130186g#foaf:Person]
</ud>
<ud>
Jacques Ozanam (Sainte-Olive (<en type="li">Ain)</en>, <dat when="1640">1640</dat>) <en ref="16" >Mathématicien</en>. - <in ana="1621">Professeur de mathématiques à Paris et à Lyon</in> [http://data.bnf.fr/ark:/12148/cb120960958#foaf:Person]
</ud>
<ud>
Philippe de La Hire (<en type="li">Paris (France)</en>, <dat when="1640">1640</dat>) <en ref="16" >Mathématicien</en>. - Géomètre et <en ref="24" >astronome</en>. - <in ana="1621">Professeur de mathématiques au Collège de France</in>. - Membre de l''Académie des sciences (<dat when="1678">1678</dat>) [http://data.bnf.fr/ark:/12148/cb121592847#foaf:Person]
</ud>
<ud>
Pierre Ango (<dat when="1640">1640</dat>) Jésuite. - Enseigna les humanités, les mathématiques et la philosophie. - Né à Rouen, mort à La Flèche [http://data.bnf.fr/ark:/12148/cb12512101m#foaf:Person]
</ud>
<ud>
Denis Papin (<dat when="1642">1642</dat>) <en ref="1630" >Physicien</en>. - Un des précurseurs de l''invention de la machine à vapeur, qui eu l''idée du piston (dés 1690), et inspira la machine que l''Anglais Thomas Newcomen (1664-1729), mis au point ensuite (en 1712). - Quitta définitivement la France, après la révocation de l''Édit de Nantes (<dat when="1685">1685</dat>). - Occupa une chaire de mathématiques à l''Université de Marburg, Allemagne (<dat when="1687">1687</dat>). - Rédige un article (Ars nova ad aquam ignis...) présentant sa machine dans la revue " Acta Eruditorum", Leipzig (en 1707), revue célèbre pour les publications de Leibniz (1646-1716), sur le calcul différentiel et intégral [http://data.bnf.fr/ark:/12148/cb12087889k#foaf:Person]
</ud>
<ud>
Isaac Newton (Woolsthorpe, Lincolnshire (<en type="li">GB)</en>, <dat when="1642">1642</dat>) <en ref="1630" >Physicien</en>, <en ref="16" >mathématicien</en> et <en ref="24" >astronome</en> [http://data.bnf.fr/ark:/12148/cb119176085#foaf:Person]
</ud>
<ud>
Johann Welper (<dat when="1642">1642</dat>) Variante(s) de prénom : Johannes ; Jean. - <en ref="1632" >Imprimeur</en>-<en ref="1631" >libraire</en>. - Fils et apprenti d''Eberhard Welper, <en ref="1632" >imprimeur</en>-<en ref="1631" >libraire</en> et <en ref="16" >mathématicien</en> à Strasbourg. A été compagnon pendant 6 ans à Ulm, Augsbourg, Munich, Vienne, Leipzig et Nuremberg, avant de succéder à son père. L''enquête de 1700-1701 le dit âgé de 60 ans et "établi à Strasbourg depuis 42 ans". À sa mort, son entreprise est rachetée par Melchior Pauschinger [http://data.bnf.fr/ark:/12148/cb160636269#foaf:Person]
</ud>
<ud>
Michel Mourgues (<dat when="1642">1642</dat>) Jésuite. - Enseigna la rhétorique et les mathématiques à l''Université de Toulouse [http://data.bnf.fr/ark:/12148/cb124637183#foaf:Person]
</ud>
<ud>
Takakazu Seki (<dat when="1642">1642</dat>) <en ref="16" >Mathématicien</en> japonais [http://data.bnf.fr/ark:/12148/cb12443516f#foaf:Person]
</ud>
<ud>
Jean Jombert (<dat when="1643">1643</dat>) <en ref="1631" >Libraire</en>. - Fils d''un fruitier et marchand de vins parisien. En apprentissage chez le <en ref="1631" >libraire</en> parisien Pierre II Baudouin à partir de janv. 1666, il travaille en 1670-1671 chez Louis Billaine et Pierre Le Petit, puis chez la veuve de Pierre I Baudouin à partir de 1672. Gendre en 1res noces (<dat when="1671">1671</dat>) du <en ref="1631" >libraire</en> Jean d''Houry. Publie sous son propre nom dès 1680, peut-être dès 1678, mais n''est reçu maître que le 17 sept. 1686. Publie de nombreux ouvrages de mathématiques. Dit âgé d''env. 60 ans lors de l''enquête de nov.-déc. 1701. Testaments le 9 août 1704 et le 6 oct. 1705. Décédé au début de nov. 1705. Sa veuve lui succède [http://data.bnf.fr/ark:/12148/cb15074749j#foaf:Person]
</ud>
<ud>
Antoine Thomas (<en type="li">Namur</en>, <dat when="1644">1644</dat>) Jésuite (à partir de 1660). - <en ref="16" >Mathématicien</en> et <en ref="24" >astronome</en> de l''empereur de Chine [http://data.bnf.fr/ark:/12148/cb10636254r#foaf:Person]
</ud>
<ud>
Johann Jakob Zimmermann (<en type="li">Vaihingen an der Enz, Allemagne</en>, <dat when="1644">1644</dat>) <en ref="1629" >Théologien</en>, <en ref="16" >mathématicien</en> et <en ref="24" >astronome</en> [http://data.bnf.fr/ark:/12148/cb10721479d#foaf:Person]
</ud>
<ud>
Ole Rømer (<en type="li">Åarhus, Danemark</en>, <dat when="1644">1644</dat>) <en ref="24" >Astronome</en> [http://data.bnf.fr/ark:/12148/cb12324191r#foaf:Person]
</ud>
<ud>
Carlos de Sigüenza y Góngora (<en type="li">Mexico</en>, <dat when="1645">1645</dat>) <en ref="24" >Astronome</en>, <en ref="16" >mathématicien</en>, poète, historien. - Sa bibliothèque, comprenant des documents uniques sur l''histoire du Mexique, disparut dans un incendie lors de l''insurrection de 1692 [http://data.bnf.fr/ark:/12148/cb121021638#foaf:Person]
</ud>
<ud>
Eusebio Francisco Kino (<en type="li">Taio, Italie</en>, <dat when="1645">1645</dat>) <en ref="16" >Mathématicien</en> et <en ref="29" >géographe</en> de formation. - Jésuite, arrive au Mexique en 1681 [http://data.bnf.fr/ark:/12148/cb122190783#foaf:Person]
</ud>
<ud>
Maximilian Rassler (<en type="li">Waldsee (Allemagne)</en>, <dat when="1645">1645</dat>) Jésuite. - <in ana="1621">Professeur de réthorique, de mathématiques, philosophie et contreverse</in>. - Recteur et chancelier de l''Université de Dillingen, Allemagne [http://data.bnf.fr/ark:/12148/cb158132748#foaf:Person]
</ud>
<ud>
Elena Lucrezia Cornaro Piscopia (<en type="li">Venise (Italie)</en>, <dat when="1646">1646</dat>) <en ref="18" >Philosophe</en> et <en ref="16" >mathématicien</en>ne. - Première femme docteur en philosophie [http://data.bnf.fr/ark:/12148/cb16591183r#foaf:Person]
</ud>
<ud>
Francesco Maria Pompeo Colonna (<en type="li">Rome</en>, <dat when="1646">1646</dat>) <en ref="16" >Mathématicien</en>, <en ref="1630" >physicien</en> et occultiste. - Vécut à Paris à partir de 1668 [http://data.bnf.fr/ark:/12148/cb118973978#foaf:Person]
</ud>
<ud>
Harald Vallerius (<dat when="1646">1646</dat>) Professeur universitaire de mathématiques [http://data.bnf.fr/ark:/12148/cb16032560b#foaf:Person]
</ud>
<ud>
John Flamsteed (<dat when="1646">1646</dat>) <en ref="24" >Astronome</en>. - Fut le premier directeur de l''Observatoire de Greenwich, GB, fondé en 1675 [http://data.bnf.fr/ark:/12148/cb13524243n#foaf:Person]
</ud>
<ud>
John Flamsteed (<dat when="1646">1646</dat>) <en ref="24" >Astronome</en> britannique. Fut le premier directeur de l''observatoire de Greenwich, fondé en 1675 [http://data.bnf.fr/ark:/12148/cb13510391m#foaf:Person]
</ud>
<ud>
Niccolò Partenio Giannettasio (<dat when="1648">1648</dat>) Jésuite. - Historien et poète. - Professeur de mathématiques et d''hébreu au Collège des Jésuites de Naples. - Né à Naples, meurt à Massa [http://data.bnf.fr/ark:/12148/cb133256727#foaf:Person]
</ud>
<ud>
Tommaso Ceva (<dat when="1648">1648</dat>) Jésuite. - <en ref="18" >Philosophe</en>, <en ref="24" >astronome</en>, <en ref="1630" >physicien</en> et poète. - Membre de l''Académie de l''Arcadie sous le pseudonyme : Callimaco Neridio [http://data.bnf.fr/ark:/12148/cb13321850h#foaf:Person]
</ud>
<ud>
Jean Le Febvre (<en type="li">Lisieux (Calvados)</en>, <dat when="1650">1650</dat>) Tisserand, puis <en ref="24" >astronome</en>. - Membre de l''Académie des sciences de 1682 à 1702 [http://data.bnf.fr/ark:/12148/cb16176897g#foaf:Person]
</ud>
<ud>
Michelangelo Fardella (<dat when="1650">1650</dat>) Franciscain. - <en ref="18" >Philosophe</en>, <en ref="24" >astronome</en> et <en ref="16" >mathématicien</en>. - Professeur de philosophie, de théologie, de mathématiques, professeur d''astronomie et de physique à l''Université de Padoue (1694-). - Né à Trapani, meurt à Naples [http://data.bnf.fr/ark:/12148/cb12093422f#foaf:Person]
</ud>
<ud>
Andreas Cellarius (<dat when="1651">1651</dat>) <en ref="16" >Mathématicien</en> et <en ref="29" >géographe</en> hollandais actif de 1656 à 1702. En 1660 il est recteur de l''Ecole latine de Hoorn [http://data.bnf.fr/ark:/12148/cb15338282n#foaf:Person]
</ud>
<ud>
Antoine-François Payen (<en type="li">Avignon</en>, <dat when="1651">1651</dat>) Jurisconsulte et <en ref="24" >astronome</en>. - Enseigna la jurisprudence civile dès 1642 à Avignon [http://data.bnf.fr/ark:/12148/cb144713316#foaf:Person]
</ud>
<ud>
Arent Roggeveen (<dat when="1651">1651</dat>) <en ref="16" >Mathématicien</en>, navigateur et hydrographe [http://data.bnf.fr/ark:/12148/cb153879695#foaf:Person]
</ud>
<ud>
Bingzhen Jiao (<dat when="1651">1651</dat>) Peintre et <en ref="16" >mathématicien</en> à la cour de l''empereur Kangxi [http://data.bnf.fr/ark:/12148/cb14546684c#foaf:Person]
</ud>
<ud>
Caspar Dauthendey (<dat when="1651">1651</dat>) <en ref="1635" >Architecte</en> et <en ref="16" >mathématicien</en> [http://data.bnf.fr/ark:/12148/cb153778194#foaf:Person]
</ud>
<ud>
Claude Bonjour (<dat when="1651">1651</dat>) Augustin du couvent de Pontarlier. <en ref="29" >Géographe</en> et <en ref="16" >mathématicien</en> [http://data.bnf.fr/ark:/12148/cb15294805z#foaf:Person]
</ud>
<ud>
Claude Comiers (<dat when="1651">1651</dat>) <en ref="1629" >Théologien</en> et <en ref="16" >mathématicien</en>, né à Embrun. Chanoine d''Embrun, <en ref="1633" >ingénieur</en> des armées, puis prévôt de l''église collégiale de Ternant, professeur de mathématiques à Paris ; protonotaire apostolique et officier du Saint-Office. - Il a laissé des livres et des articles sur des sujets variés : géométrie, astronomie, <en ref="28" >médecin</en>e, occultisme, physique... [http://data.bnf.fr/ark:/12148/cb12250531g#foaf:Person]
</ud>
<ud>
Claude Irson (<dat when="1651">1651</dat>) <en ref="16" >Mathématicien</en> et grammairien. - A été teneur de comptes vers 1678 [http://data.bnf.fr/ark:/12148/cb125155096#foaf:Person]
</ud>
<ud>
de La Roche (<dat when="1651">1651</dat>) <en ref="16" >Mathématicien</en> [http://data.bnf.fr/ark:/12148/cb13009642b#foaf:Person]
</ud>
<ud>
Ehrenfried Walter von Tschirnhaus (<en type="li">Kieslingswalde, Allemagne</en>, <dat when="1651">1651</dat>) <en ref="18" >Philosophe</en>, <en ref="16" >mathématicien</en> et biologiste. - Industriel, considéré comme l''inventeur de la porcellaine blanche en Europe [http://data.bnf.fr/ark:/12148/cb12515471b#foaf:Person]
</ud>
<ud>
Federico Gualdi (<dat when="1651">1651</dat>) Alchimiste, <en ref="24" >astronome</en>, <en ref="16" >mathématicien</en>. - <en ref="18" >Philosophe</en> hermétique. - Membre de la Rose-croix d''Or. - Serait d''origine allemande ou italienne [http://data.bnf.fr/ark:/12148/cb150904929#foaf:Person]
</ud>
<ud>
Francesco Levera (<en type="li">Savoie</en>, <dat when="1651">1651</dat>) <en ref="18" >Philosophe</en>, <en ref="24" >astronome</en> et <en ref="1629" >théologien</en> [http://data.bnf.fr/ark:/12148/cb10442558v#foaf:Person]
</ud>
<ud>
François Chevalier (Sainte-Maur, <dat when="1651">1651</dat>) Elève de l''abbé Galloys. Associé géomètre à l''Académie des sciences en 1707. Pensionnaire mécanicien en 1725. <in ana="1621">Professeur de mathématiques au Collège de France</in>. Maître de mathématiques du roi et des pages de la Petite Ecurie. Présenta en 1707 à l''Académie une méthode de collecte des informations cartographiques sur des châssis concentriques [http://data.bnf.fr/ark:/12148/cb153045899#foaf:Person]
</ud>
<ud>
François Noël (Hestrud, Pays-Bas Méridionaux, <dat when="1651">1651</dat>) Jésuite (à partir de 1670) ordonné prêtre en 1682. - Missionnaire en Chine, il fut envoyé à Rome à l''occasion de la querelle des rites, et ne put rentrer en Chinê. - Il enseigna ensuite à Prague. - Auteur de poésies et de théâtre, d''un traité d''astronomie, de traductions et d''un ouvrage catéchétique en chinois [http://data.bnf.fr/ark:/12148/cb16653645d#foaf:Person]
</ud>
<ud>
Guisnée (<dat when="1651">1651</dat>) <en ref="16" >Mathématicien</en>. - Membre de l''Académie royale des sciences [http://data.bnf.fr/ark:/12148/cb14618149h#foaf:Person]
</ud>
<ud>
Jacques Mengau (<dat when="1651">1651</dat>) <in ana="1621">Professeur de mathématiques</in>. - Auteur de mazarinades. - Actif de 1648 à 1652 [http://data.bnf.fr/ark:/12148/cb12166762s#foaf:Person]
</ud>
<ud>
Jean Bachou (<dat when="1651">1651</dat>) <en ref="16" >Mathématicien</en> et alchimiste lyonnais. - Avocat au parlement [http://data.bnf.fr/ark:/12148/cb12158814g#foaf:Person]
</ud>
<ud>
Jean Glover (<dat when="1651">1651</dat>) <en ref="1633" >Ingénieur</en> et <en ref="16" >mathématicien</en> originaire d''Écosse et établi en France. - Auteur notamment de plusieurs propositions de loteries et d''une "Nouvelle Manière d''exécuter les loteries..." (<en type="li">Paris</en>, <dat when="1705">1705</dat>). - Se qualifie d''"esquire, seigneur de Glaideny et de la baronnie de Baltillée en Ecosse" [http://data.bnf.fr/ark:/12148/cb15818830h#foaf:Person]
</ud>
<ud>
Jean-Baptiste Delure (<dat when="1651">1651</dat>) Éditeur d''estampes et de cartes géographiques. - <en ref="1633" >Ingénieur</en> pour les instruments de mathématiques et fabricant de cartes et de globes ; éditeur occasionnel [http://data.bnf.fr/ark:/12148/cb153164066#foaf:Person]
</ud>
<ud>
Joachim d'' Alencé (<dat when="1651">1651</dat>) <en ref="24" >Astronome</en> et <en ref="1630" >physicien</en> [http://data.bnf.fr/ark:/12148/cb12397878n#foaf:Person]
</ud>
<ud>
Joanne Westenburg (<dat when="1651">1651</dat>) <en ref="1636" >Cartographe</en>, <en ref="28" >médecin</en> et <en ref="16" >mathématicien</en> [http://data.bnf.fr/ark:/12148/cb15377993t#foaf:Person]
</ud>
<ud>
Johann Andreas Planer (<en type="li">Strelen, Allemagne</en>, <dat when="1651">1651</dat>) <en ref="16" >Mathématicien</en>. - Professeur de mathématiques à l''Université de Wittenberg [http://data.bnf.fr/ark:/12148/cb16672375p#foaf:Person]
</ud>
<ud>
Le Blanc (<dat when="1651">1651</dat>) Professeur de mathématiques (<dat when="1692">1692</dat>). - Réside rue de Seine à Paris en 1692 [http://data.bnf.fr/ark:/12148/cb16650697x#foaf:Person]
</ud>
<ud>
Le Demaine Godalles (<dat when="1651">1651</dat>) Hydrographe, <en ref="1633" >Ingénieur</en> du roi et <in ana="1621">professeur de Mathématiques, <en ref="1635" >Architecte</en></in> [http://data.bnf.fr/ark:/12148/cb15375819n#foaf:Person]
</ud>
<ud>
Philip Lea (<dat when="1651">1651</dat>) <en ref="1636" >Cartographe</en>, fabricant et éditeur de globes, de cartes, d''instruments de mathématiques, actif de 1666 à 1700 à Londres [http://data.bnf.fr/ark:/12148/cb15328427v#foaf:Person]
</ud>
<ud>
René Gaultier de Maignannes (<dat when="1651">1651</dat>) <en ref="16" >Mathématicien</en> angevin. - Spécialiste de la perspective [http://data.bnf.fr/ark:/12148/cb12536157m#foaf:Person]
</ud>
<ud>
David François de Merveilleux (<dat when="1652">1652</dat>) <en ref="29" >Géographe</en> et <en ref="1636" >cartographe</en>. Connaissances mathématiques étendues (il publie un traîté d''arithmétique et de géométrie). En 1695 il entre au service de Guillaume III qui lui accorde le brev